/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/***************************************************************************
 *            e-kolab-plugin-util.c
 *
 *  Sat Jun 02 15:28:05 2012
 *  Copyright  2012  Christian Hilberg
 *  <hilberg@kernelconcepts.de>
 *
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

/*----------------------------------------------------------------------------*/

#include <config.h>

#include <glib/gi18n-lib.h>

#include "e-kolab-plugin-util.h"

/*----------------------------------------------------------------------------*/
/* internal statics (non-UI) */


/*----------------------------------------------------------------------------*/
/* internal statics (UI) */


/*----------------------------------------------------------------------------*/
/* API functions (non-UI) */


/*----------------------------------------------------------------------------*/
/* API functions (UI) */

GtkWidget*
e_kolab_plugin_util_ui_selected_folder_widget (const gchar *foldername)
{
	GtkWidget *label = NULL;
	gchar *labeltext = NULL;

	g_assert (foldername != NULL);

	label = gtk_label_new (NULL);
	labeltext = g_strconcat ("<b>",
	                         C_("Kolab Folder Properties",
	                            "Selected Folder:"),
	                         " </b>",
	                         foldername,
	                         NULL);
	gtk_label_set_markup (GTK_LABEL (label), labeltext);
	g_free (labeltext);
	gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.0);
	gtk_widget_set_margin_top (GTK_WIDGET (label), 4);
	gtk_widget_set_margin_bottom (GTK_WIDGET (label), 4);

	return label;
}

/*----------------------------------------------------------------------------*/
