/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

#include "e-kolab-backend.h"

#include <libekolab/e-source-kolab-folder.h>
#include <libekolab/camel-kolab-imapx-settings.h>

#define E_KOLAB_BACKEND_GET_PRIVATE(obj) \
	(G_TYPE_INSTANCE_GET_PRIVATE \
	((obj), E_TYPE_KOLAB_BACKEND, EKolabBackendPrivate))

struct _EKolabBackendPrivate {
	gint placeholder;   /* remove when there's something else to add */
};

G_DEFINE_DYNAMIC_TYPE (
	EKolabBackend,
	e_kolab_backend,
	E_TYPE_COLLECTION_BACKEND)

static void
kolab_backend_populate (ECollectionBackend *backend)
{
	/* FIXME At this point the backend should query the Kolab server
	 *       for all available non-mail folders such as address books
	 *       and calendars, and create ESources for them.
	 *
	 *       Upstream authors are still fleshing out the details of
	 *       how this should work.  Query Matthew Barnes when you're
	 *       ready to implement this.
	 */
}

static gchar *
kolab_backend_dup_resource_id (ECollectionBackend *backend,
                               ESource *child_source)
{
	ESourceResource *extension;
	const gchar *extension_name;

	extension_name = E_SOURCE_EXTENSION_KOLAB_FOLDER;
	extension = e_source_get_extension (child_source, extension_name);

	return e_source_resource_dup_identity (extension);
}

static void
kolab_backend_child_added (ECollectionBackend *backend,
                           ESource *child_source)
{
	/* Chain up to parent's child_added() method. */
	E_COLLECTION_BACKEND_CLASS (e_kolab_backend_parent_class)->
		child_added (backend, child_source);
}

static void
kolab_backend_child_removed (ECollectionBackend *backend,
                             ESource *child_source)
{
	/* Chain up to parent's child_removed() method. */
	E_COLLECTION_BACKEND_CLASS (e_kolab_backend_parent_class)->
		child_removed (backend, child_source);
}

static void
e_kolab_backend_class_init (EKolabBackendClass *class)
{
	ECollectionBackendClass *backend_class;

	g_type_class_add_private (class, sizeof (EKolabBackendPrivate));

	backend_class = E_COLLECTION_BACKEND_CLASS (class);
	backend_class->populate = kolab_backend_populate;
	backend_class->dup_resource_id = kolab_backend_dup_resource_id;
	backend_class->child_added = kolab_backend_child_added;
	backend_class->child_removed = kolab_backend_child_removed;

	/* This generates an ESourceCamel subtype for CamelKolabIMAPXSettings. */
	e_source_camel_generate_subtype ("kolab", CAMEL_TYPE_KOLAB_IMAPX_SETTINGS);
}

static void
e_kolab_backend_class_finalize (EKolabBackendClass *class)
{
}

static void
e_kolab_backend_init (EKolabBackend *backend)
{
	backend->priv = E_KOLAB_BACKEND_GET_PRIVATE (backend);
}

void
e_kolab_backend_type_register (GTypeModule *type_module)
{
	/* XXX G_DEFINE_DYNAMIC_TYPE declares a static type registration
	 *     function, so we have to wrap it with a public function in
	 *     order to register types from a separate compilation unit. */
	e_kolab_backend_register_type (type_module);
}

