/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* calendar-component.c
 *
 * Copyright (C) 2003  Ximian, Inc
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Rodrigo Moya <rodrigo@ximian.com>
 */

#ifndef MIGRATION_H
#define MIGRATION_H

#include <libedataserver/e-source-group.h>
#include "calendar-component.h"
#include "tasks-component.h"
#include "memos-component.h"

struct _GError;

gboolean migrate_calendars (CalendarComponent *component, int major, int minor, int revision, struct _GError **err);
gboolean migrate_tasks (TasksComponent *component, int major, int minor, int revision, struct _GError **err);
gboolean migrate_memos (MemosComponent *component, int major, int minor, int revision, struct _GError **err);
#endif
