/* tpf-persona-store.c generated by valac 0.11.7, the Vala compiler
 * generated from tpf-persona-store.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <telepathy-glib/telepathy-glib.h>
#include <tp-lowlevel.h>
#include <gio/gio.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <glib/gi18n-lib.h>


#define TPF_TYPE_PERSONA_STORE (tpf_persona_store_get_type ())
#define TPF_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TPF_TYPE_PERSONA_STORE, TpfPersonaStore))
#define TPF_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TPF_TYPE_PERSONA_STORE, TpfPersonaStoreClass))
#define TPF_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TPF_TYPE_PERSONA_STORE))
#define TPF_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TPF_TYPE_PERSONA_STORE))
#define TPF_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TPF_TYPE_PERSONA_STORE, TpfPersonaStoreClass))

typedef struct _TpfPersonaStore TpfPersonaStore;
typedef struct _TpfPersonaStoreClass TpfPersonaStoreClass;
typedef struct _TpfPersonaStorePrivate TpfPersonaStorePrivate;

#define TPF_TYPE_PERSONA (tpf_persona_get_type ())
#define TPF_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TPF_TYPE_PERSONA, TpfPersona))
#define TPF_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TPF_TYPE_PERSONA, TpfPersonaClass))
#define TPF_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TPF_TYPE_PERSONA))
#define TPF_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TPF_TYPE_PERSONA))
#define TPF_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TPF_TYPE_PERSONA, TpfPersonaClass))

typedef struct _TpfPersona TpfPersona;
typedef struct _TpfPersonaClass TpfPersonaClass;

#define TYPE_LOGGER (logger_get_type ())
#define LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LOGGER, Logger))
#define LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LOGGER, LoggerClass))
#define IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LOGGER))
#define IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LOGGER))
#define LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LOGGER, LoggerClass))

typedef struct _Logger Logger;
typedef struct _LoggerClass LoggerClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TpfPersonaStorePrepareData TpfPersonaStorePrepareData;
typedef struct _TpfPersonaStoreInitialiseFavouriteContactsData TpfPersonaStoreInitialiseFavouriteContactsData;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
typedef struct _TpfPersonaStoreRemovePersonaData TpfPersonaStoreRemovePersonaData;
typedef struct _TpfPersonaStoreChannelGroupPendIncomingAddsData TpfPersonaStoreChannelGroupPendIncomingAddsData;
typedef struct _TpfPersonaStoreChangeGroupMembershipData TpfPersonaStoreChangeGroupMembershipData;
typedef struct _TpfPersonaStoreAddStandardChannelData TpfPersonaStoreAddStandardChannelData;
typedef struct _TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData;
typedef struct _TpfPersonaStoreCreatePersonasFromContactIdsData TpfPersonaStoreCreatePersonasFromContactIdsData;
typedef struct _TpfPersonaStoreAddPersonaFromDetailsData TpfPersonaStoreAddPersonaFromDetailsData;
typedef struct _TpfPersonaStoreChangeIsFavouriteData TpfPersonaStoreChangeIsFavouriteData;
typedef struct _TpfPersonaStoreChangeAliasData TpfPersonaStoreChangeAliasData;

struct _TpfPersonaStore {
	FolksPersonaStore parent_instance;
	TpfPersonaStorePrivate * priv;
};

struct _TpfPersonaStoreClass {
	FolksPersonaStoreClass parent_class;
};

struct _TpfPersonaStorePrivate {
	GHashTable* _personas;
	GeeHashMap* _handle_persona_map;
	GeeHashMap* _channel_group_personas_map;
	GeeHashMap* _channel_group_incoming_adds;
	GeeHashMap* _group_outgoing_adds;
	GeeHashMap* _group_outgoing_removes;
	GeeHashMap* _standard_channels_unready;
	GeeHashMap* _group_channels_unready;
	GeeHashMap* _groups;
	GeeHashSet* _favourite_handles;
	TpChannel* _publish;
	TpChannel* _stored;
	TpChannel* _subscribe;
	TpConnection* _conn;
	FolksTpLowlevel* _ll;
	TpAccountManager* _account_manager;
	Logger* _logger;
	TpContact* _self_contact;
	FolksMaybeBool _can_add_personas;
	FolksMaybeBool _can_alias_personas;
	FolksMaybeBool _can_group_personas;
	FolksMaybeBool _can_remove_personas;
	gboolean _is_prepared;
	GStaticRecMutex __lock__is_prepared;
	TpAccount* _account;
};

struct _TpfPersonaStorePrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	TpAccountManager* _tmp0_;
	TpConnectionStatusReason reason;
	TpConnectionStatusReason _tmp1_;
	TpConnectionStatus _tmp2_;
	TpConnectionStatus status;
	const gchar* _tmp3_;
	Logger* _tmp4_;
	Logger* _tmp5_;
	GError * e;
	const gchar* _tmp6_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreInitialiseFavouriteContactsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	gint _tmp0_;
	gchar** _tmp1_;
	gchar** contacts;
	gint contacts_length1;
	gint _contacts_size_;
	GError * e;
	const gchar* _tmp2_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreRemovePersonaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	FolksPersona* persona;
	TpfPersona* _tmp0_;
	TpfPersona* tp_persona;
	gboolean _tmp1_;
	TpContact* _tmp2_;
	gboolean _tmp3_;
	const gchar* _tmp4_;
	GError* _tmp5_;
	TpContact* _tmp6_;
	guint _tmp7_;
	GError * e1;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	TpContact* _tmp11_;
	guint _tmp12_;
	GError * e2;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	TpContact* _tmp16_;
	guint _tmp17_;
	GError * e3;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreChannelGroupPendIncomingAddsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	TpChannel* channel;
	GArray* adds;
	gboolean create_personas;
	guint _tmp0_;
	guint adds_length;
	gint i;
	gboolean _tmp1_;
	guint _tmp2_;
	TpHandle channel_handle;
	TpHandle _tmp3_;
	TpHandle contact_handle;
	gpointer _tmp4_;
	TpfPersona* persona;
	gpointer _tmp5_;
	GeeHashSet* contact_handles;
	GeeHashSet* _tmp6_;
};

struct _TpfPersonaStoreChangeGroupMembershipData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	FolksPersona* persona;
	gchar* group;
	gboolean is_member;
	TpfPersona* _tmp0_;
	TpfPersona* tp_persona;
	gpointer _tmp1_;
	TpChannel* channel;
	GeeHashMap* _tmp2_;
	GeeHashMap* _tmp3_;
	GeeHashMap* change_map;
	gpointer _tmp4_;
	GeeHashSet* change_set;
	GeeHashSet* _tmp5_;
	TpConnection* _tmp6_;
};

struct _TpfPersonaStoreAddStandardChannelData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	TpConnection* conn;
	gchar* name;
	TpChannel* result;
	TpChannel* channel;
	TpChannel* _tmp0_;
	TpChannel* _tmp1_;
	TpChannel* _tmp2_;
	GError * e;
	GError * _inner_error_;
};

struct _TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	TpChannel* channel;
	GArray* channel_handles;
	guint* _tmp0_;
	guint* contact_handles;
	gint contact_handles_length1;
	gint _contact_handles_size_;
	gint i;
	gboolean _tmp1_;
	guint _tmp2_;
	TpHandle channel_handle;
	TpHandle _tmp3_;
	TpHandle contact_handle;
	gpointer _tmp4_;
	TpfPersona* persona;
	const gchar* _tmp5_;
	GList* _tmp6_;
	GList* contacts;
	gboolean _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	TpContact** _tmp10_;
	TpContact** contacts_array;
	gint contacts_array_length1;
	gint _contacts_array_size_;
	gint j;
	GList* l;
	gboolean _tmp11_;
	TpContact* _tmp12_;
	TpContact* _tmp13_;
	GError * e;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreCreatePersonasFromContactIdsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	gchar** contact_ids;
	gint contact_ids_length1;
	GList* result;
	GList* _tmp0_;
	GList* contacts;
	GList* personas;
	gint err_count;
	gchar* _tmp1_;
	gchar* err_string;
	GList* l;
	gboolean _tmp2_;
	TpContact* _tmp3_;
	TpContact* contact;
	const gchar* _tmp4_;
	TpfPersona* _tmp5_;
	TpfPersona* persona;
	TpfPersona* _tmp6_;
	const gchar* _tmp7_;
	GError* _tmp8_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreAddPersonaFromDetailsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	GHashTable* details;
	FolksPersona* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* contact_id;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GError* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* add_message;
	TpConnectionStatus _tmp8_;
	TpConnectionStatus status;
	gboolean _tmp9_;
	gboolean _tmp10_;
	const gchar* _tmp11_;
	GError* _tmp12_;
	gchar** _tmp13_;
	gchar** contact_ids;
	gint contact_ids_length1;
	gint _contact_ids_size_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GList* _tmp16_;
	GList* personas;
	guint _tmp17_;
	TpfPersona* _tmp18_;
	TpfPersona* persona;
	TpChannelGroupFlags _tmp19_;
	TpChannelGroupFlags flags;
	guint _tmp20_;
	guint num_personas;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* message;
	GError* _tmp23_;
	GError * e;
	const gchar* _tmp24_;
	GError* _tmp25_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreChangeIsFavouriteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	FolksPersona* persona;
	gboolean is_favourite;
	const gchar* _tmp0_;
	TpContact* _tmp1_;
	const gchar* _tmp2_;
	const gchar* id;
	GError * e;
	const gchar* _tmp3_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreChangeAliasData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	TpfPersona* persona;
	gchar* alias;
	TpContact* _tmp0_;
	guint _tmp1_;
	TpContact* _tmp2_;
	guint _tmp3_;
};


static gpointer tpf_persona_store_parent_class = NULL;
static gchar* tpf_persona_store__tp_channel_iface;
static gchar* tpf_persona_store__tp_channel_iface = NULL;
static gchar* tpf_persona_store__tp_channel_contact_list_type;
static gchar* tpf_persona_store__tp_channel_contact_list_type = NULL;
static gchar* tpf_persona_store__tp_channel_channel_type;
static gchar* tpf_persona_store__tp_channel_channel_type = NULL;
static gchar* tpf_persona_store__tp_channel_handle_type;
static gchar* tpf_persona_store__tp_channel_handle_type = NULL;
static gchar** tpf_persona_store__undisplayed_groups;
static gint tpf_persona_store__undisplayed_groups_length1;
static gchar** tpf_persona_store__undisplayed_groups = NULL;
static gint tpf_persona_store__undisplayed_groups_length1 = 0;
static gint _tpf_persona_store__undisplayed_groups_size_ = 0;
static TpContactFeature* tpf_persona_store__contact_features;
static gint tpf_persona_store__contact_features_length1;
static TpContactFeature* tpf_persona_store__contact_features = NULL;
static gint tpf_persona_store__contact_features_length1 = 0;
static gint _tpf_persona_store__contact_features_size_ = 0;

GType tpf_persona_store_get_type (void) G_GNUC_CONST;
GType tpf_persona_get_type (void) G_GNUC_CONST;
GType logger_get_type (void) G_GNUC_CONST;
#define TPF_PERSONA_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TPF_TYPE_PERSONA_STORE, TpfPersonaStorePrivate))
enum  {
	TPF_PERSONA_STORE_DUMMY_PROPERTY,
	TPF_PERSONA_STORE_ACCOUNT,
	TPF_PERSONA_STORE_TYPE_ID,
	TPF_PERSONA_STORE_CAN_ADD_PERSONAS,
	TPF_PERSONA_STORE_CAN_ALIAS_PERSONAS,
	TPF_PERSONA_STORE_CAN_GROUP_PERSONAS,
	TPF_PERSONA_STORE_CAN_REMOVE_PERSONAS,
	TPF_PERSONA_STORE_IS_PREPARED,
	TPF_PERSONA_STORE_PERSONAS
};
TpfPersonaStore* tpf_persona_store_new (TpAccount* account);
TpfPersonaStore* tpf_persona_store_construct (GType object_type, TpAccount* account);
static void _tpf_persona_store_reset (TpfPersonaStore* self);
TpAccount* tpf_persona_store_get_account (TpfPersonaStore* self);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void _tpf_persona_store_channel_invalidated_cb (TpfPersonaStore* self, TpProxy* proxy, guint domain, gint code, const gchar* message);
static void __tpf_persona_store_channel_invalidated_cb_tp_proxy_invalidated (TpProxy* _sender, guint domain, gint code, const gchar* message, gpointer self);
static void tpf_persona_store_real_prepare_data_free (gpointer _data);
static void tpf_persona_store_real_prepare (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_store_real_prepare_co (TpfPersonaStorePrepareData* data);
static void _lambda2_ (TpAccount* a, TpfPersonaStore* self);
static void __lambda2__tp_account_manager_account_disabled (TpAccountManager* _sender, TpAccount* account, gpointer self);
static void _lambda3_ (TpAccount* a, TpfPersonaStore* self);
static void __lambda3__tp_account_manager_account_removed (TpAccountManager* _sender, TpAccount* account, gpointer self);
static void _lambda4_ (TpAccount* a, gboolean valid, TpfPersonaStore* self);
static void __lambda4__tp_account_manager_account_validity_changed (TpAccountManager* _sender, TpAccount* account, gboolean valid, gpointer self);
static void _tpf_persona_store_account_status_changed_cb (TpfPersonaStore* self, guint old_status, guint new_status, guint reason, const gchar* dbus_error_name, GHashTable* details);
static void __tpf_persona_store_account_status_changed_cb_tp_account_status_changed (TpAccount* _sender, guint old_status, guint new_status, guint reason, const gchar* dbus_error_name, GHashTable* details, gpointer self);
Logger* logger_new (const gchar* account_path, GError** error);
Logger* logger_construct (GType object_type, const gchar* account_path, GError** error);
static void _lambda11_ (TpfPersonaStore* self);
static void __lambda11__logger_invalidated (Logger* _sender, gpointer self);
static void _tpf_persona_store_favourite_contacts_changed_cb (TpfPersonaStore* self, gchar** added, int added_length1, gchar** removed, int removed_length1);
static void __tpf_persona_store_favourite_contacts_changed_cb_logger_favourite_contacts_changed (Logger* _sender, gchar** added, int added_length1, gchar** removed, int removed_length1, gpointer self);
static void _tpf_persona_store_initialise_favourite_contacts_data_free (gpointer _data);
static void _tpf_persona_store_initialise_favourite_contacts (TpfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _tpf_persona_store_initialise_favourite_contacts_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static gboolean _tpf_persona_store_initialise_favourite_contacts_co (TpfPersonaStoreInitialiseFavouriteContactsData* data);
void logger_get_favourite_contacts (Logger* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar** logger_get_favourite_contacts_finish (Logger* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void _tpf_persona_store_initialise_favourite_contacts_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _lambda10_ (TpConnection* c, TpHandleType ht, guint* h, int h_length1, gchar** i, int i_length1, GError* e, TpfPersonaStore* self, GObject* w);
static void _tpf_persona_store_change_favourites_by_request_handles (TpfPersonaStore* self, TpHandle* handles, int handles_length1, gchar** ids, int ids_length1, GError* _error_, gboolean add, GError** error);
static void __lambda10__tp_connection_request_handles_cb (TpConnection* connection, TpHandleType handle_type, int n_handles, guint* handles, gchar** ids, GError* _error_, gpointer self, GObject* weak_object);
static void _lambda12_ (TpConnection* c, TpHandleType ht, guint* h, int h_length1, gchar** i, int i_length1, GError* e, TpfPersonaStore* self, GObject* w);
static void __lambda12__tp_connection_request_handles_cb (TpConnection* connection, TpHandleType handle_type, int n_handles, guint* handles, gchar** ids, GError* _error_, gpointer self, GObject* weak_object);
static void _lambda13_ (TpConnection* c, TpHandleType ht, guint* h, int h_length1, gchar** i, int i_length1, GError* e, TpfPersonaStore* self, GObject* w);
static void __lambda13__tp_connection_request_handles_cb (TpConnection* connection, TpHandleType handle_type, int n_handles, guint* handles, gchar** ids, GError* _error_, gpointer self, GObject* weak_object);
static void _tpf_persona_store_connection_ready_cb (TpfPersonaStore* self, GObject* s, GParamSpec* p);
static void __tpf_persona_store_connection_ready_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona_store_new_group_channels_cb (TpfPersonaStore* self, TpChannel* channel, GAsyncResult* _result_);
static void __tpf_persona_store_new_group_channels_cb_folks_tp_lowlevel_new_group_channels_callback (TpChannel* channel, GAsyncResult* _result_, gpointer self);
static void _lambda6_ (GObject* s2, GAsyncResult* res, TpfPersonaStore* self);
static void __lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _lambda7_ (GObject* s3, GAsyncResult* res3, TpfPersonaStore* self);
static GValue* _g_value_dup (GValue* self);
static void _vala_GValue_free (GValue* self);
static void __lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _tpf_persona_store_add_standard_channel (TpfPersonaStore* self, TpConnection* conn, const gchar* name, GAsyncReadyCallback _callback_, gpointer _user_data_);
static TpChannel* _tpf_persona_store_add_standard_channel_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static void _tpf_persona_store_self_handle_changed_cb (TpfPersonaStore* self, GObject* s, GParamSpec* p);
static void __tpf_persona_store_self_handle_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona_store_ignore_by_handle (TpfPersonaStore* self, guint handle, const gchar* message, TpfPersona* actor, FolksGroupDetailsChangeReason reason);
static void _lambda9_ (TpConnection* conn, TpContact** contacts, int contacts_length1, TpHandle* failed, int failed_length1, GError* _error_, TpfPersonaStore* self, GObject* weak_object);
static TpfPersona* _tpf_persona_store_add_persona_from_contact (TpfPersonaStore* self, TpContact* contact, gboolean from_contact_list);
static void _g_list_free__g_object_unref0_ (GList* self);
static void __lambda9__tp_connection_contacts_by_handle_cb (TpConnection* connection, int n_contacts, TpContact** contacts, int n_failed, TpHandle* failed, GError* _error_, gpointer self, GObject* weak_object);
static void _tpf_persona_store_set_up_new_group_channel (TpfPersonaStore* self, TpChannel* channel);
static void _tpf_persona_store_channel_group_changes_resolve (TpfPersonaStore* self, TpChannel* channel);
TpContact* tpf_persona_get_contact (TpfPersona* self);
static void _tpf_persona_store_set_up_new_standard_channel (TpfPersonaStore* self, TpChannel* channel);
static void _lambda8_ (GObject* s, GParamSpec* p, TpfPersonaStore* self);
static void _tpf_persona_store_publish_channel_group_members_changed_detailed_cb (TpfPersonaStore* self, TpChannel* channel, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details);
static void __tpf_persona_store_publish_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed (TpChannel* _sender, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details, gpointer self);
static void _tpf_persona_store_stored_channel_group_members_changed_detailed_cb (TpfPersonaStore* self, TpChannel* channel, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details);
static void __tpf_persona_store_stored_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed (TpChannel* _sender, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details, gpointer self);
static void _tpf_persona_store_subscribe_channel_group_members_changed_detailed_cb (TpfPersonaStore* self, TpChannel* channel, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details);
static void __tpf_persona_store_subscribe_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed (TpChannel* _sender, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details, gpointer self);
static void _tpf_persona_store_subscribe_channel_group_flags_changed_cb (TpfPersonaStore* self, TpChannel* channel, guint added, guint removed);
static void __tpf_persona_store_subscribe_channel_group_flags_changed_cb_tp_channel_group_flags_changed (TpChannel* _sender, guint added, guint removed, gpointer self);
static void _tpf_persona_store_channel_group_pend_incoming_adds (TpfPersonaStore* self, TpChannel* channel, GArray* adds, gboolean create_personas, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _tpf_persona_store_channel_group_pend_incoming_adds_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static void __lambda8__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona_store_ignore_by_handle_if_needed (TpfPersonaStore* self, guint handle, GHashTable* details);
static void _tpf_persona_store_update_capability (TpfPersonaStore* self, TpChannelGroupFlags added, TpChannelGroupFlags removed, TpChannelGroupFlags tp_flag, FolksMaybeBool* private_member, const gchar* prop_name);
static FolksGroupDetailsChangeReason _tpf_persona_store_change_reason_from_tp_reason (guint reason);
static void tpf_persona_store_real_remove_persona_data_free (gpointer _data);
static void tpf_persona_store_real_remove_persona (FolksPersonaStore* base, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_store_real_remove_persona_co (TpfPersonaStoreRemovePersonaData* data);
gboolean tpf_persona_get_is_in_contact_list (TpfPersona* self);
static void _tpf_persona_store_channel_group_pend_incoming_adds_data_free (gpointer _data);
static gboolean _tpf_persona_store_channel_group_pend_incoming_adds_co (TpfPersonaStoreChannelGroupPendIncomingAddsData* data);
static void _tpf_persona_store_create_personas_from_channel_handles_async (TpfPersonaStore* self, TpChannel* channel, GArray* channel_handles, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _tpf_persona_store_create_personas_from_channel_handles_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static void _tpf_persona_store_channel_group_pend_incoming_adds_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _tpf_persona_store_channel_groups_add_new_personas (TpfPersonaStore* self);
static void _lambda5_ (GObject* s, GParamSpec* p, TpfPersonaStore* self);
static void _tpf_persona_store_channel_group_members_changed_detailed_cb (TpfPersonaStore* self, TpChannel* channel, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details);
static void __tpf_persona_store_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed (TpChannel* _sender, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details, gpointer self);
static void __lambda5__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona_store_change_group_membership_data_free (gpointer _data);
void _tpf_persona_store_change_group_membership (TpfPersonaStore* self, FolksPersona* persona, const gchar* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _tpf_persona_store_change_group_membership_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static gboolean _tpf_persona_store_change_group_membership_co (TpfPersonaStoreChangeGroupMembershipData* data);
static void _tpf_persona_store_change_standard_contact_list_membership (TpfPersonaStore* self, TpChannel* channel, FolksPersona* persona, gboolean is_member, const gchar* message);
static void _tpf_persona_store_add_standard_channel_data_free (gpointer _data);
static gboolean _tpf_persona_store_add_standard_channel_co (TpfPersonaStoreAddStandardChannelData* data);
static void _tpf_persona_store_add_standard_channel_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _tpf_persona_store_create_personas_from_channel_handles_async_data_free (gpointer _data);
static gboolean _tpf_persona_store_create_personas_from_channel_handles_async_co (TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData* data);
static void _vala_array_add1 (guint** array, int* length, int* size, guint value);
void tpf_persona_set_is_in_contact_list (TpfPersona* self, gboolean value);
static void _tpf_persona_store_create_personas_from_channel_handles_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _tpf_persona_store_add_new_personas_from_contacts (TpfPersonaStore* self, TpContact** contacts, int contacts_length1);
static void _tpf_persona_store_create_personas_from_contact_ids_data_free (gpointer _data);
static gchar** _vala_array_dup1 (gchar** self, int length);
static void _tpf_persona_store_create_personas_from_contact_ids (TpfPersonaStore* self, gchar** contact_ids, int contact_ids_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
static GList* _tpf_persona_store_create_personas_from_contact_ids_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static gboolean _tpf_persona_store_create_personas_from_contact_ids_co (TpfPersonaStoreCreatePersonasFromContactIdsData* data);
static void _tpf_persona_store_create_personas_from_contact_ids_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
TpfPersona* tpf_persona_new (TpContact* contact, TpfPersonaStore* store);
TpfPersona* tpf_persona_construct (GType object_type, TpContact* contact, TpfPersonaStore* store);
static gboolean _tpf_persona_store_group_is_display_group (TpfPersonaStore* self, const gchar* group);
static void tpf_persona_store_real_add_persona_from_details_data_free (gpointer _data);
static void tpf_persona_store_real_add_persona_from_details (FolksPersonaStore* base, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_store_real_add_persona_from_details_co (TpfPersonaStoreAddPersonaFromDetailsData* data);
static void tpf_persona_store_add_persona_from_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tpf_persona_store_change_is_favourite_data_free (gpointer _data);
void tpf_persona_store_change_is_favourite (TpfPersonaStore* self, FolksPersona* persona, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_is_favourite_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static gboolean tpf_persona_store_change_is_favourite_co (TpfPersonaStoreChangeIsFavouriteData* data);
void logger_add_favourite_contact (Logger* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void logger_add_favourite_contact_finish (Logger* self, GAsyncResult* _res_, GError** error);
static void tpf_persona_store_change_is_favourite_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void logger_remove_favourite_contact (Logger* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void logger_remove_favourite_contact_finish (Logger* self, GAsyncResult* _res_, GError** error);
static void tpf_persona_store_change_alias_data_free (gpointer _data);
void tpf_persona_store_change_alias (TpfPersonaStore* self, TpfPersona* persona, const gchar* alias, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_alias_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static gboolean tpf_persona_store_change_alias_co (TpfPersonaStoreChangeAliasData* data);
static void tpf_persona_store_set_account (TpfPersonaStore* self, TpAccount* value);
static void g_cclosure_user_marshal_VOID__STRING_POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void tpf_persona_store_finalize (GObject* obj);
static void _vala_tpf_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tpf_persona_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
   * Create a new PersonaStore.
   *
   * Create a new persona store to store the {@link Persona}s for the contacts
   * in the Telepathy account provided by `account`.
   *
   * @param account the Telepathy account being represented by the persona store
   */
TpfPersonaStore* tpf_persona_store_construct (GType object_type, TpAccount* account) {
	TpfPersonaStore * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (account != NULL, NULL);
	_tmp0_ = tp_account_get_display_name (account);
	_tmp1_ = tp_proxy_get_object_path ((TpProxy*) account);
	self = (TpfPersonaStore*) g_object_new (object_type, "account", account, "display-name", _tmp0_, "id", _tmp1_, NULL);
	_tpf_persona_store_reset (self);
	return self;
}


TpfPersonaStore* tpf_persona_store_new (TpAccount* account) {
	return tpf_persona_store_construct (TPF_TYPE_PERSONA_STORE, account);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void __tpf_persona_store_channel_invalidated_cb_tp_proxy_invalidated (TpProxy* _sender, guint domain, gint code, const gchar* message, gpointer self) {
	_tpf_persona_store_channel_invalidated_cb (self, _sender, domain, code, message);
}


static void _tpf_persona_store_reset (TpfPersonaStore* self) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	GHashTable* _tmp3_ = NULL;
	GeeHashMap* _tmp4_ = NULL;
	GeeHashMap* _tmp5_ = NULL;
	GeeHashMap* _tmp6_ = NULL;
	GeeHashMap* _tmp7_ = NULL;
	GeeHashMap* _tmp8_ = NULL;
	GeeHashMap* _tmp12_ = NULL;
	GeeHashMap* _tmp13_ = NULL;
	GeeHashMap* _tmp21_ = NULL;
	GeeHashSet* _tmp22_ = NULL;
	FolksTpLowlevel* _tmp23_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = tp_account_get_protocol (self->priv->_account);
	if (g_strcmp0 (_tmp1_, "local-xmpp") == 0) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = tp_account_get_protocol (self->priv->_account);
		_tmp0_ = g_strcmp0 (_tmp2_, "irc") == 0;
	}
	if (_tmp0_) {
		folks_persona_store_set_trust_level ((FolksPersonaStore*) self, FOLKS_PERSONA_STORE_TRUST_NONE);
	} else {
		folks_persona_store_set_trust_level ((FolksPersonaStore*) self, FOLKS_PERSONA_STORE_TRUST_PARTIAL);
	}
	_tmp3_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->_personas);
	self->priv->_personas = _tmp3_;
	_g_object_unref0 (self->priv->_conn);
	self->priv->_conn = NULL;
	_tmp4_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_handle_persona_map);
	self->priv->_handle_persona_map = _tmp4_;
	_tmp5_ = gee_hash_map_new (TP_TYPE_CHANNEL, (GBoxedCopyFunc) g_object_ref, g_object_unref, GEE_TYPE_HASH_SET, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_channel_group_personas_map);
	self->priv->_channel_group_personas_map = _tmp5_;
	_tmp6_ = gee_hash_map_new (TP_TYPE_CHANNEL, (GBoxedCopyFunc) g_object_ref, g_object_unref, GEE_TYPE_HASH_SET, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_channel_group_incoming_adds);
	self->priv->_channel_group_incoming_adds = _tmp6_;
	_tmp7_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_HASH_SET, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_group_outgoing_adds);
	self->priv->_group_outgoing_adds = _tmp7_;
	_tmp8_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_HASH_SET, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_group_outgoing_removes);
	self->priv->_group_outgoing_removes = _tmp8_;
	if (self->priv->_publish != NULL) {
		guint _tmp9_;
		g_signal_parse_name ("invalidated", TP_TYPE_PROXY, &_tmp9_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((TpProxy*) self->priv->_publish, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) __tpf_persona_store_channel_invalidated_cb_tp_proxy_invalidated, self);
		_g_object_unref0 (self->priv->_publish);
		self->priv->_publish = NULL;
	}
	if (self->priv->_stored != NULL) {
		guint _tmp10_;
		g_signal_parse_name ("invalidated", TP_TYPE_PROXY, &_tmp10_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((TpProxy*) self->priv->_stored, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) __tpf_persona_store_channel_invalidated_cb_tp_proxy_invalidated, self);
		_g_object_unref0 (self->priv->_stored);
		self->priv->_stored = NULL;
	}
	if (self->priv->_subscribe != NULL) {
		guint _tmp11_;
		g_signal_parse_name ("invalidated", TP_TYPE_PROXY, &_tmp11_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((TpProxy*) self->priv->_subscribe, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) __tpf_persona_store_channel_invalidated_cb_tp_proxy_invalidated, self);
		_g_object_unref0 (self->priv->_subscribe);
		self->priv->_subscribe = NULL;
	}
	_tmp12_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, TP_TYPE_CHANNEL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_standard_channels_unready);
	self->priv->_standard_channels_unready = _tmp12_;
	_tmp13_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, TP_TYPE_CHANNEL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_group_channels_unready);
	self->priv->_group_channels_unready = _tmp13_;
	if (self->priv->_groups != NULL) {
		{
			GeeCollection* _tmp14_ = NULL;
			GeeCollection* _tmp15_;
			GeeIterator* _tmp16_ = NULL;
			GeeIterator* _tmp17_;
			GeeIterator* _channel_it;
			_tmp14_ = gee_map_get_values ((GeeMap*) self->priv->_groups);
			_tmp15_ = _tmp14_;
			_tmp16_ = gee_iterable_iterator ((GeeIterable*) _tmp15_);
			_tmp17_ = _tmp16_;
			_g_object_unref0 (_tmp15_);
			_channel_it = _tmp17_;
			while (TRUE) {
				gboolean _tmp18_;
				gpointer _tmp19_ = NULL;
				TpChannel* channel;
				_tmp18_ = gee_iterator_next (_channel_it);
				if (!_tmp18_) {
					break;
				}
				_tmp19_ = gee_iterator_get (_channel_it);
				channel = (TpChannel*) _tmp19_;
				if (channel != NULL) {
					guint _tmp20_;
					g_signal_parse_name ("invalidated", TP_TYPE_PROXY, &_tmp20_, NULL, FALSE);
					g_signal_handlers_disconnect_matched ((TpProxy*) channel, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp20_, 0, NULL, (GCallback) __tpf_persona_store_channel_invalidated_cb_tp_proxy_invalidated, self);
				}
				_g_object_unref0 (channel);
			}
			_g_object_unref0 (_channel_it);
		}
	}
	_tmp21_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, TP_TYPE_CHANNEL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_groups);
	self->priv->_groups = _tmp21_;
	_tmp22_ = gee_hash_set_new (G_TYPE_UINT, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_favourite_handles);
	self->priv->_favourite_handles = _tmp22_;
	_tmp23_ = folks_tp_lowlevel_new ();
	_g_object_unref0 (self->priv->_ll);
	self->priv->_ll = _tmp23_;
}


static void tpf_persona_store_real_prepare_data_free (gpointer _data) {
	TpfPersonaStorePrepareData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (TpfPersonaStorePrepareData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void tpf_persona_store_real_prepare (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStore * self;
	TpfPersonaStorePrepareData* _data_;
	self = (TpfPersonaStore*) base;
	_data_ = g_slice_new0 (TpfPersonaStorePrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_real_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_real_prepare_data_free);
	_data_->self = _g_object_ref0 (self);
	tpf_persona_store_real_prepare_co (_data_);
}


static void tpf_persona_store_real_prepare_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaStorePrepareData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Prepare the PersonaStore for use.
   *
   * See {@link Folks.PersonaStore.prepare}.
   */
static void _lambda2_ (TpAccount* a, TpfPersonaStore* self) {
	g_return_if_fail (a != NULL);
	if (self->priv->_account == a) {
		GList* _tmp0_ = NULL;
		GList* _tmp1_;
		_tmp0_ = g_hash_table_get_values (self->priv->_personas);
		_tmp1_ = _tmp0_;
		g_signal_emit_by_name ((FolksPersonaStore*) self, "personas-changed", NULL, _tmp1_, NULL, NULL, 0);
		_g_list_free0 (_tmp1_);
		g_signal_emit_by_name ((FolksPersonaStore*) self, "removed");
	}
}


static void __lambda2__tp_account_manager_account_disabled (TpAccountManager* _sender, TpAccount* account, gpointer self) {
	_lambda2_ (account, self);
}


static void _lambda3_ (TpAccount* a, TpfPersonaStore* self) {
	g_return_if_fail (a != NULL);
	if (self->priv->_account == a) {
		GList* _tmp0_ = NULL;
		GList* _tmp1_;
		_tmp0_ = g_hash_table_get_values (self->priv->_personas);
		_tmp1_ = _tmp0_;
		g_signal_emit_by_name ((FolksPersonaStore*) self, "personas-changed", NULL, _tmp1_, NULL, NULL, 0);
		_g_list_free0 (_tmp1_);
		g_signal_emit_by_name ((FolksPersonaStore*) self, "removed");
	}
}


static void __lambda3__tp_account_manager_account_removed (TpAccountManager* _sender, TpAccount* account, gpointer self) {
	_lambda3_ (account, self);
}


static void _lambda4_ (TpAccount* a, gboolean valid, TpfPersonaStore* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (a != NULL);
	if (!valid) {
		_tmp0_ = self->priv->_account == a;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GList* _tmp1_ = NULL;
		GList* _tmp2_;
		_tmp1_ = g_hash_table_get_values (self->priv->_personas);
		_tmp2_ = _tmp1_;
		g_signal_emit_by_name ((FolksPersonaStore*) self, "personas-changed", NULL, _tmp2_, NULL, NULL, 0);
		_g_list_free0 (_tmp2_);
		g_signal_emit_by_name ((FolksPersonaStore*) self, "removed");
	}
}


static void __lambda4__tp_account_manager_account_validity_changed (TpAccountManager* _sender, TpAccount* account, gboolean valid, gpointer self) {
	_lambda4_ (account, valid, self);
}


static void __tpf_persona_store_account_status_changed_cb_tp_account_status_changed (TpAccount* _sender, guint old_status, guint new_status, guint reason, const gchar* dbus_error_name, GHashTable* details, gpointer self) {
	_tpf_persona_store_account_status_changed_cb (self, old_status, new_status, reason, dbus_error_name, details);
}


static void _lambda11_ (TpfPersonaStore* self) {
	const gchar* _tmp0_ = NULL;
	_tmp0_ = _ ("Lost connection to the telepathy-logger service.");
	g_warning ("tpf-persona-store.vala:312: %s", _tmp0_);
	_g_object_unref0 (self->priv->_logger);
	self->priv->_logger = NULL;
}


static void __lambda11__logger_invalidated (Logger* _sender, gpointer self) {
	_lambda11_ (self);
}


static void __tpf_persona_store_favourite_contacts_changed_cb_logger_favourite_contacts_changed (Logger* _sender, gchar** added, int added_length1, gchar** removed, int removed_length1, gpointer self) {
	_tpf_persona_store_favourite_contacts_changed_cb (self, added, added_length1, removed, removed_length1);
}


static gboolean tpf_persona_store_real_prepare_co (TpfPersonaStorePrepareData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		g_static_rec_mutex_lock (&data->self->priv->__lock__is_prepared);
		if (!data->self->priv->_is_prepared) {
			data->_tmp0_ = NULL;
			data->_tmp0_ = tp_account_manager_dup ();
			_g_object_unref0 (data->self->priv->_account_manager);
			data->self->priv->_account_manager = data->_tmp0_;
			g_signal_connect_object (data->self->priv->_account_manager, "account-disabled", (GCallback) __lambda2__tp_account_manager_account_disabled, data->self, 0);
			g_signal_connect_object (data->self->priv->_account_manager, "account-removed", (GCallback) __lambda3__tp_account_manager_account_removed, data->self, 0);
			g_signal_connect_object (data->self->priv->_account_manager, "account-validity-changed", (GCallback) __lambda4__tp_account_manager_account_validity_changed, data->self, 0);
			g_signal_connect_object (data->self->priv->_account, "status-changed", (GCallback) __tpf_persona_store_account_status_changed_cb_tp_account_status_changed, data->self, 0);
			data->_tmp2_ = tp_account_get_connection_status (data->self->priv->_account, &data->_tmp1_);
			data->reason = data->_tmp1_;
			data->status = data->_tmp2_;
			if (data->status != TP_CONNECTION_STATUS_DISCONNECTED) {
				_tpf_persona_store_account_status_changed_cb (data->self, (guint) TP_CONNECTION_STATUS_DISCONNECTED, (guint) data->status, (guint) data->reason, NULL, NULL);
			}
			data->_tmp3_ = NULL;
			data->_tmp3_ = folks_persona_store_get_id ((FolksPersonaStore*) data->self);
			data->_tmp4_ = NULL;
			data->_tmp4_ = logger_new (data->_tmp3_, &data->_inner_error_);
			data->_tmp5_ = data->_tmp4_;
			if (data->_inner_error_ != NULL) {
				if (data->_inner_error_->domain == DBUS_GERROR) {
					goto __catch2_dbus_gerror;
				}
				g_static_rec_mutex_unlock (&data->self->priv->__lock__is_prepared);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
			_g_object_unref0 (data->self->priv->_logger);
			data->self->priv->_logger = data->_tmp5_;
			g_signal_connect_object (data->self->priv->_logger, "invalidated", (GCallback) __lambda11__logger_invalidated, data->self, 0);
			g_signal_connect_object (data->self->priv->_logger, "favourite-contacts-changed", (GCallback) __tpf_persona_store_favourite_contacts_changed_cb_logger_favourite_contacts_changed, data->self, 0);
			goto __finally2;
			__catch2_dbus_gerror:
			{
				data->e = data->_inner_error_;
				data->_inner_error_ = NULL;
				data->_tmp6_ = NULL;
				data->_tmp6_ = _ ("Couldn't connect to the telepathy-logger service.");
				g_warning ("tpf-persona-store.vala:321: %s", data->_tmp6_);
				_g_object_unref0 (data->self->priv->_logger);
				data->self->priv->_logger = NULL;
				_g_error_free0 (data->e);
			}
			__finally2:
			if (data->_inner_error_ != NULL) {
				g_static_rec_mutex_unlock (&data->self->priv->__lock__is_prepared);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
			data->self->priv->_is_prepared = TRUE;
			g_object_notify ((GObject*) data->self, "is-prepared");
		}
		__finally1:
		g_static_rec_mutex_unlock (&data->self->priv->__lock__is_prepared);
		if (data->_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _tpf_persona_store_initialise_favourite_contacts_data_free (gpointer _data) {
	TpfPersonaStoreInitialiseFavouriteContactsData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (TpfPersonaStoreInitialiseFavouriteContactsData, data);
}


static void _tpf_persona_store_initialise_favourite_contacts (TpfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreInitialiseFavouriteContactsData* _data_;
	_data_ = g_slice_new0 (TpfPersonaStoreInitialiseFavouriteContactsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_initialise_favourite_contacts);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_initialise_favourite_contacts_data_free);
	_data_->self = _g_object_ref0 (self);
	_tpf_persona_store_initialise_favourite_contacts_co (_data_);
}


static void _tpf_persona_store_initialise_favourite_contacts_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpfPersonaStoreInitialiseFavouriteContactsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _tpf_persona_store_initialise_favourite_contacts_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreInitialiseFavouriteContactsData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_tpf_persona_store_initialise_favourite_contacts_co (data);
}


static void _lambda10_ (TpConnection* c, TpHandleType ht, guint* h, int h_length1, gchar** i, int i_length1, GError* e, TpfPersonaStore* self, GObject* w) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (c != NULL);
	g_return_if_fail (w != NULL);
	_tpf_persona_store_change_favourites_by_request_handles (self, (TpHandle*) h, h_length1, i, i_length1, e, TRUE, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch4_g_error;
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * e;
		const gchar* _tmp0_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp0_ = _ ("Couldn't get list of favorite contacts: %s");
		g_warning (_tmp0_, e->message);
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda10__tp_connection_request_handles_cb (TpConnection* connection, TpHandleType handle_type, int n_handles, guint* handles, gchar** ids, GError* _error_, gpointer self, GObject* weak_object) {
	_lambda10_ (connection, handle_type, handles, n_handles, ids, n_handles, _error_, self, weak_object);
}


static gboolean _tpf_persona_store_initialise_favourite_contacts_co (TpfPersonaStoreInitialiseFavouriteContactsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (data->self->priv->_logger == NULL) {
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_state_ = 1;
	logger_get_favourite_contacts (data->self->priv->_logger, _tpf_persona_store_initialise_favourite_contacts_ready, data);
	return FALSE;
	_state_1:
	data->_tmp1_ = NULL;
	data->_tmp1_ = logger_get_favourite_contacts_finish (data->self->priv->_logger, data->_res_, &data->_tmp0_, &data->_inner_error_);
	data->contacts = data->_tmp1_;
	data->contacts_length1 = data->_tmp0_;
	data->_contacts_size_ = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == DBUS_GERROR) {
			goto __catch3_dbus_gerror;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	if (data->contacts_length1 == 0) {
		data->contacts = (_vala_array_free (data->contacts, data->contacts_length1, (GDestroyNotify) g_free), NULL);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	tp_connection_request_handles (data->self->priv->_conn, -1, TP_HANDLE_TYPE_CONTACT, data->contacts, __lambda10__tp_connection_request_handles_cb, g_object_ref (data->self), g_object_unref, (GObject*) data->self);
	data->contacts = (_vala_array_free (data->contacts, data->contacts_length1, (GDestroyNotify) g_free), NULL);
	goto __finally3;
	__catch3_dbus_gerror:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp2_ = NULL;
		data->_tmp2_ = _ ("Couldn't get list of favorite contacts: %s");
		g_warning (data->_tmp2_, data->e->message);
		_g_error_free0 (data->e);
	}
	__finally3:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void _tpf_persona_store_change_favourites_by_request_handles (TpfPersonaStore* self, TpHandle* handles, int handles_length1, gchar** ids, int ids_length1, GError* _error_, gboolean add, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (_error_ != NULL) {
		GError* _tmp0_;
		_tmp0_ = _g_error_copy0 (_error_);
		_inner_error_ = _tmp0_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				TpHandle h;
				gpointer _tmp2_ = NULL;
				TpfPersona* p;
				gboolean _tmp3_ = FALSE;
				if (!_tmp1_) {
					i++;
				}
				_tmp1_ = FALSE;
				if (!(i < handles_length1)) {
					break;
				}
				h = handles[i];
				_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->_handle_persona_map, GUINT_TO_POINTER ((guint) h));
				p = (TpfPersona*) _tmp2_;
				if (add) {
					gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->_favourite_handles, GUINT_TO_POINTER ((guint) h));
				} else {
					gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->_favourite_handles, GUINT_TO_POINTER ((guint) h));
				}
				if (p == NULL) {
					gboolean _tmp4_ = FALSE;
					gboolean _tmp5_ = FALSE;
					if (self->priv->_self_contact == NULL) {
						gint _tmp6_;
						_tmp6_ = gee_map_get_size ((GeeMap*) self->priv->_handle_persona_map);
						_tmp5_ = _tmp6_ > 0;
					} else {
						_tmp5_ = FALSE;
					}
					if (_tmp5_) {
						_tmp4_ = TRUE;
					} else {
						gboolean _tmp7_ = FALSE;
						if (self->priv->_self_contact != NULL) {
							gint _tmp8_;
							_tmp8_ = gee_map_get_size ((GeeMap*) self->priv->_handle_persona_map);
							_tmp7_ = _tmp8_ > 1;
						} else {
							_tmp7_ = FALSE;
						}
						_tmp4_ = _tmp7_;
					}
					_tmp3_ = _tmp4_;
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					const gchar* _tmp9_ = NULL;
					_tmp9_ = _ ("Unknown persona '%s' in favorites list.");
					g_warning (_tmp9_, ids[i]);
					_g_object_unref0 (p);
					continue;
				}
				if (p != NULL) {
					folks_favourite_details_set_is_favourite ((FolksFavouriteDetails*) p, add);
				}
				_g_object_unref0 (p);
			}
		}
	}
}


static void _lambda12_ (TpConnection* c, TpHandleType ht, guint* h, int h_length1, gchar** i, int i_length1, GError* e, TpfPersonaStore* self, GObject* w) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (c != NULL);
	g_return_if_fail (w != NULL);
	_tpf_persona_store_change_favourites_by_request_handles (self, (TpHandle*) h, h_length1, i, i_length1, e, TRUE, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch5_g_error;
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError * e;
		const gchar* _tmp0_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp0_ = _ ("Couldn't add favorite contacts: %s");
		g_warning (_tmp0_, e->message);
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda12__tp_connection_request_handles_cb (TpConnection* connection, TpHandleType handle_type, int n_handles, guint* handles, gchar** ids, GError* _error_, gpointer self, GObject* weak_object) {
	_lambda12_ (connection, handle_type, handles, n_handles, ids, n_handles, _error_, self, weak_object);
}


static void _lambda13_ (TpConnection* c, TpHandleType ht, guint* h, int h_length1, gchar** i, int i_length1, GError* e, TpfPersonaStore* self, GObject* w) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (c != NULL);
	g_return_if_fail (w != NULL);
	_tpf_persona_store_change_favourites_by_request_handles (self, (TpHandle*) h, h_length1, i, i_length1, e, FALSE, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch6_g_error;
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError * e;
		const gchar* _tmp0_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp0_ = _ ("Couldn't remove favorite contacts: %s");
		g_warning (_tmp0_, e->message);
		_g_error_free0 (e);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda13__tp_connection_request_handles_cb (TpConnection* connection, TpHandleType handle_type, int n_handles, guint* handles, gchar** ids, GError* _error_, gpointer self, GObject* weak_object) {
	_lambda13_ (connection, handle_type, handles, n_handles, ids, n_handles, _error_, self, weak_object);
}


static void _tpf_persona_store_favourite_contacts_changed_cb (TpfPersonaStore* self, gchar** added, int added_length1, gchar** removed, int removed_length1) {
	g_return_if_fail (self != NULL);
	if (self->priv->_conn == NULL) {
		return;
	}
	if (added_length1 > 0) {
		tp_connection_request_handles (self->priv->_conn, -1, TP_HANDLE_TYPE_CONTACT, added, __lambda12__tp_connection_request_handles_cb, g_object_ref (self), g_object_unref, (GObject*) self);
	}
	if (removed_length1 > 0) {
		tp_connection_request_handles (self->priv->_conn, -1, TP_HANDLE_TYPE_CONTACT, removed, __lambda13__tp_connection_request_handles_cb, g_object_ref (self), g_object_unref, (GObject*) self);
	}
}


static void __tpf_persona_store_connection_ready_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona_store_connection_ready_cb (self, _sender, pspec);
}


static void _tpf_persona_store_account_status_changed_cb (TpfPersonaStore* self, guint old_status, guint new_status, guint reason, const gchar* dbus_error_name, GHashTable* details) {
	const gchar* _tmp0_ = NULL;
	TpConnection* _tmp3_ = NULL;
	TpConnection* _tmp4_;
	TpConnection* conn;
	gboolean connection_ready;
	g_return_if_fail (self != NULL);
	_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	g_debug ("tpf-persona-store.vala:474: Account '%s' changed status from %u to %u.", _tmp0_, old_status, new_status);
	if (new_status == TP_CONNECTION_STATUS_DISCONNECTED) {
		GList* _tmp1_ = NULL;
		GList* _tmp2_;
		_tmp1_ = g_hash_table_get_values (self->priv->_personas);
		_tmp2_ = _tmp1_;
		g_signal_emit_by_name ((FolksPersonaStore*) self, "personas-changed", NULL, _tmp2_, NULL, NULL, 0);
		_g_list_free0 (_tmp2_);
		_tpf_persona_store_reset (self);
		return;
	} else {
		if (new_status != TP_CONNECTION_STATUS_CONNECTED) {
			return;
		}
	}
	_tmp3_ = tp_account_get_connection (self->priv->_account);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	conn = _tmp4_;
	g_signal_connect_object ((GObject*) conn, "notify::connection-ready", (GCallback) __tpf_persona_store_connection_ready_cb_g_object_notify, self, 0);
	connection_ready = FALSE;
	g_object_get ((GObject*) conn, "connection-ready", &connection_ready, NULL);
	if (connection_ready == TRUE) {
		_tpf_persona_store_connection_ready_cb (self, (GObject*) conn, NULL);
	} else {
		tp_proxy_prepare_async ((TpProxy*) conn, NULL, NULL, NULL);
	}
	_g_object_unref0 (conn);
}


static void __tpf_persona_store_new_group_channels_cb_folks_tp_lowlevel_new_group_channels_callback (TpChannel* channel, GAsyncResult* _result_, gpointer self) {
	_tpf_persona_store_new_group_channels_cb (self, channel, _result_);
}


static void _lambda6_ (GObject* s2, GAsyncResult* res, TpfPersonaStore* self) {
	FolksMaybeBool new_can_alias;
	TpConnectionAliasFlags _tmp0_;
	TpConnectionAliasFlags flags;
	GError * _inner_error_ = NULL;
	g_return_if_fail (res != NULL);
	new_can_alias = FOLKS_MAYBE_BOOL_FALSE;
	_tmp0_ = folks_tp_lowlevel_connection_get_alias_flags_finish (self->priv->_ll, res, &_inner_error_);
	flags = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch7_g_error;
	}
	if ((flags & TP_CONNECTION_ALIAS_FLAG_USER_SET) > 0) {
		new_can_alias = FOLKS_MAYBE_BOOL_TRUE;
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError * e;
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = _ ("Failed to determine whether we can set aliases on Telepathy account '%" \
"s': %s");
		_tmp2_ = folks_persona_store_get_display_name ((FolksPersonaStore*) self);
		g_warning (_tmp1_, _tmp2_, e->message);
		_g_error_free0 (e);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	self->priv->_can_alias_personas = new_can_alias;
	g_object_notify ((GObject*) self, "can-alias-personas");
}


static void __lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda6_ (source_object, res, self);
	g_object_unref (self);
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	g_return_if_fail (self != NULL);
	g_ptr_array_set_size (self, value);
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static void _lambda7_ (GObject* s3, GAsyncResult* res3, TpfPersonaStore* self) {
	FolksMaybeBool new_can_group;
	FolksTpLowlevel* _tmp0_;
	FolksTpLowlevel* ll;
	GPtrArray* v = NULL;
	gint i = 0;
	GPtrArray* _tmp1_ = NULL;
	GPtrArray* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (res3 != NULL);
	new_can_group = FOLKS_MAYBE_BOOL_FALSE;
	_tmp0_ = _g_object_ref0 (self->priv->_ll);
	ll = _tmp0_;
	_tmp1_ = folks_tp_lowlevel_connection_get_requestable_channel_classes_finish (ll, res3, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		_g_ptr_array_unref0 (v);
		_g_object_unref0 (ll);
		goto __catch8_g_error;
	}
	_g_ptr_array_unref0 (v);
	v = _tmp2_;
	{
		gboolean _tmp3_;
		i = 0;
		_tmp3_ = TRUE;
		while (TRUE) {
			gint _tmp4_;
			gconstpointer _tmp5_ = NULL;
			GValueArray* class;
			GValue* _tmp6_ = NULL;
			GValue* _tmp7_;
			GValue* val;
			if (!_tmp3_) {
				i++;
			}
			_tmp3_ = FALSE;
			_tmp4_ = g_ptr_array_get_length (v);
			if (!(i < _tmp4_)) {
				break;
			}
			_tmp5_ = g_ptr_array_index (v, (guint) i);
			class = (GValueArray*) _tmp5_;
			_tmp6_ = g_value_array_get_nth (class, (guint) 0);
			_tmp7_ = __g_value_dup0 (_tmp6_);
			val = _tmp7_;
			if (val != NULL) {
				void* _tmp8_ = NULL;
				GHashTable* _tmp9_;
				GHashTable* props;
				const gchar* _tmp10_ = NULL;
				gchar* _tmp11_;
				gchar* channel_type;
				gboolean handle_type_valid = FALSE;
				gboolean _tmp12_;
				guint32 _tmp13_;
				guint32 handle_type;
				gboolean _tmp14_ = FALSE;
				gboolean _tmp15_ = FALSE;
				_tmp8_ = g_value_get_boxed (val);
				_tmp9_ = _g_hash_table_ref0 ((GHashTable*) _tmp8_);
				props = _tmp9_;
				_tmp10_ = tp_asv_get_string (props, tpf_persona_store__tp_channel_channel_type);
				_tmp11_ = g_strdup (_tmp10_);
				channel_type = _tmp11_;
				_tmp13_ = tp_asv_get_uint32 (props, tpf_persona_store__tp_channel_handle_type, &_tmp12_);
				handle_type_valid = _tmp12_;
				handle_type = _tmp13_;
				if (g_strcmp0 (channel_type, tpf_persona_store__tp_channel_contact_list_type) == 0) {
					_tmp15_ = handle_type_valid;
				} else {
					_tmp15_ = FALSE;
				}
				if (_tmp15_) {
					_tmp14_ = handle_type == TP_HANDLE_TYPE_GROUP;
				} else {
					_tmp14_ = FALSE;
				}
				if (_tmp14_) {
					new_can_group = FOLKS_MAYBE_BOOL_TRUE;
					_g_free0 (channel_type);
					_g_hash_table_unref0 (props);
					__vala_GValue_free0 (val);
					break;
				}
				_g_free0 (channel_type);
				_g_hash_table_unref0 (props);
			}
			__vala_GValue_free0 (val);
		}
	}
	_g_ptr_array_unref0 (v);
	_g_object_unref0 (ll);
	goto __finally8;
	__catch8_g_error:
	{
		GError * e3;
		const gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		e3 = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = _ ("Failed to determine whether we can set groups on Telepathy account '%s" \
"': %s");
		_tmp17_ = folks_persona_store_get_display_name ((FolksPersonaStore*) self);
		g_warning (_tmp16_, _tmp17_, e3->message);
		_g_error_free0 (e3);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	self->priv->_can_group_personas = new_can_group;
	g_object_notify ((GObject*) self, "can-group-personas");
}


static void __lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda7_ (source_object, res, self);
	g_object_unref (self);
}


static void __tpf_persona_store_self_handle_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona_store_self_handle_changed_cb (self, _sender, pspec);
}


static void _tpf_persona_store_connection_ready_cb (TpfPersonaStore* self, GObject* s, GParamSpec* p) {
	TpConnection* _tmp0_;
	TpConnection* c;
	TpConnection* _tmp1_;
	guint _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	_tmp0_ = _g_object_ref0 (TP_CONNECTION (s));
	c = _tmp0_;
	folks_tp_lowlevel_connection_connect_to_new_group_channels (self->priv->_ll, c, __tpf_persona_store_new_group_channels_cb_folks_tp_lowlevel_new_group_channels_callback, self);
	folks_tp_lowlevel_connection_get_alias_flags_async (self->priv->_ll, c, __lambda6__gasync_ready_callback, g_object_ref (self));
	folks_tp_lowlevel_connection_get_requestable_channel_classes_async (self->priv->_ll, c, __lambda7__gasync_ready_callback, g_object_ref (self));
	_tpf_persona_store_add_standard_channel (self, c, "publish", NULL, NULL);
	_tpf_persona_store_add_standard_channel (self, c, "stored", NULL, NULL);
	_tpf_persona_store_add_standard_channel (self, c, "subscribe", NULL, NULL);
	_tmp1_ = _g_object_ref0 (c);
	_g_object_unref0 (self->priv->_conn);
	self->priv->_conn = _tmp1_;
	g_signal_connect_object ((GObject*) self->priv->_conn, "notify::self-handle", (GCallback) __tpf_persona_store_self_handle_changed_cb_g_object_notify, self, 0);
	_tmp2_ = tp_connection_get_self_handle (self->priv->_conn);
	if (_tmp2_ != 0) {
		_tpf_persona_store_self_handle_changed_cb (self, (GObject*) self->priv->_conn, NULL);
	}
	_tpf_persona_store_initialise_favourite_contacts (self, NULL, NULL);
	_g_object_unref0 (c);
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void _lambda9_ (TpConnection* conn, TpContact** contacts, int contacts_length1, TpHandle* failed, int failed_length1, GError* _error_, TpfPersonaStore* self, GObject* weak_object) {
	TpContact* _tmp2_;
	TpContact* contact;
	TpfPersona* _tmp3_ = NULL;
	TpfPersona* persona;
	GList* personas;
	TpfPersona* _tmp4_;
	TpContact* _tmp5_;
	g_return_if_fail (conn != NULL);
	g_return_if_fail (weak_object != NULL);
	if (_error_ != NULL) {
		const gchar* _tmp0_ = NULL;
		guint _tmp1_;
		_tmp0_ = _ ("Failed to create contact for self handle '%u': %s");
		_tmp1_ = tp_connection_get_self_handle (conn);
		g_warning (_tmp0_, _tmp1_, _error_->message);
		return;
	}
	g_debug ("tpf-persona-store.vala:635: Creating persona from self-handle");
	_tmp2_ = _g_object_ref0 (contacts[0]);
	contact = _tmp2_;
	_tmp3_ = _tpf_persona_store_add_persona_from_contact (self, contact, FALSE);
	persona = _tmp3_;
	personas = NULL;
	_tmp4_ = _g_object_ref0 (persona);
	personas = g_list_prepend (personas, _tmp4_);
	_tmp5_ = _g_object_ref0 (contact);
	_g_object_unref0 (self->priv->_self_contact);
	self->priv->_self_contact = _tmp5_;
	g_signal_emit_by_name ((FolksPersonaStore*) self, "personas-changed", personas, NULL, NULL, NULL, 0);
	__g_list_free__g_object_unref0_0 (personas);
	_g_object_unref0 (persona);
	_g_object_unref0 (contact);
}


static void __lambda9__tp_connection_contacts_by_handle_cb (TpConnection* connection, int n_contacts, TpContact** contacts, int n_failed, TpHandle* failed, GError* _error_, gpointer self, GObject* weak_object) {
	_lambda9_ (connection, contacts, n_contacts, failed, n_failed, _error_, self, weak_object);
}


static void _tpf_persona_store_self_handle_changed_cb (TpfPersonaStore* self, GObject* s, GParamSpec* p) {
	TpConnection* _tmp0_;
	TpConnection* c;
	guint _tmp2_;
	guint _tmp3_;
	guint* _tmp4_ = NULL;
	guint* contact_handles;
	gint contact_handles_length1;
	gint _contact_handles_size_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	_tmp0_ = _g_object_ref0 (TP_CONNECTION (s));
	c = _tmp0_;
	if (self->priv->_self_contact != NULL) {
		guint _tmp1_;
		_tmp1_ = tp_contact_get_handle (self->priv->_self_contact);
		_tpf_persona_store_ignore_by_handle (self, _tmp1_, NULL, NULL, 0);
	}
	_tmp2_ = tp_connection_get_self_handle (c);
	if (_tmp2_ == 0) {
		_g_object_unref0 (c);
		return;
	}
	_tmp3_ = tp_connection_get_self_handle (c);
	_tmp4_ = g_new0 (guint, 1);
	_tmp4_[0] = _tmp3_;
	contact_handles = _tmp4_;
	contact_handles_length1 = 1;
	_contact_handles_size_ = 1;
	tp_connection_get_contacts_by_handle (c, contact_handles_length1, contact_handles, tpf_persona_store__contact_features_length1, (guint*) tpf_persona_store__contact_features, __lambda9__tp_connection_contacts_by_handle_cb, g_object_ref (self), g_object_unref, (GObject*) self);
	contact_handles = (g_free (contact_handles), NULL);
	_g_object_unref0 (c);
}


static void _tpf_persona_store_new_group_channels_cb (TpfPersonaStore* self, TpChannel* channel, GAsyncResult* _result_) {
	g_return_if_fail (self != NULL);
	if (channel == NULL) {
		const gchar* _tmp0_ = NULL;
		_tmp0_ = _ ("Error creating channel for NewChannels signal.");
		g_warning ("tpf-persona-store.vala:657: %s", _tmp0_);
		return;
	}
	_tpf_persona_store_set_up_new_group_channel (self, channel);
	_tpf_persona_store_channel_group_changes_resolve (self, channel);
}


static void _tpf_persona_store_channel_group_changes_resolve (TpfPersonaStore* self, TpChannel* channel) {
	const gchar* _tmp0_ = NULL;
	const gchar* group;
	GeeHashMap* _tmp1_ = NULL;
	GeeHashMap* change_maps;
	gpointer _tmp2_ = NULL;
	GeeHashSet* _tmp3_;
	gboolean _tmp4_;
	gpointer _tmp7_ = NULL;
	GeeHashSet* _tmp8_;
	gboolean _tmp9_;
	gint _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = tp_channel_get_identifier (channel);
	group = _tmp0_;
	_tmp1_ = gee_hash_map_new (GEE_TYPE_HASH_SET, (GBoxedCopyFunc) g_object_ref, g_object_unref, G_TYPE_BOOLEAN, NULL, NULL, NULL, NULL, NULL);
	change_maps = _tmp1_;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->_group_outgoing_adds, group);
	_tmp3_ = (GeeHashSet*) _tmp2_;
	_tmp4_ = _tmp3_ != NULL;
	_g_object_unref0 (_tmp3_);
	if (_tmp4_) {
		gpointer _tmp5_ = NULL;
		GeeHashSet* _tmp6_;
		_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->_group_outgoing_adds, group);
		_tmp6_ = (GeeHashSet*) _tmp5_;
		gee_abstract_map_set ((GeeAbstractMap*) change_maps, _tmp6_, GINT_TO_POINTER (TRUE));
		_g_object_unref0 (_tmp6_);
	}
	_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->_group_outgoing_removes, group);
	_tmp8_ = (GeeHashSet*) _tmp7_;
	_tmp9_ = _tmp8_ != NULL;
	_g_object_unref0 (_tmp8_);
	if (_tmp9_) {
		gpointer _tmp10_ = NULL;
		GeeHashSet* _tmp11_;
		_tmp10_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->_group_outgoing_removes, group);
		_tmp11_ = (GeeHashSet*) _tmp10_;
		gee_abstract_map_set ((GeeAbstractMap*) change_maps, _tmp11_, GINT_TO_POINTER (FALSE));
		_g_object_unref0 (_tmp11_);
	}
	_tmp12_ = gee_map_get_size ((GeeMap*) change_maps);
	if (_tmp12_ < 1) {
		_g_object_unref0 (change_maps);
		return;
	}
	{
		GeeSet* _tmp13_ = NULL;
		GeeSet* _tmp14_;
		GeeIterator* _tmp15_ = NULL;
		GeeIterator* _tmp16_;
		GeeIterator* _entry_it;
		_tmp13_ = gee_map_get_entries ((GeeMap*) change_maps);
		_tmp14_ = _tmp13_;
		_tmp15_ = gee_iterable_iterator ((GeeIterable*) _tmp14_);
		_tmp16_ = _tmp15_;
		_g_object_unref0 (_tmp14_);
		_entry_it = _tmp16_;
		while (TRUE) {
			gboolean _tmp17_;
			gpointer _tmp18_ = NULL;
			GeeMapEntry* entry;
			gconstpointer _tmp19_ = NULL;
			GeeHashSet* _tmp20_;
			GeeHashSet* changes;
			_tmp17_ = gee_iterator_next (_entry_it);
			if (!_tmp17_) {
				break;
			}
			_tmp18_ = gee_iterator_get (_entry_it);
			entry = (GeeMapEntry*) _tmp18_;
			_tmp19_ = gee_map_entry_get_key (entry);
			_tmp20_ = _g_object_ref0 ((GeeHashSet*) _tmp19_);
			changes = _tmp20_;
			{
				GeeIterator* _tmp21_ = NULL;
				GeeIterator* _persona_it;
				_tmp21_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) changes);
				_persona_it = _tmp21_;
				while (TRUE) {
					gboolean _tmp22_;
					gpointer _tmp23_ = NULL;
					TpfPersona* persona;
					TpContact* _tmp24_ = NULL;
					guint _tmp25_;
					gconstpointer _tmp26_ = NULL;
					_tmp22_ = gee_iterator_next (_persona_it);
					if (!_tmp22_) {
						break;
					}
					_tmp23_ = gee_iterator_get (_persona_it);
					persona = (TpfPersona*) _tmp23_;
					_tmp24_ = tpf_persona_get_contact (persona);
					_tmp25_ = tp_contact_get_handle (_tmp24_);
					_tmp26_ = gee_map_entry_get_value (entry);
					folks_tp_lowlevel_channel_group_change_membership (channel, (guint) ((TpHandle) _tmp25_), GPOINTER_TO_INT (_tmp26_), NULL, &_inner_error_);
					if (_inner_error_ != NULL) {
						goto __catch9_g_error;
					}
					goto __finally9;
					__catch9_g_error:
					{
						GError * e;
						gconstpointer _tmp27_ = NULL;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp27_ = gee_map_entry_get_value (entry);
						if (GPOINTER_TO_INT (_tmp27_) == TRUE) {
							const gchar* _tmp28_ = NULL;
							const gchar* _tmp29_ = NULL;
							_tmp28_ = _ ("Failed to add persona '%s' to group '%s'.");
							_tmp29_ = folks_persona_get_uid ((FolksPersona*) persona);
							g_warning (_tmp28_, _tmp29_, group);
						} else {
							const gchar* _tmp30_ = NULL;
							const gchar* _tmp31_ = NULL;
							_tmp30_ = _ ("Failed to remove persona '%s' from group '%s'.");
							_tmp31_ = folks_persona_get_uid ((FolksPersona*) persona);
							g_warning (_tmp30_, _tmp31_, group);
						}
						_g_error_free0 (e);
					}
					__finally9:
					if (_inner_error_ != NULL) {
						_g_object_unref0 (persona);
						_g_object_unref0 (_persona_it);
						_g_object_unref0 (changes);
						_g_object_unref0 (entry);
						_g_object_unref0 (_entry_it);
						_g_object_unref0 (change_maps);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_g_object_unref0 (persona);
				}
				_g_object_unref0 (_persona_it);
			}
			gee_abstract_collection_clear ((GeeAbstractCollection*) changes);
			_g_object_unref0 (changes);
			_g_object_unref0 (entry);
		}
		_g_object_unref0 (_entry_it);
	}
	_g_object_unref0 (change_maps);
}


static void __tpf_persona_store_publish_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed (TpChannel* _sender, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details, gpointer self) {
	_tpf_persona_store_publish_channel_group_members_changed_detailed_cb (self, _sender, added, removed, local_pending, remote_pending, details);
}


static void __tpf_persona_store_stored_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed (TpChannel* _sender, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details, gpointer self) {
	_tpf_persona_store_stored_channel_group_members_changed_detailed_cb (self, _sender, added, removed, local_pending, remote_pending, details);
}


static void __tpf_persona_store_subscribe_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed (TpChannel* _sender, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details, gpointer self) {
	_tpf_persona_store_subscribe_channel_group_members_changed_detailed_cb (self, _sender, added, removed, local_pending, remote_pending, details);
}


static void __tpf_persona_store_subscribe_channel_group_flags_changed_cb_tp_channel_group_flags_changed (TpChannel* _sender, guint added, guint removed, gpointer self) {
	_tpf_persona_store_subscribe_channel_group_flags_changed_cb (self, _sender, added, removed);
}


static void _lambda8_ (GObject* s, GParamSpec* p, TpfPersonaStore* self) {
	TpChannel* _tmp0_;
	TpChannel* c;
	const gchar* _tmp1_ = NULL;
	const gchar* name;
	TpIntset* _tmp6_ = NULL;
	TpIntset* members;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = _g_object_ref0 (TP_CHANNEL (s));
	c = _tmp0_;
	_tmp1_ = tp_channel_get_identifier (c);
	name = _tmp1_;
	g_debug ("tpf-persona-store.vala:728: Channel '%s' is ready.", name);
	if (g_strcmp0 (name, "publish") == 0) {
		TpChannel* _tmp2_;
		_tmp2_ = _g_object_ref0 (c);
		_g_object_unref0 (self->priv->_publish);
		self->priv->_publish = _tmp2_;
		g_signal_connect_object (c, "group-members-changed-detailed", (GCallback) __tpf_persona_store_publish_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed, self, 0);
	} else {
		if (g_strcmp0 (name, "stored") == 0) {
			TpChannel* _tmp3_;
			_tmp3_ = _g_object_ref0 (c);
			_g_object_unref0 (self->priv->_stored);
			self->priv->_stored = _tmp3_;
			g_signal_connect_object (c, "group-members-changed-detailed", (GCallback) __tpf_persona_store_stored_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed, self, 0);
		} else {
			if (g_strcmp0 (name, "subscribe") == 0) {
				TpChannel* _tmp4_;
				TpChannelGroupFlags _tmp5_;
				_tmp4_ = _g_object_ref0 (c);
				_g_object_unref0 (self->priv->_subscribe);
				self->priv->_subscribe = _tmp4_;
				g_signal_connect_object (c, "group-members-changed-detailed", (GCallback) __tpf_persona_store_subscribe_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed, self, 0);
				g_signal_connect_object (c, "group-flags-changed", (GCallback) __tpf_persona_store_subscribe_channel_group_flags_changed_cb_tp_channel_group_flags_changed, self, 0);
				_tmp5_ = tp_channel_group_get_flags (c);
				_tpf_persona_store_subscribe_channel_group_flags_changed_cb (self, c, (guint) _tmp5_, (guint) 0);
			}
		}
	}
	gee_abstract_map_unset ((GeeAbstractMap*) self->priv->_standard_channels_unready, name, NULL);
	g_signal_connect_object ((TpProxy*) c, "invalidated", (GCallback) __tpf_persona_store_channel_invalidated_cb_tp_proxy_invalidated, self, 0);
	_tmp6_ = tp_channel_group_get_members (c);
	members = _tmp6_;
	if (members != NULL) {
		GArray* _tmp7_ = NULL;
		GArray* _tmp8_;
		_tmp7_ = tp_intset_to_array (members);
		_tmp8_ = _tmp7_;
		_tpf_persona_store_channel_group_pend_incoming_adds (self, c, _tmp8_, TRUE, NULL, NULL);
		_g_array_unref0 (_tmp8_);
	}
	_g_object_unref0 (c);
}


static void __lambda8__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda8_ (_sender, pspec, self);
}


static void _tpf_persona_store_set_up_new_standard_channel (TpfPersonaStore* self, TpChannel* channel) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = tp_channel_get_identifier (channel);
	g_debug ("tpf-persona-store.vala:716: Setting up new standard channel '%s'.", _tmp0_);
	_tmp1_ = tp_channel_get_identifier (channel);
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->_standard_channels_unready, _tmp1_, channel);
	g_signal_connect_object ((GObject*) channel, "notify::channel-ready", (GCallback) __lambda8__g_object_notify, self, 0);
}


static void _tpf_persona_store_publish_channel_group_members_changed_detailed_cb (TpfPersonaStore* self, TpChannel* channel, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	g_return_if_fail (local_pending != NULL);
	g_return_if_fail (remote_pending != NULL);
	g_return_if_fail (details != NULL);
	if (added->len > 0) {
		_tpf_persona_store_channel_group_pend_incoming_adds (self, channel, added, TRUE, NULL, NULL);
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint _tmp1_;
				guint handle;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < removed->len)) {
					break;
				}
				_tmp1_ = g_array_index (removed, guint, (guint) i);
				handle = _tmp1_;
				_tpf_persona_store_ignore_by_handle_if_needed (self, handle, details);
			}
		}
	}
}


static void _tpf_persona_store_stored_channel_group_members_changed_detailed_cb (TpfPersonaStore* self, TpChannel* channel, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	g_return_if_fail (local_pending != NULL);
	g_return_if_fail (remote_pending != NULL);
	g_return_if_fail (details != NULL);
	if (added->len > 0) {
		_tpf_persona_store_channel_group_pend_incoming_adds (self, channel, added, TRUE, NULL, NULL);
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint _tmp1_;
				guint handle;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < removed->len)) {
					break;
				}
				_tmp1_ = g_array_index (removed, guint, (guint) i);
				handle = _tmp1_;
				_tpf_persona_store_ignore_by_handle_if_needed (self, handle, details);
			}
		}
	}
}


static void _tpf_persona_store_subscribe_channel_group_flags_changed_cb (TpfPersonaStore* self, TpChannel* channel, guint added, guint removed) {
	g_return_if_fail (self != NULL);
	_tpf_persona_store_update_capability (self, (TpChannelGroupFlags) added, (TpChannelGroupFlags) removed, TP_CHANNEL_GROUP_FLAG_CAN_ADD, &self->priv->_can_add_personas, "can-add-personas");
	_tpf_persona_store_update_capability (self, (TpChannelGroupFlags) added, (TpChannelGroupFlags) removed, TP_CHANNEL_GROUP_FLAG_CAN_REMOVE, &self->priv->_can_remove_personas, "can-remove-personas");
}


static void _tpf_persona_store_update_capability (TpfPersonaStore* self, TpChannelGroupFlags added, TpChannelGroupFlags removed, TpChannelGroupFlags tp_flag, FolksMaybeBool* private_member, const gchar* prop_name) {
	FolksMaybeBool new_value;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prop_name != NULL);
	new_value = *private_member;
	if ((added & tp_flag) != 0) {
		new_value = FOLKS_MAYBE_BOOL_TRUE;
	}
	if ((removed & tp_flag) != 0) {
		new_value = FOLKS_MAYBE_BOOL_FALSE;
	}
	if (new_value != (*private_member)) {
		*private_member = new_value;
		g_object_notify ((GObject*) self, prop_name);
	}
}


static void _tpf_persona_store_subscribe_channel_group_members_changed_detailed_cb (TpfPersonaStore* self, TpChannel* channel, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	g_return_if_fail (local_pending != NULL);
	g_return_if_fail (remote_pending != NULL);
	g_return_if_fail (details != NULL);
	if (added->len > 0) {
		_tpf_persona_store_channel_group_pend_incoming_adds (self, channel, added, TRUE, NULL, NULL);
		if (self->priv->_publish != NULL) {
			_tpf_persona_store_channel_group_pend_incoming_adds (self, self->priv->_publish, added, TRUE, NULL, NULL);
		}
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint _tmp1_;
				guint handle;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < removed->len)) {
					break;
				}
				_tmp1_ = g_array_index (removed, guint, (guint) i);
				handle = _tmp1_;
				_tpf_persona_store_ignore_by_handle_if_needed (self, handle, details);
			}
		}
	}
}


static void _tpf_persona_store_channel_invalidated_cb (TpfPersonaStore* self, TpProxy* proxy, guint domain, gint code, const gchar* message) {
	TpChannel* _tmp0_;
	TpChannel* channel;
	g_return_if_fail (self != NULL);
	g_return_if_fail (proxy != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = _g_object_ref0 (TP_CHANNEL (proxy));
	channel = _tmp0_;
	gee_abstract_map_unset ((GeeAbstractMap*) self->priv->_channel_group_personas_map, channel, NULL);
	gee_abstract_map_unset ((GeeAbstractMap*) self->priv->_channel_group_incoming_adds, channel, NULL);
	if (proxy == TP_PROXY (self->priv->_publish)) {
		_g_object_unref0 (self->priv->_publish);
		self->priv->_publish = NULL;
	} else {
		if (proxy == TP_PROXY (self->priv->_stored)) {
			_g_object_unref0 (self->priv->_stored);
			self->priv->_stored = NULL;
		} else {
			if (proxy == TP_PROXY (self->priv->_subscribe)) {
				_g_object_unref0 (self->priv->_subscribe);
				self->priv->_subscribe = NULL;
			} else {
				GError* _tmp1_ = NULL;
				GError* _error_;
				const gchar* _tmp2_ = NULL;
				gchar* _tmp3_;
				gchar* name;
				_tmp1_ = g_error_new ((GQuark) domain, code, "%s", message);
				_error_ = _tmp1_;
				_tmp2_ = tp_channel_get_identifier (channel);
				_tmp3_ = g_strdup (_tmp2_);
				name = _tmp3_;
				g_signal_emit_by_name (self, "group-removed", name, _error_);
				gee_abstract_map_unset ((GeeAbstractMap*) self->priv->_groups, name, NULL);
				_g_free0 (name);
				_g_error_free0 (_error_);
			}
		}
	}
	_g_object_unref0 (channel);
}


static void _tpf_persona_store_ignore_by_handle_if_needed (TpfPersonaStore* self, guint handle, GHashTable* details) {
	TpIntset* members = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* message;
	gboolean valid = FALSE;
	TpfPersona* actor;
	gboolean _tmp7_;
	guint32 _tmp8_;
	guint32 actor_handle;
	gboolean _tmp9_ = FALSE;
	FolksGroupDetailsChangeReason reason;
	gboolean _tmp11_;
	guint32 _tmp12_;
	guint32 tp_reason;
	g_return_if_fail (self != NULL);
	g_return_if_fail (details != NULL);
	if (self->priv->_subscribe != NULL) {
		TpIntset* _tmp0_ = NULL;
		gboolean _tmp1_;
		TpIntset* _tmp2_ = NULL;
		gboolean _tmp3_;
		_tmp0_ = tp_channel_group_get_members (self->priv->_subscribe);
		members = _tmp0_;
		_tmp1_ = tp_intset_is_member (members, handle);
		if (_tmp1_) {
			return;
		}
		_tmp2_ = tp_channel_group_get_remote_pending (self->priv->_subscribe);
		members = _tmp2_;
		_tmp3_ = tp_intset_is_member (members, handle);
		if (_tmp3_) {
			return;
		}
	}
	if (self->priv->_publish != NULL) {
		TpIntset* _tmp4_ = NULL;
		gboolean _tmp5_;
		_tmp4_ = tp_channel_group_get_members (self->priv->_publish);
		members = _tmp4_;
		_tmp5_ = tp_intset_is_member (members, handle);
		if (_tmp5_) {
			return;
		}
	}
	_tmp6_ = tp_asv_get_string (details, "message");
	message = _tmp6_;
	actor = NULL;
	_tmp8_ = tp_asv_get_uint32 (details, "actor", &_tmp7_);
	valid = _tmp7_;
	actor_handle = _tmp8_;
	if (actor_handle > 0) {
		_tmp9_ = valid;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gpointer _tmp10_ = NULL;
		_tmp10_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->_handle_persona_map, GUINT_TO_POINTER ((guint) actor_handle));
		_g_object_unref0 (actor);
		actor = (TpfPersona*) _tmp10_;
	}
	reason = FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE;
	_tmp12_ = tp_asv_get_uint32 (details, "change-reason", &_tmp11_);
	valid = _tmp11_;
	tp_reason = _tmp12_;
	if (valid) {
		FolksGroupDetailsChangeReason _tmp13_;
		_tmp13_ = _tpf_persona_store_change_reason_from_tp_reason ((guint) tp_reason);
		reason = _tmp13_;
	}
	_tpf_persona_store_ignore_by_handle (self, handle, message, actor, reason);
	_g_object_unref0 (actor);
}


static FolksGroupDetailsChangeReason _tpf_persona_store_change_reason_from_tp_reason (guint reason) {
	FolksGroupDetailsChangeReason result = 0;
	result = (FolksGroupDetailsChangeReason) reason;
	return result;
}


static void _tpf_persona_store_ignore_by_handle (TpfPersonaStore* self, guint handle, const gchar* message, TpfPersona* actor, FolksGroupDetailsChangeReason reason) {
	gpointer _tmp0_ = NULL;
	TpfPersona* persona;
	gboolean _tmp1_ = FALSE;
	GList* personas;
	TpfPersona* _tmp17_;
	const gchar* _tmp18_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->_handle_persona_map, GUINT_TO_POINTER (handle));
	persona = (TpfPersona*) _tmp0_;
	g_debug ("tpf-persona-store.vala:954: Ignoring handle %u (persona: %p)", handle, persona);
	if (self->priv->_self_contact != NULL) {
		guint _tmp2_;
		_tmp2_ = tp_contact_get_handle (self->priv->_self_contact);
		_tmp1_ = _tmp2_ == handle;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_g_object_unref0 (self->priv->_self_contact);
		self->priv->_self_contact = NULL;
	}
	gee_abstract_map_unset ((GeeAbstractMap*) self->priv->_handle_persona_map, GUINT_TO_POINTER (handle), NULL);
	if (persona == NULL) {
		_g_object_unref0 (persona);
		return;
	}
	{
		GeeSet* _tmp3_ = NULL;
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _tmp6_;
		GeeIterator* _channel_it;
		_tmp3_ = gee_map_get_keys ((GeeMap*) self->priv->_channel_group_personas_map);
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_channel_it = _tmp6_;
		while (TRUE) {
			gboolean _tmp7_;
			gpointer _tmp8_ = NULL;
			TpChannel* channel;
			gpointer _tmp9_ = NULL;
			GeeHashSet* members;
			_tmp7_ = gee_iterator_next (_channel_it);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = gee_iterator_get (_channel_it);
			channel = (TpChannel*) _tmp8_;
			_tmp9_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->_channel_group_personas_map, channel);
			members = (GeeHashSet*) _tmp9_;
			if (members != NULL) {
				gee_abstract_collection_remove ((GeeAbstractCollection*) members, persona);
			}
			_g_object_unref0 (members);
			_g_object_unref0 (channel);
		}
		_g_object_unref0 (_channel_it);
	}
	{
		GeeSet* _tmp10_ = NULL;
		GeeSet* _tmp11_;
		GeeIterator* _tmp12_ = NULL;
		GeeIterator* _tmp13_;
		GeeIterator* _name_it;
		_tmp10_ = gee_map_get_keys ((GeeMap*) self->priv->_group_outgoing_adds);
		_tmp11_ = _tmp10_;
		_tmp12_ = gee_iterable_iterator ((GeeIterable*) _tmp11_);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp11_);
		_name_it = _tmp13_;
		while (TRUE) {
			gboolean _tmp14_;
			gpointer _tmp15_ = NULL;
			gchar* name;
			gpointer _tmp16_ = NULL;
			GeeHashSet* members;
			_tmp14_ = gee_iterator_next (_name_it);
			if (!_tmp14_) {
				break;
			}
			_tmp15_ = gee_iterator_get (_name_it);
			name = (gchar*) _tmp15_;
			_tmp16_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->_group_outgoing_adds, name);
			members = (GeeHashSet*) _tmp16_;
			if (members != NULL) {
				gee_abstract_collection_remove ((GeeAbstractCollection*) members, persona);
			}
			_g_object_unref0 (members);
			_g_free0 (name);
		}
		_g_object_unref0 (_name_it);
	}
	personas = NULL;
	_tmp17_ = _g_object_ref0 (persona);
	personas = g_list_append (personas, _tmp17_);
	g_signal_emit_by_name ((FolksPersonaStore*) self, "personas-changed", NULL, personas, message, (FolksPersona*) actor, reason);
	_tmp18_ = folks_persona_get_iid ((FolksPersona*) persona);
	g_hash_table_remove (self->priv->_personas, _tmp18_);
	__g_list_free__g_object_unref0_0 (personas);
	_g_object_unref0 (persona);
}


static void tpf_persona_store_real_remove_persona_data_free (gpointer _data) {
	TpfPersonaStoreRemovePersonaData* data;
	data = _data;
	_g_object_unref0 (data->persona);
	_g_object_unref0 (data->self);
	g_slice_free (TpfPersonaStoreRemovePersonaData, data);
}


static void tpf_persona_store_real_remove_persona (FolksPersonaStore* base, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStore * self;
	TpfPersonaStoreRemovePersonaData* _data_;
	self = (TpfPersonaStore*) base;
	_data_ = g_slice_new0 (TpfPersonaStoreRemovePersonaData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_real_remove_persona);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_real_remove_persona_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->persona = _g_object_ref0 (persona);
	tpf_persona_store_real_remove_persona_co (_data_);
}


static void tpf_persona_store_real_remove_persona_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaStoreRemovePersonaData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Remove a {@link Persona} from the PersonaStore.
   *
   * See {@link Folks.PersonaStore.remove_persona}.
   */
static gboolean tpf_persona_store_real_remove_persona_co (TpfPersonaStoreRemovePersonaData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = _g_object_ref0 (TPF_PERSONA (data->persona));
	data->tp_persona = data->_tmp0_;
	data->_tmp2_ = NULL;
	data->_tmp2_ = tpf_persona_get_contact (data->tp_persona);
	if (data->_tmp2_ == data->self->priv->_self_contact) {
		data->_tmp3_ = tpf_persona_get_is_in_contact_list (data->tp_persona);
		data->_tmp1_ = data->_tmp3_ == FALSE;
	} else {
		data->_tmp1_ = FALSE;
	}
	if (data->_tmp1_) {
		data->_tmp4_ = NULL;
		data->_tmp4_ = _ ("Personas representing the local user may not be removed.");
		data->_tmp5_ = NULL;
		data->_tmp5_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_UNSUPPORTED_ON_USER, data->_tmp4_);
		data->_inner_error_ = data->_tmp5_;
		if (data->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->tp_persona);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (data->tp_persona);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->_tmp6_ = NULL;
	data->_tmp6_ = tpf_persona_get_contact (data->tp_persona);
	data->_tmp7_ = tp_contact_get_handle (data->_tmp6_);
	folks_tp_lowlevel_channel_group_change_membership (data->self->priv->_stored, (guint) ((TpHandle) data->_tmp7_), FALSE, NULL, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch10_g_error;
	}
	goto __finally10;
	__catch10_g_error:
	{
		data->e1 = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp8_ = NULL;
		data->_tmp8_ = _ ("Failed to remove persona '%s' (%s) from 'stored' list: %s");
		data->_tmp9_ = NULL;
		data->_tmp9_ = folks_persona_get_uid ((FolksPersona*) data->tp_persona);
		data->_tmp10_ = NULL;
		data->_tmp10_ = folks_alias_details_get_alias ((FolksAliasDetails*) data->tp_persona);
		g_warning (data->_tmp8_, data->_tmp9_, data->_tmp10_, data->e1->message);
		_g_error_free0 (data->e1);
	}
	__finally10:
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->tp_persona);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (data->tp_persona);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->_tmp11_ = NULL;
	data->_tmp11_ = tpf_persona_get_contact (data->tp_persona);
	data->_tmp12_ = tp_contact_get_handle (data->_tmp11_);
	folks_tp_lowlevel_channel_group_change_membership (data->self->priv->_subscribe, (guint) ((TpHandle) data->_tmp12_), FALSE, NULL, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch11_g_error;
	}
	goto __finally11;
	__catch11_g_error:
	{
		data->e2 = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp13_ = NULL;
		data->_tmp13_ = _ ("Failed to remove persona '%s' (%s) from 'subscribe' list: %s");
		data->_tmp14_ = NULL;
		data->_tmp14_ = folks_persona_get_uid ((FolksPersona*) data->tp_persona);
		data->_tmp15_ = NULL;
		data->_tmp15_ = folks_alias_details_get_alias ((FolksAliasDetails*) data->tp_persona);
		g_warning (data->_tmp13_, data->_tmp14_, data->_tmp15_, data->e2->message);
		_g_error_free0 (data->e2);
	}
	__finally11:
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->tp_persona);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (data->tp_persona);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->_tmp16_ = NULL;
	data->_tmp16_ = tpf_persona_get_contact (data->tp_persona);
	data->_tmp17_ = tp_contact_get_handle (data->_tmp16_);
	folks_tp_lowlevel_channel_group_change_membership (data->self->priv->_publish, (guint) ((TpHandle) data->_tmp17_), FALSE, NULL, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch12_g_error;
	}
	goto __finally12;
	__catch12_g_error:
	{
		data->e3 = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp18_ = NULL;
		data->_tmp18_ = _ ("Failed to remove persona '%s' (%s) from 'publish' list: %s");
		data->_tmp19_ = NULL;
		data->_tmp19_ = folks_persona_get_uid ((FolksPersona*) data->tp_persona);
		data->_tmp20_ = NULL;
		data->_tmp20_ = folks_alias_details_get_alias ((FolksAliasDetails*) data->tp_persona);
		g_warning (data->_tmp18_, data->_tmp19_, data->_tmp20_, data->e3->message);
		_g_error_free0 (data->e3);
	}
	__finally12:
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->tp_persona);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (data->tp_persona);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	_g_object_unref0 (data->tp_persona);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _tpf_persona_store_channel_group_pend_incoming_adds_data_free (gpointer _data) {
	TpfPersonaStoreChannelGroupPendIncomingAddsData* data;
	data = _data;
	_g_object_unref0 (data->channel);
	_g_array_unref0 (data->adds);
	_g_object_unref0 (data->self);
	g_slice_free (TpfPersonaStoreChannelGroupPendIncomingAddsData, data);
}


static gpointer _g_array_ref0 (gpointer self) {
	return self ? g_array_ref (self) : NULL;
}


static void _tpf_persona_store_channel_group_pend_incoming_adds (TpfPersonaStore* self, TpChannel* channel, GArray* adds, gboolean create_personas, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreChannelGroupPendIncomingAddsData* _data_;
	_data_ = g_slice_new0 (TpfPersonaStoreChannelGroupPendIncomingAddsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_channel_group_pend_incoming_adds);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_channel_group_pend_incoming_adds_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->channel = _g_object_ref0 (channel);
	_data_->adds = _g_array_ref0 (adds);
	_data_->create_personas = create_personas;
	_tpf_persona_store_channel_group_pend_incoming_adds_co (_data_);
}


static void _tpf_persona_store_channel_group_pend_incoming_adds_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpfPersonaStoreChannelGroupPendIncomingAddsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _tpf_persona_store_channel_group_pend_incoming_adds_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreChannelGroupPendIncomingAddsData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_tpf_persona_store_channel_group_pend_incoming_adds_co (data);
}


static gboolean _tpf_persona_store_channel_group_pend_incoming_adds_co (TpfPersonaStoreChannelGroupPendIncomingAddsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (data->adds != NULL) {
		data->_tmp0_ = data->adds->len;
	} else {
		data->_tmp0_ = (guint) 0;
	}
	data->adds_length = data->_tmp0_;
	if (data->adds_length >= 1) {
		if (data->create_personas) {
			data->_state_ = 1;
			_tpf_persona_store_create_personas_from_channel_handles_async (data->self, data->channel, data->adds, _tpf_persona_store_channel_group_pend_incoming_adds_ready, data);
			return FALSE;
			_state_1:
			_tpf_persona_store_create_personas_from_channel_handles_finish (data->self, data->_res_);
		}
		{
			data->i = 0;
			{
				data->_tmp1_ = TRUE;
				while (TRUE) {
					if (!data->_tmp1_) {
						data->i++;
					}
					data->_tmp1_ = FALSE;
					if (!(data->i < data->adds->len)) {
						break;
					}
					data->_tmp2_ = g_array_index (data->adds, guint, (guint) data->i);
					data->channel_handle = (TpHandle) data->_tmp2_;
					data->_tmp3_ = tp_channel_group_get_handle_owner (data->channel, data->channel_handle);
					data->contact_handle = data->_tmp3_;
					data->_tmp4_ = NULL;
					data->_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) data->self->priv->_handle_persona_map, GUINT_TO_POINTER ((guint) data->contact_handle));
					data->persona = (TpfPersona*) data->_tmp4_;
					if (data->persona == NULL) {
						data->_tmp5_ = NULL;
						data->_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) data->self->priv->_channel_group_incoming_adds, data->channel);
						data->contact_handles = (GeeHashSet*) data->_tmp5_;
						if (data->contact_handles == NULL) {
							data->_tmp6_ = NULL;
							data->_tmp6_ = gee_hash_set_new (G_TYPE_UINT, NULL, NULL, NULL, NULL);
							_g_object_unref0 (data->contact_handles);
							data->contact_handles = data->_tmp6_;
							gee_abstract_map_set ((GeeAbstractMap*) data->self->priv->_channel_group_incoming_adds, data->channel, data->contact_handles);
						}
						gee_abstract_collection_add ((GeeAbstractCollection*) data->contact_handles, GUINT_TO_POINTER ((guint) data->contact_handle));
						_g_object_unref0 (data->contact_handles);
					}
					_g_object_unref0 (data->persona);
				}
			}
		}
	}
	_tpf_persona_store_channel_groups_add_new_personas (data->self);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void __tpf_persona_store_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed (TpChannel* _sender, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details, gpointer self) {
	_tpf_persona_store_channel_group_members_changed_detailed_cb (self, _sender, added, removed, local_pending, remote_pending, details);
}


static void _lambda5_ (GObject* s, GParamSpec* p, TpfPersonaStore* self) {
	TpChannel* _tmp0_;
	TpChannel* c;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* name;
	TpIntset* _tmp3_ = NULL;
	TpIntset* members;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = _g_object_ref0 (TP_CHANNEL (s));
	c = _tmp0_;
	_tmp1_ = tp_channel_get_identifier (c);
	_tmp2_ = g_strdup (_tmp1_);
	name = _tmp2_;
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->_groups, name, c);
	gee_abstract_map_unset ((GeeAbstractMap*) self->priv->_group_channels_unready, name, NULL);
	g_signal_connect_object ((TpProxy*) c, "invalidated", (GCallback) __tpf_persona_store_channel_invalidated_cb_tp_proxy_invalidated, self, 0);
	g_signal_connect_object (c, "group-members-changed-detailed", (GCallback) __tpf_persona_store_channel_group_members_changed_detailed_cb_tp_channel_group_members_changed_detailed, self, 0);
	_tmp3_ = tp_channel_group_get_members (c);
	members = _tmp3_;
	if (members != NULL) {
		GArray* _tmp4_ = NULL;
		GArray* _tmp5_;
		_tmp4_ = tp_intset_to_array (members);
		_tmp5_ = _tmp4_;
		_tpf_persona_store_channel_group_pend_incoming_adds (self, c, _tmp5_, FALSE, NULL, NULL);
		_g_array_unref0 (_tmp5_);
	}
	_g_free0 (name);
	_g_object_unref0 (c);
}


static void __lambda5__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda5_ (_sender, pspec, self);
}


static void _tpf_persona_store_set_up_new_group_channel (TpfPersonaStore* self, TpChannel* channel) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = tp_channel_get_identifier (channel);
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->_group_channels_unready, _tmp0_, channel);
	g_signal_connect_object ((GObject*) channel, "notify::channel-ready", (GCallback) __lambda5__g_object_notify, self, 0);
}


static void _tpf_persona_store_channel_group_members_changed_detailed_cb (TpfPersonaStore* self, TpChannel* channel, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	g_return_if_fail (local_pending != NULL);
	g_return_if_fail (remote_pending != NULL);
	g_return_if_fail (details != NULL);
	if (added != NULL) {
		_tpf_persona_store_channel_group_pend_incoming_adds (self, channel, added, FALSE, NULL, NULL);
	}
}


static void _tpf_persona_store_change_group_membership_data_free (gpointer _data) {
	TpfPersonaStoreChangeGroupMembershipData* data;
	data = _data;
	_g_object_unref0 (data->persona);
	_g_free0 (data->group);
	_g_object_unref0 (data->self);
	g_slice_free (TpfPersonaStoreChangeGroupMembershipData, data);
}


void _tpf_persona_store_change_group_membership (TpfPersonaStore* self, FolksPersona* persona, const gchar* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreChangeGroupMembershipData* _data_;
	_data_ = g_slice_new0 (TpfPersonaStoreChangeGroupMembershipData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_change_group_membership);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_change_group_membership_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->persona = _g_object_ref0 (persona);
	_data_->group = g_strdup (group);
	_data_->is_member = is_member;
	_tpf_persona_store_change_group_membership_co (_data_);
}


void _tpf_persona_store_change_group_membership_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpfPersonaStoreChangeGroupMembershipData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean _tpf_persona_store_change_group_membership_co (TpfPersonaStoreChangeGroupMembershipData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = _g_object_ref0 (TPF_PERSONA (data->persona));
	data->tp_persona = data->_tmp0_;
	data->_tmp1_ = NULL;
	data->_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) data->self->priv->_groups, data->group);
	data->channel = (TpChannel*) data->_tmp1_;
	if (data->is_member) {
		data->_tmp2_ = data->self->priv->_group_outgoing_adds;
	} else {
		data->_tmp2_ = data->self->priv->_group_outgoing_removes;
	}
	data->_tmp3_ = _g_object_ref0 (data->_tmp2_);
	data->change_map = data->_tmp3_;
	data->_tmp4_ = NULL;
	data->_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) data->change_map, data->group);
	data->change_set = (GeeHashSet*) data->_tmp4_;
	if (data->change_set == NULL) {
		data->_tmp5_ = NULL;
		data->_tmp5_ = gee_hash_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
		_g_object_unref0 (data->change_set);
		data->change_set = data->_tmp5_;
		gee_abstract_map_set ((GeeAbstractMap*) data->change_map, data->group, data->change_set);
	}
	gee_abstract_collection_add ((GeeAbstractCollection*) data->change_set, data->tp_persona);
	if (data->channel == NULL) {
		data->_tmp6_ = NULL;
		data->_tmp6_ = tp_account_get_connection (data->self->priv->_account);
		folks_tp_lowlevel_connection_create_group_async (data->self->priv->_ll, data->_tmp6_, data->group);
	} else {
		_tpf_persona_store_channel_group_changes_resolve (data->self, data->channel);
	}
	_g_object_unref0 (data->change_set);
	_g_object_unref0 (data->change_map);
	_g_object_unref0 (data->channel);
	_g_object_unref0 (data->tp_persona);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _tpf_persona_store_change_standard_contact_list_membership (TpfPersonaStore* self, TpChannel* channel, FolksPersona* persona, gboolean is_member, const gchar* message) {
	TpfPersona* _tmp0_;
	TpfPersona* tp_persona;
	TpContact* _tmp1_ = NULL;
	guint _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	g_return_if_fail (persona != NULL);
	_tmp0_ = _g_object_ref0 (TPF_PERSONA (persona));
	tp_persona = _tmp0_;
	_tmp1_ = tpf_persona_get_contact (tp_persona);
	_tmp2_ = tp_contact_get_handle (_tmp1_);
	folks_tp_lowlevel_channel_group_change_membership (channel, (guint) ((TpHandle) _tmp2_), is_member, message, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch13_g_error;
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		if (is_member == TRUE) {
			const gchar* _tmp3_ = NULL;
			const gchar* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			_tmp3_ = _ ("Failed to add persona '%s' to contact list '%s': %s");
			_tmp4_ = folks_persona_get_uid (persona);
			_tmp5_ = tp_channel_get_identifier (channel);
			g_warning (_tmp3_, _tmp4_, _tmp5_, e->message);
		} else {
			const gchar* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			_tmp6_ = _ ("Failed to remove persona '%s' from contact list '%s': %s");
			_tmp7_ = folks_persona_get_uid (persona);
			_tmp8_ = tp_channel_get_identifier (channel);
			g_warning (_tmp6_, _tmp7_, _tmp8_, e->message);
		}
		_g_error_free0 (e);
	}
	__finally13:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (tp_persona);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (tp_persona);
}


static void _tpf_persona_store_add_standard_channel_data_free (gpointer _data) {
	TpfPersonaStoreAddStandardChannelData* data;
	data = _data;
	_g_object_unref0 (data->conn);
	_g_free0 (data->name);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (TpfPersonaStoreAddStandardChannelData, data);
}


static void _tpf_persona_store_add_standard_channel (TpfPersonaStore* self, TpConnection* conn, const gchar* name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreAddStandardChannelData* _data_;
	_data_ = g_slice_new0 (TpfPersonaStoreAddStandardChannelData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_add_standard_channel);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_add_standard_channel_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->conn = _g_object_ref0 (conn);
	_data_->name = g_strdup (name);
	_tpf_persona_store_add_standard_channel_co (_data_);
}


static TpChannel* _tpf_persona_store_add_standard_channel_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpChannel* result;
	TpfPersonaStoreAddStandardChannelData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void _tpf_persona_store_add_standard_channel_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreAddStandardChannelData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_tpf_persona_store_add_standard_channel_co (data);
}


static gboolean _tpf_persona_store_add_standard_channel_co (TpfPersonaStoreAddStandardChannelData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->channel = NULL;
	g_debug ("tpf-persona-store.vala:1210: Adding standard channel '%s' to connectio" \
"n %p", data->name, data->conn);
	data->_state_ = 1;
	folks_tp_lowlevel_connection_open_contact_list_channel_async (data->self->priv->_ll, data->conn, data->name, _tpf_persona_store_add_standard_channel_ready, data);
	return FALSE;
	_state_1:
	data->_tmp0_ = NULL;
	data->_tmp0_ = folks_tp_lowlevel_connection_open_contact_list_channel_finish (data->self->priv->_ll, data->_res_, &data->_inner_error_);
	data->_tmp1_ = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		goto __catch14_g_error;
	}
	data->_tmp2_ = _g_object_ref0 (data->_tmp1_);
	_g_object_unref0 (data->channel);
	data->channel = data->_tmp2_;
	goto __finally14;
	__catch14_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_debug ("tpf-persona-store.vala:1220: Failed to add channel '%s': %s\n", data->name, data->e->message);
		data->result = NULL;
		_g_error_free0 (data->e);
		_g_object_unref0 (data->channel);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally14:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->channel);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_tpf_persona_store_set_up_new_standard_channel (data->self, data->channel);
	data->result = data->channel;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->channel);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _tpf_persona_store_create_personas_from_channel_handles_async_data_free (gpointer _data) {
	TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData* data;
	data = _data;
	_g_object_unref0 (data->channel);
	_g_array_unref0 (data->channel_handles);
	_g_object_unref0 (data->self);
	g_slice_free (TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData, data);
}


static void _tpf_persona_store_create_personas_from_channel_handles_async (TpfPersonaStore* self, TpChannel* channel, GArray* channel_handles, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData* _data_;
	_data_ = g_slice_new0 (TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_create_personas_from_channel_handles_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_create_personas_from_channel_handles_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->channel = _g_object_ref0 (channel);
	_data_->channel_handles = _g_array_ref0 (channel_handles);
	_tpf_persona_store_create_personas_from_channel_handles_async_co (_data_);
}


static void _tpf_persona_store_create_personas_from_channel_handles_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _vala_array_add1 (guint** array, int* length, int* size, guint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _tpf_persona_store_create_personas_from_channel_handles_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_tpf_persona_store_create_personas_from_channel_handles_async_co (data);
}


static gboolean _tpf_persona_store_create_personas_from_channel_handles_async_co (TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_new0 (guint, 0);
	data->contact_handles = data->_tmp0_;
	data->contact_handles_length1 = 0;
	data->_contact_handles_size_ = 0;
	{
		data->i = 0;
		{
			data->_tmp1_ = TRUE;
			while (TRUE) {
				if (!data->_tmp1_) {
					data->i++;
				}
				data->_tmp1_ = FALSE;
				if (!(data->i < data->channel_handles->len)) {
					break;
				}
				data->_tmp2_ = g_array_index (data->channel_handles, guint, (guint) data->i);
				data->channel_handle = (TpHandle) data->_tmp2_;
				data->_tmp3_ = tp_channel_group_get_handle_owner (data->channel, data->channel_handle);
				data->contact_handle = data->_tmp3_;
				data->_tmp4_ = NULL;
				data->_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) data->self->priv->_handle_persona_map, GUINT_TO_POINTER ((guint) data->contact_handle));
				data->persona = (TpfPersona*) data->_tmp4_;
				if (data->persona == NULL) {
					_vala_array_add1 (&data->contact_handles, &data->contact_handles_length1, &data->_contact_handles_size_, (guint) data->contact_handle);
				} else {
					data->_tmp5_ = NULL;
					data->_tmp5_ = folks_persona_get_uid ((FolksPersona*) data->persona);
					g_debug ("tpf-persona-store.vala:1256: Setting is-in-contact-list for '%s' to tr" \
"ue", data->_tmp5_);
					tpf_persona_set_is_in_contact_list (data->persona, TRUE);
				}
				_g_object_unref0 (data->persona);
			}
		}
	}
	if (data->contact_handles_length1 < 1) {
		data->contact_handles = (g_free (data->contact_handles), NULL);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_state_ = 1;
	folks_tp_lowlevel_connection_get_contacts_by_handle_async (data->self->priv->_ll, data->self->priv->_conn, data->contact_handles, data->contact_handles_length1, (guint*) tpf_persona_store__contact_features, tpf_persona_store__contact_features_length1, _tpf_persona_store_create_personas_from_channel_handles_async_ready, data);
	return FALSE;
	_state_1:
	data->_tmp6_ = NULL;
	data->_tmp6_ = folks_tp_lowlevel_connection_get_contacts_by_handle_finish (data->self->priv->_ll, data->_res_, &data->_inner_error_);
	data->contacts = data->_tmp6_;
	if (data->_inner_error_ != NULL) {
		goto __catch15_g_error;
	}
	if (data->contacts == NULL) {
		data->_tmp7_ = TRUE;
	} else {
		data->_tmp8_ = g_list_length (data->contacts);
		data->_tmp7_ = data->_tmp8_ < 1;
	}
	if (data->_tmp7_) {
		__g_list_free__g_object_unref0_0 (data->contacts);
		data->contact_handles = (g_free (data->contact_handles), NULL);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp9_ = g_list_length (data->contacts);
	data->_tmp10_ = NULL;
	data->_tmp10_ = g_new0 (TpContact*, data->_tmp9_ + 1);
	data->contacts_array = data->_tmp10_;
	data->contacts_array_length1 = data->_tmp9_;
	data->_contacts_array_size_ = data->_tmp9_;
	data->j = 0;
	data->l = data->contacts;
	{
		data->_tmp11_ = TRUE;
		while (TRUE) {
			if (!data->_tmp11_) {
				data->l = data->l->next;
			}
			data->_tmp11_ = FALSE;
			if (!(data->l != NULL)) {
				break;
			}
			data->_tmp12_ = _g_object_ref0 ((TpContact*) data->l->data);
			data->_tmp13_ = data->_tmp12_;
			_g_object_unref0 (data->contacts_array[data->j]);
			data->contacts_array[data->j] = data->_tmp13_;
			data->j++;
		}
	}
	_tpf_persona_store_add_new_personas_from_contacts (data->self, data->contacts_array, data->contacts_array_length1);
	data->contacts_array = (_vala_array_free (data->contacts_array, data->contacts_array_length1, (GDestroyNotify) g_object_unref), NULL);
	__g_list_free__g_object_unref0_0 (data->contacts);
	goto __finally15;
	__catch15_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp14_ = NULL;
		data->_tmp14_ = _ ("Failed to create personas from incoming contacts in channel '%s': %s");
		data->_tmp15_ = NULL;
		data->_tmp15_ = tp_channel_get_identifier (data->channel);
		g_warning (data->_tmp14_, data->_tmp15_, data->e->message);
		_g_error_free0 (data->e);
	}
	__finally15:
	if (data->_inner_error_ != NULL) {
		data->contact_handles = (g_free (data->contact_handles), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->contact_handles = (g_free (data->contact_handles), NULL);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _tpf_persona_store_create_personas_from_contact_ids_data_free (gpointer _data) {
	TpfPersonaStoreCreatePersonasFromContactIdsData* data;
	data = _data;
	data->contact_ids = (_vala_array_free (data->contact_ids, data->contact_ids_length1, (GDestroyNotify) g_free), NULL);
	__g_list_free__g_object_unref0_0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (TpfPersonaStoreCreatePersonasFromContactIdsData, data);
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static void _tpf_persona_store_create_personas_from_contact_ids (TpfPersonaStore* self, gchar** contact_ids, int contact_ids_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreCreatePersonasFromContactIdsData* _data_;
	gchar** _tmp0_;
	_data_ = g_slice_new0 (TpfPersonaStoreCreatePersonasFromContactIdsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_create_personas_from_contact_ids);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_create_personas_from_contact_ids_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->contact_ids = (_tmp0_ = contact_ids, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup1 (_tmp0_, contact_ids_length1));
	_data_->contact_ids_length1 = contact_ids_length1;
	_tpf_persona_store_create_personas_from_contact_ids_co (_data_);
}


static GList* _tpf_persona_store_create_personas_from_contact_ids_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error) {
	GList* result;
	TpfPersonaStoreCreatePersonasFromContactIdsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void _tpf_persona_store_create_personas_from_contact_ids_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreCreatePersonasFromContactIdsData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_tpf_persona_store_create_personas_from_contact_ids_co (data);
}


static gboolean _tpf_persona_store_create_personas_from_contact_ids_co (TpfPersonaStoreCreatePersonasFromContactIdsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (data->contact_ids_length1 > 0) {
		data->_state_ = 1;
		folks_tp_lowlevel_connection_get_contacts_by_id_async (data->self->priv->_ll, data->self->priv->_conn, data->contact_ids, data->contact_ids_length1, (guint*) tpf_persona_store__contact_features, tpf_persona_store__contact_features_length1, _tpf_persona_store_create_personas_from_contact_ids_ready, data);
		return FALSE;
		_state_1:
		data->_tmp0_ = NULL;
		data->_tmp0_ = folks_tp_lowlevel_connection_get_contacts_by_id_finish (data->self->priv->_ll, data->_res_, &data->_inner_error_);
		data->contacts = data->_tmp0_;
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		data->personas = NULL;
		data->err_count = 0;
		data->_tmp1_ = g_strdup ("");
		data->err_string = data->_tmp1_;
		{
			data->l = data->contacts;
			data->_tmp2_ = TRUE;
			while (TRUE) {
				if (!data->_tmp2_) {
					data->l = data->l->next;
				}
				data->_tmp2_ = FALSE;
				if (!(data->l != NULL)) {
					break;
				}
				data->_tmp3_ = _g_object_ref0 ((TpContact*) data->l->data);
				data->contact = data->_tmp3_;
				data->_tmp4_ = NULL;
				data->_tmp4_ = tp_contact_get_identifier (data->contact);
				g_debug ("tpf-persona-store.vala:1312: Creating persona from contact '%s'", data->_tmp4_);
				data->_tmp5_ = NULL;
				data->_tmp5_ = _tpf_persona_store_add_persona_from_contact (data->self, data->contact, TRUE);
				data->persona = data->_tmp5_;
				if (data->persona != NULL) {
					data->_tmp6_ = _g_object_ref0 (data->persona);
					data->personas = g_list_prepend (data->personas, data->_tmp6_);
				}
				_g_object_unref0 (data->persona);
				_g_object_unref0 (data->contact);
			}
		}
		if (data->err_count > 0) {
			data->_tmp7_ = NULL;
			data->_tmp7_ = ngettext ("Failed to create %u persona:\n%s", "Failed to create %u personas:\n%s", (gulong) data->err_count);
			data->_tmp8_ = NULL;
			data->_tmp8_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_CREATE_FAILED, data->_tmp7_, data->err_count, data->err_string);
			data->_inner_error_ = data->_tmp8_;
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_free0 (data->err_string);
			__g_list_free__g_object_unref0_0 (data->personas);
			__g_list_free__g_object_unref0_0 (data->contacts);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		if (data->personas != NULL) {
			g_signal_emit_by_name ((FolksPersonaStore*) data->self, "personas-changed", data->personas, NULL, NULL, NULL, 0);
		}
		data->result = data->personas;
		_g_free0 (data->err_string);
		__g_list_free__g_object_unref0_0 (data->contacts);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->result = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static TpfPersona* _tpf_persona_store_add_persona_from_contact (TpfPersonaStore* self, TpContact* contact, gboolean from_contact_list) {
	TpfPersona* result = NULL;
	TpHandle _tmp0_;
	TpHandle h;
	TpfPersona* persona;
	const gchar* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (contact != NULL, NULL);
	_tmp0_ = tp_contact_get_handle (contact);
	h = _tmp0_;
	persona = NULL;
	_tmp1_ = tp_contact_get_identifier (contact);
	g_debug ("tpf-persona-store.vala:1346: Adding persona from contact '%s'", _tmp1_);
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->_handle_persona_map, GUINT_TO_POINTER ((guint) h));
	_g_object_unref0 (persona);
	persona = (TpfPersona*) _tmp2_;
	if (persona == NULL) {
		TpfPersona* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		TpfPersona* _tmp6_;
		gboolean _tmp7_;
		_tmp3_ = tpf_persona_new (contact, self);
		_g_object_unref0 (persona);
		persona = _tmp3_;
		_tmp4_ = folks_persona_get_iid ((FolksPersona*) persona);
		_tmp5_ = g_strdup (_tmp4_);
		_tmp6_ = _g_object_ref0 (persona);
		g_hash_table_insert (self->priv->_personas, _tmp5_, _tmp6_);
		gee_abstract_map_set ((GeeAbstractMap*) self->priv->_handle_persona_map, GUINT_TO_POINTER ((guint) h), persona);
		_tmp7_ = gee_abstract_collection_contains ((GeeAbstractCollection*) self->priv->_favourite_handles, GUINT_TO_POINTER ((guint) h));
		folks_favourite_details_set_is_favourite ((FolksFavouriteDetails*) persona, _tmp7_);
		if (from_contact_list == FALSE) {
			g_debug ("tpf-persona-store.vala:1366:     Setting is-in-contact-list to false");
		}
		tpf_persona_set_is_in_contact_list (persona, from_contact_list);
		result = persona;
		return result;
	} else {
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_;
		g_debug ("tpf-persona-store.vala:1375:     ...already exists.");
		_tmp9_ = tpf_persona_get_is_in_contact_list (persona);
		if (_tmp9_ == FALSE) {
			_tmp8_ = from_contact_list == TRUE;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			g_debug ("tpf-persona-store.vala:1385:     Setting is-in-contact-list to true");
			tpf_persona_set_is_in_contact_list (persona, TRUE);
		}
		result = NULL;
		_g_object_unref0 (persona);
		return result;
	}
	_g_object_unref0 (persona);
}


static void _tpf_persona_store_add_new_personas_from_contacts (TpfPersonaStore* self, TpContact** contacts, int contacts_length1) {
	GList* personas;
	g_return_if_fail (self != NULL);
	personas = NULL;
	{
		TpContact** contact_collection;
		int contact_collection_length1;
		int contact_it;
		contact_collection = contacts;
		contact_collection_length1 = contacts_length1;
		for (contact_it = 0; contact_it < contacts_length1; contact_it = contact_it + 1) {
			TpContact* _tmp0_;
			TpContact* contact;
			_tmp0_ = _g_object_ref0 (contact_collection[contact_it]);
			contact = _tmp0_;
			{
				TpfPersona* _tmp1_ = NULL;
				TpfPersona* persona;
				_tmp1_ = _tpf_persona_store_add_persona_from_contact (self, contact, TRUE);
				persona = _tmp1_;
				if (persona != NULL) {
					TpfPersona* _tmp2_;
					_tmp2_ = _g_object_ref0 (persona);
					personas = g_list_prepend (personas, _tmp2_);
				}
				_g_object_unref0 (persona);
				_g_object_unref0 (contact);
			}
		}
	}
	_tpf_persona_store_channel_groups_add_new_personas (self);
	if (personas != NULL) {
		g_signal_emit_by_name ((FolksPersonaStore*) self, "personas-changed", personas, NULL, NULL, NULL, 0);
	}
	__g_list_free__g_object_unref0_0 (personas);
}


static void _tpf_persona_store_channel_groups_add_new_personas (TpfPersonaStore* self) {
	g_return_if_fail (self != NULL);
	{
		GeeSet* _tmp0_ = NULL;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_ = NULL;
		GeeIterator* _tmp3_;
		GeeIterator* _entry_it;
		_tmp0_ = gee_map_get_entries ((GeeMap*) self->priv->_channel_group_incoming_adds);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_entry_it = _tmp3_;
		while (TRUE) {
			gboolean _tmp4_;
			gpointer _tmp5_ = NULL;
			GeeMapEntry* entry;
			gconstpointer _tmp6_ = NULL;
			TpChannel* _tmp7_;
			TpChannel* channel;
			GList* members_added;
			gpointer _tmp8_ = NULL;
			GeeHashSet* members;
			const gchar* _tmp10_ = NULL;
			gconstpointer _tmp11_ = NULL;
			GeeHashSet* _tmp12_;
			GeeHashSet* contact_handles;
			gboolean _tmp13_ = FALSE;
			gint _tmp25_;
			const gchar* _tmp26_ = NULL;
			gchar* _tmp27_;
			gchar* name;
			gboolean _tmp28_ = FALSE;
			gboolean _tmp29_;
			_tmp4_ = gee_iterator_next (_entry_it);
			if (!_tmp4_) {
				break;
			}
			_tmp5_ = gee_iterator_get (_entry_it);
			entry = (GeeMapEntry*) _tmp5_;
			_tmp6_ = gee_map_entry_get_key (entry);
			_tmp7_ = _g_object_ref0 (TP_CHANNEL ((TpChannel*) _tmp6_));
			channel = _tmp7_;
			members_added = NULL;
			_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->_channel_group_personas_map, channel);
			members = (GeeHashSet*) _tmp8_;
			if (members == NULL) {
				GeeHashSet* _tmp9_ = NULL;
				_tmp9_ = gee_hash_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
				_g_object_unref0 (members);
				members = _tmp9_;
			}
			_tmp10_ = tp_channel_get_identifier (channel);
			g_debug ("tpf-persona-store.vala:1420: Adding members to channel '%s':", _tmp10_);
			_tmp11_ = gee_map_entry_get_value (entry);
			_tmp12_ = _g_object_ref0 ((GeeHashSet*) _tmp11_);
			contact_handles = _tmp12_;
			if (contact_handles != NULL) {
				gint _tmp14_;
				_tmp14_ = gee_collection_get_size ((GeeCollection*) contact_handles);
				_tmp13_ = _tmp14_ > 0;
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				GeeHashSet* _tmp15_ = NULL;
				GeeHashSet* contact_handles_added;
				_tmp15_ = gee_hash_set_new (G_TYPE_UINT, NULL, NULL, NULL, NULL);
				contact_handles_added = _tmp15_;
				{
					GeeIterator* _tmp16_ = NULL;
					GeeIterator* _contact_handle_it;
					_tmp16_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) contact_handles);
					_contact_handle_it = _tmp16_;
					while (TRUE) {
						gboolean _tmp17_;
						gpointer _tmp18_ = NULL;
						guint contact_handle;
						gpointer _tmp19_ = NULL;
						TpfPersona* persona;
						_tmp17_ = gee_iterator_next (_contact_handle_it);
						if (!_tmp17_) {
							break;
						}
						_tmp18_ = gee_iterator_get (_contact_handle_it);
						contact_handle = GPOINTER_TO_UINT (_tmp18_);
						_tmp19_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->_handle_persona_map, GUINT_TO_POINTER (contact_handle));
						persona = (TpfPersona*) _tmp19_;
						if (persona != NULL) {
							const gchar* _tmp20_ = NULL;
							TpfPersona* _tmp21_;
							_tmp20_ = folks_persona_get_uid ((FolksPersona*) persona);
							g_debug ("tpf-persona-store.vala:1431:     %s", _tmp20_);
							gee_abstract_collection_add ((GeeAbstractCollection*) members, persona);
							_tmp21_ = _g_object_ref0 (persona);
							members_added = g_list_prepend (members_added, _tmp21_);
							gee_abstract_collection_add ((GeeAbstractCollection*) contact_handles_added, GUINT_TO_POINTER (contact_handle));
						}
						_g_object_unref0 (persona);
					}
					_g_object_unref0 (_contact_handle_it);
				}
				{
					GeeIterator* _tmp22_ = NULL;
					GeeIterator* _handle_it;
					_tmp22_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) contact_handles_added);
					_handle_it = _tmp22_;
					while (TRUE) {
						gboolean _tmp23_;
						gpointer _tmp24_ = NULL;
						guint handle;
						_tmp23_ = gee_iterator_next (_handle_it);
						if (!_tmp23_) {
							break;
						}
						_tmp24_ = gee_iterator_get (_handle_it);
						handle = GPOINTER_TO_UINT (_tmp24_);
						gee_abstract_collection_remove ((GeeAbstractCollection*) contact_handles, GUINT_TO_POINTER (handle));
					}
					_g_object_unref0 (_handle_it);
				}
				_g_object_unref0 (contact_handles_added);
			}
			_tmp25_ = gee_collection_get_size ((GeeCollection*) members);
			if (_tmp25_ > 0) {
				gee_abstract_map_set ((GeeAbstractMap*) self->priv->_channel_group_personas_map, channel, members);
			}
			_tmp26_ = tp_channel_get_identifier (channel);
			_tmp27_ = g_strdup (_tmp26_);
			name = _tmp27_;
			_tmp29_ = _tpf_persona_store_group_is_display_group (self, name);
			if (_tmp29_) {
				guint _tmp30_;
				_tmp30_ = g_list_length (members_added);
				_tmp28_ = _tmp30_ > 0;
			} else {
				_tmp28_ = FALSE;
			}
			if (_tmp28_) {
				members_added = g_list_reverse (members_added);
				g_signal_emit_by_name (self, "group-members-changed", name, members_added, NULL);
			}
			_g_free0 (name);
			_g_object_unref0 (contact_handles);
			_g_object_unref0 (members);
			__g_list_free__g_object_unref0_0 (members_added);
			_g_object_unref0 (channel);
			_g_object_unref0 (entry);
		}
		_g_object_unref0 (_entry_it);
	}
}


static gboolean _tpf_persona_store_group_is_display_group (TpfPersonaStore* self, const gchar* group) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (group != NULL, FALSE);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < tpf_persona_store__undisplayed_groups_length1)) {
					break;
				}
				if (g_strcmp0 (tpf_persona_store__undisplayed_groups[i], group) == 0) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static void tpf_persona_store_real_add_persona_from_details_data_free (gpointer _data) {
	TpfPersonaStoreAddPersonaFromDetailsData* data;
	data = _data;
	_g_hash_table_unref0 (data->details);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (TpfPersonaStoreAddPersonaFromDetailsData, data);
}


static void tpf_persona_store_real_add_persona_from_details (FolksPersonaStore* base, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStore * self;
	TpfPersonaStoreAddPersonaFromDetailsData* _data_;
	self = (TpfPersonaStore*) base;
	_data_ = g_slice_new0 (TpfPersonaStoreAddPersonaFromDetailsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_real_add_persona_from_details);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_real_add_persona_from_details_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->details = _g_hash_table_ref0 (details);
	tpf_persona_store_real_add_persona_from_details_co (_data_);
}


static FolksPersona* tpf_persona_store_real_add_persona_from_details_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	FolksPersona* result;
	TpfPersonaStoreAddPersonaFromDetailsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
   * Add a new {@link Persona} to the PersonaStore.
   *
   * See {@link Folks.PersonaStore.add_persona_from_details}.
   */
static void tpf_persona_store_add_persona_from_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreAddPersonaFromDetailsData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tpf_persona_store_real_add_persona_from_details_co (data);
}


static gboolean tpf_persona_store_real_add_persona_from_details_co (TpfPersonaStoreAddPersonaFromDetailsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = tp_asv_get_string (data->details, "contact");
	data->_tmp1_ = g_strdup (data->_tmp0_);
	data->contact_id = data->_tmp1_;
	if (data->contact_id == NULL) {
		data->_tmp2_ = NULL;
		data->_tmp2_ = _ ("Persona store (%s, %s) requires the following details:\n" \
"    contact (provided: '%s')\n");
		data->_tmp3_ = NULL;
		data->_tmp3_ = folks_persona_store_get_type_id ((FolksPersonaStore*) data->self);
		data->_tmp4_ = NULL;
		data->_tmp4_ = folks_persona_store_get_id ((FolksPersonaStore*) data->self);
		data->_tmp5_ = NULL;
		data->_tmp5_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_INVALID_ARGUMENT, data->_tmp2_, data->_tmp3_, data->_tmp4_, data->contact_id);
		data->_inner_error_ = data->_tmp5_;
		if (data->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_free0 (data->contact_id);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_free0 (data->contact_id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->_tmp6_ = NULL;
	data->_tmp6_ = tp_asv_get_string (data->details, "message");
	data->_tmp7_ = g_strdup (data->_tmp6_);
	data->add_message = data->_tmp7_;
	if (g_strcmp0 (data->add_message, "") == 0) {
		_g_free0 (data->add_message);
		data->add_message = NULL;
	}
	data->_tmp8_ = tp_account_get_connection_status (data->self->priv->_account, NULL);
	data->status = data->_tmp8_;
	if (data->status == TP_CONNECTION_STATUS_DISCONNECTED) {
		data->_tmp10_ = TRUE;
	} else {
		data->_tmp10_ = data->status == TP_CONNECTION_STATUS_CONNECTING;
	}
	if (data->_tmp10_) {
		data->_tmp9_ = TRUE;
	} else {
		data->_tmp9_ = data->self->priv->_conn == NULL;
	}
	if (data->_tmp9_) {
		data->_tmp11_ = NULL;
		data->_tmp11_ = _ ("Cannot create a new persona while offline.");
		data->_tmp12_ = NULL;
		data->_tmp12_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE, data->_tmp11_);
		data->_inner_error_ = data->_tmp12_;
		if (data->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_free0 (data->add_message);
			_g_free0 (data->contact_id);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_free0 (data->add_message);
			_g_free0 (data->contact_id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->_tmp13_ = NULL;
	data->_tmp13_ = g_new0 (gchar*, 1 + 1);
	data->contact_ids = data->_tmp13_;
	data->contact_ids_length1 = 1;
	data->_contact_ids_size_ = 1;
	data->_tmp14_ = g_strdup (data->contact_id);
	data->_tmp15_ = data->_tmp14_;
	_g_free0 (data->contact_ids[0]);
	data->contact_ids[0] = data->_tmp15_;
	data->_state_ = 1;
	_tpf_persona_store_create_personas_from_contact_ids (data->self, data->contact_ids, data->contact_ids_length1, tpf_persona_store_add_persona_from_details_ready, data);
	return FALSE;
	_state_1:
	data->_tmp16_ = NULL;
	data->_tmp16_ = _tpf_persona_store_create_personas_from_contact_ids_finish (data->self, data->_res_, &data->_inner_error_);
	data->personas = data->_tmp16_;
	if (data->_inner_error_ != NULL) {
		goto __catch16_g_error;
	}
	if (data->personas == NULL) {
		data->result = NULL;
		__g_list_free__g_object_unref0_0 (data->personas);
		data->contact_ids = (_vala_array_free (data->contact_ids, data->contact_ids_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (data->add_message);
		_g_free0 (data->contact_id);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	} else {
		data->_tmp17_ = g_list_length (data->personas);
		if (data->_tmp17_ == 1) {
			data->_tmp18_ = _g_object_ref0 ((TpfPersona*) data->personas->data);
			data->persona = data->_tmp18_;
			if (data->self->priv->_subscribe != NULL) {
				_tpf_persona_store_change_standard_contact_list_membership (data->self, data->self->priv->_subscribe, (FolksPersona*) data->persona, TRUE, data->add_message);
			}
			if (data->self->priv->_publish != NULL) {
				data->_tmp19_ = tp_channel_group_get_flags (data->self->priv->_publish);
				data->flags = data->_tmp19_;
				if ((data->flags & TP_CHANNEL_GROUP_FLAG_CAN_ADD) == TP_CHANNEL_GROUP_FLAG_CAN_ADD) {
					_tpf_persona_store_change_standard_contact_list_membership (data->self, data->self->priv->_publish, (FolksPersona*) data->persona, TRUE, data->add_message);
				}
			}
			data->result = (FolksPersona*) data->persona;
			__g_list_free__g_object_unref0_0 (data->personas);
			data->contact_ids = (_vala_array_free (data->contact_ids, data->contact_ids_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (data->add_message);
			_g_free0 (data->contact_id);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			data->_tmp20_ = g_list_length (data->personas);
			data->num_personas = data->_tmp20_;
			data->_tmp21_ = NULL;
			data->_tmp21_ = ngettext ("Requested a single persona, but got %u persona back.", "Requested a single persona, but got %u personas back.", (gulong) data->num_personas);
			data->_tmp22_ = g_strdup (data->_tmp21_);
			data->message = data->_tmp22_;
			data->_tmp23_ = NULL;
			data->_tmp23_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_CREATE_FAILED, data->message, data->num_personas);
			data->_inner_error_ = data->_tmp23_;
			_g_free0 (data->message);
			__g_list_free__g_object_unref0_0 (data->personas);
			goto __catch16_g_error;
		}
	}
	__g_list_free__g_object_unref0_0 (data->personas);
	goto __finally16;
	__catch16_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp24_ = NULL;
		data->_tmp24_ = _ ("Failed to add a persona from details: %s");
		data->_tmp25_ = NULL;
		data->_tmp25_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_CREATE_FAILED, data->_tmp24_, data->e->message);
		data->_inner_error_ = data->_tmp25_;
		_g_error_free0 (data->e);
		goto __finally16;
	}
	__finally16:
	if (data->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		data->contact_ids = (_vala_array_free (data->contact_ids, data->contact_ids_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (data->add_message);
		_g_free0 (data->contact_id);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	} else {
		data->contact_ids = (_vala_array_free (data->contact_ids, data->contact_ids_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (data->add_message);
		_g_free0 (data->contact_id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->contact_ids = (_vala_array_free (data->contact_ids, data->contact_ids_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (data->add_message);
	_g_free0 (data->contact_id);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void tpf_persona_store_change_is_favourite_data_free (gpointer _data) {
	TpfPersonaStoreChangeIsFavouriteData* data;
	data = _data;
	_g_object_unref0 (data->persona);
	_g_object_unref0 (data->self);
	g_slice_free (TpfPersonaStoreChangeIsFavouriteData, data);
}


void tpf_persona_store_change_is_favourite (TpfPersonaStore* self, FolksPersona* persona, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreChangeIsFavouriteData* _data_;
	_data_ = g_slice_new0 (TpfPersonaStoreChangeIsFavouriteData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_change_is_favourite);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_change_is_favourite_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->persona = _g_object_ref0 (persona);
	_data_->is_favourite = is_favourite;
	tpf_persona_store_change_is_favourite_co (_data_);
}


void tpf_persona_store_change_is_favourite_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpfPersonaStoreChangeIsFavouriteData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Change the favourite status of a persona in this store.
   *
   * This function is idempotent, but relies upon having a connection to the
   * Telepathy logger service, so may fail if that connection is not present.
   */
static void tpf_persona_store_change_is_favourite_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreChangeIsFavouriteData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tpf_persona_store_change_is_favourite_co (data);
}


static gboolean tpf_persona_store_change_is_favourite_co (TpfPersonaStoreChangeIsFavouriteData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (data->self->priv->_logger == NULL) {
		data->_tmp0_ = NULL;
		data->_tmp0_ = _ ("Failed to change favorite without a connection to the telepathy-logger" \
" service.");
		g_warning ("tpf-persona-store.vala:1569: %s", data->_tmp0_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp1_ = NULL;
	data->_tmp1_ = tpf_persona_get_contact (TPF_PERSONA (data->persona));
	data->_tmp2_ = NULL;
	data->_tmp2_ = tp_contact_get_identifier (data->_tmp1_);
	data->id = data->_tmp2_;
	if (data->is_favourite) {
		data->_state_ = 1;
		logger_add_favourite_contact (data->self->priv->_logger, data->id, tpf_persona_store_change_is_favourite_ready, data);
		return FALSE;
		_state_1:
		logger_add_favourite_contact_finish (data->self->priv->_logger, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			if (data->_inner_error_->domain == DBUS_GERROR) {
				goto __catch17_dbus_gerror;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	} else {
		data->_state_ = 2;
		logger_remove_favourite_contact (data->self->priv->_logger, data->id, tpf_persona_store_change_is_favourite_ready, data);
		return FALSE;
		_state_2:
		logger_remove_favourite_contact_finish (data->self->priv->_logger, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			if (data->_inner_error_->domain == DBUS_GERROR) {
				goto __catch17_dbus_gerror;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	goto __finally17;
	__catch17_dbus_gerror:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp3_ = NULL;
		data->_tmp3_ = _ ("Failed to change a persona's favorite status.");
		g_warning ("tpf-persona-store.vala:1589: %s", data->_tmp3_);
		_g_error_free0 (data->e);
	}
	__finally17:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void tpf_persona_store_change_alias_data_free (gpointer _data) {
	TpfPersonaStoreChangeAliasData* data;
	data = _data;
	_g_object_unref0 (data->persona);
	_g_free0 (data->alias);
	_g_object_unref0 (data->self);
	g_slice_free (TpfPersonaStoreChangeAliasData, data);
}


void tpf_persona_store_change_alias (TpfPersonaStore* self, TpfPersona* persona, const gchar* alias, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreChangeAliasData* _data_;
	_data_ = g_slice_new0 (TpfPersonaStoreChangeAliasData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_change_alias);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_change_alias_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->persona = _g_object_ref0 (persona);
	_data_->alias = g_strdup (alias);
	tpf_persona_store_change_alias_co (_data_);
}


void tpf_persona_store_change_alias_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpfPersonaStoreChangeAliasData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean tpf_persona_store_change_alias_co (TpfPersonaStoreChangeAliasData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = tpf_persona_get_contact (data->persona);
	data->_tmp1_ = tp_contact_get_handle (data->_tmp0_);
	g_debug ("tpf-persona-store.vala:1595: Changing alias of persona %u to '%s'.", data->_tmp1_, data->alias);
	data->_tmp2_ = NULL;
	data->_tmp2_ = tpf_persona_get_contact (data->persona);
	data->_tmp3_ = tp_contact_get_handle (data->_tmp2_);
	folks_tp_lowlevel_connection_set_contact_alias (data->self->priv->_ll, data->self->priv->_conn, (guint) ((TpHandle) data->_tmp3_), data->alias);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


TpAccount* tpf_persona_store_get_account (TpfPersonaStore* self) {
	TpAccount* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_account;
	return result;
}


static void tpf_persona_store_set_account (TpfPersonaStore* self, TpAccount* value) {
	TpAccount* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_account);
	self->priv->_account = _tmp0_;
	g_object_notify ((GObject *) self, "account");
}


static const gchar* tpf_persona_store_real_get_type_id (FolksPersonaStore* base) {
	const gchar* result;
	TpfPersonaStore* self;
	self = (TpfPersonaStore*) base;
	result = BACKEND_NAME;
	return result;
}


static FolksMaybeBool tpf_persona_store_real_get_can_add_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	TpfPersonaStore* self;
	self = (TpfPersonaStore*) base;
	result = self->priv->_can_add_personas;
	return result;
}


static FolksMaybeBool tpf_persona_store_real_get_can_alias_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	TpfPersonaStore* self;
	self = (TpfPersonaStore*) base;
	result = self->priv->_can_alias_personas;
	return result;
}


static FolksMaybeBool tpf_persona_store_real_get_can_group_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	TpfPersonaStore* self;
	self = (TpfPersonaStore*) base;
	result = self->priv->_can_group_personas;
	return result;
}


static FolksMaybeBool tpf_persona_store_real_get_can_remove_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	TpfPersonaStore* self;
	self = (TpfPersonaStore*) base;
	result = self->priv->_can_remove_personas;
	return result;
}


static gboolean tpf_persona_store_real_get_is_prepared (FolksPersonaStore* base) {
	gboolean result;
	TpfPersonaStore* self;
	self = (TpfPersonaStore*) base;
	result = self->priv->_is_prepared;
	return result;
}


static GHashTable* tpf_persona_store_real_get_personas (FolksPersonaStore* base) {
	GHashTable* result;
	TpfPersonaStore* self;
	self = (TpfPersonaStore*) base;
	result = self->priv->_personas;
	return result;
}


static void g_cclosure_user_marshal_VOID__STRING_POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_POINTER_POINTER) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_POINTER_POINTER callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_POINTER_POINTER) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_pointer (param_values + 2), g_value_get_pointer (param_values + 3), data2);
}


static void g_cclosure_user_marshal_VOID__STRING_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_POINTER) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_POINTER callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_POINTER) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_pointer (param_values + 2), data2);
}


static void tpf_persona_store_class_init (TpfPersonaStoreClass * klass) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_ = NULL;
	TpContactFeature* _tmp8_ = NULL;
	tpf_persona_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TpfPersonaStorePrivate));
	FOLKS_PERSONA_STORE_CLASS (klass)->prepare = tpf_persona_store_real_prepare;
	FOLKS_PERSONA_STORE_CLASS (klass)->prepare_finish = tpf_persona_store_real_prepare_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->remove_persona = tpf_persona_store_real_remove_persona;
	FOLKS_PERSONA_STORE_CLASS (klass)->remove_persona_finish = tpf_persona_store_real_remove_persona_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->add_persona_from_details = tpf_persona_store_real_add_persona_from_details;
	FOLKS_PERSONA_STORE_CLASS (klass)->add_persona_from_details_finish = tpf_persona_store_real_add_persona_from_details_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_type_id = tpf_persona_store_real_get_type_id;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_add_personas = tpf_persona_store_real_get_can_add_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_alias_personas = tpf_persona_store_real_get_can_alias_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_group_personas = tpf_persona_store_real_get_can_group_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_remove_personas = tpf_persona_store_real_get_can_remove_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_is_prepared = tpf_persona_store_real_get_is_prepared;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_personas = tpf_persona_store_real_get_personas;
	G_OBJECT_CLASS (klass)->get_property = _vala_tpf_persona_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tpf_persona_store_set_property;
	G_OBJECT_CLASS (klass)->finalize = tpf_persona_store_finalize;
	/**
	   * The Telepathy account this store is based upon.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_ACCOUNT, g_param_spec_object ("account", "account", "account", TP_TYPE_ACCOUNT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * The type of persona store this is.
	   *
	   * See {@link Folks.PersonaStore.type_id}.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_TYPE_ID, "type-id");
	/**
	   * Whether this PersonaStore can add {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_add_personas}.
	   *
	   * @since 0.3.1
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_CAN_ADD_PERSONAS, "can-add-personas");
	/**
	   * Whether this PersonaStore can set the alias of {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_alias_personas}.
	   *
	   * @since 0.3.1
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_CAN_ALIAS_PERSONAS, "can-alias-personas");
	/**
	   * Whether this PersonaStore can set the groups of {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_group_personas}.
	   *
	   * @since 0.3.1
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_CAN_GROUP_PERSONAS, "can-group-personas");
	/**
	   * Whether this PersonaStore can remove {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_remove_personas}.
	   *
	   * @since 0.3.1
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_CAN_REMOVE_PERSONAS, "can-remove-personas");
	/**
	   * Whether this PersonaStore has been prepared.
	   *
	   * See {@link Folks.PersonaStore.is_prepared}.
	   *
	   * @since 0.3.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_IS_PREPARED, "is-prepared");
	/**
	   * The {@link Persona}s exposed by this PersonaStore.
	   *
	   * See {@link Folks.PersonaStore.personas}.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_PERSONAS, "personas");
	g_signal_new ("group_members_changed", TPF_TYPE_PERSONA_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_POINTER_POINTER, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_POINTER, G_TYPE_POINTER);
	g_signal_new ("group_removed", TPF_TYPE_PERSONA_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_POINTER, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_POINTER);
	_tmp0_ = g_strdup ("org.freedesktop.Telepathy.Channel");
	tpf_persona_store__tp_channel_iface = _tmp0_;
	_tmp1_ = g_strconcat (tpf_persona_store__tp_channel_iface, ".Type.ContactList", NULL);
	tpf_persona_store__tp_channel_contact_list_type = _tmp1_;
	_tmp2_ = g_strconcat (tpf_persona_store__tp_channel_iface, ".ChannelType", NULL);
	tpf_persona_store__tp_channel_channel_type = _tmp2_;
	_tmp3_ = g_strconcat (tpf_persona_store__tp_channel_iface, ".TargetHandleType", NULL);
	tpf_persona_store__tp_channel_handle_type = _tmp3_;
	_tmp4_ = g_strdup ("publish");
	_tmp5_ = g_strdup ("stored");
	_tmp6_ = g_strdup ("subscribe");
	_tmp7_ = g_new0 (gchar*, 3 + 1);
	_tmp7_[0] = _tmp4_;
	_tmp7_[1] = _tmp5_;
	_tmp7_[2] = _tmp6_;
	tpf_persona_store__undisplayed_groups = _tmp7_;
	tpf_persona_store__undisplayed_groups_length1 = 3;
	_tmp8_ = g_new0 (TpContactFeature, 6);
	_tmp8_[0] = TP_CONTACT_FEATURE_ALIAS;
	_tmp8_[1] = TP_CONTACT_FEATURE_AVATAR_DATA;
	_tmp8_[2] = TP_CONTACT_FEATURE_AVATAR_TOKEN;
	_tmp8_[3] = TP_CONTACT_FEATURE_CAPABILITIES;
	_tmp8_[4] = TP_CONTACT_FEATURE_CLIENT_TYPES;
	_tmp8_[5] = TP_CONTACT_FEATURE_PRESENCE;
	tpf_persona_store__contact_features = _tmp8_;
	tpf_persona_store__contact_features_length1 = 6;
}


static void tpf_persona_store_instance_init (TpfPersonaStore * self) {
	self->priv = TPF_PERSONA_STORE_GET_PRIVATE (self);
	self->priv->_can_add_personas = FOLKS_MAYBE_BOOL_UNSET;
	self->priv->_can_alias_personas = FOLKS_MAYBE_BOOL_UNSET;
	self->priv->_can_group_personas = FOLKS_MAYBE_BOOL_UNSET;
	self->priv->_can_remove_personas = FOLKS_MAYBE_BOOL_UNSET;
	g_static_rec_mutex_init (&self->priv->__lock__is_prepared);
	self->priv->_is_prepared = FALSE;
}


static void tpf_persona_store_finalize (GObject* obj) {
	TpfPersonaStore * self;
	self = TPF_PERSONA_STORE (obj);
	_g_hash_table_unref0 (self->priv->_personas);
	_g_object_unref0 (self->priv->_handle_persona_map);
	_g_object_unref0 (self->priv->_channel_group_personas_map);
	_g_object_unref0 (self->priv->_channel_group_incoming_adds);
	_g_object_unref0 (self->priv->_group_outgoing_adds);
	_g_object_unref0 (self->priv->_group_outgoing_removes);
	_g_object_unref0 (self->priv->_standard_channels_unready);
	_g_object_unref0 (self->priv->_group_channels_unready);
	_g_object_unref0 (self->priv->_groups);
	_g_object_unref0 (self->priv->_favourite_handles);
	_g_object_unref0 (self->priv->_publish);
	_g_object_unref0 (self->priv->_stored);
	_g_object_unref0 (self->priv->_subscribe);
	_g_object_unref0 (self->priv->_conn);
	_g_object_unref0 (self->priv->_ll);
	_g_object_unref0 (self->priv->_account_manager);
	_g_object_unref0 (self->priv->_logger);
	_g_object_unref0 (self->priv->_self_contact);
	g_static_rec_mutex_free (&self->priv->__lock__is_prepared);
	_g_object_unref0 (self->priv->_account);
	G_OBJECT_CLASS (tpf_persona_store_parent_class)->finalize (obj);
}


/**
 * A persona store which is associated with a single Telepathy account. It will
 * create {@link Persona}s for each of the contacts in the published, stored or
 * subscribed
 * [[http://people.collabora.co.uk/~danni/telepathy-book/chapter.channel.html|channels]]
 * of the account.
 */
GType tpf_persona_store_get_type (void) {
	static volatile gsize tpf_persona_store_type_id__volatile = 0;
	if (g_once_init_enter (&tpf_persona_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TpfPersonaStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tpf_persona_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TpfPersonaStore), 0, (GInstanceInitFunc) tpf_persona_store_instance_init, NULL };
		GType tpf_persona_store_type_id;
		tpf_persona_store_type_id = g_type_register_static (FOLKS_TYPE_PERSONA_STORE, "TpfPersonaStore", &g_define_type_info, 0);
		g_once_init_leave (&tpf_persona_store_type_id__volatile, tpf_persona_store_type_id);
	}
	return tpf_persona_store_type_id__volatile;
}


static void _vala_tpf_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TpfPersonaStore * self;
	self = TPF_PERSONA_STORE (object);
	switch (property_id) {
		case TPF_PERSONA_STORE_ACCOUNT:
		g_value_set_object (value, tpf_persona_store_get_account (self));
		break;
		case TPF_PERSONA_STORE_TYPE_ID:
		g_value_set_string (value, folks_persona_store_get_type_id ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_CAN_ADD_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_add_personas ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_CAN_ALIAS_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_alias_personas ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_CAN_GROUP_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_group_personas ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_CAN_REMOVE_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_remove_personas ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_IS_PREPARED:
		g_value_set_boolean (value, folks_persona_store_get_is_prepared ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_PERSONAS:
		g_value_set_boxed (value, folks_persona_store_get_personas ((FolksPersonaStore*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tpf_persona_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TpfPersonaStore * self;
	self = TPF_PERSONA_STORE (object);
	switch (property_id) {
		case TPF_PERSONA_STORE_ACCOUNT:
		tpf_persona_store_set_account (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



