/* field-details.c generated by valac 0.11.7, the Vala compiler
 * generated from field-details.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Marco Barisione <marco.barisione@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define FOLKS_TYPE_FIELD_DETAILS (folks_field_details_get_type ())
#define FOLKS_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_FIELD_DETAILS, FolksFieldDetails))
#define FOLKS_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_FIELD_DETAILS, FolksFieldDetailsClass))
#define FOLKS_IS_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_FIELD_DETAILS))
#define FOLKS_IS_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_FIELD_DETAILS))
#define FOLKS_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_FIELD_DETAILS, FolksFieldDetailsClass))

typedef struct _FolksFieldDetails FolksFieldDetails;
typedef struct _FolksFieldDetailsClass FolksFieldDetailsClass;
typedef struct _FolksFieldDetailsPrivate FolksFieldDetailsPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))

struct _FolksFieldDetails {
	GObject parent_instance;
	FolksFieldDetailsPrivate * priv;
};

struct _FolksFieldDetailsClass {
	GObjectClass parent_class;
};

struct _FolksFieldDetailsPrivate {
	gchar* _value;
	GHashTable* _parameters;
};


static gpointer folks_field_details_parent_class = NULL;

GType folks_field_details_get_type (void) G_GNUC_CONST;
#define FOLKS_FIELD_DETAILS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_FIELD_DETAILS, FolksFieldDetailsPrivate))
enum  {
	FOLKS_FIELD_DETAILS_DUMMY_PROPERTY,
	FOLKS_FIELD_DETAILS_VALUE,
	FOLKS_FIELD_DETAILS_PARAMETERS
};
FolksFieldDetails* folks_field_details_new (const gchar* value);
FolksFieldDetails* folks_field_details_construct (GType object_type, const gchar* value);
void folks_field_details_set_value (FolksFieldDetails* self, const gchar* value);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void __g_list_free__g_free0_0_ (gpointer var);
void folks_field_details_set_parameters (FolksFieldDetails* self, GHashTable* value);
GList* folks_field_details_get_parameter_values (FolksFieldDetails* self, const gchar* parameter_name);
GHashTable* folks_field_details_get_parameters (FolksFieldDetails* self);
void folks_field_details_add_parameter (FolksFieldDetails* self, const gchar* parameter_name, const gchar* parameter_value);
void folks_field_details_set_parameter (FolksFieldDetails* self, const gchar* parameter_name, const gchar* parameter_value);
void folks_field_details_extend_parameters (FolksFieldDetails* self, GHashTable* additional);
void folks_field_details_remove_parameter_all (FolksFieldDetails* self, const gchar* parameter_name);
const gchar* folks_field_details_get_value (FolksFieldDetails* self);
static void folks_field_details_finalize (GObject* obj);
static void _vala_folks_field_details_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_field_details_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
   * Create a new FieldDetails.
   *
   * @param value the value of the field
   * @return a new FieldDetails
   *
   * @since 0.3.5
   */
static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void __g_list_free__g_free0_0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL));
}


FolksFieldDetails* folks_field_details_construct (GType object_type, const gchar* value) {
	FolksFieldDetails * self = NULL;
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_;
	g_return_val_if_fail (value != NULL, NULL);
	self = (FolksFieldDetails*) g_object_new (object_type, NULL);
	folks_field_details_set_value (self, value);
	_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, __g_list_free__g_free0_0_);
	_tmp1_ = _tmp0_;
	folks_field_details_set_parameters (self, _tmp1_);
	_g_hash_table_unref0 (_tmp1_);
	return self;
}


FolksFieldDetails* folks_field_details_new (const gchar* value) {
	return folks_field_details_construct (FOLKS_TYPE_FIELD_DETAILS, value);
}


/**
   * Get the values for a parameter
   *
   * @param parameter_name the parameter name
   * @return a list of values for `parameter_name` or `null` (i.e. an empty
   * list) if there are no such parameters.
   *
   * @since 0.3.5
   */
GList* folks_field_details_get_parameter_values (FolksFieldDetails* self, const gchar* parameter_name) {
	GList* result = NULL;
	gconstpointer _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (parameter_name != NULL, NULL);
	_tmp0_ = g_hash_table_lookup (self->priv->_parameters, parameter_name);
	result = (GList*) _tmp0_;
	return result;
}


/**
   * Add a new value for a parameter.
   *
   * If there is already a parameter called `parameter_name` then
   * `parameter_value` is added to the existing ones.
   *
   * @param parameter_name the name of the parameter
   * @param parameter_value the value to add
   *
   * @since 0.3.5
   */
void folks_field_details_add_parameter (FolksFieldDetails* self, const gchar* parameter_name, const gchar* parameter_value) {
	gconstpointer _tmp0_ = NULL;
	GList* values;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parameter_name != NULL);
	g_return_if_fail (parameter_value != NULL);
	_tmp0_ = g_hash_table_lookup (self->priv->_parameters, parameter_name);
	values = (GList*) _tmp0_;
	if (values == NULL) {
		GList* new_values;
		gchar* _tmp1_;
		gchar* _tmp2_;
		GList* _tmp3_;
		new_values = NULL;
		_tmp1_ = g_strdup (parameter_value);
		new_values = g_list_append (new_values, _tmp1_);
		_tmp2_ = g_strdup (parameter_name);
		_tmp3_ = new_values;
		new_values = NULL;
		g_hash_table_insert (self->priv->_parameters, _tmp2_, _tmp3_);
		__g_list_free__g_free0_0 (new_values);
	} else {
		GList* _tmp4_ = NULL;
		_tmp4_ = g_list_find_custom (values, parameter_value, g_strcmp0);
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = g_strdup (parameter_value);
			values = g_list_append (values, _tmp5_);
		}
	}
}


/**
   * Set the value of a parameter.
   *
   * Sets the parameter called `parameter_name` to be `parameter_value`.
   * If there were already parameters with the same name they are replaced.
   *
   * @param parameter_name the name of the parameter
   * @param parameter_value the value to add
   *
   * @since 0.3.5
   */
void folks_field_details_set_parameter (FolksFieldDetails* self, const gchar* parameter_name, const gchar* parameter_value) {
	GList* values;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parameter_name != NULL);
	g_return_if_fail (parameter_value != NULL);
	values = NULL;
	_tmp0_ = g_strdup (parameter_value);
	values = g_list_append (values, _tmp0_);
	_tmp1_ = g_strdup (parameter_name);
	_tmp2_ = values;
	values = NULL;
	g_hash_table_insert (self->priv->_parameters, _tmp1_, _tmp2_);
	__g_list_free__g_free0_0 (values);
}


/**
   * Extend the existing parameters.
   *
   * Merge the parameters from `additional` into the existing ones.
   *
   * @param additional the parameters to add
   *
   * @since 0.3.5
   */
void folks_field_details_extend_parameters (FolksFieldDetails* self, GHashTable* additional) {
	GHashTableIter iter = {0};
	const gchar* name = NULL;
	GList* values = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (additional != NULL);
	g_hash_table_iter_init (&iter, additional);
	while (TRUE) {
		gconstpointer _tmp0_ = NULL;
		gconstpointer _tmp1_ = NULL;
		gboolean _tmp2_;
		_tmp2_ = g_hash_table_iter_next (&iter, &_tmp0_, &_tmp1_);
		name = _tmp0_;
		values = _tmp1_;
		if (!_tmp2_) {
			break;
		}
		{
			GList* val_collection;
			GList* val_it;
			val_collection = values;
			for (val_it = val_collection; val_it != NULL; val_it = val_it->next) {
				const gchar* val;
				val = (const gchar*) val_it->data;
				{
					folks_field_details_add_parameter (self, name, val);
				}
			}
		}
	}
}


/**
   * Remove all instances of a parameter.
   *
   * @param parameter_name the name of the parameter
   *
   * @since 0.3.5
   */
void folks_field_details_remove_parameter_all (FolksFieldDetails* self, const gchar* parameter_name) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (parameter_name != NULL);
	g_hash_table_remove (self->priv->_parameters, parameter_name);
}


const gchar* folks_field_details_get_value (FolksFieldDetails* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_value;
	return result;
}


void folks_field_details_set_value (FolksFieldDetails* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_value);
	self->priv->_value = _tmp0_;
	g_object_notify ((GObject *) self, "value");
}


GHashTable* folks_field_details_get_parameters (FolksFieldDetails* self) {
	GHashTable* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_parameters;
	return result;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


void folks_field_details_set_parameters (FolksFieldDetails* self, GHashTable* value) {
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_hash_table_ref0 (value);
	_g_hash_table_unref0 (self->priv->_parameters);
	self->priv->_parameters = _tmp0_;
	g_object_notify ((GObject *) self, "parameters");
}


static void folks_field_details_class_init (FolksFieldDetailsClass * klass) {
	folks_field_details_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksFieldDetailsPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_field_details_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_field_details_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_field_details_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_FIELD_DETAILS_VALUE, g_param_spec_string ("value", "value", "value", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The parameters associated with the value.
	   *
	   * A hash table of the parameters associated with
	   * {@link Folks.FieldDetails.value}. The keys are the names of the
	   * parameters, while the values are a list of strings.
	   *
	   * @since 0.3.5
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_FIELD_DETAILS_PARAMETERS, g_param_spec_boxed ("parameters", "parameters", "parameters", G_TYPE_HASH_TABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void folks_field_details_instance_init (FolksFieldDetails * self) {
	self->priv = FOLKS_FIELD_DETAILS_GET_PRIVATE (self);
}


static void folks_field_details_finalize (GObject* obj) {
	FolksFieldDetails * self;
	self = FOLKS_FIELD_DETAILS (obj);
	_g_free0 (self->priv->_value);
	_g_hash_table_unref0 (self->priv->_parameters);
	G_OBJECT_CLASS (folks_field_details_parent_class)->finalize (obj);
}


/**
 * Object representing a string value that can have some parameters
 * associated with it.
 *
 * Some contact details, like phone numbers or URLs, can have some
 * extra details associated with them.
 * For instance, a phone number expressed in vcard notation as
 * `tel;type=work,voice:(111) 555-1234` would be represented as
 * a FieldDetails with value "(111) 555-1234" and with parameters
 * `['type': ('work', 'voice')]`.
 *
 * @since 0.3.5
 */
GType folks_field_details_get_type (void) {
	static volatile gsize folks_field_details_type_id__volatile = 0;
	if (g_once_init_enter (&folks_field_details_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksFieldDetailsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_field_details_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksFieldDetails), 0, (GInstanceInitFunc) folks_field_details_instance_init, NULL };
		GType folks_field_details_type_id;
		folks_field_details_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksFieldDetails", &g_define_type_info, 0);
		g_once_init_leave (&folks_field_details_type_id__volatile, folks_field_details_type_id);
	}
	return folks_field_details_type_id__volatile;
}


static void _vala_folks_field_details_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksFieldDetails * self;
	self = FOLKS_FIELD_DETAILS (object);
	switch (property_id) {
		case FOLKS_FIELD_DETAILS_VALUE:
		g_value_set_string (value, folks_field_details_get_value (self));
		break;
		case FOLKS_FIELD_DETAILS_PARAMETERS:
		g_value_set_boxed (value, folks_field_details_get_parameters (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_field_details_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksFieldDetails * self;
	self = FOLKS_FIELD_DETAILS (object);
	switch (property_id) {
		case FOLKS_FIELD_DETAILS_VALUE:
		folks_field_details_set_value (self, g_value_get_string (value));
		break;
		case FOLKS_FIELD_DETAILS_PARAMETERS:
		folks_field_details_set_parameters (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



