/* url-details-interface.c generated by valac 0.12.0, the Vala compiler
 * generated from url-details-interface.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <folks-test.h>
#include <folks.h>
#include <tracker-test.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <folks-tracker.h>
#include <gio/gio.h>


#define TYPE_URL_DETAILS_INTERFACE_TESTS (url_details_interface_tests_get_type ())
#define URL_DETAILS_INTERFACE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_URL_DETAILS_INTERFACE_TESTS, UrlDetailsInterfaceTests))
#define URL_DETAILS_INTERFACE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_URL_DETAILS_INTERFACE_TESTS, UrlDetailsInterfaceTestsClass))
#define IS_URL_DETAILS_INTERFACE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_URL_DETAILS_INTERFACE_TESTS))
#define IS_URL_DETAILS_INTERFACE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_URL_DETAILS_INTERFACE_TESTS))
#define URL_DETAILS_INTERFACE_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_URL_DETAILS_INTERFACE_TESTS, UrlDetailsInterfaceTestsClass))

typedef struct _UrlDetailsInterfaceTests UrlDetailsInterfaceTests;
typedef struct _UrlDetailsInterfaceTestsClass UrlDetailsInterfaceTestsClass;
typedef struct _UrlDetailsInterfaceTestsPrivate UrlDetailsInterfaceTestsPrivate;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _tracker_test_backend_unref0(var) ((var == NULL) ? NULL : (var = (tracker_test_backend_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _UrlDetailsInterfaceTestsTestUrlDetailsInterfaceAsyncData UrlDetailsInterfaceTestsTestUrlDetailsInterfaceAsyncData;

struct _UrlDetailsInterfaceTests {
	FolksTestCase parent_instance;
	UrlDetailsInterfaceTestsPrivate * priv;
};

struct _UrlDetailsInterfaceTestsClass {
	FolksTestCaseClass parent_class;
};

struct _UrlDetailsInterfaceTestsPrivate {
	GMainLoop* _main_loop;
	FolksIndividualAggregator* _aggregator;
	TrackerTestBackend* _tracker_backend;
	gchar* _blog_url;
	gchar* _website_url;
	gchar* _urls;
	gboolean _found_blog;
	gboolean _found_website;
};

struct _UrlDetailsInterfaceTestsTestUrlDetailsInterfaceAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UrlDetailsInterfaceTests* self;
	FolksBackendStore* _tmp0_;
	FolksBackendStore* store;
	FolksIndividualAggregator* _tmp1_;
	GError * e;
	GError * _inner_error_;
};


static gpointer url_details_interface_tests_parent_class = NULL;

GType url_details_interface_tests_get_type (void) G_GNUC_CONST;
#define URL_DETAILS_INTERFACE_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_URL_DETAILS_INTERFACE_TESTS, UrlDetailsInterfaceTestsPrivate))
enum  {
	URL_DETAILS_INTERFACE_TESTS_DUMMY_PROPERTY
};
UrlDetailsInterfaceTests* url_details_interface_tests_new (void);
UrlDetailsInterfaceTests* url_details_interface_tests_construct (GType object_type);
void url_details_interface_tests_test_url_details_interface (UrlDetailsInterfaceTests* self);
static void _url_details_interface_tests_test_url_details_interface_folks_test_case_test_method (gpointer self);
static void url_details_interface_tests_real_set_up (FolksTestCase* base);
static void url_details_interface_tests_real_tear_down (FolksTestCase* base);
static void _url_details_interface_tests_test_url_details_interface_async (UrlDetailsInterfaceTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _url_details_interface_tests_test_url_details_interface_finish (UrlDetailsInterfaceTests* self, GAsyncResult* _res_);
static gboolean _lambda0_ (UrlDetailsInterfaceTests* self);
static gboolean __lambda0__gsource_func (gpointer self);
static void _url_details_interface_tests_test_url_details_interface_async_data_free (gpointer _data);
static gboolean _url_details_interface_tests_test_url_details_interface_async_co (UrlDetailsInterfaceTestsTestUrlDetailsInterfaceAsyncData* data);
static void _url_details_interface_tests_test_url_details_interface_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _url_details_interface_tests_individuals_changed_cb (UrlDetailsInterfaceTests* self, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason);
static void __url_details_interface_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static void url_details_interface_tests_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);


static void _url_details_interface_tests_test_url_details_interface_folks_test_case_test_method (gpointer self) {
	url_details_interface_tests_test_url_details_interface (self);
}


UrlDetailsInterfaceTests* url_details_interface_tests_construct (GType object_type) {
	UrlDetailsInterfaceTests * self = NULL;
	TrackerTestBackend* _tmp0_ = NULL;
	self = (UrlDetailsInterfaceTests*) folks_test_case_construct (object_type, "UrlDetailsInterfaceTests");
	_tmp0_ = tracker_test_backend_new ();
	_tracker_test_backend_unref0 (self->priv->_tracker_backend);
	self->priv->_tracker_backend = _tmp0_;
	tracker_test_backend_set_debug (self->priv->_tracker_backend, FALSE);
	folks_test_case_add_test ((FolksTestCase*) self, "test url details interface", _url_details_interface_tests_test_url_details_interface_folks_test_case_test_method, self);
	return self;
}


UrlDetailsInterfaceTests* url_details_interface_tests_new (void) {
	return url_details_interface_tests_construct (TYPE_URL_DETAILS_INTERFACE_TESTS);
}


static void url_details_interface_tests_real_set_up (FolksTestCase* base) {
	UrlDetailsInterfaceTests * self;
	self = (UrlDetailsInterfaceTests*) base;
}


static void url_details_interface_tests_real_tear_down (FolksTestCase* base) {
	UrlDetailsInterfaceTests * self;
	self = (UrlDetailsInterfaceTests*) base;
}


static gboolean _lambda0_ (UrlDetailsInterfaceTests* self) {
	gboolean result = FALSE;
	g_main_loop_quit (self->priv->_main_loop);
	g_assert_not_reached ();
	return result;
}


static gboolean __lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda0_ (self);
	return result;
}


void url_details_interface_tests_test_url_details_interface (UrlDetailsInterfaceTests* self) {
	GMainLoop* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GeeHashMap* c1;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->_main_loop);
	self->priv->_main_loop = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	c1 = _tmp1_;
	_tmp2_ = g_strdup ("http://blog.example.org");
	_g_free0 (self->priv->_blog_url);
	self->priv->_blog_url = _tmp2_;
	_tmp3_ = g_strdup ("http://www.example.org");
	_g_free0 (self->priv->_website_url);
	self->priv->_website_url = _tmp3_;
	_tmp4_ = g_strdup_printf ("%s,%s", self->priv->_blog_url, self->priv->_website_url);
	_g_free0 (self->priv->_urls);
	self->priv->_urls = _tmp4_;
	gee_abstract_map_set ((GeeAbstractMap*) c1, TRF_ONTOLOGY_DEFS_NCO_FULLNAME, "persona #1");
	gee_abstract_map_set ((GeeAbstractMap*) c1, TRACKER_TEST_BACKEND_URLS, self->priv->_urls);
	tracker_test_backend_add_contact (self->priv->_tracker_backend, c1);
	tracker_test_backend_set_up (self->priv->_tracker_backend);
	self->priv->_found_blog = FALSE;
	self->priv->_found_website = FALSE;
	_url_details_interface_tests_test_url_details_interface_async (self, NULL, NULL);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, __lambda0__gsource_func, g_object_ref (self), g_object_unref);
	g_main_loop_run (self->priv->_main_loop);
	g_assert (self->priv->_found_blog == TRUE);
	g_assert (self->priv->_found_website == TRUE);
	tracker_test_backend_tear_down (self->priv->_tracker_backend);
	_g_object_unref0 (c1);
}


static void _url_details_interface_tests_test_url_details_interface_async_data_free (gpointer _data) {
	UrlDetailsInterfaceTestsTestUrlDetailsInterfaceAsyncData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (UrlDetailsInterfaceTestsTestUrlDetailsInterfaceAsyncData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _url_details_interface_tests_test_url_details_interface_async (UrlDetailsInterfaceTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UrlDetailsInterfaceTestsTestUrlDetailsInterfaceAsyncData* _data_;
	_data_ = g_slice_new0 (UrlDetailsInterfaceTestsTestUrlDetailsInterfaceAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _url_details_interface_tests_test_url_details_interface_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _url_details_interface_tests_test_url_details_interface_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_url_details_interface_tests_test_url_details_interface_async_co (_data_);
}


static void _url_details_interface_tests_test_url_details_interface_finish (UrlDetailsInterfaceTests* self, GAsyncResult* _res_) {
	UrlDetailsInterfaceTestsTestUrlDetailsInterfaceAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _url_details_interface_tests_test_url_details_interface_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UrlDetailsInterfaceTestsTestUrlDetailsInterfaceAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_url_details_interface_tests_test_url_details_interface_async_co (data);
}


static void __url_details_interface_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_url_details_interface_tests_individuals_changed_cb (self, added, removed, message, actor, reason);
}


static gboolean _url_details_interface_tests_test_url_details_interface_async_co (UrlDetailsInterfaceTestsTestUrlDetailsInterfaceAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = folks_backend_store_dup ();
	data->store = data->_tmp0_;
	data->_state_ = 1;
	folks_backend_store_prepare (data->store, _url_details_interface_tests_test_url_details_interface_async_ready, data);
	return FALSE;
	_state_1:
	folks_backend_store_prepare_finish (data->store, data->_res_);
	data->_tmp1_ = NULL;
	data->_tmp1_ = folks_individual_aggregator_new ();
	_g_object_unref0 (data->self->priv->_aggregator);
	data->self->priv->_aggregator = data->_tmp1_;
	g_signal_connect_object (data->self->priv->_aggregator, "individuals-changed", (GCallback) __url_details_interface_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed, data->self, 0);
	data->_state_ = 2;
	folks_individual_aggregator_prepare (data->self->priv->_aggregator, _url_details_interface_tests_test_url_details_interface_async_ready, data);
	return FALSE;
	_state_2:
	folks_individual_aggregator_prepare_finish (data->self->priv->_aggregator, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	goto __finally0;
	__catch0_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("url-details-interface.vala:102: Error when calling prepare: %s\n", data->e->message);
		_g_error_free0 (data->e);
	}
	__finally0:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->store);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _url_details_interface_tests_individuals_changed_cb (UrlDetailsInterfaceTests* self, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason) {
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	{
		GList* i_collection;
		GList* i_it;
		i_collection = added;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			FolksIndividual* _tmp0_;
			FolksIndividual* i;
			_tmp0_ = _g_object_ref0 ((FolksIndividual*) i_it->data);
			i = _tmp0_;
			{
				const gchar* _tmp1_ = NULL;
				gchar* _tmp2_;
				gchar* full_name;
				_tmp1_ = folks_name_details_get_full_name ((FolksNameDetails*) i);
				_tmp2_ = g_strdup (_tmp1_);
				full_name = _tmp2_;
				if (full_name != NULL) {
					GList* _tmp3_ = NULL;
					_tmp3_ = folks_url_details_get_urls ((FolksUrlDetails*) i);
					{
						GList* url_collection;
						GList* url_it;
						url_collection = _tmp3_;
						for (url_it = url_collection; url_it != NULL; url_it = url_it->next) {
							FolksFieldDetails* _tmp4_;
							FolksFieldDetails* url;
							_tmp4_ = _g_object_ref0 ((FolksFieldDetails*) url_it->data);
							url = _tmp4_;
							{
								const gchar* _tmp5_ = NULL;
								_tmp5_ = folks_field_details_get_value (url);
								if (g_strcmp0 (_tmp5_, self->priv->_blog_url) == 0) {
									self->priv->_found_blog = TRUE;
								} else {
									const gchar* _tmp6_ = NULL;
									_tmp6_ = folks_field_details_get_value (url);
									if (g_strcmp0 (_tmp6_, self->priv->_website_url) == 0) {
										self->priv->_found_website = TRUE;
									}
								}
								_g_object_unref0 (url);
							}
						}
					}
				}
				_g_free0 (full_name);
				_g_object_unref0 (i);
			}
		}
	}
	g_assert (removed == NULL);
	if (self->priv->_found_blog) {
		_tmp7_ = self->priv->_found_website;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		g_main_loop_quit (self->priv->_main_loop);
	}
}


static void url_details_interface_tests_class_init (UrlDetailsInterfaceTestsClass * klass) {
	url_details_interface_tests_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UrlDetailsInterfaceTestsPrivate));
	FOLKS_TEST_CASE_CLASS (klass)->set_up = url_details_interface_tests_real_set_up;
	FOLKS_TEST_CASE_CLASS (klass)->tear_down = url_details_interface_tests_real_tear_down;
	G_OBJECT_CLASS (klass)->finalize = url_details_interface_tests_finalize;
}


static void url_details_interface_tests_instance_init (UrlDetailsInterfaceTests * self) {
	self->priv = URL_DETAILS_INTERFACE_TESTS_GET_PRIVATE (self);
}


static void url_details_interface_tests_finalize (GObject* obj) {
	UrlDetailsInterfaceTests * self;
	self = URL_DETAILS_INTERFACE_TESTS (obj);
	_g_main_loop_unref0 (self->priv->_main_loop);
	_g_object_unref0 (self->priv->_aggregator);
	_tracker_test_backend_unref0 (self->priv->_tracker_backend);
	_g_free0 (self->priv->_blog_url);
	_g_free0 (self->priv->_website_url);
	_g_free0 (self->priv->_urls);
	G_OBJECT_CLASS (url_details_interface_tests_parent_class)->finalize (obj);
}


GType url_details_interface_tests_get_type (void) {
	static volatile gsize url_details_interface_tests_type_id__volatile = 0;
	if (g_once_init_enter (&url_details_interface_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UrlDetailsInterfaceTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) url_details_interface_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UrlDetailsInterfaceTests), 0, (GInstanceInitFunc) url_details_interface_tests_instance_init, NULL };
		GType url_details_interface_tests_type_id;
		url_details_interface_tests_type_id = g_type_register_static (FOLKS_TYPE_TEST_CASE, "UrlDetailsInterfaceTests", &g_define_type_info, 0);
		g_once_init_leave (&url_details_interface_tests_type_id__volatile, url_details_interface_tests_type_id);
	}
	return url_details_interface_tests_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GTestSuite* _tmp0_ = NULL;
	GTestSuite* root;
	UrlDetailsInterfaceTests* _tmp1_ = NULL;
	UrlDetailsInterfaceTests* _tmp2_;
	GTestSuite* _tmp3_ = NULL;
	g_test_init (&args_length1, &args, NULL);
	_tmp0_ = g_test_get_root ();
	root = _tmp0_;
	_tmp1_ = url_details_interface_tests_new ();
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_test_case_get_suite ((FolksTestCase*) _tmp2_);
	g_test_suite_add_suite (root, _tmp3_);
	_g_object_unref0 (_tmp2_);
	g_test_run ();
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}



