/* prefix-name-updates.c generated by valac 0.12.0, the Vala compiler
 * generated from prefix-name-updates.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <folks-test.h>
#include <tracker-test.h>
#include <folks/folks.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <folks/folks-tracker.h>
#include <gio/gio.h>


#define TYPE_PREFIX_NAME_UPDATES_TESTS (prefix_name_updates_tests_get_type ())
#define PREFIX_NAME_UPDATES_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFIX_NAME_UPDATES_TESTS, PrefixNameUpdatesTests))
#define PREFIX_NAME_UPDATES_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFIX_NAME_UPDATES_TESTS, PrefixNameUpdatesTestsClass))
#define IS_PREFIX_NAME_UPDATES_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFIX_NAME_UPDATES_TESTS))
#define IS_PREFIX_NAME_UPDATES_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFIX_NAME_UPDATES_TESTS))
#define PREFIX_NAME_UPDATES_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFIX_NAME_UPDATES_TESTS, PrefixNameUpdatesTestsClass))

typedef struct _PrefixNameUpdatesTests PrefixNameUpdatesTests;
typedef struct _PrefixNameUpdatesTestsClass PrefixNameUpdatesTestsClass;
typedef struct _PrefixNameUpdatesTestsPrivate PrefixNameUpdatesTestsPrivate;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _tracker_test_backend_unref0(var) ((var == NULL) ? NULL : (var = (tracker_test_backend_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _PrefixNameUpdatesTestsTestPrefixNameUpdatesAsyncData PrefixNameUpdatesTestsTestPrefixNameUpdatesAsyncData;

struct _PrefixNameUpdatesTests {
	FolksTestCase parent_instance;
	PrefixNameUpdatesTestsPrivate * priv;
};

struct _PrefixNameUpdatesTestsClass {
	FolksTestCaseClass parent_class;
};

struct _PrefixNameUpdatesTestsPrivate {
	GMainLoop* _main_loop;
	TrackerTestBackend* _tracker_backend;
	FolksIndividualAggregator* _aggregator;
	gboolean _updated_prefix_name_found;
	gboolean _initial_prefix_name_found;
	gchar* _updated_prefix_name;
	gchar* _individual_id;
	gchar* _initial_fullname;
	gchar* _initial_prefix_name;
	gchar* _contact_urn;
};

struct _PrefixNameUpdatesTestsTestPrefixNameUpdatesAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	PrefixNameUpdatesTests* self;
	FolksBackendStore* _tmp0_;
	FolksBackendStore* store;
	FolksIndividualAggregator* _tmp1_;
	GError * e;
	GError * _inner_error_;
};


static gpointer prefix_name_updates_tests_parent_class = NULL;

GType prefix_name_updates_tests_get_type (void) G_GNUC_CONST;
#define PREFIX_NAME_UPDATES_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PREFIX_NAME_UPDATES_TESTS, PrefixNameUpdatesTestsPrivate))
enum  {
	PREFIX_NAME_UPDATES_TESTS_DUMMY_PROPERTY
};
PrefixNameUpdatesTests* prefix_name_updates_tests_new (void);
PrefixNameUpdatesTests* prefix_name_updates_tests_construct (GType object_type);
void prefix_name_updates_tests_test_prefix_name_updates (PrefixNameUpdatesTests* self);
static void _prefix_name_updates_tests_test_prefix_name_updates_folks_test_case_test_method (gpointer self);
static void prefix_name_updates_tests_real_set_up (FolksTestCase* base);
static void prefix_name_updates_tests_real_tear_down (FolksTestCase* base);
static void _prefix_name_updates_tests_test_prefix_name_updates_async (PrefixNameUpdatesTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _prefix_name_updates_tests_test_prefix_name_updates_finish (PrefixNameUpdatesTests* self, GAsyncResult* _res_);
static gboolean _lambda0_ (PrefixNameUpdatesTests* self);
static gboolean __lambda0__gsource_func (gpointer self);
static void _prefix_name_updates_tests_test_prefix_name_updates_async_data_free (gpointer _data);
static gboolean _prefix_name_updates_tests_test_prefix_name_updates_async_co (PrefixNameUpdatesTestsTestPrefixNameUpdatesAsyncData* data);
static void _prefix_name_updates_tests_test_prefix_name_updates_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _prefix_name_updates_tests_individuals_changed_cb (PrefixNameUpdatesTests* self, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason);
static void __prefix_name_updates_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static void _prefix_name_updates_tests_notify_prefix_name_cb (PrefixNameUpdatesTests* self, GObject* individual_obj, GParamSpec* ps);
static void __prefix_name_updates_tests_notify_prefix_name_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void prefix_name_updates_tests_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);


static void _prefix_name_updates_tests_test_prefix_name_updates_folks_test_case_test_method (gpointer self) {
	prefix_name_updates_tests_test_prefix_name_updates (self);
}


PrefixNameUpdatesTests* prefix_name_updates_tests_construct (GType object_type) {
	PrefixNameUpdatesTests * self = NULL;
	TrackerTestBackend* _tmp0_ = NULL;
	self = (PrefixNameUpdatesTests*) folks_test_case_construct (object_type, "PrefixNameUpdates");
	_tmp0_ = tracker_test_backend_new ();
	_tracker_test_backend_unref0 (self->priv->_tracker_backend);
	self->priv->_tracker_backend = _tmp0_;
	tracker_test_backend_set_debug (self->priv->_tracker_backend, FALSE);
	folks_test_case_add_test ((FolksTestCase*) self, "prefix name updates", _prefix_name_updates_tests_test_prefix_name_updates_folks_test_case_test_method, self);
	return self;
}


PrefixNameUpdatesTests* prefix_name_updates_tests_new (void) {
	return prefix_name_updates_tests_construct (TYPE_PREFIX_NAME_UPDATES_TESTS);
}


static void prefix_name_updates_tests_real_set_up (FolksTestCase* base) {
	PrefixNameUpdatesTests * self;
	self = (PrefixNameUpdatesTests*) base;
}


static void prefix_name_updates_tests_real_tear_down (FolksTestCase* base) {
	PrefixNameUpdatesTests * self;
	self = (PrefixNameUpdatesTests*) base;
}


static gboolean _lambda0_ (PrefixNameUpdatesTests* self) {
	gboolean result = FALSE;
	g_main_loop_quit (self->priv->_main_loop);
	g_assert_not_reached ();
	return result;
}


static gboolean __lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda0_ (self);
	return result;
}


void prefix_name_updates_tests_test_prefix_name_updates (PrefixNameUpdatesTests* self) {
	GMainLoop* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GeeHashMap* c1;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->_main_loop);
	self->priv->_main_loop = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	c1 = _tmp1_;
	_tmp2_ = g_strdup ("persona #1");
	_g_free0 (self->priv->_initial_fullname);
	self->priv->_initial_fullname = _tmp2_;
	_tmp3_ = g_strdup ("prefix name #1");
	_g_free0 (self->priv->_initial_prefix_name);
	self->priv->_initial_prefix_name = _tmp3_;
	_tmp4_ = g_strdup ("updated prefix #1");
	_g_free0 (self->priv->_updated_prefix_name);
	self->priv->_updated_prefix_name = _tmp4_;
	_tmp5_ = g_strdup ("<urn:contact001>");
	_g_free0 (self->priv->_contact_urn);
	self->priv->_contact_urn = _tmp5_;
	gee_abstract_map_set ((GeeAbstractMap*) c1, TRACKER_TEST_BACKEND_URN, self->priv->_contact_urn);
	gee_abstract_map_set ((GeeAbstractMap*) c1, TRF_ONTOLOGY_DEFS_NCO_FULLNAME, self->priv->_initial_fullname);
	gee_abstract_map_set ((GeeAbstractMap*) c1, TRF_ONTOLOGY_DEFS_NCO_PREFIX, self->priv->_initial_prefix_name);
	tracker_test_backend_add_contact (self->priv->_tracker_backend, c1);
	tracker_test_backend_set_up (self->priv->_tracker_backend);
	self->priv->_initial_prefix_name_found = FALSE;
	self->priv->_updated_prefix_name_found = FALSE;
	_tmp6_ = g_strdup ("");
	_g_free0 (self->priv->_individual_id);
	self->priv->_individual_id = _tmp6_;
	_prefix_name_updates_tests_test_prefix_name_updates_async (self, NULL, NULL);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, __lambda0__gsource_func, g_object_ref (self), g_object_unref);
	g_main_loop_run (self->priv->_main_loop);
	g_assert (self->priv->_initial_prefix_name_found == TRUE);
	g_assert (self->priv->_updated_prefix_name_found == TRUE);
	tracker_test_backend_tear_down (self->priv->_tracker_backend);
	_g_object_unref0 (c1);
}


static void _prefix_name_updates_tests_test_prefix_name_updates_async_data_free (gpointer _data) {
	PrefixNameUpdatesTestsTestPrefixNameUpdatesAsyncData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (PrefixNameUpdatesTestsTestPrefixNameUpdatesAsyncData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _prefix_name_updates_tests_test_prefix_name_updates_async (PrefixNameUpdatesTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	PrefixNameUpdatesTestsTestPrefixNameUpdatesAsyncData* _data_;
	_data_ = g_slice_new0 (PrefixNameUpdatesTestsTestPrefixNameUpdatesAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _prefix_name_updates_tests_test_prefix_name_updates_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _prefix_name_updates_tests_test_prefix_name_updates_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_prefix_name_updates_tests_test_prefix_name_updates_async_co (_data_);
}


static void _prefix_name_updates_tests_test_prefix_name_updates_finish (PrefixNameUpdatesTests* self, GAsyncResult* _res_) {
	PrefixNameUpdatesTestsTestPrefixNameUpdatesAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _prefix_name_updates_tests_test_prefix_name_updates_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	PrefixNameUpdatesTestsTestPrefixNameUpdatesAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_prefix_name_updates_tests_test_prefix_name_updates_async_co (data);
}


static void __prefix_name_updates_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_prefix_name_updates_tests_individuals_changed_cb (self, added, removed, message, actor, reason);
}


static gboolean _prefix_name_updates_tests_test_prefix_name_updates_async_co (PrefixNameUpdatesTestsTestPrefixNameUpdatesAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = folks_backend_store_dup ();
	data->store = data->_tmp0_;
	data->_state_ = 1;
	folks_backend_store_prepare (data->store, _prefix_name_updates_tests_test_prefix_name_updates_async_ready, data);
	return FALSE;
	_state_1:
	folks_backend_store_prepare_finish (data->store, data->_res_);
	data->_tmp1_ = NULL;
	data->_tmp1_ = folks_individual_aggregator_new ();
	_g_object_unref0 (data->self->priv->_aggregator);
	data->self->priv->_aggregator = data->_tmp1_;
	g_signal_connect_object (data->self->priv->_aggregator, "individuals-changed", (GCallback) __prefix_name_updates_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed, data->self, 0);
	data->_state_ = 2;
	folks_individual_aggregator_prepare (data->self->priv->_aggregator, _prefix_name_updates_tests_test_prefix_name_updates_async_ready, data);
	return FALSE;
	_state_2:
	folks_individual_aggregator_prepare_finish (data->self->priv->_aggregator, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	goto __finally0;
	__catch0_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("prefix-name-updates.vala:106: Error when calling prepare: %s\n", data->e->message);
		_g_error_free0 (data->e);
	}
	__finally0:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->store);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void __prefix_name_updates_tests_notify_prefix_name_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_prefix_name_updates_tests_notify_prefix_name_cb (self, _sender, pspec);
}


static void _prefix_name_updates_tests_individuals_changed_cb (PrefixNameUpdatesTests* self, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason) {
	gint _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	{
		GeeIterator* _tmp0_ = NULL;
		GeeIterator* _i_it;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) added);
		_i_it = _tmp0_;
		while (TRUE) {
			gboolean _tmp1_;
			gpointer _tmp2_ = NULL;
			FolksIndividual* i;
			const gchar* _tmp3_ = NULL;
			_tmp1_ = gee_iterator_next (_i_it);
			if (!_tmp1_) {
				break;
			}
			_tmp2_ = gee_iterator_get (_i_it);
			i = (FolksIndividual*) _tmp2_;
			_tmp3_ = folks_name_details_get_full_name ((FolksNameDetails*) i);
			if (g_strcmp0 (self->priv->_initial_fullname, _tmp3_) == 0) {
				FolksStructuredName* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				gchar* _tmp6_;
				gchar* prefix_name;
				_tmp4_ = folks_name_details_get_structured_name ((FolksNameDetails*) i);
				_tmp5_ = folks_structured_name_get_prefixes (_tmp4_);
				_tmp6_ = g_strdup (_tmp5_);
				prefix_name = _tmp6_;
				if (g_strcmp0 (prefix_name, self->priv->_initial_prefix_name) == 0) {
					FolksStructuredName* _tmp7_ = NULL;
					const gchar* _tmp8_ = NULL;
					gchar* _tmp9_;
					_tmp7_ = folks_name_details_get_structured_name ((FolksNameDetails*) i);
					g_signal_connect_object ((GObject*) _tmp7_, "notify::prefixes", (GCallback) __prefix_name_updates_tests_notify_prefix_name_cb_g_object_notify, self, 0);
					_tmp8_ = folks_individual_get_id (i);
					_tmp9_ = g_strdup (_tmp8_);
					_g_free0 (self->priv->_individual_id);
					self->priv->_individual_id = _tmp9_;
					self->priv->_initial_prefix_name_found = TRUE;
					tracker_test_backend_update_contact (self->priv->_tracker_backend, self->priv->_contact_urn, TRF_ONTOLOGY_DEFS_NCO_PREFIX, self->priv->_updated_prefix_name);
				}
				_g_free0 (prefix_name);
			}
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	_tmp10_ = gee_collection_get_size ((GeeCollection*) removed);
	g_assert (_tmp10_ == 0);
}


static void _prefix_name_updates_tests_notify_prefix_name_cb (PrefixNameUpdatesTests* self, GObject* individual_obj, GParamSpec* ps) {
	FolksStructuredName* _tmp0_;
	FolksStructuredName* sname;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* prefix_name;
	g_return_if_fail (self != NULL);
	g_return_if_fail (individual_obj != NULL);
	g_return_if_fail (ps != NULL);
	_tmp0_ = _g_object_ref0 (FOLKS_STRUCTURED_NAME (individual_obj));
	sname = _tmp0_;
	_tmp1_ = folks_structured_name_get_prefixes (sname);
	_tmp2_ = g_strdup (_tmp1_);
	prefix_name = _tmp2_;
	if (g_strcmp0 (prefix_name, self->priv->_updated_prefix_name) == 0) {
		self->priv->_updated_prefix_name_found = TRUE;
		g_main_loop_quit (self->priv->_main_loop);
	}
	_g_free0 (prefix_name);
	_g_object_unref0 (sname);
}


static void prefix_name_updates_tests_class_init (PrefixNameUpdatesTestsClass * klass) {
	prefix_name_updates_tests_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PrefixNameUpdatesTestsPrivate));
	FOLKS_TEST_CASE_CLASS (klass)->set_up = prefix_name_updates_tests_real_set_up;
	FOLKS_TEST_CASE_CLASS (klass)->tear_down = prefix_name_updates_tests_real_tear_down;
	G_OBJECT_CLASS (klass)->finalize = prefix_name_updates_tests_finalize;
}


static void prefix_name_updates_tests_instance_init (PrefixNameUpdatesTests * self) {
	self->priv = PREFIX_NAME_UPDATES_TESTS_GET_PRIVATE (self);
}


static void prefix_name_updates_tests_finalize (GObject* obj) {
	PrefixNameUpdatesTests * self;
	self = PREFIX_NAME_UPDATES_TESTS (obj);
	_g_main_loop_unref0 (self->priv->_main_loop);
	_tracker_test_backend_unref0 (self->priv->_tracker_backend);
	_g_object_unref0 (self->priv->_aggregator);
	_g_free0 (self->priv->_updated_prefix_name);
	_g_free0 (self->priv->_individual_id);
	_g_free0 (self->priv->_initial_fullname);
	_g_free0 (self->priv->_initial_prefix_name);
	_g_free0 (self->priv->_contact_urn);
	G_OBJECT_CLASS (prefix_name_updates_tests_parent_class)->finalize (obj);
}


GType prefix_name_updates_tests_get_type (void) {
	static volatile gsize prefix_name_updates_tests_type_id__volatile = 0;
	if (g_once_init_enter (&prefix_name_updates_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PrefixNameUpdatesTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) prefix_name_updates_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrefixNameUpdatesTests), 0, (GInstanceInitFunc) prefix_name_updates_tests_instance_init, NULL };
		GType prefix_name_updates_tests_type_id;
		prefix_name_updates_tests_type_id = g_type_register_static (FOLKS_TYPE_TEST_CASE, "PrefixNameUpdatesTests", &g_define_type_info, 0);
		g_once_init_leave (&prefix_name_updates_tests_type_id__volatile, prefix_name_updates_tests_type_id);
	}
	return prefix_name_updates_tests_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GTestSuite* _tmp0_ = NULL;
	GTestSuite* root;
	PrefixNameUpdatesTests* _tmp1_ = NULL;
	PrefixNameUpdatesTests* _tmp2_;
	GTestSuite* _tmp3_ = NULL;
	g_test_init (&args_length1, &args, NULL);
	_tmp0_ = g_test_get_root ();
	root = _tmp0_;
	_tmp1_ = prefix_name_updates_tests_new ();
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_test_case_get_suite ((FolksTestCase*) _tmp2_);
	g_test_suite_add_suite (root, _tmp3_);
	_g_object_unref0 (_tmp2_);
	g_test_run ();
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}



