/**********************************************************************
Copyright (C) 1996 Christopher Lee
 
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
You should have received a copy of the GNU General Public License
along with this software; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/

#ifndef __G_WRAP_H__
#define __G_WRAP_H__

#ifdef __cplusplus
extern "C" {
#endif
  
  typedef unsigned long GWSCM;
  typedef void (*mark_fn_t)(void*);
  
  void gw_puts  (char *str, GWSCM port);
  void gw_error (char *message);
  void gw_mark(GWSCM obj);
  void gw_add_description(GWSCM lst);
  void gw_initialize(void);
  
  /* POINTER_TOKENs */
  
  typedef struct {
    char* typename;
    void* pdata;
  } POINTER_TOKEN_st;
  typedef POINTER_TOKEN_st * POINTER_TOKEN;
  
  void POINTER_TOKEN_print(POINTER_TOKEN pt, GWSCM port, int writingp);
  int POINTER_TOKEN_eq(POINTER_TOKEN pt1, POINTER_TOKEN pt2);
  POINTER_TOKEN make_POINTER_TOKEN(char *type, void* addr);
  void POINTER_TOKEN_free(POINTER_TOKEN pt);
  
  /* POINTER_ARRAYs */
  
  typedef struct {
    char* typename;
    char* itemtype;
    void** pdata;
    unsigned long length;
  } POINTER_ARRAY_st;
  typedef POINTER_ARRAY_st * POINTER_ARRAY;
  
  void          POINTER_ARRAY_print(POINTER_ARRAY pa, GWSCM port, int writingp);
  int           POINTER_ARRAY_eq(POINTER_ARRAY pa1, POINTER_ARRAY pa2);
  POINTER_ARRAY make_POINTER_ARRAY(char *type, char *itemtype, void** addr);
  void          POINTER_ARRAY_free(POINTER_ARRAY pa);
  POINTER_TOKEN POINTER_ARRAY_ref(POINTER_ARRAY pa, int index);
  unsigned long POINTER_ARRAY_length(POINTER_ARRAY pa);
  
  /* FIXME: This shouldn't be here, and the type shouldn't be GWSCM...
     Hopefully this will make it to the guile upstream source... */
  GWSCM              gh_ulonglong2scm(unsigned long long x);
  unsigned long long gh_scm2ulonglong(GWSCM x);
  GWSCM              gh_longlong2scm(long long x);
  long long gh_scm2longlong(GWSCM x);
  
#ifdef __cplusplus
}
#endif

#endif
