#! /usr/bin/env python
#
# (Un-)installer script for .desktop user installation.
#

try:
    import pygtk; pygtk.require("2.0")
except:
    pass

import gnome.vfs
import os
import sys


#
# Copies a file into a location in the VFS.
#
def vfscopy(src, dest):

    print "copying %(src)s -> %(dest)s" % vars()
    file = gnome.vfs.URI(dest)
    if (gnome.vfs.exists(file)):
        fd = gnome.vfs.open(file, gnome.vfs.OPEN_WRITE)
    else:
        fd = gnome.vfs.create(file, gnome.vfs.OPEN_WRITE)
    fdsrc = open(src, "r")
    data = fdsrc.read()
    fd.write(data)
    fd.close()
    fdsrc.close()


#
# Removes a file from a location in the VFS.
#
def vfsremove(src):

    print "removing %(src)s" % vars()
    file = gnome.vfs.URI(src)
    if (gnome.vfs.exists(file)):
    	fd = gnome.vfs.unlink(file)


print "desktop helper script"
print "====================="
action = sys.argv[1]
print "Action: %(action)s." % vars()

if (action == "install"):
    vfscopy("gdesklets.desktop",
    "applications:///Accessories/gdesklets.desktop")
    print "Successfully installed desktop file."
elif (action == "uninstall"):
    vfsremove("applications:///Accessories/gdesklets.desktop")
    print "Successfully uninstalled desktop file."
else:
    print "ERROR: Invalid action. Aborting. Valid actions: install, uninstall."
