import desktop
try:
    from utils import _ewmh as ewmh
except:
    print "Couldn't load EWMH support. Some window flags will not work."

import gtk


#
# Class for transparent windows.
#
class GlassWindow(gtk.Window):

    # transparency modes
    TRANSPARENCY_NONE = 0
    TRANSPARENCY_SCREENSHOT = 1
    TRANSPARENCY_PSEUDO = 2

    # window types
    TYPE_NORMAL = 0
    TYPE_KEEP_BELOW = 1
    TYPE_KEEP_ABOVE = 2
    TYPE_STICKY = 4
    TYPE_MANAGED = 8
    

    #
    # Constructor.
    #
    def __init__(self, wintype = gtk.WINDOW_TOPLEVEL):

        self.__gc_lock = 0

        # the transparency mode to use
        self.__transparency = self.TRANSPARENCY_PSEUDO

        # the desktop background
        self.__bg_root = None

        # remember the current window position to detect movements
        self.__position = (0, 0)
        self.__size = (0, 0)


        gtk.Window.__init__(self, wintype)
        self.connect("configure-event", self.__on_configure)
        desktop.watch_bg(self.__bg_observer)

        self.__bg_image = gtk.gdk.Pixbuf(0, 1, 8, 10, 10)
        self.__bg_image.fill(0xffffff)



    #
    # Observer method for the background.
    # Connect this method to the BG watcher.
    #
    def __bg_observer(self, src, cmd):

        self.update_bg()




    #
    # Sets the type of this window. Multiple types can be ORed together.
    #
    def set_window_type(self, wtype):

        if (wtype & self.TYPE_STICKY):
            self.stick()
        else:
            self.unstick()

        if (wtype & self.TYPE_MANAGED):
            self.set_decorated(gtk.TRUE)
        else:
            self.set_decorated(gtk.FALSE)

        # do it later, if the window isn't currently visible
        if (not self.get_property("visible")):
            gtk.idle_add(self.set_window_type, wtype)
            return

        try:
            # old versions of PyGTK don't have this
            winid = self.window.xid
            
            if (wtype & self.TYPE_KEEP_BELOW):
                ewmh.set_below(winid)

            elif (wtype & self.TYPE_KEEP_ABOVE):
                ewmh.set_above(winid)

        except:
            pass





    #
    # Sets the transparency mode of this window.
    #
    def set_transparency_mode(self, mode):

        self.__transparency = mode

        if (mode == self.TRANSPARENCY_NONE):
            self.__bg_root = gtk.gdk.Pixbuf(0, 1, 8, width, height)
            self.__bg_root.fill(0xffffff)



    #
    # Displays the background image.
    #
    def __display_bg(self):

        if (not self.__bg_root): return

        width = self.__bg_root.get_width()
        height = self.__bg_root.get_height()

        # set as window bg
        pix, mask = self.__bg_root.render_pixmap_and_mask()

        style = gtk.Style()
        style.bg_pixmap[gtk.STATE_NORMAL] = pix
        self.set_style(style)

        # work around the memory leak bug #110261 of pygtk
        if (not self.__gc_lock):
            self.__gc_lock = 1

            def f(self):
                self.__gc_lock = 0
                import gc; gc.collect()

            gtk.timeout_add(1000, f, self)

        #end if


        # tell gtk to redraw this window ASAP
        self.queue_draw()



    #
    # Updates the background for transparency.
    #
    def update_bg(self, noscreenshot = 0):

        if (not self.window): return
        
        x, y = self.window.get_origin()
        width, height = self.window.get_size()
        if (self.__transparency != self.TRANSPARENCY_NONE
            and width > 1 and height > 1):
            self.__capture_bg(x, y, width, height, noscreenshot)
            self.__display_bg()



    #
    # Captures the background to create transparency.
    #
    def __capture_bg(self, x, y, width, height, noscreenshot = 0):

        #del self.__bg_root
        # try capturing the background
        if (self.__transparency == self.TRANSPARENCY_PSEUDO):
            try:
                self.__bg_root = desktop.get_wallpaper(x, y, width, height)
                return
            except:
                try:
                    self.__bg_root = desktop.get_wallcolor(width, height)
                    return
                except:
                    self.__bg_root = gtk.gdk.Pixbuf(0, 1, 8, width, height)
                    self.__bg_root.fill(0xddddee)
                    return
                #end try
            #end try
        #end if

        # use screenshot transparency if capturing has failed or transparency
        # mode is set to screenshot transparency
        if (noscreenshot): return  # must not make screenshot now

        self.hide()
        self.move(-1000, 0)
        self.queue_draw()

        # wait long enough for the window to disappear; does this work always?
        while (gtk.gdk.events_pending()): gtk.mainiteration()
        gtk.mainiteration()
        
        self.__bg_root = desktop.get_wallpaper_fallback(x, y, width, height)
        self.show()
        self.move(x, y)


    #
    # Reacts on moving the window.
    #
    def __on_configure(self, src, event):

        pos = self.window.get_origin()
        size = self.window.get_size()
        if (pos != self.__position or size != self.__size):
            self.__position = pos
            self.__size = size

            # don't make screenshots while moving the window
            self.update_bg(noscreenshot = 1)
