import polling

import os, stat


class Memory:

    def __init__(self):

        self.__get_total_ram = polling.wrap(self.__poll_total_ram, 0)

        self.get_ram = polling.wrap(self.__poll_mem, 0.2, 0)
        self.get_swap = polling.wrap(self.__poll_mem, 0.2, 1)




    def __poll_total_ram(self):
        
        memtotal = os.stat("/proc/kcore")[stat.ST_SIZE]
        return memtotal


        
    def __poll_mem(self, mode):

        fd = open("/proc/meminfo", "r")
        mem = fd.read()
        fd.close()
        lines = mem.splitlines()

        # RAM
        if (mode == 0):
            nil, total, used , free, share, buffers, cached = lines[1].split()
            total = self.__get_total_ram()
            used = int(used) - int(cached)

        # Swap
        elif (mode == 1):
            nil, total, used, free = lines[2].split()
            total = int(total)
            used = int(used)

        return (total, used)
