import polling

import commands
import time


class Sys:

    def __init__(self):

        self.get_arch = polling.wrap(self.__poll_arch, 0)
        self.get_os = polling.wrap(self.__poll_os, 0)

        self.get_uptime = polling.wrap(self.__poll_uptime, 1, 0)
        self.get_idletime = polling.wrap(self.__poll_uptime, 1, 1)
        self.get_sysstart = polling.wrap(self.__poll_uptime, 0, 2)

        self.get_load_avg_1m = polling.wrap(self.__poll_load_avg, 30, 0)
        self.get_load_avg_5m = polling.wrap(self.__poll_load_avg, 30, 1)
        self.get_load_avg_15m = polling.wrap(self.__poll_load_avg, 30, 2)

        self.get_tasks = polling.wrap(self.__poll_tasks, 0.2)



    def __poll_arch(self):

        arch = commands.getoutput("uname -m")
        return arch


    def __poll_os(self):

        os = commands.getoutput("uname -o")
        return os


    def __poll_uptime(self, mode):

        fd = open("/proc/uptime", "r")
        data = fd.readlines()
        fd.close()
        
        uptime, idletime = data[0].split()

        # uptime
        if (mode == 0):
            return int(float(uptime))
        # idle time
        elif (mode == 1):
            return int(float(idletime))
        # sys start
        elif (mode == 2):
            now = time.time()
            return int(now - float(uptime))


    def __poll_load_avg(self, mode):

        fd = open("/proc/loadavg", "r")
        data = fd.readlines()
        fd.close()
        load1, load5, load15, t, d = data[0].split()

        # avg over 1 minute
        if (mode == 0):
            return float(load1)
        # avg over 5 minutes
        elif (mode == 1):
            return float(load5)
        # avg over 15 minutes
        elif (mode == 2):
            return float(load15)



    def __poll_tasks(self):

        fd = open("/proc/loadavg", "r")
        data = fd.readlines()
        fd.close()

        parts = data[0].split()
        running, tasks = parts[3].split("/")

        return (int(tasks), int(running))
