#
# Adds the given displays.
#

from config.ConfigManager import ConfigManager
from utils import dialog

import sys, random, time, os



#
# Returns a unique ID.
#
def new_id():

    return (str(time.time()) + str(random.random())).replace(".", "")



displays = sys.argv[1:]
if (displays):
    config = ConfigManager()
    configdata = config.get("main", "displays")
    data = []
    if (configdata): data.append(configdata)
    
    for d in displays:
        path = os.path.abspath(os.path.abspath(d))
        id = new_id()
        if (os.path.exists(path)):
            data.append(id + ":" + path)
            print "Added " + path + "."
        else:
            dialog.error("Could not add display",
                         "The display could not be added because the file "
                         "does not exist.")
        #end if

    config.set("main", "displays", ",".join(data))
    sys.exit(0)
#end for
