/*
 *  Copyright (C) 2003 Tommi Komulainen
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "network-prefs.h"
#include "galeon-shell.h"
#include "galeon-embed-prefs.h"
#include "gul-gobject-misc.h"

#include <gtk/gtkmessagedialog.h>
#include <gtk/gtklabel.h>
#include <bonobo/bonobo-i18n.h>

#ifndef GNOME_NETWORK_PREFERENCES
#define GNOME_NETWORK_PREFERENCES	"gnome-network-preferences"
#endif

/* Glade callbacks */
void
prefs_clear_memory_cache_button_clicked_cb (GtkWidget *button, 
					    gpointer data);
void
prefs_clear_disk_cache_button_clicked_cb (GtkWidget *button, 
					  gpointer data);
void
prefs_configure_proxy_button_clicked_cb (GtkWidget *button,
		                         gpointer data);


/* Proxy page */

enum
{
	CACHE_COMPARE_PROP,
	DISK_CACHE_PROP,
	MEMORY_CACHE_PROP,
	WARNING_WIDGET,
	BUTTON_WIDGET
};

static const
GaleonDialogProperty properties [] =
{
	{ CACHE_COMPARE_PROP, "cache_compare_radiobutton", CONF_NETWORK_CACHE_COMPARE, PT_AUTOAPPLY, NULL },
	{ DISK_CACHE_PROP, "disk_cache_spin", CONF_NETWORK_DISK_CACHE, PT_AUTOAPPLY, NULL },
	{ MEMORY_CACHE_PROP, "memory_cache_spin", CONF_NETWORK_MEMORY_CACHE, PT_AUTOAPPLY, NULL },
	
	{ WARNING_WIDGET, "proxy_warning", NULL, PT_NORMAL, NULL },
	{ BUTTON_WIDGET, "proxy_button", NULL, PT_NORMAL, NULL },
	{ -1, NULL, NULL }
};


static GObjectClass *parent_class = NULL;

struct NetworkPrefsPrivate
{
	gpointer dummy;
};

static void
network_prefs_init (NetworkPrefs *dialog)
{	
	GtkWidget *button;
	GtkWidget *warning;
	char *path;

	dialog->priv = g_new0 (NetworkPrefsPrivate, 1);
	
	galeon_dialog_construct (GALEON_DIALOG(dialog),
				 properties,
				 "prefs-dialog.glade", 
				 "network_page_box");

	button = galeon_dialog_get_control (GALEON_DIALOG(dialog), BUTTON_WIDGET);
	warning = galeon_dialog_get_control (GALEON_DIALOG(dialog), WARNING_WIDGET);

	path = g_find_program_in_path (GNOME_NETWORK_PREFERENCES);
	if (path != NULL)
	{
		gtk_widget_set_sensitive (button, TRUE);
		gtk_widget_hide (warning);
		g_free (path);
	}
	else
	{
		gtk_widget_set_sensitive (button, FALSE);
		gtk_widget_show (warning);
	}
}

static void
network_prefs_finalize (GObject *object)
{
	NetworkPrefs *dialog;

        g_return_if_fail (object != NULL);
        g_return_if_fail (IS_NETWORK_PREFS (object));

	dialog = NETWORK_PREFS (object);

        g_return_if_fail (dialog->priv != NULL);

        g_free (dialog->priv);

        G_OBJECT_CLASS (parent_class)->finalize (object);
}

static void
network_prefs_class_init (NetworkPrefsClass *klass)
{
        GObjectClass *object_class = G_OBJECT_CLASS (klass);

        parent_class = g_type_class_peek_parent (klass);

        object_class->finalize = network_prefs_finalize;
}

GUL_TYPE_FUNC(network_prefs, NetworkPrefs, GALEON_DIALOG_TYPE)

GaleonDialog *
network_prefs_new (void)
{
	return GALEON_DIALOG(g_object_new (NETWORK_PREFS_TYPE, NULL));
}

/* Glade callbacks */

void
prefs_clear_memory_cache_button_clicked_cb (GtkWidget *button, 
					    gpointer data)
{
	GaleonEmbedShell *shell;

	shell = galeon_shell_get_embed_shell (galeon_shell);
	galeon_embed_shell_clear_cache (shell, MEMORY_CACHE);
}

void
prefs_clear_disk_cache_button_clicked_cb (GtkWidget *button, 
					  gpointer data)
{
	GaleonEmbedShell *shell;

	shell = galeon_shell_get_embed_shell (galeon_shell);
	galeon_embed_shell_clear_cache (shell, DISK_CACHE);
}

void
prefs_configure_proxy_button_clicked_cb (GtkWidget *button,
		                         gpointer data)
{
	GtkWidget *parent;
	GtkWidget *dialog;
	GtkWidget *label;
	char 	  *message ;
	GError 	  *err = NULL;

	if (g_spawn_command_line_async (GNOME_NETWORK_PREFERENCES, &err))
		return;

	message = g_strdup_printf("<b>%s</b>\n\n%s",
			          _("Cannot start network proxy "
				    "configuration program; the "
				    "following error occured:"),
				  err->message);
	g_clear_error (&err);

	parent = gtk_widget_get_toplevel (button);
	dialog = gtk_message_dialog_new (GTK_WINDOW(parent),
			                 GTK_DIALOG_MODAL,
					 GTK_MESSAGE_ERROR,
					 GTK_BUTTONS_OK,
					 message);
	g_free (message);

	/* XXX The label is private, but until GtkMessageDialog has constructor
	 * that supports markup, this appears to be the way to go. */
	label = GTK_MESSAGE_DIALOG(dialog)->label;
	gtk_label_set_use_markup (GTK_LABEL(label), TRUE);

	gtk_dialog_run (GTK_DIALOG(dialog));
	gtk_widget_destroy (dialog);
}
