/*
 *  Copyright (C) 2001 Philip Langdale
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef TOCProtocolHandler_h__
#define TOCProtocolHandler_h__
    
#include "nsError.h"
#include "nsCOMPtr.h"
#include "nsIProtocolHandler.h"
#include "nsIURI.h"
#include "nsIChannel.h"
#include "nsIStorageStream.h"

#include "BaseProtocolHandler.h"

#define G_TOC_PROTOCOL_CID				\
{ /* a3a7b6e5-7a92-431d-87e6-3bef8e7ada56*/		\
    0xa3a7b6e5,						\
    0x7a92,						\
    0x431d,						\
    {0x87, 0xe6, 0x3b, 0xef, 0x8e, 0x7a, 0xda, 0x56}	\
}
#define G_TOC_HANDLER_CONTRACTID NS_NETWORK_PROTOCOL_CONTRACTID_PREFIX "toc"
#define G_TOC_HANDLER_CLASSNAME "Galeon's toc protocol handler"

class GTOCProtocolHandler : public GBaseProtocolHandler
{
  public:
	NS_DECL_ISUPPORTS

	NS_IMETHODIMP NewChannel(nsIURI *aURI, nsIChannel **_retval);

	GTOCProtocolHandler () : GBaseProtocolHandler("toc")
				 {NS_INIT_ISUPPORTS();};
	virtual ~GTOCProtocolHandler() {};
	/* additional members */
  protected:
  	NS_METHOD CreatePage (void);
  	NS_METHOD CreateTOCPage (void);
  	NS_METHOD CreateInfoPage (void);
  	NS_METHOD CreateManPage (void);
  	NS_METHOD CreateHelpPage (const char *type,
  				  int (*select)(const struct dirent *));
  	nsCOMPtr<nsIURI> mURI;
	nsCOMPtr<nsIChannel> mChannel;
	nsCOMPtr<nsIStorageStream> mStream;
  	nsCString mDocType;
};

class nsIFactory;

extern nsresult NS_NewTOCHandlerFactory(nsIFactory** aFactory); 

#endif // TOCProtocolHandler_h__
