import unittest
from utils import refresh_gui, init_gazpacho
import gtk

app, project = init_gazpacho()

from gazpacho import command

class GtkButtonTest(unittest.TestCase):
        
    def test01Creation(self):
        global app, project
        app.palette.select_widget('Gtk+ Base', 'GtkWindow')
        refresh_gui()
        gwidget = project.get_widget_by_name('window1')
        app.palette.select_widget('Gtk+ Base', 'GtkButton')
        placeholder = gwidget.widget.get_child()
        cm = app.get_command_manager()
        cm.create(app.add_class, placeholder, None)
        refresh_gui()
        gwidget = project.get_widget_by_name('button1')
        self.assertEqual(gtk.Button, type(gwidget.widget))

    def test02Property(self):
        global app, project
        gwidget = project.get_widget_by_name('button1')
        prop = gwidget.get_glade_property('label')
        cm = app.get_command_manager()
        cm.set_property(prop, 'Click me!')
        refresh_gui()
        self.assertEqual(gwidget.widget.get_label(), 'Click me!')

    def test03Saving(self):
        global project
        project.save(__file__+'.glade')
        refresh_gui()
        
    def test04Loading(self):
        global app
        app.open_project(__file__+'.glade')
        refresh_gui()
        
if __name__ == '__main__':
    suite = unittest.TestSuite()
    suite.addTest(unittest.makeSuite(GtkButtonTest))
    unittest.TextTestRunner(verbosity=2).run(suite)
