/*
 * Gnome Basic Arrays
 *
 * Author:
 *    Michael Meeks <michael@imaginator.com>
 *
 * Copyright 2000, Helix Code, Inc.
 */

#ifndef GBRUN_ARRAY_H
#define GBRUN_ARRAY_H

#include <gbrun/gbrun-object.h>

#define GBRUN_TYPE_ARRAY            (gbrun_array_get_type ())
#define GBRUN_ARRAY(obj)            (GTK_CHECK_CAST ((obj), GBRUN_TYPE_ARRAY, GBRunArray))
#define GBRUN_ARRAY_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), GBRUN_TYPE_ARRAY, GBRunArrayClass))
#define GBRUN_IS_ARRAY(obj)         (GTK_CHECK_TYPE ((obj), GBRUN_TYPE_ARRAY))
#define GBRUN_IS_ARRAY_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GBRUN_TYPE_ARRAY))

struct _GBRunArray {
	GBObject    object;

	GtkType     content_type;

	GSList     *indicees;
	gpointer    data;
};

struct _GBRunArrayClass {
	GBObjectClass priv;
};

GtkType        gbrun_array_get_type (void);

GBObject      *gbrun_array_new      (GBRunEvalContext *ec,
				     const GBVar      *var);

GBObject      *gbrun_array_new_vals (GBRunEvalContext *ec,
				     GSList           *values);

#endif /* GBRUN_ARRAY_H */
