#include "gbrun-global.h"

static void
gbrun_global_destroy (GtkObject *global)
{
	GSList *l;
	GBRunGlobal *obj = (GBRunGlobal *) global;

	for (l = obj->children; l; l = l->next)
		gtk_object_unref (l->data);

	g_slist_free (obj->children);
	obj->children = NULL;
}

static void
gbrun_global_copy (GBEvalContext  *ec,
		   GBObject       *src,
		   GBObject       *dest)
{
	g_warning ("Copying all global functions is not implemented");
}

static gboolean
gbrun_global_assign (GBEvalContext  *ec,
		     GBObject       *object,
		     const GBObjRef *ref,
		     GBValue        *value,
		     gboolean        try_assign)
{
	GSList  *l;
	GBRunGlobal *obj = GBRUN_GLOBAL (object);

	for (l = obj->children; l; l = l->next) {
		if (gb_object_assign (ec, l->data, ref, value, try_assign))
			return TRUE;
	}

	return FALSE;
}

static GBValue *
gbrun_global_deref (GBEvalContext  *ec,
		    GBObject       *object,
		    const GBObjRef *ref,
		    gboolean        try_deref)
{
	GSList  *l;
	GBValue *ret;
	GBRunGlobal *obj = GBRUN_GLOBAL (object);

	for (l = obj->children; l; l = l->next) {
		if ((ret = gb_object_deref (ec, l->data, ref, try_deref)))
			return ret;
	}

	return NULL;
}

static void
gbrun_global_class_init (GBRunGlobalClass *klass)
{
	GBObjectClass  *gb_class = (GBObjectClass *) klass;
	GtkObjectClass *gtk_class = (GtkObjectClass *) klass;

	gb_class->copy   = gbrun_global_copy;
	gb_class->assign = gbrun_global_assign;
	gb_class->deref  = gbrun_global_deref;

	gtk_class->destroy = gbrun_global_destroy;
}

GtkType
gbrun_global_get_type (void)
{
	static GtkType global_type = 0;

	if (!global_type) {
		static const GtkTypeInfo global_info = {
			"GBRunGlobal",
			sizeof (GBRunGlobal),
			sizeof (GBRunGlobalClass),
			(GtkClassInitFunc)  gbrun_global_class_init,
			(GtkObjectInitFunc) NULL,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		global_type = gtk_type_unique (GB_TYPE_OBJECT, &global_info);
		gtk_type_class (global_type);

		/* FIXME: need a g_atexit (unref_global) */
	}

	return global_type;	
}

GBObject *
gbrun_global_get (void)
{
	static GBObject *global = NULL;

	if (!global)
		global = gtk_type_new (gbrun_global_get_type ());

	return global;
}

void
gbrun_global_add (GBObject *object)
{
	GBRunGlobal *global = GBRUN_GLOBAL (gbrun_global_get ());

	g_return_if_fail (GB_IS_OBJECT (object));

	global->children = g_slist_prepend (global->children, object);
}
