/*
 * Copyright (C) 2010 - Jesse van den Kieboom
 *
 * gedit-collaboration is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gedit-collaboration is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gedit-collaboration. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GEDIT_COLLABORATION_COLOR_BUTTON_H__
#define __GEDIT_COLLABORATION_COLOR_BUTTON_H__

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define GEDIT_COLLABORATION_TYPE_COLOR_BUTTON			(gedit_collaboration_color_button_get_type ())
#define GEDIT_COLLABORATION_COLOR_BUTTON(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), GEDIT_COLLABORATION_TYPE_COLOR_BUTTON, GeditCollaborationColorButton))
#define GEDIT_COLLABORATION_COLOR_BUTTON_CONST(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), GEDIT_COLLABORATION_TYPE_COLOR_BUTTON, GeditCollaborationColorButton const))
#define GEDIT_COLLABORATION_COLOR_BUTTON_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), GEDIT_COLLABORATION_TYPE_COLOR_BUTTON, GeditCollaborationColorButtonClass))
#define GEDIT_COLLABORATION_IS_COLOR_BUTTON(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEDIT_COLLABORATION_TYPE_COLOR_BUTTON))
#define GEDIT_COLLABORATION_IS_COLOR_BUTTON_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GEDIT_COLLABORATION_TYPE_COLOR_BUTTON))
#define GEDIT_COLLABORATION_COLOR_BUTTON_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS ((obj), GEDIT_COLLABORATION_TYPE_COLOR_BUTTON, GeditCollaborationColorButtonClass))

typedef struct _GeditCollaborationColorButton	GeditCollaborationColorButton;
typedef struct _GeditCollaborationColorButtonClass	GeditCollaborationColorButtonClass;
typedef struct _GeditCollaborationColorButtonPrivate	GeditCollaborationColorButtonPrivate;

struct _GeditCollaborationColorButton
{
	GtkColorButton parent;

	GeditCollaborationColorButtonPrivate *priv;
};

struct _GeditCollaborationColorButtonClass
{
	GtkColorButtonClass parent_class;
};

GType gedit_collaboration_color_button_get_type (void) G_GNUC_CONST;
void _gedit_collaboration_color_button_register_type (GTypeModule *type_module);

GeditCollaborationColorButton *gedit_collaboration_color_button_new (void);

void gedit_collaboration_color_button_set_hue (GeditCollaborationColorButton *button,
                                               gdouble                        hue);

gdouble gedit_collaboration_color_button_get_hue (GeditCollaborationColorButton *button);

G_END_DECLS

#endif /* __GEDIT_COLLABORATION_COLOR_BUTTON_H__ */
