/* gegl.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Gegl", lower_case_cprefix = "gegl_")]
namespace Gegl {
	[CCode (cprefix = "GEGL_BLIT_", has_type_id = "0", cheader_filename = "gegl.h")]
	public enum BlitFlags {
		DEFAULT,
		CACHE,
		DIRTY
	}
	[CCode (cprefix = "GEGL_INTERPOLATION_", has_type_id = "0", cheader_filename = "gegl.h")]
	public enum Interpolation {
		NEAREST,
		LINEAR
	}
	[CCode (cprefix = "GEGL_PARAM_PAD_", has_type_id = "0", cheader_filename = "gegl.h")]
	public enum PadType {
		OUTPUT,
		INPUT
	}
	[CCode (cheader_filename = "gegl.h")]
	public class Processor : GLib.Object {
		[CCode (cname = "gegl_node_new_processor")]
		public Processor (Gegl.Node sink, Gegl.Rectangle? rect = null);
		public void destroy ();
		public void set_rectangle (Gegl.Rectangle rectangle);
		public bool work (out double progress);
		[NoAccessorMethod]
		public weak int chunksize { get; construct; }
		[NoAccessorMethod]
		public weak Gegl.Node node { set construct; }
		[NoAccessorMethod]
		public weak double progress { get; set; }
	}
	[CCode (cheader_filename = "gegl.h")]
	public class Node : GLib.Object, Gegl.Visitable {
		public Node ();
		public Node.from_file (string path);
		public Node.from_xml (string xmldata, string path_root);
		public weak Gegl.Node new_child (...);
		public weak Gegl.Node create_child (string operation);
		public weak Gegl.Node adopt_child (Gegl.Node child);
		public weak Gegl.Node add_child (Gegl.Node child);
		public weak Gegl.Node remove_child (Gegl.Node child);
		public bool connect_from (string input_pad_name, Gegl.Node source, string output_pad_name);
		public bool connect_to (string output_pad_name, Gegl.Node sink, string input_pad_name);
		public void link (Gegl.Node sink);
		public void link_many (...);
		public bool disconnect (string input_pad);
		public weak GLib.SList<Gegl.Node> get_children ();
		public int get_consumers (string output_pad, out weak Gegl.Node nodes, string pads);
		public weak string get_operation ();
		public weak Gegl.Node get_input_proxy (string pad_name);
		public weak Gegl.Node get_output_proxy (string pad_name);
		public weak Gegl.Node get_parent ();
		public weak Gegl.Node get_producer (string input_pad_name, string output_pad_name);
		public weak Gegl.Node detect (int x, int y);
		public Gegl.Rectangle get_bounding_box ();
		public void blit (double scale, Gegl.Rectangle roi, void* format, void* destination_buf, int rowstride, Gegl.BlitFlags flags);
		public void process ();
		public weak GLib.ParamSpec find_property (string property_name);
		public void get (...);
		public void set (...);
		public void get_property (string property_name, GLib.Value value);
		public void set_property (string property_name, GLib.Value value);
		public weak string to_xml (string path_root);
		[NoAccessorMethod]
		public weak string name { get; set construct; }
		[NoAccessorMethod]
		public weak string operation { get; set construct; }
		public signal void computed (Gegl.Rectangle p0);
		public signal void invalidated (Gegl.Rectangle p0);
	}
	[CCode (cheader_filename = "gegl.h")]
	public class Buffer : GLib.Object {
		public void copy (Gegl.Rectangle src_rect, Gegl.Buffer dst, Gegl.Rectangle dst_rect);
		public Gegl.Buffer create_sub_buffer (Gegl.Rectangle extent);
		public void destroy ();
		public Gegl.Buffer dup ();
		public void flush ();
		public void get (double scale, Gegl.Rectangle rect, void* format, void* dest, int rowstride);
		public Gegl.Rectangle get_extent ();
		public static Gegl.Interpolation interpolation_from_string (string str);
		public static weak Gegl.Buffer load (string path);
		public Buffer (Gegl.Rectangle? extent, void* format);
		public static weak Gegl.Buffer open (string path);
		public void sample (double x, double y, double scale, void* dest, void* format, Gegl.Interpolation interpolation);
		public void sample_cleanup ();
		public void save (string path, Gegl.Rectangle roi);
		public void set (Gegl.Rectangle rect, void* format, void* src, int rowstride);
		public bool set_extent (Gegl.Rectangle extent);
		[NoAccessorMethod]
		public weak int abyss_height { get; construct; }
		[NoAccessorMethod]
		public weak int abyss_width { get; construct; }
		[NoAccessorMethod]
		public weak int abyss_x { get; construct; }
		[NoAccessorMethod]
		public weak int abyss_y { get; construct; }
		[NoAccessorMethod]
		public weak void* format { get; set construct; }
		[NoAccessorMethod]
		public weak int height { get; set construct; }
		[NoAccessorMethod]
		public weak string path { get; set construct; }
		[NoAccessorMethod]
		public weak int pixels { get; }
		[NoAccessorMethod]
		public weak int px_size { get; }
		[NoAccessorMethod]
		public weak int shift_x { get; construct; }
		[NoAccessorMethod]
		public weak int shift_y { get; construct; }
		[NoAccessorMethod]
		public weak int tile_height { get; construct; }
		[NoAccessorMethod]
		public weak int tile_width { get; construct; }
		[NoAccessorMethod]
		public weak int width { get; set construct; }
		[NoAccessorMethod]
		public weak int x { get; set construct; }
		[NoAccessorMethod]
		public weak int y { get; set construct; }
		public signal void changed (Gegl.Rectangle p0);
	}
	[CCode (cheader_filename = "gegl.h")]
	public class Color : GLib.Object {
		public void get_rgba (float r, float g, float b, float a);
		public Color (string str);
		public void set_rgba (float r, float g, float b, float a);
	}
	[CCode (cheader_filename = "gegl.h")]
	public interface Visitable {
	}
	[CCode (cheader_filename = "gegl.h")]
	public struct Rectangle {
		public int x;
		public int y;
		public int width;
		public int height;
		public void bounding_box (Gegl.Rectangle src1, Gegl.Rectangle src2);
		public bool contains (Gegl.Rectangle s);
		public bool equal (Gegl.Rectangle s);
		public bool equal_coords (int x, int y, int width, int height);
		public bool intersect (Gegl.Rectangle src1, Gegl.Rectangle src2);
		public void set (int x, int y, uint width, uint height);
	}
	public const int AUTO_ROWSTRIDE;
	public const int MAJOR_VERSION;
	public const int MICRO_VERSION;
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "gegl.h")]
	public static weak GLib.Object config ();
	[CCode (cheader_filename = "gegl.h")]
	public static void exit ();
	[CCode (cheader_filename = "gegl.h")]
	public static void get_version (int major, int minor, int micro);
	[CCode (cheader_filename = "gegl.h")]
	public static void init ([CCode (array_length_pos = 0.9)] ref weak string[] argv);
}
