/*-*- java -*-*/

#include <glib.h>
#include <glib-object.h>
#include <babl/babl.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define TYPE_TEST_BABL (test_babl_get_type ())
#define TEST_BABL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEST_BABL, TestBabl))
#define TEST_BABL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEST_BABL, TestBablClass))
#define IS_TEST_BABL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEST_BABL))
#define IS_TEST_BABL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEST_BABL))
#define TEST_BABL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEST_BABL, TestBablClass))

typedef struct _TestBabl TestBabl;
typedef struct _TestBablClass TestBablClass;
typedef struct _TestBablPrivate TestBablPrivate;
typedef struct _ParamSpecTestBabl ParamSpecTestBabl;

struct _TestBabl {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TestBablPrivate * priv;
};

struct _TestBablClass {
	GTypeClass parent_class;
	void (*finalize) (TestBabl *self);
};

struct _ParamSpecTestBabl {
	GParamSpec parent_instance;
};


static gpointer test_babl_parent_class = NULL;

gpointer test_babl_ref (gpointer instance);
void test_babl_unref (gpointer instance);
GParamSpec* param_spec_test_babl (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_test_babl (GValue* value, gpointer v_object);
gpointer value_get_test_babl (const GValue* value);
GType test_babl_get_type (void);
enum  {
	TEST_BABL_DUMMY_PROPERTY
};
static gint test_babl_main (char** args, int args_length1);
TestBabl* test_babl_new (void);
TestBabl* test_babl_construct (GType object_type);
static void test_babl_finalize (TestBabl* obj);



static gint test_babl_main (char** args, int args_length1) {
	gint result;
	Babl* fmt;
	babl_init ();
	fmt = babl_format ("R'G'B' u8");
	fmt = NULL;
	g_printerr ("New Babl.Format created !\n");
	babl_destroy ();
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return test_babl_main (argv, argc);
}


TestBabl* test_babl_construct (GType object_type) {
	TestBabl* self;
	self = (TestBabl*) g_type_create_instance (object_type);
	return self;
}


TestBabl* test_babl_new (void) {
	return test_babl_construct (TYPE_TEST_BABL);
}


static void value_test_babl_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_test_babl_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		test_babl_unref (value->data[0].v_pointer);
	}
}


static void value_test_babl_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = test_babl_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_test_babl_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_test_babl_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		TestBabl* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = test_babl_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_test_babl_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TestBabl** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = test_babl_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_test_babl (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecTestBabl* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TEST_BABL), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_test_babl (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEST_BABL), NULL);
	return value->data[0].v_pointer;
}


void value_set_test_babl (GValue* value, gpointer v_object) {
	TestBabl* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEST_BABL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TEST_BABL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		test_babl_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		test_babl_unref (old);
	}
}


static void test_babl_class_init (TestBablClass * klass) {
	test_babl_parent_class = g_type_class_peek_parent (klass);
	TEST_BABL_CLASS (klass)->finalize = test_babl_finalize;
}


static void test_babl_instance_init (TestBabl * self) {
	self->ref_count = 1;
}


static void test_babl_finalize (TestBabl* obj) {
	TestBabl * self;
	self = TEST_BABL (obj);
}


GType test_babl_get_type (void) {
	static GType test_babl_type_id = 0;
	if (test_babl_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { value_test_babl_init, value_test_babl_free_value, value_test_babl_copy_value, value_test_babl_peek_pointer, "p", value_test_babl_collect_value, "p", value_test_babl_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TestBablClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) test_babl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TestBabl), 0, (GInstanceInitFunc) test_babl_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		test_babl_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TestBabl", &g_define_type_info, &g_define_type_fundamental_info, 0);
	}
	return test_babl_type_id;
}


gpointer test_babl_ref (gpointer instance) {
	TestBabl* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void test_babl_unref (gpointer instance) {
	TestBabl* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TEST_BABL_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}




