/*
 * Ascii Table plugin
 *
 * Authors:
 *   Steffen Kern (alfi@pn.org)
 *   JP Rosevear (jpr@arcavia.com)
 */

#include "../../src/gide.h"
#include "../../src/gI_plugin.h"
#include "../../src/gI_tools.h"
#include "../../src/gide-tools.h"

#define ASCIITABLE_NAME  _("Utilities - Ascii Table")
#define ASCIITABLE_TITLE _("Ascii Table Plugin")
#define ASCIITABLE_DESCR _("Display an ascii table for use.")

static void
plugin_asciitable_select( GtkWidget *clist, gint row, gint column,
			  GdkEventButton *bevent, gpointer data )
{
	if( !bevent )
		return;
	
	if( bevent->type == GDK_2BUTTON_PRESS )
	{
		GideDocument *current;
		gchar *ch;
		
		current = gI_window_get_current_doc( GIDE_WINDOW(data) );
		if( !current )
			return;
		
		gtk_clist_get_text( GTK_CLIST( clist ), row, 0, &ch );
		ch += 2;
		
		gI_document_insert_text_at_point( current, ch );
	}
}

static void
plugin_asciitable ( Tool *tool, ToolState *state )
{
	GtkWidget *window;
	GtkWidget *scrwindow;
	GtkWidget *clist;
	gchar *items[4];
	gchar ch[10];
	gchar dec[10];
	gchar hex[10];
	gchar oct[10];
	gint i;
	gchar *list_titles[] = { "Char", "Dec#", "Hex#", "Oct#" };

	window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	gtk_signal_connect( GTK_OBJECT( window ), "destroy",
			    GTK_SIGNAL_FUNC( gtk_widget_destroyed ), NULL );
	gtk_window_set_title( GTK_WINDOW( window ), _("Tools - ASCII Table") );
	gtk_widget_set_usize( window, 210, 400 );
	
	scrwindow = gtk_scrolled_window_new( NULL, NULL );
	gtk_container_add( GTK_CONTAINER( window ), scrwindow );
	
	clist = gtk_clist_new_with_titles( 4, list_titles );
	gtk_signal_connect( GTK_OBJECT( clist ), "select_row",
			    GTK_SIGNAL_FUNC( plugin_asciitable_select ),
			    state->window );
	gtk_container_add( GTK_CONTAINER( scrwindow ), clist );
	gtk_clist_column_titles_passive( GTK_CLIST( clist ) );
	gtk_clist_set_column_width( GTK_CLIST( clist ), 0, 40 );
	gtk_clist_set_column_width( GTK_CLIST( clist ), 1, 40 );
	gtk_clist_set_column_width( GTK_CLIST( clist ), 2, 40 );
	gtk_clist_set_column_width( GTK_CLIST( clist ), 3, 40 );
	
	/* fill list */
	for(i=0;i<256;i++)
	{
		sprintf( ch, "%3c", i );
		sprintf( dec, "%3d", i );
		sprintf( hex, "0x%2.2X", i );
		sprintf( oct, "%3.3o", i );
		
		items[0] = ch;
		items[1] = dec;
		items[2] = hex;
		items[3] = oct;
		
		gtk_clist_append( GTK_CLIST( clist ), items );
	}
	
	gtk_widget_show_all( window );
}

static gboolean
plugin_asciitable_sens ( Tool *tool, ToolState *state )
{
	return TRUE;
}

static int
can_unload (PluginData *pd)
{
	return 1;
}

static void
cleanup_plugin (PluginData *pd)
{
	gide_tool_remove( ASCIITABLE_NAME );
}

PluginInitResult
init_plugin (CommandContext *context, PluginData *pd)
{
	GtkObject *tool;
	
	if (plugin_version_mismatch  (context, pd, VERSION))
		return PLUGIN_QUIET_ERROR;
	
	tool = gI_tool_new( ASCIITABLE_NAME, (void *) plugin_asciitable);
	gI_tool_set_menu_data( TOOL(tool), plugin_asciitable_sens,
			       "Tools/Utilities/ASCII Table", NULL);
	gide_tool_add( TOOL(tool) );
		
	if (plugin_data_init (pd, can_unload, cleanup_plugin,
                              ASCIITABLE_TITLE, ASCIITABLE_DESCR))
                return PLUGIN_OK;
        else
                return PLUGIN_ERROR;		     	
}






















