/*
 * Calculator plugin
 *
 * Authors:
 *   Steffen Kern (alfi@pn.org)
 *   JP Rosevear (jpr@arcavia.com)
 */

#include <string.h>
#include "../../src/gide.h"
#include "../../src/gI_plugin.h"
#include "../../src/gI_tools.h"
#include "../../src/gide-tools.h"

#define DOCSTAT_NAME  _("Document Statistics")
#define DOCSTAT_TITLE _("Document Statistics Plugin")
#define DOCSTAT_DESCR _("Display a dialog with document statistics.")

static void
plugin_docstat ( Tool *tool, ToolState *state )
{
	gchar tmp[255];
	gchar *c;
	gint in_word = 0;
	glong words = 0;
	glong chars = 0;
	glong chars_ns = 0;
	GtkWidget *dlg;
	GtkWidget *label;

	glong i;
	glong length;

	length = gI_text_get_length( state->document );
	
	/* go thru document... */
	for(i=1;i<=length;i++)
	{
		c = gtk_editable_get_chars( GTK_EDITABLE( state->document ),
					    i-1, i );
		
		/* Character/Word Counters */
		chars++;
		if( !isspace( *c ) ) {
			chars_ns++;
			
			if( *c == ',' || *c == ';' ||
			    *c == ':' || *c == '.' ) {
				if( in_word ) {
					in_word = 0;
				}
			} else {
				if( !in_word ) {
					in_word = 1;
					words++;
				}
			}
		} else {
			if ( in_word ) {
				in_word = 0;
			}
		}
		
		g_free( c );
	}
	
	/* Dialog */
	dlg = gnome_dialog_new( "Tools - Word Count",
			       GNOME_STOCK_BUTTON_OK, NULL );

	g_snprintf( tmp, 255, _("Characters: %ld"), chars );
	label = gtk_label_new( tmp );
	gtk_widget_show( label );
	gtk_box_pack_start( GTK_BOX( GNOME_DIALOG( dlg )->vbox ),
			    label, FALSE, TRUE, 5 );

	g_snprintf( tmp, 255, _("Non-Space Characters: %ld"), chars_ns );
	label = gtk_label_new( tmp );
	gtk_widget_show( label );
	gtk_box_pack_start( GTK_BOX( GNOME_DIALOG( dlg )->vbox ),
			    label, FALSE, TRUE, 5 );
		       
	g_snprintf( tmp, 255, _("Words: %ld"), words );
	label = gtk_label_new( tmp );
	gtk_widget_show( label );
	gtk_box_pack_start( GTK_BOX( GNOME_DIALOG( dlg )->vbox ),
			    label, FALSE, TRUE, 5 );
		
	gnome_dialog_run_and_close( GNOME_DIALOG(dlg) );
}

static gboolean
plugin_docstat_sens ( Tool *tool, ToolState *state )
{
	if (state->document)
		return TRUE;

	return FALSE;
}

static int
can_unload (PluginData *pd)
{
	return 1;
}

static void
cleanup_plugin (PluginData *pd)
{
	gide_tool_remove( DOCSTAT_NAME );
}

PluginInitResult
init_plugin (CommandContext *context, PluginData *pd)
{
	GtkObject *tool;
	
	if (plugin_version_mismatch  (context, pd, VERSION))
		return PLUGIN_QUIET_ERROR;
	
	tool = gI_tool_new( DOCSTAT_NAME, (void *) plugin_docstat );
	gI_tool_set_menu_data( TOOL(tool), plugin_docstat_sens,
			       "Tools/Document Statistics...", NULL);
	gide_tool_add( TOOL(tool) );
		
	if (plugin_data_init (pd, can_unload, cleanup_plugin,
                              DOCSTAT_TITLE, DOCSTAT_DESCR))
                return PLUGIN_OK;
        else
                return PLUGIN_ERROR;
}

