/*
 * Sample plugin demostration
 *
 * Authors:
 *   Tom Dyas (tdyas@romulus.rutgers.edu)
 *   JP Rosevear (jpr@arcavia.com)
 */

#include "../../src/gide.h"
#include "../../src/gI_plugin.h"
#include "../../src/gI_tools.h"
#include "../../src/gide-tools.h"

#define SAMPLE_NAME  _("Hello World")
#define SAMPLE_TITLE _("Hello World Plugin")
#define SAMPLE_DESCR _("Sample Gide Plugin")

static void
hello_world ( Tool *tool, ToolState *state )
{
	gI_document_insert_text_at_point( state->document, "Hello, world!"); 
}

static gboolean
hello_world_sens ( Tool *tool, ToolState *state )
{
	if (state->document)
		return TRUE;

	return FALSE;
}

static int
can_unload (PluginData *pd)
{
	return 1;
}

static void
cleanup_plugin (PluginData *pd)
{
	gide_tool_remove( SAMPLE_NAME );
}

PluginInitResult
init_plugin (CommandContext *context, PluginData *pd)
{
	GtkObject *tool;
	
	if (plugin_version_mismatch  (context, pd, VERSION))
		return PLUGIN_QUIET_ERROR;

	tool = gI_tool_new( SAMPLE_NAME, (void *) hello_world);
	gI_tool_set_menu_data( TOOL(tool), hello_world_sens, 
			       "Tools/Sample/\"Hello, world!\"", NULL);
	gide_tool_add( TOOL(tool) );

	if (plugin_data_init (pd, can_unload, cleanup_plugin,
                              SAMPLE_TITLE, SAMPLE_DESCR))
                return PLUGIN_OK;
        else
                return PLUGIN_ERROR;
}

