/*
 * Text plugin
 *
 * Author:
 *   JP Rosevear (jpr@arcavia.com)
 */

#include "../../src/gide.h"
#include "../../src/gI_plugin.h"
#include "../../src/gI_tools.h"
#include "../../src/gide-tools.h"
#include "plugin_text_insert.h"
#include "plugin_text_replace.h"
#include "plugin_text_delete.h"

#define TEXT_INSERT_DATE_NAME  _("Text - Insert Date and Time")
#define TEXT_INSERT_GPL_NAME   _("Text - Insert GPL (C)")
#define TEXT_INSERT_GPLP_NAME  _("Text - Insert GPL (C++)")
#define TEXT_DELETE_BOF_NAME   _("Text - Delete To Beginning of File")
#define TEXT_DELETE_EOF_NAME   _("Text - Delete To End of File")
#define TEXT_DELETE_BOL_NAME   _("Text - Delete To Beginning of Line")
#define TEXT_DELETE_EOL_NAME   _("Text - Delete To End of Line")
#define TEXT_REPLACE_TABS_NAME _("Text - Replace Tabs with Spaces")
#define TEXT_TITLE _("Text Plugin")
#define TEXT_DESCR _("Text utilities.")

static gboolean
plugin_text_sens ( Tool *tool, ToolState *state )
{
	if (state->document)
		return TRUE;

	return FALSE;
}

static void
plugin_text_init ( void )
{
	GtkObject *tool;
	
	tool = gI_tool_new( TEXT_INSERT_DATE_NAME,
			    (void *) plugin_text_insert_date);
	gI_tool_set_menu_data( TOOL(tool), plugin_text_sens,
			       "Edit/Insert/Date and Time", NULL);
	gide_tool_add( TOOL(tool) );

	tool = gI_tool_new( TEXT_INSERT_GPL_NAME,
			    (void *) plugin_text_insert_gpl_c);
	gI_tool_set_menu_data( TOOL(tool), plugin_text_sens,
			       "Edit/Insert/License/GPL - Notice (C)", NULL);
	gide_tool_add( TOOL(tool) );
	
	tool = gI_tool_new( TEXT_INSERT_GPLP_NAME,
			    (void *) plugin_text_insert_gpl_cpp);
	gI_tool_set_menu_data( TOOL(tool), plugin_text_sens,
			       "Edit/Insert/License/GPL - Notice (C++)", NULL);
	gide_tool_add( TOOL(tool) );

	tool = gI_tool_new( TEXT_REPLACE_TABS_NAME,
			    (void *) plugin_text_replace_tab_spaces);
	gI_tool_set_menu_data( TOOL(tool), plugin_text_sens,
			       "Edit/Replace/Tabs with spaces", NULL);
	gide_tool_add( TOOL(tool) );

	tool = gI_tool_new( TEXT_DELETE_BOF_NAME,
			    (void *) plugin_text_delete_to_bof);
	gI_tool_set_menu_data( TOOL(tool), plugin_text_sens,
			       "Edit/Delete/To beginning of file", NULL);
	gide_tool_add( TOOL(tool) );
		
	tool = gI_tool_new( TEXT_DELETE_EOF_NAME,
			    (void *) plugin_text_delete_to_eof);
	gI_tool_set_menu_data( TOOL(tool), plugin_text_sens,
			       "Edit/Delete/To end of file", NULL);
	gide_tool_add( TOOL(tool) );

	tool = gI_tool_new( TEXT_DELETE_BOL_NAME,
		 	    (void *) plugin_text_delete_to_bol);
	gI_tool_set_menu_data( TOOL(tool), plugin_text_sens,
			       "Edit/Delete/To beginning of line", NULL);
	gide_tool_add( TOOL(tool) );

	tool = gI_tool_new( TEXT_DELETE_EOL_NAME,
			    (void *) plugin_text_delete_to_eol);
	gI_tool_set_menu_data( TOOL(tool), plugin_text_sens,
			       "Edit/Delete/To end of line", NULL);
	gide_tool_add( TOOL(tool) );

}

static int
can_unload (PluginData *pd)
{
	return 1;
}

static void
cleanup_plugin (PluginData *pd)
{
	gide_tool_remove( TEXT_INSERT_DATE_NAME );
	gide_tool_remove( TEXT_INSERT_GPL_NAME );
	gide_tool_remove( TEXT_INSERT_GPLP_NAME );
	gide_tool_remove( TEXT_DELETE_BOF_NAME );
	gide_tool_remove( TEXT_DELETE_EOF_NAME );
	gide_tool_remove( TEXT_DELETE_BOL_NAME );
	gide_tool_remove( TEXT_DELETE_EOL_NAME );
	gide_tool_remove( TEXT_REPLACE_TABS_NAME );
}

PluginInitResult
init_plugin (CommandContext *context, PluginData *pd)
{
	if (plugin_version_mismatch  (context, pd, VERSION))
		return PLUGIN_QUIET_ERROR;
	
	plugin_text_init();
	
	if (plugin_data_init (pd, can_unload, cleanup_plugin,
                              TEXT_TITLE, TEXT_DESCR))
                return PLUGIN_OK;
        else
                return PLUGIN_ERROR;
}

