/* $Header: /cvs/gnome/gIDE/src/gI_document.h,v 1.13 2000/03/26 21:44:48 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GI_DOCUMENT_H
#define GI_DOCUMENT_H

#include <config.h>
#include <gnome.h>
#include <stdio.h>
#include "structs.h"
#include "gI_text.h"
#include "gI_search.h"

#ifdef HAVE_GTKTEXT_PATCH
#include <gtksctext.h>
#include <gtkeditor/gtkeditor.h>
#endif

#define GIDE_DOCUMENT(o)          (GTK_CHECK_CAST ((o), gI_document_get_type(), GideDocument))
#define GIDE_DOCUMENT_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), gI_document_get_type(), GideDocumentClass))
#define IS_GIDE_DOCUMENT(o)       (GTK_CHECK_TYPE ((o), gI_document_get_type()))

typedef struct _GideDocument      GideDocument;
typedef struct _GideDocumentClass GideDocumentClass;

struct _GideDocumentClass {
#ifdef HAVE_GTKTEXT_PATCH
	GtkEditorClass text;
#else
	GtkTextClass text;
#endif

	void (* modified) (GideDocument *document);
	void (* unmodified) (GideDocument *document);
	void (* readonly) (GideDocument *document);
	void (* unreadonly) (GideDocument *document);
	void (* source) (GideDocument *document, gchar *filename);
};

struct _GideDocument {
#ifdef HAVE_GTKTEXT_PATCH
	GtkEditor text;
#else
	GtkText text;
#endif

	/* Undo support */
	GSList	   *undo_commands;
	GSList	   *redo_commands;
	
	gI_compile_window *compile_window;
	gint compile_id;

	GtkWidget *label;
	gchar *filename;
	gint changed;
	gint changed_id;
	guint x;
	guint y;
	gint read_only;
	gint working;
	gint last_mod;
	gint insert_id;
	gint delete_id;	
};


/*
 * Prototypes for 'gI_document.c'
 */
guint gI_document_get_type (void);
GtkWidget *gI_document_new( void );
GtkWidget *gI_document_new_with_file( const gchar *filename, FILE *file );

void gI_document_load_file( GideDocument *document, const gchar *filename,
			    FILE *file );
void gI_document_save_file( GideDocument *document, const gchar *filename,
			    FILE *file );
		       				  
void gI_document_set_undo_redo_state( GideDocument *doc,
				      char const * const undo_suffix,
				      char const * const redo_suffix);

/* Signal manipulators */
void gI_document_connect_event_signals( GideDocument *doc );
void gI_document_connect_text_signals( GideDocument *doc );
void gI_document_disconnect_text_signals( GideDocument *doc );

/* Functions to get/set state */
gboolean gI_document_is_free( GideDocument *document );
gboolean gI_document_is_changed( GideDocument *document );
void gI_document_set_changed_state( GideDocument *document, gboolean state );
void gI_document_set_readonly_state( GideDocument *document, gboolean state );

/* Text functions */
void gI_document_insert( GideDocument *document, GdkFont *font, GdkColor *fore,
                         GdkColor *back, const char *chars, gint length );
void gI_document_insert_text_at_point( GideDocument *document,
				       gchar *str );

void gI_document_delete( GideDocument *document, gint from, gint to );
void gI_document_delete_selection( GideDocument *document );

void gI_document_clear_text( GideDocument *document );

/* Searching */
gint gI_document_search( GideDocument *document, SearchReplaceState *state );

void gI_document_track_movement( GideDocument *document );
gint gI_document_show_popup_menu(GtkWidget *widget,GdkEvent *ev);

void gI_document_cmd_swaphc(GtkWidget *widget);
void gI_document_cmd_open_file_at_line(GtkWidget *widget);

/* Special functions */
glong get_column_from_point( glong point );
void special_remove_current_file( GtkWidget *widget, gpointer data );
void update_documents_style( void );
void check_current_doc(void);
void special_insert_file( GtkWidget *widget, gpointer data );
glong gI_document_get_pageno( GideDocument *document );
void gI_document_set_changed( GideDocument *document );
void special_mail_doc( GtkWidget *widget, gpointer data );
void show_manpage( GtkWidget *widget, gpointer data );


#endif




