/* $Header: /cvs/gnome/gIDE/src/gI_run.c,v 1.9 2000/04/22 17:23:01 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gide.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include "gI_file.h"
#include "gI_common.h"
#include "gI_project.h"
#include "gI_compile.h"
#include "gI_run.h"


/* globals */
static gchar parameters[STRLEN];
static GtkWidget *par_window = NULL;
static GtkWidget *e_par;


/* externs */
extern gchar gide_path[];


/* local prototypes */
static void gen_run_script( gchar *filename );


/*
 ---------------------------------------------------------------------
     Function: run_run()
     Desc: Callback-Function /Run/Run
 ---------------------------------------------------------------------
*/

void run_run( GtkWidget *widget, gpointer data )
{
    GideDocument *current;
    gchar filename[STRLEN];
    gchar str[STRLEN];
    gchar *ptr;
    gchar exec_string[MAXLEN];
    gI_project *project;
    FILE *tmpfile;
    glong i,length;
    glong exec_mod, src_mod;
	gchar *runscript;
    static glong recursed = 0;
	gchar *filep;

    current = gI_window_get_current_doc( main_window );

    if( !current )
		return;

	g_assert(IS_GIDE_WINDOW(data));

    /* special handling for projects,
		project handling has priority, maybe we need a pref. switch to
		decide this in the future... */
    project = gI_project_get_current();
    if( project && project->mtarget != NULL && !isempty( project->mtarget ) )
    {
        strcpy( filename, project->mtarget );
		if( !isempty( project->prjroot ) )
		{
			gchar *mtarget;

			mtarget = g_strconcat( project->prjroot, "/", project->mtarget, NULL );
			if( !file_exist( mtarget ) )
			{
				g_free( mtarget );

        		if( !file_exist( filename ) )
        		{
           			g_snprintf( str, STRLEN, _("\n    Can't find executable '%s'!    \n"), filename );
            		gI_error_dialog( str);
            		return;
        		} 
			}
			else
			{
				strcpy( filename, mtarget );
			}

			g_free( mtarget );
		}
		else
		{
        	if( !file_exist( filename ) )
        	{
           		g_snprintf( str, STRLEN, _("\n    Can't find executable '%s'!    \n"), filename );
            	gI_error_dialog( str);
            	return;
        	} 
    	} 
	}
    else
    {
		/* save the file, if the 'save and compile on run' configuration option is set */
		if( !recursed && current->filename && (current->changed || (get_last_mod( current->filename ) != current->last_mod)) && cfg->sor )
		{
			if( current->changed )
				file_save( NULL, GIDE_WINDOW(data) );

		    compile_compile_exec( NULL, GIDE_WINDOW(data) );

			/* let the stuff get compiled ... */
			while( current->working )
				gtk_main_iteration_do( TRUE );
		}

    	if( !current->filename )
    	{
            /* if theres no filename and the changed flag is not set, your
               text widget is empty! */
            if( !current->changed )
                return;

		    /* create a temp filename, save the current text widget content,
		       try to compile it to a exec. and try to run it */	

			filep = tempnam( cfg->tmpdir, "gide_run_" );  
		    strcpy( filename, filep ); 
			g_free( filep );
		    strcat( filename, ".c" ); 
		    tmpfile = fopen( filename, "w" );
		    if( !tmpfile )
		    {
			gI_error_dialog( _("Unable to Create the Temponary File!") );
		        return;
		    }	

		    length = gI_text_get_length( current );

		    for(i=1;i<=length;i++)
		        fputc( gtk_editable_get_chars( GTK_EDITABLE( current ), i-1, i )[0], tmpfile );

		    fclose( tmpfile );

		    current->filename = g_strdup( filename );

		    compile_compile_exec( NULL, GIDE_WINDOW(data) );

			/* let the stuff get compiled ... */
			while( current->working )
				gtk_main_iteration_do( TRUE );

			recursed = 1;

		    run_run( widget, data );

			recursed = 0;
	
		    /* let the compiled stuff get started (is 1sec enough??)...*/
		    sleep( 1 );
 
		    g_free( current->filename );
		    current->filename = NULL;

		    /* remove the temp. files */
		    remove( filename );
        
		    ptr = strrchr( filename, '.' );
   			if( ptr )
		    {
				*ptr = '\0';
				remove( filename );
		    }

		    return;
		}

		/* check if executable file exists */
	    strcpy( filename, current->filename );
		ptr = strrchr( filename, '.' );
		if( ptr )
		{
	  		*ptr = '\0';
	    	if( !file_exist( filename ) )
	    	{
				/* if executable does not exist, try to compile the current
		   		file to a executable and try to run it! */
				if( !recursed )
				{
					compile_compile_exec( NULL,
							      GIDE_WINDOW(data) );

		
			    	recursed = 1;

			    	run_run( widget, data );

			    	recursed = 0;		
	
			    	return;	
				}

				g_snprintf( str, STRLEN, _("\n    Can't find executable '%s'!    \n"), filename );
		        gI_error_dialog( str);
		        return;
			}
		    else
		    {
				exec_mod = get_last_mod( filename ); 
		
				strcpy( str, current->filename );
				src_mod = get_last_mod( str );
		        if( src_mod > exec_mod )
		        {
					gI_error_dialog( _("Source File is newer than Executable File!\n(maybe you should recompile it)") );
				}
		    }	
		}
    }

	runscript = g_strconcat( gide_path, "/", "helper-run.sh", NULL );
	if( !file_exist( runscript ) )
	{
		gen_run_script( runscript );
	}

	/* make sure that its executable */
	chmod( runscript, 0700 );

    g_snprintf( exec_string, MAXLEN, "%s -T \"(gIDE) Running: '%s'\" -e \"%s\" \"%s %s\" &", cfg->xterm, filename, runscript, filename, parameters );

    system( exec_string );

	g_free( runscript );
}


static void par_window_destroy( GtkWidget *widget, gpointer data )
{
    gtk_widget_destroy( par_window );
    par_window = NULL;
}


static void run_parameters_ok( GtkWidget *widget, gpointer data )
{
    strncpy( parameters, gtk_entry_get_text( GTK_ENTRY( e_par ) ), STRLEN );
    par_window_destroy( NULL, NULL );
}


/*
 ---------------------------------------------------------------------
     Function: run_parameters()
     Desc: Callback-Function /Run/Parameters
 ---------------------------------------------------------------------
*/

void run_parameters( GtkWidget *widget, gpointer data )
{
    GtkWidget *hbox;
    GtkWidget *button;
    
    if( par_window )
        return;
    
    par_window = gtk_window_new( GTK_WINDOW_DIALOG );
    gtk_window_set_title( GTK_WINDOW( par_window ), _("Run - Parameters") );
    gtk_signal_connect( GTK_OBJECT( par_window ), "destroy",
                        GTK_SIGNAL_FUNC( par_window_destroy ), NULL );
    gtk_container_set_border_width( GTK_CONTAINER( par_window ), 10 );
    gtk_window_set_position( GTK_WINDOW( par_window ), GTK_WIN_POS_MOUSE );

    hbox = gtk_hbox_new( FALSE, 0 );
    gtk_container_add( GTK_CONTAINER( par_window ), hbox );
    gtk_widget_show( hbox );

    e_par = gtk_entry_new_with_max_length( 255 );
    gtk_box_pack_start( GTK_BOX( hbox ), e_par, TRUE, TRUE, 5 );
    gtk_widget_grab_focus( e_par );
    gtk_signal_connect( GTK_OBJECT( e_par ), "activate",
                        GTK_SIGNAL_FUNC( run_parameters_ok ), NULL );
    gtk_widget_show( e_par );

    button = gnome_stock_button( GNOME_STOCK_BUTTON_OK );
    gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, TRUE, 5 );
    gtk_signal_connect( GTK_OBJECT( button ), "clicked",
                        GTK_SIGNAL_FUNC( run_parameters_ok ), NULL );
    GTK_WIDGET_SET_FLAGS( button, GTK_CAN_DEFAULT );
    gtk_widget_grab_default( button );
    gtk_widget_show( button );

    if( parameters )
        gtk_entry_set_text( GTK_ENTRY( e_par ), parameters );
    
    gtk_widget_show( par_window );
}


static void gen_run_script( gchar *filename )
{
	FILE *f;

	f = fopen( filename, "w" );
	if( !f )
	{
		gchar str[100];

		g_snprintf( str, sizeof(str), _("Unable to create helper script: %s\n\nRetry?"), strerror( errno ) );
		if( gI_ask_dialog( str) == 0 ) /* YES */
		{
			gen_run_script( filename );
		}
		return;
	}

	fprintf( f, "#!%s\n", cfg->bash );
	fprintf( f, "# Helper Script for gIDE: /Run/Run\n" );
	fprintf( f, "$1\n" );
	fprintf( f, "echo\n" );
	fprintf( f, "echo \"Press enter to continue...\"\n" );
	fprintf( f, "read\n" );

	fclose( f );
}

