/* $Header: /cvs/gnome/gIDE/src/gI_tools.h,v 1.14 2000/04/16 04:59:57 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GI_TOOLS_H
#define GI_TOOLS_H

#include "gide.h"
#include "gI_project.h"

#define TOOL(o)          (GTK_CHECK_CAST ((o), gI_tool_get_type(), Tool))
#define TOOL_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), gI_tool_get_type(), ToolClass))
#define IS_TOOL(o)       (GTK_CHECK_TYPE ((o), gI_tool_get_type()))

typedef struct _Tool      Tool;
typedef struct _ToolClass ToolClass;
typedef struct _ToolState ToolState;

struct _ToolClass {
	GtkObjectClass   parent_class;
};

struct _Tool {
	GtkObject object;

	gchar *name;
	gchar *menu_name;
	gchar *popup_name;

	void (*func) ( Tool *, ToolState * );
	gboolean (*sens_func) ( Tool *, ToolState * );
};

struct _ToolState {
	GideWindow *window;
	GideDocument *document;
	gI_project *project;
};

/*
 * Prototypes for 'gI_tools.c'
 */
guint gI_tool_get_type (void);
GtkObject *gI_tool_new( const char * name, void *func );
void gI_tool_set_menu_data( Tool *tool, void *sens_func,
			    const char *menu_name,
			    const char *popup_name );

#endif




