/* $Header: /cvs/gnome/gIDE/src/structs.h,v 1.12 2000/04/22 17:23:01 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef STRUCTS_H
#define STRUCTS_H

#include <config.h>
#include <gnome.h>
#include <stdio.h>

#ifdef HAVE_GTKTEXT_PATCH
#include <gtkeditor/gtkeditor.h>
#endif

/* defines */
#define STRLEN							1024
#define MAXLEN							4096
#define MAXFILES						256
#define MAXFUNC							1024
#define MAXPARM							16
#define MAX_TOOLBAR_ITEMS				25
#define MAX_PROJECT_FILES				100
#define MAX_PROJECT_TARGETS				50
#define MAX_TODO_ITEMS					250

#define NOT_IMPLEMENTED printf( "%s(): Not Implemented!\n", __FUNCTION__ )

#define HISTORY							"gide.history"
#define FUNC_IGN_FILE					"functions.ignore"
#define FUNC_HL_FILE					"functions.highlight"

#ifdef HAVE_GUILE
#define CONFIG							"gide.scm"
#define PATTERNS						"patterns.scm"
#define GLOBASSOC						"glob.scm"
#else
#define CONFIG							"gide.conf"
#define PATTERNS						"patterns"
#define GLOBASSOC						"glob"
#endif

#define CSET_FILE						"compile_sets"

/* Structs for gIDE */

typedef struct _gI_compile_window
{
	GtkWidget*							window;
	GtkWidget*							list;
	GtkWidget*							comp_dialog;
	GtkWidget*							close_button;
	gint pid;
} gI_compile_window;

typedef struct _gI_brkpnt_window
{
	GtkWidget*							window;
	GtkWidget*							list;
	GtkItemFactory*						popup_menu;
} gI_brkpnt_window;

typedef struct _gI_watch_window
{
	GtkWidget*							window;
	GtkWidget*							list;
	GtkItemFactory*						popup_menu;
	gchar*								data;
} gI_watch_window;

typedef struct _gI_bt_window
{
	GtkWidget*							window;
	GtkWidget*							list;
	GtkItemFactory*						popup_menu;
} gI_bt_window;

typedef struct _gI_debug_window
{
	GtkWidget*							window;
	GtkWidget*							statusbar;
	GtkWidget*							text;
	GtkWidget*							entry;
	gI_brkpnt_window*					brkpnt_window;
	gI_watch_window*					watch_window;
	gI_bt_window*						bt_window;
	GtkWidget*							popup_menu;
	gint								pid;
	gint								fh_in;
	gint								fh_out;
	gchar*								sockname;
	gint								input_id;
	GList*								breakpoints;
	GList*								cmd_queue;
	gint								state;
	gint								wait_for;
} gI_debug_window;

typedef struct _gI_config
{
	gint								about;
	gchar*								cfgfile;

	/* compile sets */
	GList*								csets;

	/* compile */
	gchar*								cc;
	gchar*								ld;
	gchar*								incpath;
	gchar*								ccopt;
	gchar*								libpath;
	gchar*								ldopt;

	/* debug */
	gchar*								db;

	/* directories */
	gchar*								tmpdir;

	/* editor */
	gchar*								fontname;
/*	GdkFont*							font;
*/
	GtkStyle*							style;
	gint								disable_font_stuff;
	GdkColor*							bgcol;
	GdkColor*							fgcol;
	gint								wordwrap;
	gint								autosave;
	gint								autosave_freq;
	gint								use_redit;
	gchar*								redit;
	gint								highlight;
	gchar*								ign_file;
	gint								tab_width;
#ifdef HAVE_GTKTEXT_PATCH
	gint								edtab;
#endif

	/* misc */
	gint								toolbar;
	gint								toolbar_custom;
	gchar*								toolbar_custom_items[MAX_TOOLBAR_ITEMS];
	gint								toolbar_custom_items_no;
	gchar*								bash;
	gchar*								make;
	gchar*								man;
	gchar*								xterm;
	gint								sor;

	/* user/host */
	gchar*								email;
	gchar*								smtp;

	/* projects */
	gint								prjftree;
	gint								changelog;
	gint								remdone;

#ifdef HAVE_GTKTEXT_PATCH
	/* highlighting */
	gchar*								patternfile;
	gchar*								globassocfile;
	gchar*								hli_file;
#endif
} gI_config;

typedef struct _gI_brkpnt
{
	gchar*								file;
	gint								line;
	gint								no;
} gI_brkpnt;

typedef struct _gI_gdbcmd
{
	gchar*								cmd;
	gint								show;
	gint								status;
} gI_gdbcmd;

#ifdef HAVE_GTKTEXT_PATCH
typedef struct _gI_pat_dialog
{
	GtkWidget*							dialog;
	GtkEditor*							buf;
	GtkCombo*							patname;
	GtkEntry*							combeg;
	GtkEntry*							comend;
	GnomeColorPicker*					comcolor;
	GtkEntry*							strbeg;
	GtkEntry*							strend;
	GnomeColorPicker*					strcolor;
	GtkEntry*							chbeg;
	GtkEntry*							chend;
	GnomeColorPicker*					chcolor;
	GtkEntry*							keywords;
	GnomeColorPicker*					keywordscolor;
	GtkEntry*							types;
	GnomeColorPicker*					typescolor;
	GtkEntry*							func_regexp;
} gI_pat_dialog;
#endif

typedef struct _gI_comp_dialog
{
	GtkWidget*							vbox;
	GtkWidget*							combo;
	GtkWidget*							e_fpat;
	GtkWidget*							e_compiler;
	GtkWidget*							e_linker;
	GtkWidget*							e_incpath;
	GtkWidget*							e_ccopt;
	GtkWidget*							e_libpath;
	GtkWidget*							e_ldopt;
	GtkWidget*							e_ccmdline_exec;
	GtkWidget*							e_ccmdline_obj;
	GtkWidget*							e_lcmdline;
} gI_comp_dialog;

typedef struct _gI_comp_set
{
	gchar*								cset;
	gchar*								fpat;
	gchar*								compiler;
	gchar*								linker;
	gchar*								incpath;
	gchar*								ccopt;
	gchar*								libpath;
	gchar*								ldopt; 
	gchar*								c_cmdline_exec;
	gchar*								c_cmdline_obj;
	gchar*								l_cmdline;
} gI_comp_set;

#endif
