/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2007 Imendio AB
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GIGGLE_VIEW_H__
#define __GIGGLE_VIEW_H__

#include <glib-object.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS

#define GIGGLE_TYPE_VIEW            (giggle_view_get_type ())
#define GIGGLE_VIEW(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GIGGLE_TYPE_VIEW, GiggleView))
#define GIGGLE_VIEW_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GIGGLE_TYPE_VIEW, GiggleViewClass))
#define GIGGLE_IS_VIEW(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GIGGLE_TYPE_VIEW))
#define GIGGLE_IS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GIGGLE_TYPE_VIEW))
#define GIGGLE_VIEW_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GIGGLE_TYPE_VIEW, GiggleViewClass))

typedef struct GiggleView      GiggleView;
typedef struct GiggleViewClass GiggleViewClass;

struct GiggleView {
	GtkVBox parent_instance;
};

struct GiggleViewClass {
	GtkVBoxClass parent_class;

	void (* add_ui)    (GiggleView   *view,
		    	    GtkUIManager *manager);
	void (* remove_ui) (GiggleView   *view);
};

GType              giggle_view_get_type          (void);

GtkAction *        giggle_view_get_action        (GiggleView *view);
const char *       giggle_view_get_accelerator   (GiggleView *view);
const char *       giggle_view_get_name   	 (GiggleView *view);

void		   giggle_view_add_ui 		 (GiggleView   *view,
		    				  GtkUIManager *manager);
void		   giggle_view_remove_ui 	 (GiggleView   *view);

G_END_DECLS

#endif /* __GIGGLE_VIEW_H__ */
