/* $Id$

   Copyright (C) 2018 Ole Aamot Software
   Author(s): Ole Aamot <ole@gnome.org>
   License: GNU GPL version 3
   Version: 0.0.4 (2018-07-14)
   Website: http://www.gingerblue.org/
   
*/

#include <gst/gst.h>
#include <gtk/gtk.h>
#include <glib/gstdio.h>
#include <glib/gi18n.h>
#include <libxml/xmlmemory.h>
#include <libxml/parser.h>
#include "gingerblue.h"

GingerblueData *
gb_file_parse_volume (GingerblueData *data, xmlDocPtr doc, xmlNodePtr cur) {
	xmlNodePtr sub;
	g_return_if_fail (data != NULL);
	g_return_if_fail (doc != NULL);
	g_return_if_fail (cur != NULL);
	data->version = (gchar *)xmlGetProp (cur, (const xmlChar *)"version");
	data->volume = (gchar *)xmlGetProp (cur, (const xmlChar *)"volume");  
	sub = cur->xmlChildrenNode;
	while (sub != NULL) {
    		if ((!xmlStrcmp
		     (sub->name, (const xmlChar *) "volume"))) {
			data->volume = (gchar *) xmlNodeListGetString(doc, sub->xmlChildrenNode, 1);
		}
		sub = sub->next;
	}
	return (GingerblueData *)data;
}

GingerblueData *
gb_file_config_load (GingerblueData *head, gchar *filename) {
	xmlDocPtr doc = NULL;
	xmlNodePtr cur = NULL;
	GingerblueData *curr = NULL;
	gchar *version;
	g_return_val_if_fail (filename != NULL, NULL);
	doc = xmlReadFile (filename, NULL, 0);
	if (doc == NULL) {
		perror("xmlParseFile");
		xmlFreeDoc (doc);
		return NULL;
	}
	cur = xmlDocGetRootElement (doc);
	if (cur == NULL) {
		fprintf (stderr, "Empty document\n");
		xmlFreeDoc (doc);
		return NULL;
	}
	if (xmlStrcmp(cur->name, (const xmlChar *) "gingerblue")) {
		fprintf(stderr, "Document of wrong type, root node != gingerblue\n");
		xmlFreeDoc (doc);
		return NULL;
	}
	version = (gchar *) xmlGetProp (cur, (const xmlChar *)"version");
	g_print ("Valid GNOME Gingerblue %s XML document...\n", version);
	free (version);
	cur = cur->xmlChildrenNode;
	while (cur != NULL) {
		g_print ("Parsing volume...\n");
		if ((!xmlStrcmp(cur->name, (const xmlChar *) "volume"))) {
			g_print ("Found volume\n");
			curr = g_new0(GingerblueData, 1);
			curr = gb_file_parse_volume (curr, doc, cur);
			curr->next = head;
			head = curr;
			/* mem_volume = head */
			/* volumes = g_list_append (gingerblue_volumes, (GingerblueData *)mem_volume); */
			g_print ("Done with parsing the volume\n");
		}    
		cur = cur->next;
	}
	g_print ("Finished parsing XML document\n");
	xmlFreeDoc (doc);
	return curr;
}
