/* test-checkout-ref.c generated by valac 0.30.0.16-6dbb1, the Vala compiler
 * generated from test-checkout-ref.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2015 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "libgitg/libgitg.h"
#include "libgitg-ext/libgitg-ext.h"
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gitg-assert.h>
#include <gee.h>


#define GITG_TEST_TYPE_TEST (gitg_test_test_get_type ())
#define GITG_TEST_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TEST_TYPE_TEST, GitgTestTest))
#define GITG_TEST_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TEST_TYPE_TEST, GitgTestTestClass))
#define GITG_TEST_IS_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TEST_TYPE_TEST))
#define GITG_TEST_IS_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TEST_TYPE_TEST))
#define GITG_TEST_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TEST_TYPE_TEST, GitgTestTestClass))

typedef struct _GitgTestTest GitgTestTest;
typedef struct _GitgTestTestClass GitgTestTestClass;
typedef struct _GitgTestTestPrivate GitgTestTestPrivate;

#define GITG_TEST_TYPE_REPOSITORY (gitg_test_repository_get_type ())
#define GITG_TEST_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TEST_TYPE_REPOSITORY, GitgTestRepository))
#define GITG_TEST_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TEST_TYPE_REPOSITORY, GitgTestRepositoryClass))
#define GITG_TEST_IS_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TEST_TYPE_REPOSITORY))
#define GITG_TEST_IS_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TEST_TYPE_REPOSITORY))
#define GITG_TEST_REPOSITORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TEST_TYPE_REPOSITORY, GitgTestRepositoryClass))

typedef struct _GitgTestRepository GitgTestRepository;
typedef struct _GitgTestRepositoryClass GitgTestRepositoryClass;
typedef struct _GitgTestRepositoryPrivate GitgTestRepositoryPrivate;

#define GITG_TEST_TYPE_APPLICATION (gitg_test_application_get_type ())
#define GITG_TEST_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TEST_TYPE_APPLICATION, GitgTestApplication))
#define GITG_TEST_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TEST_TYPE_APPLICATION, GitgTestApplicationClass))
#define GITG_TEST_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TEST_TYPE_APPLICATION))
#define GITG_TEST_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TEST_TYPE_APPLICATION))
#define GITG_TEST_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TEST_TYPE_APPLICATION, GitgTestApplicationClass))

typedef struct _GitgTestApplication GitgTestApplication;
typedef struct _GitgTestApplicationClass GitgTestApplicationClass;
typedef struct _GitgTestApplicationPrivate GitgTestApplicationPrivate;

#define GITG_TEST_TYPE_CHECKOUT_REF (gitg_test_checkout_ref_get_type ())
#define GITG_TEST_CHECKOUT_REF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TEST_TYPE_CHECKOUT_REF, GitgTestCheckoutRef))
#define GITG_TEST_CHECKOUT_REF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TEST_TYPE_CHECKOUT_REF, GitgTestCheckoutRefClass))
#define GITG_TEST_IS_CHECKOUT_REF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TEST_TYPE_CHECKOUT_REF))
#define GITG_TEST_IS_CHECKOUT_REF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TEST_TYPE_CHECKOUT_REF))
#define GITG_TEST_CHECKOUT_REF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TEST_TYPE_CHECKOUT_REF, GitgTestCheckoutRefClass))

typedef struct _GitgTestCheckoutRef GitgTestCheckoutRef;
typedef struct _GitgTestCheckoutRefClass GitgTestCheckoutRefClass;
typedef struct _GitgTestCheckoutRefPrivate GitgTestCheckoutRefPrivate;

#define GITG_TEST_TYPE_REF_ACTION_INTERFACE (gitg_test_ref_action_interface_get_type ())
#define GITG_TEST_REF_ACTION_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TEST_TYPE_REF_ACTION_INTERFACE, GitgTestRefActionInterface))
#define GITG_TEST_REF_ACTION_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TEST_TYPE_REF_ACTION_INTERFACE, GitgTestRefActionInterfaceClass))
#define GITG_TEST_IS_REF_ACTION_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TEST_TYPE_REF_ACTION_INTERFACE))
#define GITG_TEST_IS_REF_ACTION_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TEST_TYPE_REF_ACTION_INTERFACE))
#define GITG_TEST_REF_ACTION_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TEST_TYPE_REF_ACTION_INTERFACE, GitgTestRefActionInterfaceClass))

typedef struct _GitgTestRefActionInterface GitgTestRefActionInterface;
typedef struct _GitgTestRefActionInterfaceClass GitgTestRefActionInterfaceClass;

#define GITG_TYPE_REF_ACTION_CHECKOUT (gitg_ref_action_checkout_get_type ())
#define GITG_REF_ACTION_CHECKOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REF_ACTION_CHECKOUT, GitgRefActionCheckout))
#define GITG_REF_ACTION_CHECKOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REF_ACTION_CHECKOUT, GitgRefActionCheckoutClass))
#define GITG_IS_REF_ACTION_CHECKOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REF_ACTION_CHECKOUT))
#define GITG_IS_REF_ACTION_CHECKOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REF_ACTION_CHECKOUT))
#define GITG_REF_ACTION_CHECKOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REF_ACTION_CHECKOUT, GitgRefActionCheckoutClass))

typedef struct _GitgRefActionCheckout GitgRefActionCheckout;
typedef struct _GitgRefActionCheckoutClass GitgRefActionCheckoutClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))

#define GITG_TYPE_SIMPLE_NOTIFICATION (gitg_simple_notification_get_type ())
#define GITG_SIMPLE_NOTIFICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_SIMPLE_NOTIFICATION, GitgSimpleNotification))
#define GITG_SIMPLE_NOTIFICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_SIMPLE_NOTIFICATION, GitgSimpleNotificationClass))
#define GITG_IS_SIMPLE_NOTIFICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_SIMPLE_NOTIFICATION))
#define GITG_IS_SIMPLE_NOTIFICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_SIMPLE_NOTIFICATION))
#define GITG_SIMPLE_NOTIFICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_SIMPLE_NOTIFICATION, GitgSimpleNotificationClass))

typedef struct _GitgSimpleNotification GitgSimpleNotification;
typedef struct _GitgSimpleNotificationClass GitgSimpleNotificationClass;

#define GITG_SIMPLE_NOTIFICATION_TYPE_STATUS (gitg_simple_notification_status_get_type ())
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;

struct _GitgTestTest {
	GObject parent_instance;
	GitgTestTestPrivate * priv;
};

struct _GitgTestTestClass {
	GObjectClass parent_class;
	void (*set_up) (GitgTestTest* self);
	void (*tear_down) (GitgTestTest* self);
};

struct _GitgTestRepository {
	GitgTestTest parent_instance;
	GitgTestRepositoryPrivate * priv;
	GitgRepository* d_repository;
};

struct _GitgTestRepositoryClass {
	GitgTestTestClass parent_class;
};

struct _GitgTestApplication {
	GitgTestRepository parent_instance;
	GitgTestApplicationPrivate * priv;
};

struct _GitgTestApplicationClass {
	GitgTestRepositoryClass parent_class;
};

struct _GitgTestCheckoutRef {
	GitgTestApplication parent_instance;
	GitgTestCheckoutRefPrivate * priv;
};

struct _GitgTestCheckoutRefClass {
	GitgTestApplicationClass parent_class;
	void (*test_checkout_branch) (GitgTestCheckoutRef* self);
	void (*test_checkout_branch_safe) (GitgTestCheckoutRef* self);
	void (*test_checkout_branch_conflict) (GitgTestCheckoutRef* self);
};

struct _GitgTestCheckoutRefPrivate {
	GitgBranch* the_branch;
	GitgTestRefActionInterface* action_interface;
	GitgRefActionCheckout* action;
};

struct _Block1Data {
	int _ref_count_;
	GitgTestCheckoutRef* self;
	GMainLoop* loop;
};

typedef enum  {
	GITG_SIMPLE_NOTIFICATION_STATUS_NONE,
	GITG_SIMPLE_NOTIFICATION_STATUS_SUCCESS,
	GITG_SIMPLE_NOTIFICATION_STATUS_ERROR
} GitgSimpleNotificationStatus;

struct _Block2Data {
	int _ref_count_;
	GitgTestCheckoutRef* self;
	GMainLoop* loop;
};

struct _Block3Data {
	int _ref_count_;
	GitgTestCheckoutRef* self;
	GMainLoop* loop;
};


static gpointer gitg_test_checkout_ref_parent_class = NULL;

GType gitg_test_test_get_type (void) G_GNUC_CONST;
GType gitg_test_repository_get_type (void) G_GNUC_CONST;
GType gitg_test_application_get_type (void) G_GNUC_CONST;
GType gitg_test_checkout_ref_get_type (void) G_GNUC_CONST;
GType gitg_test_ref_action_interface_get_type (void) G_GNUC_CONST;
GType gitg_ref_action_checkout_get_type (void) G_GNUC_CONST;
#define GITG_TEST_CHECKOUT_REF_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TEST_TYPE_CHECKOUT_REF, GitgTestCheckoutRefPrivate))
enum  {
	GITG_TEST_CHECKOUT_REF_DUMMY_PROPERTY
};
static void gitg_test_checkout_ref_real_set_up (GitgTestTest* base);
void gitg_test_test_set_up (GitgTestTest* self);
void gitg_test_repository_commit (GitgTestRepository* self, const gchar* filename, ...);
GitgBranch* gitg_test_repository_create_branch (GitgTestRepository* self, const gchar* name);
GitgTestRefActionInterface* gitg_test_ref_action_interface_new (GitgExtApplication* application);
GitgTestRefActionInterface* gitg_test_ref_action_interface_construct (GType object_type, GitgExtApplication* application);
GitgRefActionCheckout* gitg_ref_action_checkout_new (GitgExtApplication* application, GitgExtRefActionInterface* action_interface, GitgRef* reference);
GitgRefActionCheckout* gitg_ref_action_checkout_construct (GType object_type, GitgExtApplication* application, GitgExtRefActionInterface* action_interface, GitgRef* reference);
GitgTestCheckoutRef* gitg_test_checkout_ref_new (void);
GitgTestCheckoutRef* gitg_test_checkout_ref_construct (GType object_type);
GitgTestApplication* gitg_test_application_new (void);
GitgTestApplication* gitg_test_application_construct (GType object_type);
static void gitg_test_checkout_ref_real_test_checkout_branch (GitgTestCheckoutRef* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
void gitg_ref_action_checkout_checkout (GitgRefActionCheckout* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean gitg_ref_action_checkout_checkout_finish (GitgRefActionCheckout* self, GAsyncResult* _res_);
static void __lambda6_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res);
static void ___lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
GType gitg_simple_notification_get_type (void) G_GNUC_CONST;
GeeArrayList* gitg_test_application_get_simple_notifications (GitgTestApplication* self);
const gchar* gitg_simple_notification_get_title (GitgSimpleNotification* self);
GType gitg_simple_notification_status_get_type (void) G_GNUC_CONST;
GitgSimpleNotificationStatus gitg_simple_notification_get_status (GitgSimpleNotification* self);
const gchar* gitg_simple_notification_get_message (GitgSimpleNotification* self);
void gitg_test_repository_assert_file_contents (GitgTestRepository* self, const gchar* filename, const gchar* expected_contents);
static void gitg_test_checkout_ref_real_test_checkout_branch_safe (GitgTestCheckoutRef* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
void gitg_test_repository_write_file (GitgTestRepository* self, const gchar* filename, const gchar* contents);
static void __lambda7_ (Block2Data* _data2_, GObject* obj, GAsyncResult* res);
static void ___lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void gitg_test_checkout_ref_real_test_checkout_branch_conflict (GitgTestCheckoutRef* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda8_ (Block3Data* _data3_, GObject* obj, GAsyncResult* res);
static void ___lambda8__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void gitg_test_checkout_ref_finalize (GObject* obj);


static void gitg_test_checkout_ref_real_set_up (GitgTestTest* base) {
	GitgTestCheckoutRef * self;
	GitgBranch* _tmp0_ = NULL;
	GitgTestRefActionInterface* _tmp1_ = NULL;
	GitgTestRefActionInterface* _tmp2_ = NULL;
	GitgBranch* _tmp3_ = NULL;
	GitgRefActionCheckout* _tmp4_ = NULL;
#line 28 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	self = (GitgTestCheckoutRef*) base;
#line 30 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	GITG_TEST_TEST_CLASS (gitg_test_checkout_ref_parent_class)->set_up ((GitgTestTest*) G_TYPE_CHECK_INSTANCE_CAST (self, GITG_TEST_TYPE_APPLICATION, GitgTestApplication));
#line 32 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	gitg_test_repository_commit ((GitgTestRepository*) self, "b", "staged changes\n", NULL);
#line 33 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	gitg_test_repository_commit ((GitgTestRepository*) self, "a", "lala\n", NULL);
#line 35 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp0_ = gitg_test_repository_create_branch ((GitgTestRepository*) self, "thebranch");
#line 35 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_g_object_unref0 (self->priv->the_branch);
#line 35 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	self->priv->the_branch = _tmp0_;
#line 37 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	gitg_test_repository_commit ((GitgTestRepository*) self, "a", "changed?\n", NULL);
#line 39 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp1_ = gitg_test_ref_action_interface_new ((GitgExtApplication*) self);
#line 39 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_g_object_unref0 (self->priv->action_interface);
#line 39 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	self->priv->action_interface = _tmp1_;
#line 40 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp2_ = self->priv->action_interface;
#line 40 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp3_ = self->priv->the_branch;
#line 40 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp4_ = gitg_ref_action_checkout_new ((GitgExtApplication*) self, (GitgExtRefActionInterface*) _tmp2_, (GitgRef*) _tmp3_);
#line 40 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_g_object_unref0 (self->priv->action);
#line 40 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	self->priv->action = _tmp4_;
#line 280 "test-checkout-ref.c"
}


GitgTestCheckoutRef* gitg_test_checkout_ref_construct (GType object_type) {
	GitgTestCheckoutRef * self = NULL;
#line 22 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	self = (GitgTestCheckoutRef*) gitg_test_application_construct (object_type);
#line 22 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	return self;
#line 290 "test-checkout-ref.c"
}


GitgTestCheckoutRef* gitg_test_checkout_ref_new (void) {
#line 22 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	return gitg_test_checkout_ref_construct (GITG_TEST_TYPE_CHECKOUT_REF);
#line 297 "test-checkout-ref.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 46 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 46 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	return _data1_;
#line 306 "test-checkout-ref.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 46 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 315 "test-checkout-ref.c"
		GitgTestCheckoutRef* self;
#line 46 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
		self = _data1_->self;
#line 46 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
		_g_main_loop_unref0 (_data1_->loop);
#line 46 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
		_g_object_unref0 (self);
#line 46 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
		g_slice_free (Block1Data, _data1_);
#line 325 "test-checkout-ref.c"
	}
}


static void __lambda6_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res) {
	GitgTestCheckoutRef* self;
	GitgRefActionCheckout* _tmp0_ = NULL;
	GAsyncResult* _tmp1_ = NULL;
#line 50 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	self = _data1_->self;
#line 50 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	g_return_if_fail (res != NULL);
#line 51 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp0_ = self->priv->action;
#line 51 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp1_ = res;
#line 51 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	gitg_ref_action_checkout_checkout_finish (_tmp0_, _tmp1_);
#line 52 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	g_main_loop_quit (_data1_->loop);
#line 346 "test-checkout-ref.c"
}


static void ___lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 50 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	__lambda6_ (self, source_object, res);
#line 50 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	block1_data_unref (self);
#line 355 "test-checkout-ref.c"
}


static void gitg_test_checkout_ref_real_test_checkout_branch (GitgTestCheckoutRef* self) {
	Block1Data* _data1_;
	GMainLoop* _tmp0_ = NULL;
	GitgRefActionCheckout* _tmp1_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	GeeArrayList* _tmp7_ = NULL;
	GeeArrayList* _tmp8_ = NULL;
	GeeArrayList* _tmp9_ = NULL;
	gpointer _tmp10_ = NULL;
	GitgSimpleNotification* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	GeeArrayList* _tmp14_ = NULL;
	GeeArrayList* _tmp15_ = NULL;
	GeeArrayList* _tmp16_ = NULL;
	gpointer _tmp17_ = NULL;
	GitgSimpleNotification* _tmp18_ = NULL;
	GitgSimpleNotificationStatus _tmp19_ = 0;
	GitgSimpleNotificationStatus _tmp20_ = 0;
	GeeArrayList* _tmp21_ = NULL;
	GeeArrayList* _tmp22_ = NULL;
	GeeArrayList* _tmp23_ = NULL;
	gpointer _tmp24_ = NULL;
	GitgSimpleNotification* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
#line 46 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 46 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_data1_->_ref_count_ = 1;
#line 46 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_data1_->self = g_object_ref (self);
#line 48 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 48 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_data1_->loop = _tmp0_;
#line 50 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp1_ = self->priv->action;
#line 50 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	gitg_ref_action_checkout_checkout (_tmp1_, ___lambda6__gasync_ready_callback, block1_data_ref (_data1_));
#line 55 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	g_main_loop_run (_data1_->loop);
#line 57 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp2_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 57 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp3_ = _tmp2_;
#line 57 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp4_ = _tmp3_;
#line 57 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp5_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp4_);
#line 57 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp6_ = _tmp5_;
#line 57 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	gitg_test_assert_assert_inteq (_tmp6_, 1);
#line 57 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_g_object_unref0 (_tmp4_);
#line 58 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp7_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 58 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp8_ = _tmp7_;
#line 58 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp9_ = _tmp8_;
#line 58 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, 0);
#line 58 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp11_ = (GitgSimpleNotification*) _tmp10_;
#line 58 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp12_ = gitg_simple_notification_get_title (_tmp11_);
#line 58 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp13_ = _tmp12_;
#line 58 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	gitg_test_assert_assert_streq (_tmp13_, "Checkout 'thebranch'");
#line 58 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_g_object_unref0 (_tmp11_);
#line 58 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_g_object_unref0 (_tmp9_);
#line 59 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp14_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 59 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp15_ = _tmp14_;
#line 59 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp16_ = _tmp15_;
#line 59 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, 0);
#line 59 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp18_ = (GitgSimpleNotification*) _tmp17_;
#line 59 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp19_ = gitg_simple_notification_get_status (_tmp18_);
#line 59 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp20_ = _tmp19_;
#line 59 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp20_, (gint) GITG_SIMPLE_NOTIFICATION_STATUS_SUCCESS);
#line 59 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_g_object_unref0 (_tmp18_);
#line 59 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_g_object_unref0 (_tmp16_);
#line 60 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp21_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 60 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp22_ = _tmp21_;
#line 60 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp23_ = _tmp22_;
#line 60 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, 0);
#line 60 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp25_ = (GitgSimpleNotification*) _tmp24_;
#line 60 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp26_ = gitg_simple_notification_get_message (_tmp25_);
#line 60 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp27_ = _tmp26_;
#line 60 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	gitg_test_assert_assert_streq (_tmp27_, "Successfully checked out branch to working directory");
#line 60 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_g_object_unref0 (_tmp25_);
#line 60 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_g_object_unref0 (_tmp23_);
#line 61 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "a", "lala\n");
#line 46 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	block1_data_unref (_data1_);
#line 46 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_data1_ = NULL;
#line 485 "test-checkout-ref.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 64 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 64 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	return _data2_;
#line 494 "test-checkout-ref.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 64 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 503 "test-checkout-ref.c"
		GitgTestCheckoutRef* self;
#line 64 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
		self = _data2_->self;
#line 64 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
		_g_main_loop_unref0 (_data2_->loop);
#line 64 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
		_g_object_unref0 (self);
#line 64 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
		g_slice_free (Block2Data, _data2_);
#line 513 "test-checkout-ref.c"
	}
}


static void __lambda7_ (Block2Data* _data2_, GObject* obj, GAsyncResult* res) {
	GitgTestCheckoutRef* self;
	GitgRefActionCheckout* _tmp0_ = NULL;
	GAsyncResult* _tmp1_ = NULL;
#line 70 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	self = _data2_->self;
#line 70 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	g_return_if_fail (res != NULL);
#line 71 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp0_ = self->priv->action;
#line 71 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp1_ = res;
#line 71 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	gitg_ref_action_checkout_checkout_finish (_tmp0_, _tmp1_);
#line 72 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	g_main_loop_quit (_data2_->loop);
#line 534 "test-checkout-ref.c"
}


static void ___lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 70 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	__lambda7_ (self, source_object, res);
#line 70 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	block2_data_unref (self);
#line 543 "test-checkout-ref.c"
}


static void gitg_test_checkout_ref_real_test_checkout_branch_safe (GitgTestCheckoutRef* self) {
	Block2Data* _data2_;
	GMainLoop* _tmp0_ = NULL;
	GitgRefActionCheckout* _tmp1_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	GeeArrayList* _tmp7_ = NULL;
	GeeArrayList* _tmp8_ = NULL;
	GeeArrayList* _tmp9_ = NULL;
	gpointer _tmp10_ = NULL;
	GitgSimpleNotification* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	GeeArrayList* _tmp14_ = NULL;
	GeeArrayList* _tmp15_ = NULL;
	GeeArrayList* _tmp16_ = NULL;
	gpointer _tmp17_ = NULL;
	GitgSimpleNotification* _tmp18_ = NULL;
	GitgSimpleNotificationStatus _tmp19_ = 0;
	GitgSimpleNotificationStatus _tmp20_ = 0;
	GeeArrayList* _tmp21_ = NULL;
	GeeArrayList* _tmp22_ = NULL;
	GeeArrayList* _tmp23_ = NULL;
	gpointer _tmp24_ = NULL;
	GitgSimpleNotification* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
#line 64 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 64 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_data2_->_ref_count_ = 1;
#line 64 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_data2_->self = g_object_ref (self);
#line 66 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	gitg_test_repository_write_file ((GitgTestRepository*) self, "b", "something changed\n");
#line 68 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 68 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_data2_->loop = _tmp0_;
#line 70 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp1_ = self->priv->action;
#line 70 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	gitg_ref_action_checkout_checkout (_tmp1_, ___lambda7__gasync_ready_callback, block2_data_ref (_data2_));
#line 75 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	g_main_loop_run (_data2_->loop);
#line 77 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp2_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 77 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp3_ = _tmp2_;
#line 77 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp4_ = _tmp3_;
#line 77 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp5_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp4_);
#line 77 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp6_ = _tmp5_;
#line 77 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	gitg_test_assert_assert_inteq (_tmp6_, 1);
#line 77 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_g_object_unref0 (_tmp4_);
#line 78 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp7_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 78 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp8_ = _tmp7_;
#line 78 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp9_ = _tmp8_;
#line 78 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, 0);
#line 78 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp11_ = (GitgSimpleNotification*) _tmp10_;
#line 78 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp12_ = gitg_simple_notification_get_title (_tmp11_);
#line 78 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp13_ = _tmp12_;
#line 78 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	gitg_test_assert_assert_streq (_tmp13_, "Checkout 'thebranch'");
#line 78 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_g_object_unref0 (_tmp11_);
#line 78 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_g_object_unref0 (_tmp9_);
#line 79 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp14_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 79 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp15_ = _tmp14_;
#line 79 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp16_ = _tmp15_;
#line 79 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, 0);
#line 79 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp18_ = (GitgSimpleNotification*) _tmp17_;
#line 79 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp19_ = gitg_simple_notification_get_status (_tmp18_);
#line 79 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp20_ = _tmp19_;
#line 79 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp20_, (gint) GITG_SIMPLE_NOTIFICATION_STATUS_SUCCESS);
#line 79 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_g_object_unref0 (_tmp18_);
#line 79 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_g_object_unref0 (_tmp16_);
#line 80 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp21_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 80 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp22_ = _tmp21_;
#line 80 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp23_ = _tmp22_;
#line 80 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, 0);
#line 80 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp25_ = (GitgSimpleNotification*) _tmp24_;
#line 80 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp26_ = gitg_simple_notification_get_message (_tmp25_);
#line 80 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp27_ = _tmp26_;
#line 80 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	gitg_test_assert_assert_streq (_tmp27_, "Successfully checked out branch to working directory");
#line 80 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_g_object_unref0 (_tmp25_);
#line 80 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_g_object_unref0 (_tmp23_);
#line 81 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "b", "something changed\n");
#line 64 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	block2_data_unref (_data2_);
#line 64 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_data2_ = NULL;
#line 675 "test-checkout-ref.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 84 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 84 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	return _data3_;
#line 684 "test-checkout-ref.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 84 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 693 "test-checkout-ref.c"
		GitgTestCheckoutRef* self;
#line 84 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
		self = _data3_->self;
#line 84 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
		_g_main_loop_unref0 (_data3_->loop);
#line 84 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
		_g_object_unref0 (self);
#line 84 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
		g_slice_free (Block3Data, _data3_);
#line 703 "test-checkout-ref.c"
	}
}


static void __lambda8_ (Block3Data* _data3_, GObject* obj, GAsyncResult* res) {
	GitgTestCheckoutRef* self;
	GitgRefActionCheckout* _tmp0_ = NULL;
	GAsyncResult* _tmp1_ = NULL;
#line 90 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	self = _data3_->self;
#line 90 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	g_return_if_fail (res != NULL);
#line 91 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp0_ = self->priv->action;
#line 91 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp1_ = res;
#line 91 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	gitg_ref_action_checkout_checkout_finish (_tmp0_, _tmp1_);
#line 92 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	g_main_loop_quit (_data3_->loop);
#line 724 "test-checkout-ref.c"
}


static void ___lambda8__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 90 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	__lambda8_ (self, source_object, res);
#line 90 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	block3_data_unref (self);
#line 733 "test-checkout-ref.c"
}


static void gitg_test_checkout_ref_real_test_checkout_branch_conflict (GitgTestCheckoutRef* self) {
	Block3Data* _data3_;
	GMainLoop* _tmp0_ = NULL;
	GitgRefActionCheckout* _tmp1_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	GeeArrayList* _tmp7_ = NULL;
	GeeArrayList* _tmp8_ = NULL;
	GeeArrayList* _tmp9_ = NULL;
	gpointer _tmp10_ = NULL;
	GitgSimpleNotification* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	GeeArrayList* _tmp14_ = NULL;
	GeeArrayList* _tmp15_ = NULL;
	GeeArrayList* _tmp16_ = NULL;
	gpointer _tmp17_ = NULL;
	GitgSimpleNotification* _tmp18_ = NULL;
	GitgSimpleNotificationStatus _tmp19_ = 0;
	GitgSimpleNotificationStatus _tmp20_ = 0;
	GeeArrayList* _tmp21_ = NULL;
	GeeArrayList* _tmp22_ = NULL;
	GeeArrayList* _tmp23_ = NULL;
	gpointer _tmp24_ = NULL;
	GitgSimpleNotification* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
#line 84 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 84 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_data3_->_ref_count_ = 1;
#line 84 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_data3_->self = g_object_ref (self);
#line 86 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	gitg_test_repository_write_file ((GitgTestRepository*) self, "a", "something changed\n");
#line 88 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 88 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_data3_->loop = _tmp0_;
#line 90 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp1_ = self->priv->action;
#line 90 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	gitg_ref_action_checkout_checkout (_tmp1_, ___lambda8__gasync_ready_callback, block3_data_ref (_data3_));
#line 95 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	g_main_loop_run (_data3_->loop);
#line 97 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp2_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 97 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp3_ = _tmp2_;
#line 97 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp4_ = _tmp3_;
#line 97 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp5_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp4_);
#line 97 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp6_ = _tmp5_;
#line 97 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	gitg_test_assert_assert_inteq (_tmp6_, 1);
#line 97 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_g_object_unref0 (_tmp4_);
#line 98 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp7_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 98 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp8_ = _tmp7_;
#line 98 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp9_ = _tmp8_;
#line 98 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, 0);
#line 98 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp11_ = (GitgSimpleNotification*) _tmp10_;
#line 98 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp12_ = gitg_simple_notification_get_title (_tmp11_);
#line 98 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp13_ = _tmp12_;
#line 98 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	gitg_test_assert_assert_streq (_tmp13_, "Checkout 'thebranch'");
#line 98 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_g_object_unref0 (_tmp11_);
#line 98 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_g_object_unref0 (_tmp9_);
#line 99 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp14_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 99 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp15_ = _tmp14_;
#line 99 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp16_ = _tmp15_;
#line 99 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, 0);
#line 99 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp18_ = (GitgSimpleNotification*) _tmp17_;
#line 99 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp19_ = gitg_simple_notification_get_status (_tmp18_);
#line 99 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp20_ = _tmp19_;
#line 99 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp20_, (gint) GITG_SIMPLE_NOTIFICATION_STATUS_ERROR);
#line 99 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_g_object_unref0 (_tmp18_);
#line 99 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_g_object_unref0 (_tmp16_);
#line 100 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp21_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 100 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp22_ = _tmp21_;
#line 100 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp23_ = _tmp22_;
#line 100 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, 0);
#line 100 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp25_ = (GitgSimpleNotification*) _tmp24_;
#line 100 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp26_ = gitg_simple_notification_get_message (_tmp25_);
#line 100 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_tmp27_ = _tmp26_;
#line 100 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	gitg_test_assert_assert_streq (_tmp27_, "Failed to checkout branch: 1 conflict prevents checkout");
#line 100 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_g_object_unref0 (_tmp25_);
#line 100 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_g_object_unref0 (_tmp23_);
#line 101 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "a", "something changed\n");
#line 84 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	block3_data_unref (_data3_);
#line 84 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_data3_ = NULL;
#line 865 "test-checkout-ref.c"
}


static void gitg_test_checkout_ref_class_init (GitgTestCheckoutRefClass * klass) {
#line 22 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	gitg_test_checkout_ref_parent_class = g_type_class_peek_parent (klass);
#line 22 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	g_type_class_add_private (klass, sizeof (GitgTestCheckoutRefPrivate));
#line 22 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	((GitgTestTestClass *) klass)->set_up = gitg_test_checkout_ref_real_set_up;
#line 22 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	((GitgTestCheckoutRefClass *) klass)->test_checkout_branch = gitg_test_checkout_ref_real_test_checkout_branch;
#line 22 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	((GitgTestCheckoutRefClass *) klass)->test_checkout_branch_safe = gitg_test_checkout_ref_real_test_checkout_branch_safe;
#line 22 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	((GitgTestCheckoutRefClass *) klass)->test_checkout_branch_conflict = gitg_test_checkout_ref_real_test_checkout_branch_conflict;
#line 22 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_test_checkout_ref_finalize;
#line 884 "test-checkout-ref.c"
	/**
	 * test basic branch checkout.
	 */
#line 22 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	g_signal_new ("test_checkout_branch", GITG_TEST_TYPE_CHECKOUT_REF, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgTestCheckoutRefClass, test_checkout_branch), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 22 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	g_signal_new ("test_checkout_branch_safe", GITG_TEST_TYPE_CHECKOUT_REF, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgTestCheckoutRefClass, test_checkout_branch_safe), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 22 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	g_signal_new ("test_checkout_branch_conflict", GITG_TEST_TYPE_CHECKOUT_REF, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgTestCheckoutRefClass, test_checkout_branch_conflict), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 894 "test-checkout-ref.c"
}


static void gitg_test_checkout_ref_instance_init (GitgTestCheckoutRef * self) {
#line 22 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	self->priv = GITG_TEST_CHECKOUT_REF_GET_PRIVATE (self);
#line 901 "test-checkout-ref.c"
}


static void gitg_test_checkout_ref_finalize (GObject* obj) {
	GitgTestCheckoutRef * self;
#line 22 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TEST_TYPE_CHECKOUT_REF, GitgTestCheckoutRef);
#line 24 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_g_object_unref0 (self->priv->the_branch);
#line 25 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_g_object_unref0 (self->priv->action_interface);
#line 26 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	_g_object_unref0 (self->priv->action);
#line 22 "/home/nacho/checkout/gnome/gitg/tests/gitg/test-checkout-ref.vala"
	G_OBJECT_CLASS (gitg_test_checkout_ref_parent_class)->finalize (obj);
#line 917 "test-checkout-ref.c"
}


GType gitg_test_checkout_ref_get_type (void) {
	static volatile gsize gitg_test_checkout_ref_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_test_checkout_ref_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgTestCheckoutRefClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_test_checkout_ref_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgTestCheckoutRef), 0, (GInstanceInitFunc) gitg_test_checkout_ref_instance_init, NULL };
		GType gitg_test_checkout_ref_type_id;
		gitg_test_checkout_ref_type_id = g_type_register_static (GITG_TEST_TYPE_APPLICATION, "GitgTestCheckoutRef", &g_define_type_info, 0);
		g_once_init_leave (&gitg_test_checkout_ref_type_id__volatile, gitg_test_checkout_ref_type_id);
	}
	return gitg_test_checkout_ref_type_id__volatile;
}



