/* test-stage.c generated by valac 0.30.0.16-6dbb1, the Vala compiler
 * generated from test-stage.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2013 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "libgitg/libgitg.h"
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libgit2-glib/ggit.h>
#include <gio/gio.h>
#include <gitg-assert.h>


#define GITG_TEST_TYPE_TEST (gitg_test_test_get_type ())
#define GITG_TEST_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TEST_TYPE_TEST, GitgTestTest))
#define GITG_TEST_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TEST_TYPE_TEST, GitgTestTestClass))
#define GITG_TEST_IS_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TEST_TYPE_TEST))
#define GITG_TEST_IS_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TEST_TYPE_TEST))
#define GITG_TEST_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TEST_TYPE_TEST, GitgTestTestClass))

typedef struct _GitgTestTest GitgTestTest;
typedef struct _GitgTestTestClass GitgTestTestClass;
typedef struct _GitgTestTestPrivate GitgTestTestPrivate;

#define GITG_TEST_TYPE_REPOSITORY (gitg_test_repository_get_type ())
#define GITG_TEST_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TEST_TYPE_REPOSITORY, GitgTestRepository))
#define GITG_TEST_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TEST_TYPE_REPOSITORY, GitgTestRepositoryClass))
#define GITG_TEST_IS_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TEST_TYPE_REPOSITORY))
#define GITG_TEST_IS_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TEST_TYPE_REPOSITORY))
#define GITG_TEST_REPOSITORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TEST_TYPE_REPOSITORY, GitgTestRepositoryClass))

typedef struct _GitgTestRepository GitgTestRepository;
typedef struct _GitgTestRepositoryClass GitgTestRepositoryClass;
typedef struct _GitgTestRepositoryPrivate GitgTestRepositoryPrivate;

#define LIB_GITG_TEST_TYPE_STAGE (lib_gitg_test_stage_get_type ())
#define LIB_GITG_TEST_STAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIB_GITG_TEST_TYPE_STAGE, LibGitgTestStage))
#define LIB_GITG_TEST_STAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LIB_GITG_TEST_TYPE_STAGE, LibGitgTestStageClass))
#define LIB_GITG_TEST_IS_STAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIB_GITG_TEST_TYPE_STAGE))
#define LIB_GITG_TEST_IS_STAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LIB_GITG_TEST_TYPE_STAGE))
#define LIB_GITG_TEST_STAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LIB_GITG_TEST_TYPE_STAGE, LibGitgTestStageClass))

typedef struct _LibGitgTestStage LibGitgTestStage;
typedef struct _LibGitgTestStageClass LibGitgTestStageClass;
typedef struct _LibGitgTestStagePrivate LibGitgTestStagePrivate;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block2Data Block2Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GitgTestTest {
	GObject parent_instance;
	GitgTestTestPrivate * priv;
};

struct _GitgTestTestClass {
	GObjectClass parent_class;
	void (*set_up) (GitgTestTest* self);
	void (*tear_down) (GitgTestTest* self);
};

struct _GitgTestRepository {
	GitgTestTest parent_instance;
	GitgTestRepositoryPrivate * priv;
	GitgRepository* d_repository;
};

struct _GitgTestRepositoryClass {
	GitgTestTestClass parent_class;
};

struct _LibGitgTestStage {
	GitgTestRepository parent_instance;
	LibGitgTestStagePrivate * priv;
};

struct _LibGitgTestStageClass {
	GitgTestRepositoryClass parent_class;
	void (*test_file_status) (LibGitgTestStage* self);
	void (*test_stage) (LibGitgTestStage* self);
	void (*test_unstage) (LibGitgTestStage* self);
	void (*test_revert) (LibGitgTestStage* self);
	void (*test_delete) (LibGitgTestStage* self);
};

struct _Block1Data {
	int _ref_count_;
	LibGitgTestStage* self;
	GeeHashSet* seen;
	GitgStageStatusEnumerator* e;
	GMainLoop* loop;
	GeeHashMap* cfiles;
};

struct _Block2Data {
	int _ref_count_;
	LibGitgTestStage* self;
	GitgStage* stage;
	GMainLoop* loop;
};

struct _Block3Data {
	int _ref_count_;
	LibGitgTestStage* self;
	GitgStage* stage;
	GMainLoop* loop;
};

struct _Block4Data {
	int _ref_count_;
	LibGitgTestStage* self;
	GitgStage* stage;
	GMainLoop* loop;
};

struct _Block5Data {
	int _ref_count_;
	LibGitgTestStage* self;
	GitgStage* stage;
	GMainLoop* loop;
};


static gpointer lib_gitg_test_stage_parent_class = NULL;

GType gitg_test_test_get_type (void) G_GNUC_CONST;
GType gitg_test_repository_get_type (void) G_GNUC_CONST;
GType lib_gitg_test_stage_get_type (void) G_GNUC_CONST;
enum  {
	LIB_GITG_TEST_STAGE_DUMMY_PROPERTY
};
static void lib_gitg_test_stage_real_set_up (GitgTestTest* base);
void gitg_test_test_set_up (GitgTestTest* self);
void gitg_test_repository_commit (GitgTestRepository* self, const gchar* filename, ...);
void gitg_test_repository_workdir_remove (GitgTestRepository* self, const gchar* filename, ...);
void gitg_test_repository_workdir_modify (GitgTestRepository* self, const gchar* filename, ...);
void gitg_test_repository_index_modify (GitgTestRepository* self, const gchar* filename, ...);
static void lib_gitg_test_stage_check_file_status (LibGitgTestStage* self, GMainLoop* loop, GeeHashMap* cfiles);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda4_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res);
static void ___lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
LibGitgTestStage* lib_gitg_test_stage_new (void);
LibGitgTestStage* lib_gitg_test_stage_construct (GType object_type);
GitgTestRepository* gitg_test_repository_new (void);
GitgTestRepository* gitg_test_repository_construct (GType object_type);
static void lib_gitg_test_stage_real_test_file_status (LibGitgTestStage* self);
static void lib_gitg_test_stage_real_test_stage (LibGitgTestStage* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda5_ (Block2Data* _data2_, GObject* obj, GAsyncResult* res);
static void ___lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void lib_gitg_test_stage_real_test_unstage (LibGitgTestStage* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda6_ (Block3Data* _data3_, GObject* obj, GAsyncResult* res);
static void ___lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void lib_gitg_test_stage_real_test_revert (LibGitgTestStage* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda7_ (Block4Data* _data4_, GObject* obj, GAsyncResult* res);
static void ___lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void lib_gitg_test_stage_real_test_delete (LibGitgTestStage* self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda8_ (Block5Data* _data5_, GObject* obj, GAsyncResult* res);
static void ___lambda8__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
 * Create basic repository with files in a variety of states.
 */
static void lib_gitg_test_stage_real_set_up (GitgTestTest* base) {
	LibGitgTestStage * self;
#line 28 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	self = (LibGitgTestStage*) base;
#line 30 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	GITG_TEST_TEST_CLASS (lib_gitg_test_stage_parent_class)->set_up ((GitgTestTest*) G_TYPE_CHECK_INSTANCE_CAST (self, GITG_TEST_TYPE_REPOSITORY, GitgTestRepository));
#line 33 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	gitg_test_repository_commit ((GitgTestRepository*) self, "a", "hello world\n", "b", "gitg test file\n", "c", "hello\n", NULL);
#line 37 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	gitg_test_repository_workdir_remove ((GitgTestRepository*) self, "c", NULL);
#line 38 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	gitg_test_repository_workdir_modify ((GitgTestRepository*) self, "a", "changed world\n", NULL);
#line 39 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	gitg_test_repository_workdir_modify ((GitgTestRepository*) self, "b", "changed test\n", NULL);
#line 41 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	gitg_test_repository_index_modify ((GitgTestRepository*) self, "b", "staged changes\n", NULL);
#line 221 "test-stage.c"
}


static gpointer _g_main_loop_ref0 (gpointer self) {
#line 44 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	return self ? g_main_loop_ref (self) : NULL;
#line 228 "test-stage.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 44 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	return self ? g_object_ref (self) : NULL;
#line 235 "test-stage.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 44 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 44 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	return _data1_;
#line 244 "test-stage.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 44 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 253 "test-stage.c"
		LibGitgTestStage* self;
#line 44 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		self = _data1_->self;
#line 44 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_object_unref0 (_data1_->e);
#line 44 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_object_unref0 (_data1_->seen);
#line 44 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_main_loop_unref0 (_data1_->loop);
#line 44 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_object_unref0 (_data1_->cfiles);
#line 44 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_object_unref0 (self);
#line 44 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		g_slice_free (Block1Data, _data1_);
#line 269 "test-stage.c"
	}
}


static void __lambda4_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res) {
	LibGitgTestStage* self;
	GitgStageStatusItem** items = NULL;
	GAsyncResult* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GitgStageStatusItem** _tmp2_ = NULL;
	gint items_length1 = 0;
	gint _items_size_ = 0;
	GitgStageStatusItem** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	GeeHashMap* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	GitgStageStatusItem** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	GeeHashSet* _tmp31_ = NULL;
	gint _tmp32_ = 0;
	gint _tmp33_ = 0;
	GMainLoop* _tmp34_ = NULL;
#line 56 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	self = _data1_->self;
#line 56 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	g_return_if_fail (res != NULL);
#line 57 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp0_ = res;
#line 57 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp2_ = gitg_stage_status_enumerator_next_items_finish (_data1_->e, _tmp0_, &_tmp1_);
#line 57 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	items = _tmp2_;
#line 57 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	items_length1 = _tmp1_;
#line 57 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_items_size_ = items_length1;
#line 59 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp3_ = items;
#line 59 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp3__length1 = items_length1;
#line 59 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp4_ = _data1_->cfiles;
#line 59 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp5_ = gee_abstract_map_get_size ((GeeMap*) _tmp4_);
#line 59 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp6_ = _tmp5_;
#line 59 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_vala_assert (_tmp3__length1 == _tmp6_, "items.length == cfiles.size");
#line 61 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp7_ = items;
#line 61 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp7__length1 = items_length1;
#line 323 "test-stage.c"
	{
		GitgStageStatusItem** item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
#line 61 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		item_collection = _tmp7_;
#line 61 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		item_collection_length1 = _tmp7__length1;
#line 61 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		for (item_it = 0; item_it < _tmp7__length1; item_it = item_it + 1) {
#line 335 "test-stage.c"
			GitgStageStatusItem* _tmp8_ = NULL;
			GitgStageStatusItem* item = NULL;
#line 61 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
			_tmp8_ = _g_object_ref0 (item_collection[item_it]);
#line 61 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
			item = _tmp8_;
#line 342 "test-stage.c"
			{
				GitgStageStatusFile* f = NULL;
				GitgStageStatusItem* _tmp9_ = NULL;
				GitgStageStatusFile* _tmp10_ = NULL;
				GeeHashMap* _tmp11_ = NULL;
				GitgStageStatusFile* _tmp12_ = NULL;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				gboolean _tmp16_ = FALSE;
				GeeHashMap* _tmp17_ = NULL;
				GitgStageStatusFile* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				gpointer _tmp22_ = NULL;
				GitgStageStatusFile* _tmp23_ = NULL;
				GgitStatusFlags _tmp24_ = 0;
				GgitStatusFlags _tmp25_ = 0;
				GeeHashSet* _tmp26_ = NULL;
				GitgStageStatusFile* _tmp27_ = NULL;
				gchar* _tmp28_ = NULL;
				gchar* _tmp29_ = NULL;
				gchar* _tmp30_ = NULL;
#line 63 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp9_ = item;
#line 63 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, GITG_TYPE_STAGE_STATUS_FILE) ? ((GitgStageStatusFile*) _tmp9_) : NULL);
#line 63 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
				f = _tmp10_;
#line 65 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp11_ = _data1_->cfiles;
#line 65 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp12_ = f;
#line 65 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp13_ = gitg_stage_status_item_get_path ((GitgStageStatusItem*) _tmp12_);
#line 65 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp14_ = _tmp13_;
#line 65 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp15_ = _tmp14_;
#line 65 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp16_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp11_, _tmp15_);
#line 65 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
				_vala_assert (_tmp16_, "cfiles.has_key(f.path)");
#line 65 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
				_g_free0 (_tmp15_);
#line 66 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp17_ = _data1_->cfiles;
#line 66 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp18_ = f;
#line 66 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp19_ = gitg_stage_status_item_get_path ((GitgStageStatusItem*) _tmp18_);
#line 66 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp20_ = _tmp19_;
#line 66 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp21_ = _tmp20_;
#line 66 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp22_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp17_, _tmp21_);
#line 66 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp23_ = f;
#line 66 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp24_ = gitg_stage_status_file_get_flags (_tmp23_);
#line 66 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp25_ = _tmp24_;
#line 66 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
				gitg_test_assert_assert_inteq ((gint) ((GgitStatusFlags) ((gintptr) _tmp22_)), (gint) _tmp25_);
#line 66 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
				_g_free0 (_tmp21_);
#line 68 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp26_ = _data1_->seen;
#line 68 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp27_ = f;
#line 68 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp28_ = gitg_stage_status_item_get_path ((GitgStageStatusItem*) _tmp27_);
#line 68 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp29_ = _tmp28_;
#line 68 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
				_tmp30_ = _tmp29_;
#line 68 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
				gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp26_, _tmp30_);
#line 68 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
				_g_free0 (_tmp30_);
#line 61 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
				_g_object_unref0 (f);
#line 61 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
				_g_object_unref0 (item);
#line 429 "test-stage.c"
			}
		}
	}
#line 71 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp31_ = _data1_->seen;
#line 71 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp32_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp31_);
#line 71 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp33_ = _tmp32_;
#line 71 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_vala_assert (_tmp33_ == 0, "seen.size == 0");
#line 72 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp34_ = _data1_->loop;
#line 72 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	g_main_loop_quit (_tmp34_);
#line 56 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	items = (_vala_array_free (items, items_length1, (GDestroyNotify) g_object_unref), NULL);
#line 447 "test-stage.c"
}


static void ___lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 56 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	__lambda4_ (self, source_object, res);
#line 56 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	block1_data_unref (self);
#line 456 "test-stage.c"
}


static void lib_gitg_test_stage_check_file_status (LibGitgTestStage* self, GMainLoop* loop, GeeHashMap* cfiles) {
	Block1Data* _data1_;
	GMainLoop* _tmp0_ = NULL;
	GMainLoop* _tmp1_ = NULL;
	GeeHashMap* _tmp2_ = NULL;
	GeeHashMap* _tmp3_ = NULL;
	GeeHashSet* _tmp4_ = NULL;
	GitgStage* stage = NULL;
	GitgRepository* _tmp17_ = NULL;
	GitgStage* _tmp18_ = NULL;
	GitgStage* _tmp19_ = NULL;
	GitgStageStatusEnumerator* _tmp20_ = NULL;
#line 44 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	g_return_if_fail (self != NULL);
#line 44 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	g_return_if_fail (loop != NULL);
#line 44 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	g_return_if_fail (cfiles != NULL);
#line 44 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 44 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_data1_->_ref_count_ = 1;
#line 44 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_data1_->self = g_object_ref (self);
#line 44 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp0_ = loop;
#line 44 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp1_ = _g_main_loop_ref0 (_tmp0_);
#line 44 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_g_main_loop_unref0 (_data1_->loop);
#line 44 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_data1_->loop = _tmp1_;
#line 44 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp2_ = cfiles;
#line 44 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 44 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_g_object_unref0 (_data1_->cfiles);
#line 44 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_data1_->cfiles = _tmp3_;
#line 46 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp4_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 46 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_data1_->seen = _tmp4_;
#line 504 "test-stage.c"
	{
		GeeIterator* _f_it = NULL;
		GeeHashMap* _tmp5_ = NULL;
		GeeSet* _tmp6_ = NULL;
		GeeSet* _tmp7_ = NULL;
		GeeSet* _tmp8_ = NULL;
		GeeIterator* _tmp9_ = NULL;
		GeeIterator* _tmp10_ = NULL;
#line 48 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_tmp5_ = _data1_->cfiles;
#line 48 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_tmp6_ = gee_abstract_map_get_keys ((GeeMap*) _tmp5_);
#line 48 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_tmp7_ = _tmp6_;
#line 48 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_tmp8_ = _tmp7_;
#line 48 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
#line 48 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_tmp10_ = _tmp9_;
#line 48 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_object_unref0 (_tmp8_);
#line 48 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_f_it = _tmp10_;
#line 48 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		while (TRUE) {
#line 531 "test-stage.c"
			GeeIterator* _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
			gchar* f = NULL;
			GeeIterator* _tmp13_ = NULL;
			gpointer _tmp14_ = NULL;
			GeeHashSet* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
#line 48 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
			_tmp11_ = _f_it;
#line 48 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
			_tmp12_ = gee_iterator_next (_tmp11_);
#line 48 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
			if (!_tmp12_) {
#line 48 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
				break;
#line 547 "test-stage.c"
			}
#line 48 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
			_tmp13_ = _f_it;
#line 48 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
			_tmp14_ = gee_iterator_get (_tmp13_);
#line 48 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
			f = (gchar*) _tmp14_;
#line 50 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
			_tmp15_ = _data1_->seen;
#line 50 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
			_tmp16_ = f;
#line 50 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, _tmp16_);
#line 48 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
			_g_free0 (f);
#line 563 "test-stage.c"
		}
#line 48 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_object_unref0 (_f_it);
#line 567 "test-stage.c"
	}
#line 53 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp17_ = ((GitgTestRepository*) self)->d_repository;
#line 53 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp18_ = gitg_repository_get_stage (_tmp17_);
#line 53 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp19_ = _tmp18_;
#line 53 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	stage = _tmp19_;
#line 54 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp20_ = gitg_stage_file_status (stage, NULL);
#line 54 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_data1_->e = _tmp20_;
#line 56 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	gitg_stage_status_enumerator_next_items (_data1_->e, -1, ___lambda4__gasync_ready_callback, block1_data_ref (_data1_));
#line 44 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_g_object_unref0 (stage);
#line 44 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	block1_data_unref (_data1_);
#line 44 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_data1_ = NULL;
#line 589 "test-stage.c"
}


LibGitgTestStage* lib_gitg_test_stage_construct (GType object_type) {
	LibGitgTestStage * self = NULL;
#line 23 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	self = (LibGitgTestStage*) gitg_test_repository_construct (object_type);
#line 23 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	return self;
#line 599 "test-stage.c"
}


LibGitgTestStage* lib_gitg_test_stage_new (void) {
#line 23 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	return lib_gitg_test_stage_construct (LIB_GITG_TEST_TYPE_STAGE);
#line 606 "test-stage.c"
}


static void lib_gitg_test_stage_real_test_file_status (LibGitgTestStage* self) {
	GeeHashMap* m = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GMainLoop* loop = NULL;
	GMainLoop* _tmp1_ = NULL;
#line 82 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, ggit_status_flags_get_type (), NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 82 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	m = _tmp0_;
#line 84 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	gee_abstract_map_set ((GeeAbstractMap*) m, "a", (gpointer) ((gintptr) GGIT_STATUS_WORKING_TREE_MODIFIED));
#line 85 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	gee_abstract_map_set ((GeeAbstractMap*) m, "b", (gpointer) ((gintptr) (GGIT_STATUS_WORKING_TREE_MODIFIED | GGIT_STATUS_INDEX_MODIFIED)));
#line 86 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	gee_abstract_map_set ((GeeAbstractMap*) m, "c", (gpointer) ((gintptr) GGIT_STATUS_WORKING_TREE_DELETED));
#line 88 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp1_ = g_main_loop_new (NULL, FALSE);
#line 88 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	loop = _tmp1_;
#line 90 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	lib_gitg_test_stage_check_file_status (self, loop, m);
#line 91 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	g_main_loop_run (loop);
#line 80 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_g_main_loop_unref0 (loop);
#line 80 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_g_object_unref0 (m);
#line 637 "test-stage.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 97 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 97 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	return _data2_;
#line 646 "test-stage.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 97 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 655 "test-stage.c"
		LibGitgTestStage* self;
#line 97 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		self = _data2_->self;
#line 97 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_main_loop_unref0 (_data2_->loop);
#line 97 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_object_unref0 (_data2_->stage);
#line 97 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_object_unref0 (self);
#line 97 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		g_slice_free (Block2Data, _data2_);
#line 667 "test-stage.c"
	}
}


static void __lambda5_ (Block2Data* _data2_, GObject* obj, GAsyncResult* res) {
	LibGitgTestStage* self;
	GeeHashMap* m = NULL;
	GeeHashMap* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 103 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	self = _data2_->self;
#line 103 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	g_return_if_fail (res != NULL);
#line 681 "test-stage.c"
	{
		GAsyncResult* _tmp0_ = NULL;
#line 106 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_tmp0_ = res;
#line 106 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		gitg_stage_stage_finish (_data2_->stage, _tmp0_, &_inner_error_);
#line 106 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 690 "test-stage.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_ = NULL;
#line 104 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		e = _inner_error_;
#line 104 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_inner_error_ = NULL;
#line 107 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_tmp1_ = e;
#line 107 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		gitg_test_assert_assert_no_error (_tmp1_);
#line 104 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_error_free0 (e);
#line 709 "test-stage.c"
	}
	__finally0:
#line 104 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 104 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 104 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		g_clear_error (&_inner_error_);
#line 104 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		return;
#line 720 "test-stage.c"
	}
#line 109 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, ggit_status_flags_get_type (), NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 109 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	m = _tmp2_;
#line 111 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	gee_abstract_map_set ((GeeAbstractMap*) m, "a", (gpointer) ((gintptr) GGIT_STATUS_INDEX_MODIFIED));
#line 112 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	gee_abstract_map_set ((GeeAbstractMap*) m, "b", (gpointer) ((gintptr) (GGIT_STATUS_WORKING_TREE_MODIFIED | GGIT_STATUS_INDEX_MODIFIED)));
#line 113 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	gee_abstract_map_set ((GeeAbstractMap*) m, "c", (gpointer) ((gintptr) GGIT_STATUS_WORKING_TREE_DELETED));
#line 115 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	lib_gitg_test_stage_check_file_status (self, _data2_->loop, m);
#line 103 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_g_object_unref0 (m);
#line 736 "test-stage.c"
}


static void ___lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 103 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	__lambda5_ (self, source_object, res);
#line 103 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	block2_data_unref (self);
#line 745 "test-stage.c"
}


static void lib_gitg_test_stage_real_test_stage (LibGitgTestStage* self) {
	Block2Data* _data2_;
	GitgRepository* _tmp0_ = NULL;
	GitgStage* _tmp1_ = NULL;
	GitgStage* _tmp2_ = NULL;
	GMainLoop* _tmp3_ = NULL;
#line 97 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 97 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_data2_->_ref_count_ = 1;
#line 97 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_data2_->self = g_object_ref (self);
#line 99 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp0_ = ((GitgTestRepository*) self)->d_repository;
#line 99 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp1_ = gitg_repository_get_stage (_tmp0_);
#line 99 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp2_ = _tmp1_;
#line 99 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_data2_->stage = _tmp2_;
#line 101 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp3_ = g_main_loop_new (NULL, FALSE);
#line 101 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_data2_->loop = _tmp3_;
#line 103 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	gitg_stage_stage_path (_data2_->stage, "a", ___lambda5__gasync_ready_callback, block2_data_ref (_data2_));
#line 118 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	g_main_loop_run (_data2_->loop);
#line 97 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	block2_data_unref (_data2_);
#line 97 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_data2_ = NULL;
#line 781 "test-stage.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 124 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 124 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	return _data3_;
#line 790 "test-stage.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 124 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 799 "test-stage.c"
		LibGitgTestStage* self;
#line 124 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		self = _data3_->self;
#line 124 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_main_loop_unref0 (_data3_->loop);
#line 124 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_object_unref0 (_data3_->stage);
#line 124 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_object_unref0 (self);
#line 124 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		g_slice_free (Block3Data, _data3_);
#line 811 "test-stage.c"
	}
}


static void __lambda6_ (Block3Data* _data3_, GObject* obj, GAsyncResult* res) {
	LibGitgTestStage* self;
	GeeHashMap* m = NULL;
	GeeHashMap* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 130 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	self = _data3_->self;
#line 130 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	g_return_if_fail (res != NULL);
#line 825 "test-stage.c"
	{
		GAsyncResult* _tmp0_ = NULL;
#line 133 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_tmp0_ = res;
#line 133 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		gitg_stage_unstage_finish (_data3_->stage, _tmp0_, &_inner_error_);
#line 133 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 834 "test-stage.c"
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_ = NULL;
#line 131 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		e = _inner_error_;
#line 131 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_inner_error_ = NULL;
#line 134 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_tmp1_ = e;
#line 134 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		gitg_test_assert_assert_no_error (_tmp1_);
#line 131 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_error_free0 (e);
#line 853 "test-stage.c"
	}
	__finally1:
#line 131 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 131 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 131 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		g_clear_error (&_inner_error_);
#line 131 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		return;
#line 864 "test-stage.c"
	}
#line 136 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, ggit_status_flags_get_type (), NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 136 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	m = _tmp2_;
#line 138 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	gee_abstract_map_set ((GeeAbstractMap*) m, "a", (gpointer) ((gintptr) GGIT_STATUS_WORKING_TREE_MODIFIED));
#line 139 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	gee_abstract_map_set ((GeeAbstractMap*) m, "b", (gpointer) ((gintptr) GGIT_STATUS_WORKING_TREE_MODIFIED));
#line 140 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	gee_abstract_map_set ((GeeAbstractMap*) m, "c", (gpointer) ((gintptr) GGIT_STATUS_WORKING_TREE_DELETED));
#line 142 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	lib_gitg_test_stage_check_file_status (self, _data3_->loop, m);
#line 130 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_g_object_unref0 (m);
#line 880 "test-stage.c"
}


static void ___lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 130 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	__lambda6_ (self, source_object, res);
#line 130 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	block3_data_unref (self);
#line 889 "test-stage.c"
}


static void lib_gitg_test_stage_real_test_unstage (LibGitgTestStage* self) {
	Block3Data* _data3_;
	GitgRepository* _tmp0_ = NULL;
	GitgStage* _tmp1_ = NULL;
	GitgStage* _tmp2_ = NULL;
	GMainLoop* _tmp3_ = NULL;
#line 124 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 124 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_data3_->_ref_count_ = 1;
#line 124 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_data3_->self = g_object_ref (self);
#line 126 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp0_ = ((GitgTestRepository*) self)->d_repository;
#line 126 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp1_ = gitg_repository_get_stage (_tmp0_);
#line 126 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp2_ = _tmp1_;
#line 126 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_data3_->stage = _tmp2_;
#line 128 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp3_ = g_main_loop_new (NULL, FALSE);
#line 128 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_data3_->loop = _tmp3_;
#line 130 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	gitg_stage_unstage_path (_data3_->stage, "b", ___lambda6__gasync_ready_callback, block3_data_ref (_data3_));
#line 145 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	g_main_loop_run (_data3_->loop);
#line 124 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	block3_data_unref (_data3_);
#line 124 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_data3_ = NULL;
#line 925 "test-stage.c"
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
#line 151 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 151 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	return _data4_;
#line 934 "test-stage.c"
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 151 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 943 "test-stage.c"
		LibGitgTestStage* self;
#line 151 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		self = _data4_->self;
#line 151 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_main_loop_unref0 (_data4_->loop);
#line 151 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_object_unref0 (_data4_->stage);
#line 151 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_object_unref0 (self);
#line 151 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		g_slice_free (Block4Data, _data4_);
#line 955 "test-stage.c"
	}
}


static void __lambda7_ (Block4Data* _data4_, GObject* obj, GAsyncResult* res) {
	LibGitgTestStage* self;
	GeeHashMap* m = NULL;
	GeeHashMap* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 157 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	self = _data4_->self;
#line 157 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	g_return_if_fail (res != NULL);
#line 969 "test-stage.c"
	{
		GAsyncResult* _tmp0_ = NULL;
#line 160 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_tmp0_ = res;
#line 160 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		gitg_stage_revert_finish (_data4_->stage, _tmp0_, &_inner_error_);
#line 160 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 978 "test-stage.c"
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_ = NULL;
#line 158 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		e = _inner_error_;
#line 158 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_inner_error_ = NULL;
#line 161 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_tmp1_ = e;
#line 161 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		gitg_test_assert_assert_no_error (_tmp1_);
#line 158 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_error_free0 (e);
#line 997 "test-stage.c"
	}
	__finally2:
#line 158 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 158 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 158 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		g_clear_error (&_inner_error_);
#line 158 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		return;
#line 1008 "test-stage.c"
	}
#line 163 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, ggit_status_flags_get_type (), NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 163 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	m = _tmp2_;
#line 165 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	gee_abstract_map_set ((GeeAbstractMap*) m, "b", (gpointer) ((gintptr) (GGIT_STATUS_INDEX_MODIFIED | GGIT_STATUS_WORKING_TREE_MODIFIED)));
#line 166 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	gee_abstract_map_set ((GeeAbstractMap*) m, "c", (gpointer) ((gintptr) GGIT_STATUS_WORKING_TREE_DELETED));
#line 168 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	lib_gitg_test_stage_check_file_status (self, _data4_->loop, m);
#line 157 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_g_object_unref0 (m);
#line 1022 "test-stage.c"
}


static void ___lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 157 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	__lambda7_ (self, source_object, res);
#line 157 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	block4_data_unref (self);
#line 1031 "test-stage.c"
}


static void lib_gitg_test_stage_real_test_revert (LibGitgTestStage* self) {
	Block4Data* _data4_;
	GitgRepository* _tmp0_ = NULL;
	GitgStage* _tmp1_ = NULL;
	GitgStage* _tmp2_ = NULL;
	GMainLoop* _tmp3_ = NULL;
#line 151 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_data4_ = g_slice_new0 (Block4Data);
#line 151 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_data4_->_ref_count_ = 1;
#line 151 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_data4_->self = g_object_ref (self);
#line 153 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp0_ = ((GitgTestRepository*) self)->d_repository;
#line 153 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp1_ = gitg_repository_get_stage (_tmp0_);
#line 153 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp2_ = _tmp1_;
#line 153 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_data4_->stage = _tmp2_;
#line 155 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp3_ = g_main_loop_new (NULL, FALSE);
#line 155 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_data4_->loop = _tmp3_;
#line 157 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	gitg_stage_revert_path (_data4_->stage, "a", ___lambda7__gasync_ready_callback, block4_data_ref (_data4_));
#line 171 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	g_main_loop_run (_data4_->loop);
#line 151 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	block4_data_unref (_data4_);
#line 151 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_data4_ = NULL;
#line 1067 "test-stage.c"
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
#line 177 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 177 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	return _data5_;
#line 1076 "test-stage.c"
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 177 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 1085 "test-stage.c"
		LibGitgTestStage* self;
#line 177 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		self = _data5_->self;
#line 177 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_main_loop_unref0 (_data5_->loop);
#line 177 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_object_unref0 (_data5_->stage);
#line 177 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_object_unref0 (self);
#line 177 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		g_slice_free (Block5Data, _data5_);
#line 1097 "test-stage.c"
	}
}


static void __lambda8_ (Block5Data* _data5_, GObject* obj, GAsyncResult* res) {
	LibGitgTestStage* self;
	GeeHashMap* m = NULL;
	GeeHashMap* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 183 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	self = _data5_->self;
#line 183 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	g_return_if_fail (res != NULL);
#line 1111 "test-stage.c"
	{
		GAsyncResult* _tmp0_ = NULL;
#line 186 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_tmp0_ = res;
#line 186 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		gitg_stage_delete_finish (_data5_->stage, _tmp0_, &_inner_error_);
#line 186 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1120 "test-stage.c"
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_ = NULL;
#line 184 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		e = _inner_error_;
#line 184 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_inner_error_ = NULL;
#line 187 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_tmp1_ = e;
#line 187 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		gitg_test_assert_assert_no_error (_tmp1_);
#line 184 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		_g_error_free0 (e);
#line 1139 "test-stage.c"
	}
	__finally3:
#line 184 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 184 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 184 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		g_clear_error (&_inner_error_);
#line 184 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
		return;
#line 1150 "test-stage.c"
	}
#line 189 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, ggit_status_flags_get_type (), NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 189 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	m = _tmp2_;
#line 191 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	gee_abstract_map_set ((GeeAbstractMap*) m, "a", (gpointer) ((gintptr) GGIT_STATUS_WORKING_TREE_MODIFIED));
#line 192 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	gee_abstract_map_set ((GeeAbstractMap*) m, "b", (gpointer) ((gintptr) (GGIT_STATUS_INDEX_MODIFIED | GGIT_STATUS_WORKING_TREE_MODIFIED)));
#line 193 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	gee_abstract_map_set ((GeeAbstractMap*) m, "c", (gpointer) ((gintptr) GGIT_STATUS_INDEX_DELETED));
#line 195 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	lib_gitg_test_stage_check_file_status (self, _data5_->loop, m);
#line 183 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_g_object_unref0 (m);
#line 1166 "test-stage.c"
}


static void ___lambda8__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 183 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	__lambda8_ (self, source_object, res);
#line 183 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	block5_data_unref (self);
#line 1175 "test-stage.c"
}


static void lib_gitg_test_stage_real_test_delete (LibGitgTestStage* self) {
	Block5Data* _data5_;
	GitgRepository* _tmp0_ = NULL;
	GitgStage* _tmp1_ = NULL;
	GitgStage* _tmp2_ = NULL;
	GMainLoop* _tmp3_ = NULL;
#line 177 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_data5_ = g_slice_new0 (Block5Data);
#line 177 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_data5_->_ref_count_ = 1;
#line 177 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_data5_->self = g_object_ref (self);
#line 179 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp0_ = ((GitgTestRepository*) self)->d_repository;
#line 179 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp1_ = gitg_repository_get_stage (_tmp0_);
#line 179 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp2_ = _tmp1_;
#line 179 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_data5_->stage = _tmp2_;
#line 181 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_tmp3_ = g_main_loop_new (NULL, FALSE);
#line 181 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_data5_->loop = _tmp3_;
#line 183 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	gitg_stage_delete_path (_data5_->stage, "c", ___lambda8__gasync_ready_callback, block5_data_ref (_data5_));
#line 198 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	g_main_loop_run (_data5_->loop);
#line 177 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	block5_data_unref (_data5_);
#line 177 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	_data5_ = NULL;
#line 1211 "test-stage.c"
}


static void lib_gitg_test_stage_class_init (LibGitgTestStageClass * klass) {
#line 23 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	lib_gitg_test_stage_parent_class = g_type_class_peek_parent (klass);
#line 23 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	((GitgTestTestClass *) klass)->set_up = lib_gitg_test_stage_real_set_up;
#line 23 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	((LibGitgTestStageClass *) klass)->test_file_status = lib_gitg_test_stage_real_test_file_status;
#line 23 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	((LibGitgTestStageClass *) klass)->test_stage = lib_gitg_test_stage_real_test_stage;
#line 23 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	((LibGitgTestStageClass *) klass)->test_unstage = lib_gitg_test_stage_real_test_unstage;
#line 23 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	((LibGitgTestStageClass *) klass)->test_revert = lib_gitg_test_stage_real_test_revert;
#line 23 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	((LibGitgTestStageClass *) klass)->test_delete = lib_gitg_test_stage_real_test_delete;
#line 1230 "test-stage.c"
	/**
	 * Test whether the different file statuses created by the set_up()
	 * are properly reported by the stage file status enumerator.
	 */
#line 23 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	g_signal_new ("test_file_status", LIB_GITG_TEST_TYPE_STAGE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (LibGitgTestStageClass, test_file_status), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1237 "test-stage.c"
	/**
	 * test staging a complete file in the index.
	 */
#line 23 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	g_signal_new ("test_stage", LIB_GITG_TEST_TYPE_STAGE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (LibGitgTestStageClass, test_stage), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1243 "test-stage.c"
	/**
	 * test staging a complete file in the index.
	 */
#line 23 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	g_signal_new ("test_unstage", LIB_GITG_TEST_TYPE_STAGE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (LibGitgTestStageClass, test_unstage), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1249 "test-stage.c"
	/**
	 * test reverting a complete file in the index.
	 */
#line 23 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	g_signal_new ("test_revert", LIB_GITG_TEST_TYPE_STAGE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (LibGitgTestStageClass, test_revert), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1255 "test-stage.c"
	/**
	 * test deleting a file in the index.
	 */
#line 23 "/home/nacho/checkout/gnome/gitg/tests/libgitg/test-stage.vala"
	g_signal_new ("test_delete", LIB_GITG_TEST_TYPE_STAGE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (LibGitgTestStageClass, test_delete), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1261 "test-stage.c"
}


static void lib_gitg_test_stage_instance_init (LibGitgTestStage * self) {
}


GType lib_gitg_test_stage_get_type (void) {
	static volatile gsize lib_gitg_test_stage_type_id__volatile = 0;
	if (g_once_init_enter (&lib_gitg_test_stage_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LibGitgTestStageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) lib_gitg_test_stage_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LibGitgTestStage), 0, (GInstanceInitFunc) lib_gitg_test_stage_instance_init, NULL };
		GType lib_gitg_test_stage_type_id;
		lib_gitg_test_stage_type_id = g_type_register_static (GITG_TEST_TYPE_REPOSITORY, "LibGitgTestStage", &g_define_type_info, 0);
		g_once_init_leave (&lib_gitg_test_stage_type_id__volatile, lib_gitg_test_stage_type_id);
	}
	return lib_gitg_test_stage_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



