/* gitg-repository-list-box.c generated by valac 0.30.0.38-a55d, the Vala compiler
 * generated from gitg-repository-list-box.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012-2016 - Ignacio Casal Quinteiro
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <libgit2-glib/ggit.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <ide.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>


#define GITG_TYPE_SELECTION_MODE (gitg_selection_mode_get_type ())

#define GITG_TYPE_REPOSITORY_LIST_BOX (gitg_repository_list_box_get_type ())
#define GITG_REPOSITORY_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBox))
#define GITG_REPOSITORY_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBoxClass))
#define GITG_IS_REPOSITORY_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REPOSITORY_LIST_BOX))
#define GITG_IS_REPOSITORY_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REPOSITORY_LIST_BOX))
#define GITG_REPOSITORY_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBoxClass))

typedef struct _GitgRepositoryListBox GitgRepositoryListBox;
typedef struct _GitgRepositoryListBoxClass GitgRepositoryListBoxClass;
typedef struct _GitgRepositoryListBoxPrivate GitgRepositoryListBoxPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define GITG_REPOSITORY_LIST_BOX_TYPE_ROW (gitg_repository_list_box_row_get_type ())
#define GITG_REPOSITORY_LIST_BOX_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow))
#define GITG_REPOSITORY_LIST_BOX_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRowClass))
#define GITG_REPOSITORY_LIST_BOX_IS_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_REPOSITORY_LIST_BOX_TYPE_ROW))
#define GITG_REPOSITORY_LIST_BOX_IS_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_REPOSITORY_LIST_BOX_TYPE_ROW))
#define GITG_REPOSITORY_LIST_BOX_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRowClass))

typedef struct _GitgRepositoryListBoxRow GitgRepositoryListBoxRow;
typedef struct _GitgRepositoryListBoxRowClass GitgRepositoryListBoxRowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GITG_TYPE_REPOSITORY (gitg_repository_get_type ())
#define GITG_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REPOSITORY, GitgRepository))
#define GITG_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REPOSITORY, GitgRepositoryClass))
#define GITG_IS_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REPOSITORY))
#define GITG_IS_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REPOSITORY))
#define GITG_REPOSITORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REPOSITORY, GitgRepositoryClass))

typedef struct _GitgRepository GitgRepository;
typedef struct _GitgRepositoryClass GitgRepositoryClass;
#define _gtk_recent_info_unref0(var) ((var == NULL) ? NULL : (var = (gtk_recent_info_unref (var), NULL)))
#define __g_list_free__gtk_recent_info_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_recent_info_unref0_ (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _Block16Data Block16Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _GitgRepositoryListBoxRowPrivate GitgRepositoryListBoxRowPrivate;

#define GITG_TYPE_PROGRESS_BIN (gitg_progress_bin_get_type ())
#define GITG_PROGRESS_BIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_PROGRESS_BIN, GitgProgressBin))
#define GITG_PROGRESS_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_PROGRESS_BIN, GitgProgressBinClass))
#define GITG_IS_PROGRESS_BIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_PROGRESS_BIN))
#define GITG_IS_PROGRESS_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_PROGRESS_BIN))
#define GITG_PROGRESS_BIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_PROGRESS_BIN, GitgProgressBinClass))

typedef struct _GitgProgressBin GitgProgressBin;
typedef struct _GitgProgressBinClass GitgProgressBinClass;
typedef struct _Block17Data Block17Data;
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))

#define GITG_TYPE_REF (gitg_ref_get_type ())
#define GITG_REF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REF, GitgRef))
#define GITG_IS_REF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REF))
#define GITG_REF_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_REF, GitgRefIface))

typedef struct _GitgRef GitgRef;
typedef struct _GitgRefIface GitgRefIface;

#define GITG_TYPE_PARSED_REF_NAME (gitg_parsed_ref_name_get_type ())
#define GITG_PARSED_REF_NAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefName))
#define GITG_PARSED_REF_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefNameClass))
#define GITG_IS_PARSED_REF_NAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_PARSED_REF_NAME))
#define GITG_IS_PARSED_REF_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_PARSED_REF_NAME))
#define GITG_PARSED_REF_NAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefNameClass))

typedef struct _GitgParsedRefName GitgParsedRefName;
typedef struct _GitgParsedRefNameClass GitgParsedRefNameClass;

#define GITG_TYPE_REF_STATE (gitg_ref_state_get_type ())
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))

typedef enum  {
	GITG_SELECTION_MODE_NORMAL,
	GITG_SELECTION_MODE_SELECTION
} GitgSelectionMode;

struct _GitgRepositoryListBox {
	GtkListBox parent_instance;
	GitgRepositoryListBoxPrivate * priv;
};

struct _GitgRepositoryListBoxClass {
	GtkListBoxClass parent_class;
};

struct _GitgRepositoryListBoxPrivate {
	gchar* d_filter_text;
	GitgSelectionMode _mode;
};

struct _Block16Data {
	int _ref_count_;
	GitgRepositoryListBox* self;
	GitgRepositoryListBoxRow* row;
	GFile* f;
};

struct _GitgRepositoryListBoxRow {
	GtkListBoxRow parent_instance;
	GitgRepositoryListBoxRowPrivate * priv;
};

struct _GitgRepositoryListBoxRowClass {
	GtkListBoxRowClass parent_class;
};

struct _GitgRepositoryListBoxRowPrivate {
	GitgRepository* d_repository;
	GDateTime* d_time;
	gboolean d_loading;
	GitgProgressBin* d_progress_bin;
	GtkLabel* d_repository_label;
	GtkLabel* d_description_label;
	GtkLabel* d_branch_label;
	GtkSpinner* d_spinner;
	GtkCheckButton* d_remove_check_button;
	GtkRevealer* d_remove_revealer;
	GtkBox* d_languages_box;
	GitgSelectionMode d_mode;
	gchar* d_dirname;
	gchar* d_branch_name;
	gboolean _selected;
};

struct _Block17Data {
	int _ref_count_;
	GitgRepositoryListBoxRow* self;
	GgitOId* entry_id;
};

typedef enum  {
	GITG_REF_STATE_NONE,
	GITG_REF_STATE_SELECTED,
	GITG_REF_STATE_PRELIGHT
} GitgRefState;

struct _GitgRefIface {
	GTypeInterface parent_iface;
	GitgRepository* (*get_owner) (GitgRef* self);
	GitgParsedRefName* (*get_d_parsed_name) (GitgRef* self);
	void (*set_d_parsed_name) (GitgRef* self, GitgParsedRefName* value);
	GList* (*get_d_pushes) (GitgRef* self);
	void (*set_d_pushes) (GitgRef* self, GList* value);
	GitgRefState (*get_state) (GitgRef* self);
	void (*set_state) (GitgRef* self, GitgRefState value);
	gboolean (*get_working) (GitgRef* self);
	void (*set_working) (GitgRef* self, gboolean value);
};


static gpointer gitg_repository_list_box_parent_class = NULL;
static gpointer gitg_repository_list_box_row_parent_class = NULL;

GType gitg_selection_mode_get_type (void) G_GNUC_CONST;
GType gitg_repository_list_box_get_type (void) G_GNUC_CONST;
#define GITG_REPOSITORY_LIST_BOX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBoxPrivate))
enum  {
	GITG_REPOSITORY_LIST_BOX_DUMMY_PROPERTY,
	GITG_REPOSITORY_LIST_BOX_MODE,
	GITG_REPOSITORY_LIST_BOX_HAS_SELECTION
};
static gboolean gitg_repository_list_box_real_button_press_event (GtkWidget* base, GdkEventButton* event);
GitgSelectionMode gitg_repository_list_box_get_mode (GitgRepositoryListBox* self);
void gitg_repository_list_box_set_mode (GitgRepositoryListBox* self, GitgSelectionMode value);
GType gitg_repository_list_box_row_get_type (void) G_GNUC_CONST;
void gitg_repository_list_box_row_set_selected (GitgRepositoryListBoxRow* self, gboolean value);
static void gitg_repository_list_box_real_row_activated (GtkListBox* base, GtkListBoxRow* row);
gboolean gitg_repository_list_box_row_get_selected (GitgRepositoryListBoxRow* self);
GType gitg_repository_get_type (void) G_GNUC_CONST;
GitgRepository* gitg_repository_list_box_row_get_repository (GitgRepositoryListBoxRow* self);
static void gitg_repository_list_box_update_header (GitgRepositoryListBox* self, GtkListBoxRow* row, GtkListBoxRow* before);
static gboolean gitg_repository_list_box_filter (GitgRepositoryListBox* self, GtkListBoxRow* row);
const gchar* gitg_repository_list_box_row_get_repository_name (GitgRepositoryListBoxRow* self);
static gint gitg_repository_list_box_compare_widgets (GitgRepositoryListBox* self, GtkListBoxRow* a, GtkListBoxRow* b);
GDateTime* gitg_repository_list_box_row_get_time (GitgRepositoryListBoxRow* self);
void gitg_repository_list_box_populate_recent (GitgRepositoryListBox* self);
static void gitg_repository_list_box_add_recent_info (GitgRepositoryListBox* self);
GitgRepository* gitg_repository_new (GFile* location, GFile* workdir, GError** error);
GitgRepository* gitg_repository_construct (GType object_type, GFile* location, GFile* workdir, GError** error);
static void _gtk_recent_info_unref0_ (gpointer var);
static void _g_list_free__gtk_recent_info_unref0_ (GList* self);
GitgRepositoryListBoxRow* gitg_repository_list_box_add_repository (GitgRepositoryListBox* self, GitgRepository* repository);
static GitgRepositoryListBoxRow* gitg_repository_list_box_get_row_for_repository (GitgRepositoryListBox* self, GitgRepository* repository);
static void gitg_repository_list_box_add_repository_to_recent_manager (GitgRepositoryListBox* self, const gchar* uri);
static void gtk_recent_data_destroy (GtkRecentData* self);
void gitg_repository_list_box_end_cloning (GitgRepositoryListBox* self, GitgRepositoryListBoxRow* row, GitgRepository* repository);
void gitg_repository_list_box_row_set_repository (GitgRepositoryListBoxRow* self, GitgRepository* value);
void gitg_repository_list_box_row_set_loading (GitgRepositoryListBoxRow* self, gboolean value);
GitgRepositoryListBoxRow* gitg_repository_list_box_begin_cloning (GitgRepositoryListBox* self, GFile* location);
gchar* gitg_utils_replace_home_dir_with_tilde (GFile* file);
GitgRepositoryListBoxRow* gitg_repository_list_box_row_new (GitgRepository* repository, const gchar* dirname);
GitgRepositoryListBoxRow* gitg_repository_list_box_row_construct (GType object_type, GitgRepository* repository, const gchar* dirname);
void gitg_repository_list_box_row_set_repository_name (GitgRepositoryListBoxRow* self, const gchar* value);
void gitg_repository_list_box_row_set_branch_name (GitgRepositoryListBoxRow* self, const gchar* value);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static void ____lambda67_ (GitgRepositoryListBox* self);
static void _____lambda67__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void ____lambda68_ (Block16Data* _data16_);
static void _____lambda68__gitg_repository_list_box_row_request_remove (GitgRepositoryListBoxRow* _sender, gpointer self);
void gitg_repository_list_box_row_set_can_remove (GitgRepositoryListBoxRow* self, gboolean value);
void gitg_repository_list_box_row_set_time (GitgRepositoryListBoxRow* self, GDateTime* value);
void gitg_repository_list_box_filter_text (GitgRepositoryListBox* self, const gchar* text);
GitgRepositoryListBox* gitg_repository_list_box_new (void);
GitgRepositoryListBox* gitg_repository_list_box_construct (GType object_type);
GitgRepositoryListBoxRow** gitg_repository_list_box_get_selection (GitgRepositoryListBox* self, int* result_length1);
static void _vala_array_add16 (GitgRepositoryListBoxRow*** array, int* length, int* size, GitgRepositoryListBoxRow* value);
gboolean gitg_repository_list_box_get_has_selection (GitgRepositoryListBox* self);
static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * gitg_repository_list_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _gitg_repository_list_box_update_header_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self);
static gboolean _gitg_repository_list_box_filter_gtk_list_box_filter_func (GtkListBoxRow* row, gpointer self);
static gint _gitg_repository_list_box_compare_widgets_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self);
GType gitg_progress_bin_get_type (void) G_GNUC_CONST;
#define GITG_REPOSITORY_LIST_BOX_ROW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRowPrivate))
enum  {
	GITG_REPOSITORY_LIST_BOX_ROW_DUMMY_PROPERTY,
	GITG_REPOSITORY_LIST_BOX_ROW_MODE,
	GITG_REPOSITORY_LIST_BOX_ROW_SELECTED,
	GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY,
	GITG_REPOSITORY_LIST_BOX_ROW_CAN_REMOVE,
	GITG_REPOSITORY_LIST_BOX_ROW_TIME,
	GITG_REPOSITORY_LIST_BOX_ROW_FRACTION,
	GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_NAME,
	GITG_REPOSITORY_LIST_BOX_ROW_DIRNAME,
	GITG_REPOSITORY_LIST_BOX_ROW_BRANCH_NAME,
	GITG_REPOSITORY_LIST_BOX_ROW_LOADING
};
static void gitg_repository_list_box_row_update_branch_label (GitgRepositoryListBoxRow* self);
static void gitg_repository_list_box_row_update_repository_data (GitgRepositoryListBoxRow* self);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void _vala_GgitOId_free (GgitOId* self);
static void block17_data_unref (void * _userdata_);
GType gitg_parsed_ref_name_get_type (void) G_GNUC_CONST;
GType gitg_ref_state_get_type (void) G_GNUC_CONST;
GType gitg_ref_get_type (void) G_GNUC_CONST;
GitgRef* gitg_repository_get_head (GitgRepository* self, GError** error);
GitgParsedRefName* gitg_ref_get_parsed_name (GitgRef* self);
gchar* gitg_parsed_ref_name_get_shortname (GitgParsedRefName* self);
static gint ____lambda66_ (Block17Data* _data17_, const gchar* root, GgitTreeEntry* entry);
static gint _____lambda66__ggit_tree_walk_callback (const gchar* root, GgitTreeEntry* entry, gpointer self);
gpointer gitg_repository_lookup (GitgRepository* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GgitOId* id, GError** error);
gchar* gitg_repository_get_name (GitgRepository* self);
GitgSelectionMode gitg_repository_list_box_row_get_mode (GitgRepositoryListBoxRow* self);
void gitg_repository_list_box_row_set_mode (GitgRepositoryListBoxRow* self, GitgSelectionMode value);
gboolean gitg_repository_list_box_row_get_can_remove (GitgRepositoryListBoxRow* self);
void gitg_repository_list_box_row_set_fraction (GitgRepositoryListBoxRow* self, gdouble value);
void gitg_progress_bin_set_fraction (GitgProgressBin* self, gdouble value);
const gchar* gitg_repository_list_box_row_get_dirname (GitgRepositoryListBoxRow* self);
void gitg_repository_list_box_row_set_dirname (GitgRepositoryListBoxRow* self, const gchar* value);
const gchar* gitg_repository_list_box_row_get_branch_name (GitgRepositoryListBoxRow* self);
gboolean gitg_repository_list_box_row_get_loading (GitgRepositoryListBoxRow* self);
static GObject * gitg_repository_list_box_row_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gitg_repository_list_box_row_finalize (GObject* obj);
static void _vala_gitg_repository_list_box_row_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gitg_repository_list_box_row_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void gitg_repository_list_box_finalize (GObject* obj);
static void _vala_gitg_repository_list_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gitg_repository_list_box_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType gitg_selection_mode_get_type (void) {
	static volatile gsize gitg_selection_mode_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_selection_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{GITG_SELECTION_MODE_NORMAL, "GITG_SELECTION_MODE_NORMAL", "normal"}, {GITG_SELECTION_MODE_SELECTION, "GITG_SELECTION_MODE_SELECTION", "selection"}, {0, NULL, NULL}};
		GType gitg_selection_mode_type_id;
		gitg_selection_mode_type_id = g_enum_register_static ("GitgSelectionMode", values);
		g_once_init_leave (&gitg_selection_mode_type_id__volatile, gitg_selection_mode_type_id);
	}
	return gitg_selection_mode_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 267 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return self ? g_object_ref (self) : NULL;
#line 321 "gitg-repository-list-box.c"
}


static gboolean gitg_repository_list_box_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	GitgRepositoryListBox * self;
	gboolean result = FALSE;
	GdkEvent* ev = NULL;
	GdkEventButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GdkEvent* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GdkEventButton* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
#line 259 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self = (GitgRepositoryListBox*) base;
#line 259 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 261 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = event;
#line 261 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	ev = (GdkEvent*) _tmp0_;
#line 263 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = ev;
#line 263 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = gdk_event_triggers_context_menu (_tmp2_);
#line 263 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp3_) {
#line 349 "gitg-repository-list-box.c"
		GitgSelectionMode _tmp4_ = 0;
#line 263 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = self->priv->_mode;
#line 263 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp1_ = _tmp4_ == GITG_SELECTION_MODE_NORMAL;
#line 355 "gitg-repository-list-box.c"
	} else {
#line 263 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp1_ = FALSE;
#line 359 "gitg-repository-list-box.c"
	}
#line 263 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp1_) {
#line 363 "gitg-repository-list-box.c"
		GitgRepositoryListBoxRow* row = NULL;
		GdkEventButton* _tmp5_ = NULL;
		gdouble _tmp6_ = 0.0;
		GtkListBoxRow* _tmp7_ = NULL;
		GitgRepositoryListBoxRow* _tmp8_ = NULL;
		GitgRepositoryListBoxRow* _tmp9_ = NULL;
#line 265 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_set_mode (self, GITG_SELECTION_MODE_SELECTION);
#line 267 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = event;
#line 267 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = _tmp5_->y;
#line 267 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp7_ = gtk_list_box_get_row_at_y ((GtkListBox*) self, (gint) _tmp6_);
#line 267 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW) ? ((GitgRepositoryListBoxRow*) _tmp7_) : NULL);
#line 267 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		row = _tmp8_;
#line 269 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp9_ = row;
#line 269 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		if (_tmp9_ != NULL) {
#line 386 "gitg-repository-list-box.c"
			GitgRepositoryListBoxRow* _tmp10_ = NULL;
#line 271 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp10_ = row;
#line 271 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			gitg_repository_list_box_row_set_selected (_tmp10_, TRUE);
#line 392 "gitg-repository-list-box.c"
		}
#line 274 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		result = TRUE;
#line 274 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (row);
#line 274 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		return result;
#line 400 "gitg-repository-list-box.c"
	}
#line 277 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp11_ = event;
#line 277 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp12_ = GTK_WIDGET_CLASS (gitg_repository_list_box_parent_class)->button_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_get_type (), GtkListBox), _tmp11_);
#line 277 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp12_;
#line 277 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 410 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_real_row_activated (GtkListBox* base, GtkListBoxRow* row) {
	GitgRepositoryListBox * self;
	GitgRepositoryListBoxRow* r = NULL;
	GtkListBoxRow* _tmp0_ = NULL;
	GitgRepositoryListBoxRow* _tmp1_ = NULL;
	GitgSelectionMode _tmp2_ = 0;
	GitgRepositoryListBoxRow* _tmp7_ = NULL;
	GitgRepository* _tmp8_ = NULL;
	GitgRepository* _tmp9_ = NULL;
#line 280 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self = (GitgRepositoryListBox*) base;
#line 280 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (row != NULL);
#line 282 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = row;
#line 282 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 282 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	r = _tmp1_;
#line 284 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = self->priv->_mode;
#line 284 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp2_ == GITG_SELECTION_MODE_SELECTION) {
#line 437 "gitg-repository-list-box.c"
		GitgRepositoryListBoxRow* _tmp3_ = NULL;
		GitgRepositoryListBoxRow* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
#line 286 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = r;
#line 286 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = r;
#line 286 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = gitg_repository_list_box_row_get_selected (_tmp4_);
#line 286 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = _tmp5_;
#line 286 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_selected (_tmp3_, !_tmp6_);
#line 287 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (r);
#line 287 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		return;
#line 456 "gitg-repository-list-box.c"
	}
#line 290 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp7_ = r;
#line 290 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp8_ = gitg_repository_list_box_row_get_repository (_tmp7_);
#line 290 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp9_ = _tmp8_;
#line 290 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp9_ != NULL) {
#line 466 "gitg-repository-list-box.c"
		GitgRepositoryListBoxRow* _tmp10_ = NULL;
		GitgRepository* _tmp11_ = NULL;
		GitgRepository* _tmp12_ = NULL;
#line 292 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp10_ = r;
#line 292 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp11_ = gitg_repository_list_box_row_get_repository (_tmp10_);
#line 292 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp12_ = _tmp11_;
#line 292 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_signal_emit_by_name (self, "repository-activated", _tmp12_);
#line 478 "gitg-repository-list-box.c"
	}
#line 280 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (r);
#line 482 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_update_header (GitgRepositoryListBox* self, GtkListBoxRow* row, GtkListBoxRow* before) {
	GtkSeparator* _tmp0_ = NULL;
	GtkListBoxRow* _tmp1_ = NULL;
	GtkListBoxRow* _tmp3_ = NULL;
#line 306 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 306 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (row != NULL);
#line 308 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = before;
#line 308 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp1_ != NULL) {
#line 498 "gitg-repository-list-box.c"
		GtkSeparator* _tmp2_ = NULL;
#line 308 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
#line 308 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_object_ref_sink (_tmp2_);
#line 308 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp0_);
#line 308 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = _tmp2_;
#line 508 "gitg-repository-list-box.c"
	} else {
#line 308 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp0_);
#line 308 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = NULL;
#line 514 "gitg-repository-list-box.c"
	}
#line 308 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = row;
#line 308 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_row_set_header (_tmp3_, (GtkWidget*) _tmp0_);
#line 306 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_tmp0_);
#line 522 "gitg-repository-list-box.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1278 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1278 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1279 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1279 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1279 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1279 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	return result;
#line 542 "gitg-repository-list-box.c"
}


static gboolean gitg_repository_list_box_filter (GitgRepositoryListBox* self, GtkListBoxRow* row) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
#line 311 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 311 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (row != NULL, FALSE);
#line 313 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = self->priv->d_filter_text;
#line 313 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp1_ != NULL) {
#line 558 "gitg-repository-list-box.c"
		GtkListBoxRow* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 313 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = row;
#line 313 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = gitg_repository_list_box_row_get_repository_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 313 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = _tmp3_;
#line 313 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = self->priv->d_filter_text;
#line 313 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = string_contains (_tmp4_, _tmp5_);
#line 313 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = _tmp6_;
#line 576 "gitg-repository-list-box.c"
	} else {
#line 313 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = TRUE;
#line 580 "gitg-repository-list-box.c"
	}
#line 313 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 313 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 586 "gitg-repository-list-box.c"
}


static gint gitg_repository_list_box_compare_widgets (GitgRepositoryListBox* self, GtkListBoxRow* a, GtkListBoxRow* b) {
	gint result = 0;
	GtkListBoxRow* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
	GDateTime* _tmp2_ = NULL;
	GtkListBoxRow* _tmp3_ = NULL;
	GDateTime* _tmp4_ = NULL;
	GDateTime* _tmp5_ = NULL;
	gint _tmp6_ = 0;
#line 316 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 316 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 316 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (b != NULL, 0);
#line 318 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = a;
#line 318 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = gitg_repository_list_box_row_get_time (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 318 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = _tmp1_;
#line 318 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = b;
#line 318 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = gitg_repository_list_box_row_get_time (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 318 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = _tmp4_;
#line 318 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp6_ = g_date_time_compare (_tmp2_, _tmp5_);
#line 318 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = -_tmp6_;
#line 318 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 623 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_populate_recent (GitgRepositoryListBox* self) {
#line 321 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 323 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_add_recent_info (self);
#line 632 "gitg-repository-list-box.c"
}


static gpointer _gtk_recent_info_ref0 (gpointer self) {
#line 332 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return self ? gtk_recent_info_ref (self) : NULL;
#line 639 "gitg-repository-list-box.c"
}


static void _gtk_recent_info_unref0_ (gpointer var) {
#line 345 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	(var == NULL) ? NULL : (var = (gtk_recent_info_unref (var), NULL));
#line 646 "gitg-repository-list-box.c"
}


static void _g_list_free__gtk_recent_info_unref0_ (GList* self) {
#line 345 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_list_foreach (self, (GFunc) _gtk_recent_info_unref0_, NULL);
#line 345 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_list_free (self);
#line 655 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_add_recent_info (GitgRepositoryListBox* self) {
	GtkRecentManager* recent_manager = NULL;
	GtkRecentManager* _tmp0_ = NULL;
	GtkRecentManager* _tmp1_ = NULL;
	GList* reversed_items = NULL;
	GtkRecentManager* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 326 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 328 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = gtk_recent_manager_get_default ();
#line 328 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 328 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	recent_manager = _tmp1_;
#line 329 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = recent_manager;
#line 329 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = gtk_recent_manager_get_items (_tmp2_);
#line 329 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	reversed_items = _tmp3_;
#line 330 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	reversed_items = g_list_reverse (reversed_items);
#line 332 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = reversed_items;
#line 686 "gitg-repository-list-box.c"
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
#line 332 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		item_collection = _tmp4_;
#line 332 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
#line 694 "gitg-repository-list-box.c"
			GtkRecentInfo* _tmp5_ = NULL;
			GtkRecentInfo* item = NULL;
#line 332 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp5_ = _gtk_recent_info_ref0 ((GtkRecentInfo*) item_it->data);
#line 332 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			item = _tmp5_;
#line 701 "gitg-repository-list-box.c"
			{
				GtkRecentInfo* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
#line 334 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp6_ = item;
#line 334 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp7_ = gtk_recent_info_has_group (_tmp6_, "gitg");
#line 334 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				if (_tmp7_) {
#line 711 "gitg-repository-list-box.c"
					GFile* repo_file = NULL;
					GtkRecentInfo* _tmp8_ = NULL;
					const gchar* _tmp9_ = NULL;
					GFile* _tmp10_ = NULL;
					GitgRepository* repo = NULL;
					GitgRepository* _tmp18_ = NULL;
					GitgRepositoryListBoxRow* _tmp19_ = NULL;
					GitgRepositoryListBoxRow* _tmp20_ = NULL;
#line 336 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp8_ = item;
#line 336 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp9_ = gtk_recent_info_get_uri (_tmp8_);
#line 336 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp10_ = g_file_new_for_uri (_tmp9_);
#line 336 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					repo_file = _tmp10_;
#line 728 "gitg-repository-list-box.c"
					{
						GitgRepository* _tmp11_ = NULL;
						GFile* _tmp12_ = NULL;
						GitgRepository* _tmp13_ = NULL;
						GitgRepository* _tmp14_ = NULL;
#line 341 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp12_ = repo_file;
#line 341 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp13_ = gitg_repository_new (_tmp12_, NULL, &_inner_error_);
#line 341 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp11_ = _tmp13_;
#line 341 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 742 "gitg-repository-list-box.c"
							goto __catch51_g_error;
						}
#line 341 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp14_ = _tmp11_;
#line 341 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp11_ = NULL;
#line 341 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo);
#line 341 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						repo = _tmp14_;
#line 339 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (_tmp11_);
#line 755 "gitg-repository-list-box.c"
					}
					goto __finally51;
					__catch51_g_error:
					{
#line 339 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						g_clear_error (&_inner_error_);
#line 339 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_inner_error_ = NULL;
#line 764 "gitg-repository-list-box.c"
						{
							GtkRecentManager* _tmp15_ = NULL;
							GtkRecentInfo* _tmp16_ = NULL;
							const gchar* _tmp17_ = NULL;
#line 347 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp15_ = recent_manager;
#line 347 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp16_ = item;
#line 347 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp17_ = gtk_recent_info_get_uri (_tmp16_);
#line 347 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							gtk_recent_manager_remove_item (_tmp15_, _tmp17_, &_inner_error_);
#line 347 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 779 "gitg-repository-list-box.c"
								goto __catch52_g_error;
							}
						}
						goto __finally52;
						__catch52_g_error:
						{
#line 345 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							g_clear_error (&_inner_error_);
#line 345 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_inner_error_ = NULL;
#line 790 "gitg-repository-list-box.c"
						}
						__finally52:
#line 345 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 345 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_g_object_unref0 (repo);
#line 345 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_g_object_unref0 (repo_file);
#line 345 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_gtk_recent_info_unref0 (item);
#line 345 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							__g_list_free__gtk_recent_info_unref0_0 (reversed_items);
#line 345 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_g_object_unref0 (recent_manager);
#line 345 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 345 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							g_clear_error (&_inner_error_);
#line 345 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							return;
#line 811 "gitg-repository-list-box.c"
						}
#line 350 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo);
#line 350 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo_file);
#line 350 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_gtk_recent_info_unref0 (item);
#line 350 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						continue;
#line 821 "gitg-repository-list-box.c"
					}
					__finally51:
#line 339 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 339 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo);
#line 339 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo_file);
#line 339 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_gtk_recent_info_unref0 (item);
#line 339 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						__g_list_free__gtk_recent_info_unref0_0 (reversed_items);
#line 339 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (recent_manager);
#line 339 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 339 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						g_clear_error (&_inner_error_);
#line 339 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						return;
#line 842 "gitg-repository-list-box.c"
					}
#line 353 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp18_ = repo;
#line 353 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp19_ = gitg_repository_list_box_add_repository (self, _tmp18_);
#line 353 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp20_ = _tmp19_;
#line 353 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (_tmp20_);
#line 334 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (repo);
#line 334 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (repo_file);
#line 856 "gitg-repository-list-box.c"
				}
#line 332 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_gtk_recent_info_unref0 (item);
#line 860 "gitg-repository-list-box.c"
			}
		}
	}
#line 326 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	__g_list_free__gtk_recent_info_unref0_0 (reversed_items);
#line 326 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (recent_manager);
#line 868 "gitg-repository-list-box.c"
}


static GitgRepositoryListBoxRow* gitg_repository_list_box_get_row_for_repository (GitgRepositoryListBox* self, GitgRepository* repository) {
	GitgRepositoryListBoxRow* result = NULL;
	GitgRepositoryListBoxRow* row = NULL;
	GList* _tmp0_ = NULL;
#line 358 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 358 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (repository != NULL, NULL);
#line 360 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	row = NULL;
#line 362 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
#line 884 "gitg-repository-list-box.c"
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
#line 362 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		child_collection = _tmp0_;
#line 362 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
#line 892 "gitg-repository-list-box.c"
			GtkWidget* child = NULL;
#line 362 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			child = (GtkWidget*) child_it->data;
#line 896 "gitg-repository-list-box.c"
			{
				GitgRepositoryListBoxRow* d = NULL;
				GtkWidget* _tmp1_ = NULL;
				GitgRepositoryListBoxRow* _tmp2_ = NULL;
				GitgRepositoryListBoxRow* _tmp3_ = NULL;
				GitgRepository* _tmp4_ = NULL;
				GitgRepository* _tmp5_ = NULL;
				GFile* _tmp6_ = NULL;
				GFile* _tmp7_ = NULL;
				GitgRepository* _tmp8_ = NULL;
				GFile* _tmp9_ = NULL;
				GFile* _tmp10_ = NULL;
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
#line 364 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp1_ = child;
#line 364 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 364 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				d = _tmp2_;
#line 366 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp3_ = d;
#line 366 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp4_ = gitg_repository_list_box_row_get_repository (_tmp3_);
#line 366 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp5_ = _tmp4_;
#line 366 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp6_ = ggit_repository_get_location ((GgitRepository*) _tmp5_);
#line 366 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp7_ = _tmp6_;
#line 366 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp8_ = repository;
#line 366 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp9_ = ggit_repository_get_location ((GgitRepository*) _tmp8_);
#line 366 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp10_ = _tmp9_;
#line 366 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp11_ = g_file_equal (_tmp7_, _tmp10_);
#line 366 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp12_ = _tmp11_;
#line 366 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (_tmp10_);
#line 366 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (_tmp7_);
#line 366 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				if (_tmp12_) {
#line 943 "gitg-repository-list-box.c"
					GitgRepositoryListBoxRow* _tmp13_ = NULL;
					GitgRepositoryListBoxRow* _tmp14_ = NULL;
#line 368 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp13_ = d;
#line 368 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp14_ = _g_object_ref0 (_tmp13_);
#line 368 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (row);
#line 368 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					row = _tmp14_;
#line 369 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (d);
#line 369 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					break;
#line 958 "gitg-repository-list-box.c"
				}
#line 362 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (d);
#line 962 "gitg-repository-list-box.c"
			}
		}
#line 362 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_list_free0 (child_collection);
#line 967 "gitg-repository-list-box.c"
	}
#line 373 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = row;
#line 373 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 973 "gitg-repository-list-box.c"
}


static void gtk_recent_data_destroy (GtkRecentData* self) {
#line 376 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 ((*self).display_name);
#line 376 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 ((*self).description);
#line 376 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 ((*self).mime_type);
#line 376 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 ((*self).app_name);
#line 376 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 ((*self).app_exec);
#line 376 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	(*self).groups = (_vala_array_free ((*self).groups, _vala_array_length ((*self).groups), (GDestroyNotify) g_free), NULL);
#line 990 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_add_repository_to_recent_manager (GitgRepositoryListBox* self, const gchar* uri) {
	GtkRecentManager* recent_manager = NULL;
	GtkRecentManager* _tmp0_ = NULL;
	GtkRecentManager* _tmp1_ = NULL;
	GtkRecentData item = {0};
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GtkRecentData _tmp10_ = {0};
#line 376 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 376 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (uri != NULL);
#line 378 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = gtk_recent_manager_get_default ();
#line 378 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 378 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	recent_manager = _tmp1_;
#line 379 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	memset (&item, 0, sizeof (GtkRecentData));
#line 381 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = g_get_application_name ();
#line 381 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 381 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (item.app_name);
#line 381 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	item.app_name = _tmp3_;
#line 382 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = g_strdup ("inode/directory");
#line 382 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (item.mime_type);
#line 382 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	item.mime_type = _tmp4_;
#line 383 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = g_get_prgname ();
#line 383 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp6_ = g_strjoin (" ", _tmp5_, "%f", NULL);
#line 383 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (item.app_exec);
#line 383 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	item.app_exec = _tmp6_;
#line 384 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp7_ = g_strdup ("gitg");
#line 384 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp8_ = g_new0 (gchar*, 2 + 1);
#line 384 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp8_[0] = _tmp7_;
#line 384 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp8_[1] = NULL;
#line 384 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	item.groups = (_vala_array_free (item.groups, _vala_array_length (item.groups), (GDestroyNotify) g_free), NULL);
#line 384 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	item.groups = _tmp8_;
#line 386 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp9_ = uri;
#line 386 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp10_ = item;
#line 386 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_recent_manager_add_full (recent_manager, _tmp9_, &_tmp10_);
#line 376 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_recent_data_destroy (&item);
#line 376 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (recent_manager);
#line 1064 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_end_cloning (GitgRepositoryListBox* self, GitgRepositoryListBoxRow* row, GitgRepository* repository) {
	GitgRepository* _tmp0_ = NULL;
#line 389 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 389 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (row != NULL);
#line 391 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = repository;
#line 391 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp0_ != NULL) {
#line 1078 "gitg-repository-list-box.c"
		GFile* workdir = NULL;
		GitgRepository* _tmp1_ = NULL;
		GFile* _tmp2_ = NULL;
		GFile* repo_file = NULL;
		GitgRepository* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
		gchar* uri = NULL;
		gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		GitgRepositoryListBoxRow* _tmp13_ = NULL;
		GitgRepository* _tmp14_ = NULL;
		GitgRepositoryListBoxRow* _tmp15_ = NULL;
#line 393 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp1_ = repository;
#line 393 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = ggit_repository_get_workdir ((GgitRepository*) _tmp1_);
#line 393 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		workdir = _tmp2_;
#line 394 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = repository;
#line 394 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = ggit_repository_get_location ((GgitRepository*) _tmp3_);
#line 394 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		repo_file = _tmp4_;
#line 396 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = workdir;
#line 396 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		if (_tmp6_ != NULL) {
#line 1109 "gitg-repository-list-box.c"
			GFile* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
#line 396 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp7_ = workdir;
#line 396 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp8_ = g_file_get_uri (_tmp7_);
#line 396 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (_tmp5_);
#line 396 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp5_ = _tmp8_;
#line 1120 "gitg-repository-list-box.c"
		} else {
			GFile* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
#line 396 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp9_ = repo_file;
#line 396 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp10_ = g_file_get_uri (_tmp9_);
#line 396 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (_tmp5_);
#line 396 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp5_ = _tmp10_;
#line 1132 "gitg-repository-list-box.c"
		}
#line 396 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp11_ = g_strdup (_tmp5_);
#line 396 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		uri = _tmp11_;
#line 397 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp12_ = uri;
#line 397 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_add_repository_to_recent_manager (self, _tmp12_);
#line 399 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp13_ = row;
#line 399 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp14_ = repository;
#line 399 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_repository (_tmp13_, _tmp14_);
#line 400 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp15_ = row;
#line 400 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_loading (_tmp15_, FALSE);
#line 391 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (uri);
#line 391 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_tmp5_);
#line 391 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (repo_file);
#line 391 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (workdir);
#line 1160 "gitg-repository-list-box.c"
	} else {
		GitgRepositoryListBoxRow* _tmp16_ = NULL;
#line 404 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp16_ = row;
#line 404 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_container_remove ((GtkContainer*) self, (GtkWidget*) _tmp16_);
#line 1167 "gitg-repository-list-box.c"
	}
}


GitgRepositoryListBoxRow* gitg_repository_list_box_begin_cloning (GitgRepositoryListBox* self, GFile* location) {
	GitgRepositoryListBoxRow* result = NULL;
	GitgRepositoryListBoxRow* row = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GitgRepositoryListBoxRow* _tmp5_ = NULL;
	GitgRepositoryListBoxRow* _tmp6_ = NULL;
	GFile* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
#line 408 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 408 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (location != NULL, NULL);
#line 410 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = location;
#line 410 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = g_file_get_parent (_tmp0_);
#line 410 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = _tmp1_;
#line 410 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = gitg_utils_replace_home_dir_with_tilde (_tmp2_);
#line 410 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = _tmp3_;
#line 410 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = gitg_repository_list_box_row_new (NULL, _tmp4_);
#line 410 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_ref_sink (_tmp5_);
#line 410 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp6_ = _tmp5_;
#line 410 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (_tmp4_);
#line 410 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_tmp2_);
#line 410 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	row = _tmp6_;
#line 411 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp7_ = location;
#line 411 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp8_ = g_file_get_basename (_tmp7_);
#line 411 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp9_ = _tmp8_;
#line 411 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_set_repository_name (row, _tmp9_);
#line 411 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (_tmp9_);
#line 412 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp10_ = _ ("Cloning…");
#line 412 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_set_branch_name (row, _tmp10_);
#line 414 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_set_loading (row, TRUE);
#line 415 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_show ((GtkWidget*) row);
#line 417 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) row);
#line 418 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = row;
#line 418 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 1236 "gitg-repository-list-box.c"
}


static Block16Data* block16_data_ref (Block16Data* _data16_) {
#line 421 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_atomic_int_inc (&_data16_->_ref_count_);
#line 421 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return _data16_;
#line 1245 "gitg-repository-list-box.c"
}


static void block16_data_unref (void * _userdata_) {
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
#line 421 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
#line 1254 "gitg-repository-list-box.c"
		GitgRepositoryListBox* self;
#line 421 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		self = _data16_->self;
#line 421 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_data16_->f);
#line 421 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_data16_->row);
#line 421 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (self);
#line 421 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_slice_free (Block16Data, _data16_);
#line 1266 "gitg-repository-list-box.c"
	}
}


static void ____lambda67_ (GitgRepositoryListBox* self) {
#line 441 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject*) self, "has-selection");
#line 1274 "gitg-repository-list-box.c"
}


static void _____lambda67__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 440 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	____lambda67_ ((GitgRepositoryListBox*) self);
#line 1281 "gitg-repository-list-box.c"
}


static void ____lambda68_ (Block16Data* _data16_) {
	GitgRepositoryListBox* self;
	GitgRepositoryListBoxRow* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 444 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self = _data16_->self;
#line 1291 "gitg-repository-list-box.c"
	{
		GtkRecentManager* recent_manager = NULL;
		GtkRecentManager* _tmp0_ = NULL;
		GtkRecentManager* _tmp1_ = NULL;
		GFile* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
#line 447 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = gtk_recent_manager_get_default ();
#line 447 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 447 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		recent_manager = _tmp1_;
#line 448 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = _data16_->f;
#line 448 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = g_file_get_uri (_tmp2_);
#line 448 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = _tmp3_;
#line 448 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_recent_manager_remove_item (recent_manager, _tmp4_, &_inner_error_);
#line 448 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_tmp4_);
#line 448 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 448 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (recent_manager);
#line 1319 "gitg-repository-list-box.c"
			goto __catch53_g_error;
		}
#line 445 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (recent_manager);
#line 1324 "gitg-repository-list-box.c"
	}
	goto __finally53;
	__catch53_g_error:
	{
#line 445 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_clear_error (&_inner_error_);
#line 445 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_inner_error_ = NULL;
#line 1333 "gitg-repository-list-box.c"
	}
	__finally53:
#line 445 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 445 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 445 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_clear_error (&_inner_error_);
#line 445 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		return;
#line 1344 "gitg-repository-list-box.c"
	}
#line 451 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = _data16_->row;
#line 451 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_container_remove ((GtkContainer*) self, (GtkWidget*) _tmp5_);
#line 1350 "gitg-repository-list-box.c"
}


static void _____lambda68__gitg_repository_list_box_row_request_remove (GitgRepositoryListBoxRow* _sender, gpointer self) {
#line 444 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	____lambda68_ (self);
#line 1357 "gitg-repository-list-box.c"
}


GitgRepositoryListBoxRow* gitg_repository_list_box_add_repository (GitgRepositoryListBox* self, GitgRepository* repository) {
	GitgRepositoryListBoxRow* result = NULL;
	Block16Data* _data16_;
	GitgRepository* _tmp0_ = NULL;
	GitgRepositoryListBoxRow* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GitgRepository* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GFile* _tmp14_ = NULL;
	GitgRepositoryListBoxRow* _tmp15_ = NULL;
	GFile* _tmp47_ = NULL;
	GitgRepositoryListBoxRow* _tmp51_ = NULL;
	GitgRepositoryListBoxRow* _tmp52_ = NULL;
#line 421 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 421 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (repository != NULL, NULL);
#line 421 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data16_ = g_slice_new0 (Block16Data);
#line 421 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data16_->_ref_count_ = 1;
#line 421 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data16_->self = g_object_ref (self);
#line 423 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = repository;
#line 423 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = gitg_repository_list_box_get_row_for_repository (self, _tmp0_);
#line 423 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data16_->row = _tmp1_;
#line 425 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = repository;
#line 425 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_get ((GgitRepository*) _tmp3_, "workdir", &_tmp4_, NULL);
#line 425 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = _tmp4_;
#line 425 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp6_ = _tmp5_;
#line 425 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp7_ = _tmp6_ != NULL;
#line 425 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_tmp6_);
#line 425 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp7_) {
#line 1407 "gitg-repository-list-box.c"
		GitgRepository* _tmp8_ = NULL;
		GFile* _tmp9_ = NULL;
		GFile* _tmp10_ = NULL;
#line 425 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp8_ = repository;
#line 425 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_object_get ((GgitRepository*) _tmp8_, "workdir", &_tmp9_, NULL);
#line 425 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp10_ = _tmp9_;
#line 425 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp2_);
#line 425 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = _tmp10_;
#line 1421 "gitg-repository-list-box.c"
	} else {
		GitgRepository* _tmp11_ = NULL;
		GFile* _tmp12_ = NULL;
		GFile* _tmp13_ = NULL;
#line 425 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp11_ = repository;
#line 425 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp12_ = ggit_repository_get_location ((GgitRepository*) _tmp11_);
#line 425 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp13_ = _tmp12_;
#line 425 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp2_);
#line 425 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = _tmp13_;
#line 1436 "gitg-repository-list-box.c"
	}
#line 425 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp14_ = _g_object_ref0 (_tmp2_);
#line 425 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data16_->f = _tmp14_;
#line 427 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp15_ = _data16_->row;
#line 427 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp15_ == NULL) {
#line 1446 "gitg-repository-list-box.c"
		GFile* _tmp16_ = NULL;
		GitgRepository* _tmp17_ = NULL;
		GFile* _tmp18_ = NULL;
		GFile* _tmp19_ = NULL;
		GFile* _tmp20_ = NULL;
		gboolean _tmp21_ = FALSE;
		gchar* dirname = NULL;
		GFile* _tmp28_ = NULL;
		GFile* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		GitgRepository* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		GitgRepositoryListBoxRow* _tmp34_ = NULL;
		GitgRepositoryListBoxRow* _tmp35_ = NULL;
		GFile* _tmp36_ = NULL;
		GFile* _tmp38_ = NULL;
		GitgRepositoryListBoxRow* _tmp43_ = NULL;
#line 429 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp17_ = repository;
#line 429 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_object_get ((GgitRepository*) _tmp17_, "workdir", &_tmp18_, NULL);
#line 429 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp19_ = _tmp18_;
#line 429 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp20_ = _tmp19_;
#line 429 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp21_ = _tmp20_ != NULL;
#line 429 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp20_);
#line 429 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		if (_tmp21_) {
#line 1479 "gitg-repository-list-box.c"
			GitgRepository* _tmp22_ = NULL;
			GFile* _tmp23_ = NULL;
			GFile* _tmp24_ = NULL;
#line 429 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp22_ = repository;
#line 429 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			g_object_get ((GgitRepository*) _tmp22_, "workdir", &_tmp23_, NULL);
#line 429 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp24_ = _tmp23_;
#line 429 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (_tmp16_);
#line 429 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp16_ = _tmp24_;
#line 1493 "gitg-repository-list-box.c"
		} else {
			GitgRepository* _tmp25_ = NULL;
			GFile* _tmp26_ = NULL;
			GFile* _tmp27_ = NULL;
#line 429 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp25_ = repository;
#line 429 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp26_ = ggit_repository_get_location ((GgitRepository*) _tmp25_);
#line 429 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp27_ = _tmp26_;
#line 429 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (_tmp16_);
#line 429 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp16_ = _tmp27_;
#line 1508 "gitg-repository-list-box.c"
		}
#line 429 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp28_ = g_file_get_parent (_tmp16_);
#line 429 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp29_ = _tmp28_;
#line 429 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp30_ = gitg_utils_replace_home_dir_with_tilde (_tmp29_);
#line 429 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp31_ = _tmp30_;
#line 429 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp29_);
#line 429 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		dirname = _tmp31_;
#line 430 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp32_ = repository;
#line 430 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp33_ = dirname;
#line 430 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp34_ = gitg_repository_list_box_row_new (_tmp32_, _tmp33_);
#line 430 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_object_ref_sink (_tmp34_);
#line 430 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_data16_->row);
#line 430 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_data16_->row = _tmp34_;
#line 431 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp35_ = _data16_->row;
#line 431 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_widget_show ((GtkWidget*) _tmp35_);
#line 433 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp36_ = _data16_->f;
#line 433 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		if (_tmp36_ != NULL) {
#line 1542 "gitg-repository-list-box.c"
			GitgRepositoryListBoxRow* _tmp37_ = NULL;
#line 435 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp37_ = _data16_->row;
#line 435 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			g_object_bind_property_with_closures ((GObject*) self, "mode", (GObject*) _tmp37_, "mode", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 1548 "gitg-repository-list-box.c"
		}
#line 438 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp38_ = _data16_->f;
#line 438 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		if (_tmp38_ != NULL) {
#line 1554 "gitg-repository-list-box.c"
			GitgRepositoryListBoxRow* _tmp39_ = NULL;
			GitgRepositoryListBoxRow* _tmp40_ = NULL;
			GitgRepositoryListBoxRow* _tmp41_ = NULL;
#line 440 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp39_ = _data16_->row;
#line 440 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			g_signal_connect_object ((GObject*) _tmp39_, "notify::selected", (GCallback) _____lambda67__g_object_notify, self, 0);
#line 444 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp40_ = _data16_->row;
#line 444 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			g_signal_connect_data (_tmp40_, "request-remove", (GCallback) _____lambda68__gitg_repository_list_box_row_request_remove, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
#line 454 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp41_ = _data16_->row;
#line 454 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			gitg_repository_list_box_row_set_can_remove (_tmp41_, TRUE);
#line 1570 "gitg-repository-list-box.c"
		} else {
			GitgRepositoryListBoxRow* _tmp42_ = NULL;
#line 458 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp42_ = _data16_->row;
#line 458 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			gitg_repository_list_box_row_set_can_remove (_tmp42_, FALSE);
#line 1577 "gitg-repository-list-box.c"
		}
#line 461 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp43_ = _data16_->row;
#line 461 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp43_);
#line 427 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (dirname);
#line 427 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp16_);
#line 1587 "gitg-repository-list-box.c"
	} else {
		GitgRepositoryListBoxRow* _tmp44_ = NULL;
		GDateTime* _tmp45_ = NULL;
		GDateTime* _tmp46_ = NULL;
#line 466 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp44_ = _data16_->row;
#line 466 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp45_ = g_date_time_new_now_local ();
#line 466 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp46_ = _tmp45_;
#line 466 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_time (_tmp44_, _tmp46_);
#line 466 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_date_time_unref0 (_tmp46_);
#line 467 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_list_box_invalidate_sort ((GtkListBox*) self);
#line 1604 "gitg-repository-list-box.c"
	}
#line 470 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp47_ = _data16_->f;
#line 470 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp47_ != NULL) {
#line 1610 "gitg-repository-list-box.c"
		GFile* _tmp48_ = NULL;
		gchar* _tmp49_ = NULL;
		gchar* _tmp50_ = NULL;
#line 472 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp48_ = _data16_->f;
#line 472 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp49_ = g_file_get_uri (_tmp48_);
#line 472 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp50_ = _tmp49_;
#line 472 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_add_repository_to_recent_manager (self, _tmp50_);
#line 472 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_tmp50_);
#line 1624 "gitg-repository-list-box.c"
	}
#line 475 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp51_ = _data16_->row;
#line 475 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp52_ = _g_object_ref0 (_tmp51_);
#line 475 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp52_;
#line 475 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_tmp2_);
#line 475 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	block16_data_unref (_data16_);
#line 475 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data16_ = NULL;
#line 475 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 1640 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_filter_text (GitgRepositoryListBox* self, const gchar* text) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 516 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 518 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = text;
#line 518 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 518 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (self->priv->d_filter_text);
#line 518 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_filter_text = _tmp1_;
#line 520 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_invalidate_filter ((GtkListBox*) self);
#line 1659 "gitg-repository-list-box.c"
}


GitgRepositoryListBox* gitg_repository_list_box_construct (GType object_type) {
	GitgRepositoryListBox * self = NULL;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self = (GitgRepositoryListBox*) g_object_new (object_type, NULL);
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return self;
#line 1669 "gitg-repository-list-box.c"
}


GitgRepositoryListBox* gitg_repository_list_box_new (void) {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return gitg_repository_list_box_construct (GITG_TYPE_REPOSITORY_LIST_BOX);
#line 1676 "gitg-repository-list-box.c"
}


GitgSelectionMode gitg_repository_list_box_get_mode (GitgRepositoryListBox* self) {
	GitgSelectionMode result;
	GitgSelectionMode _tmp0_ = 0;
#line 257 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 257 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->_mode;
#line 257 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 257 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 1691 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_set_mode (GitgRepositoryListBox* self, GitgSelectionMode value) {
	GitgSelectionMode _tmp0_ = 0;
#line 257 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 257 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 257 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->_mode = _tmp0_;
#line 257 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "mode");
#line 1705 "gitg-repository-list-box.c"
}


static void _vala_array_add16 (GitgRepositoryListBoxRow*** array, int* length, int* size, GitgRepositoryListBoxRow* value) {
#line 490 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if ((*length) == (*size)) {
#line 490 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 490 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		*array = g_renew (GitgRepositoryListBoxRow*, *array, (*size) + 1);
#line 1716 "gitg-repository-list-box.c"
	}
#line 490 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	(*array)[(*length)++] = value;
#line 490 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	(*array)[*length] = NULL;
#line 1722 "gitg-repository-list-box.c"
}


GitgRepositoryListBoxRow** gitg_repository_list_box_get_selection (GitgRepositoryListBox* self, int* result_length1) {
	GitgRepositoryListBoxRow** result;
	GitgRepositoryListBoxRow** ret = NULL;
	GitgRepositoryListBoxRow** _tmp0_ = NULL;
	gint ret_length1 = 0;
	gint _ret_size_ = 0;
	GList* _tmp1_ = NULL;
	GitgRepositoryListBoxRow** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
#line 480 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 482 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = g_new0 (GitgRepositoryListBoxRow*, 0 + 1);
#line 482 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	ret = _tmp0_;
#line 482 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	ret_length1 = 0;
#line 482 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_ret_size_ = ret_length1;
#line 484 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = gtk_container_get_children ((GtkContainer*) self);
#line 1747 "gitg-repository-list-box.c"
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
#line 484 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		row_collection = _tmp1_;
#line 484 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
#line 1755 "gitg-repository-list-box.c"
			GtkWidget* row = NULL;
#line 484 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			row = (GtkWidget*) row_it->data;
#line 1759 "gitg-repository-list-box.c"
			{
				GitgRepositoryListBoxRow* r = NULL;
				GtkWidget* _tmp2_ = NULL;
				GitgRepositoryListBoxRow* _tmp3_ = NULL;
				GitgRepositoryListBoxRow* _tmp4_ = NULL;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
#line 486 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp2_ = row;
#line 486 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 486 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				r = _tmp3_;
#line 488 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp4_ = r;
#line 488 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp5_ = gitg_repository_list_box_row_get_selected (_tmp4_);
#line 488 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp6_ = _tmp5_;
#line 488 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				if (_tmp6_) {
#line 1781 "gitg-repository-list-box.c"
					GitgRepositoryListBoxRow** _tmp7_ = NULL;
					gint _tmp7__length1 = 0;
					GitgRepositoryListBoxRow* _tmp8_ = NULL;
					GitgRepositoryListBoxRow* _tmp9_ = NULL;
#line 490 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp7_ = ret;
#line 490 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp7__length1 = ret_length1;
#line 490 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp8_ = r;
#line 490 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp9_ = _g_object_ref0 (_tmp8_);
#line 490 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_vala_array_add16 (&ret, &ret_length1, &_ret_size_, _tmp9_);
#line 1796 "gitg-repository-list-box.c"
				}
#line 484 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (r);
#line 1800 "gitg-repository-list-box.c"
			}
		}
#line 484 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_list_free0 (row_collection);
#line 1805 "gitg-repository-list-box.c"
	}
#line 494 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp10_ = ret;
#line 494 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp10__length1 = ret_length1;
#line 494 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (result_length1) {
#line 494 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		*result_length1 = _tmp10__length1;
#line 1815 "gitg-repository-list-box.c"
	}
#line 494 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp10_;
#line 494 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 1821 "gitg-repository-list-box.c"
}


gboolean gitg_repository_list_box_get_has_selection (GitgRepositoryListBox* self) {
	gboolean result;
	GList* _tmp0_ = NULL;
#line 500 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 502 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
#line 1832 "gitg-repository-list-box.c"
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
#line 502 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		row_collection = _tmp0_;
#line 502 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
#line 1840 "gitg-repository-list-box.c"
			GtkWidget* row = NULL;
#line 502 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			row = (GtkWidget*) row_it->data;
#line 1844 "gitg-repository-list-box.c"
			{
				GitgRepositoryListBoxRow* r = NULL;
				GtkWidget* _tmp1_ = NULL;
				GitgRepositoryListBoxRow* _tmp2_ = NULL;
				GitgRepositoryListBoxRow* _tmp3_ = NULL;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
#line 504 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp1_ = row;
#line 504 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 504 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				r = _tmp2_;
#line 506 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp3_ = r;
#line 506 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp4_ = gitg_repository_list_box_row_get_selected (_tmp3_);
#line 506 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp5_ = _tmp4_;
#line 506 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				if (_tmp5_) {
#line 508 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					result = TRUE;
#line 508 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (r);
#line 508 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_g_list_free0 (row_collection);
#line 508 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					return result;
#line 1874 "gitg-repository-list-box.c"
				}
#line 502 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (r);
#line 1878 "gitg-repository-list-box.c"
			}
		}
#line 502 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_list_free0 (row_collection);
#line 1883 "gitg-repository-list-box.c"
	}
#line 512 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = FALSE;
#line 512 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 1889 "gitg-repository-list-box.c"
}


static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (n_param_values == 3);
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		data1 = closure->data;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		data2 = param_values->data[0].v_pointer;
#line 1908 "gitg-repository-list-box.c"
	} else {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		data1 = param_values->data[0].v_pointer;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		data2 = closure->data;
#line 1914 "gitg-repository-list-box.c"
	}
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	callback = (GMarshalFunc_VOID__STRING_STRING) (marshal_data ? marshal_data : cc->callback);
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), data2);
#line 1920 "gitg-repository-list-box.c"
}


static void _gitg_repository_list_box_update_header_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self) {
#line 298 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_update_header ((GitgRepositoryListBox*) self, row, before);
#line 1927 "gitg-repository-list-box.c"
}


static gboolean _gitg_repository_list_box_filter_gtk_list_box_filter_func (GtkListBoxRow* row, gpointer self) {
	gboolean result;
	result = gitg_repository_list_box_filter ((GitgRepositoryListBox*) self, row);
#line 299 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 1936 "gitg-repository-list-box.c"
}


static gint _gitg_repository_list_box_compare_widgets_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self) {
	gint result;
	result = gitg_repository_list_box_compare_widgets ((GitgRepositoryListBox*) self, row1, row2);
#line 300 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 1945 "gitg-repository-list-box.c"
}


static GObject * gitg_repository_list_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GitgRepositoryListBox * self;
#line 296 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	parent_class = G_OBJECT_CLASS (gitg_repository_list_box_parent_class);
#line 296 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 296 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBox);
#line 298 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_set_header_func ((GtkListBox*) self, _gitg_repository_list_box_update_header_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
#line 299 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_set_filter_func ((GtkListBox*) self, _gitg_repository_list_box_filter_gtk_list_box_filter_func, g_object_ref (self), g_object_unref);
#line 300 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_set_sort_func ((GtkListBox*) self, _gitg_repository_list_box_compare_widgets_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
#line 301 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_show ((GtkWidget*) self);
#line 303 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_set_selection_mode ((GtkListBox*) self, GTK_SELECTION_NONE);
#line 296 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return obj;
#line 1971 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_row_update_branch_label (GitgRepositoryListBoxRow* self) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
#line 149 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 151 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = self->priv->d_branch_name;
#line 151 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp1_ == NULL) {
#line 151 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = TRUE;
#line 1986 "gitg-repository-list-box.c"
	} else {
		const gchar* _tmp2_ = NULL;
#line 151 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = self->priv->d_branch_name;
#line 151 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = g_strcmp0 (_tmp2_, "") == 0;
#line 1993 "gitg-repository-list-box.c"
	}
#line 151 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp0_) {
#line 1997 "gitg-repository-list-box.c"
		GtkLabel* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 154 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = self->priv->d_branch_label;
#line 154 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = _ ("at %s");
#line 154 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = self->priv->d_dirname;
#line 154 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = g_strdup_printf (_tmp4_, _tmp5_);
#line 154 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp7_ = _tmp6_;
#line 154 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_label_set_label (_tmp3_, _tmp7_);
#line 154 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_tmp7_);
#line 2017 "gitg-repository-list-box.c"
	} else {
		gboolean _tmp8_ = FALSE;
		const gchar* _tmp9_ = NULL;
#line 156 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp9_ = self->priv->d_dirname;
#line 156 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		if (_tmp9_ == NULL) {
#line 156 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp8_ = TRUE;
#line 2027 "gitg-repository-list-box.c"
		} else {
			const gchar* _tmp10_ = NULL;
#line 156 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp10_ = self->priv->d_dirname;
#line 156 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp8_ = g_strcmp0 (_tmp10_, "") == 0;
#line 2034 "gitg-repository-list-box.c"
		}
#line 156 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		if (_tmp8_) {
#line 2038 "gitg-repository-list-box.c"
			GtkLabel* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
#line 158 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp11_ = self->priv->d_branch_label;
#line 158 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp12_ = self->priv->d_branch_name;
#line 158 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			gtk_label_set_label (_tmp11_, _tmp12_);
#line 2047 "gitg-repository-list-box.c"
		} else {
			GtkLabel* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp13_ = self->priv->d_branch_label;
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp14_ = _ ("%s at %s");
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp15_ = self->priv->d_branch_name;
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp16_ = self->priv->d_dirname;
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp17_ = g_strdup_printf (_tmp14_, _tmp15_, _tmp16_);
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp18_ = _tmp17_;
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			gtk_label_set_label (_tmp13_, _tmp18_);
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (_tmp18_);
#line 2071 "gitg-repository-list-box.c"
		}
	}
}


static Block17Data* block17_data_ref (Block17Data* _data17_) {
#line 174 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_atomic_int_inc (&_data17_->_ref_count_);
#line 174 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return _data17_;
#line 2082 "gitg-repository-list-box.c"
}


static void _vala_GgitOId_free (GgitOId* self) {
#line 174 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_boxed_free (ggit_oid_get_type (), self);
#line 2089 "gitg-repository-list-box.c"
}


static void block17_data_unref (void * _userdata_) {
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
#line 174 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
#line 2098 "gitg-repository-list-box.c"
		GitgRepositoryListBoxRow* self;
#line 174 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		self = _data17_->self;
#line 174 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		__vala_GgitOId_free0 (_data17_->entry_id);
#line 174 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (self);
#line 174 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_slice_free (Block17Data, _data17_);
#line 2108 "gitg-repository-list-box.c"
	}
}


static gint ____lambda66_ (Block17Data* _data17_, const gchar* root, GgitTreeEntry* entry) {
	GitgRepositoryListBoxRow* self;
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
#line 183 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self = _data17_->self;
#line 183 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (root != NULL, 0);
#line 183 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (entry != NULL, 0);
#line 184 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = root;
#line 184 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (g_strcmp0 (_tmp2_, "") == 0) {
#line 2129 "gitg-repository-list-box.c"
		GgitTreeEntry* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 184 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = entry;
#line 184 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = ggit_tree_entry_get_name (_tmp3_);
#line 184 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp1_ = _tmp4_ != NULL;
#line 2138 "gitg-repository-list-box.c"
	} else {
#line 184 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp1_ = FALSE;
#line 2142 "gitg-repository-list-box.c"
	}
#line 184 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp1_) {
#line 2146 "gitg-repository-list-box.c"
		GgitTreeEntry* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
#line 184 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = entry;
#line 184 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = ggit_tree_entry_get_name (_tmp5_);
#line 184 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp7_ = g_str_has_suffix (_tmp6_, ".doap");
#line 184 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = _tmp7_;
#line 2158 "gitg-repository-list-box.c"
	} else {
#line 184 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = FALSE;
#line 2162 "gitg-repository-list-box.c"
	}
#line 184 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp0_) {
#line 2166 "gitg-repository-list-box.c"
		GgitTreeEntry* _tmp8_ = NULL;
		GgitOId* _tmp9_ = NULL;
#line 186 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp8_ = entry;
#line 186 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp9_ = ggit_tree_entry_get_id (_tmp8_);
#line 186 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		__vala_GgitOId_free0 (_data17_->entry_id);
#line 186 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_data17_->entry_id = _tmp9_;
#line 187 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		result = 1;
#line 187 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		return result;
#line 2181 "gitg-repository-list-box.c"
	}
#line 189 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = 0;
#line 189 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2187 "gitg-repository-list-box.c"
}


static gint _____lambda66__ggit_tree_walk_callback (const gchar* root, GgitTreeEntry* entry, gpointer self) {
	gint result;
	result = ____lambda66_ (self, root, entry);
#line 183 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2196 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_row_update_repository_data (GitgRepositoryListBoxRow* self) {
	gchar* head_name = NULL;
	gchar* _tmp0_ = NULL;
	gchar* head_description = NULL;
	gchar* _tmp1_ = NULL;
	GitgRepository* _tmp2_ = NULL;
	gchar* _tmp52_ = NULL;
	GitgRepository* _tmp53_ = NULL;
	GtkLabel* _tmp58_ = NULL;
	const gchar* _tmp59_ = NULL;
	GtkLabel* _tmp60_ = NULL;
	const gchar* _tmp61_ = NULL;
	const gchar* _tmp62_ = NULL;
	GError * _inner_error_ = NULL;
#line 167 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 169 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = g_strdup ("");
#line 169 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	head_name = _tmp0_;
#line 170 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = g_strdup ("");
#line 170 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	head_description = _tmp1_;
#line 172 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = self->priv->d_repository;
#line 172 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp2_ != NULL) {
#line 2228 "gitg-repository-list-box.c"
		{
			Block17Data* _data17_;
			GitgRef* head = NULL;
			GitgRepository* _tmp3_ = NULL;
			GitgRef* _tmp4_ = NULL;
			GitgRef* _tmp5_ = NULL;
			GitgParsedRefName* _tmp6_ = NULL;
			GitgParsedRefName* _tmp7_ = NULL;
			GitgParsedRefName* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			GgitObject* _tmp11_ = NULL;
			GitgRef* _tmp12_ = NULL;
			GgitObject* _tmp13_ = NULL;
			GgitCommit* commit = NULL;
			GgitObject* _tmp14_ = NULL;
			GgitTree* tree = NULL;
			GgitCommit* _tmp15_ = NULL;
			GgitTree* _tmp16_ = NULL;
			GgitTree* _tmp17_ = NULL;
			GgitOId* _tmp18_ = NULL;
#line 174 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_data17_ = g_slice_new0 (Block17Data);
#line 174 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_data17_->_ref_count_ = 1;
#line 174 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_data17_->self = g_object_ref (self);
#line 176 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp3_ = self->priv->d_repository;
#line 176 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp4_ = gitg_repository_get_head (_tmp3_, &_inner_error_);
#line 176 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			head = _tmp4_;
#line 176 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 176 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				block17_data_unref (_data17_);
#line 176 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_data17_ = NULL;
#line 2268 "gitg-repository-list-box.c"
				goto __catch54_g_error;
			}
#line 177 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp5_ = head;
#line 177 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp6_ = gitg_ref_get_parsed_name (_tmp5_);
#line 177 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp7_ = _tmp6_;
#line 177 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp8_ = _tmp7_;
#line 177 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp9_ = gitg_parsed_ref_name_get_shortname (_tmp8_);
#line 177 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp10_ = _tmp9_;
#line 177 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (head_name);
#line 177 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			head_name = _tmp10_;
#line 177 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (_tmp8_);
#line 179 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp12_ = head;
#line 179 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp13_ = ggit_ref_lookup ((GgitRef*) _tmp12_, &_inner_error_);
#line 179 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp11_ = _tmp13_;
#line 179 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 179 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (head);
#line 179 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				block17_data_unref (_data17_);
#line 179 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_data17_ = NULL;
#line 2303 "gitg-repository-list-box.c"
				goto __catch54_g_error;
			}
#line 179 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp14_ = _tmp11_;
#line 179 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp11_ = NULL;
#line 179 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			commit = G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, ggit_commit_get_type (), GgitCommit);
#line 180 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp15_ = commit;
#line 180 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp16_ = ggit_commit_get_tree (_tmp15_);
#line 180 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			tree = _tmp16_;
#line 182 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_data17_->entry_id = NULL;
#line 183 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp17_ = tree;
#line 183 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			ggit_tree_walk (_tmp17_, GGIT_TREE_WALK_MODE_PRE, _____lambda66__ggit_tree_walk_callback, _data17_, &_inner_error_);
#line 183 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 183 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (tree);
#line 183 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (commit);
#line 183 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (_tmp11_);
#line 183 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (head);
#line 183 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				block17_data_unref (_data17_);
#line 183 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_data17_ = NULL;
#line 2338 "gitg-repository-list-box.c"
				goto __catch54_g_error;
			}
#line 192 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp18_ = _data17_->entry_id;
#line 192 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			if (_tmp18_ != NULL) {
#line 2345 "gitg-repository-list-box.c"
				GgitBlob* blob = NULL;
				GitgRepository* _tmp19_ = NULL;
				GgitOId* _tmp20_ = NULL;
				gpointer _tmp21_ = NULL;
				guint8* content = NULL;
				GgitBlob* _tmp22_ = NULL;
				gsize _tmp23_;
				guint8* _tmp24_ = NULL;
				gint content_length1 = 0;
				gint _content_size_ = 0;
				IdeDoap* doap = NULL;
				IdeDoap* _tmp25_ = NULL;
				IdeDoap* _tmp26_ = NULL;
				guint8* _tmp27_ = NULL;
				gint _tmp27__length1 = 0;
				IdeDoap* _tmp28_ = NULL;
				const gchar* _tmp29_ = NULL;
				gchar* _tmp30_ = NULL;
				IdeDoap* _tmp31_ = NULL;
				gchar** _tmp32_ = NULL;
				gchar** _tmp33_ = NULL;
#line 194 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp19_ = self->priv->d_repository;
#line 194 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp20_ = _data17_->entry_id;
#line 194 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp21_ = gitg_repository_lookup (_tmp19_, ggit_blob_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp20_, &_inner_error_);
#line 194 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				blob = (GgitBlob*) _tmp21_;
#line 194 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 194 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (tree);
#line 194 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (commit);
#line 194 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (_tmp11_);
#line 194 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (head);
#line 194 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					block17_data_unref (_data17_);
#line 194 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_data17_ = NULL;
#line 2389 "gitg-repository-list-box.c"
					goto __catch54_g_error;
				}
#line 196 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp22_ = blob;
#line 196 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp24_ = ggit_blob_get_raw_content (_tmp22_, &_tmp23_);
#line 196 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				content = _tmp24_;
#line 196 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				content_length1 = _tmp23_;
#line 196 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_content_size_ = content_length1;
#line 197 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp25_ = ide_doap_new ();
#line 197 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				doap = _tmp25_;
#line 198 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp26_ = doap;
#line 198 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp27_ = content;
#line 198 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp27__length1 = content_length1;
#line 198 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				ide_doap_load_from_data (_tmp26_, (const gchar*) _tmp27_, (gsize) -1, &_inner_error_);
#line 198 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 198 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (doap);
#line 198 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (blob);
#line 198 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (tree);
#line 198 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (commit);
#line 198 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (_tmp11_);
#line 198 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (head);
#line 198 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					block17_data_unref (_data17_);
#line 198 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_data17_ = NULL;
#line 2432 "gitg-repository-list-box.c"
					goto __catch54_g_error;
				}
#line 200 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp28_ = doap;
#line 200 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp29_ = ide_doap_get_shortdesc (_tmp28_);
#line 200 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp30_ = g_strdup (_tmp29_);
#line 200 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_g_free0 (head_description);
#line 200 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				head_description = _tmp30_;
#line 202 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp31_ = doap;
#line 202 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp33_ = _tmp32_ = ide_doap_get_languages (_tmp31_);
#line 2449 "gitg-repository-list-box.c"
				{
					gchar** lang_collection = NULL;
					gint lang_collection_length1 = 0;
					gint _lang_collection_size_ = 0;
					gint lang_it = 0;
#line 202 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					lang_collection = _tmp33_;
#line 202 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					lang_collection_length1 = _vala_array_length (_tmp32_);
#line 202 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					for (lang_it = 0; lang_it < _vala_array_length (_tmp32_); lang_it = lang_it + 1) {
#line 2461 "gitg-repository-list-box.c"
						gchar* _tmp34_ = NULL;
						gchar* lang = NULL;
#line 202 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp34_ = g_strdup (lang_collection[lang_it]);
#line 202 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						lang = _tmp34_;
#line 2468 "gitg-repository-list-box.c"
						{
							GtkFrame* frame = NULL;
							GtkFrame* _tmp35_ = NULL;
							GtkFrame* _tmp36_ = NULL;
							GtkFrame* _tmp37_ = NULL;
							GtkStyleContext* _tmp38_ = NULL;
							GtkFrame* _tmp39_ = NULL;
							GtkLabel* label = NULL;
							const gchar* _tmp40_ = NULL;
							GtkLabel* _tmp41_ = NULL;
							PangoAttrList* attr_list = NULL;
							PangoAttrList* _tmp42_ = NULL;
							PangoAttrList* _tmp43_ = NULL;
							PangoAttribute* _tmp44_ = NULL;
							GtkLabel* _tmp45_ = NULL;
							PangoAttrList* _tmp46_ = NULL;
							GtkLabel* _tmp47_ = NULL;
							GtkFrame* _tmp48_ = NULL;
							GtkLabel* _tmp49_ = NULL;
							GtkBox* _tmp50_ = NULL;
							GtkFrame* _tmp51_ = NULL;
#line 204 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp35_ = (GtkFrame*) gtk_frame_new (NULL);
#line 204 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							g_object_ref_sink (_tmp35_);
#line 204 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							frame = _tmp35_;
#line 205 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp36_ = frame;
#line 205 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							gtk_frame_set_shadow_type (_tmp36_, GTK_SHADOW_NONE);
#line 206 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp37_ = frame;
#line 206 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp38_ = gtk_widget_get_style_context ((GtkWidget*) _tmp37_);
#line 206 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							gtk_style_context_add_class (_tmp38_, "language-frame");
#line 207 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp39_ = frame;
#line 207 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							gtk_widget_show ((GtkWidget*) _tmp39_);
#line 209 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp40_ = lang;
#line 209 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp41_ = (GtkLabel*) gtk_label_new (_tmp40_);
#line 209 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							g_object_ref_sink (_tmp41_);
#line 209 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							label = _tmp41_;
#line 210 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp42_ = pango_attr_list_new ();
#line 210 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							attr_list = _tmp42_;
#line 211 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp43_ = attr_list;
#line 211 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp44_ = pango_attr_scale_new (PANGO_SCALE_SMALL);
#line 211 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							pango_attr_list_insert (_tmp43_, _tmp44_);
#line 212 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp45_ = label;
#line 212 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp46_ = attr_list;
#line 212 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							gtk_label_set_attributes (_tmp45_, _tmp46_);
#line 213 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp47_ = label;
#line 213 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							gtk_widget_show ((GtkWidget*) _tmp47_);
#line 215 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp48_ = frame;
#line 215 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp49_ = label;
#line 215 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							gtk_container_add ((GtkContainer*) _tmp48_, (GtkWidget*) _tmp49_);
#line 216 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp50_ = self->priv->d_languages_box;
#line 216 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp51_ = frame;
#line 216 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							gtk_container_add ((GtkContainer*) _tmp50_, (GtkWidget*) _tmp51_);
#line 202 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_pango_attr_list_unref0 (attr_list);
#line 202 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_g_object_unref0 (label);
#line 202 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_g_object_unref0 (frame);
#line 202 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_g_free0 (lang);
#line 2558 "gitg-repository-list-box.c"
						}
					}
				}
#line 192 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (doap);
#line 192 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (blob);
#line 2566 "gitg-repository-list-box.c"
			}
#line 174 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (tree);
#line 174 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (commit);
#line 174 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (_tmp11_);
#line 174 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (head);
#line 174 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			block17_data_unref (_data17_);
#line 174 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_data17_ = NULL;
#line 2580 "gitg-repository-list-box.c"
		}
		goto __finally54;
		__catch54_g_error:
		{
#line 174 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			g_clear_error (&_inner_error_);
#line 174 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_inner_error_ = NULL;
#line 2589 "gitg-repository-list-box.c"
		}
		__finally54:
#line 174 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 174 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (head_description);
#line 174 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (head_name);
#line 174 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 174 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			g_clear_error (&_inner_error_);
#line 174 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			return;
#line 2604 "gitg-repository-list-box.c"
		}
	}
#line 222 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp53_ = self->priv->d_repository;
#line 222 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp53_ != NULL) {
#line 2611 "gitg-repository-list-box.c"
		GitgRepository* _tmp54_ = NULL;
		gchar* _tmp55_ = NULL;
		gchar* _tmp56_ = NULL;
#line 222 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp54_ = self->priv->d_repository;
#line 222 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp55_ = gitg_repository_get_name (_tmp54_);
#line 222 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp56_ = _tmp55_;
#line 222 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_tmp52_);
#line 222 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp52_ = _tmp56_;
#line 2625 "gitg-repository-list-box.c"
	} else {
		gchar* _tmp57_ = NULL;
#line 222 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp57_ = g_strdup ("");
#line 222 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_tmp52_);
#line 222 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp52_ = _tmp57_;
#line 2634 "gitg-repository-list-box.c"
	}
#line 222 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_set_repository_name (self, _tmp52_);
#line 224 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp58_ = self->priv->d_description_label;
#line 224 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp59_ = head_description;
#line 224 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_label_set_label (_tmp58_, _tmp59_);
#line 225 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp60_ = self->priv->d_description_label;
#line 225 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp61_ = head_description;
#line 225 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp60_, g_strcmp0 (_tmp61_, "") != 0);
#line 227 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp62_ = head_name;
#line 227 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_set_branch_name (self, _tmp62_);
#line 167 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (_tmp52_);
#line 167 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (head_description);
#line 167 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (head_name);
#line 2660 "gitg-repository-list-box.c"
}


GitgRepositoryListBoxRow* gitg_repository_list_box_row_construct (GType object_type, GitgRepository* repository, const gchar* dirname) {
	GitgRepositoryListBoxRow * self = NULL;
	GitgRepository* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 251 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (dirname != NULL, NULL);
#line 253 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = repository;
#line 253 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = dirname;
#line 253 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self = (GitgRepositoryListBoxRow*) g_object_new (object_type, "repository", _tmp0_, "dirname", _tmp1_, NULL);
#line 251 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return self;
#line 2678 "gitg-repository-list-box.c"
}


GitgRepositoryListBoxRow* gitg_repository_list_box_row_new (GitgRepository* repository, const gchar* dirname) {
#line 251 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return gitg_repository_list_box_row_construct (GITG_REPOSITORY_LIST_BOX_TYPE_ROW, repository, dirname);
#line 2685 "gitg-repository-list-box.c"
}


GitgSelectionMode gitg_repository_list_box_row_get_mode (GitgRepositoryListBoxRow* self) {
	GitgSelectionMode result;
	GitgSelectionMode _tmp0_ = 0;
#line 66 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 66 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_mode;
#line 66 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 66 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2700 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_mode (GitgRepositoryListBoxRow* self, GitgSelectionMode value) {
	GitgSelectionMode _tmp0_ = 0;
	GitgSelectionMode _tmp1_ = 0;
#line 68 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 70 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_mode;
#line 70 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = value;
#line 70 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp0_ != _tmp1_) {
#line 2715 "gitg-repository-list-box.c"
		GitgSelectionMode _tmp2_ = 0;
		GtkRevealer* _tmp3_ = NULL;
		GitgSelectionMode _tmp4_ = 0;
		GtkCheckButton* _tmp5_ = NULL;
#line 72 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = value;
#line 72 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		self->priv->d_mode = _tmp2_;
#line 74 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = self->priv->d_remove_revealer;
#line 74 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = self->priv->d_mode;
#line 74 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_revealer_set_reveal_child (_tmp3_, _tmp4_ == GITG_SELECTION_MODE_SELECTION);
#line 76 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = self->priv->d_remove_check_button;
#line 76 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp5_, FALSE);
#line 2734 "gitg-repository-list-box.c"
	}
#line 68 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "mode");
#line 2738 "gitg-repository-list-box.c"
}


gboolean gitg_repository_list_box_row_get_selected (GitgRepositoryListBoxRow* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 83 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 83 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->_selected;
#line 83 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 83 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2753 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_selected (GitgRepositoryListBoxRow* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 83 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 83 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 83 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->_selected = _tmp0_;
#line 83 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "selected");
#line 2767 "gitg-repository-list-box.c"
}


GitgRepository* gitg_repository_list_box_row_get_repository (GitgRepositoryListBoxRow* self) {
	GitgRepository* result;
	GitgRepository* _tmp0_ = NULL;
#line 97 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 97 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_repository;
#line 97 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 97 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2782 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_repository (GitgRepositoryListBoxRow* self, GitgRepository* value) {
	GitgRepository* _tmp0_ = NULL;
	GitgRepository* _tmp1_ = NULL;
#line 98 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 100 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 100 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 100 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_repository);
#line 100 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_repository = _tmp1_;
#line 101 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_update_repository_data (self);
#line 98 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "repository");
#line 2803 "gitg-repository-list-box.c"
}


gboolean gitg_repository_list_box_row_get_can_remove (GitgRepositoryListBoxRow* self) {
	gboolean result;
	GtkCheckButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 107 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 107 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_remove_check_button;
#line 107 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp0_);
#line 107 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = _tmp1_;
#line 107 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp2_;
#line 107 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2824 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_can_remove (GitgRepositoryListBoxRow* self, gboolean value) {
	GtkCheckButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 108 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 108 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_remove_check_button;
#line 108 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = value;
#line 108 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp1_);
#line 108 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "can-remove");
#line 2841 "gitg-repository-list-box.c"
}


GDateTime* gitg_repository_list_box_row_get_time (GitgRepositoryListBoxRow* self) {
	GDateTime* result;
	GDateTime* _tmp0_ = NULL;
#line 113 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 113 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_time;
#line 113 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 113 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2856 "gitg-repository-list-box.c"
}


static gpointer _g_date_time_ref0 (gpointer self) {
#line 114 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return self ? g_date_time_ref (self) : NULL;
#line 2863 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_time (GitgRepositoryListBoxRow* self, GDateTime* value) {
	GDateTime* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
#line 114 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 114 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 114 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _g_date_time_ref0 (_tmp0_);
#line 114 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_date_time_unref0 (self->priv->d_time);
#line 114 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_time = _tmp1_;
#line 114 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "time");
#line 2882 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_fraction (GitgRepositoryListBoxRow* self, gdouble value) {
	GitgProgressBin* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
#line 120 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 120 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_progress_bin;
#line 120 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = value;
#line 120 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_progress_bin_set_fraction (_tmp0_, _tmp1_);
#line 120 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "fraction");
#line 2899 "gitg-repository-list-box.c"
}


const gchar* gitg_repository_list_box_row_get_repository_name (GitgRepositoryListBoxRow* self) {
	const gchar* result;
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 125 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 125 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_repository_label;
#line 125 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = gtk_label_get_text (_tmp0_);
#line 125 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp1_;
#line 125 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2917 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_repository_name (GitgRepositoryListBoxRow* self, const gchar* value) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 126 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 126 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_repository_label;
#line 126 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = value;
#line 126 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_label_set_label (_tmp0_, _tmp1_);
#line 126 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "repository-name");
#line 2934 "gitg-repository-list-box.c"
}


const gchar* gitg_repository_list_box_row_get_dirname (GitgRepositoryListBoxRow* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 131 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 131 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_dirname;
#line 131 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 131 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2949 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_dirname (GitgRepositoryListBoxRow* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 132 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 134 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 134 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 134 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (self->priv->d_dirname);
#line 134 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_dirname = _tmp1_;
#line 135 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_update_branch_label (self);
#line 132 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "dirname");
#line 2970 "gitg-repository-list-box.c"
}


const gchar* gitg_repository_list_box_row_get_branch_name (GitgRepositoryListBoxRow* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 141 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 141 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_branch_name;
#line 141 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 141 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2985 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_branch_name (GitgRepositoryListBoxRow* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 142 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 144 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 144 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 144 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (self->priv->d_branch_name);
#line 144 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_branch_name = _tmp1_;
#line 145 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_update_branch_label (self);
#line 142 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "branch-name");
#line 3006 "gitg-repository-list-box.c"
}


gboolean gitg_repository_list_box_row_get_loading (GitgRepositoryListBoxRow* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 232 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 232 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_loading;
#line 232 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 232 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3021 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_loading (GitgRepositoryListBoxRow* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 233 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 235 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 235 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_loading = _tmp0_;
#line 237 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = self->priv->d_loading;
#line 237 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (!_tmp1_) {
#line 3038 "gitg-repository-list-box.c"
		GtkSpinner* _tmp2_ = NULL;
		GtkSpinner* _tmp3_ = NULL;
		GitgProgressBin* _tmp4_ = NULL;
#line 239 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = self->priv->d_spinner;
#line 239 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_spinner_stop (_tmp2_);
#line 240 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = self->priv->d_spinner;
#line 240 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_widget_hide ((GtkWidget*) _tmp3_);
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = self->priv->d_progress_bin;
#line 241 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_progress_bin_set_fraction (_tmp4_, (gdouble) 0);
#line 3054 "gitg-repository-list-box.c"
	} else {
		GtkSpinner* _tmp5_ = NULL;
		GtkSpinner* _tmp6_ = NULL;
#line 245 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = self->priv->d_spinner;
#line 245 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_widget_show ((GtkWidget*) _tmp5_);
#line 246 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = self->priv->d_spinner;
#line 246 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_spinner_start (_tmp6_);
#line 3066 "gitg-repository-list-box.c"
	}
#line 233 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "loading");
#line 3070 "gitg-repository-list-box.c"
}


static GObject * gitg_repository_list_box_row_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GitgRepositoryListBoxRow * self;
	GtkCheckButton* _tmp0_ = NULL;
#line 86 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	parent_class = G_OBJECT_CLASS (gitg_repository_list_box_row_parent_class);
#line 86 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 86 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow);
#line 88 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_remove_check_button;
#line 88 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_bind_property_with_closures ((GObject*) _tmp0_, "active", (GObject*) self, "selected", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 86 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return obj;
#line 3091 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_row_class_init (GitgRepositoryListBoxRowClass * klass) {
	gint GitgRepositoryListBoxRow_private_offset;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_parent_class = g_type_class_peek_parent (klass);
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_type_class_add_private (klass, sizeof (GitgRepositoryListBoxRowPrivate));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_repository_list_box_row_get_property;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_repository_list_box_row_set_property;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->constructor = gitg_repository_list_box_row_constructor;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_repository_list_box_row_finalize;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_MODE, g_param_spec_enum ("mode", "mode", "mode", GITG_TYPE_SELECTION_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_SELECTED, g_param_spec_boolean ("selected", "selected", "selected", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY, g_param_spec_object ("repository", "repository", "repository", GITG_TYPE_REPOSITORY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_CAN_REMOVE, g_param_spec_boolean ("can-remove", "can-remove", "can-remove", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_TIME, g_param_spec_boxed ("time", "time", "time", G_TYPE_DATE_TIME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_FRACTION, g_param_spec_double ("fraction", "fraction", "fraction", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_NAME, g_param_spec_string ("repository-name", "repository-name", "repository-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_DIRNAME, g_param_spec_string ("dirname", "dirname", "dirname", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_BRANCH_NAME, g_param_spec_string ("branch-name", "branch-name", "branch-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_LOADING, g_param_spec_boolean ("loading", "loading", "loading", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	GitgRepositoryListBoxRow_private_offset = g_type_class_get_instance_private_offset (klass);
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/gitg/ui/gitg-repository-list-box-row.ui");
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_signal_new ("request_remove", GITG_REPOSITORY_LIST_BOX_TYPE_ROW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_progress_bin", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_progress_bin));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_repository_label", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_repository_label));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_description_label", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_description_label));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_branch_label", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_branch_label));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_spinner", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_spinner));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_remove_check_button", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_remove_check_button));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_remove_revealer", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_remove_revealer));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_languages_box", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_languages_box));
#line 3151 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_row_instance_init (GitgRepositoryListBoxRow * self) {
	GDateTime* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv = GITG_REPOSITORY_LIST_BOX_ROW_GET_PRIVATE (self);
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = g_date_time_new_now_local ();
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _tmp0_;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_set_time (self, _tmp1_);
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_type_ensure (GITG_TYPE_PROGRESS_BIN);
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 3170 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_row_finalize (GObject* obj) {
	GitgRepositoryListBoxRow * self;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow);
#line 38 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_repository);
#line 39 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_date_time_unref0 (self->priv->d_time);
#line 42 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_progress_bin);
#line 44 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_repository_label);
#line 46 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_description_label);
#line 48 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_branch_label);
#line 50 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_spinner);
#line 52 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_remove_check_button);
#line 54 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_remove_revealer);
#line 56 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_languages_box);
#line 61 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (self->priv->d_dirname);
#line 62 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (self->priv->d_branch_name);
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (gitg_repository_list_box_row_parent_class)->finalize (obj);
#line 3204 "gitg-repository-list-box.c"
}


GType gitg_repository_list_box_row_get_type (void) {
	static volatile gsize gitg_repository_list_box_row_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_repository_list_box_row_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgRepositoryListBoxRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_repository_list_box_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgRepositoryListBoxRow), 0, (GInstanceInitFunc) gitg_repository_list_box_row_instance_init, NULL };
		GType gitg_repository_list_box_row_type_id;
		gitg_repository_list_box_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "GitgRepositoryListBoxRow", &g_define_type_info, 0);
		g_once_init_leave (&gitg_repository_list_box_row_type_id__volatile, gitg_repository_list_box_row_type_id);
	}
	return gitg_repository_list_box_row_type_id__volatile;
}


static void _vala_gitg_repository_list_box_row_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgRepositoryListBoxRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow);
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	switch (property_id) {
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_MODE:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_enum (value, gitg_repository_list_box_row_get_mode (self));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_SELECTED:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_boolean (value, gitg_repository_list_box_row_get_selected (self));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_object (value, gitg_repository_list_box_row_get_repository (self));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_CAN_REMOVE:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_boolean (value, gitg_repository_list_box_row_get_can_remove (self));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_TIME:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_boxed (value, gitg_repository_list_box_row_get_time (self));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_NAME:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_string (value, gitg_repository_list_box_row_get_repository_name (self));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_DIRNAME:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_string (value, gitg_repository_list_box_row_get_dirname (self));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_BRANCH_NAME:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_string (value, gitg_repository_list_box_row_get_branch_name (self));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_LOADING:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_boolean (value, gitg_repository_list_box_row_get_loading (self));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 3279 "gitg-repository-list-box.c"
		default:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 3285 "gitg-repository-list-box.c"
	}
}


static void _vala_gitg_repository_list_box_row_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GitgRepositoryListBoxRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow);
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	switch (property_id) {
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_MODE:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_mode (self, g_value_get_enum (value));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_SELECTED:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_selected (self, g_value_get_boolean (value));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_repository (self, g_value_get_object (value));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_CAN_REMOVE:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_can_remove (self, g_value_get_boolean (value));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_TIME:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_time (self, g_value_get_boxed (value));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_FRACTION:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_fraction (self, g_value_get_double (value));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_NAME:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_repository_name (self, g_value_get_string (value));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_DIRNAME:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_dirname (self, g_value_get_string (value));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_BRANCH_NAME:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_branch_name (self, g_value_get_string (value));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_LOADING:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_loading (self, g_value_get_boolean (value));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 3355 "gitg-repository-list-box.c"
		default:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 3361 "gitg-repository-list-box.c"
	}
}


static void gitg_repository_list_box_class_init (GitgRepositoryListBoxClass * klass) {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_parent_class = g_type_class_peek_parent (klass);
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_type_class_add_private (klass, sizeof (GitgRepositoryListBoxPrivate));
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	((GtkWidgetClass *) klass)->button_press_event = gitg_repository_list_box_real_button_press_event;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	((GtkListBoxClass *) klass)->row_activated = gitg_repository_list_box_real_row_activated;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_repository_list_box_get_property;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_repository_list_box_set_property;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->constructor = gitg_repository_list_box_constructor;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_repository_list_box_finalize;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_MODE, g_param_spec_enum ("mode", "mode", "mode", GITG_TYPE_SELECTION_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_HAS_SELECTION, g_param_spec_boolean ("has-selection", "has-selection", "has-selection", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_signal_new ("repository_activated", GITG_TYPE_REPOSITORY_LIST_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GITG_TYPE_REPOSITORY);
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_signal_new ("show_error", GITG_TYPE_REPOSITORY_LIST_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
#line 3391 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_instance_init (GitgRepositoryListBox * self) {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv = GITG_REPOSITORY_LIST_BOX_GET_PRIVATE (self);
#line 3398 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_finalize (GObject* obj) {
	GitgRepositoryListBox * self;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBox);
#line 30 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (self->priv->d_filter_text);
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (gitg_repository_list_box_parent_class)->finalize (obj);
#line 3410 "gitg-repository-list-box.c"
}


GType gitg_repository_list_box_get_type (void) {
	static volatile gsize gitg_repository_list_box_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_repository_list_box_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgRepositoryListBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_repository_list_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgRepositoryListBox), 0, (GInstanceInitFunc) gitg_repository_list_box_instance_init, NULL };
		GType gitg_repository_list_box_type_id;
		gitg_repository_list_box_type_id = g_type_register_static (gtk_list_box_get_type (), "GitgRepositoryListBox", &g_define_type_info, 0);
		g_once_init_leave (&gitg_repository_list_box_type_id__volatile, gitg_repository_list_box_type_id);
	}
	return gitg_repository_list_box_type_id__volatile;
}


static void _vala_gitg_repository_list_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgRepositoryListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBox);
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	switch (property_id) {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_MODE:
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_enum (value, gitg_repository_list_box_get_mode (self));
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_HAS_SELECTION:
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_boolean (value, gitg_repository_list_box_get_has_selection (self));
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 3443 "gitg-repository-list-box.c"
		default:
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 3449 "gitg-repository-list-box.c"
	}
}


static void _vala_gitg_repository_list_box_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GitgRepositoryListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBox);
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	switch (property_id) {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_MODE:
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_set_mode (self, g_value_get_enum (value));
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 3465 "gitg-repository-list-box.c"
		default:
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 3471 "gitg-repository-list-box.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



