%define ver      0.5.3
%define rel      SNAP
%define prefix   /usr

Summary: Gtk+ GUI builder
Name: glade
Version: %ver
Release: %rel
Copyright: LGPL
Group: X11/Libraries
Source: glade-%{ver}.tar.gz
BuildRoot: /var/tmp/glade-%{ver}-root
URL: http://www.gnome.org/
Docdir: %{prefix}/doc
Prefix: %prefix

%description
Glade is a GUI builder for Gtk.

%prep
%setup

%build
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%prefix

if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

make prefix=$RPM_BUILD_ROOT%{prefix} install

%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)

%doc AUTHORS COPYING ChangeLog NEWS README

%{prefix}/bin/glade
%{prefix}/share/locale/*/*/*.mo
%{prefix}/share/glade/gnome/*
%{prefix}/share/gnome/apps/Development/glade.desktop

%changelog
* Wed Jun 23 1999 Jose Mercado <jmercado@mit.edu>
- Changed the Source variable to use %{var}.
- Fixed glade.desktop's path so rpm will find it.
