
/*  Gtk+ User Interface Builder
 *  Copyright (C) 1998-1999  Damon Chaplin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>

#include <gtk/gtkmain.h>
#include <gtk/gtkrc.h>

#include "gladeconfig.h"

#ifdef USE_GNOME
#include <gnome.h>
#endif

#include "glade.h"
#include "glade_project.h"
#include "glade_project_window.h"
#include "utils.h"

static void parse_command_line (int argc,
				char *argv[],
				GladeProjectWindow *project_window);
static void usage (void);


#ifdef USE_GNOME
static poptContext pctx;

static struct poptOption options[] = {
  {
    NULL,
    '\0',
    0,
    NULL,
    0,
    NULL,
    NULL
  }
};
#endif

int
main (int argc, char *argv[])
{
  GladeProjectWindow *project_window;
  gchar *home_dir, *rc_path;

  home_dir = NULL;
  rc_path = NULL;

#ifdef USE_GNOME
  /* Gnome sets the locale and parses rc files automatically. */
  gnome_init_with_popt_table ("Glade", VERSION, argc, argv, options, 0, &pctx);
#else
  gtk_set_locale ();

  /* For GTK 1.2, default GTK rc files are parsed automatically. */
  home_dir = g_get_home_dir ();
  rc_path = g_strdup_printf ("%s/.gladerc", home_dir);
  gtk_rc_add_default_file (rc_path);
  g_free (rc_path);
  gtk_init (&argc, &argv);
#endif

  /* Ignore Ctrl-C. */
  /*signal (SIGINT, SIG_IGN);*/

#ifdef ENABLE_NLS
  bindtextdomain (PACKAGE, GLADE_LOCALE_DIR);
  textdomain (PACKAGE);
#endif

  glade_init ();

  project_window = glade_project_window_new ();
  gtk_widget_show (project_window->window);

  glade_show_palette ();
  glade_show_property_editor ();

  parse_command_line (argc, argv, project_window);
  if (current_project == NULL)
    glade_project_new ();

  glade_project_window_set_project (project_window, current_project);

  gtk_main ();
  return 0;
}


/* Currently the only command-line argument we handle is an XML file to load.
   For Gnome we have to use popt, even though we have no options. */
#ifdef USE_GNOME
static void
parse_command_line (int argc, char *argv[],
		    GladeProjectWindow *project_window)
{
  gchar *filename = NULL, *directory;
  const gchar **args;
  gint i;

  args = poptGetArgs (pctx);

  for (i = 0; args && args[i]; i++)
    {
      if (filename == NULL)
	filename = (gchar*) args[i];
      else
	usage ();
    }

  poptFreeContext (pctx);

  if (filename)
    {
      directory = g_get_current_dir ();
      filename = glade_util_make_absolute_path (directory, filename);
      glade_project_window_open_project (project_window, filename);
      g_free (directory);
      g_free (filename);
    }
}

#else
static void
parse_command_line (int argc, char *argv[],
		    GladeProjectWindow *project_window)
{
  gchar *filename = NULL, *directory;
  gint i;

  /* GTK parses argc & argv and sets arguments to NULL if it has used them. */
  for (i = 1; i < argc; i++)
    {
      if (argv[i])
	{
	  if (filename == NULL)
	    filename = argv[i];
	  else
	    usage ();
	}
    }

  if (filename)
    {
      directory = g_get_current_dir ();
      filename = glade_util_make_absolute_path (directory, filename);
      glade_project_window_open_project (project_window, filename);
      g_free (directory);
      g_free (filename);
    }
}
#endif


static void
usage (void)
{
  fprintf (stderr, "Usage: glade [filename]\n");
  exit (0);
}
