// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_APPLICATION_H
#define _GIOMM_APPLICATION_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2007 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <giomm/applicationcommandline.h>
#include <giomm/file.h>
#include <glibmm/object.h>
#include <glibmm/variant.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GApplication GApplication;
typedef struct _GApplicationClass GApplicationClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class Application_Class; } // namespace Gio
namespace Gio
{

/** @addtogroup giommEnums giomm Enums and Flags */

/**
 * @ingroup giommEnums
 * @par Bitwise operators:
 * <tt>%ApplicationFlags operator|(ApplicationFlags, ApplicationFlags)</tt><br>
 * <tt>%ApplicationFlags operator&(ApplicationFlags, ApplicationFlags)</tt><br>
 * <tt>%ApplicationFlags operator^(ApplicationFlags, ApplicationFlags)</tt><br>
 * <tt>%ApplicationFlags operator~(ApplicationFlags)</tt><br>
 * <tt>%ApplicationFlags& operator|=(ApplicationFlags&, ApplicationFlags)</tt><br>
 * <tt>%ApplicationFlags& operator&=(ApplicationFlags&, ApplicationFlags)</tt><br>
 * <tt>%ApplicationFlags& operator^=(ApplicationFlags&, ApplicationFlags)</tt><br>
 */
enum ApplicationFlags
{
  APPLICATION_FLAGS_NONE = 0x0,
  APPLICATION_IS_SERVICE = (1 << 0),
  APPLICATION_IS_LAUNCHER = (1 << 1),
  APPLICATION_HANDLES_OPEN = (1 << 2),
  APPLICATION_HANDLES_COMMAND_LINE = (1 << 3)
};

/** @ingroup giommEnums */
inline ApplicationFlags operator|(ApplicationFlags lhs, ApplicationFlags rhs)
  { return static_cast<ApplicationFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline ApplicationFlags operator&(ApplicationFlags lhs, ApplicationFlags rhs)
  { return static_cast<ApplicationFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline ApplicationFlags operator^(ApplicationFlags lhs, ApplicationFlags rhs)
  { return static_cast<ApplicationFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline ApplicationFlags operator~(ApplicationFlags flags)
  { return static_cast<ApplicationFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup giommEnums */
inline ApplicationFlags& operator|=(ApplicationFlags& lhs, ApplicationFlags rhs)
  { return (lhs = static_cast<ApplicationFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline ApplicationFlags& operator&=(ApplicationFlags& lhs, ApplicationFlags rhs)
  { return (lhs = static_cast<ApplicationFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline ApplicationFlags& operator^=(ApplicationFlags& lhs, ApplicationFlags rhs)
  { return (lhs = static_cast<ApplicationFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


class ActionGroup;

/** Application - Core application class.
 * An Application is the foundation of an application, unique for a given
 * application identifier. The Application class wraps some low-level
 * platform-specific services and is intended to act as the foundation for
 * higher-level application classes such as Gtk::Application or MxApplication.
 * In general, you should not use this class outside of a higher level
 * framework.
 *
 * One of the core features that Application provides is process uniqueness,
 * in the context of a "session". The session concept is platform-dependent,
 * but corresponds roughly to a graphical desktop login. When your application
 * is launched again, its arguments are passed through platform communication
 * to the already running program. The already running instance of the program
 * is called the <i>primary instance</i>.
 *
 * Before using Application, you must choose an "application identifier". The
 * expected form of an application identifier is very close to that of of a
 * <a href="
 * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-names-interface">DBus
 * bus name</a>. Examples include: "com.example.MyApp",
 * "org.example.internal-apps.Calculator". For details on valid application
 * identifiers, see id_is_valid().
 *
 * Application provides convenient life cycle management by maintaining a
 * <i>use count</i> for the primary application instance. The use count can be
 * changed using hold() and release(). If it drops to zero, the application
 * exits.
 *
 * Application also implements the ActionGroup interface and lets you easily
 * export actions by adding them with set_action_group(). When
 * invoking an action by calling Gio::ActionGroup::activate_action() on the
 * application, it is always invoked in the primary instance.
 *
 * There is a number of different entry points into an Application:
 *
 * - via 'Activate' (i.e. just starting the application)
 * - via 'Open' (i.e. opening some files)
 * - via activating an action
 *
 * The signal_startup() signal lets you handle the application initialization
 * for all of these in a single place.
 *
 * See the C API docs for an example.
 *
 * @newin{2,28}
 */

class Application : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Application CppObjectType;
  typedef Application_Class CppClassType;
  typedef GApplication BaseObjectType;
  typedef GApplicationClass BaseClassType;

private:  friend class Application_Class;
  static CppClassType application_class_;

private:
  // noncopyable
  Application(const Application&);
  Application& operator=(const Application&);

protected:
  explicit Application(const Glib::ConstructParams& construct_params);
  explicit Application(GApplication* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Application();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GApplication*       gobj()       { return reinterpret_cast<GApplication*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GApplication* gobj() const { return reinterpret_cast<GApplication*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GApplication* gobj_copy();

private:


protected:
  explicit Application(const Glib::ustring& application_id, ApplicationFlags flags=APPLICATION_FLAGS_NONE);
  

public:
  
  static Glib::RefPtr<Application> create(const Glib::ustring& application_id, ApplicationFlags flags = APPLICATION_FLAGS_NONE);


  static bool id_is_valid(const Glib::ustring& application_id);

  
  Glib::ustring get_id() const;
  
  void set_id(const Glib::ustring& application_id);

  
  guint get_inactivity_timeout() const;
  
  void set_inactivity_timeout(guint inactivity_timeout);

  
  ApplicationFlags get_flags() const;
  
  void set_flags(ApplicationFlags flags);

  
  void set_action_group(const Glib::RefPtr<ActionGroup>& action_group);

  
  bool is_registered() const;
  
  bool is_remote() const;

  //Renamed from register() because that is a C++ keyword.
  
  /** By default, Application ensures process uniqueness when
   * initialized, but this behavior is controlled by the
   * GApplication:register property.  If it was given as <tt>false</tt> at
   * construction time, this function allows you to later attempt
   * to ensure uniqueness.  Note that the GApplication:default-quit
   * property no longer applies at this point; if this function returns
   * <tt>false</tt>, platform activation will occur, but the current process
   * will not be terminated.
   * 
   * It is an error to call this function more than once.  It is
   * also an error to call this function if the GApplication:register
   * property was <tt>true</tt> at construction time.
   * @return <tt>true</tt> if registration was successful.
   */
  bool register_application(const Glib::RefPtr<Gio::Cancellable>& cancellable);

  /// Non-cancellable version of register_application().
  bool register_application();

  
  void hold();
  
  void release();
  
  void activate();

  typedef std::vector< Glib::RefPtr<File> > type_vec_files;

  /* Opens the given files.
   *
   * In essence, this results in the open signal being emitted
   * in the primary instance.
   *
   * @a hint is simply passed through to the open signal.  It is
   * intended to be used by applications that have multiple modes for
   * opening files (eg: "view" vs "edit", etc).
   *
   * The application must be registered before calling this mwethod
   * and it must have the APPLICATION_HANDLES_OPEN flag set.
   *
   * @param files The files to open. This must be non-empty.
   * @param hint A hint.
   *
   * @newin{2,28}
   */
  void open(const type_vec_files& files, const Glib::ustring& hint = Glib::ustring());

  
  /** Starts the application.
   * 
   * The default implementation of this virtual function will simply run
   * a main loop.
   * 
   * It is an error to call this function if @a application is a proxy for
   * a remote application.
   * 
   * @newin{2,26}
   */
  int run(int argc, char** argv);
  //TODO: g_application_run_with_arguments)

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The group of actions that the application exports.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_WriteOnly< Glib::RefPtr<ActionGroup> > property_action_group() ;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The unique identifier for the application.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_application_id() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The unique identifier for the application.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_application_id() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Flags specifying the behaviour of the application.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<ApplicationFlags> property_flags() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Flags specifying the behaviour of the application.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<ApplicationFlags> property_flags() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Iime (ms) to stay alive after becoming idle.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint> property_inactivity_timeout() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Iime (ms) to stay alive after becoming idle.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_inactivity_timeout() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** If g_application_register() has been called.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_is_registered() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** If this application instance is remote.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_is_remote() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


//#m4 __CONVERSION(`const gchar*', `const Glib::ustring&', `Glib::ustring($3)')
//#m4 __CONVERSION(`GVariant*', `const Glib::VariantBase&', `Glib::wrap($3, true)')

  
  /**
   * @par Prototype:
   * <tt>void on_my_%startup()</tt>
   */

  Glib::SignalProxy0< void > signal_startup();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%activate()</tt>
   */

  Glib::SignalProxy0< void > signal_activate();

  
  //We wrap the open signal without _WRAP_SIGNAL(), because we need to change its parameters.
  //See bug https://bugzilla.gnome.org/show_bug.cgi?id=637457
  Glib::SignalProxy2< void,  const type_vec_files&, const Glib::ustring& > signal_open();

 
  /**
   * @par Prototype:
   * <tt>bool on_my_%command_line(const Glib::RefPtr<ApplicationCommandLine>& command_line)</tt>
   */

  Glib::SignalProxy1< bool,const Glib::RefPtr<ApplicationCommandLine>& > signal_command_line();


protected:
  virtual void on_open(const type_vec_files& files, const Glib::ustring& hint);


private:
  /** This is just a way to call Glib::init() (which calls g_type_init()) before
   * calling application_class_.init(), so that 
   * g_application_get_type() will always succeed.
   * See https://bugzilla.gnome.org/show_bug.cgi?id=639925
   */
  const Glib::Class& custom_class_init();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_startup();
  virtual void on_activate();
  virtual bool on_command_line(const Glib::RefPtr<ApplicationCommandLine>& command_line);


};


} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::Application
   */
  Glib::RefPtr<Gio::Application> wrap(GApplication* object, bool take_copy = false);
}


#endif /* _GIOMM_APPLICATION_H */

