// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_DATAINPUTSTREAM_H
#define _GIOMM_DATAINPUTSTREAM_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2007 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <giomm/bufferedinputstream.h>
#include <giomm/enums.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GDataInputStream GDataInputStream;
typedef struct _GDataInputStreamClass GDataInputStreamClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class DataInputStream_Class; } // namespace Gio
namespace Gio
{

/**
 * An implementation of BufferedInputStream that allows for high-level data
 * manipulation of arbitrary data (including binary operations).
 *
 * @ingroup Streams
 *
 * @newin{2,16}
 */

class DataInputStream : public Gio::BufferedInputStream
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef DataInputStream CppObjectType;
  typedef DataInputStream_Class CppClassType;
  typedef GDataInputStream BaseObjectType;
  typedef GDataInputStreamClass BaseClassType;

private:  friend class DataInputStream_Class;
  static CppClassType datainputstream_class_;

private:
  // noncopyable
  DataInputStream(const DataInputStream&);
  DataInputStream& operator=(const DataInputStream&);

protected:
  explicit DataInputStream(const Glib::ConstructParams& construct_params);
  explicit DataInputStream(GDataInputStream* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~DataInputStream();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GDataInputStream*       gobj()       { return reinterpret_cast<GDataInputStream*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GDataInputStream* gobj() const { return reinterpret_cast<GDataInputStream*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GDataInputStream* gobj_copy();

private:


protected:
    explicit DataInputStream(const Glib::RefPtr<InputStream>& base_stream);


public:

  
  static Glib::RefPtr<DataInputStream> create(const Glib::RefPtr<InputStream>& base_stream);


  /** This function sets the byte order for the given @a stream. All subsequent
   * reads from the @a stream will be read in the given @a order.
   * @param order A DataStreamByteOrder to set.
   */
  void set_byte_order(DataStreamByteOrder order);
  
  /** Gets the byte order for the data input stream.
   * @return The @a stream's current DataStreamByteOrder.
   */
  DataStreamByteOrder get_byte_order() const;
  
  /** Sets the newline type for the @a stream.
   * 
   * Note that using G_DATA_STREAM_NEWLINE_TYPE_ANY is slightly unsafe. If a read
   * chunk ends in "CR" we must read an additional byte to know if this is "CR" or
   * "CR LF", and this might block if there is no more data available.
   * @param type The type of new line return as DataStreamNewlineType.
   */
  void set_newline_type(DataStreamNewlineType type);
  
  /** Gets the current newline type for the @a stream.
   * @return DataStreamNewlineType for the given @a stream.
   */
  DataStreamNewlineType get_newline_type() const;

  
  /** Reads an unsigned 8-bit/1-byte value from @a stream.
   * @param cancellable Optional Cancellable object, <tt>0</tt> to ignore.
   * @return An unsigned 8-bit/1-byte value read from the @a stream or %0 
   * if an error occurred.
   */
  guchar read_byte(const Glib::RefPtr<Cancellable>& cancellable);

  /** non-cancellable version of read_byte()
   */
  guchar read_byte();

  
  /** Reads a 16-bit/2-byte value from @a stream.
   * 
   * In order to get the correct byte order for this read operation, 
   * see g_data_input_stream_get_byte_order() and g_data_input_stream_set_byte_order().
   * @param cancellable Optional Cancellable object, <tt>0</tt> to ignore.
   * @return A signed 16-bit/2-byte value read from @a stream or %0 if 
   * an error occurred.
   */
  gint16 read_int16(const Glib::RefPtr<Cancellable>& cancellable);
  /** non-cancellable version of read_int16()
   */
  gint16 read_int16();

  
  /** Reads an unsigned 16-bit/2-byte value from @a stream.
   * 
   * In order to get the correct byte order for this read operation, 
   * see g_data_input_stream_get_byte_order() and g_data_input_stream_set_byte_order().
   * @param cancellable Optional Cancellable object, <tt>0</tt> to ignore.
   * @return An unsigned 16-bit/2-byte value read from the @a stream or %0 if 
   * an error occurred.
   */
  guint16 read_uint16(const Glib::RefPtr<Cancellable>& cancellable);

//TODO: Real documentation:
  /** non-cancellable version of read_uint16()
   */
  guint16 read_uint16();

  
  /** Reads a signed 32-bit/4-byte value from @a stream.
   * 
   * In order to get the correct byte order for this read operation, 
   * see Glib::data_stream_get_byte_order() and Glib::data_stream_set_byte_order().
   * 
   * The operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, a Gio::Error will be thrown with CANCELLED.
   * @param cancellable Cancellable object.
   * @return A signed 32-bit/4-byte value read from the @a stream or %0 if 
   * an error occurred.
   */
  gint32 read_int32(const Glib::RefPtr<Cancellable>& cancellable);

  /** non-cancellable version of read_int32()
   */
  gint32 read_int32();

  
  /** Reads an unsigned 32-bit/4-byte value from @a stream.
   * 
   * In order to get the correct byte order for this read operation, 
   * see Glib::data_stream_get_byte_order() and Glib::data_stream_set_byte_order().
   * 
   * The operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, a Gio::Error will be thrown with CANCELLED.
   * @param cancellable Cancellable object.
   * @return An unsigned 32-bit/4-byte value read from the @a stream or %0 if 
   * an error occurred.
   */
  guint32 read_uint32(const Glib::RefPtr<Cancellable>& cancellable);
  /** non-cancellable version of read_uint32()
   */
  guint32 read_uint32();

  
  /** Reads a 64-bit/8-byte value from @a stream.
   * 
   * In order to get the correct byte order for this read operation, 
   * see Glib::data_stream_get_byte_order() and Glib::data_stream_set_byte_order().
   * 
   * The operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, a Gio::Error will be thrown with CANCELLED.
   * @param cancellable Cancellable object.
   * @return A signed 64-bit/8-byte value read from @a stream or %0 if 
   * an error occurred.
   */
  gint64 read_int64(const Glib::RefPtr<Cancellable>& cancellable);

  /** non-cancellable version of read_int64()
   */
  gint64 read_int64();

  
  /** Reads an unsigned 64-bit/8-byte value from @a stream.
   * 
   * In order to get the correct byte order for this read operation, 
   * see Glib::data_stream_get_byte_order().
   * 
   * The operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, a Gio::Error will be thrown with CANCELLED.
   * @param cancellable Cancellable object.
   * @return An unsigned 64-bit/8-byte read from @a stream or %0 if 
   * an error occurred.
   */
  guint64 read_uint64(const Glib::RefPtr<Cancellable>& cancellable);

  /** non-cancellable version of read_uint64()
   */
  guint64 read_uint64();


  //Note that we return a bool because we can't use std::string to distinguish between an empty string and a NULL.

  /** Reads a line from the data input stream.
   *
   * The operation can be cancelled by triggering the cancellable object from
   * another thread. If the operation
   * was cancelled, a Gio::Error with CANCELLED will be thrown.
   *
   * @param data A string to fill with the read data (without the newlines).
   * @param cancellable A cancellable object.
   * @result true if the read succeeded without error.
   */
  bool read_line(std::string& line, const Glib::RefPtr<Cancellable>& cancellable);
  

  /** A non-cancellable version of read_line().
   *
   * @param data A string to fill with the read data (without the newlines).
   * @result true if the read succeeded without error.
   */
  bool read_line(std::string& line);

// The below initialization is unusual because it stores the return in a 'tmp'
// variable, sets the output parameter and then frees the return.  If this is
// too weird, the methods can probably be just handwritten.
# 


  /** Reads a UTF-8 encoded line from the data input stream.
   * 
   * If @a cancellable is not <tt>0</tt>, then the operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, the error IO_ERROR_CANCELLED will be returned.
   * 
   * @newin{2,30}
   * @param length A #gsize to get the length of the data read in.
   * @param cancellable Optional Cancellable object, <tt>0</tt> to ignore.
   * @return A NUL terminated UTF-8 string with the
   * line that was read in (without the newlines).  Set @a length to a
   * #gsize to get the length of the read line.  On an error, it will
   * return <tt>0</tt> and @a error will be set.  For UTF-8 conversion errors,
   * the set error domain is CONVERT_ERROR.  If there's no content to
   * read, it will still return <tt>0</tt>, but @a error won't be set.
   */
  void read_line_utf8(std::string& line, const Glib::RefPtr<Cancellable>& cancellable, gsize& length);

  /// A read_line_utf8() convenience overload.
  void read_line_utf8(std::string& line, const Glib::RefPtr<Cancellable>& cancellable);

  /// A read_line_utf8() convenience overload.
  void read_line_utf8(std::string& line, gsize& length);

  /// A read_line_utf8() convenience overload.
  void read_line_utf8(std::string& line);

  /** The asynchronous version of read_until(). It is
   * an error to have two outstanding calls to this function.
   *
   * @param slot The slot to call when the request is satisfied.
   * @param cancellable A cancellable object.
   * @param io_priority The I/O priority of the request.
   * @result true if the read succeeded without error.
   */
  void read_line_async(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, int io_priority = Glib::PRIORITY_DEFAULT);
  

  /** Finish an asynchronous call started by read_line_async().
   *
   * @param result The AsyncResult that was provided to the callback slot.
   * @param data A string to fill with the read data.
   * @result true if the read succeeded without error.
   */
  bool read_line_finish(const Glib::RefPtr<AsyncResult>& result, std::string& data);
  

  /** Finish an asynchronous call started by
   * g_data_input_stream_read_line_async().
   * 
   * @newin{2,30}
   * @param result The AsyncResult that was provided to the callback.
   * @param length A #gsize to get the length of the data read in.
   * @return A string with the line that was read in
   * (without the newlines).  Set @a length to a #gsize to get the length
   * of the read line.  On an error, it will return <tt>0</tt> and @a error
   * will be set. For UTF-8 conversion errors, the set error domain is
   * CONVERT_ERROR.  If there's no content to read, it will still
   * return <tt>0</tt>, but @a error won't be set.
   */
  void read_line_finish_utf8(const Glib::RefPtr<AsyncResult>& result, std::string& data, gsize& length);

  /// A read_line_finish_utf8() convenience overload.
  void read_line_finish_utf8(const Glib::RefPtr<AsyncResult>& result, std::string& data);

  /** Reads a string from the data input stream, up to the first
   * occurrence of any of the stop characters.
   *
   * Note that, in contrast to read_until_async(),
   * this function consumes the stop character that it finds.
   *
   * Don't use this function in new code.  Its functionality is
   * inconsistent with read_until_async().  Both
   * functions will be marked as deprecated in a future release.  Use
   * read_upto() instead, but note that that method
   * does not consume the stop character.
   *
   * @param data A string to fill with the read data.
   * @param stop_chars Characters to terminate the read.
   * @param cancellable A cancellable object.
   * @result true if the read succeeded without error.
   */
  bool read_until(std::string& data, const std::string& stop_chars, const Glib::RefPtr<Cancellable>& cancellable);
  

  //TODO: This will be really deprecated sometime, maybe sometime after glib 2.30.0.
  /** A non-cancellable version of read_until().
   *
   * Note that, in contrast to read_until_async(),
   * this function consumes the stop character that it finds.
   *
   * Don't use this function in new code.  Its functionality is
   * inconsistent with read_until_async().  Both
   * functions will be marked as deprecated in a future release.  Use
   * read_upto() instead, but note that that method
   * does not consume the stop character.
   *
   * @param stop_chars Characters to terminate the read.
   * @param data A string to fill with the read data.
   * @result true if the read succeeded without error.
   */
  bool read_until(std::string& data, const std::string& stop_chars);

  //TODO: This will be really deprecated sometime after glib 2.30.0.
  /** The asynchronous version of read_until(). It is
   * an error to have two outstanding calls to this function.
   *
   * Note that, in contrast to ead_until(),
   * this function does not consume the stop character that it finds.  You
   * must read it for yourself.
   *
   *
   * Don't use this function in new code.  Its functionality is
   * inconsistent with read_until().  Both functions
   * will be marked as deprecated in a future release.  Use
   * read_upto_async() instead.
   *
   * @param stop_chars Characters to terminate the read.
   * @param slot The slot to call when the request is satisfied.
   * @param cancellable A cancellable object.
   * @param io_priority The I/O priority of the request.
   * @result true if the read succeeded without error.
   */
  void read_until_async(const std::string& stop_chars, const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, int io_priority = Glib::PRIORITY_DEFAULT);
  

  //TODO: This will be really deprecated sometime after glib 2.30.0.
  /** Finish an asynchronous call started by read_until_async().
   *
   * @param result The AsyncResult that was provided to the callback slot.
   * @param data A string to fill with the read data.
   * @result true if the read succeeded without error.
   */
  bool read_until_finish(const Glib::RefPtr<AsyncResult>& result, std::string& data);
  

 /** Reads a string from the data input stream, up to the first
   * occurrence of any of the stop characters.
   *
   * In contrast to read_until(), this method
   * does <emphasis>not</emphasis> consume the stop character. You have
   * to use read_byte() to get it before calling
   * read_upto() again.
   *
   * @param data A string to fill with the read data.
   * @param stop_chars Characters to terminate the read.
   * @param cancellable A cancellable object.
   * @result true if the read succeeded without error.
   */
  bool read_upto(std::string& data, const std::string& stop_chars, const Glib::RefPtr<Cancellable>& cancellable);
  

  /** A non-cancellable version of read_upto().
   * @param stop_chars Characters to terminate the read.
   * @param data A string to fill with the read data.
   * @result true if the read succeeded without error.
   */
  bool read_upto(std::string& data, const std::string& stop_chars);

  //TODO: Add a version that takes the stop_chars length, to allow a 0 in the middle?

  /** The asynchronous version of read_upto(). It is
   * an error to have two outstanding calls to this function.
   *
   * In contrast to read_until(), this method
   * does <emphasis>not</emphasis> consume the stop character. You have
   * to use read_byte() to get it before calling
   * read_upto() again.
   *
   * @param stop_chars Characters to terminate the read.
   * @param slot The slot to call when the request is satisfied.
   * @param cancellable A cancellable object.
   * @param io_priority The I/O priority of the request.
   * @result true if the read succeeded without error.
   */
  void read_upto_async(const std::string& stop_chars, const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, int io_priority = Glib::PRIORITY_DEFAULT);
  

  /** Finish an asynchronous call started by read_upto_async().
   *
   * Note that this function does <emphasis>not</emphasis> consume the
   * stop character. You have to use read_byte() to
   * get it before calling read_upto_async() again.
   *
   * @param result The AsyncResult that was provided to the callback slot.
   * @param data A string to fill with the read data.
   * @result true if the read succeeded without error.
   */
  bool read_upto_finish(const Glib::RefPtr<AsyncResult>& result, std::string& data);
  

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The byte order.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< DataStreamByteOrder > property_byte_order() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The byte order.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< DataStreamByteOrder > property_byte_order() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The accepted types of line ending.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< DataStreamNewlineType > property_newline_type() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The accepted types of line ending.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< DataStreamNewlineType > property_newline_type() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::DataInputStream
   */
  Glib::RefPtr<Gio::DataInputStream> wrap(GDataInputStream* object, bool take_copy = false);
}


#endif /* _GIOMM_DATAINPUTSTREAM_H */

