<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>
<tagfile>
  <compound kind="group">
    <name>CharsetConv</name>
    <title>Character Set Conversion</title>
    <filename>group__CharsetConv.html</filename>
    <class kind="class">Glib::ConvertError</class>
    <class kind="class">Glib::IConv</class>
    <member kind="function">
      <type>bool</type>
      <name>get_charset</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gabf5fac564c47a7a9ad6037044c3909f4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_charset</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga88965337df48a173a6b013e8243e4631</anchor>
      <arglist>(std::string &amp;charset)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>convert</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga58f7e4556c436a96c64b186bbc8f7f4c</anchor>
      <arglist>(const std::string &amp;str, const std::string &amp;to_codeset, const std::string &amp;from_codeset)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>convert_with_fallback</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga40b5aa172fabd1f3dbf50a962d0d351f</anchor>
      <arglist>(const std::string &amp;str, const std::string &amp;to_codeset, const std::string &amp;from_codeset)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>convert_with_fallback</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gaf1b091e4397a7637e884148484b1f71e</anchor>
      <arglist>(const std::string &amp;str, const std::string &amp;to_codeset, const std::string &amp;from_codeset, const Glib::ustring &amp;fallback)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>locale_to_utf8</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga4517b17f2aad4cd5c0e0640de212d928</anchor>
      <arglist>(const std::string &amp;opsys_string)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>locale_from_utf8</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gacc062729285890a7e9b22bece6fb987c</anchor>
      <arglist>(const Glib::ustring &amp;utf8_string)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>filename_to_utf8</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga6cf95dc00505401594260a360d70c17b</anchor>
      <arglist>(const std::string &amp;opsys_string)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>filename_from_utf8</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga2bd94064ad97b43324a7854b62f0835b</anchor>
      <arglist>(const Glib::ustring &amp;utf8_string)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>filename_from_uri</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gada23cd7f7dc8eb25e99b867a55551763</anchor>
      <arglist>(const Glib::ustring &amp;uri, Glib::ustring &amp;hostname)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>filename_from_uri</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gab1cb94f4a4a70bad06b715fb14a252d9</anchor>
      <arglist>(const Glib::ustring &amp;uri)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>filename_to_uri</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gae1b2f056bde3fbab578c602fe42e3de9</anchor>
      <arglist>(const std::string &amp;filename, const Glib::ustring &amp;hostname)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>filename_to_uri</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gaaf69aec83665229cc06596cf627d9d5a</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>filename_display_basename</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga05dd67157ad35da4401263247b6f4d81</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>filename_display_name</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gabc1b404cc965f3da6beecddfe2623afc</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>FileUtils</name>
    <title>File Utilities</title>
    <filename>group__FileUtils.html</filename>
    <class kind="class">Glib::FileError</class>
    <class kind="class">Glib::DirIterator</class>
    <class kind="class">Glib::Dir</class>
    <member kind="function">
      <type>bool</type>
      <name>file_test</name>
      <anchorfile>group__FileUtils.html</anchorfile>
      <anchor>ga0b2fce78896a9a84f7ea3a5646cc7d36</anchor>
      <arglist>(const std::string &amp;filename, FileTest test)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>mkstemp</name>
      <anchorfile>group__FileUtils.html</anchorfile>
      <anchor>gae4c8d716bd109b6b8e1420a8c20b3507</anchor>
      <arglist>(std::string &amp;filename_template)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>file_open_tmp</name>
      <anchorfile>group__FileUtils.html</anchorfile>
      <anchor>gae91f239f1cf0123399374deed54fbf3a</anchor>
      <arglist>(std::string &amp;name_used, const std::string &amp;prefix)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>file_open_tmp</name>
      <anchorfile>group__FileUtils.html</anchorfile>
      <anchor>ga682379de4ea119540b4bdc1759e93e1d</anchor>
      <arglist>(std::string &amp;name_used)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>file_get_contents</name>
      <anchorfile>group__FileUtils.html</anchorfile>
      <anchor>ga835da54212fe78e833ac55b49150b989</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>Markup</name>
    <title>Simple XML Subset Parser</title>
    <filename>group__Markup.html</filename>
    <class kind="class">Glib::MarkupError</class>
    <class kind="class">Glib::Markup::AttributeKeyLess</class>
    <class kind="class">Glib::Markup::Parser</class>
    <class kind="class">Glib::Markup::ParseContext</class>
    <member kind="typedef">
      <type>Glib::MarkupError</type>
      <name>Error</name>
      <anchorfile>group__Markup.html</anchorfile>
      <anchor>ga7d0403c76601e7d3ba4641737e094e77</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>escape_text</name>
      <anchorfile>group__Markup.html</anchorfile>
      <anchor>gac95c5843d8dada8449f90f2fd635feb1</anchor>
      <arglist>(const Glib::ustring &amp;text)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>ShellUtils</name>
    <title>Shell-related Utilities</title>
    <filename>group__ShellUtils.html</filename>
    <class kind="class">Glib::ShellError</class>
    <member kind="function">
      <type>Glib::ArrayHandle&lt; std::string &gt;</type>
      <name>shell_parse_argv</name>
      <anchorfile>group__ShellUtils.html</anchorfile>
      <anchor>gabc52fcb14cfc7a5ba37ca821cc837818</anchor>
      <arglist>(const std::string &amp;command_line)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>shell_quote</name>
      <anchorfile>group__ShellUtils.html</anchorfile>
      <anchor>ga55ebfb935f2131b2ae40d339568f568c</anchor>
      <arglist>(const std::string &amp;unquoted_string)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>shell_unquote</name>
      <anchorfile>group__ShellUtils.html</anchorfile>
      <anchor>ga449dc37c6ea7e7563740df86e31c263c</anchor>
      <arglist>(const std::string &amp;quoted_string)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>Spawn</name>
    <title>Spawning Processes</title>
    <filename>group__Spawn.html</filename>
    <class kind="class">Glib::SpawnError</class>
    <member kind="function">
      <type>void</type>
      <name>spawn_async_with_pipes</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>gadb706d1e1d3083f9e6442a3044a602fb</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, const Glib::ArrayHandle&lt; std::string &gt; &amp;envp, SpawnFlags flags=SPAWN_DEFAULT, const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), Pid *child_pid=0, int *standard_input=0, int *standard_output=0, int *standard_error=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_async_with_pipes</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>ga1aaf9311604a09fd4cc7823094243b34</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, SpawnFlags flags=SPAWN_DEFAULT, const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), Pid *child_pid=0, int *standard_input=0, int *standard_output=0, int *standard_error=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_async</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>ga0f9130d1ada136363660bc7205d8b8ec</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, const Glib::ArrayHandle&lt; std::string &gt; &amp;envp, SpawnFlags flags=SPAWN_DEFAULT, const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), Pid *child_pid=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_async</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>gab867cbdeb4024b4f91a723308a312f2a</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, SpawnFlags flags=SPAWN_DEFAULT, const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), Pid *child_pid=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_sync</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>gabc2f8009b29ba1f222e6ff1694eb34fd</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, const Glib::ArrayHandle&lt; std::string &gt; &amp;envp, SpawnFlags flags=SPAWN_DEFAULT, const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), std::string *standard_output=0, std::string *standard_error=0, int *exit_status=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_sync</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>gadae71dd52cd1df777bd83fc9455f30c5</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, SpawnFlags flags=SPAWN_DEFAULT, const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), std::string *standard_output=0, std::string *standard_error=0, int *exit_status=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_command_line_async</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>ga648167a4af607f87763f1334fe5a472f</anchor>
      <arglist>(const std::string &amp;command_line)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_command_line_sync</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>ga713bdb79396eda85ad186cb2db89564f</anchor>
      <arglist>(const std::string &amp;command_line, std::string *standard_output=0, std::string *standard_error=0, int *exit_status=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_close_pid</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>gaaea8f41c7a08af3b2919ce64fd0c27e5</anchor>
      <arglist>(Pid pid)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>Threads</name>
    <title>Threads</title>
    <filename>group__Threads.html</filename>
    <class kind="class">Glib::Threads::ThreadError</class>
    <class kind="class">Glib::Threads::Thread</class>
    <class kind="class">Glib::Threads::Thread::Exit</class>
    <class kind="class">Glib::Threads::Mutex</class>
    <class kind="class">Glib::Threads::Mutex::Lock</class>
    <class kind="class">Glib::Threads::RecMutex</class>
    <class kind="class">Glib::Threads::RWLock</class>
    <class kind="class">Glib::Threads::RWLock::ReaderLock</class>
    <class kind="class">Glib::Threads::RWLock::WriterLock</class>
    <class kind="class">Glib::Threads::Cond</class>
    <class kind="class">Glib::Threads::Private</class>
    <class kind="class">Glib::Dispatcher</class>
    <member kind="enumeration">
      <type></type>
      <name>NotLock</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>ga298a91d4f9bcfd13d3f9c342bcc8161a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NOT_LOCK</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>gga298a91d4f9bcfd13d3f9c342bcc8161aa67a1c7fd98ae71afc32ad7c22bfb0a87</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>TryLock</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>ga58eba5840db7a5440b7c37bf17a5bb74</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TRY_LOCK</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>gga58eba5840db7a5440b7c37bf17a5bb74aca992b53c9825f414b1b5b308228beeb</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>Thread *</type>
      <name>wrap</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>ga6bfbb3119eaac9fa8cb725aa1e82f61e</anchor>
      <arglist>(GThread *gobject)</arglist>
    </member>
    <member kind="function">
      <type>Mutex *</type>
      <name>wrap</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>ga474cb9d17afdc606a6afd0068ac061d3</anchor>
      <arglist>(GMutex *gobject)</arglist>
    </member>
    <member kind="function">
      <type>RecMutex *</type>
      <name>wrap</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>gad710cc5f6feaccfe6fe2c886b6cd1636</anchor>
      <arglist>(GRecMutex *gobject)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>Unicode</name>
    <title>Unicode Manipulation</title>
    <filename>group__Unicode.html</filename>
    <namespace>Glib::Unicode</namespace>
    <namespace>Glib::Ascii</namespace>
  </compound>
  <compound kind="group">
    <name>UriUtils</name>
    <title>URI Utilities</title>
    <filename>group__UriUtils.html</filename>
    <member kind="function">
      <type>std::string</type>
      <name>uri_unescape_string</name>
      <anchorfile>group__UriUtils.html</anchorfile>
      <anchor>ga0c070cac984dc463fd60ccbdb4237e25</anchor>
      <arglist>(const std::string &amp;escaped_string, const std::string &amp;illegal_characters=std::string())</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>uri_parse_scheme</name>
      <anchorfile>group__UriUtils.html</anchorfile>
      <anchor>ga0cc4270d6796b2166964f08a5cb746b3</anchor>
      <arglist>(const std::string &amp;uri)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>uri_escape_string</name>
      <anchorfile>group__UriUtils.html</anchorfile>
      <anchor>gad902095ab5049111caa9207770b0a437</anchor>
      <arglist>(const std::string &amp;unescaped, const std::string &amp;reserved_chars_allowed=std::string(), bool allow_utf8=true)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>Variant</name>
    <title>Variant Data Types</title>
    <filename>group__Variant.html</filename>
    <class kind="class">Glib::VariantBase</class>
    <class kind="class">Glib::VariantStringBase</class>
    <class kind="class">Glib::VariantContainerBase</class>
    <class kind="class">Glib::Variant</class>
    <class kind="class">Glib::Variant&lt; VariantBase &gt;</class>
    <class kind="class">Glib::Variant&lt; Variant&lt; T &gt; &gt;</class>
    <class kind="class">Glib::Variant&lt; Glib::ustring &gt;</class>
    <class kind="class">Glib::Variant&lt; std::string &gt;</class>
    <class kind="class">Glib::Variant&lt; std::vector&lt; T &gt; &gt;</class>
    <class kind="class">Glib::Variant&lt; std::vector&lt; Glib::ustring &gt; &gt;</class>
    <class kind="class">Glib::Variant&lt; std::vector&lt; std::string &gt; &gt;</class>
    <class kind="class">Glib::Variant&lt; std::map&lt; K, V &gt; &gt;</class>
    <class kind="class">Glib::VariantType</class>
    <class kind="class">Glib::Variant&lt; bool &gt;</class>
    <class kind="class">Glib::Variant&lt; unsigned char &gt;</class>
    <class kind="class">Glib::Variant&lt; gint16 &gt;</class>
    <class kind="class">Glib::Variant&lt; guint16 &gt;</class>
    <class kind="class">Glib::Variant&lt; gint32 &gt;</class>
    <class kind="class">Glib::Variant&lt; guint32 &gt;</class>
    <class kind="class">Glib::Variant&lt; gint64 &gt;</class>
    <class kind="class">Glib::Variant&lt; guint64 &gt;</class>
    <class kind="class">Glib::Variant&lt; double &gt;</class>
  </compound>
  <compound kind="group">
    <name>Base64</name>
    <title>Base64 routines</title>
    <filename>group__Base64.html</filename>
    <namespace>Glib::Base64</namespace>
  </compound>
  <compound kind="group">
    <name>ContHandles</name>
    <title>Generic container converters</title>
    <filename>group__ContHandles.html</filename>
    <subgroup>ContHelpers</subgroup>
    <class kind="class">Glib::ArrayHandle</class>
    <class kind="class">Glib::Sequence</class>
    <class kind="class">Glib::ListHandle</class>
    <class kind="class">Glib::SListHandle</class>
    <member kind="typedef">
      <type>ArrayHandle&lt; Glib::ustring &gt;</type>
      <name>StringArrayHandle</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>ga8e243b697be740f5f7d4b578ae50db41</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>OwnershipType</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>ga64c27560b41710ccf64a3679a3ba3f20</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>OWNERSHIP_NONE</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>gga64c27560b41710ccf64a3679a3ba3f20a7d594cffcc2d2d6c4313ddb4d6613c79</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>OWNERSHIP_SHALLOW</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>gga64c27560b41710ccf64a3679a3ba3f20a448c598cdc37e2de8a162e1020001715</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>OWNERSHIP_DEEP</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>gga64c27560b41710ccf64a3679a3ba3f20a2a6d6bfadc36f9eda31af79d32928c6a</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>Sequence&lt; Iterator &gt;</type>
      <name>sequence</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>ga76f58aa143a15c1ba422846c3176fbdc</anchor>
      <arglist>(Iterator pbegin, Iterator pend)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>ContHelpers</name>
    <title>Helper classes</title>
    <filename>group__ContHelpers.html</filename>
    <class kind="class">Glib::Container_Helpers::ArrayHandleIterator</class>
    <class kind="struct">Glib::Container_Helpers::TypeTraits</class>
    <class kind="class">Glib::Container_Helpers::ListHandleIterator</class>
    <class kind="class">Glib::Container_Helpers::SListHandleIterator</class>
  </compound>
  <compound kind="group">
    <name>MainLoop</name>
    <title>The Main Event Loop</title>
    <filename>group__MainLoop.html</filename>
    <class kind="class">Glib::PollFD</class>
    <class kind="class">Glib::SignalTimeout</class>
    <class kind="class">Glib::SignalIdle</class>
    <class kind="class">Glib::SignalIO</class>
    <class kind="class">Glib::SignalChildWatch</class>
    <class kind="class">Glib::MainContext</class>
    <class kind="class">Glib::MainLoop</class>
    <class kind="class">Glib::Source</class>
    <class kind="class">Glib::TimeoutSource</class>
    <class kind="class">Glib::IdleSource</class>
    <class kind="class">Glib::IOSource</class>
    <member kind="function">
      <type>SignalTimeout</type>
      <name>signal_timeout</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>gaadb206fcc112f086f9d47c016b1f2175</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SignalIdle</type>
      <name>signal_idle</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga76792522d9680a05e232d3519a25f98d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SignalIO</type>
      <name>signal_io</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>gaf391654b755a32169d18be4835677376</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SignalChildWatch</type>
      <name>signal_child_watch</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga11ee7db80cc44ece02056a38bb049e3b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; MainContext &gt;</type>
      <name>wrap</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga043c5714afbad2745b27301dd58470a4</anchor>
      <arglist>(GMainContext *gobject, bool take_copy=false)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; MainLoop &gt;</type>
      <name>wrap</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga22ea72cda4ef327ca03fb72d6a3bea89</anchor>
      <arglist>(GMainLoop *gobject, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>MiscUtils</name>
    <title>Miscellaneous Utility Functions</title>
    <filename>group__MiscUtils.html</filename>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_application_name</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga9c2f67828083d74925b23c59ab868698</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_application_name</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga40e45835b7b461cba0f7a10fbb63c0d3</anchor>
      <arglist>(const Glib::ustring &amp;application_name)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_prgname</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga391655dededb496010eee2e92d0f1fdf</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_prgname</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga7d5c429822c09048892c4dee9c8e08c1</anchor>
      <arglist>(const std::string &amp;prgname)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>getenv</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga5e186fdb08835342a5866b11fe787ebb</anchor>
      <arglist>(const std::string &amp;variable, bool &amp;found)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>getenv</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga8e2c8f250aa7f059956737851ace08f6</anchor>
      <arglist>(const std::string &amp;variable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setenv</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga862657f21e5a930541d048a920204f59</anchor>
      <arglist>(const std::string &amp;variable, const std::string &amp;value, bool overwrite=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unsetenv</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga6fb89001630714ec9ee5244cab56343e</anchor>
      <arglist>(const std::string &amp;variable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ArrayHandle&lt; std::string &gt;</type>
      <name>listenv</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga350a5f6f1ae631f748c89d8dbe7557df</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_user_name</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga52964bfd712e8c9e688f668da51f3ed9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_real_name</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga30692e3263e66868878f535e0b7c9722</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_home_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga9412ea70c7fea058c03211dac318f8e6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_tmp_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gac42272146fd9320958132f1591d28991</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_current_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga06d93c95572d6a382b8cc4e09dd5a339</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_user_special_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gabc928a4e477df53f90e221a854cc73cb</anchor>
      <arglist>(GUserDirectory directory)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_user_data_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga821b704b5ede1583e4057990976d394b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_user_config_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gae517b931f4753abcd48adb2769a8fc48</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; std::string &gt;</type>
      <name>get_system_data_dirs</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga3a957e23dc92b928045135d4a5c6aec9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; std::string &gt;</type>
      <name>get_system_config_dirs</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga7ac473ccb6ff59400b62b9396d1b72bd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_user_cache_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gaa68121f26e82df1c293c82b89c8998e5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>path_is_absolute</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gad82525f39f7408f97f2c096c4f721b3b</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>path_skip_root</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga306eee64abc3d28993895b826f4dd533</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>path_get_basename</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga20ebf2917a7fce5d1901568017b95a35</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>path_get_dirname</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gae03457226c4239a74b83486739521434</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>build_filename</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gaa4a70bf050b3f318f87049ed30206a9a</anchor>
      <arglist>(const Glib::ArrayHandle&lt; std::string &gt; &amp;elements)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>build_filename</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gada06023cc39be3a44eb68e38d6cbea6c</anchor>
      <arglist>(const std::string &amp;elem1, const std::string &amp;elem2)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>build_filename</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gaf2be471b98cb5d47c9a30c084f87d9a7</anchor>
      <arglist>(const std::string &amp;elem1, const std::string &amp;elem2, const std::string &amp;elem3)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>build_filename</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gab342ab4856f3de7a5bc69a36773d7fb3</anchor>
      <arglist>(const std::string &amp;elem1, const std::string &amp;elem2, const std::string &amp;elem3, const std::string &amp;elem4)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>build_filename</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga95d2bc18e3b0974f909243aca9970476</anchor>
      <arglist>(const std::string &amp;elem1, const std::string &amp;elem2, const std::string &amp;elem3, const std::string &amp;elem4, const std::string &amp;elem5)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>build_filename</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga8b726f15e39f873bb0174d26d8a636a6</anchor>
      <arglist>(const std::string &amp;elem1, const std::string &amp;elem2, const std::string &amp;elem3, const std::string &amp;elem4, const std::string &amp;elem5, const std::string &amp;elem6)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>build_filename</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gaea9f342e6f620944625d48194622cdc6</anchor>
      <arglist>(const std::string &amp;elem1, const std::string &amp;elem2, const std::string &amp;elem3, const std::string &amp;elem4, const std::string &amp;elem5, const std::string &amp;elem6, const std::string &amp;elem7)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>build_filename</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga4349eeddfaee3e22194bc511d1e92873</anchor>
      <arglist>(const std::string &amp;elem1, const std::string &amp;elem2, const std::string &amp;elem3, const std::string &amp;elem4, const std::string &amp;elem5, const std::string &amp;elem6, const std::string &amp;elem7, const std::string &amp;elem8)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>build_filename</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gafb17c98037af155ff8c46499bfbc5d2d</anchor>
      <arglist>(const std::string &amp;elem1, const std::string &amp;elem2, const std::string &amp;elem3, const std::string &amp;elem4, const std::string &amp;elem5, const std::string &amp;elem6, const std::string &amp;elem7, const std::string &amp;elem8, const std::string &amp;elem9)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>build_path</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga6afc89d45cc34f3cfce4a55f3f5e7afa</anchor>
      <arglist>(const std::string &amp;separator, const Glib::ArrayHandle&lt; std::string &gt; &amp;elements)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>find_program_in_path</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gaa4c4ecb9a3eb803ae6d9dee51e1e5b14</anchor>
      <arglist>(const std::string &amp;program)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>PatternMatching</name>
    <title>Glob-style Pattern Matching</title>
    <filename>group__PatternMatching.html</filename>
    <class kind="class">Glib::PatternSpec</class>
  </compound>
  <compound kind="group">
    <name>Random</name>
    <title>Random Numbers</title>
    <filename>group__Random.html</filename>
    <class kind="class">Glib::Rand</class>
  </compound>
  <compound kind="group">
    <name>StringUtils</name>
    <title>String Utility Functions</title>
    <filename>group__StringUtils.html</filename>
    <member kind="function">
      <type>bool</type>
      <name>str_has_prefix</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga6b7e8354049756e92a97554a107618ac</anchor>
      <arglist>(const std::string &amp;str, const std::string &amp;prefix)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>str_has_suffix</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga5c4e380ffc6617ac61ca92e203e45630</anchor>
      <arglist>(const std::string &amp;str, const std::string &amp;suffix)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>strtod</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>gaa44aba9faa6575d4881b1fe779464f6b</anchor>
      <arglist>(const std::string &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>strtod</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga6465a8320d790115c41a2c76d1d3233c</anchor>
      <arglist>(const std::string &amp;str, std::string::size_type &amp;end_index, std::string::size_type start_index=0)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>dtostr</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>gac740e6c99bca5896ccbfc12b621491ac</anchor>
      <arglist>(double d)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>strescape</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga35e288b5ce34cb15eeec907421d2b77c</anchor>
      <arglist>(const std::string &amp;source)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>strescape</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>gad24f3547c8d6b3ec56d7f5805a11d6ab</anchor>
      <arglist>(const std::string &amp;source, const std::string &amp;exceptions)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>strcompress</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga85cd83bd40baf0119aac3ff0a9a5e7b2</anchor>
      <arglist>(const std::string &amp;source)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>strerror</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga1eb869894996c91c0f69dbff96714c71</anchor>
      <arglist>(int errnum)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>strsignal</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga44ce9f689aff8abe1e3073b209f360d3</anchor>
      <arglist>(int signum)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>ThreadPools</name>
    <title>Thread Pools</title>
    <filename>group__ThreadPools.html</filename>
    <class kind="class">Glib::ThreadPool</class>
  </compound>
  <compound kind="group">
    <name>glibmmValue</name>
    <title>Generic Values</title>
    <filename>group__glibmmValue.html</filename>
    <class kind="class">Glib::Value&lt; bool &gt;</class>
    <class kind="class">Glib::Value&lt; char &gt;</class>
    <class kind="class">Glib::Value&lt; unsigned char &gt;</class>
    <class kind="class">Glib::Value&lt; int &gt;</class>
    <class kind="class">Glib::Value&lt; unsigned int &gt;</class>
    <class kind="class">Glib::Value&lt; long &gt;</class>
    <class kind="class">Glib::Value&lt; unsigned long &gt;</class>
    <class kind="class">Glib::Value&lt; long long &gt;</class>
    <class kind="class">Glib::Value&lt; unsigned long long &gt;</class>
    <class kind="class">Glib::Value&lt; float &gt;</class>
    <class kind="class">Glib::Value&lt; double &gt;</class>
    <class kind="class">Glib::Value&lt; void * &gt;</class>
    <class kind="class">Glib::ValueBase</class>
    <class kind="class">Glib::ValueBase_Boxed</class>
    <class kind="class">Glib::ValueBase_Object</class>
    <class kind="class">Glib::ValueBase_Enum</class>
    <class kind="class">Glib::ValueBase_Flags</class>
    <class kind="class">Glib::ValueBase_String</class>
    <class kind="class">Glib::Value_Boxed</class>
    <class kind="class">Glib::Value&lt; Glib::RefPtr&lt; T &gt; &gt;</class>
    <class kind="class">Glib::Value&lt; Glib::RefPtr&lt; const T &gt; &gt;</class>
    <class kind="class">Glib::Value&lt; std::string &gt;</class>
    <class kind="class">Glib::Value&lt; Glib::ustring &gt;</class>
    <class kind="class">Glib::Value_Enum</class>
    <class kind="class">Glib::Value_Flags</class>
    <class kind="class">Glib::Value_Pointer</class>
    <class kind="class">Glib::Value</class>
    <class kind="class">Glib::Value&lt; T * &gt;</class>
    <class kind="class">Glib::Value&lt; const T * &gt;</class>
  </compound>
  <compound kind="group">
    <name>Streams</name>
    <title>Stream Classes</title>
    <filename>group__Streams.html</filename>
    <class kind="class">Gio::BufferedInputStream</class>
    <class kind="class">Gio::BufferedOutputStream</class>
    <class kind="class">Gio::DataInputStream</class>
    <class kind="class">Gio::DataOutputStream</class>
    <class kind="class">Gio::FileInputStream</class>
    <class kind="class">Gio::FileIOStream</class>
    <class kind="class">Gio::FileOutputStream</class>
    <class kind="class">Gio::FilterInputStream</class>
    <class kind="class">Gio::FilterOutputStream</class>
    <class kind="class">Gio::InputStream</class>
    <class kind="class">Gio::IOStream</class>
    <class kind="class">Gio::MemoryInputStream</class>
    <class kind="class">Gio::MemoryOutputStream</class>
    <class kind="class">Gio::Mount</class>
    <class kind="class">Gio::OutputStream</class>
    <class kind="class">Gio::Seekable</class>
    <class kind="class">Gio::UnixInputStream</class>
    <class kind="class">Gio::UnixOutputStream</class>
  </compound>
  <compound kind="group">
    <name>DBus</name>
    <title>D-Bus API</title>
    <filename>group__DBus.html</filename>
    <class kind="class">Gio::DBus::AuthObserver</class>
    <class kind="class">Gio::DBus::Connection</class>
    <class kind="class">Gio::DBus::InterfaceVTable</class>
    <class kind="class">Gio::DBus::AnnotationInfo</class>
    <class kind="class">Gio::DBus::ArgInfo</class>
    <class kind="class">Gio::DBus::MethodInfo</class>
    <class kind="class">Gio::DBus::SignalInfo</class>
    <class kind="class">Gio::DBus::PropertyInfo</class>
    <class kind="class">Gio::DBus::InterfaceInfo</class>
    <class kind="class">Gio::DBus::NodeInfo</class>
    <class kind="class">Gio::DBus::Message</class>
    <class kind="class">Gio::DBus::MethodInvocation</class>
    <class kind="class">Gio::DBus::Proxy</class>
    <class kind="class">Gio::DBus::Server</class>
    <class kind="class">Gio::DBus::SubtreeVTable</class>
    <member kind="typedef">
      <type>sigc::slot&lt; void, const Glib::RefPtr&lt; Gio::DBus::Connection &gt; &amp;, Glib::ustring &gt;</type>
      <name>SlotBusAcquired</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga92ddf71b4fad230b88f53f0bd51cf9ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; void, const Glib::RefPtr&lt; Gio::DBus::Connection &gt; &amp;, Glib::ustring &gt;</type>
      <name>SlotNameAcquired</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>gaa9752b9e34e82802372d543be19e835d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; void, const Glib::RefPtr&lt; Gio::DBus::Connection &gt; &amp;, Glib::ustring &gt;</type>
      <name>SlotNameLost</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga6191db7ad78e8398c1193b9e78b9a9e8</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; void, const Glib::RefPtr&lt; Gio::DBus::Connection &gt; &amp;, Glib::ustring, const Glib::ustring &amp; &gt;</type>
      <name>SlotNameAppeared</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga86bd32cfdf2b9f3ef20ed287c8fc58b7</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; void, const Glib::RefPtr&lt; Gio::DBus::Connection &gt; &amp;, Glib::ustring &gt;</type>
      <name>SlotNameVanished</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>gadb9a09c6a42e777238421f74c82a631b</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_address</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>gab2c056ac3cce34b4a58df19166d48fae</anchor>
      <arglist>(const std::string &amp;string)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_supported</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga2f8d4a3d5bda1d3fcc4f4f3c8cc0c214</anchor>
      <arglist>(const std::string &amp;address)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_stream</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga2d53e540686789c834cef9a3ac447bf4</anchor>
      <arglist>(const std::string &amp;address, const SlotAsyncReady slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; IOStream &gt;</type>
      <name>get_stream_finish</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga8fa5586dec918dfa553dab97f0f8e342</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;res, std::string &amp;out_guid)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; IOStream &gt;</type>
      <name>get_stream_finish</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga7da9ac3910fa800a6a42b2667b1a0135</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;res)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; IOStream &gt;</type>
      <name>get_stream_sync</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga95b08ddb9dedf51b585fa7a5da4f4233</anchor>
      <arglist>(const std::string &amp;address, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, std::string &amp;out_guid)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; IOStream &gt;</type>
      <name>get_stream_sync</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>gaec661c3dff45b4a5626b9dc1bc586b3d</anchor>
      <arglist>(const std::string &amp;address, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_for_bus_sync</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga3acef7d113b30124fe11e88c2d2a60a4</anchor>
      <arglist>(BusType bus_type, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_remote_error</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga2b6d40f35340690128b06b289388d120</anchor>
      <arglist>(const Glib::Error &amp;error)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_remote_error</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga94461b5c18260b017f3404d82ad5321a</anchor>
      <arglist>(const Glib::Error &amp;error)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>strip_remote_error</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga2f38119e0765fd1654363fcdee6e4c76</anchor>
      <arglist>(Glib::Error &amp;error)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>own_name</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga6e63011eb298f04364d38d44ae51d1e5</anchor>
      <arglist>(BusType bus_type, const Glib::ustring &amp;name, const SlotBusAcquired &amp;bus_acquired_slot=SlotBusAcquired(), const SlotNameAcquired &amp;name_acquired_slot=SlotNameAcquired(), const SlotNameLost &amp;name_lost_slot=SlotNameLost(), BusNameOwnerFlags flags=Gio::DBus::BUS_NAME_OWNER_FLAGS_NONE)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>generate_guid</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga1f11b499bbff8835c429c0fd534df4b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_guid</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>gaf95791c56c136194a67f3855a4416966</anchor>
      <arglist>(const std::string &amp;string)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_name</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga05c67dee67b2ccccdcb0c19714abd5e1</anchor>
      <arglist>(const Glib::ustring &amp;string)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_unique_name</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga04c3f3efa55c252ce9299a934f3bc9ed</anchor>
      <arglist>(const Glib::ustring &amp;string)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_member_name</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga2383c7d151a59adc91e4fbfbd1e4652a</anchor>
      <arglist>(const Glib::ustring &amp;string)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_interface_name</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>gaf8f12ce74f2521c357d814a0105359ea</anchor>
      <arglist>(const Glib::ustring &amp;string)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>watch_name</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>gaa202af27755f2ea8d0736f8ab3a75dba</anchor>
      <arglist>(BusType bus_type, const Glib::ustring &amp;name, const SlotNameAppeared &amp;name_appeared_slot=SlotNameAppeared(), const SlotNameVanished &amp;name_vanished_slot=SlotNameVanished(), BusNameWatcherFlags flags=Gio::DBus::BUS_NAME_WATCHER_FLAGS_NONE)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>watch_name</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>gaf07c31497172ba813b9322dad4570927</anchor>
      <arglist>(const Glib::RefPtr&lt; Connection &gt; &amp;connection, const Glib::ustring &amp;name, const SlotNameAppeared &amp;name_appeared_slot=SlotNameAppeared(), const SlotNameVanished &amp;name_vanished_slot=SlotNameVanished(), BusNameWatcherFlags flags=Gio::DBus::BUS_NAME_WATCHER_FLAGS_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unwatch_name</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>gaa5106315b09d6fc5ad019ecfcc8d5342</anchor>
      <arglist>(guint watcher_id)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>NetworkIO</name>
    <title>Portable Network I/O Functionality</title>
    <filename>group__NetworkIO.html</filename>
    <class kind="class">Gio::InetAddress</class>
    <class kind="class">Gio::InetSocketAddress</class>
    <class kind="class">Gio::NetworkAddress</class>
    <class kind="class">Gio::NetworkService</class>
    <class kind="class">Gio::Proxy</class>
    <class kind="class">Gio::ProxyAddress</class>
    <class kind="class">Gio::ProxyResolver</class>
    <class kind="class">Gio::Resolver</class>
    <class kind="class">Gio::Socket</class>
    <class kind="class">Gio::SocketAddress</class>
    <class kind="class">Gio::SocketAddressEnumerator</class>
    <class kind="class">Gio::SocketClient</class>
    <class kind="class">Gio::SocketConnectable</class>
    <class kind="class">Gio::SocketConnection</class>
    <class kind="class">Gio::SocketControlMessage</class>
    <class kind="class">Gio::SocketListener</class>
    <class kind="class">Gio::SocketService</class>
    <class kind="class">Gio::SrvTarget</class>
    <class kind="class">Gio::TcpConnection</class>
    <class kind="class">Gio::ThreadedSocketService</class>
    <class kind="class">Gio::UnixConnection</class>
    <class kind="class">Gio::UnixCredentialsMessage</class>
    <class kind="class">Gio::UnixFDList</class>
    <class kind="class">Gio::UnixFDMessage</class>
    <class kind="class">Gio::UnixSocketAddress</class>
    <class kind="class">Gio::SignalSocket</class>
    <class kind="class">Gio::SocketSource</class>
    <member kind="function">
      <type>SignalSocket</type>
      <name>signal_socket</name>
      <anchorfile>group__NetworkIO.html</anchorfile>
      <anchor>ga73dc3243f51abce0a62424329724f510</anchor>
      <arglist>(const Glib::RefPtr&lt; Glib::MainContext &gt; &amp;context=Glib::RefPtr&lt; Glib::MainContext &gt;())</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>giommContentType</name>
    <title>Platform-specific content typing</title>
    <filename>group__giommContentType.html</filename>
    <member kind="function">
      <type>bool</type>
      <name>content_type_equals</name>
      <anchorfile>group__giommContentType.html</anchorfile>
      <anchor>ga496c304f10ea79f1a20137bf614466e8</anchor>
      <arglist>(const Glib::ustring &amp;type1, const Glib::ustring &amp;type2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>content_type_is_a</name>
      <anchorfile>group__giommContentType.html</anchorfile>
      <anchor>ga278fca288c7c2e9995ebb64ce43a6ffd</anchor>
      <arglist>(const Glib::ustring &amp;type, const Glib::ustring &amp;supertype)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>content_type_is_unknown</name>
      <anchorfile>group__giommContentType.html</anchorfile>
      <anchor>gaee153086e7cd9f1ab0509cbf81ec06e9</anchor>
      <arglist>(const Glib::ustring &amp;type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>content_type_get_description</name>
      <anchorfile>group__giommContentType.html</anchorfile>
      <anchor>gac065cb89d7abb5935cfa225e3d41a732</anchor>
      <arglist>(const Glib::ustring &amp;type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>content_type_get_mime_type</name>
      <anchorfile>group__giommContentType.html</anchorfile>
      <anchor>ga92f379d45658e14f3ec1bec3da71d908</anchor>
      <arglist>(const Glib::ustring &amp;type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>content_type_get_icon</name>
      <anchorfile>group__giommContentType.html</anchorfile>
      <anchor>ga7972eb82466bf972bbbf5b58f6344e84</anchor>
      <arglist>(const Glib::ustring &amp;type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>content_type_get_symbolic_icon</name>
      <anchorfile>group__giommContentType.html</anchorfile>
      <anchor>gab55b0d4ac98b1aa0edab98afa66a8b6c</anchor>
      <arglist>(const Glib::ustring &amp;type)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>content_type_can_be_executable</name>
      <anchorfile>group__giommContentType.html</anchorfile>
      <anchor>gae5107c4e00134d7d9df3b755a74f9494</anchor>
      <arglist>(const Glib::ustring &amp;type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>content_type_from_mime_type</name>
      <anchorfile>group__giommContentType.html</anchorfile>
      <anchor>gad5432d8f8c8ba74f8157af9d49930b4c</anchor>
      <arglist>(const Glib::ustring &amp;mime_type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>content_type_guess</name>
      <anchorfile>group__giommContentType.html</anchorfile>
      <anchor>ga48e8afbb7f1724efcdebd7c028da5560</anchor>
      <arglist>(const std::string &amp;filename, const guchar *data, gsize data_size, bool &amp;result_uncertain)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>content_type_guess</name>
      <anchorfile>group__giommContentType.html</anchorfile>
      <anchor>gae46acc46aa5c33a8d1feda6a675fefa9</anchor>
      <arglist>(const std::string &amp;filename, const std::string &amp;data, bool &amp;result_uncertain)</arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>content_type_guess_for_tree</name>
      <anchorfile>group__giommContentType.html</anchorfile>
      <anchor>ga7e82e215c402edca50219020e43d08ec</anchor>
      <arglist>(const Glib::RefPtr&lt; const File &gt; &amp;root)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::ustring &gt;</type>
      <name>content_types_get_registered</name>
      <anchorfile>group__giommContentType.html</anchorfile>
      <anchor>gaeae6cd7ee77a7b1c52443116f346b476</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>glibmmEnums</name>
    <title>glibmm Enums and Flags</title>
    <filename>group__glibmmEnums.html</filename>
    <member kind="enumeration">
      <type></type>
      <name>TraverseType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gae3a70fa1e451da068323419e8c98e9a9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TRAVERSE_IN_ORDER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggae3a70fa1e451da068323419e8c98e9a9aa7f260b474a886df2bf1aefcfc0f14b2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TRAVERSE_PRE_ORDER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggae3a70fa1e451da068323419e8c98e9a9abed8efe71581ccb087323f38b6807661</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TRAVERSE_POST_ORDER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggae3a70fa1e451da068323419e8c98e9a9a0af70e322b94dfbbfc98b100d21cef4e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TRAVERSE_LEVEL_ORDER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggae3a70fa1e451da068323419e8c98e9a9a16cd819f4ab8175453f6287aeefad870</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>TraverseFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gad11179d39a4991e5b09f145d594a450e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TRAVERSE_LEAVES</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggad11179d39a4991e5b09f145d594a450ea7da8793fdd0c433870a5e6c2e3152898</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TRAVERSE_NON_LEAVES</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggad11179d39a4991e5b09f145d594a450ea6473ae1f054172ae349d01003fabf37f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TRAVERSE_ALL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggad11179d39a4991e5b09f145d594a450ea1be75d605b0c93ca7932110467536670</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TRAVERSE_MASK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggad11179d39a4991e5b09f145d594a450ea6832c7b45443db4eed6f4cfbd3c04b69</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>AsciiType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga2e5a690ed07dfaa6f9ad9f1c57acd787</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ASCII_ALNUM</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787af7d63a99479102b5391b44f631b5f009</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ASCII_ALPHA</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787ac87947c729ac3c3f9f58b0ca28460152</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ASCII_CNTRL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a2e19c57ce5a6eac38d911a86cc44a2fb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ASCII_DIGIT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a9acd9a82d0670a3eb0377db782f48853</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ASCII_GRAPH</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a2ecdbe5137af423fce73ff2bbb34d625</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ASCII_LOWER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a875d3cb7494e1548db0d37ab44d4057e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ASCII_PRINT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a9b1775043a8043d994c0c0ab890e86c4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ASCII_PUNCT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787ad3416d8662560db626259013ff72c58f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ASCII_SPACE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a7d7a68814efba3cf3d294475123413ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ASCII_UPPER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a5ae30681069b2ab88eed13e358c08090</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ASCII_XDIGIT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787ad78490a35d65839f2f06449e7e472337</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>OptionType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gabd6606988f30170f2e53b2b121f2b219</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>OPTION_TYPE_BOOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggabd6606988f30170f2e53b2b121f2b219a31b0b3d2951ef1533e8a2775db79250e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>OPTION_TYPE_STRING</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggabd6606988f30170f2e53b2b121f2b219a018d6130d8f46e1dbdf7db263c54d05e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>OPTION_TYPE_INT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggabd6606988f30170f2e53b2b121f2b219ab5f2e456b9c5bd209c872b11a878d29b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>OPTION_TYPE_FILENAME</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggabd6606988f30170f2e53b2b121f2b219aa24cb753e2b6aa5411bbc242217935ff</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>OPTION_TYPE_STRING_VECTOR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggabd6606988f30170f2e53b2b121f2b219adc4a9ed1661944d8301d372708915d78</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>OPTION_TYPE_FILENAME_VECTOR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggabd6606988f30170f2e53b2b121f2b219a9f3ccf0b9217a0d5380bc97d11117c58</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>OPTION_TYPE_DOUBLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggabd6606988f30170f2e53b2b121f2b219a320a43020a59acf7a724177a30d0265e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>OPTION_TYPE_INT64</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggabd6606988f30170f2e53b2b121f2b219ae4ceecbbf5f1e343ca896fcd442d707f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>ChecksumType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga5d1c13a9d5c34bff7dd1e74654f282eb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CHECKSUM_MD5</name>
      <anchorfile>classGlib_1_1Checksum.html</anchorfile>
      <anchor>ga5d1c13a9d5c34bff7dd1e74654f282ebaa22d278286ecebcc3bc58636a1aa909d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CHECKSUM_SHA1</name>
      <anchorfile>classGlib_1_1Checksum.html</anchorfile>
      <anchor>ga5d1c13a9d5c34bff7dd1e74654f282ebab2258b031ebb9a20477f4d564ac26e52</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CHECKSUM_SHA256</name>
      <anchorfile>classGlib_1_1Checksum.html</anchorfile>
      <anchor>ga5d1c13a9d5c34bff7dd1e74654f282ebadc95ea210a79482241022fd0bb19c957</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CHECKSUM_SHA512</name>
      <anchorfile>classGlib_1_1Checksum.html</anchorfile>
      <anchor>ga5d1c13a9d5c34bff7dd1e74654f282eba7a4ed07c4b7a43431ac773c8485f871a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>Month</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga9781abc52ad49766808898743e44031f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>BAD_MONTH</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>ga9781abc52ad49766808898743e44031fab42b19485c354997ff99d0280d8883bc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>JANUARY</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>ga9781abc52ad49766808898743e44031fa41f162c224a741223ef2a282a22f7612</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FEBRUARY</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>ga9781abc52ad49766808898743e44031fa6e58a73346cb200c19e1a2e8c6766c68</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MARCH</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>ga9781abc52ad49766808898743e44031faa6f580fd1bf61b898baa203eab425ef9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>APRIL</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>ga9781abc52ad49766808898743e44031fa1ae9ac1173f8c33acd183f4af21503e2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MAY</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>ga9781abc52ad49766808898743e44031fa8cb59e2c5f3f4c407f839648428e781b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>JUNE</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>ga9781abc52ad49766808898743e44031fa45b980fffd2bca9caa454c0ff22d4668</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>JULY</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>ga9781abc52ad49766808898743e44031fa79d02809a794bfff2a3fee86d9029b68</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>AUGUST</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>ga9781abc52ad49766808898743e44031fa0f91e886e724ba8b2b78c4c109608806</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SEPTEMBER</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>ga9781abc52ad49766808898743e44031fa6bb760f0b99884e88b05dd45361a8e36</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>OCTOBER</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>ga9781abc52ad49766808898743e44031fad88f29a9fe61914cfba985c0d99caaf8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NOVEMBER</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>ga9781abc52ad49766808898743e44031fa8d76aafc0a7ccce22e224702332c02f5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DECEMBER</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>ga9781abc52ad49766808898743e44031fa707720b95b5565ecc2082487cda63936</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>Weekday</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga073c9f49a289b2036eb226bcdf16a2f1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>BAD_WEEKDAY</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>ga073c9f49a289b2036eb226bcdf16a2f1a209441f7cd5e544bd8715ebbd53cb578</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MONDAY</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>ga073c9f49a289b2036eb226bcdf16a2f1aa910eb464873ddd2ac4b3f2975796275</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TUESDAY</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>ga073c9f49a289b2036eb226bcdf16a2f1ad096dfc005da0574f708365aca840edd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>WEDNESDAY</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>ga073c9f49a289b2036eb226bcdf16a2f1a6893621fdc75f8d2f9ab4aadbf00f94e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>THURSDAY</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>ga073c9f49a289b2036eb226bcdf16a2f1a94dc5538b8f75d17020925c582c66f88</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FRIDAY</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>ga073c9f49a289b2036eb226bcdf16a2f1a94ba4c5d515872decaf2986ca953a8d7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SATURDAY</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>ga073c9f49a289b2036eb226bcdf16a2f1acad9946c6af8b8132a6264e14b5b51cc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SUNDAY</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>ga073c9f49a289b2036eb226bcdf16a2f1a3fac85ddb897babe92ad1888cd325742</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>DMY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gac803072d86bbc2ce1f7d558c94f41ae1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DAY</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>gac803072d86bbc2ce1f7d558c94f41ae1a560fa4f9a4733a4c043b3f279610f9d3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MONTH</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>gac803072d86bbc2ce1f7d558c94f41ae1aba581b678d9b703faa5db3eb0d1713d2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>YEAR</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>gac803072d86bbc2ce1f7d558c94f41ae1a9f9e923dc13c924a74987cf00250674e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>FileTest</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga33c24ccefbd130021f06708763e16ef2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_TEST_IS_REGULAR</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga33c24ccefbd130021f06708763e16ef2ad7bb008269376841fe11c05da9c01a55</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_TEST_IS_SYMLINK</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga33c24ccefbd130021f06708763e16ef2ae9fcdfcc6fc6ee7bb83ce9634e5e9f18</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_TEST_IS_DIR</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga33c24ccefbd130021f06708763e16ef2ae4072d5338587b51642d1a68c730ec19</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_TEST_IS_EXECUTABLE</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga33c24ccefbd130021f06708763e16ef2ae236ad1999c8c106a5ff31154ebd5692</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_TEST_EXISTS</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga33c24ccefbd130021f06708763e16ef2aa6cf22c3904f707c94f2ad911b5df6fd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>SeekType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaa3767731311bdba4ef42dc99215e5cda</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SEEK_TYPE_CUR</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gaa3767731311bdba4ef42dc99215e5cdaac0fc030f79f4b5623de9867333011e30</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SEEK_TYPE_SET</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gaa3767731311bdba4ef42dc99215e5cdaaa8e02688f42163a11bb8b47a72456bc4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SEEK_TYPE_END</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gaa3767731311bdba4ef42dc99215e5cdaa615f7b38be2cbd60fe5fbebd656f38bd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>IOStatus</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga23fb251e48485b62a9c2677bb1f87d5e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_STATUS_ERROR</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga23fb251e48485b62a9c2677bb1f87d5eabf1fa62d0111ab895ecb887ce6cce1c4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_STATUS_NORMAL</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga23fb251e48485b62a9c2677bb1f87d5eaf2008e64a9691fc76ad9320baef5c8ba</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_STATUS_EOF</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga23fb251e48485b62a9c2677bb1f87d5ea63be2a355cd7187f9ccdd854c80fd10c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_STATUS_AGAIN</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga23fb251e48485b62a9c2677bb1f87d5ead240a3a0fd203dd76e11b76a8115d881</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>IOFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaee093e5db5bc1ea5738771ba0d1af3b7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_FLAG_APPEND</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gaee093e5db5bc1ea5738771ba0d1af3b7a0eddd66348cb8ec7aceef67736d59cce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_FLAG_NONBLOCK</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gaee093e5db5bc1ea5738771ba0d1af3b7a1a71350ea4fc4f9779a3a884f6977269</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_FLAG_IS_READABLE</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gaee093e5db5bc1ea5738771ba0d1af3b7a45c527b36c1a1df9b5b1202f84eafeed</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_FLAG_IS_WRITABLE</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gaee093e5db5bc1ea5738771ba0d1af3b7a0632918f94e302c0b20e722e941ad124</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_FLAG_IS_WRITEABLE</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gaee093e5db5bc1ea5738771ba0d1af3b7af9738e0234ae1d1f15c4512d6edb16db</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_FLAG_IS_SEEKABLE</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gaee093e5db5bc1ea5738771ba0d1af3b7a65e5b54c7fad833478ed9cc169cc15be</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_FLAG_MASK</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gaee093e5db5bc1ea5738771ba0d1af3b7a26bca9503544a0e4388041812e3ea1e7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_FLAG_GET_MASK</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gaee093e5db5bc1ea5738771ba0d1af3b7a06c9ef83e6adc8a4b4ea98dd396e2206</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_FLAG_SET_MASK</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gaee093e5db5bc1ea5738771ba0d1af3b7a31bd353961673e2199474810e2ff3ff0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>IOCondition</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gabd96381793b70d4ae32c725926990918</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_IN</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gabd96381793b70d4ae32c725926990918aa38ee764d957d52ccd85688c27778daf</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_OUT</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gabd96381793b70d4ae32c725926990918a0945b81e85eb8d2d26e77fdc04821cae</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_PRI</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gabd96381793b70d4ae32c725926990918ac8998d8c99453ea30c1ba129f89ec5a0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERR</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gabd96381793b70d4ae32c725926990918a1798f7312c98ff12681ed93f1b08f0d7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_HUP</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gabd96381793b70d4ae32c725926990918aa290fc1a996ead6c153515d4771fcdb1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_NVAL</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gabd96381793b70d4ae32c725926990918aadf52e698f361e79b53f0bcb3266df24</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>KeyFileFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga5866be36312563d91e5a7be27348459b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>KEY_FILE_NONE</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga5866be36312563d91e5a7be27348459baec458bae700a8dfd34898a5ab5b22d3b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>KEY_FILE_KEEP_COMMENTS</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga5866be36312563d91e5a7be27348459ba27ebf6c0c9a771f0268f7b06fe7e0347</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>KEY_FILE_KEEP_TRANSLATIONS</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga5866be36312563d91e5a7be27348459ba498ea5abdc02d9a60db9a0d2873f5c58</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>ParseFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaa4fcaf917b6eb2aa085817e83b0a4108</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DO_NOT_USE_THIS_UNSUPPORTED_FLAG</name>
      <anchorfile>namespaceGlib_1_1Markup.html</anchorfile>
      <anchor>gaa4fcaf917b6eb2aa085817e83b0a4108a3f48cb56dd56d529c9379ae244441e90</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TREAT_CDATA_AS_TEXT</name>
      <anchorfile>namespaceGlib_1_1Markup.html</anchorfile>
      <anchor>gaa4fcaf917b6eb2aa085817e83b0a4108adc8bc2a2d501a339db31b5e3a8351646</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PREFIX_ERROR_POSITION</name>
      <anchorfile>namespaceGlib_1_1Markup.html</anchorfile>
      <anchor>gaa4fcaf917b6eb2aa085817e83b0a4108aad5bd1990be534b2dc3a73f69b283114</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IGNORE_QUALIFIED</name>
      <anchorfile>namespaceGlib_1_1Markup.html</anchorfile>
      <anchor>gaa4fcaf917b6eb2aa085817e83b0a4108ab6113dcacb1e8b362936ef34c7bbf301</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>ModuleFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga502283ffbe523adf38c69905ec8640f3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MODULE_BIND_LAZY</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga502283ffbe523adf38c69905ec8640f3af7dfb341de1af451a3fc28d8c13e4593</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MODULE_BIND_LOCAL</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga502283ffbe523adf38c69905ec8640f3a61ed78ca3b7464b163e43240a4fffa96</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MODULE_BIND_MASK</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga502283ffbe523adf38c69905ec8640f3ab1bb8b50aaab642b5abfcddac8d7806b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>RegexCompileFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaaaedee3e1374af9f1d66ccd34252a68d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REGEX_CASELESS</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gaaaedee3e1374af9f1d66ccd34252a68da4e6c0b8e730db041fc8d1261c2932a7f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REGEX_MULTILINE</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gaaaedee3e1374af9f1d66ccd34252a68dab11968f7c699f48954c586063dc83226</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REGEX_DOTALL</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gaaaedee3e1374af9f1d66ccd34252a68daa30cd6e3af26544676c5c05578f3701f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REGEX_EXTENDED</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gaaaedee3e1374af9f1d66ccd34252a68dae4955dc52d3f93f46fa7b894689bb9dd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REGEX_ANCHORED</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gaaaedee3e1374af9f1d66ccd34252a68da242c71a1c506054daae47559a087885d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REGEX_DOLLAR_ENDONLY</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gaaaedee3e1374af9f1d66ccd34252a68da6a311ea6eb4cd26d46bef76a4ecd70d3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REGEX_UNGREEDY</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gaaaedee3e1374af9f1d66ccd34252a68dad3d43ecb091918275855d44bf137432c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REGEX_RAW</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gaaaedee3e1374af9f1d66ccd34252a68da9aaaffdaa133f45d7412af35ad17b29e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REGEX_NO_AUTO_CAPTURE</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gaaaedee3e1374af9f1d66ccd34252a68da98b6d7f319fcee7ae0c1b9e8dc146869</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REGEX_OPTIMIZE</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gaaaedee3e1374af9f1d66ccd34252a68daefe22a8d4297013ffcef77b83c40bf94</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REGEX_FIRSTLINE</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gaaaedee3e1374af9f1d66ccd34252a68da4d72c42c744da757f5b4e8760933e355</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REGEX_DUPNAMES</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gaaaedee3e1374af9f1d66ccd34252a68dad96b981e024568febb07d7f237950a15</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REGEX_NEWLINE_CR</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gaaaedee3e1374af9f1d66ccd34252a68da8743e2fb6fc70c8bbf53a025442a9f31</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REGEX_NEWLINE_LF</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gaaaedee3e1374af9f1d66ccd34252a68da18bf3b48001c90a1aefca35dd9bd832b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REGEX_NEWLINE_CRLF</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gaaaedee3e1374af9f1d66ccd34252a68da31810ab9b1612d3dafbb86d164ea783c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REGEX_NEWLINE_ANYCRLF</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gaaaedee3e1374af9f1d66ccd34252a68da6c4921ffcc04c53566d6bfe89fcf78b6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REGEX_BSR_ANYCRLF</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gaaaedee3e1374af9f1d66ccd34252a68da9fbe4801ca6fcae969a84c16826b9393</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REGEX_JAVASCRIPT_COMPAT</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gaaaedee3e1374af9f1d66ccd34252a68da7e66bb34557aafd6de8b6119c229d9c3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>RegexMatchFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga8375c7f6797efc96929e8be89435c746</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REGEX_MATCH_ANCHORED</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga8375c7f6797efc96929e8be89435c746a6d9730749c5506b89f3085ce25c80c21</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REGEX_MATCH_NOTBOL</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga8375c7f6797efc96929e8be89435c746ae09a3a58b8d8e052a35719b4f22f937a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REGEX_MATCH_NOTEOL</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga8375c7f6797efc96929e8be89435c746ab8850a97e7a6b06b1a5c97e703be2a11</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REGEX_MATCH_NOTEMPTY</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga8375c7f6797efc96929e8be89435c746a0aaf0a3c6a7fae74d4a1a6255062ae91</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REGEX_MATCH_PARTIAL</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga8375c7f6797efc96929e8be89435c746ab8930fa357708487ef7a83350304dc2c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REGEX_MATCH_NEWLINE_CR</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga8375c7f6797efc96929e8be89435c746ae0eb9716d96049f41f5560a215ea5dab</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REGEX_MATCH_NEWLINE_LF</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga8375c7f6797efc96929e8be89435c746a51549066ff64a814d44958ce9db5243b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REGEX_MATCH_NEWLINE_CRLF</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga8375c7f6797efc96929e8be89435c746ad1536133fab0dd8e25c31c0c8555b365</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REGEX_MATCH_NEWLINE_ANY</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga8375c7f6797efc96929e8be89435c746acebebe55d6e1197e4a7e92a4fc4a999b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REGEX_MATCH_NEWLINE_ANYCRLF</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga8375c7f6797efc96929e8be89435c746aa1a18562a24484f87f73115cb3a722c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REGEX_MATCH_BSR_ANYCRLF</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga8375c7f6797efc96929e8be89435c746affaea7b025e947b22e7378bf0b6baf92</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REGEX_MATCH_BSR_ANY</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga8375c7f6797efc96929e8be89435c746a824f70cd3d882d3717d67325b96a9b3f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REGEX_MATCH_PARTIAL_SOFT</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga8375c7f6797efc96929e8be89435c746a69d773f5f7d17ef9b91bd43d545ae1c1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REGEX_MATCH_PARTIAL_HARD</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga8375c7f6797efc96929e8be89435c746a1d2d11e330bc91e85a50e01445288b3f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REGEX_MATCH_NOTEMPTY_ATSTART</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga8375c7f6797efc96929e8be89435c746aea0015d4a3887504f16321a0f960241f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>SpawnFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga075918988c271e7fb63f1a1d083e26dd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SPAWN_DEFAULT</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga075918988c271e7fb63f1a1d083e26dda4198b367b82bc1adf3469423da582663</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SPAWN_LEAVE_DESCRIPTORS_OPEN</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga075918988c271e7fb63f1a1d083e26dda3b30d87840df513617bd468c750e52c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SPAWN_DO_NOT_REAP_CHILD</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga075918988c271e7fb63f1a1d083e26dda8ba0abbaa6e1907446857439f454ced1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SPAWN_SEARCH_PATH</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga075918988c271e7fb63f1a1d083e26dda7d76ee852f6b00ffaef373f3d595139f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SPAWN_STDOUT_TO_DEV_NULL</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga075918988c271e7fb63f1a1d083e26dda7a8c2616db1e6ef21f063652fd60872e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SPAWN_STDERR_TO_DEV_NULL</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga075918988c271e7fb63f1a1d083e26dda198a2b8f3ce92dce5a1117d1c2dac345</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SPAWN_CHILD_INHERITS_STDIN</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga075918988c271e7fb63f1a1d083e26ddaeb1c843fc647e28134cd3e7fa259f285</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SPAWN_FILE_AND_ARGV_ZERO</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga075918988c271e7fb63f1a1d083e26ddaead6dad17dda98e0196495dd11d62cd7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SPAWN_SEARCH_PATH_FROM_ENVP</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga075918988c271e7fb63f1a1d083e26dda876ee150dd220b4808c2f9ecab5dc0f6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SPAWN_CLOEXEC_PIPES</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga075918988c271e7fb63f1a1d083e26ddace745e1ccff2497f03ea638316abe076</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>TimeType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga56a2fdf6fb8599b99302868a176aac43</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TIME_TYPE_STANDARD</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga56a2fdf6fb8599b99302868a176aac43ae6b2b23e160971f7487d630c1fa8cf70</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TIME_TYPE_DAYLIGHT</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga56a2fdf6fb8599b99302868a176aac43a08bb0503339270dd7bf04c3406cf60c1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TIME_TYPE_UNIVERSAL</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga56a2fdf6fb8599b99302868a176aac43a88ad6264677876bc7203353a1cf45391</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>UnicodeType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_CONTROL</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46ea600cfdae816c0d120e6e3e4a32d5d9cb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_FORMAT</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46ea5b522871761887006148af4734e84875</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_UNASSIGNED</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46ea6e8a7e7b5ce23cd99d30f4ab7b672efd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_PRIVATE_USE</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46ea4d8e2c9e7eb9ab4352d6e4b6699267f9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_SURROGATE</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46ea69161af321691d504ec819bb9c19b808</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_LOWERCASE_LETTER</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46eaab14707b2ffc2073a6d770ecd70ae321</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_MODIFIER_LETTER</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46ea7bfc1c73f50fa8c69224e0df70b0b14b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_OTHER_LETTER</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46ea146261fc855eb4e65cdfb86886bdedf7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_TITLECASE_LETTER</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46ea3f43a11337d15c6050fc1ef0e2da75b6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_UPPERCASE_LETTER</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46ea43db8de276cdf9f23e23a8661456ff4d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_SPACING_MARK</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46eac73f211f2caa9d82027985cb8b549cf3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_ENCLOSING_MARK</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46ea9a7db30781bd0d0a61374fd261944e07</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_NON_SPACING_MARK</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46ea09f4af19dd4a3d3d0f10369f8b8afda2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_DECIMAL_NUMBER</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46eaf93e0b2714dcd443d48e246768a8da9e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_LETTER_NUMBER</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46ea09e6ab53938abe6c9c2d8981f137e5e3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_OTHER_NUMBER</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46ea05027699449d2ff55d446fa7572a8c5b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_CONNECT_PUNCTUATION</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46ea32edc36db8c13121a39dc416b22f822a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_DASH_PUNCTUATION</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46eab3b75b13d04b7ef056e72f798dae0e3c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_CLOSE_PUNCTUATION</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46ea0d4f41955bed4fddc7855ce714e1f957</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_FINAL_PUNCTUATION</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46ea90fff8c0bd976f3592629074fa3e801f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_INITIAL_PUNCTUATION</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46eace6196e830393b5497bfbfd6501680a0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_OTHER_PUNCTUATION</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46ea1ded1d0a0b6e5936e8a3ecd123f66869</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_OPEN_PUNCTUATION</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46ea14677d2ca9b5a1354f7460de17579daa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_CURRENCY_SYMBOL</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46eae75f8f34e79ffe86801984519eb40e6f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_MODIFIER_SYMBOL</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46ea3b6b351ca86d8095ada1d6a32e758d7a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_MATH_SYMBOL</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46eac35f3c4aa05eca14835c22a4c6a56acf</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_OTHER_SYMBOL</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46ea85c851b5804ed262ed84c2d5bc59aa1c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_LINE_SEPARATOR</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46ea2a65c1eb916c613c404eea150eac93ee</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_PARAGRAPH_SEPARATOR</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46eac808b6d7ba1f9cbb28bc0a255578085b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_SPACE_SEPARATOR</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46eabf9e349217923adfb3baef8135756118</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>UnicodeBreakType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0ea</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_MANDATORY</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaaade2215e9c2207518154a283bebb5c3b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_CARRIAGE_RETURN</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaa48ba653f60f909e05dd9b650970ecc1e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_LINE_FEED</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaab556cd8a4eaa5d766b3e49591ffae8b0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_COMBINING_MARK</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaa3f8c62e980013b2e44027ef9c34ce5c8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_SURROGATE</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaaa47bd54d2aef8bd0e52c07e8abbb65f9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_ZERO_WIDTH_SPACE</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaa37b49337ed4ecd7f53e7c9a2817d029f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_INSEPARABLE</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaa9913f639ecf34dbe62f6610fc9c3da11</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_NON_BREAKING_GLUE</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaaab52faa88b6578ab4cd88c3095793653</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_CONTINGENT</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaa2cccec32194082ea6f93db40c4af1ca5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_SPACE</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaac623ed7dc2c0cabe23c2d69f4572b7bf</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_AFTER</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaa9729f705eea307bb7ccb0283a3a85093</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_BEFORE</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaa32422806593a1aa950f533cf6eb394a9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_BEFORE_AND_AFTER</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaa05fc37bc6f3efcf0dc74973fb967f7c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_HYPHEN</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaa1074d431136b2b556b91e682eee4a189</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_NON_STARTER</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaaeb0c44e9512fb806b9ce4991e9d50f5f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_OPEN_PUNCTUATION</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaab7df43ac603e4d7b51d52d5a701e718e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_CLOSE_PUNCTUATION</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaa80435e54ace548890b953c6395556c7e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_QUOTATION</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaaf28d5b9cddeb8bb905fcfa829f436a2c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_EXCLAMATION</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaa4ab287f55e05833854353ae861b27f5b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_IDEOGRAPHIC</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaabb30f05e59de03b80d55f021de4dd1ab</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_NUMERIC</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaaacc8824bbbaf262b7563f51afce9be15</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_INFIX_SEPARATOR</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaacf598d2b5eb2d0459d2339f2e8a9b237</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_SYMBOL</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaa1bd798c1ae867ef8879f01778ee37b1e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_ALPHABETIC</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaaecf3f2bfd41dbab74e897106fef322c3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_PREFIX</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaa7e5a7d95bc74c01ca77bd3a3446ebae3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_POSTFIX</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaa4c4fd955be2dc60284b046f8f7fae397</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_COMPLEX_CONTEXT</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaae0f8fcb8bfaaddb4f30edf642b2a6146</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_AMBIGUOUS</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaa84ce090d6c8bf46abd148573bd0e3f78</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_UNKNOWN</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaae393ca22fb6bd8b01c1012d4e3386a04</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_NEXT_LINE</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaa28a02b08d3965c0ea0f6ff763a34beac</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_WORD_JOINER</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaa968e329ae40754bed636979d27540fed</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_HANGUL_L_JAMO</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaabfa27ce91eb258c1bd72131c857669d8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_HANGUL_V_JAMO</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaaeaea498600767a8af3b41e92816faea8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_HANGUL_T_JAMO</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaaabefad2b773b963104e38fe77a03281c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_HANGUL_LV_SYLLABLE</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaaccb629a2a1bae689139c8f3cc1048b31</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_HANGUL_LVT_SYLLABLE</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaa8903e767aa9ab7445578257292d1a1e3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_CLOSE_PARANTHESIS</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaabfb13fbf5e6898e8c038bd4ade5eaa4f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_CONDITIONAL_JAPANESE_STARTER</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaa9ccab026be2a4042b441a16dc5c393ed</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_HEBREW_LETTER</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaaaddbde75b0df1eee37443c5059884f19</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNICODE_BREAK_REGIONAL_INDICATOR</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0eaadff1a8802de9de1cec52b82a9b26f515</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>NormalizeMode</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga18199b64f406e397627a4e7fc799f848</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NORMALIZE_DEFAULT</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga18199b64f406e397627a4e7fc799f848a779b5d7aebd18e4b84c5e57ad1e72510</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NORMALIZE_NFD</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga18199b64f406e397627a4e7fc799f848a81e760fdac4c57b878ba43603ed6e9d8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NORMALIZE_DEFAULT_COMPOSE</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga18199b64f406e397627a4e7fc799f848af8fec61972c5f6ab8b7e600db176ed06</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NORMALIZE_NFC</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga18199b64f406e397627a4e7fc799f848ae3887d6a5497fb144f48348af4d0c2f8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NORMALIZE_ALL</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga18199b64f406e397627a4e7fc799f848a112d77bcde45ec6eb2bf2ac29bb39697</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NORMALIZE_NFKD</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga18199b64f406e397627a4e7fc799f848a6dbd51b7381af7adf532faec482be46a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NORMALIZE_ALL_COMPOSE</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga18199b64f406e397627a4e7fc799f848abfd1d0e2d16a6ba9ef9b0855124aeeb2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NORMALIZE_NFKC</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga18199b64f406e397627a4e7fc799f848abf819c3bb24fbe163d47308cc4058640</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>ThreadPriority</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga9b87dca6496b6ad53baec9ca01318448</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>THREAD_PRIORITY_LOW</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga9b87dca6496b6ad53baec9ca01318448a035a7bdc6a5b5eae6f644ed2605e8a37</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>THREAD_PRIORITY_NORMAL</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga9b87dca6496b6ad53baec9ca01318448a6216bb25baaaca32642841ade911a92e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>THREAD_PRIORITY_HIGH</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga9b87dca6496b6ad53baec9ca01318448aef77081535e90116b203ce3b3b0fe523</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>THREAD_PRIORITY_URGENT</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ga9b87dca6496b6ad53baec9ca01318448a5b79355bbd59c508995af57e0ed39a94</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>FileTest</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga8e018d8609ba17b0f6955505a8363bf7</anchor>
      <arglist>(FileTest lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileTest</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gae652f47e7b61603b9a6b86b7251d5526</anchor>
      <arglist>(FileTest lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileTest</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga6c089f23d6bfd92e083edc75519db75e</anchor>
      <arglist>(FileTest lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileTest</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga948edadd8ee7442b83d37dc3c325f890</anchor>
      <arglist>(FileTest flags)</arglist>
    </member>
    <member kind="function">
      <type>FileTest &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga9a6f5470f667596e897f5bfbd1068283</anchor>
      <arglist>(FileTest &amp;lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileTest &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga112ada474a7aad83af2bd49403abf41e</anchor>
      <arglist>(FileTest &amp;lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileTest &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga2219c78993a5196ca2a435a18e0fc3a7</anchor>
      <arglist>(FileTest &amp;lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga0dd0a8800b6311ee8f3867eb27a72ae5</anchor>
      <arglist>(IOFlags lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga7662618e73d046d4df5eb7cce3e487f8</anchor>
      <arglist>(IOFlags lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gad61c57b0678c703e8a14230d18bacff7</anchor>
      <arglist>(IOFlags lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga548c1cb09208fef57e5d0b3c992d71b9</anchor>
      <arglist>(IOFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gac3539f6df5e0c0658726f4f0573146f9</anchor>
      <arglist>(IOFlags &amp;lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gae84d9361a6154e6b0e8d099705ad6cad</anchor>
      <arglist>(IOFlags &amp;lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga2180a5c566ced37bbeb37050d9632da9</anchor>
      <arglist>(IOFlags &amp;lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gab5937e9164f36f75ba87fd67903348d5</anchor>
      <arglist>(IOCondition lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga12928ddba0f38406f19d55547bac552b</anchor>
      <arglist>(IOCondition lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga6416bbf923045261beb85241fff8ef0d</anchor>
      <arglist>(IOCondition lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga85461947d24f306cefd2fe17999deb97</anchor>
      <arglist>(IOCondition flags)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga8269a01826f8737d98ab0d345a0004f4</anchor>
      <arglist>(IOCondition &amp;lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga11f46ad6051058eeeb34d5963a4f7c44</anchor>
      <arglist>(IOCondition &amp;lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga995d6d5d01db67af62661bcd5dfd1ad6</anchor>
      <arglist>(IOCondition &amp;lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gabac5e1493392116b118e4d1048e3fef0</anchor>
      <arglist>(KeyFileFlags lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga1827ef58fe5e85d65ff8166e51b33556</anchor>
      <arglist>(KeyFileFlags lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gacc28b21831114895abfdbae6c1908114</anchor>
      <arglist>(KeyFileFlags lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gab99ff1d7c6d96da2ddfcfd1c4954e9b6</anchor>
      <arglist>(KeyFileFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga7096a34594825c90d7b6257935a62eb1</anchor>
      <arglist>(KeyFileFlags &amp;lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga80dd56fcaea8bc3f0a5f21b9d3049877</anchor>
      <arglist>(KeyFileFlags &amp;lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gac90869f74a743e2f99f55708c28a585d</anchor>
      <arglist>(KeyFileFlags &amp;lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ParseFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga330303c9d78eb78547012d549d4bb018</anchor>
      <arglist>(ParseFlags lhs, ParseFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ParseFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga421021254296cdba48ec178a54fe93d9</anchor>
      <arglist>(ParseFlags lhs, ParseFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ParseFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gab059cb7acda2b29eb2066958fc71951a</anchor>
      <arglist>(ParseFlags lhs, ParseFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ParseFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga1fb97b62ae844c056b400e2813a21ee2</anchor>
      <arglist>(ParseFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>ParseFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga6b24d718f166cb352be94ee6e4090296</anchor>
      <arglist>(ParseFlags &amp;lhs, ParseFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ParseFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga2a7b1137fa0d9495cdb5f46ec564a2ba</anchor>
      <arglist>(ParseFlags &amp;lhs, ParseFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ParseFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaf59b9479390c508dff23dba221177bcc</anchor>
      <arglist>(ParseFlags &amp;lhs, ParseFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gade862759d091b90329ba8f85aa2fd010</anchor>
      <arglist>(ModuleFlags lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaacd06c8457fa8f31c1483f96c4933ddf</anchor>
      <arglist>(ModuleFlags lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga333d93ef372c08c322d27ac05bda0e18</anchor>
      <arglist>(ModuleFlags lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaaa723a5b4d33e54167f7adbb18746004</anchor>
      <arglist>(ModuleFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gae9df767ea1ec74b0d9d9acce426a07a8</anchor>
      <arglist>(ModuleFlags &amp;lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gab903aa5397125ce37c66a259c4b1a5f5</anchor>
      <arglist>(ModuleFlags &amp;lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga8e73a634c6441630eddf8805b22dd163</anchor>
      <arglist>(ModuleFlags &amp;lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga5c44b3a4eee7eefbb1f2d1d8f22642ca</anchor>
      <arglist>(RegexCompileFlags lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga4ae748a01d312275d2ca4e15c5df5826</anchor>
      <arglist>(RegexCompileFlags lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga69068f48bbea92cdd3cc7d69fdc017e1</anchor>
      <arglist>(RegexCompileFlags lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gacb650222b1a3f6a44e72df95d815a7f8</anchor>
      <arglist>(RegexCompileFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gae6fd65d5a674d2e2e453793d86fa64cd</anchor>
      <arglist>(RegexCompileFlags &amp;lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaeefcf05c20e07dde23268b83a1ff1c45</anchor>
      <arglist>(RegexCompileFlags &amp;lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga1425051a4ffed939a1bff1e0543c9498</anchor>
      <arglist>(RegexCompileFlags &amp;lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gab63da3a959cbd5f00f4fa535e35eda08</anchor>
      <arglist>(RegexMatchFlags lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga29b80a6c4482fae8e19f9328ec0c3147</anchor>
      <arglist>(RegexMatchFlags lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga06c395f619dffca3f0fc483fab302122</anchor>
      <arglist>(RegexMatchFlags lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaf192ce556cbd7ddb416e8078bdb09523</anchor>
      <arglist>(RegexMatchFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga8f30deab298559a873d7beca40279ead</anchor>
      <arglist>(RegexMatchFlags &amp;lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga283a3e82cd9d3da8746edbe13a6f616a</anchor>
      <arglist>(RegexMatchFlags &amp;lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga402d81f594d95305aa6e275aa74126ae</anchor>
      <arglist>(RegexMatchFlags &amp;lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaba6cac919da111ebf69667bf9f8006ff</anchor>
      <arglist>(SpawnFlags lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga2d10b36fdc1ceb9fea2ffcd58406f3e2</anchor>
      <arglist>(SpawnFlags lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga84449a9a461b381f88f65435ef8389ec</anchor>
      <arglist>(SpawnFlags lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga065f45ca68d1397febf331293e4cc4de</anchor>
      <arglist>(SpawnFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gabbe289c910b34a158f8dc22bb0b0095f</anchor>
      <arglist>(SpawnFlags &amp;lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga93f15ab009ea244c1d8b069e27ec193f</anchor>
      <arglist>(SpawnFlags &amp;lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga40166fcca8eb8ec5b148c82444553927</anchor>
      <arglist>(SpawnFlags &amp;lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga5bc1518eb5547dbb8af77b944ccaa048</anchor>
      <arglist>(AsciiType lhs, AsciiType rhs)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga4c340e00aeb13a9124081f383283eed0</anchor>
      <arglist>(AsciiType lhs, AsciiType rhs)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga682a545ca2e86b3e162305e4f14fa8d5</anchor>
      <arglist>(AsciiType lhs, AsciiType rhs)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gad7ea47582094c6d092a8f485e1e709c6</anchor>
      <arglist>(AsciiType flags)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga69bba23f4c9a83c268d0599f241b8ebe</anchor>
      <arglist>(AsciiType &amp;lhs, AsciiType rhs)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga8f4b46bf548b21ef21a568ecc18a5871</anchor>
      <arglist>(AsciiType &amp;lhs, AsciiType rhs)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gac1b0239e539cf250333fe0adc04dbb41</anchor>
      <arglist>(AsciiType &amp;lhs, AsciiType rhs)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>giommEnums</name>
    <title>giomm Enums and Flags</title>
    <filename>group__giommEnums.html</filename>
    <member kind="enumeration">
      <type></type>
      <name>AppInfoCreateFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae39c1e25f40a070e1720470758a55344</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>APP_INFO_CREATE_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gae39c1e25f40a070e1720470758a55344add0a457b19825cca468ab82bfcb26792</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>APP_INFO_CREATE_NEEDS_TERMINAL</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gae39c1e25f40a070e1720470758a55344a856b6d31af6aa3b829c4f7d0c369cb36</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>APP_INFO_CREATE_SUPPORTS_URIS</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gae39c1e25f40a070e1720470758a55344acdadd06006e617905058fe72b7d20a15</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>APP_INFO_CREATE_SUPPORTS_STARTUP_NOTIFICATION</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gae39c1e25f40a070e1720470758a55344a019ac7f7975aa01cf9cce569d32cb305</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>ApplicationFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga493d914cf0a466cc9c6b18a44c5d345e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>APPLICATION_FLAGS_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga493d914cf0a466cc9c6b18a44c5d345eac3648311d6c651b1ec142a9126dd9218</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>APPLICATION_IS_SERVICE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga493d914cf0a466cc9c6b18a44c5d345eacbfbbfcf23728f586b20198ec8c0ef65</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>APPLICATION_IS_LAUNCHER</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga493d914cf0a466cc9c6b18a44c5d345ea80b9654d577ba14cac46a377803582f8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>APPLICATION_HANDLES_OPEN</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga493d914cf0a466cc9c6b18a44c5d345ea48febe68e1b1d161e976fbe7438d6dfe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>APPLICATION_HANDLES_COMMAND_LINE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga493d914cf0a466cc9c6b18a44c5d345ea571b3655b06b966f063c6934c716827a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>APPLICATION_SEND_ENVIRONMENT</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga493d914cf0a466cc9c6b18a44c5d345ea3d7a27c9565496e3e091054a5c43d3a5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>APPLICATION_NON_UNIQUE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga493d914cf0a466cc9c6b18a44c5d345ea076d0a322fe529f2d3e34cab73036d2d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>ConverterResult</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa0a2aaee2c908b38261e17b4cb851b5f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CONVERTER_ERROR</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaa0a2aaee2c908b38261e17b4cb851b5fafe3299680b582332e478fb2687a2444e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CONVERTER_CONVERTED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaa0a2aaee2c908b38261e17b4cb851b5fa90c651f8d195d6f831ac5129d37bfea5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CONVERTER_FINISHED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaa0a2aaee2c908b38261e17b4cb851b5fa8b4c5ace43db5f6c59e93f2657c64a24</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CONVERTER_FLUSHED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaa0a2aaee2c908b38261e17b4cb851b5faf5796b84682a3a74758fc0ebbff8e78a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>ConverterFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab07e5ab152ffbc542e6e5c007809f17c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CONVERTER_NO_FLAGS</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gab07e5ab152ffbc542e6e5c007809f17cad789df2d3d8b69e3c3e769799ea2fd9a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CONVERTER_INPUT_AT_END</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gab07e5ab152ffbc542e6e5c007809f17caf8ef1d62da6ff9d9f48354d086c4542b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CONVERTER_FLUSH</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gab07e5ab152ffbc542e6e5c007809f17ca09637822cb0ec186b2765b19e32ca75c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>CredentialsType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae498b021f21459dc83201f010ddf8dde</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CREDENTIALS_TYPE_INVALID</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gae498b021f21459dc83201f010ddf8ddea29474824e47dc06cd31745084064b741</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CREDENTIALS_TYPE_LINUX_UCRED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gae498b021f21459dc83201f010ddf8ddea41895e1cf2bf9aa8f1913fee18f6f57a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CREDENTIALS_TYPE_FREEBSD_CMSGCRED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gae498b021f21459dc83201f010ddf8ddea87ae260e0bc318acd72444ee24be4563</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CREDENTIALS_TYPE_OPENBSD_SOCKPEERCRED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gae498b021f21459dc83201f010ddf8ddea6f27f270318a2033f69c7fa5f3289813</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CREDENTIALS_TYPE_SOLARIS_UCRED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gae498b021f21459dc83201f010ddf8ddea70852c7fca3b1ed74f6adf469115c523</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>BusType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa00806111608557f425bf09bdf4b0087</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>BUS_TYPE_STARTER</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>gaa00806111608557f425bf09bdf4b0087aab916c886b6a3f3aadd08806416fe776</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>BUS_TYPE_NONE</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>gaa00806111608557f425bf09bdf4b0087a04b4cf0b4c4e1ade2161d47f50573a03</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>BUS_TYPE_SYSTEM</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>gaa00806111608557f425bf09bdf4b0087a2eccc6ac9ad0dd3ab3b5156173bf4270</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>BUS_TYPE_SESSION</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>gaa00806111608557f425bf09bdf4b0087ae0de0856fe1ddbb862fe8fa39da894cf</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>CallFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa2aaa37e1bbc56a65746a9ebc3a5a4db</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CALL_FLAGS_NONE</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>gaa2aaa37e1bbc56a65746a9ebc3a5a4dba40e3b6a19ddaa17280300aa628abe849</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CALL_FLAGS_NO_AUTO_START</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>gaa2aaa37e1bbc56a65746a9ebc3a5a4dba07771ba4cced2dbe5a356c7b1169bcab</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>ConnectionFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa395bc4535e698ee8615a929c947187d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CONNECTION_FLAGS_NONE</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>gaa395bc4535e698ee8615a929c947187da2eb3cb8d569f71c870a88394f591fded</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CONNECTION_FLAGS_AUTHENTICATION_CLIENT</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>gaa395bc4535e698ee8615a929c947187da83efcd0c5b446244f4de720f8f2d9903</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CONNECTION_FLAGS_AUTHENTICATION_SERVER</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>gaa395bc4535e698ee8615a929c947187da3d01acde66ebbf2422da41d3a3644388</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CONNECTION_FLAGS_AUTHENTICATION_ALLOW_ANONYMOUS</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>gaa395bc4535e698ee8615a929c947187da5eb013d20a37142b4d6e5dfe3cdad04c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CONNECTION_FLAGS_MESSAGE_BUS_CONNECTION</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>gaa395bc4535e698ee8615a929c947187da2ef23aff9fc5ed0984bdd2f94e6de6a9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CONNECTION_FLAGS_DELAY_MESSAGE_PROCESSING</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>gaa395bc4535e698ee8615a929c947187da5912bf6845315acc846b31cf13333cc2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>SendMessageFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab2b457af9dfcf8a106e4b8495d22af2b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SEND_MESSAGE_FLAGS_NONE</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>gab2b457af9dfcf8a106e4b8495d22af2ba033b75923dcedbfd7f395b6b11f59cda</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SEND_MESSAGE_FLAGS_PRESERVE_SERIAL</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>gab2b457af9dfcf8a106e4b8495d22af2ba27d67cc732f62f053bc596e1376ee348</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>SignalFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5978f448a9187eca418eac34799144fa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SIGNAL_FLAGS_NONE</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>ga5978f448a9187eca418eac34799144faaea59457ebca8e18dbcf629edfdc2214f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SIGNAL_FLAGS_NO_MATCH_RULE</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>ga5978f448a9187eca418eac34799144faa9357714d880d0bf44a617714a9d16fdc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SIGNAL_FLAGS_MATCH_ARG0_NAMESPACE</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>ga5978f448a9187eca418eac34799144faa97049b22e5a8c6b8f7a071906bf476f4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SIGNAL_FLAGS_MATCH_ARG0_PATH</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>ga5978f448a9187eca418eac34799144faa0cd86d556df3b75375c80de534c834f7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>SubtreeFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga57ca559dd8d3b93c96c4828cb457b975</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SUBTREE_FLAGS_NONE</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>ga57ca559dd8d3b93c96c4828cb457b975a235c5dac5f3035f4ddd88ae6bf2d5653</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SUBTREE_FLAGS_DISPATCH_TO_UNENUMERATED_NODES</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>ga57ca559dd8d3b93c96c4828cb457b975a52969f47406b6454b4c2ab0c9b8b5e82</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>InterfaceSkeletonFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gad553d6b87f056a42ec83373c5f6198d7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DBUS_INTERFACE_SKELETON_FLAGS_NONE</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>gad553d6b87f056a42ec83373c5f6198d7a29fbfeb50c91d0bc36ea3787456357a2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DBUS_INTERFACE_SKELETON_FLAGS_HANDLE_METHOD_INVOCATIONS_IN_THREAD</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>gad553d6b87f056a42ec83373c5f6198d7a40f6eded2fb704153c939c0be30cb9be</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>PropertyInfoFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga54150c0a362b8266949aa773ddeae53b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PROPERTY_INFO_FLAGS_NONE</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>ga54150c0a362b8266949aa773ddeae53baaa63905ed5df2500e977566ee5d50903</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PROPERTY_INFO_FLAGS_READABLE</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>ga54150c0a362b8266949aa773ddeae53baca64e29b7a0c8f601486d803cfaa81d9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PROPERTY_INFO_FLAGS_WRITABLE</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>ga54150c0a362b8266949aa773ddeae53baabf556bc3f5e90e4c205f3d0135064ea</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>MessageType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gadd9b3057ea07b6bb75a7c033678a07b6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MESSAGE_TYPE_INVALID</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>gadd9b3057ea07b6bb75a7c033678a07b6a8b9a7a6a084815a8060eabf1be20eabe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MESSAGE_TYPE_METHOD_CALL</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>gadd9b3057ea07b6bb75a7c033678a07b6a0a9c5e63591ba34e488c83d4600e681d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MESSAGE_TYPE_METHOD_RETURN</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>gadd9b3057ea07b6bb75a7c033678a07b6a16c69b9e9b6cec7e8a5b7a66608f104f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MESSAGE_TYPE_ERROR</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>gadd9b3057ea07b6bb75a7c033678a07b6a12f215babf0bfc97fb6567de80e9b4d4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MESSAGE_TYPE_SIGNAL</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>gadd9b3057ea07b6bb75a7c033678a07b6a795e7b4a83d335bc31ccc8297d55e9c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>MessageFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf22c46c040ba585ee936319b7e414784</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MESSAGE_FLAGS_NONE</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>gaf22c46c040ba585ee936319b7e414784a0c88b5d305a144cfb012c3cb2fd70585</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MESSAGE_FLAGS_NO_REPLY_EXPECTED</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>gaf22c46c040ba585ee936319b7e414784a04f4cdacc644a4e28f846aa6d9bbf002</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MESSAGE_FLAGS_NO_AUTO_START</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>gaf22c46c040ba585ee936319b7e414784a75250947c066ac742792ef5349e33253</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>MessageHeaderField</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga6cfd9fb2c0212aea31cecd5fd923a0f0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MESSAGE_HEADER_FIELD_INVALID</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>ga6cfd9fb2c0212aea31cecd5fd923a0f0a0919873bbe88467c5baad50f3baa5243</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MESSAGE_HEADER_FIELD_PATH</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>ga6cfd9fb2c0212aea31cecd5fd923a0f0a5d2013e287e2ba9b1948cc27e4167393</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MESSAGE_HEADER_FIELD_INTERFACE</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>ga6cfd9fb2c0212aea31cecd5fd923a0f0ac969fef8c51f9124c48eda21f6e82967</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MESSAGE_HEADER_FIELD_MEMBER</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>ga6cfd9fb2c0212aea31cecd5fd923a0f0a5ffa315233785645f6d85b1362b5f4e9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MESSAGE_HEADER_FIELD_ERROR_NAME</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>ga6cfd9fb2c0212aea31cecd5fd923a0f0a37658b900f0090e075394e1ae05c4d56</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MESSAGE_HEADER_FIELD_REPLY_SERIAL</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>ga6cfd9fb2c0212aea31cecd5fd923a0f0a4f7e9cdc27fcddb17d5fbd7f748fb0f2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MESSAGE_HEADER_FIELD_DESTINATION</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>ga6cfd9fb2c0212aea31cecd5fd923a0f0adbbdafefa229a74ba0cf4ebb6005832b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MESSAGE_HEADER_FIELD_SENDER</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>ga6cfd9fb2c0212aea31cecd5fd923a0f0af56b497d31dd6bf2d60f276ec3eb9860</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MESSAGE_HEADER_FIELD_SIGNATURE</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>ga6cfd9fb2c0212aea31cecd5fd923a0f0aa125004b5dadc193b5b333fe1ad1b9b0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MESSAGE_HEADER_FIELD_NUM_UNIX_FDS</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>ga6cfd9fb2c0212aea31cecd5fd923a0f0a3d842bfa90a49623fcbf34f4dbfd20a3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>CapabilityFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gadc652797a964763619fdb48a89b42f93</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CAPABILITY_FLAGS_NONE</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>gadc652797a964763619fdb48a89b42f93a3ed3e77bb323d43df2818db094d96bfa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CAPABILITY_FLAGS_UNIX_FD_PASSING</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>gadc652797a964763619fdb48a89b42f93abca338e994b09efcf37e7fc7950d03fc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>BusNameOwnerFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga90e13b67fdf97528695baa4a6a18b051</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>BUS_NAME_OWNER_FLAGS_NONE</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>ga90e13b67fdf97528695baa4a6a18b051a900fa7dcd6f4b5263dc9b42969439140</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>BUS_NAME_OWNER_FLAGS_ALLOW_REPLACEMENT</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>ga90e13b67fdf97528695baa4a6a18b051a064a68e0fa3528cdede245b4a7f30a13</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>BUS_NAME_OWNER_FLAGS_REPLACE</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>ga90e13b67fdf97528695baa4a6a18b051ac8d4a3e5664ccd285031c35e6a6b03b8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>ProxyFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac7e5173c0b0042ec1dfca220d6761c9f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PROXY_FLAGS_NONE</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>gac7e5173c0b0042ec1dfca220d6761c9fa03980d62f7e788a29e39d9ff27fa13ae</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>gac7e5173c0b0042ec1dfca220d6761c9fa2746107ef7f01e33186ec8a73e52f03e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>gac7e5173c0b0042ec1dfca220d6761c9faaed9ebcc1eebcb8f74a7ee86a9f6a757</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PROXY_FLAGS_DO_NOT_AUTO_START</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>gac7e5173c0b0042ec1dfca220d6761c9faa4beae8b2803f42530e2b5d7916e8d71</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PROXY_FLAGS_GET_INVALIDATED_PROPERTIES</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>gac7e5173c0b0042ec1dfca220d6761c9fa5998625f06e94240adde9f3125e3c58e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PROXY_FLAGS_DO_NOT_AUTO_START_AT_CONSTRUCTION</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>gac7e5173c0b0042ec1dfca220d6761c9fa8f8e762671b830cfc00ec07aee37052e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>ServerFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3fbaae392de9b7cb4e91ba94476a82b2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SERVER_FLAGS_NONE</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>ga3fbaae392de9b7cb4e91ba94476a82b2adbf5c5f93fd528dcf3bc9975e8971ae1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SERVER_FLAGS_RUN_IN_THREAD</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>ga3fbaae392de9b7cb4e91ba94476a82b2a16f16173f6d63d6f4a87a07dfc3ea168</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SERVER_FLAGS_AUTHENTICATION_ALLOW_ANONYMOUS</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>ga3fbaae392de9b7cb4e91ba94476a82b2a002f455d364a7646b317d9cb764c6da5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>BusNameWatcherFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga724a510e53ed4df47411bcdbaf680c85</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>BUS_NAME_WATCHER_FLAGS_NONE</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>ga724a510e53ed4df47411bcdbaf680c85a23e333ede42826b165a4d40b0f55ad22</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>BUS_NAME_WATCHER_FLAGS_AUTO_START</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>ga724a510e53ed4df47411bcdbaf680c85a559feaf6228b1762dc83064053a137d1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>DriveStartFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab628e70b1d028b3bc9b02b0d3b8acf2d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DRIVE_START_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gab628e70b1d028b3bc9b02b0d3b8acf2da9fe888bc06249b6238868b8fffa4c9cd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>DriveStartStopType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga148d2356238c5c8f809dcbd58341cc2d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DRIVE_START_STOP_TYPE_UNKNOWN</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga148d2356238c5c8f809dcbd58341cc2dac0b4d7173528ab4d281f2946189225b2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DRIVE_START_STOP_TYPE_SHUTDOWN</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga148d2356238c5c8f809dcbd58341cc2dab2f2a704561293cdd46fc45149a698ab</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DRIVE_START_STOP_TYPE_NETWORK</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga148d2356238c5c8f809dcbd58341cc2daf3635f16b2365d617603e90b9894be49</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DRIVE_START_STOP_TYPE_MULTIDISK</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga148d2356238c5c8f809dcbd58341cc2da76e4f6e59c0474cb0f73bd35f8ede533</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DRIVE_START_STOP_TYPE_PASSWORD</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga148d2356238c5c8f809dcbd58341cc2daeed465a6f82c4446c9585d3a070af35f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>EmblemOrigin</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7f2c8f757fdeb91ca48c0bc8184f9270</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>EMBLEM_ORIGIN_UNKNOWN</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7f2c8f757fdeb91ca48c0bc8184f9270a91846b396a34f3df7fabff035440d684</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>EMBLEM_ORIGIN_DEVICE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7f2c8f757fdeb91ca48c0bc8184f9270a03234829155a8c8df81621edefb0611f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>EMBLEM_ORIGIN_LIVEMETADATA</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7f2c8f757fdeb91ca48c0bc8184f9270a162bb08277c29a9e2a4697ae2bbe1abc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>EMBLEM_ORIGIN_TAG</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7f2c8f757fdeb91ca48c0bc8184f9270a19f1be7e988a13fb24aba702e3a053a5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>DataStreamByteOrder</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga87dea9b56fed9c0bca0f8426fb57781e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DATA_STREAM_BYTE_ORDER_BIG_ENDIAN</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga87dea9b56fed9c0bca0f8426fb57781ea8b4902d3cb6f18ca9cd368b8592bc2d2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga87dea9b56fed9c0bca0f8426fb57781eacfc71a021f044e01f47fc17414d614cd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DATA_STREAM_BYTE_ORDER_HOST_ENDIAN</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga87dea9b56fed9c0bca0f8426fb57781eadbbb7a6b49187d80effe2f86ece4df35</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>DataStreamNewlineType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2de111fe308aff763fb98a39bc507267</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DATA_STREAM_NEWLINE_TYPE_LF</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga2de111fe308aff763fb98a39bc507267a3436677feb41490a984ca7a2888703c6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DATA_STREAM_NEWLINE_TYPE_CR</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga2de111fe308aff763fb98a39bc507267a26f114922babde47f335da1db19edc0d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DATA_STREAM_NEWLINE_TYPE_CR_LF</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga2de111fe308aff763fb98a39bc507267a67902d64d395eaf7ffda260087c18258</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DATA_STREAM_NEWLINE_TYPE_ANY</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga2de111fe308aff763fb98a39bc507267acb8fa2e7c3b4afceb6247a60e11b3a14</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>ErrorEnum</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_FAILED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9ab0cc1f39ca02a434f5743fe048024234</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_NOT_FOUND</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a4ef5a9505bfc5dfc1ae9f9f3447d4e11</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_EXISTS</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a4ceb1df9ce7cee68ae688d9b4928bd35</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_IS_DIRECTORY</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a51c6cd44b213e6398f0832b2e4f0d9a2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_NOT_DIRECTORY</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a59876b7a8237ec343ab802d3d8d3993c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_NOT_EMPTY</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a88ac8b2960da0db4b2ad1911421ce6a8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_NOT_REGULAR_FILE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a26df8843300d90f513e9e3cedb6b7160</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_NOT_SYMBOLIC_LINK</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a1cae279c511fd3bfa2bd6c22f40afad5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_NOT_MOUNTABLE_FILE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a61a760edac9e645617248da0dc4cb1b7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_FILENAME_TOO_LONG</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a94e7643e3100aec970d860fc04cf2a4b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_INVALID_FILENAME</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a169d1d04640be309d75f57daaaab967a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_TOO_MANY_LINKS</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9aab3cb365b675f525a57cb3aa59b19eb8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_NO_SPACE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a74478cef936bb366faa61c4d3fbd2f35</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_INVALID_ARGUMENT</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a133a98e6b98462e693e2cdb01d04dd45</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_PERMISSION_DENIED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a175f98a99b2eedf9388b0b1a14337768</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_NOT_SUPPORTED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a8105194f1a5fcafb73fa0bb11a58ba37</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_NOT_MOUNTED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a6077fb042b3fbf7919b07e32cc58a0c7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_ALREADY_MOUNTED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a76f3bd66119828db7de127c2d0d9d404</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_CLOSED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a811449c2fc1320fdc9cc2699e95c28b8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_CANCELLED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a34b177be2c03351bc7229368daeb6c7a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_PENDING</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a59888e38aafea0a297cddda02b4d4c30</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_READ_ONLY</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a94ce70939862a818366ce36d4073eea5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_CANT_CREATE_BACKUP</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a3d84f8d331584efdecd6509659469963</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_WRONG_ETAG</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a5e70c1d9cabf665b6644072e617fcd8e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_TIMED_OUT</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a6afbb366cf6fadbcd3a0cc9bdda4d785</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_WOULD_RECURSE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a40e63426571446c6b8367e8723ff884b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_BUSY</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9af03051cf787ed29bfbfc3eef779f643c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_WOULD_BLOCK</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a33cedc0aa8ed9ed6fe2046dafa6be761</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_HOST_NOT_FOUND</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9af82cfefac7dcb8443eeb68e00655018c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_HOST_WAS_NOT_FOUND</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9ae0f97278ba9282b38b4de0a05bc5d02a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_WOULD_MERGE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a8fde4035c92a204ea5ced8fc0246b1c4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_FAILED_HANDLED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9aedf009957a6447d72d7b57e322873241</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_TOO_MANY_OPEN_FILES</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a07c99219035cdedfb7e68912103c4809</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_NOT_INITIALIZED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a41dba331826e8286d2cd6b0597c66ed3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_ADDRESS_IN_USE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a52c950d317ba2bf030503348fbbe3507</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_PARTIAL_INPUT</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a499e88d84d7c74f16f05d590ad325939</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_INVALID_DATA</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9ac127dae51d242cf4e555698a304ab6e3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_DBUS_ERROR</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a01732f06363333ccd3a92315c39997bc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_HOST_UNREACHABLE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9abb38de071094e3719cff06eda169ad19</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_NETWORK_UNREACHABLE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a10b76e3c96ac62ce1b391bd16aaddd34</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_CONNECTION_REFUSED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a7ea93acf57628c52f0ec0bca88867a1f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_PROXY_FAILED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a488eb73dbfcda6c9dfdce34506aad189</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_PROXY_AUTH_FAILED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a719d21f61636b4a2be41c57095d75a28</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_PROXY_NEED_AUTH</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9af530560c8f757e469966e70937c2b84f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_PROXY_NOT_ALLOWED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a792abebe5a0f00a91b764195990f863d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_BROKEN_PIPE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a4a016f0cbd21e8208d0d48ce6882ad98</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>SocketFamily</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga0ba69e14ad979bf9b2073ad122e38d48</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_FAMILY_INVALID</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0ba69e14ad979bf9b2073ad122e38d48a6bed0d7385152034c574c30517146415</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_FAMILY_UNIX</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0ba69e14ad979bf9b2073ad122e38d48a064bccdabdfea2abf2b51d0c75776c90</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_FAMILY_IPV4</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0ba69e14ad979bf9b2073ad122e38d48ad5c89514986f19d88128f5e6904a7954</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_FAMILY_IPV6</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0ba69e14ad979bf9b2073ad122e38d48ada5d2619a60802d5623077908d7d9d9d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>TlsAuthenticationMode</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga202fd408b6a0f198ae5aaf0f0c6a69b1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_AUTHENTICATION_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga202fd408b6a0f198ae5aaf0f0c6a69b1a6f68cd7902a2ff811172ef8790c3b45f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_AUTHENTICATION_REQUESTED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga202fd408b6a0f198ae5aaf0f0c6a69b1a7f674a9fdd9ada5fc3aa290be6daa714</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_AUTHENTICATION_REQUIRED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga202fd408b6a0f198ae5aaf0f0c6a69b1af0e295a2f16be5c1964b35b8ed26d755</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>TlsCertificateFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac96df88bc70e763045de6aa47e87039a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_CERTIFICATE_UNKNOWN_CA</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gac96df88bc70e763045de6aa47e87039aaa61070c1752cab0ed249d122ea6d1c82</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_CERTIFICATE_BAD_IDENTITY</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gac96df88bc70e763045de6aa47e87039aacab8c8dda0e2cec3f607d9a9ca1a42b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_CERTIFICATE_NOT_ACTIVATED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gac96df88bc70e763045de6aa47e87039aa5254c1571dbe9837634767c357b7d8bf</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_CERTIFICATE_EXPIRED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gac96df88bc70e763045de6aa47e87039aa4fac7824ceea67b46567d4c02758f0de</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_CERTIFICATE_REVOKED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gac96df88bc70e763045de6aa47e87039aaef5e648db292564cead690dc80454a5b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_CERTIFICATE_INSECURE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gac96df88bc70e763045de6aa47e87039aa2fe51d259ecb128d4905bb5e25d6c5c1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_CERTIFICATE_GENERIC_ERROR</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gac96df88bc70e763045de6aa47e87039aad6eeb967a5da3b6b700f9380816f4840</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_CERTIFICATE_VALIDATE_ALL</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gac96df88bc70e763045de6aa47e87039aa5f708cb7a52ac87665c6fb824f9ae066</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>FileQueryInfoFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2cb7bdea61353f0999607785abd032c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_QUERY_INFO_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga2cb7bdea61353f0999607785abd032c0a4e412b5c20ae24607975e36b1d2142c9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_QUERY_INFO_NOFOLLOW_SYMLINKS</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga2cb7bdea61353f0999607785abd032c0a083d027fec770383a5747b6f5d555f80</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>FileCreateFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga500a44e123fd4c578f8af9ddef2f7601</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_CREATE_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga500a44e123fd4c578f8af9ddef2f7601a823486fdb9088ef7b93e208bc6b62e88</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_CREATE_PRIVATE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga500a44e123fd4c578f8af9ddef2f7601a20a321bcbed7bc1ca7dcfdafbd71542d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_CREATE_REPLACE_DESTINATION</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga500a44e123fd4c578f8af9ddef2f7601ae08c57359cd652d3ce61f4e1509748f5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>FileCopyFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga08edc09a45449b136b27493647d4ecbe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_COPY_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga08edc09a45449b136b27493647d4ecbea74324723d31670f9d554d43d4d21cba9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_COPY_OVERWRITE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga08edc09a45449b136b27493647d4ecbea2be9041c22de8fec379aee9fb358320b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_COPY_BACKUP</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga08edc09a45449b136b27493647d4ecbeadc037d686a7557c965dfa15491df35cf</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_COPY_NOFOLLOW_SYMLINKS</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga08edc09a45449b136b27493647d4ecbea32ab435654684ff92fa8f8175af13201</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_COPY_ALL_METADATA</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga08edc09a45449b136b27493647d4ecbea4e001ed252dd18fecaa44f1b759e1569</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_COPY_NO_FALLBACK_FOR_MOVE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga08edc09a45449b136b27493647d4ecbeada7bad8e87c41d3dc1754d534216536d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_COPY_TARGET_DEFAULT_PERMS</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga08edc09a45449b136b27493647d4ecbeaae94c977672250ae25bc12fc6fe2c112</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>FileMonitorFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga469f795e9a4dddb2421c0e5568be6649</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_MONITOR_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga469f795e9a4dddb2421c0e5568be6649adedf14a2a5916e81bc91e6174b400290</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_MONITOR_WATCH_MOUNTS</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga469f795e9a4dddb2421c0e5568be6649a137fce52cf19a9e99778bc444a168e8e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_MONITOR_SEND_MOVED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga469f795e9a4dddb2421c0e5568be6649a685c2e018318ca8b6b74d1ad42275644</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_MONITOR_WATCH_HARD_LINKS</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga469f795e9a4dddb2421c0e5568be6649a415c73cd16a4fb046d37b427a087aac9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>FileMeasureFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3d27573e797e8e78e7b71705ad015ced</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_MEASURE_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga3d27573e797e8e78e7b71705ad015ceda96dacae2624b3093efe929aed02cbca3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_MEASURE_REPORT_ANY_ERROR</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga3d27573e797e8e78e7b71705ad015ceda32288391e78d0e5cdb60043371e6bc67</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_MEASURE_APPARENT_SIZE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga3d27573e797e8e78e7b71705ad015cedaa164ff3f2ce85af9ce27769f624e68a1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_MEASURE_NO_XDEV</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga3d27573e797e8e78e7b71705ad015cedab724452e7293d1d0a823cabb170b691d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>FileAttributeType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5e79fa284e14b18d180741cd1c03d0e2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_ATTRIBUTE_TYPE_INVALID</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga5e79fa284e14b18d180741cd1c03d0e2a805ed50e0977f72475eeda88c0d7a7a1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_ATTRIBUTE_TYPE_STRING</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga5e79fa284e14b18d180741cd1c03d0e2a2245a488ce026f086d5c675094eff3f4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_ATTRIBUTE_TYPE_BYTE_STRING</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga5e79fa284e14b18d180741cd1c03d0e2a164db2121bfd5ff822bac6acbde33544</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_ATTRIBUTE_TYPE_BOOLEAN</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga5e79fa284e14b18d180741cd1c03d0e2a93319c8374a669b5e1129567418bde82</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_ATTRIBUTE_TYPE_UINT32</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga5e79fa284e14b18d180741cd1c03d0e2aba6788fbe235ea29dea30b35257fbc68</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_ATTRIBUTE_TYPE_INT32</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga5e79fa284e14b18d180741cd1c03d0e2a4dc9622fb7721f6c649cd84383a5d5c8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_ATTRIBUTE_TYPE_UINT64</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga5e79fa284e14b18d180741cd1c03d0e2a0fa0752320fa928bc91377fd949dd2b1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_ATTRIBUTE_TYPE_INT64</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga5e79fa284e14b18d180741cd1c03d0e2a2125480e07a560278057f1708b2f2786</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_ATTRIBUTE_TYPE_OBJECT</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga5e79fa284e14b18d180741cd1c03d0e2a62c78139dc3d8dcfd7d9a065f03d8dd6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_ATTRIBUTE_TYPE_STRINGV</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga5e79fa284e14b18d180741cd1c03d0e2a099ea86783dc6107a1091288cde7ed8a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>FileAttributeInfoFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8687b5c14230bb3e46a1df7341941f16</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_ATTRIBUTE_INFO_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga8687b5c14230bb3e46a1df7341941f16a94fee536cd3b76cf646d218bbe79431f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_ATTRIBUTE_INFO_COPY_WITH_FILE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga8687b5c14230bb3e46a1df7341941f16a4d067fa34aaa26916a8e628a324fd0ff</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_ATTRIBUTE_INFO_COPY_WHEN_MOVED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga8687b5c14230bb3e46a1df7341941f16a7c592c7403a77c24938d2cf862f3d4f1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>FileAttributeStatus</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae926022c51a79fd117e4bfd100c25b29</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_ATTRIBUTE_STATUS_UNSET</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gae926022c51a79fd117e4bfd100c25b29aa6ae1faab740fea51730ec8deb321357</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_ATTRIBUTE_STATUS_SET</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gae926022c51a79fd117e4bfd100c25b29a498cc49dddb48bc7b47c6a1436635e9c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_ATTRIBUTE_STATUS_ERROR_SETTING</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gae926022c51a79fd117e4bfd100c25b29a33b51e197bf827abaaf840392ca490c8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>FileType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7dcba95023d74c47bba3fd0a07f8824c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_TYPE_NOT_KNOWN</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7dcba95023d74c47bba3fd0a07f8824cac25cd997f78ab9767b89832029ff7643</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_TYPE_REGULAR</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7dcba95023d74c47bba3fd0a07f8824cabb375590e8c40cd86e52d5514ef6cecb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_TYPE_DIRECTORY</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7dcba95023d74c47bba3fd0a07f8824ca92da3d5f23153beff0aca0df8306f205</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_TYPE_SYMBOLIC_LINK</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7dcba95023d74c47bba3fd0a07f8824ca1c546c9a8d5b169bc9341f91a4043a76</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_TYPE_SPECIAL</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7dcba95023d74c47bba3fd0a07f8824caa018808e35cbe9662b5d4912839d92af</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_TYPE_SHORTCUT</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7dcba95023d74c47bba3fd0a07f8824ca945309db7d4a735df1b2f9aa0de8e9af</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_TYPE_MOUNTABLE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7dcba95023d74c47bba3fd0a07f8824ca22b432ea367e5862e5afc063fd6b77e4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>FileMonitorEvent</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabd42cf9877b5b6556bb18b7fd6b6dd81</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_MONITOR_EVENT_CHANGED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gabd42cf9877b5b6556bb18b7fd6b6dd81a5a51698573022af410cb775ab5f624a5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_MONITOR_EVENT_CHANGES_DONE_HINT</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gabd42cf9877b5b6556bb18b7fd6b6dd81a92c379f4f5af44ae845743ac00356ae0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_MONITOR_EVENT_DELETED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gabd42cf9877b5b6556bb18b7fd6b6dd81ae5ad92f521597f62f841b2fa3f4ac5ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_MONITOR_EVENT_CREATED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gabd42cf9877b5b6556bb18b7fd6b6dd81ab930b855d1b6166425a50e2f0073e96d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_MONITOR_EVENT_ATTRIBUTE_CHANGED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gabd42cf9877b5b6556bb18b7fd6b6dd81a497566a966a85e8a3d605b1e0f2fe6df</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_MONITOR_EVENT_PRE_UNMOUNT</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gabd42cf9877b5b6556bb18b7fd6b6dd81aa6b5259e0e4118e4278e7ba3b2a7b3a7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_MONITOR_EVENT_UNMOUNTED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gabd42cf9877b5b6556bb18b7fd6b6dd81afc80802f75f9a2b28e0ac8865a1c6c3c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_MONITOR_EVENT_MOVED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gabd42cf9877b5b6556bb18b7fd6b6dd81a476780dff2264f47c66d99e73d82902b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>IOStreamSpliceFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga753fc539949f2db7d1114d7ebd5b45b7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_STREAM_SPLICE_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga753fc539949f2db7d1114d7ebd5b45b7a72d9ff1d41beeda3a353d288067c1a89</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_STREAM_SPLICE_CLOSE_STREAM1</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga753fc539949f2db7d1114d7ebd5b45b7a24034382c40a690f81e569dc73bb8ca8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_STREAM_SPLICE_CLOSE_STREAM2</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga753fc539949f2db7d1114d7ebd5b45b7aa6bbcbd7487a11353206d37995150d50</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_STREAM_SPLICE_WAIT_FOR_BOTH</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga753fc539949f2db7d1114d7ebd5b45b7a76dec5a78d423a9443f657ce2fac8c36</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>MountUnmountFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9fa1b6a8eabf8f88e4cf6d611a4cff44</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MOUNT_UNMOUNT_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga9fa1b6a8eabf8f88e4cf6d611a4cff44a1599c4ebeb5c0c6e9c312a4b9e4231b6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MOUNT_UNMOUNT_FORCE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga9fa1b6a8eabf8f88e4cf6d611a4cff44a8a1875392ebf634f2d02625395df5207</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>MountMountFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5484bace25c932fd4c7354259e138814</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MOUNT_MOUNT_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga5484bace25c932fd4c7354259e138814a73c8f98eedd8a952ae25a55533dc145d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>AskPasswordFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac807da73d3b89a6dc16dad028244e6ec</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ASK_PASSWORD_NEED_PASSWORD</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gac807da73d3b89a6dc16dad028244e6eca777e15d6610937851ef05608edb34d16</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ASK_PASSWORD_NEED_USERNAME</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gac807da73d3b89a6dc16dad028244e6eca01380b474c01152aeb2db5351adc14a5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ASK_PASSWORD_NEED_DOMAIN</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gac807da73d3b89a6dc16dad028244e6ecae283224523fe0a4c343984e1fd0e7a72</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ASK_PASSWORD_SAVING_SUPPORTED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gac807da73d3b89a6dc16dad028244e6eca4e5c4cd229b2d87c9fa505262e31a747</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ASK_PASSWORD_ANONYMOUS_SUPPORTED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gac807da73d3b89a6dc16dad028244e6eca58484c40d21ac105c3af15f845ef55f7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>PasswordSave</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gafec517575c8f8d6f48433c86da52448f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PASSWORD_SAVE_NEVER</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gafec517575c8f8d6f48433c86da52448faedf9056b0e9394620857b9b142b4ceb3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PASSWORD_SAVE_FOR_SESSION</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gafec517575c8f8d6f48433c86da52448fa11147906f5de9af5313c3dc99223e4dd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PASSWORD_SAVE_PERMANENTLY</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gafec517575c8f8d6f48433c86da52448fa3372ea635ae7fa7c23f2941211703bba</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>MountOperationResult</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac479310f8df4ad5909d717caec261076</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MOUNT_OPERATION_HANDLED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gac479310f8df4ad5909d717caec261076aadc695f34c2910427dc53ceb41785ffb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MOUNT_OPERATION_ABORTED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gac479310f8df4ad5909d717caec261076a88bb44b71d0d353785c6b60b42bb5e9a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MOUNT_OPERATION_UNHANDLED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gac479310f8df4ad5909d717caec261076a22c0d4477019d21864affc0e6739b51d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>OutputStreamSpliceFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7c30d67e5f60d33fdcd3053123feea74</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>OUTPUT_STREAM_SPLICE_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7c30d67e5f60d33fdcd3053123feea74a4a8d0f68799497978b5baaf64a453435</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>OUTPUT_STREAM_SPLICE_CLOSE_SOURCE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7c30d67e5f60d33fdcd3053123feea74abc66eea22d58051ebd68f30510264db5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>OUTPUT_STREAM_SPLICE_CLOSE_TARGET</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7c30d67e5f60d33fdcd3053123feea74a342a9302a3953a86a706a5d016df4fc4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>ResolverRecordType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7305dc7c78903a65491f3a505f55e966</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>RESOLVER_RECORD_SRV</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7305dc7c78903a65491f3a505f55e966ac548d0dd4d1ca0dc44e0198026d97743</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>RESOLVER_RECORD_MX</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7305dc7c78903a65491f3a505f55e966a659ee77f7a108769e0a5ed1bd8d623cc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>RESOLVER_RECORD_TXT</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7305dc7c78903a65491f3a505f55e966a88dfa057fc978cf1b44d97cc524b4fba</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>RESOLVER_RECORD_SOA</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7305dc7c78903a65491f3a505f55e966ac16f3405fc29e0a668b86d50c297242b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>RESOLVER_RECORD_NS</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7305dc7c78903a65491f3a505f55e966ad1009cbb36502af096ebbbe783b7a6ee</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>SettingsBindFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab41e4379084ff04d75104143d99ecf61</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SETTINGS_BIND_DEFAULT</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gab41e4379084ff04d75104143d99ecf61a3ce16849b0de4e3ee431fdc4b9e22743</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SETTINGS_BIND_GET</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gab41e4379084ff04d75104143d99ecf61aa319946ecd163150075ef1ab0f19284c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SETTINGS_BIND_SET</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gab41e4379084ff04d75104143d99ecf61a80140cfe9c11b5cea3600728f9d82ede</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SETTINGS_BIND_NO_SENSITIVITY</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gab41e4379084ff04d75104143d99ecf61a4f626b2d4de6868c5a90cac6e1ce19f7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SETTINGS_BIND_GET_NO_CHANGES</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gab41e4379084ff04d75104143d99ecf61ad9391f896ba987bdf6eb6c41e33b4f8f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SETTINGS_BIND_INVERT_BOOLEAN</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gab41e4379084ff04d75104143d99ecf61a3ad9eea211350bc06670ff384d0e8268</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>SocketType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2302a45e052658e343729e0be2fd3310</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_TYPE_INVALID</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga2302a45e052658e343729e0be2fd3310a49bd4b46e7905c9394731d0abadb2e02</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_TYPE_STREAM</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga2302a45e052658e343729e0be2fd3310afc55c511821dc58a492d7c474a1b1ea8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_TYPE_DATAGRAM</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga2302a45e052658e343729e0be2fd3310ae1eef5b09f7187e72db09c0f7bfaf944</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_TYPE_SEQPACKET</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga2302a45e052658e343729e0be2fd3310a1b81d801009c9471bbeb3aba2412b6a1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>SocketProtocol</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4e8932017a600fffa5e8e6b5f6ea5b16</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_PROTOCOL_UNKNOWN</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga4e8932017a600fffa5e8e6b5f6ea5b16ab3f91855912cd06d5ae3cdc79ce65a97</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_PROTOCOL_DEFAULT</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga4e8932017a600fffa5e8e6b5f6ea5b16a96f0a62cfb9d0121dff3b1cbb86588e4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_PROTOCOL_TCP</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga4e8932017a600fffa5e8e6b5f6ea5b16ad06eafdd4ba6c1989f0e79da060bd968</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_PROTOCOL_UDP</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga4e8932017a600fffa5e8e6b5f6ea5b16a68e3a82b9749e8503d2121bcc8528102</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_PROTOCOL_SCTP</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga4e8932017a600fffa5e8e6b5f6ea5b16a1f4d47329d9ef942f5d20247da0b4c6d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>SocketMsgFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga11f5e6b2ba2903428e93d947c82fa04e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_MSG_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga11f5e6b2ba2903428e93d947c82fa04ea566eba142e4067e3510eb479d177ffad</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_MSG_OOB</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga11f5e6b2ba2903428e93d947c82fa04ea1d7b6de8ed171562d9254f285f5a5993</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_MSG_PEEK</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga11f5e6b2ba2903428e93d947c82fa04eab353a9d8f6a5efbd5c5b5f70b3310b25</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_MSG_DONTROUTE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga11f5e6b2ba2903428e93d947c82fa04ea4d60627f51602e0da0f517d544236be0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>SocketClientEvent</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf8428cdf057aabdd8990b5e0a8021adc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_CLIENT_RESOLVING</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaf8428cdf057aabdd8990b5e0a8021adcaf27ff2bb8aa4bfba7f530914302e6b68</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_CLIENT_RESOLVED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaf8428cdf057aabdd8990b5e0a8021adcad20a5e4f48335b65d71dd81fbb4e45ab</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_CLIENT_CONNECTING</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaf8428cdf057aabdd8990b5e0a8021adcaab53be1516a7898addfa234505380c91</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_CLIENT_CONNECTED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaf8428cdf057aabdd8990b5e0a8021adca272d5c7a7ff4f8cc2dfb3f35a70293ee</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_CLIENT_PROXY_NEGOTIATING</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaf8428cdf057aabdd8990b5e0a8021adcad78637c6c51ffe5f0ee87445241ee07a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_CLIENT_PROXY_NEGOTIATED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaf8428cdf057aabdd8990b5e0a8021adca88d3229819861b95e92db313a03178fb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_CLIENT_TLS_HANDSHAKING</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaf8428cdf057aabdd8990b5e0a8021adca6a19a1c046f9c1a7a48c035c15f2e9ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_CLIENT_TLS_HANDSHAKED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaf8428cdf057aabdd8990b5e0a8021adca9b4da0f454f3921280a4b53d627e5509</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_CLIENT_COMPLETE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaf8428cdf057aabdd8990b5e0a8021adcae48a58af767d126bf0b857f01606274a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>TlsRehandshakeMode</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9730680b829b7745e4f36c1540761f3f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_REHANDSHAKE_NEVER</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga9730680b829b7745e4f36c1540761f3fac8ff1b158382a7e0944ca22d36efa45d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_REHANDSHAKE_SAFELY</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga9730680b829b7745e4f36c1540761f3faa634954ea0400e153992717d5cb26cdc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_REHANDSHAKE_UNSAFELY</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga9730680b829b7745e4f36c1540761f3fa2176f716b50ba1295c669015897f5a81</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>TlsDatabaseVerifyFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa46a3fc37c1e5566af625d7db3123a4b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_DATABASE_VERIFY_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaa46a3fc37c1e5566af625d7db3123a4bae878bdddf57ebe9c6763e09cbeb1d0db</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>TlsDatabaseLookupFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga0de6ee7362d49df4f068b6214b93a076</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_DATABASE_LOOKUP_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0de6ee7362d49df4f068b6214b93a076ab4bcee74e44c9e07b862aea638a6a702</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_DATABASE_LOOKUP_KEYPAIR</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0de6ee7362d49df4f068b6214b93a076a4a63bab7d12dc952756580064d71a0a6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>TlsInteractionResult</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga13ffba1819a4d780593c50266d7a9484</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_INTERACTION_UNHANDLED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga13ffba1819a4d780593c50266d7a9484a9124d1a05b6e51fcfb74d1c5dfe81444</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_INTERACTION_HANDLED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga13ffba1819a4d780593c50266d7a9484ae073f3fa9246f1aaf14cca26b643c0bb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_INTERACTION_FAILED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga13ffba1819a4d780593c50266d7a9484a246a89fbc6dd9fa82f7fe072f20d6ed8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>TlsCertificateRequestFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaab2a17acffc49fca7080e27fd1e61996</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_CERTIFICATE_REQUEST_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaab2a17acffc49fca7080e27fd1e61996a1a43c45f95ab7c4cd60f77d3a668579d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>TlsPasswordFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8ac18330be9383471445ba62336a929a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_PASSWORD_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga8ac18330be9383471445ba62336a929aa974fc670e6e7a7a558552003dd192b00</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_PASSWORD_RETRY</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga8ac18330be9383471445ba62336a929aa13f226bbdab3f2abb89c5bdc6aabbbff</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_PASSWORD_MANY_TRIES</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga8ac18330be9383471445ba62336a929aae3b9f706b9a6b6d6c63dc9c1d2609911</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_PASSWORD_FINAL_TRY</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga8ac18330be9383471445ba62336a929aa231f395c8c272846b106aee9690901eb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>ZlibCompressorFormat</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab247c6072c566753c8b9762f66e84c02</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ZLIB_COMPRESSOR_FORMAT_ZLIB</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gab247c6072c566753c8b9762f66e84c02ab635cfa0d0ddeafe35f7e3c8ad411e1e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ZLIB_COMPRESSOR_FORMAT_GZIP</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gab247c6072c566753c8b9762f66e84c02a0c0304ef454aaf0d34a180241d3c604b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ZLIB_COMPRESSOR_FORMAT_RAW</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gab247c6072c566753c8b9762f66e84c02a97beae051e98c770a6185a3336390fda</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>UnixSocketAddressType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf842f4597d522154407164deb4906c2e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNIX_SOCKET_ADDRESS_INVALID</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaf842f4597d522154407164deb4906c2eaeefc2bdc5ec67828a46119a74c8e7143</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNIX_SOCKET_ADDRESS_ANONYMOUS</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaf842f4597d522154407164deb4906c2ea93c2605ae77d14182f21150b0b399b95</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNIX_SOCKET_ADDRESS_PATH</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaf842f4597d522154407164deb4906c2eaa81d365fa4258138dd887b23768fd30d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNIX_SOCKET_ADDRESS_ABSTRACT</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaf842f4597d522154407164deb4906c2eae50800b7fb801e830b3ead075c13d644</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNIX_SOCKET_ADDRESS_ABSTRACT_PADDED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaf842f4597d522154407164deb4906c2ea7deb4d7d3c78b7f9bd191b853ede3f88</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac2ae439cef63de06f97ed8454b67ec32</anchor>
      <arglist>(AppInfoCreateFlags lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1f0f1235c25f5552c8a1467697bd66d3</anchor>
      <arglist>(AppInfoCreateFlags lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9f582e5773b615c406ceb28b695b7015</anchor>
      <arglist>(AppInfoCreateFlags lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga302df8457f421e75eaea25a67cb63c19</anchor>
      <arglist>(AppInfoCreateFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaccda1b3df9583689a62a3add6715f640</anchor>
      <arglist>(AppInfoCreateFlags &amp;lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga179d7c2a3d709c7a8e4a0796a8b5e833</anchor>
      <arglist>(AppInfoCreateFlags &amp;lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5dac484830e37250c0942325fb4b85a3</anchor>
      <arglist>(AppInfoCreateFlags &amp;lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ApplicationFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga44ea3f3bc13b4f365f8b2423a9ac6697</anchor>
      <arglist>(ApplicationFlags lhs, ApplicationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ApplicationFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga69ea1b280906db58e7da69dfa8e967f4</anchor>
      <arglist>(ApplicationFlags lhs, ApplicationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ApplicationFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf78c94e5bddf6119131fc2925e25e4db</anchor>
      <arglist>(ApplicationFlags lhs, ApplicationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ApplicationFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabfccee773f2311c38a00aa0d1ecbe3ac</anchor>
      <arglist>(ApplicationFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>ApplicationFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7f8cf604f276081f162dfe2e78e5e76a</anchor>
      <arglist>(ApplicationFlags &amp;lhs, ApplicationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ApplicationFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga786d1f08e7b472c5474df9bf6ebe1a1b</anchor>
      <arglist>(ApplicationFlags &amp;lhs, ApplicationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ApplicationFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga58651ff4ec0b8e4ca0fd0e868e8f09cf</anchor>
      <arglist>(ApplicationFlags &amp;lhs, ApplicationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ConverterFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9f956fe651a1375f27fc596f1ade2ab6</anchor>
      <arglist>(ConverterFlags lhs, ConverterFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ConverterFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaed01900163c4efb6fc8b072ace92a4ff</anchor>
      <arglist>(ConverterFlags lhs, ConverterFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ConverterFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa24dddaf6719113c40e5c8ec9694cf05</anchor>
      <arglist>(ConverterFlags lhs, ConverterFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ConverterFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1ca85527dd594724362f3a6e8d1ad466</anchor>
      <arglist>(ConverterFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>ConverterFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga006555992fbb516f1cea93b762566516</anchor>
      <arglist>(ConverterFlags &amp;lhs, ConverterFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ConverterFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga09dd687bd08618a59a4a0128521f12ca</anchor>
      <arglist>(ConverterFlags &amp;lhs, ConverterFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ConverterFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga65a84e2cc906ff5924d3eb0af66b56b2</anchor>
      <arglist>(ConverterFlags &amp;lhs, ConverterFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CallFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaaf256ad4e34a802125934a3602918182</anchor>
      <arglist>(CallFlags lhs, CallFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CallFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga47883a2d57f11392fdd1a6ef43f89e68</anchor>
      <arglist>(CallFlags lhs, CallFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CallFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2f5d5bbe79d36aeb8946a9d1985ba5d4</anchor>
      <arglist>(CallFlags lhs, CallFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CallFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab7d0c01e24d4734b302439ac13db5c01</anchor>
      <arglist>(CallFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>CallFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf7f8b92419edde75f68a2e9fe3f6b207</anchor>
      <arglist>(CallFlags &amp;lhs, CallFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CallFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4d35c282233dc1001a6bee144e8927cf</anchor>
      <arglist>(CallFlags &amp;lhs, CallFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CallFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga45397d95ea49e8d13e45968ec55056f0</anchor>
      <arglist>(CallFlags &amp;lhs, CallFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ConnectionFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabf0261e49d127ddbb20121314bd691e5</anchor>
      <arglist>(ConnectionFlags lhs, ConnectionFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ConnectionFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaaf4fb4e9f9f05db8aef1d7dd7b74e683</anchor>
      <arglist>(ConnectionFlags lhs, ConnectionFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ConnectionFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gadeceb9495694a6f85d0aa34cd76593f4</anchor>
      <arglist>(ConnectionFlags lhs, ConnectionFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ConnectionFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9cd54aecd4fcf0476f3908ced65ea3da</anchor>
      <arglist>(ConnectionFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>ConnectionFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga531539a51f6fa26100e00cf79b3ef074</anchor>
      <arglist>(ConnectionFlags &amp;lhs, ConnectionFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ConnectionFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga252e252c236c2cd7d5a34accd1dc35b2</anchor>
      <arglist>(ConnectionFlags &amp;lhs, ConnectionFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ConnectionFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab3e32a633be5fab9f1e2ea91e4c203b2</anchor>
      <arglist>(ConnectionFlags &amp;lhs, ConnectionFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SendMessageFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga517437c24b21c9390d68d06252c38ee0</anchor>
      <arglist>(SendMessageFlags lhs, SendMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SendMessageFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae80621518706162a86658592b7254795</anchor>
      <arglist>(SendMessageFlags lhs, SendMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SendMessageFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gacb730118932c2c089205040b6f99bb5e</anchor>
      <arglist>(SendMessageFlags lhs, SendMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SendMessageFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2a7223d208f91d9a6d618b24bcd120ad</anchor>
      <arglist>(SendMessageFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>SendMessageFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2c8dbd2f0ee82cc71309daaa7708fac2</anchor>
      <arglist>(SendMessageFlags &amp;lhs, SendMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SendMessageFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga0742f8360fae7f654c500754b638940b</anchor>
      <arglist>(SendMessageFlags &amp;lhs, SendMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SendMessageFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga47c0490b33800886410984ebc8ade747</anchor>
      <arglist>(SendMessageFlags &amp;lhs, SendMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SignalFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa71251f9666e33b79ca3a35b14c56b75</anchor>
      <arglist>(SignalFlags lhs, SignalFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SignalFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga61dba33469f7b98cbdcbf4a70a3587f5</anchor>
      <arglist>(SignalFlags lhs, SignalFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SignalFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab061e0a24b6b7d57c6eb05bb8a311f9b</anchor>
      <arglist>(SignalFlags lhs, SignalFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SignalFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8a995c39db7f285301ce89935348568b</anchor>
      <arglist>(SignalFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>SignalFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga92a022e06267a8e614e64124f3ac27ae</anchor>
      <arglist>(SignalFlags &amp;lhs, SignalFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SignalFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab844f8ad8ade34198b73813de9388fdc</anchor>
      <arglist>(SignalFlags &amp;lhs, SignalFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SignalFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga67e999a4414637b197248e62958c6528</anchor>
      <arglist>(SignalFlags &amp;lhs, SignalFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SubtreeFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae3a3d5e31e4ddea76624f7681614397c</anchor>
      <arglist>(SubtreeFlags lhs, SubtreeFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SubtreeFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga229d4d6025379fde0b915a35249bd64a</anchor>
      <arglist>(SubtreeFlags lhs, SubtreeFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SubtreeFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga515f8f33ea2499547311998d503cbdf1</anchor>
      <arglist>(SubtreeFlags lhs, SubtreeFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SubtreeFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa24aa533cfbe9d4988c40466d5105272</anchor>
      <arglist>(SubtreeFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>SubtreeFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga48af5a57b27520a781794b0d491b2c18</anchor>
      <arglist>(SubtreeFlags &amp;lhs, SubtreeFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SubtreeFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga341722664bb6d009b4260f25e1a076f8</anchor>
      <arglist>(SubtreeFlags &amp;lhs, SubtreeFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SubtreeFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa9e879e08b368bda95e12b464c246461</anchor>
      <arglist>(SubtreeFlags &amp;lhs, SubtreeFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>InterfaceSkeletonFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga93f58fade77f58a700609e2155c0284c</anchor>
      <arglist>(InterfaceSkeletonFlags lhs, InterfaceSkeletonFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>InterfaceSkeletonFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga91e89a2d2b763c87263ddc193f9f2a72</anchor>
      <arglist>(InterfaceSkeletonFlags lhs, InterfaceSkeletonFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>InterfaceSkeletonFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab154380be90dcc8abd71ab17da151708</anchor>
      <arglist>(InterfaceSkeletonFlags lhs, InterfaceSkeletonFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>InterfaceSkeletonFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf0aadfd03ce7e0ad24b9d5672a85ffb9</anchor>
      <arglist>(InterfaceSkeletonFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>InterfaceSkeletonFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2015b9e953b4ea4b5d4480568e91e7d3</anchor>
      <arglist>(InterfaceSkeletonFlags &amp;lhs, InterfaceSkeletonFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>InterfaceSkeletonFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa143b170cc1d5319f15353e6e2f0d6ca</anchor>
      <arglist>(InterfaceSkeletonFlags &amp;lhs, InterfaceSkeletonFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>InterfaceSkeletonFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga78faf490171eeb84cafee0a15f50886f</anchor>
      <arglist>(InterfaceSkeletonFlags &amp;lhs, InterfaceSkeletonFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>PropertyInfoFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3162179be3acb867fc1b7d66a9e2d27c</anchor>
      <arglist>(PropertyInfoFlags lhs, PropertyInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>PropertyInfoFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga65cedd2790b1b312c81429f5799f279f</anchor>
      <arglist>(PropertyInfoFlags lhs, PropertyInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>PropertyInfoFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga36f6ee825d38230e4fb1d264550f385c</anchor>
      <arglist>(PropertyInfoFlags lhs, PropertyInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>PropertyInfoFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac36330aaaa3f5436abef2c04ddd76edb</anchor>
      <arglist>(PropertyInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>PropertyInfoFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9d77c45a262381a023550c672f4aad30</anchor>
      <arglist>(PropertyInfoFlags &amp;lhs, PropertyInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>PropertyInfoFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gadb34a8bfac33bb32b93ea41c9799be2b</anchor>
      <arglist>(PropertyInfoFlags &amp;lhs, PropertyInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>PropertyInfoFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga332bf3aa8cd16de4a9d563ac60aa34c6</anchor>
      <arglist>(PropertyInfoFlags &amp;lhs, PropertyInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MessageFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7dab85256a6961f9edbd479b8641a840</anchor>
      <arglist>(MessageFlags lhs, MessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MessageFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae7a5b60247b0d28c0c53b5be0781dcb4</anchor>
      <arglist>(MessageFlags lhs, MessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MessageFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaedaa6d5aed08b463298ef9a29abf6611</anchor>
      <arglist>(MessageFlags lhs, MessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MessageFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga45fb183fd7a0d4e6c9c741e4f3544449</anchor>
      <arglist>(MessageFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>MessageFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa7c77f89fbc6749eeb2580b0708385ef</anchor>
      <arglist>(MessageFlags &amp;lhs, MessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MessageFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4c1e428d82aca56d2e425af99965db45</anchor>
      <arglist>(MessageFlags &amp;lhs, MessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MessageFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf94c469e7db6e0c1e018f472976c0e6b</anchor>
      <arglist>(MessageFlags &amp;lhs, MessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CapabilityFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa381c473b1bd9ba61f55980bdfbd64a7</anchor>
      <arglist>(CapabilityFlags lhs, CapabilityFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CapabilityFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga167ba2e96e38e978775fdac3bd4671c4</anchor>
      <arglist>(CapabilityFlags lhs, CapabilityFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CapabilityFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf407a0b027a0f5ac46690ccf96a1d16b</anchor>
      <arglist>(CapabilityFlags lhs, CapabilityFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CapabilityFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaac055f4785da200653bdbc7d228d158d</anchor>
      <arglist>(CapabilityFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>CapabilityFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaffb83150531f7af44949645e6d7bd632</anchor>
      <arglist>(CapabilityFlags &amp;lhs, CapabilityFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CapabilityFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaba92d42345a5ba2677e740657f36a804</anchor>
      <arglist>(CapabilityFlags &amp;lhs, CapabilityFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CapabilityFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf6b4bae2281097b7020ebd2c78460a88</anchor>
      <arglist>(CapabilityFlags &amp;lhs, CapabilityFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga6ee165e164ee5ac76fcae97d149b0096</anchor>
      <arglist>(BusNameOwnerFlags lhs, BusNameOwnerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae95dbcb5c39a041199a14ef692ff190e</anchor>
      <arglist>(BusNameOwnerFlags lhs, BusNameOwnerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga66e5ff30c50eda68a6e9c9856ff24929</anchor>
      <arglist>(BusNameOwnerFlags lhs, BusNameOwnerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga76ae3c19edb95730bbf26a8bd2fe41fc</anchor>
      <arglist>(BusNameOwnerFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1082185ea5b919ef8e797f5a4a2cbd84</anchor>
      <arglist>(BusNameOwnerFlags &amp;lhs, BusNameOwnerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8e3b00479dfbf4a7ead540cf77612f13</anchor>
      <arglist>(BusNameOwnerFlags &amp;lhs, BusNameOwnerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8256822b508991b36784f8633f5a2a41</anchor>
      <arglist>(BusNameOwnerFlags &amp;lhs, BusNameOwnerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ProxyFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa322b87fce3af1fdea7133a127088be1</anchor>
      <arglist>(ProxyFlags lhs, ProxyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ProxyFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabc62c83be1688dcba26adbf8142f0e9c</anchor>
      <arglist>(ProxyFlags lhs, ProxyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ProxyFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga86dfb1bb4f81af398e3d9e46c7bcfdd6</anchor>
      <arglist>(ProxyFlags lhs, ProxyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ProxyFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3ea4f184a1f3477087c578f74b88fbf2</anchor>
      <arglist>(ProxyFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>ProxyFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gace0563138240e17842fa5110f70e6c38</anchor>
      <arglist>(ProxyFlags &amp;lhs, ProxyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ProxyFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8f874bf89ca3dc93aabc8b99c9a24c76</anchor>
      <arglist>(ProxyFlags &amp;lhs, ProxyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ProxyFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga996098077862478d47a82bae84847f4e</anchor>
      <arglist>(ProxyFlags &amp;lhs, ProxyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ServerFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7955ba627de857db9a98ba002092c825</anchor>
      <arglist>(ServerFlags lhs, ServerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ServerFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gad22f2b21e846e019f1287d912029522b</anchor>
      <arglist>(ServerFlags lhs, ServerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ServerFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga11ec0042ba646a016c058c8ead2cd18d</anchor>
      <arglist>(ServerFlags lhs, ServerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ServerFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5ab28f60229aa0c887d0c1ec05ec286f</anchor>
      <arglist>(ServerFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>ServerFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac1a3b9ca9c65cb38a478ac3df387983a</anchor>
      <arglist>(ServerFlags &amp;lhs, ServerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ServerFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabefa22f57f50d6504dbd41d325552293</anchor>
      <arglist>(ServerFlags &amp;lhs, ServerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ServerFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3104ed754362062701f00c4aa9ee2bec</anchor>
      <arglist>(ServerFlags &amp;lhs, ServerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga11d69d7cecb05e6a1ab2e29802001c0d</anchor>
      <arglist>(BusNameWatcherFlags lhs, BusNameWatcherFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4e9cd27579fc08b486bf6963e0e48828</anchor>
      <arglist>(BusNameWatcherFlags lhs, BusNameWatcherFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3c6767c920f33ef0acf5273d87d44191</anchor>
      <arglist>(BusNameWatcherFlags lhs, BusNameWatcherFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7f09a804dfb04f4a256cfb22cac05378</anchor>
      <arglist>(BusNameWatcherFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3cde961e2c29d55871ad3cb2b4d0f7b1</anchor>
      <arglist>(BusNameWatcherFlags &amp;lhs, BusNameWatcherFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8a9b2721d1528e637f826498f93486be</anchor>
      <arglist>(BusNameWatcherFlags &amp;lhs, BusNameWatcherFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga606fa2da2a5a44a01e084c959fd1cca2</anchor>
      <arglist>(BusNameWatcherFlags &amp;lhs, BusNameWatcherFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga38b31de13d1949c2acb9255bdc858767</anchor>
      <arglist>(DriveStartFlags lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7c4f37b1ef92224ac50016d49c95bf00</anchor>
      <arglist>(DriveStartFlags lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae75239258d148626dc4b0048b55a4c44</anchor>
      <arglist>(DriveStartFlags lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf625621abb6c686d449c3f3c43aee02c</anchor>
      <arglist>(DriveStartFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga994648faf5be7fd03bc1929554044dac</anchor>
      <arglist>(DriveStartFlags &amp;lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga77b3f8597aac448c2dd860f204e32b8f</anchor>
      <arglist>(DriveStartFlags &amp;lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1c0e50bc08aaf61dc1fbbe786c5e6b33</anchor>
      <arglist>(DriveStartFlags &amp;lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsCertificateFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga22c0194e634b597f4dcec67551a7ca9b</anchor>
      <arglist>(TlsCertificateFlags lhs, TlsCertificateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsCertificateFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1380174558e94de7c9c8b36b56332550</anchor>
      <arglist>(TlsCertificateFlags lhs, TlsCertificateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsCertificateFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9fd8470137571e8eef6bc1af201a5867</anchor>
      <arglist>(TlsCertificateFlags lhs, TlsCertificateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsCertificateFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8fd13816125414ef8f52696da2c1e0ca</anchor>
      <arglist>(TlsCertificateFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>TlsCertificateFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga69a2edc59567e8ddc43d718a01ca11a3</anchor>
      <arglist>(TlsCertificateFlags &amp;lhs, TlsCertificateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsCertificateFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9b25fecd6c1e006bac8f384156bfe80a</anchor>
      <arglist>(TlsCertificateFlags &amp;lhs, TlsCertificateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsCertificateFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7960cd8bde85baaf03372bf57015d123</anchor>
      <arglist>(TlsCertificateFlags &amp;lhs, TlsCertificateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaba7574ea0b336541af125d4eb9423088</anchor>
      <arglist>(FileQueryInfoFlags lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gafd57fe410ba970bb3cb78eb1c9942aeb</anchor>
      <arglist>(FileQueryInfoFlags lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gacae77e10133f304081534efa76be4a52</anchor>
      <arglist>(FileQueryInfoFlags lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga42422c40ea08ec4f0ad74c8e2a657eb5</anchor>
      <arglist>(FileQueryInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac59d6f3b6a2adca24d2763ba2af99a02</anchor>
      <arglist>(FileQueryInfoFlags &amp;lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga203c5d02679e3aa4c78080fb9269b1f9</anchor>
      <arglist>(FileQueryInfoFlags &amp;lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga55adc6ecb3a15cb850b30bafb7eb9248</anchor>
      <arglist>(FileQueryInfoFlags &amp;lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga431f17ab67ccea562ea556c10df6bd27</anchor>
      <arglist>(FileCreateFlags lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4a52dbf7b71137a0d00ef49c0eb163a6</anchor>
      <arglist>(FileCreateFlags lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab4d3e010c78b9f5ca2673210269b999d</anchor>
      <arglist>(FileCreateFlags lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga703109997bbde3b6a686dd36ec9d35ad</anchor>
      <arglist>(FileCreateFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4f6ed1c3e6f2a3a7d394b62f3166df7a</anchor>
      <arglist>(FileCreateFlags &amp;lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga43d71b19c0e673331de89e1b1d84679b</anchor>
      <arglist>(FileCreateFlags &amp;lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga045123aaa65f69e2a76a488d1024e34d</anchor>
      <arglist>(FileCreateFlags &amp;lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga0b841b27ceceb381f08e1bc5cf929eb1</anchor>
      <arglist>(FileCopyFlags lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabb1d7757198076b221ba038b1d3ae841</anchor>
      <arglist>(FileCopyFlags lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga29b016e93e7a6dfdebc4f9f6e4fbf1c1</anchor>
      <arglist>(FileCopyFlags lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga70312f36423a73fbf663c64824631dc8</anchor>
      <arglist>(FileCopyFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabb9c03e9bbf1ef698696dc08b0d36371</anchor>
      <arglist>(FileCopyFlags &amp;lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gad2f22009032ff6f0975c5a5701ca061d</anchor>
      <arglist>(FileCopyFlags &amp;lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga514b3929469585c9cfc222ef2daf4fea</anchor>
      <arglist>(FileCopyFlags &amp;lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab3fab04e51aeff08aaf235f038e50d72</anchor>
      <arglist>(FileMonitorFlags lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf801bc2b57ef5136eba961cdcd68e2e6</anchor>
      <arglist>(FileMonitorFlags lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga81b5df359bd6a61df867af8274d182ae</anchor>
      <arglist>(FileMonitorFlags lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga501c69e3e5101b66d2e5fb8181229b2c</anchor>
      <arglist>(FileMonitorFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8af51d7b4e7b78d3f0153090674470aa</anchor>
      <arglist>(FileMonitorFlags &amp;lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae45bc889f678f9f87ff04596b0de7d1a</anchor>
      <arglist>(FileMonitorFlags &amp;lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaffa032f65b2c0270e12fe6bafa5c36bf</anchor>
      <arglist>(FileMonitorFlags &amp;lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMeasureFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga881f9e3f716eea055f2436e00f817bcd</anchor>
      <arglist>(FileMeasureFlags lhs, FileMeasureFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMeasureFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga62c11254603103531378a6c86f251519</anchor>
      <arglist>(FileMeasureFlags lhs, FileMeasureFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMeasureFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga178b6b7a47d7191a834ba91ef45d8900</anchor>
      <arglist>(FileMeasureFlags lhs, FileMeasureFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMeasureFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga73ba283b4941eb5ed0586c5de9e687af</anchor>
      <arglist>(FileMeasureFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileMeasureFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8b334fb16e12f2fb292818af8f91430b</anchor>
      <arglist>(FileMeasureFlags &amp;lhs, FileMeasureFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMeasureFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gad1b04b5b1c7c54552cd86d3ec144ec24</anchor>
      <arglist>(FileMeasureFlags &amp;lhs, FileMeasureFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMeasureFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1dd67b3e69f82f1ae7d29ae6a36a0571</anchor>
      <arglist>(FileMeasureFlags &amp;lhs, FileMeasureFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3779f0623bf9380fb656028b9bc88323</anchor>
      <arglist>(FileAttributeInfoFlags lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga31f3ea9c0f0f3b94b829cff51a483da3</anchor>
      <arglist>(FileAttributeInfoFlags lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gade49ce26dfa73eb2eb9fc56534ac1319</anchor>
      <arglist>(FileAttributeInfoFlags lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9150f4358ab779fd1267151c4ee84a46</anchor>
      <arglist>(FileAttributeInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gadebdfefd85c32a1b626bce9ae251138b</anchor>
      <arglist>(FileAttributeInfoFlags &amp;lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4d263feb91a513421902169e234bb8c3</anchor>
      <arglist>(FileAttributeInfoFlags &amp;lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf8c86d142fcb81426bc429d51da4f7d9</anchor>
      <arglist>(FileAttributeInfoFlags &amp;lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOStreamSpliceFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gadd33991052b8c7b6d70b6afd4c4b3850</anchor>
      <arglist>(IOStreamSpliceFlags lhs, IOStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOStreamSpliceFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac4e194f1ff1b6337b2001528aad67bc9</anchor>
      <arglist>(IOStreamSpliceFlags lhs, IOStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOStreamSpliceFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga798437d9bba38467f6bf1eb02935f618</anchor>
      <arglist>(IOStreamSpliceFlags lhs, IOStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOStreamSpliceFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga69033ae6dd34521e4951f4a5ca14dfff</anchor>
      <arglist>(IOStreamSpliceFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>IOStreamSpliceFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gadeb0ed62d112c12255260042ff0205dd</anchor>
      <arglist>(IOStreamSpliceFlags &amp;lhs, IOStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOStreamSpliceFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab782a172a6c7d8b540c720f86fd5ad44</anchor>
      <arglist>(IOStreamSpliceFlags &amp;lhs, IOStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOStreamSpliceFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gad48e0449d3be29a9e01e27982d62fad6</anchor>
      <arglist>(IOStreamSpliceFlags &amp;lhs, IOStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga42e2925c2e192eb3e9b71b727e676644</anchor>
      <arglist>(MountUnmountFlags lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9ab823e8ba96b485774da1e93c7e576f</anchor>
      <arglist>(MountUnmountFlags lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga76909c76363248e860a94b20dad18ad9</anchor>
      <arglist>(MountUnmountFlags lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gace7018ee540582a709530dce1dd9191a</anchor>
      <arglist>(MountUnmountFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2d1ab6ef14833802a3615e54b8115aa8</anchor>
      <arglist>(MountUnmountFlags &amp;lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae1e6af7ffa613a35d110daedd6671389</anchor>
      <arglist>(MountUnmountFlags &amp;lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga6a939c0dc5f5b25dbad5cdb7a1848184</anchor>
      <arglist>(MountUnmountFlags &amp;lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1248f40d35ae4fb70d74c5df295cb4ae</anchor>
      <arglist>(MountMountFlags lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa459981a578b6e5ee443681687f9a777</anchor>
      <arglist>(MountMountFlags lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga02952bdc6c064b144e6667e326618c2d</anchor>
      <arglist>(MountMountFlags lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga74223d1de9c9db1c53429a6d23671d4f</anchor>
      <arglist>(MountMountFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaab40e5b0bc75d3308e8cb78606c4eb18</anchor>
      <arglist>(MountMountFlags &amp;lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga24a69ca68eff0e99a80c1c73f32c304e</anchor>
      <arglist>(MountMountFlags &amp;lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gad941eb418369c3f95f0b5c046e7d868d</anchor>
      <arglist>(MountMountFlags &amp;lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab444ed2fbe1877464f469a64d9107e36</anchor>
      <arglist>(AskPasswordFlags lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8a45caccd402223c595e5a160f15f030</anchor>
      <arglist>(AskPasswordFlags lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf0b37f457e38844832549486982ed1d8</anchor>
      <arglist>(AskPasswordFlags lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga993dba04647b8f34ad72e86cbc88ba34</anchor>
      <arglist>(AskPasswordFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga01e87fab2e1906ac5eafa153747ceae9</anchor>
      <arglist>(AskPasswordFlags &amp;lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga90dc37e16010e611eed712a21ee0a787</anchor>
      <arglist>(AskPasswordFlags &amp;lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8e3411a2fa7d7f016953b5f84dbad4c1</anchor>
      <arglist>(AskPasswordFlags &amp;lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaef500d088ea9d123dc514f71c4c67b1d</anchor>
      <arglist>(OutputStreamSpliceFlags lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga39f9583f05c94f16ce6228b52663e4e4</anchor>
      <arglist>(OutputStreamSpliceFlags lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga14a79b6dee4f711a22b52bf259539e34</anchor>
      <arglist>(OutputStreamSpliceFlags lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gafcded381df7535fe7c41bb8f8c21c169</anchor>
      <arglist>(OutputStreamSpliceFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5602d53794a62a9e823005e6f9aed428</anchor>
      <arglist>(OutputStreamSpliceFlags &amp;lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab363845e9d7769f38c78dc7cc55d9db6</anchor>
      <arglist>(OutputStreamSpliceFlags &amp;lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga01f192f0f1b9f66047d603780c458e6e</anchor>
      <arglist>(OutputStreamSpliceFlags &amp;lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8cd5ffb873f77345b515bf4ec2522ad7</anchor>
      <arglist>(SettingsBindFlags lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf9c3bdce8aa4209b368419a8a4f374a7</anchor>
      <arglist>(SettingsBindFlags lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabe81d29f028b8bfb85c189c2471a290d</anchor>
      <arglist>(SettingsBindFlags lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3faf22f64ae075a5465b7827001101d2</anchor>
      <arglist>(SettingsBindFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga0299f50197606d69c0f306224760fcdb</anchor>
      <arglist>(SettingsBindFlags &amp;lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga93c66617507b97c4ce9d5e7b99bd0c04</anchor>
      <arglist>(SettingsBindFlags &amp;lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3f4f0e3823c4d8ce3470b656913fb4e0</anchor>
      <arglist>(SettingsBindFlags &amp;lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa085ca077592487a87d8339ce3324166</anchor>
      <arglist>(SocketMsgFlags lhs, SocketMsgFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7483601181aa5da2467e986408d0136a</anchor>
      <arglist>(SocketMsgFlags lhs, SocketMsgFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaadfaf5e3a456218e23ca0ee13ac3db3d</anchor>
      <arglist>(SocketMsgFlags lhs, SocketMsgFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf31952f93c501b25194ad46df8994752</anchor>
      <arglist>(SocketMsgFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga62b41279cd63908c0736e96f868e832e</anchor>
      <arglist>(SocketMsgFlags &amp;lhs, SocketMsgFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga43e4984d2489a21f44a4ab961bf98541</anchor>
      <arglist>(SocketMsgFlags &amp;lhs, SocketMsgFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab892045d6e9cf73dc96593ead692145b</anchor>
      <arglist>(SocketMsgFlags &amp;lhs, SocketMsgFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsDatabaseVerifyFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga39e0d92d55656c2a2632f98636265306</anchor>
      <arglist>(TlsDatabaseVerifyFlags lhs, TlsDatabaseVerifyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsDatabaseVerifyFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga36f857562dfaa5bedb2f11bdcb713be2</anchor>
      <arglist>(TlsDatabaseVerifyFlags lhs, TlsDatabaseVerifyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsDatabaseVerifyFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8368dd487149972f892a91422e9bd33b</anchor>
      <arglist>(TlsDatabaseVerifyFlags lhs, TlsDatabaseVerifyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsDatabaseVerifyFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf2f0b0b2463b3e547db1a4b85603bd36</anchor>
      <arglist>(TlsDatabaseVerifyFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>TlsDatabaseVerifyFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga23b4f358bf1da65d761823c0c14601a3</anchor>
      <arglist>(TlsDatabaseVerifyFlags &amp;lhs, TlsDatabaseVerifyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsDatabaseVerifyFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gad2d6cac92ff624db2f477f5563ebe73b</anchor>
      <arglist>(TlsDatabaseVerifyFlags &amp;lhs, TlsDatabaseVerifyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsDatabaseVerifyFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gacf39fa96fbecf1a1eb1c265794b79c03</anchor>
      <arglist>(TlsDatabaseVerifyFlags &amp;lhs, TlsDatabaseVerifyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsDatabaseLookupFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga17032c82d6f99398b325773ecfbb8864</anchor>
      <arglist>(TlsDatabaseLookupFlags lhs, TlsDatabaseLookupFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsDatabaseLookupFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8801450685cbe42b72c590b4deaa0f47</anchor>
      <arglist>(TlsDatabaseLookupFlags lhs, TlsDatabaseLookupFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsDatabaseLookupFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaab103c2de8ca0e1abc5afb44a06ab7c7</anchor>
      <arglist>(TlsDatabaseLookupFlags lhs, TlsDatabaseLookupFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsDatabaseLookupFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae83d0705d3e1b6a1c1214802fd0413a7</anchor>
      <arglist>(TlsDatabaseLookupFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>TlsDatabaseLookupFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga70adec8becf6acbe4d1f3a7d32512647</anchor>
      <arglist>(TlsDatabaseLookupFlags &amp;lhs, TlsDatabaseLookupFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsDatabaseLookupFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4c1f3085e84fdd58ee013b45e624da10</anchor>
      <arglist>(TlsDatabaseLookupFlags &amp;lhs, TlsDatabaseLookupFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsDatabaseLookupFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gad91ca8afd55f164582fc2182414a567d</anchor>
      <arglist>(TlsDatabaseLookupFlags &amp;lhs, TlsDatabaseLookupFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsCertificateRequestFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf22bb92488cf1cd6097decfc5ccff4aa</anchor>
      <arglist>(TlsCertificateRequestFlags lhs, TlsCertificateRequestFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsCertificateRequestFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga546257d6ed4e6d44df743dab4b3f96c1</anchor>
      <arglist>(TlsCertificateRequestFlags lhs, TlsCertificateRequestFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsCertificateRequestFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabf70e6fec894c648a62a8b3057601b90</anchor>
      <arglist>(TlsCertificateRequestFlags lhs, TlsCertificateRequestFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsCertificateRequestFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9b6865e73e13095e7a4a57bbac28db74</anchor>
      <arglist>(TlsCertificateRequestFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>TlsCertificateRequestFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga25a044628996f41d7419dd2ea3631ca7</anchor>
      <arglist>(TlsCertificateRequestFlags &amp;lhs, TlsCertificateRequestFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsCertificateRequestFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1c9aafd291a44e3c108bd01423297899</anchor>
      <arglist>(TlsCertificateRequestFlags &amp;lhs, TlsCertificateRequestFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsCertificateRequestFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gad07b2cce57653f7ed382f2fecaba5798</anchor>
      <arglist>(TlsCertificateRequestFlags &amp;lhs, TlsCertificateRequestFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsPasswordFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gafbbaf640a1d770dc0bd46380763952e8</anchor>
      <arglist>(TlsPasswordFlags lhs, TlsPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsPasswordFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga58b2a4408d61617ba6bf6322aec97b3f</anchor>
      <arglist>(TlsPasswordFlags lhs, TlsPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsPasswordFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga18b59057b4efe6dfb55345e198c2dd4a</anchor>
      <arglist>(TlsPasswordFlags lhs, TlsPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsPasswordFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9c6566499acc6dbfb73ad14225ebaff4</anchor>
      <arglist>(TlsPasswordFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>TlsPasswordFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab3d9e43f9d3f79660d3eba8402cc3c7d</anchor>
      <arglist>(TlsPasswordFlags &amp;lhs, TlsPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsPasswordFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4b9578c71d74bf9ba422b1b906c766cf</anchor>
      <arglist>(TlsPasswordFlags &amp;lhs, TlsPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsPasswordFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1bf68c82d083fab33b612fe7756b7d56</anchor>
      <arglist>(TlsPasswordFlags &amp;lhs, TlsPasswordFlags rhs)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ChecksumType</name>
    <filename>classChecksumType.html</filename>
  </compound>
  <compound kind="namespace">
    <name>Gio</name>
    <filename>namespaceGio.html</filename>
    <namespace>Gio::DBus</namespace>
    <class kind="class">Gio::Action</class>
    <class kind="class">Gio::ActionGroup</class>
    <class kind="class">Gio::ActionMap</class>
    <class kind="class">Gio::AppInfo</class>
    <class kind="class">Gio::AppLaunchContext</class>
    <class kind="class">Gio::Application</class>
    <class kind="class">Gio::ApplicationCommandLine</class>
    <class kind="class">Gio::AsyncInitable</class>
    <class kind="class">Gio::AsyncResult</class>
    <class kind="class">Gio::BufferedInputStream</class>
    <class kind="class">Gio::BufferedOutputStream</class>
    <class kind="class">Gio::Cancellable</class>
    <class kind="class">Gio::CharsetConverter</class>
    <class kind="class">Gio::Converter</class>
    <class kind="class">Gio::ConverterInputStream</class>
    <class kind="class">Gio::ConverterOutputStream</class>
    <class kind="class">Gio::Credentials</class>
    <class kind="class">Gio::DataInputStream</class>
    <class kind="class">Gio::DataOutputStream</class>
    <class kind="class">Gio::DesktopAppInfo</class>
    <class kind="class">Gio::Drive</class>
    <class kind="class">Gio::Emblem</class>
    <class kind="class">Gio::EmblemedIcon</class>
    <class kind="class">Gio::Error</class>
    <class kind="class">Gio::File</class>
    <class kind="class">Gio::FileAttributeInfo</class>
    <class kind="class">Gio::FileAttributeInfoList</class>
    <class kind="class">Gio::FileAttributeMatcher</class>
    <class kind="class">Gio::FileEnumerator</class>
    <class kind="class">Gio::FileIcon</class>
    <class kind="class">Gio::FileInfo</class>
    <class kind="class">Gio::FileInputStream</class>
    <class kind="class">Gio::FileIOStream</class>
    <class kind="class">Gio::FileMonitor</class>
    <class kind="class">Gio::FilenameCompleter</class>
    <class kind="class">Gio::FileOutputStream</class>
    <class kind="class">Gio::FilterInputStream</class>
    <class kind="class">Gio::FilterOutputStream</class>
    <class kind="class">Gio::Icon</class>
    <class kind="class">Gio::InetAddress</class>
    <class kind="class">Gio::InetSocketAddress</class>
    <class kind="class">Gio::Initable</class>
    <class kind="class">Gio::InputStream</class>
    <class kind="class">Gio::IOStream</class>
    <class kind="class">Gio::LoadableIcon</class>
    <class kind="class">Gio::MemoryInputStream</class>
    <class kind="class">Gio::MemoryOutputStream</class>
    <class kind="class">Gio::Menu</class>
    <class kind="class">Gio::MenuAttributeIter</class>
    <class kind="class">Gio::MenuItem</class>
    <class kind="class">Gio::MenuLinkIter</class>
    <class kind="class">Gio::MenuModel</class>
    <class kind="class">Gio::Mount</class>
    <class kind="class">Gio::MountOperation</class>
    <class kind="class">Gio::NetworkAddress</class>
    <class kind="class">Gio::NetworkService</class>
    <class kind="class">Gio::Notification</class>
    <class kind="class">Gio::OutputStream</class>
    <class kind="class">Gio::Permission</class>
    <class kind="class">Gio::PollableInputStream</class>
    <class kind="class">Gio::PollableOutputStream</class>
    <class kind="class">Gio::Proxy</class>
    <class kind="class">Gio::ProxyAddress</class>
    <class kind="class">Gio::ProxyResolver</class>
    <class kind="class">Gio::RemoteActionGroup</class>
    <class kind="class">Gio::Resolver</class>
    <class kind="class">Gio::ResolverError</class>
    <class kind="class">Gio::ResourceError</class>
    <class kind="class">Gio::Seekable</class>
    <class kind="class">Gio::Settings</class>
    <class kind="class">Gio::SignalSocket</class>
    <class kind="class">Gio::SimpleAction</class>
    <class kind="class">Gio::SimpleActionGroup</class>
    <class kind="class">Gio::SimplePermission</class>
    <class kind="class">Gio::Socket</class>
    <class kind="class">Gio::SocketAddress</class>
    <class kind="class">Gio::SocketAddressEnumerator</class>
    <class kind="class">Gio::SocketClient</class>
    <class kind="class">Gio::SocketConnectable</class>
    <class kind="class">Gio::SocketConnection</class>
    <class kind="class">Gio::SocketControlMessage</class>
    <class kind="class">Gio::SocketListener</class>
    <class kind="class">Gio::SocketService</class>
    <class kind="class">Gio::SocketSource</class>
    <class kind="class">Gio::SrvTarget</class>
    <class kind="class">Gio::TcpConnection</class>
    <class kind="class">Gio::ThemedIcon</class>
    <class kind="class">Gio::ThreadedSocketService</class>
    <class kind="class">Gio::TlsCertificate</class>
    <class kind="class">Gio::TlsClientConnection</class>
    <class kind="class">Gio::TlsConnection</class>
    <class kind="class">Gio::TlsDatabase</class>
    <class kind="class">Gio::TlsError</class>
    <class kind="class">Gio::TlsInteraction</class>
    <class kind="class">Gio::TlsPassword</class>
    <class kind="class">Gio::TlsServerConnection</class>
    <class kind="class">Gio::UnixConnection</class>
    <class kind="class">Gio::UnixCredentialsMessage</class>
    <class kind="class">Gio::UnixFDList</class>
    <class kind="class">Gio::UnixFDMessage</class>
    <class kind="class">Gio::UnixInputStream</class>
    <class kind="class">Gio::UnixOutputStream</class>
    <class kind="class">Gio::UnixSocketAddress</class>
    <class kind="class">Gio::Volume</class>
    <class kind="class">Gio::VolumeMonitor</class>
    <class kind="class">Gio::ZlibCompressor</class>
    <class kind="class">Gio::ZlibDecompressor</class>
    <member kind="typedef">
      <type>sigc::slot&lt; void, Glib::RefPtr&lt; AsyncResult &gt; &amp; &gt;</type>
      <name>SlotAsyncReady</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>aecaa02709f9ab83fa2b36d2571665cbe</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Glib::ListHandle&lt; Gio::SrvTarget, SrvTargetListTraits &gt;</type>
      <name>ListHandle_SrvTarget</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a1b4ed5afd24e359d3ba6bde02c9e90be</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>AppInfoCreateFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae39c1e25f40a070e1720470758a55344</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>APP_INFO_CREATE_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gae39c1e25f40a070e1720470758a55344add0a457b19825cca468ab82bfcb26792</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>APP_INFO_CREATE_NEEDS_TERMINAL</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gae39c1e25f40a070e1720470758a55344a856b6d31af6aa3b829c4f7d0c369cb36</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>APP_INFO_CREATE_SUPPORTS_URIS</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gae39c1e25f40a070e1720470758a55344acdadd06006e617905058fe72b7d20a15</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>APP_INFO_CREATE_SUPPORTS_STARTUP_NOTIFICATION</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gae39c1e25f40a070e1720470758a55344a019ac7f7975aa01cf9cce569d32cb305</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>ApplicationFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga493d914cf0a466cc9c6b18a44c5d345e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>APPLICATION_FLAGS_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga493d914cf0a466cc9c6b18a44c5d345eac3648311d6c651b1ec142a9126dd9218</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>APPLICATION_IS_SERVICE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga493d914cf0a466cc9c6b18a44c5d345eacbfbbfcf23728f586b20198ec8c0ef65</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>APPLICATION_IS_LAUNCHER</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga493d914cf0a466cc9c6b18a44c5d345ea80b9654d577ba14cac46a377803582f8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>APPLICATION_HANDLES_OPEN</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga493d914cf0a466cc9c6b18a44c5d345ea48febe68e1b1d161e976fbe7438d6dfe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>APPLICATION_HANDLES_COMMAND_LINE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga493d914cf0a466cc9c6b18a44c5d345ea571b3655b06b966f063c6934c716827a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>APPLICATION_SEND_ENVIRONMENT</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga493d914cf0a466cc9c6b18a44c5d345ea3d7a27c9565496e3e091054a5c43d3a5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>APPLICATION_NON_UNIQUE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga493d914cf0a466cc9c6b18a44c5d345ea076d0a322fe529f2d3e34cab73036d2d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>ConverterResult</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa0a2aaee2c908b38261e17b4cb851b5f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CONVERTER_ERROR</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaa0a2aaee2c908b38261e17b4cb851b5fafe3299680b582332e478fb2687a2444e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CONVERTER_CONVERTED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaa0a2aaee2c908b38261e17b4cb851b5fa90c651f8d195d6f831ac5129d37bfea5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CONVERTER_FINISHED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaa0a2aaee2c908b38261e17b4cb851b5fa8b4c5ace43db5f6c59e93f2657c64a24</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CONVERTER_FLUSHED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaa0a2aaee2c908b38261e17b4cb851b5faf5796b84682a3a74758fc0ebbff8e78a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>ConverterFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab07e5ab152ffbc542e6e5c007809f17c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CONVERTER_NO_FLAGS</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gab07e5ab152ffbc542e6e5c007809f17cad789df2d3d8b69e3c3e769799ea2fd9a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CONVERTER_INPUT_AT_END</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gab07e5ab152ffbc542e6e5c007809f17caf8ef1d62da6ff9d9f48354d086c4542b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CONVERTER_FLUSH</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gab07e5ab152ffbc542e6e5c007809f17ca09637822cb0ec186b2765b19e32ca75c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>CredentialsType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae498b021f21459dc83201f010ddf8dde</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CREDENTIALS_TYPE_INVALID</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gae498b021f21459dc83201f010ddf8ddea29474824e47dc06cd31745084064b741</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CREDENTIALS_TYPE_LINUX_UCRED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gae498b021f21459dc83201f010ddf8ddea41895e1cf2bf9aa8f1913fee18f6f57a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CREDENTIALS_TYPE_FREEBSD_CMSGCRED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gae498b021f21459dc83201f010ddf8ddea87ae260e0bc318acd72444ee24be4563</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CREDENTIALS_TYPE_OPENBSD_SOCKPEERCRED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gae498b021f21459dc83201f010ddf8ddea6f27f270318a2033f69c7fa5f3289813</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CREDENTIALS_TYPE_SOLARIS_UCRED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gae498b021f21459dc83201f010ddf8ddea70852c7fca3b1ed74f6adf469115c523</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>DriveStartFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab628e70b1d028b3bc9b02b0d3b8acf2d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DRIVE_START_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gab628e70b1d028b3bc9b02b0d3b8acf2da9fe888bc06249b6238868b8fffa4c9cd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>DriveStartStopType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga148d2356238c5c8f809dcbd58341cc2d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DRIVE_START_STOP_TYPE_UNKNOWN</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga148d2356238c5c8f809dcbd58341cc2dac0b4d7173528ab4d281f2946189225b2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DRIVE_START_STOP_TYPE_SHUTDOWN</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga148d2356238c5c8f809dcbd58341cc2dab2f2a704561293cdd46fc45149a698ab</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DRIVE_START_STOP_TYPE_NETWORK</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga148d2356238c5c8f809dcbd58341cc2daf3635f16b2365d617603e90b9894be49</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DRIVE_START_STOP_TYPE_MULTIDISK</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga148d2356238c5c8f809dcbd58341cc2da76e4f6e59c0474cb0f73bd35f8ede533</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DRIVE_START_STOP_TYPE_PASSWORD</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga148d2356238c5c8f809dcbd58341cc2daeed465a6f82c4446c9585d3a070af35f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>EmblemOrigin</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7f2c8f757fdeb91ca48c0bc8184f9270</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>EMBLEM_ORIGIN_UNKNOWN</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7f2c8f757fdeb91ca48c0bc8184f9270a91846b396a34f3df7fabff035440d684</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>EMBLEM_ORIGIN_DEVICE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7f2c8f757fdeb91ca48c0bc8184f9270a03234829155a8c8df81621edefb0611f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>EMBLEM_ORIGIN_LIVEMETADATA</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7f2c8f757fdeb91ca48c0bc8184f9270a162bb08277c29a9e2a4697ae2bbe1abc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>EMBLEM_ORIGIN_TAG</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7f2c8f757fdeb91ca48c0bc8184f9270a19f1be7e988a13fb24aba702e3a053a5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>DataStreamByteOrder</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga87dea9b56fed9c0bca0f8426fb57781e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DATA_STREAM_BYTE_ORDER_BIG_ENDIAN</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga87dea9b56fed9c0bca0f8426fb57781ea8b4902d3cb6f18ca9cd368b8592bc2d2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga87dea9b56fed9c0bca0f8426fb57781eacfc71a021f044e01f47fc17414d614cd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DATA_STREAM_BYTE_ORDER_HOST_ENDIAN</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga87dea9b56fed9c0bca0f8426fb57781eadbbb7a6b49187d80effe2f86ece4df35</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>DataStreamNewlineType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2de111fe308aff763fb98a39bc507267</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DATA_STREAM_NEWLINE_TYPE_LF</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga2de111fe308aff763fb98a39bc507267a3436677feb41490a984ca7a2888703c6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DATA_STREAM_NEWLINE_TYPE_CR</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga2de111fe308aff763fb98a39bc507267a26f114922babde47f335da1db19edc0d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DATA_STREAM_NEWLINE_TYPE_CR_LF</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga2de111fe308aff763fb98a39bc507267a67902d64d395eaf7ffda260087c18258</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DATA_STREAM_NEWLINE_TYPE_ANY</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga2de111fe308aff763fb98a39bc507267acb8fa2e7c3b4afceb6247a60e11b3a14</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>ErrorEnum</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_FAILED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9ab0cc1f39ca02a434f5743fe048024234</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_NOT_FOUND</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a4ef5a9505bfc5dfc1ae9f9f3447d4e11</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_EXISTS</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a4ceb1df9ce7cee68ae688d9b4928bd35</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_IS_DIRECTORY</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a51c6cd44b213e6398f0832b2e4f0d9a2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_NOT_DIRECTORY</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a59876b7a8237ec343ab802d3d8d3993c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_NOT_EMPTY</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a88ac8b2960da0db4b2ad1911421ce6a8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_NOT_REGULAR_FILE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a26df8843300d90f513e9e3cedb6b7160</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_NOT_SYMBOLIC_LINK</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a1cae279c511fd3bfa2bd6c22f40afad5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_NOT_MOUNTABLE_FILE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a61a760edac9e645617248da0dc4cb1b7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_FILENAME_TOO_LONG</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a94e7643e3100aec970d860fc04cf2a4b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_INVALID_FILENAME</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a169d1d04640be309d75f57daaaab967a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_TOO_MANY_LINKS</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9aab3cb365b675f525a57cb3aa59b19eb8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_NO_SPACE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a74478cef936bb366faa61c4d3fbd2f35</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_INVALID_ARGUMENT</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a133a98e6b98462e693e2cdb01d04dd45</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_PERMISSION_DENIED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a175f98a99b2eedf9388b0b1a14337768</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_NOT_SUPPORTED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a8105194f1a5fcafb73fa0bb11a58ba37</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_NOT_MOUNTED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a6077fb042b3fbf7919b07e32cc58a0c7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_ALREADY_MOUNTED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a76f3bd66119828db7de127c2d0d9d404</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_CLOSED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a811449c2fc1320fdc9cc2699e95c28b8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_CANCELLED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a34b177be2c03351bc7229368daeb6c7a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_PENDING</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a59888e38aafea0a297cddda02b4d4c30</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_READ_ONLY</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a94ce70939862a818366ce36d4073eea5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_CANT_CREATE_BACKUP</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a3d84f8d331584efdecd6509659469963</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_WRONG_ETAG</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a5e70c1d9cabf665b6644072e617fcd8e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_TIMED_OUT</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a6afbb366cf6fadbcd3a0cc9bdda4d785</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_WOULD_RECURSE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a40e63426571446c6b8367e8723ff884b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_BUSY</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9af03051cf787ed29bfbfc3eef779f643c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_WOULD_BLOCK</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a33cedc0aa8ed9ed6fe2046dafa6be761</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_HOST_NOT_FOUND</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9af82cfefac7dcb8443eeb68e00655018c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_HOST_WAS_NOT_FOUND</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9ae0f97278ba9282b38b4de0a05bc5d02a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_WOULD_MERGE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a8fde4035c92a204ea5ced8fc0246b1c4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_FAILED_HANDLED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9aedf009957a6447d72d7b57e322873241</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_TOO_MANY_OPEN_FILES</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a07c99219035cdedfb7e68912103c4809</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_NOT_INITIALIZED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a41dba331826e8286d2cd6b0597c66ed3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_ADDRESS_IN_USE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a52c950d317ba2bf030503348fbbe3507</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_PARTIAL_INPUT</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a499e88d84d7c74f16f05d590ad325939</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_INVALID_DATA</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9ac127dae51d242cf4e555698a304ab6e3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_DBUS_ERROR</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a01732f06363333ccd3a92315c39997bc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_HOST_UNREACHABLE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9abb38de071094e3719cff06eda169ad19</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_NETWORK_UNREACHABLE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a10b76e3c96ac62ce1b391bd16aaddd34</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_CONNECTION_REFUSED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a7ea93acf57628c52f0ec0bca88867a1f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_PROXY_FAILED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a488eb73dbfcda6c9dfdce34506aad189</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_PROXY_AUTH_FAILED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a719d21f61636b4a2be41c57095d75a28</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_PROXY_NEED_AUTH</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9af530560c8f757e469966e70937c2b84f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_PROXY_NOT_ALLOWED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a792abebe5a0f00a91b764195990f863d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_ERROR_BROKEN_PIPE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9a4a016f0cbd21e8208d0d48ce6882ad98</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>SocketFamily</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga0ba69e14ad979bf9b2073ad122e38d48</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_FAMILY_INVALID</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0ba69e14ad979bf9b2073ad122e38d48a6bed0d7385152034c574c30517146415</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_FAMILY_UNIX</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0ba69e14ad979bf9b2073ad122e38d48a064bccdabdfea2abf2b51d0c75776c90</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_FAMILY_IPV4</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0ba69e14ad979bf9b2073ad122e38d48ad5c89514986f19d88128f5e6904a7954</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_FAMILY_IPV6</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0ba69e14ad979bf9b2073ad122e38d48ada5d2619a60802d5623077908d7d9d9d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>TlsAuthenticationMode</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga202fd408b6a0f198ae5aaf0f0c6a69b1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_AUTHENTICATION_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga202fd408b6a0f198ae5aaf0f0c6a69b1a6f68cd7902a2ff811172ef8790c3b45f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_AUTHENTICATION_REQUESTED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga202fd408b6a0f198ae5aaf0f0c6a69b1a7f674a9fdd9ada5fc3aa290be6daa714</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_AUTHENTICATION_REQUIRED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga202fd408b6a0f198ae5aaf0f0c6a69b1af0e295a2f16be5c1964b35b8ed26d755</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>TlsCertificateFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac96df88bc70e763045de6aa47e87039a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_CERTIFICATE_UNKNOWN_CA</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gac96df88bc70e763045de6aa47e87039aaa61070c1752cab0ed249d122ea6d1c82</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_CERTIFICATE_BAD_IDENTITY</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gac96df88bc70e763045de6aa47e87039aacab8c8dda0e2cec3f607d9a9ca1a42b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_CERTIFICATE_NOT_ACTIVATED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gac96df88bc70e763045de6aa47e87039aa5254c1571dbe9837634767c357b7d8bf</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_CERTIFICATE_EXPIRED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gac96df88bc70e763045de6aa47e87039aa4fac7824ceea67b46567d4c02758f0de</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_CERTIFICATE_REVOKED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gac96df88bc70e763045de6aa47e87039aaef5e648db292564cead690dc80454a5b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_CERTIFICATE_INSECURE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gac96df88bc70e763045de6aa47e87039aa2fe51d259ecb128d4905bb5e25d6c5c1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_CERTIFICATE_GENERIC_ERROR</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gac96df88bc70e763045de6aa47e87039aad6eeb967a5da3b6b700f9380816f4840</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_CERTIFICATE_VALIDATE_ALL</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gac96df88bc70e763045de6aa47e87039aa5f708cb7a52ac87665c6fb824f9ae066</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>FileQueryInfoFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2cb7bdea61353f0999607785abd032c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_QUERY_INFO_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga2cb7bdea61353f0999607785abd032c0a4e412b5c20ae24607975e36b1d2142c9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_QUERY_INFO_NOFOLLOW_SYMLINKS</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga2cb7bdea61353f0999607785abd032c0a083d027fec770383a5747b6f5d555f80</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>FileCreateFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga500a44e123fd4c578f8af9ddef2f7601</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_CREATE_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga500a44e123fd4c578f8af9ddef2f7601a823486fdb9088ef7b93e208bc6b62e88</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_CREATE_PRIVATE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga500a44e123fd4c578f8af9ddef2f7601a20a321bcbed7bc1ca7dcfdafbd71542d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_CREATE_REPLACE_DESTINATION</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga500a44e123fd4c578f8af9ddef2f7601ae08c57359cd652d3ce61f4e1509748f5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>FileCopyFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga08edc09a45449b136b27493647d4ecbe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_COPY_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga08edc09a45449b136b27493647d4ecbea74324723d31670f9d554d43d4d21cba9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_COPY_OVERWRITE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga08edc09a45449b136b27493647d4ecbea2be9041c22de8fec379aee9fb358320b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_COPY_BACKUP</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga08edc09a45449b136b27493647d4ecbeadc037d686a7557c965dfa15491df35cf</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_COPY_NOFOLLOW_SYMLINKS</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga08edc09a45449b136b27493647d4ecbea32ab435654684ff92fa8f8175af13201</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_COPY_ALL_METADATA</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga08edc09a45449b136b27493647d4ecbea4e001ed252dd18fecaa44f1b759e1569</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_COPY_NO_FALLBACK_FOR_MOVE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga08edc09a45449b136b27493647d4ecbeada7bad8e87c41d3dc1754d534216536d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_COPY_TARGET_DEFAULT_PERMS</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga08edc09a45449b136b27493647d4ecbeaae94c977672250ae25bc12fc6fe2c112</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>FileMonitorFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga469f795e9a4dddb2421c0e5568be6649</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_MONITOR_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga469f795e9a4dddb2421c0e5568be6649adedf14a2a5916e81bc91e6174b400290</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_MONITOR_WATCH_MOUNTS</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga469f795e9a4dddb2421c0e5568be6649a137fce52cf19a9e99778bc444a168e8e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_MONITOR_SEND_MOVED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga469f795e9a4dddb2421c0e5568be6649a685c2e018318ca8b6b74d1ad42275644</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_MONITOR_WATCH_HARD_LINKS</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga469f795e9a4dddb2421c0e5568be6649a415c73cd16a4fb046d37b427a087aac9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>FileMeasureFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3d27573e797e8e78e7b71705ad015ced</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_MEASURE_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga3d27573e797e8e78e7b71705ad015ceda96dacae2624b3093efe929aed02cbca3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_MEASURE_REPORT_ANY_ERROR</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga3d27573e797e8e78e7b71705ad015ceda32288391e78d0e5cdb60043371e6bc67</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_MEASURE_APPARENT_SIZE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga3d27573e797e8e78e7b71705ad015cedaa164ff3f2ce85af9ce27769f624e68a1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_MEASURE_NO_XDEV</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga3d27573e797e8e78e7b71705ad015cedab724452e7293d1d0a823cabb170b691d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>FileAttributeType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5e79fa284e14b18d180741cd1c03d0e2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_ATTRIBUTE_TYPE_INVALID</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga5e79fa284e14b18d180741cd1c03d0e2a805ed50e0977f72475eeda88c0d7a7a1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_ATTRIBUTE_TYPE_STRING</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga5e79fa284e14b18d180741cd1c03d0e2a2245a488ce026f086d5c675094eff3f4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_ATTRIBUTE_TYPE_BYTE_STRING</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga5e79fa284e14b18d180741cd1c03d0e2a164db2121bfd5ff822bac6acbde33544</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_ATTRIBUTE_TYPE_BOOLEAN</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga5e79fa284e14b18d180741cd1c03d0e2a93319c8374a669b5e1129567418bde82</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_ATTRIBUTE_TYPE_UINT32</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga5e79fa284e14b18d180741cd1c03d0e2aba6788fbe235ea29dea30b35257fbc68</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_ATTRIBUTE_TYPE_INT32</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga5e79fa284e14b18d180741cd1c03d0e2a4dc9622fb7721f6c649cd84383a5d5c8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_ATTRIBUTE_TYPE_UINT64</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga5e79fa284e14b18d180741cd1c03d0e2a0fa0752320fa928bc91377fd949dd2b1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_ATTRIBUTE_TYPE_INT64</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga5e79fa284e14b18d180741cd1c03d0e2a2125480e07a560278057f1708b2f2786</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_ATTRIBUTE_TYPE_OBJECT</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga5e79fa284e14b18d180741cd1c03d0e2a62c78139dc3d8dcfd7d9a065f03d8dd6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_ATTRIBUTE_TYPE_STRINGV</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga5e79fa284e14b18d180741cd1c03d0e2a099ea86783dc6107a1091288cde7ed8a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>FileAttributeInfoFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8687b5c14230bb3e46a1df7341941f16</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_ATTRIBUTE_INFO_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga8687b5c14230bb3e46a1df7341941f16a94fee536cd3b76cf646d218bbe79431f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_ATTRIBUTE_INFO_COPY_WITH_FILE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga8687b5c14230bb3e46a1df7341941f16a4d067fa34aaa26916a8e628a324fd0ff</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_ATTRIBUTE_INFO_COPY_WHEN_MOVED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga8687b5c14230bb3e46a1df7341941f16a7c592c7403a77c24938d2cf862f3d4f1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>FileAttributeStatus</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae926022c51a79fd117e4bfd100c25b29</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_ATTRIBUTE_STATUS_UNSET</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gae926022c51a79fd117e4bfd100c25b29aa6ae1faab740fea51730ec8deb321357</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_ATTRIBUTE_STATUS_SET</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gae926022c51a79fd117e4bfd100c25b29a498cc49dddb48bc7b47c6a1436635e9c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_ATTRIBUTE_STATUS_ERROR_SETTING</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gae926022c51a79fd117e4bfd100c25b29a33b51e197bf827abaaf840392ca490c8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>FileType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7dcba95023d74c47bba3fd0a07f8824c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_TYPE_NOT_KNOWN</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7dcba95023d74c47bba3fd0a07f8824cac25cd997f78ab9767b89832029ff7643</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_TYPE_REGULAR</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7dcba95023d74c47bba3fd0a07f8824cabb375590e8c40cd86e52d5514ef6cecb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_TYPE_DIRECTORY</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7dcba95023d74c47bba3fd0a07f8824ca92da3d5f23153beff0aca0df8306f205</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_TYPE_SYMBOLIC_LINK</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7dcba95023d74c47bba3fd0a07f8824ca1c546c9a8d5b169bc9341f91a4043a76</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_TYPE_SPECIAL</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7dcba95023d74c47bba3fd0a07f8824caa018808e35cbe9662b5d4912839d92af</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_TYPE_SHORTCUT</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7dcba95023d74c47bba3fd0a07f8824ca945309db7d4a735df1b2f9aa0de8e9af</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_TYPE_MOUNTABLE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7dcba95023d74c47bba3fd0a07f8824ca22b432ea367e5862e5afc063fd6b77e4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>FileMonitorEvent</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabd42cf9877b5b6556bb18b7fd6b6dd81</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_MONITOR_EVENT_CHANGED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gabd42cf9877b5b6556bb18b7fd6b6dd81a5a51698573022af410cb775ab5f624a5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_MONITOR_EVENT_CHANGES_DONE_HINT</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gabd42cf9877b5b6556bb18b7fd6b6dd81a92c379f4f5af44ae845743ac00356ae0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_MONITOR_EVENT_DELETED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gabd42cf9877b5b6556bb18b7fd6b6dd81ae5ad92f521597f62f841b2fa3f4ac5ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_MONITOR_EVENT_CREATED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gabd42cf9877b5b6556bb18b7fd6b6dd81ab930b855d1b6166425a50e2f0073e96d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_MONITOR_EVENT_ATTRIBUTE_CHANGED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gabd42cf9877b5b6556bb18b7fd6b6dd81a497566a966a85e8a3d605b1e0f2fe6df</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_MONITOR_EVENT_PRE_UNMOUNT</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gabd42cf9877b5b6556bb18b7fd6b6dd81aa6b5259e0e4118e4278e7ba3b2a7b3a7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_MONITOR_EVENT_UNMOUNTED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gabd42cf9877b5b6556bb18b7fd6b6dd81afc80802f75f9a2b28e0ac8865a1c6c3c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILE_MONITOR_EVENT_MOVED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gabd42cf9877b5b6556bb18b7fd6b6dd81a476780dff2264f47c66d99e73d82902b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>IOStreamSpliceFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga753fc539949f2db7d1114d7ebd5b45b7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_STREAM_SPLICE_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga753fc539949f2db7d1114d7ebd5b45b7a72d9ff1d41beeda3a353d288067c1a89</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_STREAM_SPLICE_CLOSE_STREAM1</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga753fc539949f2db7d1114d7ebd5b45b7a24034382c40a690f81e569dc73bb8ca8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_STREAM_SPLICE_CLOSE_STREAM2</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga753fc539949f2db7d1114d7ebd5b45b7aa6bbcbd7487a11353206d37995150d50</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IO_STREAM_SPLICE_WAIT_FOR_BOTH</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga753fc539949f2db7d1114d7ebd5b45b7a76dec5a78d423a9443f657ce2fac8c36</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>MenuAttribute</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a7df84578d37eccbf86072c8fc85b217a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MENU_ATTRIBUTE_ACTION</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a7df84578d37eccbf86072c8fc85b217aa86f1a371d32e9fab99744d963e04f5bb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MENU_ATTRIBUTE_LABEL</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a7df84578d37eccbf86072c8fc85b217aa4ae64afc7fe6c6660c51c6f486c040cf</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MENU_ATTRIBUTE_TARGET</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a7df84578d37eccbf86072c8fc85b217aa58117bdf3a42e57648845407823a3219</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>MenuLink</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a4febebe134c8e141020c6c253711e0d2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MENU_LINK_SECTION</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a4febebe134c8e141020c6c253711e0d2aa6356ca52c0aeb0abea871c903fa2b70</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MENU_LINK_SUBMENU</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a4febebe134c8e141020c6c253711e0d2a58cf137e0477ed185f5ff32ae84dcedc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>MountUnmountFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9fa1b6a8eabf8f88e4cf6d611a4cff44</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MOUNT_UNMOUNT_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga9fa1b6a8eabf8f88e4cf6d611a4cff44a1599c4ebeb5c0c6e9c312a4b9e4231b6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MOUNT_UNMOUNT_FORCE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga9fa1b6a8eabf8f88e4cf6d611a4cff44a8a1875392ebf634f2d02625395df5207</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>MountMountFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5484bace25c932fd4c7354259e138814</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MOUNT_MOUNT_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga5484bace25c932fd4c7354259e138814a73c8f98eedd8a952ae25a55533dc145d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>AskPasswordFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac807da73d3b89a6dc16dad028244e6ec</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ASK_PASSWORD_NEED_PASSWORD</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gac807da73d3b89a6dc16dad028244e6eca777e15d6610937851ef05608edb34d16</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ASK_PASSWORD_NEED_USERNAME</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gac807da73d3b89a6dc16dad028244e6eca01380b474c01152aeb2db5351adc14a5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ASK_PASSWORD_NEED_DOMAIN</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gac807da73d3b89a6dc16dad028244e6ecae283224523fe0a4c343984e1fd0e7a72</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ASK_PASSWORD_SAVING_SUPPORTED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gac807da73d3b89a6dc16dad028244e6eca4e5c4cd229b2d87c9fa505262e31a747</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ASK_PASSWORD_ANONYMOUS_SUPPORTED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gac807da73d3b89a6dc16dad028244e6eca58484c40d21ac105c3af15f845ef55f7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>PasswordSave</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gafec517575c8f8d6f48433c86da52448f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PASSWORD_SAVE_NEVER</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gafec517575c8f8d6f48433c86da52448faedf9056b0e9394620857b9b142b4ceb3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PASSWORD_SAVE_FOR_SESSION</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gafec517575c8f8d6f48433c86da52448fa11147906f5de9af5313c3dc99223e4dd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PASSWORD_SAVE_PERMANENTLY</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gafec517575c8f8d6f48433c86da52448fa3372ea635ae7fa7c23f2941211703bba</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>MountOperationResult</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac479310f8df4ad5909d717caec261076</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MOUNT_OPERATION_HANDLED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gac479310f8df4ad5909d717caec261076aadc695f34c2910427dc53ceb41785ffb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MOUNT_OPERATION_ABORTED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gac479310f8df4ad5909d717caec261076a88bb44b71d0d353785c6b60b42bb5e9a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MOUNT_OPERATION_UNHANDLED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gac479310f8df4ad5909d717caec261076a22c0d4477019d21864affc0e6739b51d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>OutputStreamSpliceFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7c30d67e5f60d33fdcd3053123feea74</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>OUTPUT_STREAM_SPLICE_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7c30d67e5f60d33fdcd3053123feea74a4a8d0f68799497978b5baaf64a453435</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>OUTPUT_STREAM_SPLICE_CLOSE_SOURCE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7c30d67e5f60d33fdcd3053123feea74abc66eea22d58051ebd68f30510264db5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>OUTPUT_STREAM_SPLICE_CLOSE_TARGET</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7c30d67e5f60d33fdcd3053123feea74a342a9302a3953a86a706a5d016df4fc4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>ResolverRecordType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7305dc7c78903a65491f3a505f55e966</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>RESOLVER_RECORD_SRV</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7305dc7c78903a65491f3a505f55e966ac548d0dd4d1ca0dc44e0198026d97743</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>RESOLVER_RECORD_MX</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7305dc7c78903a65491f3a505f55e966a659ee77f7a108769e0a5ed1bd8d623cc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>RESOLVER_RECORD_TXT</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7305dc7c78903a65491f3a505f55e966a88dfa057fc978cf1b44d97cc524b4fba</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>RESOLVER_RECORD_SOA</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7305dc7c78903a65491f3a505f55e966ac16f3405fc29e0a668b86d50c297242b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>RESOLVER_RECORD_NS</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga7305dc7c78903a65491f3a505f55e966ad1009cbb36502af096ebbbe783b7a6ee</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>SettingsBindFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab41e4379084ff04d75104143d99ecf61</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SETTINGS_BIND_DEFAULT</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gab41e4379084ff04d75104143d99ecf61a3ce16849b0de4e3ee431fdc4b9e22743</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SETTINGS_BIND_GET</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gab41e4379084ff04d75104143d99ecf61aa319946ecd163150075ef1ab0f19284c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SETTINGS_BIND_SET</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gab41e4379084ff04d75104143d99ecf61a80140cfe9c11b5cea3600728f9d82ede</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SETTINGS_BIND_NO_SENSITIVITY</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gab41e4379084ff04d75104143d99ecf61a4f626b2d4de6868c5a90cac6e1ce19f7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SETTINGS_BIND_GET_NO_CHANGES</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gab41e4379084ff04d75104143d99ecf61ad9391f896ba987bdf6eb6c41e33b4f8f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SETTINGS_BIND_INVERT_BOOLEAN</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gab41e4379084ff04d75104143d99ecf61a3ad9eea211350bc06670ff384d0e8268</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>SocketType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2302a45e052658e343729e0be2fd3310</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_TYPE_INVALID</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga2302a45e052658e343729e0be2fd3310a49bd4b46e7905c9394731d0abadb2e02</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_TYPE_STREAM</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga2302a45e052658e343729e0be2fd3310afc55c511821dc58a492d7c474a1b1ea8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_TYPE_DATAGRAM</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga2302a45e052658e343729e0be2fd3310ae1eef5b09f7187e72db09c0f7bfaf944</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_TYPE_SEQPACKET</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga2302a45e052658e343729e0be2fd3310a1b81d801009c9471bbeb3aba2412b6a1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>SocketProtocol</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4e8932017a600fffa5e8e6b5f6ea5b16</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_PROTOCOL_UNKNOWN</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga4e8932017a600fffa5e8e6b5f6ea5b16ab3f91855912cd06d5ae3cdc79ce65a97</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_PROTOCOL_DEFAULT</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga4e8932017a600fffa5e8e6b5f6ea5b16a96f0a62cfb9d0121dff3b1cbb86588e4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_PROTOCOL_TCP</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga4e8932017a600fffa5e8e6b5f6ea5b16ad06eafdd4ba6c1989f0e79da060bd968</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_PROTOCOL_UDP</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga4e8932017a600fffa5e8e6b5f6ea5b16a68e3a82b9749e8503d2121bcc8528102</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_PROTOCOL_SCTP</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga4e8932017a600fffa5e8e6b5f6ea5b16a1f4d47329d9ef942f5d20247da0b4c6d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>SocketMsgFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga11f5e6b2ba2903428e93d947c82fa04e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_MSG_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga11f5e6b2ba2903428e93d947c82fa04ea566eba142e4067e3510eb479d177ffad</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_MSG_OOB</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga11f5e6b2ba2903428e93d947c82fa04ea1d7b6de8ed171562d9254f285f5a5993</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_MSG_PEEK</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga11f5e6b2ba2903428e93d947c82fa04eab353a9d8f6a5efbd5c5b5f70b3310b25</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_MSG_DONTROUTE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga11f5e6b2ba2903428e93d947c82fa04ea4d60627f51602e0da0f517d544236be0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>SocketClientEvent</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf8428cdf057aabdd8990b5e0a8021adc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_CLIENT_RESOLVING</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaf8428cdf057aabdd8990b5e0a8021adcaf27ff2bb8aa4bfba7f530914302e6b68</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_CLIENT_RESOLVED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaf8428cdf057aabdd8990b5e0a8021adcad20a5e4f48335b65d71dd81fbb4e45ab</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_CLIENT_CONNECTING</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaf8428cdf057aabdd8990b5e0a8021adcaab53be1516a7898addfa234505380c91</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_CLIENT_CONNECTED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaf8428cdf057aabdd8990b5e0a8021adca272d5c7a7ff4f8cc2dfb3f35a70293ee</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_CLIENT_PROXY_NEGOTIATING</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaf8428cdf057aabdd8990b5e0a8021adcad78637c6c51ffe5f0ee87445241ee07a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_CLIENT_PROXY_NEGOTIATED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaf8428cdf057aabdd8990b5e0a8021adca88d3229819861b95e92db313a03178fb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_CLIENT_TLS_HANDSHAKING</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaf8428cdf057aabdd8990b5e0a8021adca6a19a1c046f9c1a7a48c035c15f2e9ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_CLIENT_TLS_HANDSHAKED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaf8428cdf057aabdd8990b5e0a8021adca9b4da0f454f3921280a4b53d627e5509</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SOCKET_CLIENT_COMPLETE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaf8428cdf057aabdd8990b5e0a8021adcae48a58af767d126bf0b857f01606274a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>TlsRehandshakeMode</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9730680b829b7745e4f36c1540761f3f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_REHANDSHAKE_NEVER</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga9730680b829b7745e4f36c1540761f3fac8ff1b158382a7e0944ca22d36efa45d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_REHANDSHAKE_SAFELY</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga9730680b829b7745e4f36c1540761f3faa634954ea0400e153992717d5cb26cdc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_REHANDSHAKE_UNSAFELY</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga9730680b829b7745e4f36c1540761f3fa2176f716b50ba1295c669015897f5a81</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>TlsDatabaseVerifyFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa46a3fc37c1e5566af625d7db3123a4b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_DATABASE_VERIFY_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaa46a3fc37c1e5566af625d7db3123a4bae878bdddf57ebe9c6763e09cbeb1d0db</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>TlsDatabaseLookupFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga0de6ee7362d49df4f068b6214b93a076</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_DATABASE_LOOKUP_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0de6ee7362d49df4f068b6214b93a076ab4bcee74e44c9e07b862aea638a6a702</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_DATABASE_LOOKUP_KEYPAIR</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga0de6ee7362d49df4f068b6214b93a076a4a63bab7d12dc952756580064d71a0a6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>TlsInteractionResult</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga13ffba1819a4d780593c50266d7a9484</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_INTERACTION_UNHANDLED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga13ffba1819a4d780593c50266d7a9484a9124d1a05b6e51fcfb74d1c5dfe81444</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_INTERACTION_HANDLED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga13ffba1819a4d780593c50266d7a9484ae073f3fa9246f1aaf14cca26b643c0bb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_INTERACTION_FAILED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga13ffba1819a4d780593c50266d7a9484a246a89fbc6dd9fa82f7fe072f20d6ed8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>TlsCertificateRequestFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaab2a17acffc49fca7080e27fd1e61996</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_CERTIFICATE_REQUEST_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaab2a17acffc49fca7080e27fd1e61996a1a43c45f95ab7c4cd60f77d3a668579d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>TlsPasswordFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8ac18330be9383471445ba62336a929a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_PASSWORD_NONE</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga8ac18330be9383471445ba62336a929aa974fc670e6e7a7a558552003dd192b00</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_PASSWORD_RETRY</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga8ac18330be9383471445ba62336a929aa13f226bbdab3f2abb89c5bdc6aabbbff</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_PASSWORD_MANY_TRIES</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga8ac18330be9383471445ba62336a929aae3b9f706b9a6b6d6c63dc9c1d2609911</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TLS_PASSWORD_FINAL_TRY</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ga8ac18330be9383471445ba62336a929aa231f395c8c272846b106aee9690901eb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>ZlibCompressorFormat</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab247c6072c566753c8b9762f66e84c02</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ZLIB_COMPRESSOR_FORMAT_ZLIB</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gab247c6072c566753c8b9762f66e84c02ab635cfa0d0ddeafe35f7e3c8ad411e1e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ZLIB_COMPRESSOR_FORMAT_GZIP</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gab247c6072c566753c8b9762f66e84c02a0c0304ef454aaf0d34a180241d3c604b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ZLIB_COMPRESSOR_FORMAT_RAW</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gab247c6072c566753c8b9762f66e84c02a97beae051e98c770a6185a3336390fda</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>UnixSocketAddressType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf842f4597d522154407164deb4906c2e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNIX_SOCKET_ADDRESS_INVALID</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaf842f4597d522154407164deb4906c2eaeefc2bdc5ec67828a46119a74c8e7143</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNIX_SOCKET_ADDRESS_ANONYMOUS</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaf842f4597d522154407164deb4906c2ea93c2605ae77d14182f21150b0b399b95</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNIX_SOCKET_ADDRESS_PATH</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaf842f4597d522154407164deb4906c2eaa81d365fa4258138dd887b23768fd30d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNIX_SOCKET_ADDRESS_ABSTRACT</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaf842f4597d522154407164deb4906c2eae50800b7fb801e830b3ead075c13d644</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNIX_SOCKET_ADDRESS_ABSTRACT_PADDED</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>gaf842f4597d522154407164deb4906c2ea7deb4d7d3c78b7f9bd191b853ede3f88</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac2ae439cef63de06f97ed8454b67ec32</anchor>
      <arglist>(AppInfoCreateFlags lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1f0f1235c25f5552c8a1467697bd66d3</anchor>
      <arglist>(AppInfoCreateFlags lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9f582e5773b615c406ceb28b695b7015</anchor>
      <arglist>(AppInfoCreateFlags lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga302df8457f421e75eaea25a67cb63c19</anchor>
      <arglist>(AppInfoCreateFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaccda1b3df9583689a62a3add6715f640</anchor>
      <arglist>(AppInfoCreateFlags &amp;lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga179d7c2a3d709c7a8e4a0796a8b5e833</anchor>
      <arglist>(AppInfoCreateFlags &amp;lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5dac484830e37250c0942325fb4b85a3</anchor>
      <arglist>(AppInfoCreateFlags &amp;lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ApplicationFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga44ea3f3bc13b4f365f8b2423a9ac6697</anchor>
      <arglist>(ApplicationFlags lhs, ApplicationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ApplicationFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga69ea1b280906db58e7da69dfa8e967f4</anchor>
      <arglist>(ApplicationFlags lhs, ApplicationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ApplicationFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf78c94e5bddf6119131fc2925e25e4db</anchor>
      <arglist>(ApplicationFlags lhs, ApplicationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ApplicationFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabfccee773f2311c38a00aa0d1ecbe3ac</anchor>
      <arglist>(ApplicationFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>ApplicationFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7f8cf604f276081f162dfe2e78e5e76a</anchor>
      <arglist>(ApplicationFlags &amp;lhs, ApplicationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ApplicationFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga786d1f08e7b472c5474df9bf6ebe1a1b</anchor>
      <arglist>(ApplicationFlags &amp;lhs, ApplicationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ApplicationFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga58651ff4ec0b8e4ca0fd0e868e8f09cf</anchor>
      <arglist>(ApplicationFlags &amp;lhs, ApplicationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ConverterFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9f956fe651a1375f27fc596f1ade2ab6</anchor>
      <arglist>(ConverterFlags lhs, ConverterFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ConverterFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaed01900163c4efb6fc8b072ace92a4ff</anchor>
      <arglist>(ConverterFlags lhs, ConverterFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ConverterFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa24dddaf6719113c40e5c8ec9694cf05</anchor>
      <arglist>(ConverterFlags lhs, ConverterFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ConverterFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1ca85527dd594724362f3a6e8d1ad466</anchor>
      <arglist>(ConverterFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>ConverterFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga006555992fbb516f1cea93b762566516</anchor>
      <arglist>(ConverterFlags &amp;lhs, ConverterFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ConverterFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga09dd687bd08618a59a4a0128521f12ca</anchor>
      <arglist>(ConverterFlags &amp;lhs, ConverterFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ConverterFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga65a84e2cc906ff5924d3eb0af66b56b2</anchor>
      <arglist>(ConverterFlags &amp;lhs, ConverterFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga38b31de13d1949c2acb9255bdc858767</anchor>
      <arglist>(DriveStartFlags lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7c4f37b1ef92224ac50016d49c95bf00</anchor>
      <arglist>(DriveStartFlags lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae75239258d148626dc4b0048b55a4c44</anchor>
      <arglist>(DriveStartFlags lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf625621abb6c686d449c3f3c43aee02c</anchor>
      <arglist>(DriveStartFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga994648faf5be7fd03bc1929554044dac</anchor>
      <arglist>(DriveStartFlags &amp;lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga77b3f8597aac448c2dd860f204e32b8f</anchor>
      <arglist>(DriveStartFlags &amp;lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1c0e50bc08aaf61dc1fbbe786c5e6b33</anchor>
      <arglist>(DriveStartFlags &amp;lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsCertificateFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga22c0194e634b597f4dcec67551a7ca9b</anchor>
      <arglist>(TlsCertificateFlags lhs, TlsCertificateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsCertificateFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1380174558e94de7c9c8b36b56332550</anchor>
      <arglist>(TlsCertificateFlags lhs, TlsCertificateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsCertificateFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9fd8470137571e8eef6bc1af201a5867</anchor>
      <arglist>(TlsCertificateFlags lhs, TlsCertificateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsCertificateFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8fd13816125414ef8f52696da2c1e0ca</anchor>
      <arglist>(TlsCertificateFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>TlsCertificateFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga69a2edc59567e8ddc43d718a01ca11a3</anchor>
      <arglist>(TlsCertificateFlags &amp;lhs, TlsCertificateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsCertificateFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9b25fecd6c1e006bac8f384156bfe80a</anchor>
      <arglist>(TlsCertificateFlags &amp;lhs, TlsCertificateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsCertificateFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7960cd8bde85baaf03372bf57015d123</anchor>
      <arglist>(TlsCertificateFlags &amp;lhs, TlsCertificateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaba7574ea0b336541af125d4eb9423088</anchor>
      <arglist>(FileQueryInfoFlags lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gafd57fe410ba970bb3cb78eb1c9942aeb</anchor>
      <arglist>(FileQueryInfoFlags lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gacae77e10133f304081534efa76be4a52</anchor>
      <arglist>(FileQueryInfoFlags lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga42422c40ea08ec4f0ad74c8e2a657eb5</anchor>
      <arglist>(FileQueryInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac59d6f3b6a2adca24d2763ba2af99a02</anchor>
      <arglist>(FileQueryInfoFlags &amp;lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga203c5d02679e3aa4c78080fb9269b1f9</anchor>
      <arglist>(FileQueryInfoFlags &amp;lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga55adc6ecb3a15cb850b30bafb7eb9248</anchor>
      <arglist>(FileQueryInfoFlags &amp;lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga431f17ab67ccea562ea556c10df6bd27</anchor>
      <arglist>(FileCreateFlags lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4a52dbf7b71137a0d00ef49c0eb163a6</anchor>
      <arglist>(FileCreateFlags lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab4d3e010c78b9f5ca2673210269b999d</anchor>
      <arglist>(FileCreateFlags lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga703109997bbde3b6a686dd36ec9d35ad</anchor>
      <arglist>(FileCreateFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4f6ed1c3e6f2a3a7d394b62f3166df7a</anchor>
      <arglist>(FileCreateFlags &amp;lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga43d71b19c0e673331de89e1b1d84679b</anchor>
      <arglist>(FileCreateFlags &amp;lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga045123aaa65f69e2a76a488d1024e34d</anchor>
      <arglist>(FileCreateFlags &amp;lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga0b841b27ceceb381f08e1bc5cf929eb1</anchor>
      <arglist>(FileCopyFlags lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabb1d7757198076b221ba038b1d3ae841</anchor>
      <arglist>(FileCopyFlags lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga29b016e93e7a6dfdebc4f9f6e4fbf1c1</anchor>
      <arglist>(FileCopyFlags lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga70312f36423a73fbf663c64824631dc8</anchor>
      <arglist>(FileCopyFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabb9c03e9bbf1ef698696dc08b0d36371</anchor>
      <arglist>(FileCopyFlags &amp;lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gad2f22009032ff6f0975c5a5701ca061d</anchor>
      <arglist>(FileCopyFlags &amp;lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga514b3929469585c9cfc222ef2daf4fea</anchor>
      <arglist>(FileCopyFlags &amp;lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab3fab04e51aeff08aaf235f038e50d72</anchor>
      <arglist>(FileMonitorFlags lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf801bc2b57ef5136eba961cdcd68e2e6</anchor>
      <arglist>(FileMonitorFlags lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga81b5df359bd6a61df867af8274d182ae</anchor>
      <arglist>(FileMonitorFlags lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga501c69e3e5101b66d2e5fb8181229b2c</anchor>
      <arglist>(FileMonitorFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8af51d7b4e7b78d3f0153090674470aa</anchor>
      <arglist>(FileMonitorFlags &amp;lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae45bc889f678f9f87ff04596b0de7d1a</anchor>
      <arglist>(FileMonitorFlags &amp;lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaffa032f65b2c0270e12fe6bafa5c36bf</anchor>
      <arglist>(FileMonitorFlags &amp;lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMeasureFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga881f9e3f716eea055f2436e00f817bcd</anchor>
      <arglist>(FileMeasureFlags lhs, FileMeasureFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMeasureFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga62c11254603103531378a6c86f251519</anchor>
      <arglist>(FileMeasureFlags lhs, FileMeasureFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMeasureFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga178b6b7a47d7191a834ba91ef45d8900</anchor>
      <arglist>(FileMeasureFlags lhs, FileMeasureFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMeasureFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga73ba283b4941eb5ed0586c5de9e687af</anchor>
      <arglist>(FileMeasureFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileMeasureFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8b334fb16e12f2fb292818af8f91430b</anchor>
      <arglist>(FileMeasureFlags &amp;lhs, FileMeasureFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMeasureFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gad1b04b5b1c7c54552cd86d3ec144ec24</anchor>
      <arglist>(FileMeasureFlags &amp;lhs, FileMeasureFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMeasureFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1dd67b3e69f82f1ae7d29ae6a36a0571</anchor>
      <arglist>(FileMeasureFlags &amp;lhs, FileMeasureFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3779f0623bf9380fb656028b9bc88323</anchor>
      <arglist>(FileAttributeInfoFlags lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga31f3ea9c0f0f3b94b829cff51a483da3</anchor>
      <arglist>(FileAttributeInfoFlags lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gade49ce26dfa73eb2eb9fc56534ac1319</anchor>
      <arglist>(FileAttributeInfoFlags lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9150f4358ab779fd1267151c4ee84a46</anchor>
      <arglist>(FileAttributeInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gadebdfefd85c32a1b626bce9ae251138b</anchor>
      <arglist>(FileAttributeInfoFlags &amp;lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4d263feb91a513421902169e234bb8c3</anchor>
      <arglist>(FileAttributeInfoFlags &amp;lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf8c86d142fcb81426bc429d51da4f7d9</anchor>
      <arglist>(FileAttributeInfoFlags &amp;lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOStreamSpliceFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gadd33991052b8c7b6d70b6afd4c4b3850</anchor>
      <arglist>(IOStreamSpliceFlags lhs, IOStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOStreamSpliceFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac4e194f1ff1b6337b2001528aad67bc9</anchor>
      <arglist>(IOStreamSpliceFlags lhs, IOStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOStreamSpliceFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga798437d9bba38467f6bf1eb02935f618</anchor>
      <arglist>(IOStreamSpliceFlags lhs, IOStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOStreamSpliceFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga69033ae6dd34521e4951f4a5ca14dfff</anchor>
      <arglist>(IOStreamSpliceFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>IOStreamSpliceFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gadeb0ed62d112c12255260042ff0205dd</anchor>
      <arglist>(IOStreamSpliceFlags &amp;lhs, IOStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOStreamSpliceFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab782a172a6c7d8b540c720f86fd5ad44</anchor>
      <arglist>(IOStreamSpliceFlags &amp;lhs, IOStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOStreamSpliceFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gad48e0449d3be29a9e01e27982d62fad6</anchor>
      <arglist>(IOStreamSpliceFlags &amp;lhs, IOStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga42e2925c2e192eb3e9b71b727e676644</anchor>
      <arglist>(MountUnmountFlags lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9ab823e8ba96b485774da1e93c7e576f</anchor>
      <arglist>(MountUnmountFlags lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga76909c76363248e860a94b20dad18ad9</anchor>
      <arglist>(MountUnmountFlags lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gace7018ee540582a709530dce1dd9191a</anchor>
      <arglist>(MountUnmountFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2d1ab6ef14833802a3615e54b8115aa8</anchor>
      <arglist>(MountUnmountFlags &amp;lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae1e6af7ffa613a35d110daedd6671389</anchor>
      <arglist>(MountUnmountFlags &amp;lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga6a939c0dc5f5b25dbad5cdb7a1848184</anchor>
      <arglist>(MountUnmountFlags &amp;lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1248f40d35ae4fb70d74c5df295cb4ae</anchor>
      <arglist>(MountMountFlags lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa459981a578b6e5ee443681687f9a777</anchor>
      <arglist>(MountMountFlags lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga02952bdc6c064b144e6667e326618c2d</anchor>
      <arglist>(MountMountFlags lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga74223d1de9c9db1c53429a6d23671d4f</anchor>
      <arglist>(MountMountFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaab40e5b0bc75d3308e8cb78606c4eb18</anchor>
      <arglist>(MountMountFlags &amp;lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga24a69ca68eff0e99a80c1c73f32c304e</anchor>
      <arglist>(MountMountFlags &amp;lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gad941eb418369c3f95f0b5c046e7d868d</anchor>
      <arglist>(MountMountFlags &amp;lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab444ed2fbe1877464f469a64d9107e36</anchor>
      <arglist>(AskPasswordFlags lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8a45caccd402223c595e5a160f15f030</anchor>
      <arglist>(AskPasswordFlags lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf0b37f457e38844832549486982ed1d8</anchor>
      <arglist>(AskPasswordFlags lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga993dba04647b8f34ad72e86cbc88ba34</anchor>
      <arglist>(AskPasswordFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga01e87fab2e1906ac5eafa153747ceae9</anchor>
      <arglist>(AskPasswordFlags &amp;lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga90dc37e16010e611eed712a21ee0a787</anchor>
      <arglist>(AskPasswordFlags &amp;lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8e3411a2fa7d7f016953b5f84dbad4c1</anchor>
      <arglist>(AskPasswordFlags &amp;lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaef500d088ea9d123dc514f71c4c67b1d</anchor>
      <arglist>(OutputStreamSpliceFlags lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga39f9583f05c94f16ce6228b52663e4e4</anchor>
      <arglist>(OutputStreamSpliceFlags lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga14a79b6dee4f711a22b52bf259539e34</anchor>
      <arglist>(OutputStreamSpliceFlags lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gafcded381df7535fe7c41bb8f8c21c169</anchor>
      <arglist>(OutputStreamSpliceFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5602d53794a62a9e823005e6f9aed428</anchor>
      <arglist>(OutputStreamSpliceFlags &amp;lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab363845e9d7769f38c78dc7cc55d9db6</anchor>
      <arglist>(OutputStreamSpliceFlags &amp;lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga01f192f0f1b9f66047d603780c458e6e</anchor>
      <arglist>(OutputStreamSpliceFlags &amp;lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>hostname_to_ascii</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a77e0b4b95d9ab0d2c2b21e79117ec77a</anchor>
      <arglist>(const Glib::ustring &amp;hostname)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>hostname_to_unicode</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a80496bf6a136c6b3a4d995849d0665af</anchor>
      <arglist>(const Glib::ustring &amp;hostname)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hostname_is_non_ascii</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a0d47bc4dc47f82a829ee5e00e13987f3</anchor>
      <arglist>(const Glib::ustring &amp;hostname)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hostname_is_ascii_encoded</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a58e3cc92152717d75a9f5cf4d260815d</anchor>
      <arglist>(const Glib::ustring &amp;hostname)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hostname_is_ip_address</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a19e270aea166c888515b97d0623f4309</anchor>
      <arglist>(const Glib::ustring &amp;hostname)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8cd5ffb873f77345b515bf4ec2522ad7</anchor>
      <arglist>(SettingsBindFlags lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf9c3bdce8aa4209b368419a8a4f374a7</anchor>
      <arglist>(SettingsBindFlags lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabe81d29f028b8bfb85c189c2471a290d</anchor>
      <arglist>(SettingsBindFlags lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3faf22f64ae075a5465b7827001101d2</anchor>
      <arglist>(SettingsBindFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga0299f50197606d69c0f306224760fcdb</anchor>
      <arglist>(SettingsBindFlags &amp;lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga93c66617507b97c4ce9d5e7b99bd0c04</anchor>
      <arglist>(SettingsBindFlags &amp;lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3f4f0e3823c4d8ce3470b656913fb4e0</anchor>
      <arglist>(SettingsBindFlags &amp;lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa085ca077592487a87d8339ce3324166</anchor>
      <arglist>(SocketMsgFlags lhs, SocketMsgFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7483601181aa5da2467e986408d0136a</anchor>
      <arglist>(SocketMsgFlags lhs, SocketMsgFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaadfaf5e3a456218e23ca0ee13ac3db3d</anchor>
      <arglist>(SocketMsgFlags lhs, SocketMsgFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf31952f93c501b25194ad46df8994752</anchor>
      <arglist>(SocketMsgFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga62b41279cd63908c0736e96f868e832e</anchor>
      <arglist>(SocketMsgFlags &amp;lhs, SocketMsgFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga43e4984d2489a21f44a4ab961bf98541</anchor>
      <arglist>(SocketMsgFlags &amp;lhs, SocketMsgFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab892045d6e9cf73dc96593ead692145b</anchor>
      <arglist>(SocketMsgFlags &amp;lhs, SocketMsgFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsDatabaseVerifyFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga39e0d92d55656c2a2632f98636265306</anchor>
      <arglist>(TlsDatabaseVerifyFlags lhs, TlsDatabaseVerifyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsDatabaseVerifyFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga36f857562dfaa5bedb2f11bdcb713be2</anchor>
      <arglist>(TlsDatabaseVerifyFlags lhs, TlsDatabaseVerifyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsDatabaseVerifyFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8368dd487149972f892a91422e9bd33b</anchor>
      <arglist>(TlsDatabaseVerifyFlags lhs, TlsDatabaseVerifyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsDatabaseVerifyFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf2f0b0b2463b3e547db1a4b85603bd36</anchor>
      <arglist>(TlsDatabaseVerifyFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>TlsDatabaseVerifyFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga23b4f358bf1da65d761823c0c14601a3</anchor>
      <arglist>(TlsDatabaseVerifyFlags &amp;lhs, TlsDatabaseVerifyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsDatabaseVerifyFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gad2d6cac92ff624db2f477f5563ebe73b</anchor>
      <arglist>(TlsDatabaseVerifyFlags &amp;lhs, TlsDatabaseVerifyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsDatabaseVerifyFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gacf39fa96fbecf1a1eb1c265794b79c03</anchor>
      <arglist>(TlsDatabaseVerifyFlags &amp;lhs, TlsDatabaseVerifyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsDatabaseLookupFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga17032c82d6f99398b325773ecfbb8864</anchor>
      <arglist>(TlsDatabaseLookupFlags lhs, TlsDatabaseLookupFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsDatabaseLookupFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8801450685cbe42b72c590b4deaa0f47</anchor>
      <arglist>(TlsDatabaseLookupFlags lhs, TlsDatabaseLookupFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsDatabaseLookupFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaab103c2de8ca0e1abc5afb44a06ab7c7</anchor>
      <arglist>(TlsDatabaseLookupFlags lhs, TlsDatabaseLookupFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsDatabaseLookupFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae83d0705d3e1b6a1c1214802fd0413a7</anchor>
      <arglist>(TlsDatabaseLookupFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>TlsDatabaseLookupFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga70adec8becf6acbe4d1f3a7d32512647</anchor>
      <arglist>(TlsDatabaseLookupFlags &amp;lhs, TlsDatabaseLookupFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsDatabaseLookupFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4c1f3085e84fdd58ee013b45e624da10</anchor>
      <arglist>(TlsDatabaseLookupFlags &amp;lhs, TlsDatabaseLookupFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsDatabaseLookupFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gad91ca8afd55f164582fc2182414a567d</anchor>
      <arglist>(TlsDatabaseLookupFlags &amp;lhs, TlsDatabaseLookupFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsCertificateRequestFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf22bb92488cf1cd6097decfc5ccff4aa</anchor>
      <arglist>(TlsCertificateRequestFlags lhs, TlsCertificateRequestFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsCertificateRequestFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga546257d6ed4e6d44df743dab4b3f96c1</anchor>
      <arglist>(TlsCertificateRequestFlags lhs, TlsCertificateRequestFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsCertificateRequestFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabf70e6fec894c648a62a8b3057601b90</anchor>
      <arglist>(TlsCertificateRequestFlags lhs, TlsCertificateRequestFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsCertificateRequestFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9b6865e73e13095e7a4a57bbac28db74</anchor>
      <arglist>(TlsCertificateRequestFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>TlsCertificateRequestFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga25a044628996f41d7419dd2ea3631ca7</anchor>
      <arglist>(TlsCertificateRequestFlags &amp;lhs, TlsCertificateRequestFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsCertificateRequestFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1c9aafd291a44e3c108bd01423297899</anchor>
      <arglist>(TlsCertificateRequestFlags &amp;lhs, TlsCertificateRequestFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsCertificateRequestFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gad07b2cce57653f7ed382f2fecaba5798</anchor>
      <arglist>(TlsCertificateRequestFlags &amp;lhs, TlsCertificateRequestFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsPasswordFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gafbbaf640a1d770dc0bd46380763952e8</anchor>
      <arglist>(TlsPasswordFlags lhs, TlsPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsPasswordFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga58b2a4408d61617ba6bf6322aec97b3f</anchor>
      <arglist>(TlsPasswordFlags lhs, TlsPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsPasswordFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga18b59057b4efe6dfb55345e198c2dd4a</anchor>
      <arglist>(TlsPasswordFlags lhs, TlsPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsPasswordFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9c6566499acc6dbfb73ad14225ebaff4</anchor>
      <arglist>(TlsPasswordFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>TlsPasswordFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab3d9e43f9d3f79660d3eba8402cc3c7d</anchor>
      <arglist>(TlsPasswordFlags &amp;lhs, TlsPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsPasswordFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4b9578c71d74bf9ba422b1b906c766cf</anchor>
      <arglist>(TlsPasswordFlags &amp;lhs, TlsPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TlsPasswordFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1bf68c82d083fab33b612fe7756b7d56</anchor>
      <arglist>(TlsPasswordFlags &amp;lhs, TlsPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>content_type_equals</name>
      <anchorfile>group__giommContentType.html</anchorfile>
      <anchor>ga496c304f10ea79f1a20137bf614466e8</anchor>
      <arglist>(const Glib::ustring &amp;type1, const Glib::ustring &amp;type2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>content_type_is_a</name>
      <anchorfile>group__giommContentType.html</anchorfile>
      <anchor>ga278fca288c7c2e9995ebb64ce43a6ffd</anchor>
      <arglist>(const Glib::ustring &amp;type, const Glib::ustring &amp;supertype)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>content_type_is_unknown</name>
      <anchorfile>group__giommContentType.html</anchorfile>
      <anchor>gaee153086e7cd9f1ab0509cbf81ec06e9</anchor>
      <arglist>(const Glib::ustring &amp;type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>content_type_get_description</name>
      <anchorfile>group__giommContentType.html</anchorfile>
      <anchor>gac065cb89d7abb5935cfa225e3d41a732</anchor>
      <arglist>(const Glib::ustring &amp;type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>content_type_get_mime_type</name>
      <anchorfile>group__giommContentType.html</anchorfile>
      <anchor>ga92f379d45658e14f3ec1bec3da71d908</anchor>
      <arglist>(const Glib::ustring &amp;type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>content_type_get_icon</name>
      <anchorfile>group__giommContentType.html</anchorfile>
      <anchor>ga7972eb82466bf972bbbf5b58f6344e84</anchor>
      <arglist>(const Glib::ustring &amp;type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>content_type_get_symbolic_icon</name>
      <anchorfile>group__giommContentType.html</anchorfile>
      <anchor>gab55b0d4ac98b1aa0edab98afa66a8b6c</anchor>
      <arglist>(const Glib::ustring &amp;type)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>content_type_can_be_executable</name>
      <anchorfile>group__giommContentType.html</anchorfile>
      <anchor>gae5107c4e00134d7d9df3b755a74f9494</anchor>
      <arglist>(const Glib::ustring &amp;type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>content_type_from_mime_type</name>
      <anchorfile>group__giommContentType.html</anchorfile>
      <anchor>gad5432d8f8c8ba74f8157af9d49930b4c</anchor>
      <arglist>(const Glib::ustring &amp;mime_type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>content_type_guess</name>
      <anchorfile>group__giommContentType.html</anchorfile>
      <anchor>ga48e8afbb7f1724efcdebd7c028da5560</anchor>
      <arglist>(const std::string &amp;filename, const guchar *data, gsize data_size, bool &amp;result_uncertain)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>content_type_guess</name>
      <anchorfile>group__giommContentType.html</anchorfile>
      <anchor>gae46acc46aa5c33a8d1feda6a675fefa9</anchor>
      <arglist>(const std::string &amp;filename, const std::string &amp;data, bool &amp;result_uncertain)</arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>content_type_guess_for_tree</name>
      <anchorfile>group__giommContentType.html</anchorfile>
      <anchor>ga7e82e215c402edca50219020e43d08ec</anchor>
      <arglist>(const Glib::RefPtr&lt; const File &gt; &amp;root)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::ustring &gt;</type>
      <name>content_types_get_registered</name>
      <anchorfile>group__giommContentType.html</anchorfile>
      <anchor>gaeae6cd7ee77a7b1c52443116f346b476</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a28171d5c1584ce2516ba05b13cee04ec</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SignalSocket</type>
      <name>signal_socket</name>
      <anchorfile>group__NetworkIO.html</anchorfile>
      <anchor>ga73dc3243f51abce0a62424329724f510</anchor>
      <arglist>(const Glib::RefPtr&lt; Glib::MainContext &gt; &amp;context=Glib::RefPtr&lt; Glib::MainContext &gt;())</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Action</name>
    <filename>classGio_1_1Action.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Action</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a4d9e7b20f048a9687645febc90ba77ed</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GAction *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>ad7cd56bdda4c3128f15a65b125838bb4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GAction *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a1d93ffed2823714491005f8ef26cd1a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_name</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a1347f184c1699d4ca11a646adc8915e3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::VariantType</type>
      <name>get_parameter_type</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>aa2b2004f825c07e971d8c19f5d73ea93</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::VariantType</type>
      <name>get_state_type</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a2f8889d7aebdf63b5b660602dd5e6bd0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_state_hint</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a35fc43112b149f3f8f5f26d31b9509b0</anchor>
      <arglist>(T_Value &amp;value) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::VariantBase</type>
      <name>get_state_hint_variant</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a1fbf3cbeb62dc317d82b88034c8b002a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_enabled</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>ad18df46509b43cc647c7af5b1436c644</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>change_state</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a90da4d2d2a6660cf71ad49d4069565bc</anchor>
      <arglist>(const T_Value &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>change_state</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>aa2e58f99930c048265cccaec3224c7fd</anchor>
      <arglist>(const Glib::Variant&lt; T_Value &gt; &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>change_state_variant</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>ade53cd09b546f381f07b78a2e9d95279</anchor>
      <arglist>(const Glib::VariantBase &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>change_state</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a8337a39d2a7546831f4a567670614886</anchor>
      <arglist>(const Glib::VariantBase &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_state</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a307714aa099aed0aad62d27809da6659</anchor>
      <arglist>(T_Value &amp;value) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::VariantBase</type>
      <name>get_state_variant</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>acdc6842ea3ac76070d310b5162d54d30</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>activate</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a5ca6d1b8d24caf541f0c4ea9658446bd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>activate</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a9f669ad6ada8aa29202dfe58405bffb7</anchor>
      <arglist>(const T_Value &amp;parameter)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>activate</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>af296509987a6d370aa57f40e09a4a84a</anchor>
      <arglist>(const Glib::Variant&lt; T_Value &gt; &amp;parameter)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>activate_variant</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a638a85ba4a833fe573480ed786bef010</anchor>
      <arglist>(const Glib::VariantBase &amp;parameter)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>activate</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a37d9b6b05160bfb4044659330287f9b2</anchor>
      <arglist>(const Glib::VariantBase &amp;parameter)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>print_detailed_name</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a7a384060cbcf4e7d8160d494de2dd286</anchor>
      <arglist>(const T_Value &amp;target_value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_enabled</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a066748f4a413caab2013b92cee2a31de</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_name</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a12abd796b38f0888f0782d88401da938</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::VariantType &gt;</type>
      <name>property_parameter_type</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>aea8077cd9896726dc3d1f7deac1197dd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::VariantBase &gt;</type>
      <name>property_state</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>ad7abdb4e5a6a3eb8941756eac836af27</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::VariantType &gt;</type>
      <name>property_state_type</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>aec9a1d46db1c239804cc8acc7923aeb4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_name_vfunc</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a49381270fc99336ba74f07fdaff4a60a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::VariantType</type>
      <name>get_parameter_type_vfunc</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a1c1cf8c9a1411886b8200876655dd58a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::VariantType</type>
      <name>get_state_type_vfunc</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a9a108c6228ba75165fd284bc438d519e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::VariantBase</type>
      <name>get_state_hint_vfunc</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a6a002bf97328fb5e59f100f8628b076d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>get_enabled_vfunc</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a8308a5e9e7f62af0c910c55ca2272119</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::VariantBase</type>
      <name>get_state_vfunc</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a34e7a455d18b8aa71525b217cedfbcf2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>change_state_vfunc</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a8d838854ab0998b8efdd3bb810d4429f</anchor>
      <arglist>(const Glib::VariantBase &amp;value)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>activate_vfunc</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a7e8062660469df51e34198ce39d63d59</anchor>
      <arglist>(const Glib::VariantBase &amp;parameter)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Interface</name>
      <anchorfile>classGlib_1_1Interface.html</anchorfile>
      <anchor>a3ab20f29c40967352d1bf2d88bfe11e5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Interface</name>
      <anchorfile>classGlib_1_1Interface.html</anchorfile>
      <anchor>ae05bf6a4ce0f0992c2ad01429d13f9f7</anchor>
      <arglist>(const Glib::Interface_Class &amp;interface_class)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Interface</name>
      <anchorfile>classGlib_1_1Interface.html</anchorfile>
      <anchor>a00253b22a76f751f1627865451cbc404</anchor>
      <arglist>(GObject *castitem)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Interface</name>
      <anchorfile>classGlib_1_1Interface.html</anchorfile>
      <anchor>a8e12a7a3e0281e28798326ad65e3560c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GObject *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1Interface.html</anchorfile>
      <anchor>a969e9396f75132a9577428f4fa932d42</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GObject *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1Interface.html</anchorfile>
      <anchor>a70a443071a69d3372c2cdd7128a91ed1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_property_value</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>aab599d3eec4b4a9ddc95ccdc6100053d</anchor>
      <arglist>(const Glib::ustring &amp;property_name, const Glib::ValueBase &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_property_value</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>a5e30750441b92f0246c9d4ece95fc8a0</anchor>
      <arglist>(const Glib::ustring &amp;property_name, Glib::ValueBase &amp;value) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_property</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>ad37844f7ea2c0091a22d011e04c48820</anchor>
      <arglist>(const Glib::ustring &amp;property_name, const PropertyType &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_property</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>a5f894c9c36ad391fdc85552af67a8530</anchor>
      <arglist>(const Glib::ustring &amp;property_name, PropertyType &amp;value) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>connect_property_changed</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>adc6c1e8f094275114d6e2c3ef3a33f98</anchor>
      <arglist>(const Glib::ustring &amp;property_name, const sigc::slot&lt; void &gt; &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>sigc::connection</type>
      <name>connect_property_changed_with_return</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>a896d7773c00bd2dcd310c861282ee8d1</anchor>
      <arglist>(const Glib::ustring &amp;property_name, const sigc::slot&lt; void &gt; &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>freeze_notify</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>a6e9e13b75f116c20212d318204ce8ea3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>thaw_notify</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>a1bd8ea7bd8c4084ade6b3c27dddf06a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>reference</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>a896a8a5db20043ea82956e3ef4b9c4ae</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>unreference</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>a3234b8ffb2a35b927e2978c8f3bfbfe3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GObject *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>a4c6efc18be8cb9c56e58fc0bd20fafbe</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GObject *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>a778a94181132976bbfb0519793f3b32e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GObject *</type>
      <name>gobj_copy</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>a9b2a5eb93102f1849e5419016e22a15f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>ada7d2f0ad7524c3addb5f8bc3956f005</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a508f2dd4565bcc8afdbf92835a8e668d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>name_is_valid</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a50947296af8797dc7105378c8ee94ada</anchor>
      <arglist>(const Glib::ustring &amp;action_name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>parse_detailed_name</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>af9499f200e298f81f88e19402d7c7217</anchor>
      <arglist>(const Glib::ustring &amp;detailed_name, Glib::ustring &amp;action_name, T_Value &amp;target_value)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>parse_detailed_name_variant</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a168bcf6023c045232cd225a80a0bd7d9</anchor>
      <arglist>(const Glib::ustring &amp;detailed_name, Glib::ustring &amp;action_name, Glib::VariantBase &amp;target_value)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::ustring</type>
      <name>print_detailed_name_variant</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>aebbb8988cbd0ff6caab00ca3ccb28416</anchor>
      <arglist>(const Glib::ustring &amp;action_name, const Glib::VariantBase &amp;target_value)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Action</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a6dab71d4d3af45977f0931e7ebf9fddf</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>ObjectBase</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>a27d3451d9ca28d6a2f00838d7c56d545</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>ObjectBase</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>ad4ef18214894c6874579313ab21d1018</anchor>
      <arglist>(const char *custom_type_name)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>ObjectBase</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>a3d59b4d85b0ee72a727e6b2e1b31a2ff</anchor>
      <arglist>(const std::type_info &amp;custom_type_info)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="pure">
      <type>virtual</type>
      <name>~ObjectBase</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>a42ac047a06c36c2d9c75f7cffc537dc4</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>initialize</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>a3faafb14c4f0ca60fbf0f5f5c4d549d0</anchor>
      <arglist>(GObject *castitem)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Action &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a51714129b90228d8921685cd2783f62f</anchor>
      <arglist>(GAction *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::ActionGroup</name>
    <filename>classGio_1_1ActionGroup.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~ActionGroup</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a1ab7a30ac8bd8c5a6ce58bfb9665c14e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GActionGroup *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>affe86c6498361e348fe33be39be04ab0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GActionGroup *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a5ca7db192b98be14cd12002918c43acd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_action</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a84d4936c728e51217ad7c018aff9735a</anchor>
      <arglist>(const Glib::ustring &amp;action_name) const </arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Glib::ustring &gt;</type>
      <name>list_actions</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>afa8e5b5751cdd43ace13ce529bbe3d5c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>query_action</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a19e7a3c5f3e49adbf92cac1e2b6966a7</anchor>
      <arglist>(const Glib::ustring &amp;action_name, bool &amp;enabled, Glib::VariantType &amp;parameter_type, Glib::VariantBase &amp;state_hint, Glib::VariantType &amp;state_type, Glib::VariantBase &amp;state)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>query_action</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a28aa7ffebc5e1880cfb57f5fb0ff1d3f</anchor>
      <arglist>(const Glib::ustring &amp;action_name, bool &amp;enabled, Glib::VariantType &amp;parameter_type, Glib::VariantBase &amp;state_hint, Glib::VariantType &amp;state_type)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>query_action</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a896c0f50d6c4fd4cc17b22d363b7ad81</anchor>
      <arglist>(const Glib::ustring &amp;action_name, bool &amp;enabled, Glib::VariantType &amp;parameter_type, Glib::VariantBase &amp;state_hint, Glib::VariantBase &amp;state)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>query_action</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>acfc61788cb9bc2b4b923763f0483b51e</anchor>
      <arglist>(const Glib::ustring &amp;action_name, bool &amp;enabled, Glib::VariantType &amp;parameter_type, Glib::VariantBase &amp;state_hint)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>query_action</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a788c4e56d0077bd8662968ccdd86e2b6</anchor>
      <arglist>(const Glib::ustring &amp;action_name, bool &amp;enabled, Glib::VariantBase &amp;state_hint, Glib::VariantType &amp;state_type, Glib::VariantBase &amp;state)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>query_action</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>af4678fc74b915ecd70a36fa911276105</anchor>
      <arglist>(const Glib::ustring &amp;action_name, bool &amp;enabled, Glib::VariantBase &amp;state_hint, Glib::VariantType &amp;state_type)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>query_action</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>abdc51e18b1a5cb871db9194d636ea055</anchor>
      <arglist>(const Glib::ustring &amp;action_name, bool &amp;enabled, Glib::VariantBase &amp;state_hint, Glib::VariantBase &amp;state)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>query_action</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a6cd39881204a98dcf766f65d630c6e02</anchor>
      <arglist>(const Glib::ustring &amp;action_name, bool &amp;enabled, Glib::VariantBase &amp;state_hint)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_action_enabled</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>ae37272d155dd39689ff9fbf14e88a5d2</anchor>
      <arglist>(const Glib::ustring &amp;action_name) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::VariantType</type>
      <name>get_action_parameter_type</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>adeff709d2c6545425dccdc1cb8db970d</anchor>
      <arglist>(const Glib::ustring &amp;action_name) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::VariantType</type>
      <name>get_action_state_type</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>aae87a5a748cfcf9d49a0e998364f44c3</anchor>
      <arglist>(const Glib::ustring &amp;action_name) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::VariantContainerBase</type>
      <name>get_action_state_hint</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a00076dd913902d8bb2059f304cb75bfd</anchor>
      <arglist>(const Glib::ustring &amp;action_name) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_action_state_hint</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>ad106114d0284f6c73c12b8d39ae73062</anchor>
      <arglist>(const Glib::ustring &amp;action_name, T_Value &amp;value) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::VariantContainerBase</type>
      <name>get_action_state_hint_variant</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>ab320fd8b171387c9bd68968b7f4b2ede</anchor>
      <arglist>(const Glib::ustring &amp;action_name) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::VariantBase</type>
      <name>get_action_state</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a94819b439c950b7d295d5bd30e565d94</anchor>
      <arglist>(const Glib::ustring &amp;action_name) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_action_state</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a67792d211c065540fe88c18297525be4</anchor>
      <arglist>(const Glib::ustring &amp;action_name, T_Value &amp;value) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::VariantBase</type>
      <name>get_action_state_variant</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a059b62c090523b0165cd481cfd66cba7</anchor>
      <arglist>(const Glib::ustring &amp;action_name) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>change_action_state</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a4488ac862cf56001be245ccf4638d85c</anchor>
      <arglist>(const Glib::ustring &amp;action_name, const Glib::VariantBase &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>activate_action</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>acb1430eed8062a856c32b8e48f41ebe6</anchor>
      <arglist>(const Glib::ustring &amp;action_name, const Glib::VariantBase &amp;parameter)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>activate_action</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a96a3b2f5be80d7263a5acf8a8529d7eb</anchor>
      <arglist>(const Glib::ustring &amp;action_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>action_added</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a81e3d3f5123763a1a65e920deb7e1677</anchor>
      <arglist>(const Glib::ustring &amp;action_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>action_removed</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>ae4fb6c4dca623abffd51178fc87cc8b2</anchor>
      <arglist>(const Glib::ustring &amp;action_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>action_enabled_changed</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a9c9d5b01a16210ee40d2ee078c589253</anchor>
      <arglist>(const Glib::ustring &amp;action_name, bool enabled)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>action_state_changed</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a5a303e38b81629b094e7290f366a40ac</anchor>
      <arglist>(const Glib::ustring &amp;action_name, const Glib::VariantBase &amp;state)</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::ustring &amp; &gt;</type>
      <name>signal_action_added</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a17c569a317549b9b5ad43e5bd1fb08d7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy2&lt; void, const Glib::ustring &amp;, bool &gt;</type>
      <name>signal_action_enabled_changed</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a7377172c504f5c1cc77ef470e7ad6203</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::ustring &amp; &gt;</type>
      <name>signal_action_removed</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a8d6545755151ee7148aee898cf3bc126</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy2&lt; void, const Glib::ustring &amp;, const Glib::VariantBase &amp; &gt;</type>
      <name>signal_action_state_changed</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>ab712b9c47e43ef1b2769793e39a108ad</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>has_action_vfunc</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>aa879afef3b8fa9935bf685384cad6c37</anchor>
      <arglist>(const Glib::ustring &amp;name) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual std::vector&lt; Glib::ustring &gt;</type>
      <name>list_actions_vfunc</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>aaefd0ffc294ccc020e18706d4f6b8506</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>get_action_enabled_vfunc</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a3c4555915ba58b36770a081414706be7</anchor>
      <arglist>(const Glib::ustring &amp;name) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::VariantType</type>
      <name>get_action_parameter_type_vfunc</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a52f73cf9371ca92259812700cbbbcb54</anchor>
      <arglist>(const Glib::ustring &amp;name) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::VariantType</type>
      <name>get_action_state_type_vfunc</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>ada28868b0d1ca45f035125098a3feb66</anchor>
      <arglist>(const Glib::ustring &amp;name) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::VariantBase</type>
      <name>get_action_state_hint_vfunc</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>adefc14fee2bbda347daa09bc2539f987</anchor>
      <arglist>(const Glib::ustring &amp;name) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::VariantBase</type>
      <name>get_action_state_vfunc</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a0d0c03e41f072ff8277b072d61a110e8</anchor>
      <arglist>(const Glib::ustring &amp;name) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>change_action_state_vfunc</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>aa621807bd6c8ce09466a03f4b4d7cf04</anchor>
      <arglist>(const Glib::ustring &amp;name, const Glib::VariantBase &amp;value)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>activate_action_vfunc</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a0dca67391676bf10e3e4bd167dfeba62</anchor>
      <arglist>(const Glib::ustring &amp;name, const Glib::VariantBase &amp;parameter)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a19d09dd80a81909b8927ebe631de486a</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>abb04677c5e63eb413f111339ea385568</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>ActionGroup</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>ab609e11f0c2f1fc50b7a1fa44a28e052</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_action_added</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a1f2650b664d5147b80e90648cd765267</anchor>
      <arglist>(const Glib::ustring &amp;action_name)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_action_enabled_changed</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a9a7e4f8b6320487ef072937f1c617f29</anchor>
      <arglist>(const Glib::ustring &amp;action_name, bool enabled)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_action_removed</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>abfd41d6c32940285f651aaa09aede3d9</anchor>
      <arglist>(const Glib::ustring &amp;action_name)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_action_state_changed</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>acb99c786b38bc8b55d3b9d82df6a9853</anchor>
      <arglist>(const Glib::ustring &amp;action_name, const Glib::VariantBase &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::ActionGroup &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a428112d0fff62242c0d4e3f31f076f8c</anchor>
      <arglist>(GActionGroup *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::ActionMap</name>
    <filename>classGio_1_1ActionMap.html</filename>
    <base>Glib::Interface</base>
    <member kind="typedef">
      <type>sigc::slot&lt; void, const Glib::VariantBase &amp; &gt;</type>
      <name>ActivateWithParameterSlot</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>a0cfa34eeb24fa3c247bb0acf369c5bbb</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; void &gt;</type>
      <name>ActivateSlot</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>a20d1ef5a8675224179ebee86d59578a3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; void, const Glib::ustring &amp; &gt;</type>
      <name>ActivateWithStringParameterSlot</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>a5d938580b566117fc4a7aa4a6f31f651</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; void, int &gt;</type>
      <name>ActivateWithIntParameterSlot</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>a024a6233b274195332973872f0b5eaa9</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~ActionMap</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>ab2258a99d2e74bad302b62eb28be685c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GActionMap *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>a7733b9ec4c8ad7f36887661e1c5118d5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GActionMap *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>abc5e2ebd8c4d3470fb1ad863fe5833e4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Action &gt;</type>
      <name>lookup_action</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>aca337f535c1db1d435bbf79d9e7d3c0e</anchor>
      <arglist>(const Glib::ustring &amp;action_name)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Action &gt;</type>
      <name>lookup_action</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>a6d57243d90ce36096deddb26bb6ef5e4</anchor>
      <arglist>(const Glib::ustring &amp;action_name) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SimpleAction &gt;</type>
      <name>add_action</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>a784dfa4573e994ac452d5e2dd56a5909</anchor>
      <arglist>(const Glib::ustring &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SimpleAction &gt;</type>
      <name>add_action_with_parameter</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>a3548d329e7abda0d6325c1f75a799da6</anchor>
      <arglist>(const Glib::ustring &amp;name, const ActivateWithParameterSlot &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SimpleAction &gt;</type>
      <name>add_action</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>af98561d9fe5f98aa1e469be0ec55d82b</anchor>
      <arglist>(const Glib::ustring &amp;name, const ActivateSlot &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SimpleAction &gt;</type>
      <name>add_action_bool</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>aec19298dafe16546dd4c664fd3f3ef3f</anchor>
      <arglist>(const Glib::ustring &amp;name, bool state=false)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SimpleAction &gt;</type>
      <name>add_action_bool</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>a1e0cfe16737aa26601508a0b912f6fea</anchor>
      <arglist>(const Glib::ustring &amp;name, const ActivateSlot &amp;slot, bool state=false)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SimpleAction &gt;</type>
      <name>add_action_radio_string</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>a99f4d541960158961ba0e30209ca1b2d</anchor>
      <arglist>(const Glib::ustring &amp;name, const Glib::ustring &amp;state)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SimpleAction &gt;</type>
      <name>add_action_radio_string</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>a5324d4987143dadbd08d5696e99bb66d</anchor>
      <arglist>(const Glib::ustring &amp;name, const ActivateWithStringParameterSlot &amp;slot, const Glib::ustring &amp;state)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SimpleAction &gt;</type>
      <name>add_action_radio_integer</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>aaa389cd74fb2455308b9d19d8a06601e</anchor>
      <arglist>(const Glib::ustring &amp;name, gint32 state)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SimpleAction &gt;</type>
      <name>add_action_radio_integer</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>ad106a05dd5179295c5d037c1ebad66f9</anchor>
      <arglist>(const Glib::ustring &amp;name, const ActivateWithIntParameterSlot &amp;slot, gint32 state)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_action</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>a3cd54f21b2f817b279c6e47154610852</anchor>
      <arglist>(const Glib::RefPtr&lt; Action &gt; &amp;action)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_action</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>afd8bcc4209fae2afbb0aba3f90c8bb0d</anchor>
      <arglist>(const Glib::ustring &amp;action_name)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::RefPtr&lt; Action &gt;</type>
      <name>lookup_action_vfunc</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>a73863b440e8a07406dbd6c00812a4921</anchor>
      <arglist>(const Glib::ustring &amp;name) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>add_action_vfunc</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>a79a05019f8c79a4a6b9ab9e1837f8488</anchor>
      <arglist>(Glib::RefPtr&lt; Action &gt; action) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>remove_action_vfunc</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>af9666b169b2fc68093950d8aacf1cf28</anchor>
      <arglist>(const Glib::ustring &amp;name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>a6e390dc3b7c4bb4422fbfafbb3190173</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>a24704a273680f1947ea09b72a6268146</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>ActionMap</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>ad507af7d6d501b3e3e23f7838fd093e6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::ActionMap &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>a58108146b22f328cb2153f3bcbd0c07b</anchor>
      <arglist>(GActionMap *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::AppInfo</name>
    <filename>classGio_1_1AppInfo.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~AppInfo</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>acf86d510216c430be4735d1f7b13113e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GAppInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>ab31e9bca0208159f0be42227397b8a94</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GAppInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a5e52c62432a61c5380bd5dc553898251</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; AppInfo &gt;</type>
      <name>create_duplicate</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a62a10631b3b06b42fc5cf7620938af41</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>equal</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a1803e87dccb051f4fe69cb10277c6c2e</anchor>
      <arglist>(const Glib::RefPtr&lt; AppInfo &gt; &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_id</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a3d929d82e4d7ae91f4d8904f91e7a1c4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_name</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a450c7e5a59919a66f73133749c318987</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_display_name</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>aa600e49454d101fb69e5de5d9a1dd9c3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_description</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>af7d89372dcf32cc6c25a9545a4ccffa0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_executable</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a06a665d4d812adb2eeb5c05d4c91c266</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_commandline</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>ad389c830c25f58b5ec99d247a3517939</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a35a0c2c10ee787cc5d1d4ac7773bab0d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Glib::RefPtr&lt; const Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a16fe789da6c7f5c8c023255b2faff226</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>launch</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a17b0e327594d813e1e89ff477e2afb7b</anchor>
      <arglist>(const Glib::RefPtr&lt; Gio::File &gt; &amp;file, const Glib::RefPtr&lt; AppLaunchContext &gt; &amp;launch_context)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>launch</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a1e86424b7f3b683618431f26b734dae6</anchor>
      <arglist>(const Glib::RefPtr&lt; Gio::File &gt; &amp;file)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>launch</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a546f6d9bbb65765e8f6b7fffb767048d</anchor>
      <arglist>(const std::vector&lt; Glib::RefPtr&lt; Gio::File &gt; &gt; &amp;files, const Glib::RefPtr&lt; AppLaunchContext &gt; &amp;launch_context)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>launch</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a564a73066abb31e967b47996bfcb7ae1</anchor>
      <arglist>(const std::vector&lt; Glib::RefPtr&lt; Gio::File &gt; &gt; &amp;files)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>supports_uris</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a8bb534c3834b17ff80edb046ba78250e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>supports_files</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a6ba8d06c3f3d99f907ae1aadbd8b24da</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>launch_uris</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a23a6ee89635a2b24468c73f137ad8de4</anchor>
      <arglist>(const Glib::ListHandle&lt; std::string &gt; &amp;uris, GAppLaunchContext *launch_context)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>launch_uris</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a9ca37403c57e21962961e57d532f0528</anchor>
      <arglist>(const Glib::ListHandle&lt; std::string &gt; &amp;uris, const Glib::RefPtr&lt; AppLaunchContext &gt; &amp;launch_context)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>launch_uris</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>abd6088290069f9a94ced5e4c6ef4291e</anchor>
      <arglist>(const Glib::ListHandle&lt; std::string &gt; &amp;uris)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>launch_uri</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a0d9b5ad79a7f8d567d6eb04181da0e8e</anchor>
      <arglist>(const std::string &amp;uris, const Glib::RefPtr&lt; AppLaunchContext &gt; &amp;launch_context)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>launch_uri</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a7fe4ef78cda00dbdb7a1f9c6f7038e2b</anchor>
      <arglist>(const std::string &amp;uris)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>should_show</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a7b374a9120926615fc7454afab6452e4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_delete</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>ae9c4b3e178815a1fbbd60abe69d9e0f9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>do_delete</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a634d024dee3e412df7dc794a280a438e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_as_default_for_type</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a59cefa47ef35940d5c0b74a396728808</anchor>
      <arglist>(const std::string &amp;content_type)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_as_default_for_extension</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a33b6e19f73a30f1dde7913282aa20aeb</anchor>
      <arglist>(const std::string &amp;extension)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>add_supports_type</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a0dedbcba19457176114948c80efdfbe4</anchor>
      <arglist>(const std::string &amp;content_type)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_remove_supports_type</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a150146aaba23bfa208d5c7100d986ee9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>remove_supports_type</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>aa1e9856c39e12c5ad1770299e391b6c0</anchor>
      <arglist>(const std::string &amp;content_type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>get_supported_types</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>aa1e950d1367b398f55f40e3f5bed5d18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_as_last_used_for_type</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a0a4ac1c4cec460b52eb18ac3029dd851</anchor>
      <arglist>(const std::string &amp;content_type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a12bbf2ad90f8915f46c3a49b6354e8ec</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>acd648d51cd85afa83a57c71e0679cbcf</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; AppInfo &gt;</type>
      <name>create_from_commandline</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>ac77db461b3142c9459c8c1a211672bf9</anchor>
      <arglist>(const std::string &amp;commandline, const std::string &amp;application_name, AppInfoCreateFlags flags)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::ListHandle&lt; Glib::RefPtr&lt; AppInfo &gt; &gt;</type>
      <name>get_all</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a21c3fa9bf0f708f3cf52ec38eb837c2e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::ListHandle&lt; Glib::RefPtr&lt; AppInfo &gt; &gt;</type>
      <name>get_all_for_type</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a05bb9f05067d8469f2de981794a31302</anchor>
      <arglist>(const std::string &amp;content_type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; AppInfo &gt;</type>
      <name>get_default_for_type</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a42907d07abfa7e35e2f220436d3fcb72</anchor>
      <arglist>(const std::string &amp;content_type, bool must_support_uris=true)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; AppInfo &gt;</type>
      <name>get_default_for_uri_scheme</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>ac278c0e445faed4288c6a719e059e0da</anchor>
      <arglist>(const std::string &amp;uri_scheme)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>reset_type_associations</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a01913be6448947643c9de26bddd0659c</anchor>
      <arglist>(const std::string &amp;content_type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>launch_default_for_uri</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a53a8e7c214d9c6a11cb22bb5e6b447e6</anchor>
      <arglist>(const std::string &amp;uri, const Glib::RefPtr&lt; AppLaunchContext &gt; &amp;launch_context)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>launch_default_for_uri</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a164a90bd2c00e9c4acb1194c475dd5d5</anchor>
      <arglist>(const std::string &amp;uri)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>AppInfo</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>affdc34dc0642b5a17cb53aadd8e02806</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::AppInfo &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a074ab0526fd01e5ee2daf2c81c17f552</anchor>
      <arglist>(GAppInfo *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::AppLaunchContext</name>
    <filename>classGio_1_1AppLaunchContext.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~AppLaunchContext</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>a11fe8b5d8eb6de7c6d1a19d77d366c98</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GAppLaunchContext *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>a41ed3abab4ad83b765974dfa6cb66067</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GAppLaunchContext *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>aa05603f4fe010e75df7ca950183b9224</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GAppLaunchContext *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>ac14e1569a0a5a81f846c0e11e7109011</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setenv</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>ab96bed2c0a5ad1ab135a54585da697c4</anchor>
      <arglist>(const Glib::ustring &amp;variable, const Glib::ustring &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unsetenv</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>a36b7dbc0301cebdf9d3dcf5ec589db04</anchor>
      <arglist>(const Glib::ustring &amp;variable)</arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Glib::ustring &gt;</type>
      <name>get_environment</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>afe35a0f3b2a6b29c82ba9fbb9ec9a421</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_display</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>acb9df3c4d0856cf54725a0ec1baf29cb</anchor>
      <arglist>(const Glib::RefPtr&lt; AppInfo &gt; &amp;info, const Glib::ListHandle&lt; Glib::RefPtr&lt; Gio::File &gt; &gt; &amp;files)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_startup_notify_id</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>ac76a58054fccd2cfc6f3554e1d4b012a</anchor>
      <arglist>(const Glib::RefPtr&lt; AppInfo &gt; &amp;info, const Glib::ListHandle&lt; Glib::RefPtr&lt; Gio::File &gt; &gt; &amp;files)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>launch_failed</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>aeb5fe002776ad4f040b6be49fa25b46a</anchor>
      <arglist>(const std::string &amp;startup_notify_id)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>get_data</name>
      <anchorfile>classGlib_1_1Object.html</anchorfile>
      <anchor>a0e6581bcbcc6197cca07df24bb91c492</anchor>
      <arglist>(const QueryQuark &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_data</name>
      <anchorfile>classGlib_1_1Object.html</anchorfile>
      <anchor>afff7a375a862f3f899daaa99710122fa</anchor>
      <arglist>(const Quark &amp;key, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_data</name>
      <anchorfile>classGlib_1_1Object.html</anchorfile>
      <anchor>a1febe3bae2dd71756e98e523cd33c1b4</anchor>
      <arglist>(const Quark &amp;key, void *data, DestroyNotify notify)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_data</name>
      <anchorfile>classGlib_1_1Object.html</anchorfile>
      <anchor>aada5b50844bda7ee02bed0ae2a715c00</anchor>
      <arglist>(const QueryQuark &amp;quark)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>steal_data</name>
      <anchorfile>classGlib_1_1Object.html</anchorfile>
      <anchor>ab454f71bd74403b0cc46d3cbbedd6b0e</anchor>
      <arglist>(const QueryQuark &amp;quark)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>accc93a5b33f2f4b4609796c8f4db94c5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; AppLaunchContext &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>a9e0b952987932c15f4f8ac7ae6d2e046</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>AppLaunchContext</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>a04c6b83e39f16c6ae04ad10c387e2cec</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Object</name>
      <anchorfile>classGlib_1_1Object.html</anchorfile>
      <anchor>ad43f7c5ad0336e1eb3af622392a112eb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Object</name>
      <anchorfile>classGlib_1_1Object.html</anchorfile>
      <anchor>a6d72588496bd7ac03f72420021fb94a5</anchor>
      <arglist>(const Glib::ConstructParams &amp;construct_params)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Object</name>
      <anchorfile>classGlib_1_1Object.html</anchorfile>
      <anchor>a6f490eeaeb71db673c36799a0f729be5</anchor>
      <arglist>(GObject *castitem)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~Object</name>
      <anchorfile>classGlib_1_1Object.html</anchorfile>
      <anchor>a5ae4319439a3a03d8f803fb5a27f12df</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::AppLaunchContext &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>a3cda3d0a285e3ad87f1c94142b04a688</anchor>
      <arglist>(GAppLaunchContext *object, bool take_copy=false)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Glib::Object &gt;</type>
      <name>wrap</name>
      <anchorfile>classGlib_1_1Object.html</anchorfile>
      <anchor>ae4dea9a8dc611d6e4400a5b6a3cb4e7f</anchor>
      <arglist>(GObject *object, bool take_copy=false)</arglist>
    </member>
    <member kind="typedef">
      <type>void(*</type>
      <name>DestroyNotify</name>
      <anchorfile>classGlib_1_1Object.html</anchorfile>
      <anchor>a1d8d9f3c19b59eda96c40beca8d520e0</anchor>
      <arglist>)(gpointer data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Application</name>
    <filename>classGio_1_1Application.html</filename>
    <base>Glib::Object</base>
    <base>Gio::ActionGroup</base>
    <base>Gio::ActionMap</base>
    <member kind="enumeration">
      <type></type>
      <name>OptionType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gabd6606988f30170f2e53b2b121f2b219</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>OPTION_TYPE_BOOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggabd6606988f30170f2e53b2b121f2b219a31b0b3d2951ef1533e8a2775db79250e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>OPTION_TYPE_STRING</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggabd6606988f30170f2e53b2b121f2b219a018d6130d8f46e1dbdf7db263c54d05e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>OPTION_TYPE_INT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggabd6606988f30170f2e53b2b121f2b219ab5f2e456b9c5bd209c872b11a878d29b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>OPTION_TYPE_FILENAME</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggabd6606988f30170f2e53b2b121f2b219aa24cb753e2b6aa5411bbc242217935ff</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>OPTION_TYPE_STRING_VECTOR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggabd6606988f30170f2e53b2b121f2b219adc4a9ed1661944d8301d372708915d78</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>OPTION_TYPE_FILENAME_VECTOR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggabd6606988f30170f2e53b2b121f2b219a9f3ccf0b9217a0d5380bc97d11117c58</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>OPTION_TYPE_DOUBLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggabd6606988f30170f2e53b2b121f2b219a320a43020a59acf7a724177a30d0265e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>OPTION_TYPE_INT64</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggabd6606988f30170f2e53b2b121f2b219ae4ceecbbf5f1e343ca896fcd442d707f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::vector&lt; Glib::RefPtr&lt; File &gt; &gt;</type>
      <name>type_vec_files</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a49e9c2644440be5859747d350bb0643c</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Application</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a01c45143f595a603c38f0e6706b0145a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GApplication *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a5bf7165c776bb2979a15da499b67b906</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GApplication *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>ad024d1c363f8e850b52cfea2726a1b52</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GApplication *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a554fe8f0fbd560c6ab28fc7c49ac3ce5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_id</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a0850af24ee016a9dd6087a3d4fc78d4b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_id</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a4a33387fd6130b5305ca410c95d2ef96</anchor>
      <arglist>(const Glib::ustring &amp;application_id)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; DBus::Connection &gt;</type>
      <name>get_dbus_connection</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a1b7f24a60afc884e40ab49461790a0a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const DBus::Connection &gt;</type>
      <name>get_dbus_connection</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a365ad29c4c9643a79afb05e1734bc0ab</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_dbus_object_path</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>aee8695d2cc323db74899e4cbb7a73f4f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_inactivity_timeout</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>aab3c1d90e69da18356130b989060e9f7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_inactivity_timeout</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a19eebde1f77194f294e7f00f773ba1b7</anchor>
      <arglist>(guint inactivity_timeout)</arglist>
    </member>
    <member kind="function">
      <type>ApplicationFlags</type>
      <name>get_flags</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a4d2f0f2c7b58a8183bb18a4dbaffbede</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_flags</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>aefe6afbad1f139beafeada33a9e72db4</anchor>
      <arglist>(ApplicationFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_action_group</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a9bf1e6006b6eac3e7ccefc1e6bfc92c4</anchor>
      <arglist>(const Glib::RefPtr&lt; ActionGroup &gt; &amp;action_group)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_main_option_entry</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a12ec728146b041ba28aaa23d97e01095</anchor>
      <arglist>(OptionType arg_type, const Glib::ustring &amp;long_name, gchar short_name= &apos;\0&apos;, const Glib::ustring &amp;description=Glib::ustring(), const Glib::ustring &amp;arg_description=Glib::ustring(), int flags=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_main_option_entry</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a677bbc233c1fea0c00a1d6a90259e903</anchor>
      <arglist>(const Glib::OptionGroup::SlotOptionArgString &amp;slot, const Glib::ustring &amp;long_name, gchar short_name= &apos;\0&apos;, const Glib::ustring &amp;description=Glib::ustring(), const Glib::ustring &amp;arg_description=Glib::ustring(), int flags=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_main_option_entry_filename</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a498ba4e4f34402e76b75ee4765845729</anchor>
      <arglist>(const Glib::OptionGroup::SlotOptionArgFilename &amp;slot, const Glib::ustring &amp;long_name, gchar short_name= &apos;\0&apos;, const Glib::ustring &amp;description=Glib::ustring(), const Glib::ustring &amp;arg_description=Glib::ustring(), int flags=0)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_registered</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a986b5738f908ae89486fef16d37e0581</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_remote</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a6510145fd5dce7b73b137174ffab918d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>register_application</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>adc6e597f2d27521f3658c6b8b48d9ae0</anchor>
      <arglist>(const Glib::RefPtr&lt; Gio::Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>register_application</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a8964856be3086656cc1f933381754d3a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>hold</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>ae20746f00a9ae5a98b21f469c079bc65</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>release</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a8d279ffaf0b8ea548ac5ae1db0ebe0a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>activate</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a933c7e0d462692cf7389ab3b08b6e883</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>open</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a41a766989330ceba997254c31d322e5f</anchor>
      <arglist>(const type_vec_files &amp;files, const Glib::ustring &amp;hint=Glib::ustring())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>open</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a5f72e3bf2d0826d69067e6138a97d47b</anchor>
      <arglist>(const Glib::RefPtr&lt; Gio::File &gt; &amp;file, const Glib::ustring &amp;hint=Glib::ustring())</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>run</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>add3bdf8c89411777cb44d6ce5aa26f9b</anchor>
      <arglist>(int argc, char **argv)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>quit</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a0420530131f4303251091dac443b1961</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mark_busy</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>afb0429cbaaaf8bc48f461a90507fc157</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmark_busy</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>acb096763f2db84419d2d3e32f0393d04</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>send_notification</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a76d3d76f750a48fdbb965079b6619209</anchor>
      <arglist>(const Glib::ustring &amp;id, const Glib::RefPtr&lt; Notification &gt; &amp;notification)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>send_notification</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a7f9412ab2649d6c9ec77fed22b7ede71</anchor>
      <arglist>(const Glib::RefPtr&lt; Notification &gt; &amp;notification)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>withdraw_notification</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a0ac34e395e0a335bdf60022be1804e34</anchor>
      <arglist>(const Glib::ustring &amp;id)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_WriteOnly&lt; Glib::RefPtr&lt; ActionGroup &gt; &gt;</type>
      <name>property_action_group</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>abc3c0d24a55249fca479302d97a21217</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Glib::ustring &gt;</type>
      <name>property_application_id</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>ae7aa0fb864de6c4c61f62c9bad6b2c8a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_application_id</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>aa6aed2688366db4c40a92cf024ffdc89</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; ApplicationFlags &gt;</type>
      <name>property_flags</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>ab478a16ab3e8a5d2819c5abe2590b88b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; ApplicationFlags &gt;</type>
      <name>property_flags</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a44db85a2c702c2e36e72d93e710936a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; guint &gt;</type>
      <name>property_inactivity_timeout</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a037c44160c6fb4f305ad3ce0c098c9b3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; guint &gt;</type>
      <name>property_inactivity_timeout</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a5175cca6b3e13306f9746589d962919d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_is_registered</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a99a8d9641b9b767782523c52dd602a42</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_is_remote</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a3cb12b781da84b280b39929419c032eb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_startup</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a6b1a3f8cacdedb1b1e33d4f2801a3a2b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_activate</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a94eaa9b797229fa29ef4efb1d24a0205</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy2&lt; void, const type_vec_files &amp;, const Glib::ustring &amp; &gt;</type>
      <name>signal_open</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>ae4d42ebea7a6738f2513e964ff2fb247</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; int, const Glib::RefPtr&lt; ApplicationCommandLine &gt; &amp; &gt;</type>
      <name>signal_command_line</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a9a89ad8ffc84ebfe802f0fdcd11bd296</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; int, const Glib::RefPtr&lt; Glib::VariantDict &gt; &amp; &gt;</type>
      <name>signal_handle_local_options</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>ae9fd6b6ad47e6f6eda63283e7bb3c536</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a63cc5cae8c93f4cb344cbeab0cdfcef3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Application &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a49723f8caca339ff409c077d49425327</anchor>
      <arglist>(const Glib::ustring &amp;application_id=Glib::ustring(), ApplicationFlags flags=APPLICATION_FLAGS_NONE)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>id_is_valid</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>ad9d589ea6286e7518017494117f465a2</anchor>
      <arglist>(const Glib::ustring &amp;application_id)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>set_default</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a13e52a81fba2eca92dc7e2e582dc409d</anchor>
      <arglist>(const Glib::RefPtr&lt; Application &gt; &amp;application)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>unset_default</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>aaff99f1512e9dde8fd3c182d71c82cc8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Application &gt;</type>
      <name>get_default</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a00e9413f162dffe7b7c6dbc09fa83bfa</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Application</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>ab36332457ba478951f7743ed48324c6b</anchor>
      <arglist>(const Glib::ustring &amp;application_id=Glib::ustring(), ApplicationFlags flags=APPLICATION_FLAGS_NONE)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_open</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a11939a724e0ab8ddfa3989a950dce5ed</anchor>
      <arglist>(const type_vec_files &amp;files, const Glib::ustring &amp;hint)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>local_command_line_vfunc</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a83d78cc068e04862a3d0fdab1afa48f8</anchor>
      <arglist>(char **&amp;arguments, int &amp;exit_status)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>before_emit_vfunc</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a32ff64453c75b262ec3c39f584d860d3</anchor>
      <arglist>(const Glib::VariantBase &amp;platform_data)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>after_emit_vfunc</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a24a45fbd57b7863e073d0bf120adb52e</anchor>
      <arglist>(const Glib::VariantBase &amp;platform_data)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>quit_mainloop_vfunc</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a2071fdc29b98017584d0a5ad6ca25236</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>run_mainloop_vfunc</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>acec64d0bcee724c3cb83bf124159e5d1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_startup</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a1f101517a3cfad44c71f5b147893cccb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_activate</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>af764ec32aee390fc888a4236ef7f4b8e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual int</type>
      <name>on_command_line</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a3a061412c26150b96c69a0595325b707</anchor>
      <arglist>(const Glib::RefPtr&lt; ApplicationCommandLine &gt; &amp;command_line)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Application &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a49c378c598e06036b2ed954dd6405706</anchor>
      <arglist>(GApplication *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::ApplicationCommandLine</name>
    <filename>classGio_1_1ApplicationCommandLine.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~ApplicationCommandLine</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>a65a2b021f9fb69492687aa7637b64c82</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GApplicationCommandLine *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>a4164115e133faeba88f120179790e870</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GApplicationCommandLine *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>a8eb7bb228c0b6b1afe845e20cedc5a09</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GApplicationCommandLine *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>a2110250bf429a7d01670420fd06e3c96</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>char **</type>
      <name>get_arguments</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>adcba9055d6fa3c5aba9b3bd21eed3d06</anchor>
      <arglist>(int &amp;argc) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Glib::VariantDict &gt;</type>
      <name>get_options_dict</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>ac361e879901096590f95a30d5b8ba3cb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Glib::VariantDict &gt;</type>
      <name>get_options_dict</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>aae3258ba1299277e83fccf2e2dce6794</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; InputStream &gt;</type>
      <name>get_stdin</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>a252d466396f0be57c51ef0a493e5bb01</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const InputStream &gt;</type>
      <name>get_stdin</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>a1ee6ca2b4734a89433ae1816c595e95f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_cwd</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>a650d6bf04520000fbafbed570f7b6c13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; std::string &gt;</type>
      <name>get_environ</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>a3769c3fbf95d98bc420d43f425790c8a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>getenv</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>a84ac92d5ee56674368dfba142e23416f</anchor>
      <arglist>(const Glib::ustring &amp;name) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_remote</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>aa42eeaa482f72abd31d8ad820d20c809</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::Variant&lt; std::map&lt; Glib::ustring, Glib::VariantBase &gt; &gt;</type>
      <name>get_platform_data</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>aff7413d781c99b550ecf04cda13832ff</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_exit_status</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>a1f4ae1a2fc62b6a3cbe48f1751f7c886</anchor>
      <arglist>(int exit_status)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_exit_status</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>a529a64dc4dbdcf341e05fcbd0ead42c6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>a7b09db106ab8473149c9585bef47024b</anchor>
      <arglist>(const Glib::ustring &amp;message)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>printerr</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>aebab1a57ff18a18a651c95ae0b1d0146</anchor>
      <arglist>(const Glib::ustring &amp;message)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>create_file_for_arg</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>a6873086ae3c5fda6cc15010ec9659246</anchor>
      <arglist>(const Glib::ustring &amp;arg) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>a9180788048a1d94d59593c4feaa46d95</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>ApplicationCommandLine</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>a33112e7fdeb3f82a7c08f50d35710d64</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::ApplicationCommandLine &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>a4888027a1e5b3562c802965418b8b740</anchor>
      <arglist>(GApplicationCommandLine *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::AsyncInitable</name>
    <filename>classGio_1_1AsyncInitable.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~AsyncInitable</name>
      <anchorfile>classGio_1_1AsyncInitable.html</anchorfile>
      <anchor>a48e4bd3e0a9033d24afa3a4e30d8508d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GAsyncInitable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1AsyncInitable.html</anchorfile>
      <anchor>a17b715d899d7ff40a10e98cbc04fb950</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GAsyncInitable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1AsyncInitable.html</anchorfile>
      <anchor>a470b482fc15de1b5ca307a9ba9c18649</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1AsyncInitable.html</anchorfile>
      <anchor>ac9d58b099c38f8957f8780b459cd68dd</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1AsyncInitable.html</anchorfile>
      <anchor>ad13b8625eb70ea9c8af3fd5c3b9d2460</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>AsyncInitable</name>
      <anchorfile>classGio_1_1AsyncInitable.html</anchorfile>
      <anchor>aec93b083db2e2e8609ef916bf5f11e32</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>init_async</name>
      <anchorfile>classGio_1_1AsyncInitable.html</anchorfile>
      <anchor>ae1439e78cf813af329c36239c838b0ab</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>init_async</name>
      <anchorfile>classGio_1_1AsyncInitable.html</anchorfile>
      <anchor>a05377786e1a1edd01541fd5768db65fa</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>bool</type>
      <name>init_finish</name>
      <anchorfile>classGio_1_1AsyncInitable.html</anchorfile>
      <anchor>a07df2b8ecba0a06d7ff26d08ba86e9df</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;res)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>Glib::RefPtr&lt; Glib::Object &gt;</type>
      <name>create_finish</name>
      <anchorfile>classGio_1_1AsyncInitable.html</anchorfile>
      <anchor>a9545cbf4fe23c6217d32efd2f75b489d</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;res)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>init_async_vfunc</name>
      <anchorfile>classGio_1_1AsyncInitable.html</anchorfile>
      <anchor>affca6d14e16c2841101528edf768f9cc</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>init_finish_vfunc</name>
      <anchorfile>classGio_1_1AsyncInitable.html</anchorfile>
      <anchor>a14689b76b1fe02c25bf88ce0eec9f1d7</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;res)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::AsyncInitable &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1AsyncInitable.html</anchorfile>
      <anchor>a631d18f9a5459cbb3848b2098738e6d6</anchor>
      <arglist>(GAsyncInitable *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::AsyncResult</name>
    <filename>classGio_1_1AsyncResult.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~AsyncResult</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>a9dae859748e44341d2c14a2777ca4fee</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GAsyncResult *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>ad7ebc2ac808bd8eff4f4cd4f94c1c70a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GAsyncResult *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>a134862761e05a548d2817505480140be</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Glib::Object &gt;</type>
      <name>get_source_object</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>a3b89bee3ed3ff402ff58f836e1d2398e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Glib::Object &gt;</type>
      <name>get_source_object</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>adcb9d80c42cf04098629a8153d51b32c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Glib::ObjectBase &gt;</type>
      <name>get_source_object_base</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>a65a9e867d84321b270e2b7be7b36e631</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Glib::ObjectBase &gt;</type>
      <name>get_source_object_base</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>abd7320c43aed6281325c6ddfdb7db10e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_tagged</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>a2b55e8910f32ea8a44fdd0dac94cb3f4</anchor>
      <arglist>(gpointer source_tag) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::RefPtr&lt; Glib::ObjectBase &gt;</type>
      <name>get_source_object_vfunc</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>a305c556281152983343a2353e28ca05b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>a27a2e7a0488f8a3db08fa9547c791c6a</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>a2f0dc50fadce2a220280f885e3af1d88</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>AsyncResult</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>ad50735bd35c6bcd1d037ea4fb39eeac6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::AsyncResult &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>a08e7667c305f6c361345c9a8e261d73a</anchor>
      <arglist>(GAsyncResult *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::BufferedInputStream</name>
    <filename>classGio_1_1BufferedInputStream.html</filename>
    <base>Gio::FilterInputStream</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~BufferedInputStream</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a6d961bb2ebe9c213c1e4c49572bae6ed</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GBufferedInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>aa9d0c1e643650b9a45831865f06e21be</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GBufferedInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>ad6b09565f69b4c1cf1f0ca05ee53709e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GBufferedInputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a47dc5f78b1faed25cdaaafe42b526d6d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gsize</type>
      <name>get_buffer_size</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a46384a96dc052e9d25e1a88281d69e40</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_buffer_size</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>af5f861a5b30aadc48e21fb10a46afaa7</anchor>
      <arglist>(gsize size)</arglist>
    </member>
    <member kind="function">
      <type>gsize</type>
      <name>get_available</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a436e3c852afdc67e8ba70d32e39ce6b9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>gsize</type>
      <name>peek</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a17a6489d7ab0b72268264c9f0a30e879</anchor>
      <arglist>(void *buffer, gsize offset, gsize count) const </arglist>
    </member>
    <member kind="function">
      <type>const void *</type>
      <name>peek_buffer</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a27838d9374fa86ae513bc27d939ede24</anchor>
      <arglist>(gsize &amp;count) const </arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>fill</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a197687762599fb7c5b60141b55120cde</anchor>
      <arglist>(gssize count, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>fill</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a271eab4876136b4960d37350738bfdfe</anchor>
      <arglist>(gssize count)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fill_async</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a0a41790e04e9ba500eb18d1ce8371d34</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, gssize count, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fill_async</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>aadb9c1b367e36c20c91e16ea840b6ef0</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, gssize count, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>fill_finish</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a13c665ccc722a2544539086846137277</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>read_byte</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a85477f09b58dfb83e5a1ef62f119457a</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>read_byte</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a8741ffb62c82425f54bc5e005c2a238f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; guint &gt;</type>
      <name>property_buffer_size</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a10be713afc0912c4a5fe89a2c40d943e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; guint &gt;</type>
      <name>property_buffer_size</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a8d77671c76ea9170c32c294d28403378</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FilterInputStream</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>a5d3ea75436d7681061f6c320225d7848</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFilterInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>a6db43589745dcd172f4ca4082bc5d914</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFilterInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>ac8fbd2cc879bfab4854d952b27ce271c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFilterInputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>a55ef3320e423245cc69066c90785328e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; InputStream &gt;</type>
      <name>get_base_stream</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>aa0e6304d8ea21a17b3e6a0127e3e7530</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const InputStream &gt;</type>
      <name>get_base_stream</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>a41af6a4af682c043ac9c91ed13608705</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_close_base_stream</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>a1a78226f76528f61c87ebe5a31b0f133</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_close_base_stream</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>a82e03517a6841b170c7e13fcf2f66920</anchor>
      <arglist>(bool close_base=true)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; InputStream &gt; &gt;</type>
      <name>property_base_stream</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>aee46182be8452b2b308e62b1fe932233</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_close_base_stream</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>a6667a12cd90f09d79252e0f76c5f9c16</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_close_base_stream</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>a88a93a90feb440a6b3a38794e7e10609</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~InputStream</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>afff624e3125add13c88e8a99907ba903</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a2ed1120b3d03a12086e7f0ed3946aba1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a1b0ef82ab81b3ded607584c7029fe1e9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GInputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a28a9394b07e9183c0c79798ea344c65c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>read</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a49a1f4219f96c7fafdcf1ed12eb443e2</anchor>
      <arglist>(void *buffer, gsize count, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>read</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a42ab2486116d40f6ef828277befb508a</anchor>
      <arglist>(void *buffer, gsize count)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_all</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a1dc8a2babf32f93a0a5dccc0c39e0959</anchor>
      <arglist>(void *buffer, gsize count, gsize &amp;bytes_read, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_all</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a6da0fc57d1a5df7107370c67e84aa496</anchor>
      <arglist>(void *buffer, gsize count, gsize &amp;bytes_read)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Glib::Bytes &gt;</type>
      <name>read_bytes</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>af59e44aed65ee329e01d6ca6179e97b9</anchor>
      <arglist>(gsize count, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_bytes_async</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a9653d83a56cef6201286ff5f4b709050</anchor>
      <arglist>(gsize count, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_bytes_async</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>af70a7c9073f6a494c8fac975530130c9</anchor>
      <arglist>(gsize count, const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Glib::Bytes &gt;</type>
      <name>read_bytes_finish</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a0b38e525397cddd9ae4b2ebb395ba3b3</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>skip</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a17ea65f35c15043156db90af831a44a3</anchor>
      <arglist>(gsize count, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>skip</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a1ea9146d612c666168886734b79a5d65</anchor>
      <arglist>(gsize count)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a1b76b2503e607475f63731a886456e09</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a7a3202cf7014bcfb2c0a7f301448ae50</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_async</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a5b7762ee3f3c571fbc59a0c9af6e879e</anchor>
      <arglist>(void *buffer, gsize count, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_async</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a05bea76fa9ac3c098a167d2b377e36a6</anchor>
      <arglist>(void *buffer, gsize count, const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>read_finish</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>ac089ab220e671ba0af2dd97f2405c0c5</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>skip_async</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a1bf7a4a30005813b0a46e069215907a2</anchor>
      <arglist>(gsize count, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>skip_async</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a111e86dad4548394edcff16d7735d2d5</anchor>
      <arglist>(gsize count, const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>skip_finish</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a1522468bd203ab3082ab54e9eba68b03</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_async</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>af66159778ee2d577e9df52063ced53bf</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_async</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>ab5160982124f34ed6e475776acd126d2</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>gboolean</type>
      <name>close_finish</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>ae5a0d2c3ccf27661e374f151117a8fb7</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>aa08a6604e27f04c95fa7ed60838fff02</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; BufferedInputStream &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>afc33c31f5c437df14d385d3aa9d1a37b</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;base_stream)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; BufferedInputStream &gt;</type>
      <name>create_sized</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a0ecd42e418c250abc04bfa03f09b252c</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;base_stream, gsize buffer_size)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>ad5357b46433b56fa6ad18ccd5063e71c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a0c4d454f8b892bcfc951740ddaa6f4da</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>BufferedInputStream</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a0a81d8bea742203e775f796f73f46ea4</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;base_stream)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>BufferedInputStream</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>afdadf0f95e646cdeede70af551f7fa85</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;base_stream, gsize buffer_size)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::BufferedInputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>adfe9bf4339f83095d6e96dda7b747575</anchor>
      <arglist>(GBufferedInputStream *object, bool take_copy=false)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FilterInputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>a5f5a6b8c088b86f8671d9dfaed24ac70</anchor>
      <arglist>(GFilterInputStream *object, bool take_copy=false)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::InputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>aec580b0fc1e0807d7ccba6cbb7e302db</anchor>
      <arglist>(GInputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::BufferedOutputStream</name>
    <filename>classGio_1_1BufferedOutputStream.html</filename>
    <base>Gio::FilterOutputStream</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~BufferedOutputStream</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>ab2cf992f28ebf871b0025e5060356f40</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GBufferedOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a6dfd09a0501267ef81030e3cf8e9ae47</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GBufferedOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a4a906daf7be02fd1c1548253f5f0e95c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GBufferedOutputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a890c12d13d9f87332b00b785e32e4424</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gsize</type>
      <name>get_buffer_size</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a18ba1d42def3606fe3da3912046b1c11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_buffer_size</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a8044f48728b7020ba86e7364421b21fb</anchor>
      <arglist>(gsize size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_auto_grow</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a5c308a93b5538db6c614b67e015474c5</anchor>
      <arglist>(bool auto_grow=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_auto_grow</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a53501edadccf17be8908fae896d34dcc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; guint &gt;</type>
      <name>property_buffer_size</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a4198c7a760017e659eb2b509c3dc5974</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; guint &gt;</type>
      <name>property_buffer_size</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>addaaa89d2c3b76c7fdd815854f0b8527</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_auto_grow</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a0cf7d27482a3c64bf2078d9ed8dfef58</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_auto_grow</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>af9b8ebe41658a0cd58033d6f509a71f0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FilterOutputStream</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>a65d7d0e8645a11065c74706d65e18fcd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFilterOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>a7cf09c946f16c1597e7ce038fd64f9ef</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFilterOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>a4497fb9f0cb87f953bbc8fa5bb218a0c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFilterOutputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>ae0701328a1b8b2e71ba15dcdb83422b6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; OutputStream &gt;</type>
      <name>get_base_stream</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>a135f41e0b5e9ad029d17efdce11e3fd8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const OutputStream &gt;</type>
      <name>get_base_stream</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>a983b98a5bca8404c6ac515ff8048b61e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_close_base_stream</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>a5b9f78803d5860833114852fdbbf2d7b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_close_base_stream</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>ad02373553035aa1b1c3bb2bd578a24f6</anchor>
      <arglist>(bool close_base=true)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; InputStream &gt; &gt;</type>
      <name>property_base_stream</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>a080f2c7b32bcd1c05c04a437c5586afa</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_close_base_stream</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>ae6708607574bc12ce4357a1e8df6cb15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~OutputStream</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ae03f14924981183936d800fcde857fea</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ac5a71a1f432f8ac2a53de2c66eb81d9d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ac29e6ad7ccffde24201a1da608f25ac9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GOutputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ad9128985ea683716db40d7831cb7075c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>write</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a0a714bc357db90c5e34f1d001446fe29</anchor>
      <arglist>(const void *buffer, gsize count, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>write</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a5037c7a24ba87c7e8f1992f7586f032c</anchor>
      <arglist>(const void *buffer, gsize count)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>write</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>aee589585890960b4c26c86865fe3f0b4</anchor>
      <arglist>(const std::string &amp;buffer, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>write</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>afa3cf9f1b7006b1f79d8e452616f3324</anchor>
      <arglist>(const std::string &amp;buffer)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>write_all</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ac9ff8d59409bfdfdfd95643f3ee4c98d</anchor>
      <arglist>(const void *buffer, gsize count, gsize &amp;bytes_written, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>write_all</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>aca15317cfd772d712b44147d378788b8</anchor>
      <arglist>(const void *buffer, gsize count, gsize &amp;bytes_written)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>write_all</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ac10263d00bf17a158d4aad207fbb2d64</anchor>
      <arglist>(const std::string &amp;buffer, gsize &amp;bytes_written, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>write_all</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a9171833c0c7c88103afd3fc12efbcf17</anchor>
      <arglist>(const std::string &amp;buffer, gsize &amp;bytes_written)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>write_bytes</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>aaf334df7e398b30fe3b2ac081f31ae61</anchor>
      <arglist>(const Glib::RefPtr&lt; const Glib::Bytes &gt; &amp;bytes, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>write_bytes</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a4c44e35b548088bbaa949fe3fb93e3e5</anchor>
      <arglist>(const Glib::RefPtr&lt; const Glib::Bytes &gt; &amp;bytes)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>write_bytes_async</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a7dffae36ab85aef1d2c69a1c60a7f1e1</anchor>
      <arglist>(const Glib::RefPtr&lt; const Glib::Bytes &gt; &amp;bytes, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>write_bytes_async</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a6d0a0fb359543cfbca7495b39d6dcd29</anchor>
      <arglist>(const Glib::RefPtr&lt; const Glib::Bytes &gt; &amp;bytes, const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>write_bytes_finish</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a052f5bd01513a4c1c94e52d1174545ce</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>splice</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a080bff3f1f2017b4d4ff8343a5bfbf15</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;source, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, OutputStreamSpliceFlags flags=OUTPUT_STREAM_SPLICE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>splice</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>aaca5a5891175c7c66cb77e476bae1843</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;source, OutputStreamSpliceFlags flags=OUTPUT_STREAM_SPLICE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>flush</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a413a349600ecd6013d15f563d6c6fd85</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>flush</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a6bb81a11ef79dc8ffa9f5a275d2d6e0c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a4fefad6d6b244924b4fe51c105d3805c</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ac3e92678425dd530b22eaab97852ca23</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>write_async</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a947eefdb85b9081348a1c0cc04be2eaa</anchor>
      <arglist>(const void *buffer, gsize count, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>write_async</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>aae0f58d27908beb35f24a88b6254107a</anchor>
      <arglist>(const void *buffer, gsize count, const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>write_finish</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ac61dbaa1f910c14bf3beaadc0498065f</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>splice_async</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a4bfe08685268b2236362bce84ba1cc77</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;source, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, OutputStreamSpliceFlags flags=OUTPUT_STREAM_SPLICE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>splice_async</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a85e95838d577180e11831b0f149e8f5c</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;source, const SlotAsyncReady &amp;slot, OutputStreamSpliceFlags flags=OUTPUT_STREAM_SPLICE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>splice_finish</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a29461238b7b3cf9c2d6dde85b4a6a6ea</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>flush_async</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ac76478281be9559cb0a924bcc4ead263</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>flush_async</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>aa82f241b6c72fef632eaf51b279b25ce</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>flush_finish</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>af2e8a3c48152c2fdc744a50016911a3a</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_async</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a47fb0dbd7f88c9167dacd577dcd8c6c7</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_async</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a92f6a9cc67bfa6a2356a031fb3f691c0</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close_finish</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a8db5ee9e7a3a0c091eeebe960550e6f5</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>af984ae9ac1c9ab19d9c72b23467018b3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; BufferedOutputStream &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>ad5cfe5126450ce9236a8c1f768aed4c5</anchor>
      <arglist>(const Glib::RefPtr&lt; OutputStream &gt; &amp;base_stream)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; BufferedOutputStream &gt;</type>
      <name>create_sized</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>ae687f0c086ed2b598bfe1b5c5e1d28b0</anchor>
      <arglist>(const Glib::RefPtr&lt; OutputStream &gt; &amp;base_stream, gsize buffer_size)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>aec1234b0481c14d92b2be99644ef124e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a8212097d2d77d08108024b39604b0326</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>BufferedOutputStream</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>abd7e5b3a7dc3a71b5cae2214cce5e5d6</anchor>
      <arglist>(const Glib::RefPtr&lt; OutputStream &gt; &amp;base_stream)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>BufferedOutputStream</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a4dfd4e8ed1425f8804c5df73f97ce8da</anchor>
      <arglist>(const Glib::RefPtr&lt; OutputStream &gt; &amp;base_stream, gsize buffer_size)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::BufferedOutputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>ab4fbaeef8ea590b6c674973d25678902</anchor>
      <arglist>(GBufferedOutputStream *object, bool take_copy=false)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FilterOutputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>ae070f4f975af2ac6beb39a5bef8d5f95</anchor>
      <arglist>(GFilterOutputStream *object, bool take_copy=false)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::OutputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a96aad4c49fb938a88b75abe5339bef4f</anchor>
      <arglist>(GOutputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Cancellable</name>
    <filename>classGio_1_1Cancellable.html</filename>
    <base>Glib::Object</base>
    <member kind="typedef">
      <type>sigc::slot&lt; void &gt;</type>
      <name>SlotCancelledCallback</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a18d005aeefd0da4daab594f4c44ce9cd</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Cancellable</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a97c7c4d728865129bc6f0cd3f4ecfce7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GCancellable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>ae19ec1e85fd9cd7893914d4d7c20120d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GCancellable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a668176a01f7ad3cc13c7448378f37b41</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GCancellable *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a379e6394bad0fff1eb11e1a160f30235</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_cancelled</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a47ce5f2f16541b7ae18bc5114b366d8c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_fd</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a80df23049daf594fda884f2932ce3b95</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>make_pollfd</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a6627893047c8a375324b58e955661395</anchor>
      <arglist>(GPollFD *pollfd)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>release_fd</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>ad8f406bb61e80d382153ebf600822ce2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cancel</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a86adae0645cec20d09d1a2903fe46cc0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push_current</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>ad893da5aebfb4baf34ecdbdad7a3608b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pop_current</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a93b5a39447d2b4eb9fb56748cb687fc8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a2285370aea5d98141e742e73743b9c3e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gulong</type>
      <name>connect</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a99eafc7ee028fba0da0ec18f92306490</anchor>
      <arglist>(const SlotCancelledCallback &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>disconnect</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>aa9277479b4bf0b80090e780e26215713</anchor>
      <arglist>(gulong handler_id)</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_cancelled</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a5a34d4782ccec014684c4eb6c20cf0a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a48b647ae1c890d85ceaeaf556e4a3113</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Cancellable &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a8d59324b4c253f8c890901cd934203a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Cancellable &gt;</type>
      <name>get_current</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>aaf923ce91ddf21fc03bf2902e12cd4e1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Cancellable</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>aab7733b6e915e4ebe280fbb669b6af2a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_cancelled</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>aff017e200824997b9c26d82f147e078f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Cancellable &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>ac45875da91c9c870a0f154a8249047c0</anchor>
      <arglist>(GCancellable *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::CharsetConverter</name>
    <filename>classGio_1_1CharsetConverter.html</filename>
    <base>Glib::Object</base>
    <base>Gio::Converter</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~CharsetConverter</name>
      <anchorfile>classGio_1_1CharsetConverter.html</anchorfile>
      <anchor>a7b9b74ccc17862ed82e7c36ec40e6472</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GCharsetConverter *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1CharsetConverter.html</anchorfile>
      <anchor>a68e4408875be26bdf2182bb57ae4fba7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GCharsetConverter *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1CharsetConverter.html</anchorfile>
      <anchor>ae0646824f1105aa6709092a6c8454dfa</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GCharsetConverter *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1CharsetConverter.html</anchorfile>
      <anchor>acf7a3a6edc47050a63c7722220ada7a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_use_fallback</name>
      <anchorfile>classGio_1_1CharsetConverter.html</anchorfile>
      <anchor>a7e895857e2d7f6fecc411509ec38ea68</anchor>
      <arglist>(bool use_fallback)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_use_fallback</name>
      <anchorfile>classGio_1_1CharsetConverter.html</anchorfile>
      <anchor>aa76508930dd5a1c28659c390c7afadc5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_num_fallbacks</name>
      <anchorfile>classGio_1_1CharsetConverter.html</anchorfile>
      <anchor>a4805ee8c3b365ec318b3a547f5ebec93</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_from_charset</name>
      <anchorfile>classGio_1_1CharsetConverter.html</anchorfile>
      <anchor>af8cf132476ff592b3eaeeb55caf354ea</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_to_charset</name>
      <anchorfile>classGio_1_1CharsetConverter.html</anchorfile>
      <anchor>a99036fac0e13b3d8818b1b8fbb32e794</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_use_fallback</name>
      <anchorfile>classGio_1_1CharsetConverter.html</anchorfile>
      <anchor>a6b731319ccdfee017391c355737f9a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_use_fallback</name>
      <anchorfile>classGio_1_1CharsetConverter.html</anchorfile>
      <anchor>aff9585c32bde6a2fb50642718f0bbc2d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Converter</name>
      <anchorfile>classGio_1_1Converter.html</anchorfile>
      <anchor>a8e8f92d25539dc055fc708e3420b9665</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GConverter *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Converter.html</anchorfile>
      <anchor>a904857babeefa2a3bb6106f83811b99b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GConverter *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Converter.html</anchorfile>
      <anchor>a7bc7eb3d05d45eba0f8f5a041d867232</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ConverterResult</type>
      <name>convert</name>
      <anchorfile>classGio_1_1Converter.html</anchorfile>
      <anchor>ac7778c230badef940aa3abbbc43abaea</anchor>
      <arglist>(const void *inbuf, gsize inbuf_size, void *outbuf, gsize outbuf_size, ConverterFlags flags, gsize &amp;bytes_read, gsize &amp;bytes_written)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset</name>
      <anchorfile>classGio_1_1Converter.html</anchorfile>
      <anchor>a258cb44c0dbd3d98c9eea89e6d35c866</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual ConverterResult</type>
      <name>convert_vfunc</name>
      <anchorfile>classGio_1_1Converter.html</anchorfile>
      <anchor>a7aa9c3c714fe2fe385c9ceef81563f95</anchor>
      <arglist>(const void *inbuf, gsize inbuf_size, void *outbuf, gsize outbuf_size, ConverterFlags flags, gsize &amp;bytes_read, gsize &amp;bytes_written)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>reset_vfunc</name>
      <anchorfile>classGio_1_1Converter.html</anchorfile>
      <anchor>af44ff18014e7898232eca4f4df906ee8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1CharsetConverter.html</anchorfile>
      <anchor>a5509aa74fea77a92c3ba4b52414fe107</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; CharsetConverter &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1CharsetConverter.html</anchorfile>
      <anchor>adf903e89ac7e34f6b211c3b414797eb9</anchor>
      <arglist>(const Glib::ustring &amp;to_charset, const Glib::ustring &amp;from_charset)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1Converter.html</anchorfile>
      <anchor>a17ceb5a322220c2810389a499a6d43c9</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1Converter.html</anchorfile>
      <anchor>a9dacabc2905a659441b89a70ee33b6e9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>CharsetConverter</name>
      <anchorfile>classGio_1_1CharsetConverter.html</anchorfile>
      <anchor>a1ef8d8864c3415d85e65e881b8aefc64</anchor>
      <arglist>(const Glib::ustring &amp;to_charset, const Glib::ustring &amp;from_charset)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Converter</name>
      <anchorfile>classGio_1_1Converter.html</anchorfile>
      <anchor>ae70264adb3ca2a27e800bc84fbaf0716</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::CharsetConverter &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1CharsetConverter.html</anchorfile>
      <anchor>ac58649ccbd58df5ece04510f9d5e5138</anchor>
      <arglist>(GCharsetConverter *object, bool take_copy=false)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Converter &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Converter.html</anchorfile>
      <anchor>a5a53e9fbdcfb444cbe49955aac39c65f</anchor>
      <arglist>(GConverter *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Converter</name>
    <filename>classGio_1_1Converter.html</filename>
    <base>Glib::Interface</base>
  </compound>
  <compound kind="class">
    <name>Gio::ConverterInputStream</name>
    <filename>classGio_1_1ConverterInputStream.html</filename>
    <base>Gio::FilterInputStream</base>
    <base>Gio::PollableInputStream</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~ConverterInputStream</name>
      <anchorfile>classGio_1_1ConverterInputStream.html</anchorfile>
      <anchor>ac0cb41fb75b6561e32a556cbec81b426</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GConverterInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ConverterInputStream.html</anchorfile>
      <anchor>aa076a6a334d59b2876b84b16e5f15a8e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GConverterInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ConverterInputStream.html</anchorfile>
      <anchor>a09ef37a7673e68241c19bf3d49acc61f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GConverterInputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1ConverterInputStream.html</anchorfile>
      <anchor>ad1d7a973d356d14c4d702590152c1ece</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Converter &gt;</type>
      <name>get_converter</name>
      <anchorfile>classGio_1_1ConverterInputStream.html</anchorfile>
      <anchor>a47a3b2a636c33fbc7fee8eaf14220634</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Converter &gt;</type>
      <name>get_converter</name>
      <anchorfile>classGio_1_1ConverterInputStream.html</anchorfile>
      <anchor>a5855ed740955913bf3db77621c6f0230</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; Converter &gt; &gt;</type>
      <name>property_converter</name>
      <anchorfile>classGio_1_1ConverterInputStream.html</anchorfile>
      <anchor>aca3ffd050311192230a3371ec3377757</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~PollableInputStream</name>
      <anchorfile>classGio_1_1PollableInputStream.html</anchorfile>
      <anchor>a078e51ceaafb0f1c606b4926e48e4692</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GPollableInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1PollableInputStream.html</anchorfile>
      <anchor>ae397a025e7818472f54b3dac909d0ae4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GPollableInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1PollableInputStream.html</anchorfile>
      <anchor>a282ece015ac557a1dce344ce37d6206d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_poll</name>
      <anchorfile>classGio_1_1PollableInputStream.html</anchorfile>
      <anchor>a126d3e0ac7ddaa198d20ff7713d27005</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_readable</name>
      <anchorfile>classGio_1_1PollableInputStream.html</anchorfile>
      <anchor>a8fd79806de520cf1ba84097159896bc1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>read_nonblocking</name>
      <anchorfile>classGio_1_1PollableInputStream.html</anchorfile>
      <anchor>a8eb0aa54e3a6cb3bb00d6a898139381a</anchor>
      <arglist>(void *buffer, gsize count, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>read_nonblocking</name>
      <anchorfile>classGio_1_1PollableInputStream.html</anchorfile>
      <anchor>a2d7130fc1b0291eb9531cb3b61052a8e</anchor>
      <arglist>(void *buffer, gsize count)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>can_poll_vfunc</name>
      <anchorfile>classGio_1_1PollableInputStream.html</anchorfile>
      <anchor>abff8a2ec181af77f5eb3d84fb0e523f1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>is_readable_vfunc</name>
      <anchorfile>classGio_1_1PollableInputStream.html</anchorfile>
      <anchor>a5ae8a5e398be325a70cd0302b0163c5a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual gssize</type>
      <name>read_nonblocking_vfunc</name>
      <anchorfile>classGio_1_1PollableInputStream.html</anchorfile>
      <anchor>ac00544ec021330e5b8592a0071d183ad</anchor>
      <arglist>(void *buffer, gsize count)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1ConverterInputStream.html</anchorfile>
      <anchor>a2e7192600bb103a2e0b67a52f5eaf700</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; ConverterInputStream &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1ConverterInputStream.html</anchorfile>
      <anchor>a29d12b5a1fde929ae9d9070650a7a144</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;base_stream, const Glib::RefPtr&lt; Converter &gt; &amp;converter)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1PollableInputStream.html</anchorfile>
      <anchor>a3f2d5350f4fa25919328d4911e816de4</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1PollableInputStream.html</anchorfile>
      <anchor>ad698362f2b1a62c3a35c74a04d196a97</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>ConverterInputStream</name>
      <anchorfile>classGio_1_1ConverterInputStream.html</anchorfile>
      <anchor>af5e916fdc7ae04d6833bd2f85bbbce34</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;base_stream, const Glib::RefPtr&lt; Converter &gt; &amp;converter)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>PollableInputStream</name>
      <anchorfile>classGio_1_1PollableInputStream.html</anchorfile>
      <anchor>a823f9090b70e59716eca1e582aa8073c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::ConverterInputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1ConverterInputStream.html</anchorfile>
      <anchor>a3f7d4430f52555bbba6ca2c0e2614802</anchor>
      <arglist>(GConverterInputStream *object, bool take_copy=false)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::PollableInputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1PollableInputStream.html</anchorfile>
      <anchor>ac3af174b3ea79ce80fef958070db6b7f</anchor>
      <arglist>(GPollableInputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::ConverterOutputStream</name>
    <filename>classGio_1_1ConverterOutputStream.html</filename>
    <base>Gio::FilterOutputStream</base>
    <base>Gio::PollableOutputStream</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~ConverterOutputStream</name>
      <anchorfile>classGio_1_1ConverterOutputStream.html</anchorfile>
      <anchor>acf1b5556e4cf9e886b24ceabd3c34caf</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GConverterOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ConverterOutputStream.html</anchorfile>
      <anchor>a333f4ee5b989075bcf1e1dce9f0b0178</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GConverterOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ConverterOutputStream.html</anchorfile>
      <anchor>a69efe953c6e1b2ce006d96e448d69a00</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GConverterOutputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1ConverterOutputStream.html</anchorfile>
      <anchor>a938a80f3c12a2d451589b0996ed2fcf0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Converter &gt;</type>
      <name>get_converter</name>
      <anchorfile>classGio_1_1ConverterOutputStream.html</anchorfile>
      <anchor>a4a69aedf2615cd5980086ea10e92f516</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Converter &gt;</type>
      <name>get_converter</name>
      <anchorfile>classGio_1_1ConverterOutputStream.html</anchorfile>
      <anchor>a1cd1d2f7e69320c0ef826808a3914cc6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; Converter &gt; &gt;</type>
      <name>property_converter</name>
      <anchorfile>classGio_1_1ConverterOutputStream.html</anchorfile>
      <anchor>a35ed84c62ce934a13cd5f7cd5dfbdafb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~PollableOutputStream</name>
      <anchorfile>classGio_1_1PollableOutputStream.html</anchorfile>
      <anchor>ad314c468de3b7e686901d878e3d593c3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GPollableOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1PollableOutputStream.html</anchorfile>
      <anchor>a1621ceb60a0cd7d69b7a83fa68db2930</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GPollableOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1PollableOutputStream.html</anchorfile>
      <anchor>a6ac3135a4cd1bf567fab07cc9153b4e8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_poll</name>
      <anchorfile>classGio_1_1PollableOutputStream.html</anchorfile>
      <anchor>ad136f0f582f39ade81827b6a619dbfe9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_writable</name>
      <anchorfile>classGio_1_1PollableOutputStream.html</anchorfile>
      <anchor>ac28a6eefbe073269cf0ea035a9f9b576</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>write_nonblocking</name>
      <anchorfile>classGio_1_1PollableOutputStream.html</anchorfile>
      <anchor>ac51562ebbcefb1820ca2de98bfbde720</anchor>
      <arglist>(const void *buffer, gsize count, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>write_nonblocking</name>
      <anchorfile>classGio_1_1PollableOutputStream.html</anchorfile>
      <anchor>a43f7a7991ae9ed11a6d4ef33c8dc7c1b</anchor>
      <arglist>(const void *buffer, gsize count)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>can_poll_vfunc</name>
      <anchorfile>classGio_1_1PollableOutputStream.html</anchorfile>
      <anchor>ae9577138f3aba229a042cedb85e1e37f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>is_writable_vfunc</name>
      <anchorfile>classGio_1_1PollableOutputStream.html</anchorfile>
      <anchor>a8d0bf4eaf8642b5e246587856ac53d5d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual gssize</type>
      <name>write_nonblocking_vfunc</name>
      <anchorfile>classGio_1_1PollableOutputStream.html</anchorfile>
      <anchor>acf75edfb4bcb6b5b989aa7ee3c64abb3</anchor>
      <arglist>(const void *buffer, gsize count)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1ConverterOutputStream.html</anchorfile>
      <anchor>aade9ad0b43d43f31081b339e4b9d9a5c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; ConverterOutputStream &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1ConverterOutputStream.html</anchorfile>
      <anchor>a5a85c4d188f35c66639f16cad69c92f6</anchor>
      <arglist>(const Glib::RefPtr&lt; OutputStream &gt; &amp;base_stream, const Glib::RefPtr&lt; Converter &gt; &amp;converter)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1PollableOutputStream.html</anchorfile>
      <anchor>a41ee04b3c36236782359bae58c27d72c</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1PollableOutputStream.html</anchorfile>
      <anchor>ac31bacd234575604b6f61eaf42574bd7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>ConverterOutputStream</name>
      <anchorfile>classGio_1_1ConverterOutputStream.html</anchorfile>
      <anchor>a76f58e7c20b906a644beca882286d04c</anchor>
      <arglist>(const Glib::RefPtr&lt; OutputStream &gt; &amp;base_stream, const Glib::RefPtr&lt; Converter &gt; &amp;converter)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>PollableOutputStream</name>
      <anchorfile>classGio_1_1PollableOutputStream.html</anchorfile>
      <anchor>a344a103165250271e2a51076f2a2f046</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::ConverterOutputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1ConverterOutputStream.html</anchorfile>
      <anchor>a33f780befc49741bd252d0f16039cabc</anchor>
      <arglist>(GConverterOutputStream *object, bool take_copy=false)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::PollableOutputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1PollableOutputStream.html</anchorfile>
      <anchor>a6557b15ebf4139c32c90c2f626de57b9</anchor>
      <arglist>(GPollableOutputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Credentials</name>
    <filename>classGio_1_1Credentials.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Credentials</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>a50da8ce90cb83b14f364b4ae30502458</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GCredentials *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>a046b2268030f002af002310500000873</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GCredentials *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>ad27e3960d0694de6eb2cedc00dbcaa25</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GCredentials *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>ae88176bf9139ac2f8ec61fc2b243eddd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>to_string</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>ae4852e93b213096b678584e5d90e0f0e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>gpointer</type>
      <name>get_native</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>a71bcd9f09372b9baeaebe515dfd98bf7</anchor>
      <arglist>(CredentialsType native_type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_native</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>af513a0e52915235faf163d5de363a0bd</anchor>
      <arglist>(CredentialsType native_type, gpointer native)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_same_user</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>a762d208e479db720c4e5124ed329131a</anchor>
      <arglist>(const Glib::RefPtr&lt; const Credentials &gt; &amp;other_credentials)</arglist>
    </member>
    <member kind="function">
      <type>uid_t</type>
      <name>get_unix_user</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>a09b5b839f82cbb23c86aa036e883a93a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_unix_user</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>ab791dcd8caa32cc01ad38a6d8cf343e7</anchor>
      <arglist>(uid_t uid)</arglist>
    </member>
    <member kind="function">
      <type>pid_t</type>
      <name>get_unix_pid</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>a4d18b111ef80d6f765de6890182ead39</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>a146b6d80a0ce203582402bee5684424d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Credentials &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>ad1d94115b234e0db180e48509fa18fd8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Credentials</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>a1aef06c5a74793011858b45cfd8d7898</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Credentials &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>af140151edb8dd5ccf10f9decf594b731</anchor>
      <arglist>(GCredentials *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::DataInputStream</name>
    <filename>classGio_1_1DataInputStream.html</filename>
    <base>Gio::BufferedInputStream</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~DataInputStream</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>ae97b466761df6cccb9b4232e8dece6d5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GDataInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>ad788764326462190e900785f50a50740</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDataInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a5d8f01998854eac791a3089acef051c0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDataInputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a8252806b8ac5548c51a0418162ddb6ab</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_byte_order</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a032c20df06b83828d3cb5e81f6b8f561</anchor>
      <arglist>(DataStreamByteOrder order)</arglist>
    </member>
    <member kind="function">
      <type>DataStreamByteOrder</type>
      <name>get_byte_order</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a3be4cc7ce927af027630cdeea0914004</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_newline_type</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>afbc8ad1476fd82e808234a661bfe4cd3</anchor>
      <arglist>(DataStreamNewlineType type)</arglist>
    </member>
    <member kind="function">
      <type>DataStreamNewlineType</type>
      <name>get_newline_type</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>afe528b7ecf9401b7bf91f0c67e34de9f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guchar</type>
      <name>read_byte</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>aca226b5c2d1248dd079d835dd089570d</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>guchar</type>
      <name>read_byte</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>af4d01aa4e791d403b79db406befcc28e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gint16</type>
      <name>read_int16</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a9fd357f931715d83c69b7010ff86af80</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gint16</type>
      <name>read_int16</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a2407fa551610510cfdcda3b2d8adabdc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>guint16</type>
      <name>read_uint16</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a9ac667e423ec3c3d997fc2a4683956d3</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>guint16</type>
      <name>read_uint16</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a4e99722aa033a78ac2f4dc593b36d197</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gint32</type>
      <name>read_int32</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a6280a6c0c6cc1803dc3df8dc29910bcd</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gint32</type>
      <name>read_int32</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>adbbe894fae2ba5d071c3f50895af9067</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>guint32</type>
      <name>read_uint32</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>ae7d36dbd67425b923fe335ec5a3f4124</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>guint32</type>
      <name>read_uint32</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a587856139c73d6c2df1ad2c5560cffec</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gint64</type>
      <name>read_int64</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a5d9599527bcd651841fd4f73082d26e0</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gint64</type>
      <name>read_int64</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a6ccd4123a211d1d89c17bb6e4a4aae35</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>guint64</type>
      <name>read_uint64</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a2e486863876f833e910286300c7e17a4</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>guint64</type>
      <name>read_uint64</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a9c7ed7807b2a8370f879a820dd0c7989</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_line</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a4e1ac2a250c7acd60417454379d580a7</anchor>
      <arglist>(std::string &amp;line, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_line</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a5186689410fe626e35688190b65ec0c5</anchor>
      <arglist>(std::string &amp;line)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_line_utf8</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>ac779efdf33abb470832715abeb47f3ef</anchor>
      <arglist>(std::string &amp;line, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, gsize &amp;length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_line_utf8</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>ad48b87d450f26683d167c74c7c224ceb</anchor>
      <arglist>(std::string &amp;line, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_line_utf8</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>aa1ba4df39f51b81c6e105c71d5941493</anchor>
      <arglist>(std::string &amp;line, gsize &amp;length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_line_utf8</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a8cdccad3a356c1bc34bc9ec967b710b0</anchor>
      <arglist>(std::string &amp;line)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_line_async</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>aad31c733d13f737f893326b3b7f1ff0d</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_line_finish</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a538562b9bf3a80138ba9918b2249f834</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, std::string &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_line_finish_utf8</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a5dade4189842c81b4dc3fc43a8b79af3</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, std::string &amp;data, gsize &amp;length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_line_finish_utf8</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a79e503ebe50065088e7daaa306da9cc3</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, std::string &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_until</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a058c5367f9be4e4e36d5fb9de2201815</anchor>
      <arglist>(std::string &amp;data, const std::string &amp;stop_chars, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_until</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>aa7d2a04bf5a4628df0530ec40d4c33cf</anchor>
      <arglist>(std::string &amp;data, const std::string &amp;stop_chars)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_until_async</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a708cba487c68c8c927fe8ae6277b6123</anchor>
      <arglist>(const std::string &amp;stop_chars, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_until_finish</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>aa851cb398896f39bea56868b46bd480d</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, std::string &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_upto</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>ae1ecebe6229884c4510e5b42eabe4874</anchor>
      <arglist>(std::string &amp;data, const std::string &amp;stop_chars, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_upto</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>afe582f97c8438b1517f16e805e332d1f</anchor>
      <arglist>(std::string &amp;data, const std::string &amp;stop_chars)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_upto_async</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a76d195879b8aa04c22a5c69dc82c0f46</anchor>
      <arglist>(const std::string &amp;stop_chars, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_upto_finish</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>ad0b61e9b6225bea6af433ae28dbdbea8</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, std::string &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; DataStreamByteOrder &gt;</type>
      <name>property_byte_order</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a53ffda2bedfb47315afc50d9ec64ba3b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; DataStreamByteOrder &gt;</type>
      <name>property_byte_order</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a0311a24a36a555cf9e471fbe7aa11050</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; DataStreamNewlineType &gt;</type>
      <name>property_newline_type</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>adf55222b27ecf5db6a604d4e111431f8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; DataStreamNewlineType &gt;</type>
      <name>property_newline_type</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>aec1a1d826fb927eccc4c9f5b444e33af</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a9880bf6913e0ac284cb2607efbb91178</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DataInputStream &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a5ecca0b3f4fdc5962c3c63e4e6706e4e</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;base_stream)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>DataInputStream</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a65e68eef09e6aa1d9e52d446a171fba3</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;base_stream)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::DataInputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a88853a1864df25dc8dda900a6ad52266</anchor>
      <arglist>(GDataInputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::DataOutputStream</name>
    <filename>classGio_1_1DataOutputStream.html</filename>
    <base>Gio::BufferedOutputStream</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~DataOutputStream</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ad59e02b7e431eed80a7e8280576e4145</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GDataOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>acf92da9c162b7a0805aabe334912d5cb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDataOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a42d4127b7b7b16ae6ec3feb5f66b68d2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDataOutputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ac1e10167167a2f5c894e567003483419</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_byte_order</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ad35d1b14012a1f4ce7aeca8e73a0560a</anchor>
      <arglist>(DataStreamByteOrder order)</arglist>
    </member>
    <member kind="function">
      <type>DataStreamByteOrder</type>
      <name>get_byte_order</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ad9d00dd1dbb4e42186049130601e3117</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_byte</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a193a3d737db19250895ad4329b82a602</anchor>
      <arglist>(guchar data, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_byte</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a82d0f12bac635dc5889847c4911c3407</anchor>
      <arglist>(guchar data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_int16</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a967df26dca9c0948d78bd495800eeda3</anchor>
      <arglist>(gint16 data, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_int16</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a29c0d46538383ed82d622068d826d06e</anchor>
      <arglist>(gint16 data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_uint16</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>aa0f8a4fda83e453a49d5cf614868b392</anchor>
      <arglist>(guint16 data, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_uint16</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>aa222bd351437698643820251e28a406d</anchor>
      <arglist>(guint16 data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_int32</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ac405b5c957d34ff068fb07a30dbb5f09</anchor>
      <arglist>(gint32 data, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_int32</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ac02e3766459a8bb970022ff3991d841e</anchor>
      <arglist>(gint32 data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_uint32</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a4851b514c9f3ca166b581b35f530ea71</anchor>
      <arglist>(guint32 data, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_uint32</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a16cdae2dd633a4afaea583baa7d10d44</anchor>
      <arglist>(guint32 data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_int64</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ac7efa2d21047145f79fd651129b372f2</anchor>
      <arglist>(gint64 data, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_int64</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>abbe60cbe43ae446cef3a7c9764a6fe08</anchor>
      <arglist>(gint64 data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_uint64</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a4a16076bd66c8f2e249ecde22f9762c1</anchor>
      <arglist>(guint64 data, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_uint64</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a5dfd43d27380c031314adf0dc67b4cb4</anchor>
      <arglist>(guint64 data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_string</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a11a8e87ba2da06727d2c8751214b7055</anchor>
      <arglist>(std::string str, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_string</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ababf1898b1e49d7d16fdacdfe38db3f3</anchor>
      <arglist>(std::string str)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; DataStreamByteOrder &gt;</type>
      <name>property_byte_order</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a1f7d606475f5bf58d6a344a35a3b93ee</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; DataStreamByteOrder &gt;</type>
      <name>property_byte_order</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>aaa3ddd7757f53f5dd11777a147b1ba34</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>aa9e6fcef3024211d11d990f97673ebf6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DataOutputStream &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>aa9c23f0bf4d13c5a4ca5b7bb03991928</anchor>
      <arglist>(const Glib::RefPtr&lt; OutputStream &gt; &amp;base_stream)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>DataOutputStream</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ab01b287da67c8d2312a82f03de59916f</anchor>
      <arglist>(const Glib::RefPtr&lt; OutputStream &gt; &amp;base_stream)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::DataOutputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a53e38b7e7370532ed71a1f434050043a</anchor>
      <arglist>(GDataOutputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::DesktopAppInfo</name>
    <filename>classGio_1_1DesktopAppInfo.html</filename>
    <base>Glib::Object</base>
    <base>Gio::AppInfo</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~DesktopAppInfo</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>a8dbb1f225b0f9512c0cef546b7d32012</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GDesktopAppInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>a3098e225a5b79ac496941ae2ab804c0c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDesktopAppInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>af6f5698a7fd78187bac77556ac54622f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDesktopAppInfo *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>a60fe723570666ef15c3b024bdfaf6165</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_filename</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>aba05bd82eb13c39f1ec8b6aeb233cd03</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_hidden</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>a23113d028a906d5b3e2626dc558f36e6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Glib::ustring &gt;</type>
      <name>get_keywords</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>af50116d4b05e8ece2225503e2a2187f4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_startup_wm_class</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>af9cab954da592bbbdf88d20809813ba1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_nodisplay</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>a18386532054c0b1be5e95505ac6ca906</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_show_in</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>a788388627a997e53e50a97e0721576a9</anchor>
      <arglist>(const std::string &amp;desktop_env) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_generic_name</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>aff07e2f971b7fff38c44b0287f62d3c3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_categories</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>ad74ff0ef8d13a913ae33eae087295441</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_key</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>a439947d8fb839ed66538430db1ec5470</anchor>
      <arglist>(const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_string</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>ad744bf9f27b0a35c69d33341bf7bd3d6</anchor>
      <arglist>(const Glib::ustring &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_boolean</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>af7380a428b0ab1100b295780b0472d53</anchor>
      <arglist>(const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Glib::ustring &gt;</type>
      <name>list_actions</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>a1a8e16fc896a82870fa5cad74984006e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>launch_action</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>abcbc0bb6f0c48c3c06eb05756beeaa60</anchor>
      <arglist>(const Glib::ustring &amp;action_name, const Glib::RefPtr&lt; AppLaunchContext &gt; &amp;launch_context)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>launch_action</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>a15147c1871562bbd642ffa7e40f4243e</anchor>
      <arglist>(const Glib::ustring &amp;action_name)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_action_name</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>a1344d1f5d0e8bfdd299d322628ae2178</anchor>
      <arglist>(const Glib::ustring &amp;action_name) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>af08dc73fb24e62daeafa3d34e6d9fb7e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DesktopAppInfo &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>ab6d9c00e00745f57d2e5b35f83060aad</anchor>
      <arglist>(const std::string &amp;desktop_id)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DesktopAppInfo &gt;</type>
      <name>create_from_keyfile</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>a4c474a10b54e12eac4cf71ee409c61c0</anchor>
      <arglist>(Glib::KeyFile &amp;key_file)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DesktopAppInfo &gt;</type>
      <name>create_from_filename</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>a42dca267f3ad09aaacd4937d20e4ed1d</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>set_desktop_env</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>ad3d07eea529c72d51aa868fe30d63392</anchor>
      <arglist>(const std::string &amp;desktop_env)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::DesktopAppInfo &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>ac075226810f278017e3a0fbcc372e739</anchor>
      <arglist>(GDesktopAppInfo *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Drive</name>
    <filename>classGio_1_1Drive.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Drive</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a92df3dab950a06a57ea2f5080b917a14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GDrive *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>aaa1d4330f6e1d0faee6262f632c63227</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDrive *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>ada0bdfcbce80c94f4b080f6de73706df</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_name</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a29125b6262e95613e92266221584ab2d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>aa7bbfe3d9eb4c716e4e964388b504458</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>ad0407bd1e193689a5b088abac49f581c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>get_symbolic_icon</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a25a8c98c25172d7fe3c747d8df4faca6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Icon &gt;</type>
      <name>get_symbolic_icon</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a65876a4184ba4c0b301d836494b94961</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_volumes</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a42a2753bc97ae014a1649dc53b4acfae</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::RefPtr&lt; Volume &gt; &gt;</type>
      <name>get_volumes</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>afe6e5759dcf759a1c862e172543d6bd3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_media_removable</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>aa9c9b3db01d76f26527702860498b531</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_media</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>ad5397764c7a76adf9a0d8bc4f419fbe3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_media_check_automatic</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a0cbbb630e6f944f2cd078219d7e35cc7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_poll_for_media</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a538ad0e01c3359d7d75e8389eb54dec0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_eject</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a63d1960ea469bdb1a61ddf1752a6e9b9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a4163a79cc5ff639693159110592e6be0</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a7677be984564a7cf3c5ab7dd3ebb6c96</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a306949d0008fd30a59136e0759dd60ed</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a21a808bb07f7cb580899006fd42c76ea</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>af66cf6ad9b9027630f1c9303bbb6a8fe</anchor>
      <arglist>(MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>acb804853bd5e4ecf4abc6503e6ffa82d</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>eject_finish</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>abdc299d32ba4dd96784db3a9a4523ea4</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>poll_for_media</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a1733be3e6aa7c23caa3c12a45d75878d</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>poll_for_media</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a1c565d20c1f17a233db75dec9ce30415</anchor>
      <arglist>(const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>poll_for_media</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a85bd972cad1ef7e1c2627767a825eed0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>poll_for_media_finish</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>afa415ce0439367e5d8685a2bb1bd9b8d</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_identifier</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a6a94c55bba839fa834ba18bc4ef41c39</anchor>
      <arglist>(const std::string &amp;kind) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>enumerate_identifiers</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a8c6c6c5597208c8cc9610b5f2d9f8107</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a48cae86204823873e110ecdf7948a5c3</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const SlotAsyncReady &amp;slot, DriveStartFlags flags=DRIVE_START_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a99ca25e21f33f54e79b9d62e47ddda71</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, DriveStartFlags flags=DRIVE_START_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>start_finish</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a7d81d812989e5dc79414c63149dda9d7</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_start</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a2594f0176716f8aec2464a3b4dc856a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_start_degraded</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>ac047620f769a455b2ca3869bf725e9eb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stop</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a037cd31001af5d6d0540f4ccbe7b12bf</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stop</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a1adf5f0d63a2d3a38acc4328f726f7ed</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>stop_finish</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a308102dbcef3dac0a3ad0006a0c1440e</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_stop</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a79c25c1986a1e46ca8dcdf8e331b4dba</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DriveStartStopType</type>
      <name>get_start_stop_type</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a5c9954887834a697b9417188c4e0ccb0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_sort_key</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a1bc29b35563487b0ade38bfd3d8307d8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_changed</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>abda915e1b5fff2be69fc28bbbba05736</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_disconnected</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>aa65a212796147d65d4fa953755c33b6e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_eject_button</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>aae48457a354c2bbde87b27c991bf867d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_stop_button</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a37a763ad90197500323edacc4e6a8f63</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a4a00b2efd7a10fae3ffc6e67f30b0908</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>ad065a22ee02560b7a11dc934ba57f29b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Drive</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>afeac53258c52f48d82717022dd24f87e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Drive &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a1a0d5aec4d31827ebfcbdea0c2ebee87</anchor>
      <arglist>(GDrive *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Emblem</name>
    <filename>classGio_1_1Emblem.html</filename>
    <base>Glib::Object</base>
    <base>Gio::Icon</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Emblem</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a3b0b61279f632bcac5894004b99c5f4b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GEmblem *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a18a84361942885e0b75a82ffbc342947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GEmblem *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>aedc2ab1a8682aff33ba0dbdaf5d05afb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GEmblem *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a37489c6af0fd3ebcc26f2ad70499ab69</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a2272bb4eb06787a561eae7593912aa04</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>aaea925c28921a3d9a5e772aace7a2ff4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>EmblemOrigin</type>
      <name>get_origin</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>ae2e37f3de1e0d50b50a3ba4e9ff3d30f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Icon</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>a860156dd8f8c9143cce6fba134e5d7cb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>a02ef784d9a07a205ce1d7daac39d2054</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>a94b7e4b63ce6c1c0f05673dd8b4adf94</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>hash</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>acbcfcaa91ff4d50f700267e2928a61ae</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>to_string</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>a7b0d721c852d1e5b0f9cd875769fabd7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>equal</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>a90820057c0e8974d43d2597df18efb20</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;other) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a2bb85fdfcc9864d8c90cf274bfb868b2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Emblem &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a73b765b853f364b1681352efc8a73a69</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Emblem &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a49167949418fba4e254c3044b5b2808d</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon, EmblemOrigin origin)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>abd37e490fdf4da67eb3bbe2561c16ee3</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>a04d158ce09690dfd7bb2a61303451fc2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Icon &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>a8ae9b8e7b8159620eea7f9215cac83ab</anchor>
      <arglist>(const std::string &amp;str)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Emblem</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a145a95e9ca6ee5d31be2c94be935c060</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Emblem</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a2ff0e5c38e6fc97b2c57188099304fef</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon, EmblemOrigin origin)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Icon</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>a371ebc971db810d36edf00879f9ea1df</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Emblem &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a53ecca7bfb4c8b1e3ac4305a8087bf3e</anchor>
      <arglist>(GEmblem *object, bool take_copy=false)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Icon &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>a9f6d4523888318e40c362de6eea23004</anchor>
      <arglist>(GIcon *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::EmblemedIcon</name>
    <filename>classGio_1_1EmblemedIcon.html</filename>
    <base>Glib::Object</base>
    <base>Gio::Icon</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~EmblemedIcon</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>a52372e1aef73698e9ed8dfe9623ef8e7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GEmblemedIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>ad19779f46ff62261df8b924f2e218f00</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GEmblemedIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>a2b4a572414232927365ade6bf7bd1d5d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GEmblemedIcon *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>afa5683d27b359053a929ca46d61ff512</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>aaa34ad2bbd13edbed76aaf908a04c630</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>afd4b52af91512a77936c0c1e13222436</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::RefPtr&lt; Emblem &gt; &gt;</type>
      <name>get_emblems</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>ad1795232c2d5abd7edec6a56072d94e9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_emblem</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>acf332055cf535914f444bc037ba7d324</anchor>
      <arglist>(const Glib::RefPtr&lt; Emblem &gt; &amp;emblem)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear_emblems</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>ae04323b13dba3195a1351a4bee7eeb86</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>a3100ee99c8cf620cbbac630b0af0b8ca</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; EmblemedIcon &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>ac4e4b5c233a669ac82db3852b5d9a1a6</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon, const Glib::RefPtr&lt; Emblem &gt; &amp;emblem)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; EmblemedIcon &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>a7099cac3bd82490137952fddbb398379</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>EmblemedIcon</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>af58a1bcda197ad6d06646423490ed60a</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>EmblemedIcon</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>a2d790c876f3033983c5989a64f5ed83a</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon, const Glib::RefPtr&lt; Emblem &gt; &amp;emblem)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::EmblemedIcon &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>a1f2d2a7c6ad0125c6a9b4b41c2b7766a</anchor>
      <arglist>(GEmblemedIcon *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Error</name>
    <filename>classGio_1_1Error.html</filename>
    <base>Glib::Error</base>
    <member kind="enumeration">
      <type></type>
      <name>Code</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FAILED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a4b7bf87fd22aea037daa6cadd0f6c6db</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NOT_FOUND</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a71ba0a8ad3a2cee6b86aae19fa38f8d0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>EXISTS</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a46c2fb3115cde148a9044a996a5f5947</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>IS_DIRECTORY</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134aa3b4c2b6e1109309dfb04e111ae0eeae</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NOT_DIRECTORY</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134ac89747d1a8296a2d7abc61e33e9a6849</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NOT_EMPTY</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a4d1db4eab217424adeb9acbb8bdcbed1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NOT_REGULAR_FILE</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a5f4f1cdbfc26e0b284ddc971e69b1153</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NOT_SYMBOLIC_LINK</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a308933795ee7ee7613e555eb6dfa89ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NOT_MOUNTABLE_FILE</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134aad4e3bf56a2de0f7642eb5713a4e2da0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FILENAME_TOO_LONG</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134af64160bec6d689e9143b2b065114a8b8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>INVALID_FILENAME</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a4705fc1de258afdbf3d80d1e6a9c1a93</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TOO_MANY_LINKS</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a6bc650c3933a11fd0eec1a03c96bacfd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NO_SPACE</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134adb48a8d32cc13f996feccfd7e7f4bfa9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>INVALID_ARGUMENT</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a2cc33d826acd1d12989ae83f4685db1e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PERMISSION_DENIED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a6f7122349d0108e792444d115cfe067e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NOT_SUPPORTED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134aa46bb4ae8662767fb5bf2406c384ca58</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NOT_MOUNTED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a37bbb3053c929cc59ba594a0e68c4e2e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ALREADY_MOUNTED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a2c70c6db9fe114fd367bb673a8f0d84e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CLOSED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a252082a76c9bf70f5df5e736b7334951</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CANCELLED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a9da2cb56b3e1b8db9adf481360e2ad0c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PENDING</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a6420882bc2f68e77254adb9767bac2b2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>READ_ONLY</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a15305a05f8c09ef80549261f01d42ae7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CANT_CREATE_BACKUP</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134ace8da5552c3ab58264e8c53011c68e18</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>WRONG_ETAG</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134ab84b31830cf8bda8886977905d8c0843</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TIMED_OUT</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a44decc3b328a874eadd76414c7ebe4db</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>WOULD_RECURSE</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a3af6165f166bf4e8aef85437d4497929</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>BUSY</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a066d8df507fe9a2de219f618d6242cce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>WOULD_BLOCK</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a4041bd40a7ec2e6dc8dae84c30065fec</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>HOST_NOT_FOUND</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a267c1b76c0f55be7e49beb9aeb387e7e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>HOST_WAS_NOT_FOUND</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a207ecccfb593af57a3db3c9311e623a6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>WOULD_MERGE</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134ac7a10c56c904ac8d1d977945c88d6b33</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FAILED_HANDLED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a8001f1c0293ab55c88643e3eef3458aa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TOO_MANY_OPEN_FILES</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134ab091e49c560d423fc47f1a9d5187540e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NOT_INITIALIZED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a9664753e60bdd49ecee28c513c33b53e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ADDRESS_IN_USE</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134ad49388bed14b5c28982d23fdc3bd21e3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PARTIAL_INPUT</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a4e616ea6aabe4b0ac1268d4eb7d1e23e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>INVALID_DATA</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a2e462d24aa411472f42467d6b1f6c349</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DBUS_ERROR</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a215f4a0e611d0b19eb3ead2338e314b1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>HOST_UNREACHABLE</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134ac0376a95fd22bee8a154080a64abb857</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NETWORK_UNREACHABLE</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134afece7f5dd896fff22c501c864ea4e9d0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CONNECTION_REFUSED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a65c7317f63eaacebcde82199bb7dd467</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PROXY_FAILED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134af53bc67ed0d73d7dfc014e9284363ae4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PROXY_AUTH_FAILED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a540cbcb6c05b20492c678495964f9a1f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PROXY_NEED_AUTH</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a06379a3549173bb2a2b42fc749b3875e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PROXY_NOT_ALLOWED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134ac58b52f032fda78515a08348277eafda</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>BROKEN_PIPE</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a4ddbc20b7f37144336e263cfbef1a603</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Error</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a6dbe1ed978ad03ee64dbec0a055c3914</anchor>
      <arglist>(Code error_code, const Glib::ustring &amp;error_message)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Error</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a0e59e13293663b6c1690f9277c5b48b6</anchor>
      <arglist>(GError *gobject)</arglist>
    </member>
    <member kind="function">
      <type>Code</type>
      <name>code</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>ac353667814678e7406d8b1ab72cb430a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Error</name>
      <anchorfile>classGlib_1_1Error.html</anchorfile>
      <anchor>a2639aeb2b6a6c43662cf17b8c88a122d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Error</name>
      <anchorfile>classGlib_1_1Error.html</anchorfile>
      <anchor>a40547bd64c5de1ada0feb948428524e5</anchor>
      <arglist>(GQuark domain, int code, const Glib::ustring &amp;message)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Error</name>
      <anchorfile>classGlib_1_1Error.html</anchorfile>
      <anchor>a70257ceb030e4d9dd3ac9a6482830d24</anchor>
      <arglist>(GError *gobject, bool take_copy=false)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Error</name>
      <anchorfile>classGlib_1_1Error.html</anchorfile>
      <anchor>a715ed79ccf7d2fa3a357014fc614a4a4</anchor>
      <arglist>(const Error &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Error &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlib_1_1Error.html</anchorfile>
      <anchor>a6fd059d3c4d24c3f6a0f6999be41b138</anchor>
      <arglist>(const Error &amp;other)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Error</name>
      <anchorfile>classGlib_1_1Error.html</anchorfile>
      <anchor>ae58400627bb4445a54651ae95bb63829</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GQuark</type>
      <name>domain</name>
      <anchorfile>classGlib_1_1Error.html</anchorfile>
      <anchor>a8d0366db925669aa5841f21e48f278c4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>code</name>
      <anchorfile>classGlib_1_1Error.html</anchorfile>
      <anchor>a073623423095dc52db289bf04a146648</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>what</name>
      <anchorfile>classGlib_1_1Error.html</anchorfile>
      <anchor>ac5a9ff59ba32b2ddc24c5c6c0c86d605</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>matches</name>
      <anchorfile>classGlib_1_1Error.html</anchorfile>
      <anchor>aae4921c01b2852ddb48984b4a5ec760c</anchor>
      <arglist>(GQuark domain, int code) const </arglist>
    </member>
    <member kind="function">
      <type>GError *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1Error.html</anchorfile>
      <anchor>a69e6636c8ed726b1468ed61c07d65816</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GError *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1Error.html</anchorfile>
      <anchor>a41b5a27b917ecb6a0176387bf357d8cc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual</type>
      <name>~Exception</name>
      <anchorfile>classGlib_1_1Exception.html</anchorfile>
      <anchor>a44a9c79be10c68a6861f015217ce18fb</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>GError *</type>
      <name>gobject_</name>
      <anchorfile>classGlib_1_1Error.html</anchorfile>
      <anchor>aaf45a78024403f011e31a73c1361c59a</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::File</name>
    <filename>classGio_1_1File.html</filename>
    <base>Glib::Interface</base>
    <member kind="typedef">
      <type>sigc::slot&lt; void, goffset, goffset &gt;</type>
      <name>SlotFileProgress</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac5ff32ee99845479d138eee49d92e59c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; void, bool, guint64, guint64, guint64 &gt;</type>
      <name>SlotFileMeasureProgress</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a6bb470935903b3745b2c8bcca1f40536</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; bool, const char *, goffset &gt;</type>
      <name>SlotReadMore</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>add182d22071784fc345adc757b3d687b</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~File</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af17e8c7b30baa13aaa5d58ef4d56e383</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFile *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a96552cfbaf2e5fa3659a1568db8cca91</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFile *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5437bc648d8b73451e8bee0bc902cfc0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>dup</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a9ea238062cdc317ae982ffae5c226c9b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>hash</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a0320bac72ecc9ced1f894f1af696856f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>equal</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a8877115c870ea8f58b03d1d3c01a83e4</anchor>
      <arglist>(const Glib::RefPtr&lt; const File &gt; &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_basename</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac731bed45bb7fcfd411eb69c49d3b883</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_path</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a7b3edc7946b681b6db2cdcdad08d2b00</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_uri</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a2d1313e4a4eb5de034b693ec1cc9fba0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_parse_name</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aea4a78163e3085a35cbaacde9a3a7628</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>get_parent</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af39bbd5013b2dd675911df322e12ff94</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_parent</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae0b0d16b849b2f92699ad57ee7c935d9</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;parent) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_parent</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aa1daee0498c403e83ac509e6157edd1c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>get_child</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a53c533d6bbeaaadd1b5592cf1e5ef93c</anchor>
      <arglist>(const std::string &amp;name) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>get_child_for_display_name</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a479cfd632af30b29e125f904f809ed71</anchor>
      <arglist>(const Glib::ustring &amp;display_name) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_prefix</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4c40ec88dfc4333f19e939d26a1e0332</anchor>
      <arglist>(const Glib::RefPtr&lt; const File &gt; &amp;prefix) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_relative_path</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a464248111fa2bc5df89c620354eb99bb</anchor>
      <arglist>(const Glib::RefPtr&lt; const File &gt; &amp;descendant) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>resolve_relative_path</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac5e286d421c7236df39881f8ce0a4e03</anchor>
      <arglist>(const std::string &amp;relative_path) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_native</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aaa3b910bc9f240d4ebd0efc70979f163</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_uri_scheme</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a90d71529e5b51b9ff73914eaf90be0f1</anchor>
      <arglist>(const std::string &amp;uri_scheme) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_uri_scheme</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aeecec6962f955bd72ac5595be37db7a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInputStream &gt;</type>
      <name>read</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a3ef959c7ad7096846f26eb8b282e3c68</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInputStream &gt;</type>
      <name>read</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a0395b3b0b8cec5dc1fd9953e52e5fbc1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a2826eed0b1e76c3771f6ad5f5b993991</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab451a182a647408e697c9115e66f6194</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInputStream &gt;</type>
      <name>read_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a3e71d2cd04c5c9c17a51fe8f1dc87c78</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;res)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>append_to</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a91c93ee71eee738690cb551d11df9528</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>append_to</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a8db337b93f3b9b9a6e163477391e6c89</anchor>
      <arglist>(FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>create_file</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a86258e11b2884422819d051c3cfd07a2</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>create_file</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5cf2b17b953ccfefb1d13c39bd1be72c</anchor>
      <arglist>(FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileIOStream &gt;</type>
      <name>create_file_readwrite</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad5ec69c5360219bccb794bab6a128e88</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileIOStream &gt;</type>
      <name>create_file_readwrite</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>acf5673ceb9095405e458b5035b0986b4</anchor>
      <arglist>(FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>replace</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad7cf0360096504e40f799fde5cc8e9de</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;etag=std::string(), bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>replace</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>acf55f9291659566f6fd36271801b013b</anchor>
      <arglist>(const std::string &amp;etag=std::string(), bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append_to_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a1e3dfb193e8f2ab69e24c4370de5335a</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append_to_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>abff3163e9bf8d8208cd0c0e568b777de</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>append_to_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab95fdc72631ad9a07a94eac0bac50090</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;res)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>create_file_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae0c42446d37aa466173965b7db1a2053</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>create_file_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a3fe6ed015f3d2bb72aa7aceed8dc7ca1</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>create_file_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a128001018104d45b158a27003c0c2638</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;res)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>create_file_readwrite_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4c27a2460468aab1d3c3665234c24a56</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>create_file_readwrite_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5a5989cfdee54778de733a529c24607b</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileIOStream &gt;</type>
      <name>create_file_readwrite_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a339d08bf6cafea58d9d0b0675e741d25</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;res)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad777cdaa404a6a668ee8d520299687ce</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;etag=std::string(), bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae51e51a2e3a45da4324230b4d5401a58</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;etag=std::string(), bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>replace_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4e5fe0438c73500d3d6ec7d0d4b39daa</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;res)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileIOStream &gt;</type>
      <name>open_readwrite</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a128757d6cf7b152c82bb378a095003ef</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileIOStream &gt;</type>
      <name>open_readwrite</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a456f74951f371ef5cca4282751efc66a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>open_readwrite_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a73d95a731716c7ffaa86c3af90afe8d3</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>open_readwrite_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a405af7082f531a7a39f3e7a453ab6267</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileIOStream &gt;</type>
      <name>open_readwrite_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5fdcb54ece686c870eac69c6f93aed75</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;res)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileIOStream &gt;</type>
      <name>replace_readwrite</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af483e2ddc29cbb6cd1ad751403247bad</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;etag=std::string(), bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileIOStream &gt;</type>
      <name>replace_readwrite</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a0c4aa84e74b27a67bce6b5fdccb91449</anchor>
      <arglist>(const std::string &amp;etag=std::string(), bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_readwrite_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af5ebbb5e33c0afd302add9863f2d8c24</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;etag=std::string(), bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_readwrite_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a38b7d1782f03a4d6a4dbf3be16321324</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;etag=std::string(), bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileIOStream &gt;</type>
      <name>replace_readwrite_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a47d246b8ff87be3aaef635ac123d1e44</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;res)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>adb25ffdbe571d33e89c9503fe9a20dcd</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4e4b9c07ade255b12e2b43c38c3aba90</anchor>
      <arglist>(const std::string &amp;attributes=&quot;*&quot;, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>query_exists</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad8b0a75e0afdb5f6874ea5e304d55ea8</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>query_exists</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab4cfdbf4fedacd364e40a72c71ab341a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>FileType</type>
      <name>query_file_type</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aa27c5b271c8f7667ce117cfc6118262e</anchor>
      <arglist>(FileQueryInfoFlags flags, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable) const </arglist>
    </member>
    <member kind="function">
      <type>FileType</type>
      <name>query_file_type</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a691a9de5512b870bf358a9b0d292e146</anchor>
      <arglist>(FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_info_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a7bd60e7864f8954c35e3b0891058e61c</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE, int io_priority=Glib::PRIORITY_DEFAULT) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_info_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>afcad69d782a971802a8aa85125ac2c8c</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;attributes=&quot;*&quot;, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE, int io_priority=Glib::PRIORITY_DEFAULT) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a33eadfff77c93a77ecde795307728e52</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;res)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_filesystem_info</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a40486bc2f0c8758ef8a705b6b8b57e57</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_filesystem_info</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac737012f8df97d90e2447d94d30b817d</anchor>
      <arglist>(const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Mount &gt;</type>
      <name>find_enclosing_mount</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a45b881926b8d58c49d3baa1f51f2ee5d</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Mount &gt;</type>
      <name>find_enclosing_mount</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a6eb675267c7ea1c2a0d40e2e754d8333</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_filesystem_info_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a39184ff9c9437259df4b9a9e2f283a0b</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;, int io_priority=Glib::PRIORITY_DEFAULT) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_filesystem_info_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4557ab16a50337f73d8a4649cf60fe70</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;attributes=&quot;*&quot;, int io_priority=Glib::PRIORITY_DEFAULT) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_filesystem_info_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af986512a5b8cb8acf75afd7206b09be1</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;res)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>find_enclosing_mount_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a78c95d4fa47157f7757b686677dec018</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>find_enclosing_mount_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a67458be57c5687e7469bc26e2594f4be</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Mount &gt;</type>
      <name>find_enclosing_mount_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad4b415b02053e16a92cabb6a48368733</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;res)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileEnumerator &gt;</type>
      <name>enumerate_children</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a68c3afcddc0d4860aa2afb4bf715bb20</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileEnumerator &gt;</type>
      <name>enumerate_children</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac0e293d607499b223f4892fb290ab2d6</anchor>
      <arglist>(const std::string &amp;attributes=&quot;*&quot;, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>enumerate_children_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a1ead7237b7057d9b15cf5f3065988131</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>enumerate_children_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5b5470cf1c97754a12169201665f1202</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;attributes=&quot;*&quot;, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileEnumerator &gt;</type>
      <name>enumerate_children_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>acdabb80157c69c01479e0b89821c1299</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;res)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>set_display_name</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a3dd75810d7c9ebafac398288f5afc018</anchor>
      <arglist>(const Glib::ustring &amp;display_name, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>set_display_name</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a8c2aa80b2d0ecdd22f0222c8ce42d177</anchor>
      <arglist>(const Glib::ustring &amp;display_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_display_name_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a0ac539d7758b9c0de809f8c83e0bba79</anchor>
      <arglist>(const Glib::ustring &amp;display_name, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_display_name_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a74d219d321dca3d438f876256dee82d2</anchor>
      <arglist>(const Glib::ustring &amp;display_name, const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>set_display_name_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a2abb19573076b426434f7d8d2d5a0cdb</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;res)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>remove</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aded971b0cf84801f6684ad4bd5dc66c5</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>remove</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a14f34508dea523cbf889b7193e513ca4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad8499cabde1f50f1cbd5d928d63e73fb</anchor>
      <arglist>(const SlotAsyncReady &amp;slot_ready, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a21198001203267126de9a24a8e91b0d1</anchor>
      <arglist>(const SlotAsyncReady &amp;slot_ready, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>remove_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a0240c85a3ec46e107666e65da9b92c54</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>trash</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>acae5ecd962e832cf8d538877f4118da8</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>trash</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a1925736f9af338eaf9942468b4d6d65e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>trash_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>afab15e7d88376d144253bce7bfba2730</anchor>
      <arglist>(const SlotAsyncReady &amp;slot_ready, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>trash_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5cb6f01422a66c141ba721fc8790f10a</anchor>
      <arglist>(const SlotAsyncReady &amp;slot_ready, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>trash_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a7ee78bd712cb24661335cee8e3d29344</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>copy</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af9e906ed93069e6adb6d87dae158cad9</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const SlotFileProgress &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCopyFlags flags=FILE_COPY_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>copy</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a1d8159b5b377db174b376b3c09deb7c1</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const SlotFileProgress &amp;slot, FileCopyFlags flags=FILE_COPY_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>copy</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a7a6b45bed32567031bc7b48273ad4079</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, FileCopyFlags flags=FILE_COPY_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a1785b7a4780d5d4ba5ae651350e34398</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const SlotFileProgress &amp;slot_progress, const SlotAsyncReady &amp;slot_ready, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCopyFlags flags=FILE_COPY_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5b8ae7393c73a9a1d383a82d61f4ac30</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const SlotAsyncReady &amp;slot_ready, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCopyFlags flags=FILE_COPY_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac2b1a85f29bbbe15998c090b3794cbf5</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const SlotFileProgress &amp;slot_progress, const SlotAsyncReady &amp;slot_ready, FileCopyFlags flags=FILE_COPY_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad538a383b8761d04bd36ed1aa1071e50</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const SlotAsyncReady &amp;slot_ready, FileCopyFlags flags=FILE_COPY_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>copy_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab16cd89db6cd5bb0c8dfdd4b635002d7</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;res)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>move</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a51c0d55880178c37dee578fdc723b0f2</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const SlotFileProgress &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCopyFlags flags=FILE_COPY_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>move</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>adfb2d8bfed1cb7af50e5e5795ebea732</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const SlotFileProgress &amp;slot, FileCopyFlags flags=FILE_COPY_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>move</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aba1fab56c3a8bea0b7e4d7f7324c5320</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, FileCopyFlags flags=FILE_COPY_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>make_directory</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>abfa05e23e95e77cabac289ab4e294a58</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>make_directory</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aa1e9aa5f58a76a8562fd00a13434f554</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>make_directory_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a60cf2bf09420aec99766fa132d8ae0a8</anchor>
      <arglist>(const SlotAsyncReady &amp;slot_ready, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>make_directory_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad7facff532924459948de0031396f9b5</anchor>
      <arglist>(const SlotAsyncReady &amp;slot_ready, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>make_directory_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a0758295d049fe070dd235786775f777e</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>make_directory_with_parents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>afb0b5b094339057b4b15952eb73e08d6</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>make_directory_with_parents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a874a487551d49ca62b31a3e5cf32fee6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>make_symbolic_link</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a2709318e1f24dfd0cd498d28f5e1b8fe</anchor>
      <arglist>(const std::string &amp;symlink_value, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>make_symbolic_link</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a8a9a3d060c2675ff9ac1c758f0b2c024</anchor>
      <arglist>(const std::string &amp;symlink_value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileAttributeInfoList &gt;</type>
      <name>query_settable_attributes</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4a543339b58cff6a7e5ddd840df0e69e</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileAttributeInfoList &gt;</type>
      <name>query_settable_attributes</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a1ae03d0652bcfbad2f47409b8f815bc4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileAttributeInfoList &gt;</type>
      <name>query_writable_namespaces</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af5c7463b92e2887597486e7b195ca12f</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileAttributeInfoList &gt;</type>
      <name>query_writable_namespaces</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aa0278acd7d09ed292359004defb742b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attributes_from_info</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a69d9e40a85b96809abc5189b34e8d9b7</anchor>
      <arglist>(const Glib::RefPtr&lt; FileInfo &gt; &amp;info, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attributes_from_info</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae9f6975ffef28f0d7145601a99de0903</anchor>
      <arglist>(const Glib::RefPtr&lt; FileInfo &gt; &amp;info, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attributes_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a14165fba9bf7d91448c3207407ae50c2</anchor>
      <arglist>(const Glib::RefPtr&lt; FileInfo &gt; &amp;info, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attributes_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a61317a1980318537aa8ada7bb8cc2390</anchor>
      <arglist>(const Glib::RefPtr&lt; FileInfo &gt; &amp;info, const SlotAsyncReady &amp;slot, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attributes_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aefd45aed7b975b6e204e67927de2817a</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, const Glib::RefPtr&lt; FileInfo &gt; &amp;info)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_string</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5ce5f43fd5e2836ac1989a54d3233ff6</anchor>
      <arglist>(const std::string &amp;attribute, const std::string &amp;value, FileQueryInfoFlags flags, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_string</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a75fa7e1a44e97a910d232f2b4ab4bfdd</anchor>
      <arglist>(const std::string &amp;attribute, const std::string &amp;value, FileQueryInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_byte_string</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4f4373b8694c346a6908195f1f2644f3</anchor>
      <arglist>(const std::string &amp;attribute, const std::string &amp;value, FileQueryInfoFlags flags, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_byte_string</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a09f574259052186e1b516bdcbe696710</anchor>
      <arglist>(const std::string &amp;attribute, const std::string &amp;value, FileQueryInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_uint32</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae53b0f4d2214e050a290c8e35cac0f27</anchor>
      <arglist>(const std::string &amp;attribute, guint32 value, FileQueryInfoFlags flags, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_uint32</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a7f769f140143f2e96a7587a10b6792a9</anchor>
      <arglist>(const std::string &amp;attribute, guint32 value, FileQueryInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_int32</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab0290ecba7b06ccf7736e2292708667e</anchor>
      <arglist>(const std::string &amp;attribute, gint32 value, FileQueryInfoFlags flags, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_int32</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4a707084a3c0a963548a21d17d0ec0b5</anchor>
      <arglist>(const std::string &amp;attribute, gint32 value, FileQueryInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_uint64</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a48638081fd7af772a39af59a558b17f7</anchor>
      <arglist>(const std::string &amp;attribute, guint64 value, FileQueryInfoFlags flags, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_uint64</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4aa77b3580df88cfd3d7231af78155c7</anchor>
      <arglist>(const std::string &amp;attribute, guint64 value, FileQueryInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_int64</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a111d73a2d003e5a5a4c5f86c7c3d2fb7</anchor>
      <arglist>(const std::string &amp;attribute, gint64 value, FileQueryInfoFlags flags, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_int64</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4477b0063110951b26c855696ec34802</anchor>
      <arglist>(const std::string &amp;attribute, gint64 value, FileQueryInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount_enclosing_volume</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a144aa2de6b696da90a6baffbe959d732</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount_enclosing_volume</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a70fd22116d9c8682433c4bb8cbd764c1</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount_enclosing_volume</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a2172cdcdb683630b719c521bf00b1eb4</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount_enclosing_volume</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a20f8f18876102a5efaa0536bfa71d71c</anchor>
      <arglist>(MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>mount_enclosing_volume_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aefd44b1b3467bcc474b345ff98b4aa6d</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a40c88a403f5d01d722b5900545b6a4fe</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac3c29682ef5a50de73dc2c3c3333301c</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a049e06c3d95b49ad4bff1837ef6d8677</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a8501fa88f4aaa8d52c001596960a4572</anchor>
      <arglist>(MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>mount_mountable_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae15d36a7969c55122b9f85a1690a46e8</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5b687c8f19411e955bb069c469be92b4</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab6c8e9ef0e5d83a271c8307b18e779d8</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a95f3e87e198493f4332a08aa79f6ebd3</anchor>
      <arglist>(MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a13f7cceb9754a7498789593dd58d818c</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad82d5b087fef21cbadcb9407d7f43223</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae322b2d5f8f1d95023831c3964c9b015</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>unmount_mountable_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a51458cf04ad25e4a784a3ebcb906155d</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a8a8223e3b661f03c7a60ac0f003b916e</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad8422a939a634d2248ef6d8658f0fdad</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aeb28fd505cab23a82c68ff00445b12e7</anchor>
      <arglist>(MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a1c103886296fd1ea1107906deebec8a5</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab6c75952828023d27d109a3a23fafc00</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab7aea22f6cb30b3f2be43682ddd543d9</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>eject_mountable_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a6a5124de7c55e9dc5e85ffcb9d3dd14f</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>copy_attributes</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a90726dcf94248d2fddf2e4c8584b7bf0</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCopyFlags flags=FILE_COPY_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>copy_attributes</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a05c1101ede98028c9234486eb0434250</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, FileCopyFlags flags=FILE_COPY_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileMonitor &gt;</type>
      <name>monitor_directory</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aa0fa22ffba0ff50779e49ff9d12344e6</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileMonitorFlags flags=FILE_MONITOR_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileMonitor &gt;</type>
      <name>monitor_directory</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a12d36689c1024ff9fc8819f619910a92</anchor>
      <arglist>(FileMonitorFlags flags=FILE_MONITOR_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileMonitor &gt;</type>
      <name>monitor_file</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab8e14809f330ddd58e628c96921cd987</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileMonitorFlags flags=FILE_MONITOR_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileMonitor &gt;</type>
      <name>monitor_file</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aa410183ed3b4a745093383d038d271b9</anchor>
      <arglist>(FileMonitorFlags flags=FILE_MONITOR_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileMonitor &gt;</type>
      <name>monitor</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a88aacee7bb6f6d968b4383311a9dd002</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileMonitorFlags flags=FILE_MONITOR_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileMonitor &gt;</type>
      <name>monitor</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a50896969a9de87f810f0bf5e2d3335bd</anchor>
      <arglist>(FileMonitorFlags flags=FILE_MONITOR_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>measure_disk_usage</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a27d273c8119ef09426405e35f75e533e</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const SlotFileMeasureProgress &amp;slot_progress, guint64 &amp;disk_usage, guint64 &amp;num_dirs, guint64 &amp;num_files, FileMeasureFlags flags=FILE_MEASURE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>measure_disk_usage_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a85ebd8baacbbdf12f1b34fca92b4c8f2</anchor>
      <arglist>(const SlotAsyncReady &amp;slot_ready, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const SlotFileMeasureProgress &amp;slot_progress, FileMeasureFlags flags=FILE_MEASURE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>measure_disk_usage_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5463283f6a20c51d4db7943190350d26</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, guint64 &amp;disk_usage, guint64 &amp;num_dirs, guint64 &amp;num_files)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aa4438daeeb2171e3065bb677b6768721</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const Glib::RefPtr&lt; MountOperation &gt; &amp;start_operation, DriveStartFlags flags=DRIVE_START_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad629eaf059b2e05b1f9bfc10c5732974</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; MountOperation &gt; &amp;start_operation, DriveStartFlags flags=DRIVE_START_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>start_mountable_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af11e51943807876180474b39d2e521ac</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stop_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac101831f87245a881c338014f15d38d8</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const Glib::RefPtr&lt; MountOperation &gt; &amp;start_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stop_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5ccfb3006c2bc69a32e5055939b462d6</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; MountOperation &gt; &amp;start_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>stop_mountable_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a195990af8825745d0d26147174824565</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>poll_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a8e81dd0bab13e56ed98456f6a53591ca</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>poll_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a2025339de9d7ed9b62300cad1a8e8fd4</anchor>
      <arglist>(const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>poll_mountable_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a2da5ec13a4a32f229ca97cce8961e637</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; AppInfo &gt;</type>
      <name>query_default_handler</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a753546465735b25633b003333b66d05c</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; AppInfo &gt;</type>
      <name>query_default_handler</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a0c0fd0ece2570b6704889df5ee43c283</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_contents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac53be228d732b34e062a2a57814cdf15</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, char *&amp;contents, gsize &amp;length, std::string &amp;etag_out)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_contents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ada7c826a417f88b405244c8dc39ae1ef</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, char *&amp;contents, gsize &amp;length)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_contents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a77f7781b0ba65bc4e7e613b80b353fd7</anchor>
      <arglist>(char *&amp;contents, gsize &amp;length, std::string &amp;etag_out)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_contents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a40f3ce7cf905144bac7218f9988d2d35</anchor>
      <arglist>(char *&amp;contents, gsize &amp;length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>load_contents_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad0e02ebffbaa13036e4636d2118f71a0</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>load_contents_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a6af7ec98d5543bce07b917b65d7276ce</anchor>
      <arglist>(const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_contents_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5fd15277ab90bcc57db088be04cac457</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, char *&amp;contents, gsize &amp;length, std::string &amp;etag_out)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_contents_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aee93c7e24e8391615f9f263584fb02bd</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, char *&amp;contents, gsize &amp;length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>load_partial_contents_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a0e8d95fcdf7c2aa38f54e90a22d3ab6f</anchor>
      <arglist>(const SlotReadMore &amp;slot_read_more, const SlotAsyncReady &amp;slot_async_ready, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>load_partial_contents_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a362d71932c0ba8797a8c47b77df1b6d7</anchor>
      <arglist>(const SlotReadMore &amp;slot_read_more, const SlotAsyncReady &amp;slot_async_ready)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_partial_contents_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4b323508401d2e6fd2b3ad659f9bb5eb</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, char *&amp;contents, gsize &amp;length, std::string &amp;etag_out)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_partial_contents_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae3a59c3831feeadea9bd0709617d2db9</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, char *&amp;contents, gsize &amp;length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af10deca1d5c5d1f650d3b182624330dc</anchor>
      <arglist>(const char *contents, gsize length, const std::string &amp;etag, std::string &amp;new_etag, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae7febf1f0f3b4b9efca9fae469082846</anchor>
      <arglist>(const char *contents, gsize length, const std::string &amp;etag, std::string &amp;new_etag, bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a23126b43cd262b63c0e458c3a4d0b65c</anchor>
      <arglist>(const std::string &amp;contents, const std::string &amp;etag, std::string &amp;new_etag, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aaf33a17461ff4f70fed06818e364f617</anchor>
      <arglist>(const std::string &amp;contents, const std::string &amp;etag, std::string &amp;new_etag, bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad33b24a7942429157f47379f4353378c</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const char *contents, gsize length, const std::string &amp;etag, bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a9a1c445e84124e16294974a73f2f1bbb</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const char *contents, gsize length, const std::string &amp;etag, bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a380d6ce6362fc05e0e18ff1b881ceac7</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;contents, const std::string &amp;etag, bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a6fc86aab90620881899a701c2b2775cb</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;contents, const std::string &amp;etag, bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>afbe0e644bafcb88ce52b62de803167cd</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, std::string &amp;new_etag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af0372ffd3f535f39b7e48c0483e4c1f4</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>supports_thread_contexts</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab666a9ec3922903646504f4080758522</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aa9352e68c93431dd16b8ac587703772f</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a9a1cbe348685c278bb7df93ee8018442</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; File &gt;</type>
      <name>create_for_path</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a1b1a4553b226689d50b9525488223e25</anchor>
      <arglist>(const std::string &amp;path)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; File &gt;</type>
      <name>create_for_uri</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a412b6b55f37f69bd4fb8fbd24d4967be</anchor>
      <arglist>(const std::string &amp;uri)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; File &gt;</type>
      <name>create_for_commandline_arg</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab311a1c606b3907865fc8aecd4691de8</anchor>
      <arglist>(const std::string &amp;arg)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; File &gt;</type>
      <name>create_for_parse_name</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a7532baa6ce71fe27cfd1e9bba91a3536</anchor>
      <arglist>(const Glib::ustring &amp;parse_name)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>File</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>abb3b1f0b8e19505b34ae084c518d20fc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::File &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a69670cdc7cf63783d6f9370dcbd7cc3d</anchor>
      <arglist>(GFile *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileAttributeInfo</name>
    <filename>classGio_1_1FileAttributeInfo.html</filename>
    <member kind="function">
      <type></type>
      <name>FileAttributeInfo</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>a5e4777c01a420d7265f4ccd8ed230189</anchor>
      <arglist>(const GFileAttributeInfo *ginfo)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FileAttributeInfo</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>aa290f394f7f34b5b7ba9dbb7453ae792</anchor>
      <arglist>(const FileAttributeInfo &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfo &amp;</type>
      <name>operator=</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>a19efa84d8e3f28299a2b89f86c9c7730</anchor>
      <arglist>(const FileAttributeInfo &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~FileAttributeInfo</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>af7057435f526fc718c2be147d0df5b79</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_name</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>ae2775dbf3905b88f52aee3828819792d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>FileAttributeType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>a113f8e990486cf35c33d4963342483f0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>get_flags</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>af3e06df4bf2d01ed2f1ff763c7ae01f9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::string</type>
      <name>m_name</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>ab3ac15f750d21ddb4f6c7cd3240f8e03</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>FileAttributeType</type>
      <name>m_type</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>abd2c79feb25a7adc6b9806d6b75d8c9e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>FileAttributeInfoFlags</type>
      <name>m_flags</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>a0b17e6847bad0bab1d90b7a3025e7dbf</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileAttributeInfoList</name>
    <filename>classGio_1_1FileAttributeInfoList.html</filename>
    <member kind="function">
      <type>void</type>
      <name>reference</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a1dd9c6baf89e1254fbed44338eb0a4a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unreference</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a889a9813bba642c384b9b2d05bae0823</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileAttributeInfoList *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a8aba8445408cbf56722946723e6919a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileAttributeInfoList *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a030d5b7ddafbfa9e1b15d92254530203</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileAttributeInfoList *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a2339b9d0f1a13935e58bfd1a2210cdb8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator bool</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>ae30d388537b163f12846afa47638e7be</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>empty</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a7584d4757d8ff2cab6dbc3bb1d28da94</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfo</type>
      <name>lookup</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a821a7de06545be2c6e18d7a53c5770eb</anchor>
      <arglist>(const std::string &amp;name) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileAttributeInfoList &gt;</type>
      <name>dup</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a4253d86702cb4b18859e7ba06cb7e1fc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>aed2f07a9ff6a250c3b8fa06324765c2f</anchor>
      <arglist>(const std::string &amp;name, FileAttributeType type, FileAttributeInfoFlags flags=FILE_ATTRIBUTE_INFO_NONE)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; FileAttributeInfoList &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a0a0d066b1b2e3a0a533895922ff4c14a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>FileAttributeInfoList</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>af647ecbd4ab360b48deae74066993251</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>operator delete</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a2acc6b621f0bb5aab208dceac9b353c2</anchor>
      <arglist>(void *, std::size_t)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileAttributeInfoList &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a7f7b3ffb2c6258de375ee4cc566c0089</anchor>
      <arglist>(GFileAttributeInfoList *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileAttributeMatcher</name>
    <filename>classGio_1_1FileAttributeMatcher.html</filename>
    <member kind="function">
      <type>void</type>
      <name>reference</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>af9f21d4f8a594676e747583cbc3ad61b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unreference</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a9e66e5a86c52725b6bd4f16781229775</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileAttributeMatcher *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a34cf74569abe9a13c4412bf8f2347747</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileAttributeMatcher *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a5e217b69f70586991b2ef272746aa7a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileAttributeMatcher *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a35f18b4eb01427687fb0fe4f74dc0316</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileAttributeMatcher &gt;</type>
      <name>create_difference</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a63ad723270b7edc416c06f76cf7fa251</anchor>
      <arglist>(const Glib::RefPtr&lt; const FileAttributeMatcher &gt; &amp;subtract) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>matches</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a76b65df7c7a64dd418f4a04a55af22a7</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>matches_only</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a22402c55977fefbfc113eceb56029e6e</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>enumerate_namespace</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>ac0edeabc8f07048f8bb2ba96d84983b8</anchor>
      <arglist>(const std::string &amp;ns)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>enumerate_next</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a18103e91422814f576ff4b339bb085da</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>to_string</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>af914c8e862a49796498e3403367f36bf</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; FileAttributeMatcher &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a47b85316b6b6ce30841895ae6ef4f498</anchor>
      <arglist>(const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>FileAttributeMatcher</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>ae91e6b65ca5bb2c635f5bdf9cba56ed7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>operator delete</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a7bd99c437bf29680182cce3410094c96</anchor>
      <arglist>(void *, std::size_t)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileAttributeMatcher &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a55c8ef1a5445afd09cc530d7c4945b7b</anchor>
      <arglist>(GFileAttributeMatcher *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileEnumerator</name>
    <filename>classGio_1_1FileEnumerator.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FileEnumerator</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>aa67510ecc9ddfbb3ef6f1d7ad560ca3f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFileEnumerator *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a7c4e1d7258796a85d5b473e08168bd8c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileEnumerator *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>aa54f2d24a93f78b20fa9c33913c862fd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileEnumerator *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>ac744c1c54800fb3764ea6ce5546f7937</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>next_file</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a73b5814cb108be591316cedabe362800</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>next_file</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a881873317d4a608d06405b3da3940e5a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a731c5e104949ecd082bcd6a2ada25641</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>ad3729d377a08f39e3f4fc44d5c37409f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>next_files_async</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a78de4d8a6a97cc68fc236a69a730f033</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int num_files=1, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>next_files_async</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>ad51d86fbf6ebef0aed7f4321e1df6e79</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, int num_files=1, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::RefPtr&lt; FileInfo &gt; &gt;</type>
      <name>next_files_finish</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>ab012d7f4428713efadbd10571f314973</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_async</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a0c878331956c2b28d749f561dbf84287</anchor>
      <arglist>(int io_priority, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_async</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>aab848a136da3b0880f23e9084544e4ae</anchor>
      <arglist>(int io_priority, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close_finish</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a8f87519e9368a1db2399c24649976057</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_closed</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a3908b180f25ff93b1cb6cb86945981a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_pending</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a3e1fb2fb2a8f8916929506828ded33b8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_pending</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a666470d02974350df0ed75f94321eaae</anchor>
      <arglist>(bool pending=true)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>get_container</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a3ad9348edd27ff536e61ee6b87b0fd23</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const File &gt;</type>
      <name>get_container</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a639025c665bfef49b88902d16b889ec9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>get_child</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a79ee27e734fe2a3af2c376fc95ea4f24</anchor>
      <arglist>(const Glib::RefPtr&lt; FileInfo &gt; &amp;info)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const File &gt;</type>
      <name>get_child</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a8f04643d50ec0631c209670e3e423e2a</anchor>
      <arglist>(const Glib::RefPtr&lt; FileInfo &gt; &amp;info) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>afe99ce463bfe6cc0f0c6fc209def5d53</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileEnumerator &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>aba2d802d7865e00771c69e44da54318a</anchor>
      <arglist>(GFileEnumerator *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileIcon</name>
    <filename>classGio_1_1FileIcon.html</filename>
    <base>Glib::Object</base>
    <base>Gio::LoadableIcon</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FileIcon</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>a9e9ac46fa3312d274c8de2155a5343fe</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFileIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>a0461feec986f30a389d7db0bfbc55673</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>a018eb170dea43e7bf697baa73070e195</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileIcon *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>ac56c21ee2b4cc36ba9b6d177fdc184a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>get_file</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>a91c091a48d9acadf0fa4ba5817459b8d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const File &gt;</type>
      <name>get_file</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>ad5414529acfb5cd8e118d8ce6cab676d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; File &gt; &gt;</type>
      <name>property_file</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>ae18890d04a8347df36be91dccb18e668</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LoadableIcon</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>ac1a01de0d91f26e45babaea521a982a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GLoadableIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>aa590b3b76843c19f5dbf51448f30e9f7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GLoadableIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>a50a6f22519524e14d36d070cd2cb1c89</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; InputStream &gt;</type>
      <name>load</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>af92f75fd1b6d4284e169c199a2c6b8c3</anchor>
      <arglist>(int size, Glib::ustring &amp;type, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; InputStream &gt;</type>
      <name>load</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>acd3a877867f4ca2cbf5b1a5b059e2eb6</anchor>
      <arglist>(int size, Glib::ustring &amp;type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>load_async</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>a0218104cdd576b7dde4846de9b997e41</anchor>
      <arglist>(int size, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>load_async</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>a3e2f5cf5ef217e53e6dfcbd83cc553e1</anchor>
      <arglist>(int size, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>a310571260d16ddc97ab0b4bc9e47a1b2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; FileIcon &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>a09c67bb60019f8a14015d55ebfb89e25</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>aac15ee4e49c92f2822760cc774f908d8</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>a73e373810087a0e2d13e47ab47c822c2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>FileIcon</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>a2637e26120b3abc4711be125e212a72b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>LoadableIcon</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>a6ace9bdbe5a19a4a488ad8d6ffb0e06e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileIcon &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>a211fbcdf28b3b87440c75b2c1a0212dd</anchor>
      <arglist>(GFileIcon *object, bool take_copy=false)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::LoadableIcon &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>afa55d29b9394247f8824820bb92e8e6b</anchor>
      <arglist>(GLoadableIcon *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileInfo</name>
    <filename>classGio_1_1FileInfo.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FileInfo</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>aaa6efce7f09cab1619475b27860a72cd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFileInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ae03eb9c62254cc8581e3ec757f8d98a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a631bcd07a3ae085260e7b3358444dd4a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileInfo *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a4c85d7a363f3925102ae03442472ac7d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FileInfo</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a740057465d0744299ef0f118b7efe083</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>dup</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a15f9fc3eeafd0fa4e90d51d22781be99</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy_into</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a10d6651e6544788abac1e1f5da55bdc1</anchor>
      <arglist>(Glib::RefPtr&lt; FileInfo &gt; &amp;dest_info) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_attribute</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>aa18458a7c75729d9521b3b0988bb9322</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_namespace</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>afb1ee0d2a0b6ca3284ae30639a495d34</anchor>
      <arglist>(const std::string &amp;name_space) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>list_attributes</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a784a82a76bd8a10d16e6e78d311a8cae</anchor>
      <arglist>(const std::string &amp;name_space) const </arglist>
    </member>
    <member kind="function">
      <type>FileAttributeType</type>
      <name>get_attribute_type</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ad9dfbef62139e9ea6d259d4bbe6b8b92</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_attribute</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ab36ffcf14c535c7fbbbb94907a3516c9</anchor>
      <arglist>(const std::string &amp;attribute)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeStatus</type>
      <name>get_attribute_status</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a55734d4049747825f04006145f8cd891</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_attribute_string</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>aad2362ace81fdccc95eed6cf4e84af41</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Glib::ustring &gt;</type>
      <name>get_attribute_strings</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a60775e746c94f56e37ad4659c4a5c790</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_attribute_as_string</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a75ee20462c4f2dc2c696611427a98d8c</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_attribute_byte_string</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a4803fb91a2fd7a754f030b63962b2bef</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_attribute_boolean</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a167589bb3e2fa091d7717abe6405fd9a</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>guint32</type>
      <name>get_attribute_uint32</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a4f84f3668092ae12b0f89f3ff985e9b4</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>gint32</type>
      <name>get_attribute_int32</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ad450ccf254244a053c11b14e88695c2f</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>guint64</type>
      <name>get_attribute_uint64</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a382b0afbec9d9ba59e7fbb7cbe5fc5a5</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>gint64</type>
      <name>get_attribute_int64</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>aeb52d13f7ad792ca3cfa527a85b89809</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Glib::Object &gt;</type>
      <name>get_attribute_object</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a6211b572545a437f9691297cf439d394</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_status</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a23be459ab17337e7ce3bf595d1c49caa</anchor>
      <arglist>(const std::string &amp;attribute, FileAttributeStatus status)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_string</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a1e606f4da36965161e1dca33cca4d356</anchor>
      <arglist>(const std::string &amp;attribute, const std::string &amp;attr_value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_strings</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a7ca4e0eff88cb39997d062bb87c1a7e8</anchor>
      <arglist>(const std::string &amp;attribute, const std::vector&lt; Glib::ustring &gt; &amp;attr_value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_byte_string</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a76af54b7bff8fb2059a24fe421fd695f</anchor>
      <arglist>(const std::string &amp;attribute, const std::string &amp;attr_value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_boolean</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>aac9c93946c7e7fd05404763f6b4fc768</anchor>
      <arglist>(const std::string &amp;attribute, bool attr_value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_uint32</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>acae23c362ceb3a9df2f0b4355a34c805</anchor>
      <arglist>(const std::string &amp;attribute, guint32 attr_value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_int32</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a179852aee069dcaa0b038067947fdb18</anchor>
      <arglist>(const std::string &amp;attribute, gint32 attr_value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_uint64</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>aa8116dd0baf75878247290ab382ba71e</anchor>
      <arglist>(const std::string &amp;attribute, guint64 attr_value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_int64</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>afd81b823003ec5dd86fbaaec3486c52f</anchor>
      <arglist>(const std::string &amp;attribute, gint64 attr_value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_object</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a8731a890f534730d780ba92b3407844e</anchor>
      <arglist>(const std::string &amp;attribute, const Glib::RefPtr&lt; Glib::Object &gt; &amp;attr_value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear_status</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ac00eda5b1db8e5c7d3a756a43efe47fb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::DateTime</type>
      <name>get_deletion_date</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ab33f0f1073b1408c3bea9d20a8bf6f14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>FileType</type>
      <name>get_file_type</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>abf62545b515bef26ead386be87750edb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_hidden</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a58ec7193682510c1455a6547fcabddb4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_backup</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a0e782dc65b4a048628c35af89bc2b894</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_symlink</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a7a7ef1e79deefd16be5fcea5ed00e6d5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_name</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a2a237a251dce16850d2365f246e48e4e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_display_name</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>aab26e342861a38ea9cfcd8b52813d655</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_edit_name</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a92f5240ac06f5848072e2f43aeb71516</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ad835c26e3252232a437d1013a5ed9aa3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>afa956e081955525b68c5af3f291b7b8c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>get_symbolic_icon</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>acb525fe0c1cb6b91483b7df5c37b5062</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Icon &gt;</type>
      <name>get_symbolic_icon</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a7f6058c4419384140c439fed14815f4a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_content_type</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>aa67a68ee61c7b43f2051cf8639966e75</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>goffset</type>
      <name>get_size</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a298f0414de960d56bb5a2bcd951f4900</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::TimeVal</type>
      <name>modification_time</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a0bb8836539f5a2f4fe61c07e335110c9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_symlink_target</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a848a2f85fa4f84c6477e076987d28770</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_etag</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>aaa44913ffe15c029ce09dfe828cf0a0b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>gint32</type>
      <name>get_sort_order</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a6527af61c645715e24863592246545b3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_mask</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>add9025ae3f25e5213ab8fba055a4e09d</anchor>
      <arglist>(const Glib::RefPtr&lt; FileAttributeMatcher &gt; &amp;mask)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unset_attribute_mask</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>afb9178c888fbf6fd2ef1344bc8523ba3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_file_type</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ab3ceaaaf6112575fd1b9cd6c75112606</anchor>
      <arglist>(FileType type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_is_hidden</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>af817a5e2d32a2a7d0130c53e4bb3ca72</anchor>
      <arglist>(bool is_hidden=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_is_symlink</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a79304bdfa1e1e5e73f895c896ddf730e</anchor>
      <arglist>(bool is_symlink=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_name</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>af2430c30058f424bbc71c342fd2e9cda</anchor>
      <arglist>(const std::string &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_display_name</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a6c0171f42d0877023cfe574b77359b59</anchor>
      <arglist>(const std::string &amp;display_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_edit_name</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a0aec971ea570c1946b8e57462e1bc9ce</anchor>
      <arglist>(const std::string &amp;edit_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_icon</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a3bd4ac6face055102cd02c679056a16a</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_symbolic_icon</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a166b0739038a29aca63bc3dbf750a303</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_content_type</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a1a07b5776ff1a1a8ed8d942710df5688</anchor>
      <arglist>(const std::string &amp;content_type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_size</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ac50fe95ac1dd596d44cd40225af223f5</anchor>
      <arglist>(goffset size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_modification_time</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a999893faef31be8d0989415852ec527e</anchor>
      <arglist>(const Glib::TimeVal &amp;mtime)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_symlink_target</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>af0ca88a17c88c40b58890a68278528c4</anchor>
      <arglist>(const std::string &amp;symlink_target)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_sort_order</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>afec884c7bd2f655c7a3fe0122dfb4390</anchor>
      <arglist>(gint32 sort_order)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a60db6778f3f1cb3db54e6e58a184b9e5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileInfo &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>aa08fd4d65078c227da321348eed9519d</anchor>
      <arglist>(GFileInfo *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileInputStream</name>
    <filename>classGio_1_1FileInputStream.html</filename>
    <base>Gio::InputStream</base>
    <base>Gio::Seekable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FileInputStream</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>a8039942e23f7821a67f7d1003b486b73</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFileInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>a5411e06810e06ad339d7a21257772219</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>ab1afea7b758100ca02a6aa5b89d57662</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileInputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>aa35ad981b6f18b1e5ece395970c5991b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>ae9cf87761484839f4ea53bc33064f189</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>a6ff4fe91f63b1eb38cca93591ba1f263</anchor>
      <arglist>(const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_info_async</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>a50c9554cfa15b88a1d30c7719569cc5f</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_info_async</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>a21f82f427ab1e958308889b78308dcdf</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;attributes=&quot;*&quot;, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info_finish</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>a1c8e42e09d92c59b05d122eead3e3161</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Seekable</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>a9b3fcb7df7b3e63b737e5bc5c7e74271</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSeekable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>a96176a5c51102b9a2d02f4555f2e048f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSeekable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>ac60caf803ddd50d08115da50ccb149dd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>goffset</type>
      <name>tell</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>a3f270a74f487712bb0a89d86a8313987</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_seek</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>a5dd0a134172ea72595a9c7b2072e0350</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>seek</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>aa717d10e2322df67b488657add79c70b</anchor>
      <arglist>(goffset offset, Glib::SeekType type, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>seek</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>a3404742af5d7855f6017578091f432cc</anchor>
      <arglist>(goffset offset, Glib::SeekType type)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_truncate</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>a961a029a8498e9223ed9c136cfe14597</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>truncate</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>aaf0792e6281670ea411cd7c3ef981998</anchor>
      <arglist>(goffset offset, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>truncate</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>a4458c08f1486ce89f8a7f9b49f10eb13</anchor>
      <arglist>(goffset offset)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>a396cc408fb62a174563a21f7120321e6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>ae8a94d31313527ff431cf49ba5af2bd8</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>a7abea7847823d4c93e35481d657f7978</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileInputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>aa3ca60bf8d52cd8c7d2688e58d634a36</anchor>
      <arglist>(GFileInputStream *object, bool take_copy=false)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Seekable &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>a0756ddeb91dc62f76d8a380716ecd228</anchor>
      <arglist>(GSeekable *object, bool take_copy=false)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Seekable</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>a9601b59f26a240348bd70ec68b1c4f1f</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileIOStream</name>
    <filename>classGio_1_1FileIOStream.html</filename>
    <base>Gio::IOStream</base>
    <base>Gio::Seekable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FileIOStream</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>a7b412e59741edea22ef424786aa2665a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFileIOStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>a382fe1830e5e347db4ae0d941398c0df</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileIOStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>acd384df600b1aea26bd10ca2e74f1b21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileIOStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>a2661e78434e66d48a54aa67ddd4d4e53</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>a11c3696bd12879c7554a8be1246ca069</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>a1c4cefdd3b2ff134f01ecbc7a4439921</anchor>
      <arglist>(const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_info_async</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>ae83afafd7a40cc116026af5452c26151</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_info_async</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>aeafe3bd19e6cf993dd7a2bb4e27ebd4d</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;attributes=&quot;*&quot;, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info_finish</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>a9838bea653f37c9ff298e16a96ce11dd</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_etag</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>a98607843697e850776bd6736a93df4d5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~IOStream</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a1257d3a0df6edf25cf1088e4be7144e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GIOStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a6e8d13f8095555cecbe0d59f1542893f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GIOStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a94eb81fa811399ece0ef743cd9d178ae</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GIOStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a632594c5b02e0311448e79f6d495c65a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>splice_async</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a43e681134d2fd80d3c88ebc79fae1eae</anchor>
      <arglist>(const Glib::RefPtr&lt; IOStream &gt; &amp;stream2, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, IOStreamSpliceFlags flags=Gio::IO_STREAM_SPLICE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>splice_async</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>ad883aab2d96422b0916befd71b73616e</anchor>
      <arglist>(const Glib::RefPtr&lt; IOStream &gt; &amp;stream2, const SlotAsyncReady &amp;slot, IOStreamSpliceFlags flags=Gio::IO_STREAM_SPLICE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; InputStream &gt;</type>
      <name>get_input_stream</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>afab74f0f339afb505556f6cb8b8c2b45</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; OutputStream &gt;</type>
      <name>get_output_stream</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>acdea8fc29d817070fa9cca124f398930</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>ae22ea1e4e3cd6db48b5e012f35a2306d</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a7d9c63eb525827d27f897d6823f719a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_async</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a289fe0ef58e44117952a2e01985afdd7</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_async</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a41451e389068b3a61245b43695186ee6</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close_finish</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a205a044f155178460336bd6efd05554c</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_closed</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a32d887d5d205566fe1cdfd0bf4176a8d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_pending</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>afecb3079c5a4adf9fe186b4a44923da3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_pending</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a7217e0c7ef1659a8b293a81e5b2e95e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear_pending</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>ac15dc0ec5596a9bb5ee174ea70a2b59d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>a52a9e11a62ca45bfb8b7bd5117d5f069</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>afc95fae98d93047a351166770a19732e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>splice_finish</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a75fe59f3909d44e704dbc6684e0b368e</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileIOStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>a44679bcc0dadcf0eb3bf2691e51e7e98</anchor>
      <arglist>(GFileIOStream *object, bool take_copy=false)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::IOStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a13101385680c3857e7027d78e1f6259a</anchor>
      <arglist>(GIOStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileMonitor</name>
    <filename>classGio_1_1FileMonitor.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FileMonitor</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a6ffb078bc2ce7e7c4dde4c5731fa1f08</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFileMonitor *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a047a5032cf7905ecc37c6379e8c82f35</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileMonitor *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a3930ab1dd57d0ec9341edf13bd62712f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileMonitor *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a989efd770a3a68bc77f1917751feec9e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>cancel</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>ab6bdfc13b4a27521304c9be8aedec677</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_cancelled</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>ae5ebb0182704c6ea8314c6f0a6106fad</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_rate_limit</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a47b6ca4693b67efead6c8dde6d526b31</anchor>
      <arglist>(int limit_msecs)</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy3&lt; void, const Glib::RefPtr&lt; File &gt; &amp;, const Glib::RefPtr&lt; File &gt; &amp;, FileMonitorEvent &gt;</type>
      <name>signal_changed</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a36215dcf2bf7a9476284f419f163aad9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; int &gt;</type>
      <name>property_rate_limit</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a0256afa44438302c92d8d2eecb7650f5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_rate_limit</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a0c6412fbd7ce9a054f98bb39e3d58d69</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_cancelled</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a0a7c3b0600b9fd8ab9267b7ec3f1a8ec</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a3ffca53a4e82649f8d9e2d91aced6ae2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_changed</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a42c6d3679e90ad17504d3c0a5937da7c</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;file, const Glib::RefPtr&lt; File &gt; &amp;other_file, FileMonitorEvent event_type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileMonitor &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a5ad2474eedfd1ae12f2c75003e6f26fe</anchor>
      <arglist>(GFileMonitor *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FilenameCompleter</name>
    <filename>classGio_1_1FilenameCompleter.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FilenameCompleter</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>ad72f983849b2ba03e2ef98868b56b27f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFilenameCompleter *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>a6fa2ba7f28935b557fac0dfe965fe916</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFilenameCompleter *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>a0a627a9eac4a916e93f94bc4e7bc0d25</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFilenameCompleter *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>ae069b04fba4a9fff00023476772a7b5b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_completion_suffix</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>ac881f6320fb90d70afa0a5a86a38db11</anchor>
      <arglist>(const std::string &amp;initial_text) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>get_completions</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>aa56775c73bc3d1bd5a9749926d8a7134</anchor>
      <arglist>(const std::string &amp;initial_text) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_dirs_only</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>abe7160d315c69ed35cdd5e1a25cf06bc</anchor>
      <arglist>(bool dirs_only=true)</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_got_completion_data</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>a3acc6e4468f03d924b9efae217b49e70</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>a139fce914a636a7f8f8f962b71519bd5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; FilenameCompleter &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>aeb7c3042c2f76a62f6806921bef56e89</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>FilenameCompleter</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>a1db98397daf75605c3a827f646ea98ff</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_got_completion_data</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>a092cefc4a3cbeff19f60ef75ebfc8b87</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FilenameCompleter &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>ad03881744458e4aa6308376f5aebd2b3</anchor>
      <arglist>(GFilenameCompleter *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileOutputStream</name>
    <filename>classGio_1_1FileOutputStream.html</filename>
    <base>Gio::OutputStream</base>
    <base>Gio::Seekable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FileOutputStream</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>ad441ab4039675535b59c65b4c5d14804</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFileOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>aa69b1c94c5a3a2e0002fc6cf5127fc70</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>a2bf847a5064b01e671731ecd56f88968</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileOutputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>af536865a9ed17c3093ab67465fba908b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>a660a0130611aad21965a3f74c2fe90cd</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>a9b67d7fa0b9309ca42dea8607d2ef3d5</anchor>
      <arglist>(const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_info_async</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>a926ddca8782aeb271560a058ee6554aa</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_info_async</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>aa9297d379f28510afd0d5dabba65a447</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;attributes=&quot;*&quot;, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info_finish</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>aff73b62f94cc0be14f8271480aab6299</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_etag</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>a8e29de4e67428a79b41180ca27af0a3d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>a94ffbc5e9da9b3ed5939ef645c6ecaf3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileOutputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>a5fe0a7a8069a65b4a83b36f3a54b3142</anchor>
      <arglist>(GFileOutputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FilterInputStream</name>
    <filename>classGio_1_1FilterInputStream.html</filename>
    <base>Gio::InputStream</base>
  </compound>
  <compound kind="class">
    <name>Gio::FilterOutputStream</name>
    <filename>classGio_1_1FilterOutputStream.html</filename>
    <base>Gio::OutputStream</base>
  </compound>
  <compound kind="class">
    <name>Gio::Icon</name>
    <filename>classGio_1_1Icon.html</filename>
    <base>Glib::Interface</base>
  </compound>
  <compound kind="class">
    <name>Gio::InetAddress</name>
    <filename>classGio_1_1InetAddress.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~InetAddress</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a681469990ccd8829c9c56f2c21b987ff</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GInetAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a814cf259fbe2075145372ff8f041e2fd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GInetAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a02955cf2f6af819e6a33fae34f02a35d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GInetAddress *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>ac5740ac33a8c1507165bfb24ad05867b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>address_equal</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a58adc719a3aba1ecf236bc1c5671519b</anchor>
      <arglist>(const Glib::RefPtr&lt; const InetAddress &gt; &amp;other_address) const </arglist>
    </member>
    <member kind="function">
      <type>const guint8 *</type>
      <name>to_bytes</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a55511045dd96127a9e0c71277f6f09e9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>to_string</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>aad0c75db355f9202eb2d9abdfd62664f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SocketFamily</type>
      <name>get_family</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>aad520fbba41d5d4ff350c0e0b8aa8bd2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_any</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a195f40df5aa0a539d4199dd8c89b67ce</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_link_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>ae27877a353888bda5cc7d6ef439b6f43</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_loopback</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a123434ddbf161d5bd24bdd6e1a242042</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_mc_global</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a4bc588e6ceab049f81458d17a282a696</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_mc_link_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a0759e79028e0f3a967f21e9aa785708c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_mc_node_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a30fedd1ab379f61ad0d43822a7fbd414</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_mc_org_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a1933a994b55b0d3198187813aadabb8a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_mc_site_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>af50cbe1bd1fc064e37759026f60a2e78</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_multicast</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a1751ce4f0815d2bef25c789f6a7c2c51</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_site_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a6f18baee3fd0e8d4411ed6300e3f4ac9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>gsize</type>
      <name>get_native_size</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>aadfe97104f2bc53014fd70a2f1d8541e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; void * &gt;</type>
      <name>property_bytes</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a498624e86b5dc9be0554d96b70343a06</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; SocketFamily &gt;</type>
      <name>property_family</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a853b3ede13b8e413d9fadeb18d8f9312</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_is_any</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>ae262feee62f9a7f15f424293e2586e6d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_is_link_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a663100accf609aa42963d6e85592cc46</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_is_loopback</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a88079ac790bfae71e21c98b74707615e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_is_mc_global</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a0530df1e443b6445e102e6d4f42b91d0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_is_mc_link_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>aa5e6b8ef0115b29209e242fff08d1abb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_is_mc_node_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>ad2a49d7a3d52d93e0fd450af0c45e55c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_is_mc_org_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a83dbf0d6b192c8fb2975048cc1ade07c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_is_mc_site_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a47182934c2b9053a03652463bde5460a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_is_multicast</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a07b4ff79cfa83903f92686195f06be43</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_is_site_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>ab66f7bce19f9ac287a3d1f96781850c8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a5eff31035172897b0d396208bf80628a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; InetAddress &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>ad9a5b29ab4211c5e6d03d7630d1f352e</anchor>
      <arglist>(const Glib::ustring &amp;string)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; InetAddress &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>ab34823f20a1719d0d4dd0b8908791196</anchor>
      <arglist>(const guint8 *bytes, SocketFamily family)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; InetAddress &gt;</type>
      <name>create_any</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a801b964256dd4934f58db81626e6f42a</anchor>
      <arglist>(SocketFamily family)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; InetAddress &gt;</type>
      <name>create_loopback</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>af78181b11c10d9d698d9a49cfa2136ed</anchor>
      <arglist>(SocketFamily family)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>InetAddress</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>aeca7299962f7b75793c493ff32d91abe</anchor>
      <arglist>(const guint8 *bytes, SocketFamily family)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::InetAddress &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>ab8ed0814ec989e9c9b07332b19958a01</anchor>
      <arglist>(GInetAddress *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::InetSocketAddress</name>
    <filename>classGio_1_1InetSocketAddress.html</filename>
    <base>Gio::SocketAddress</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~InetSocketAddress</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a86c013c0d7971681b61da945543f1071</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GInetSocketAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a2185ff490fa658c11854df16c41910dc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GInetSocketAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>ad0a057e46b10504010e3e014d3207f4d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GInetSocketAddress *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a0d165726f19e26d3c03a184510b6df2b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; InetAddress &gt;</type>
      <name>get_address</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a28a044f52e94263559a50197d4ddfd6b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const InetAddress &gt;</type>
      <name>get_address</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a0ff00835b7a56e1df1c18aaa3d842bea</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint16</type>
      <name>get_port</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>ae9fc68c477f6ed7915befb4131f42f42</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint32</type>
      <name>get_flowinfo</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>afb05b6f4fa428c03add9d61ad1eb3759</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint32</type>
      <name>get_scope_id</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a69cacb60872dba627119331eec5891a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; InetAddress &gt; &gt;</type>
      <name>property_address</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a11ed0ddfae5e91401ff0e2a64c0e4486</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; guint16 &gt;</type>
      <name>property_port</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a5ecad6829b5196276c1a74c6c7b809db</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; guint32 &gt;</type>
      <name>property_flowinfo</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>af11b4b7c31be613196ac14f0f84a5908</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; guint32 &gt;</type>
      <name>property_scope_id</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>aae3b8151722538e72cb8d049a4f67ce3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SocketAddress</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>aeedceaf982ff7e7dc75d419022bafde1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSocketAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>a1f65b6f40eeb9a30eb613345be919eb6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSocketAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>aa2c5c7f04c127ad5037814f847ab2d6f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GSocketAddress *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>afe1a5b0091f024fa725ff31b88d01e7b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SocketFamily</type>
      <name>get_family</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>ab4fb1e63e629e88e5263e8bf5d095809</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>to_native</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>adec995b9e46746a5d55b3c5af592ec44</anchor>
      <arglist>(gpointer dest, gsize destlen)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>get_native_size</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>a25fd6c43478da2eef785467f75ba02ec</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; SocketFamily &gt; &gt;</type>
      <name>property_family</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>a8ee87873bc28121cd998dfb3fc4a954f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SocketConnectable</name>
      <anchorfile>classGio_1_1SocketConnectable.html</anchorfile>
      <anchor>a4cb889aad12cbcf04f6c64002f040226</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSocketConnectable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketConnectable.html</anchorfile>
      <anchor>a25988d9aeb115345500d09b282cf7023</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSocketConnectable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketConnectable.html</anchorfile>
      <anchor>a5ba8bd26578fa49ce4a6f8fbb544858c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketAddressEnumerator &gt;</type>
      <name>enumerate</name>
      <anchorfile>classGio_1_1SocketConnectable.html</anchorfile>
      <anchor>a52dcce3726042d15225accd1413689aa</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const SocketAddressEnumerator &gt;</type>
      <name>enumerate</name>
      <anchorfile>classGio_1_1SocketConnectable.html</anchorfile>
      <anchor>a92e199de3976f821f57ae50164d9d12f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketAddressEnumerator &gt;</type>
      <name>proxy_enumerate</name>
      <anchorfile>classGio_1_1SocketConnectable.html</anchorfile>
      <anchor>a65568f0bfff650e6de156ae270537e7f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const SocketAddressEnumerator &gt;</type>
      <name>proxy_enumerate</name>
      <anchorfile>classGio_1_1SocketConnectable.html</anchorfile>
      <anchor>ac3384042962373d745c6fe3c26575dd2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a7fe192f0c08e62a5460a8ee8918d0ba7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; InetSocketAddress &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a863fb8d260958e69d603e2903595a973</anchor>
      <arglist>(const Glib::RefPtr&lt; InetAddress &gt; &amp;address, guint16 port)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>a2efef6041d01dc632d1d044f0ca594ca</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; SocketAddress &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>a3d2233d8fc6b47668d38d4b450b5bae2</anchor>
      <arglist>(gpointer native, gsize len)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1SocketConnectable.html</anchorfile>
      <anchor>ac5522339bc623835f4a7245205d2ce5c</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1SocketConnectable.html</anchorfile>
      <anchor>a063b80662cd354812d298720ca33b5bd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>InetSocketAddress</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a54cf3e5885e7c14a26017ccdc5f552e8</anchor>
      <arglist>(const Glib::RefPtr&lt; InetAddress &gt; &amp;address, guint16 port)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SocketConnectable</name>
      <anchorfile>classGio_1_1SocketConnectable.html</anchorfile>
      <anchor>ac2ed148dfc1b3d946972498587baf43f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::InetSocketAddress &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a4498f65e8445567d4cacdc0a68437c33</anchor>
      <arglist>(GInetSocketAddress *object, bool take_copy=false)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::SocketAddress &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>adf0c2a59f4fc452b8b8e81f86ed1dc43</anchor>
      <arglist>(GSocketAddress *object, bool take_copy=false)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::SocketConnectable &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1SocketConnectable.html</anchorfile>
      <anchor>ad7c218506ae7370a57399d87d1ec1459</anchor>
      <arglist>(GSocketConnectable *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Initable</name>
    <filename>classGio_1_1Initable.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Initable</name>
      <anchorfile>classGio_1_1Initable.html</anchorfile>
      <anchor>aa4da38b665a33995bf28ad1838253b7e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GInitable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Initable.html</anchorfile>
      <anchor>a90206d58591c674e03c5de57623bac18</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GInitable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Initable.html</anchorfile>
      <anchor>a30665fda96b812e27231ec5abc47b789</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1Initable.html</anchorfile>
      <anchor>a6b68b1a2c2ab02ed1f25887c7acd121c</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1Initable.html</anchorfile>
      <anchor>a6a76f2678aa3641f7ded51813d9ead43</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Initable</name>
      <anchorfile>classGio_1_1Initable.html</anchorfile>
      <anchor>a239fb2aa148d653d534db5581d72c348</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>init</name>
      <anchorfile>classGio_1_1Initable.html</anchorfile>
      <anchor>a7dbee3b8e980bf52ae2a66e1523127a3</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>init</name>
      <anchorfile>classGio_1_1Initable.html</anchorfile>
      <anchor>a5881cf9c259d5af218585b7ecde38464</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>init_vfunc</name>
      <anchorfile>classGio_1_1Initable.html</anchorfile>
      <anchor>a53c86a53352ecda8bca80d5132e4e99c</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, GError **error)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Initable &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Initable.html</anchorfile>
      <anchor>a9a2f7929de61e6b32a2317fe0ebde865</anchor>
      <arglist>(GInitable *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::InputStream</name>
    <filename>classGio_1_1InputStream.html</filename>
    <base>Glib::Object</base>
  </compound>
  <compound kind="class">
    <name>Gio::IOStream</name>
    <filename>classGio_1_1IOStream.html</filename>
    <base>Glib::Object</base>
  </compound>
  <compound kind="class">
    <name>Gio::LoadableIcon</name>
    <filename>classGio_1_1LoadableIcon.html</filename>
    <base>Gio::Icon</base>
  </compound>
  <compound kind="class">
    <name>Gio::MemoryInputStream</name>
    <filename>classGio_1_1MemoryInputStream.html</filename>
    <base>Gio::InputStream</base>
    <base>Gio::Seekable</base>
    <member kind="typedef">
      <type>sigc::slot&lt; void, void * &gt;</type>
      <name>SlotDestroyData</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>aacbe29490dccd02251bf7d1f7d446865</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~MemoryInputStream</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>a73bc118fab39a89f4d8e8434ff951ba8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GMemoryInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>a076380153e01599446bd991e0985db69</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GMemoryInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>af9ea44af840fc0d29d460498c8ce7d0e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GMemoryInputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>af63cbdce2036e383cb7e77a7df83651c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_data</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>a483a0f4811f64a0a83204e22c227bf80</anchor>
      <arglist>(const std::string &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_data</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>a9700ab039b7d4654330f2786bd8786eb</anchor>
      <arglist>(const void *data, gssize len)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_data</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>aa26832ff7a8bce5cc15518d5a2f0a14b</anchor>
      <arglist>(const void *data, gssize len, GDestroyNotify destroy)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_data</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>a5afddef83fb3c506a55caa0130825268</anchor>
      <arglist>(const void *data, gssize len, const SlotDestroyData &amp;destroy_slot)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>a20b123ac1fc94d3b8c531cb28ec37add</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; MemoryInputStream &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>adb6e55009e51b59fa19dcd69617cfda1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>MemoryInputStream</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>a3878e7ba1b947b72a8ab835e2ff24473</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::MemoryInputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>a37bf0e5204e95253e4119ad954b3f7b9</anchor>
      <arglist>(GMemoryInputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::MemoryOutputStream</name>
    <filename>classGio_1_1MemoryOutputStream.html</filename>
    <base>Gio::OutputStream</base>
    <base>Gio::Seekable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~MemoryOutputStream</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>ad46729116d268fe1f8f540c692a43bf4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GMemoryOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>a3a52447ebfbc60722ced10d8aa625825</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GMemoryOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>a026181901b030a2f1f6e3b66026de5d3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GMemoryOutputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>aa6b728d48c0817347df70d41bd57708f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>get_data</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>af3260b7ddbda5b7eb0447de717c7fb67</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const void *</type>
      <name>get_data</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>aca7a0ae9773ee687a7edeb0d6372b243</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>steal_data</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>a35fc40bebe06f1b305795c9a44ba23f3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gsize</type>
      <name>get_size</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>ae8e5b9a0551bba70974c99cbb24a91e3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>gsize</type>
      <name>get_data_size</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>a7325ac59862190abfbbd8402ca7e7fe5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Glib::Bytes &gt;</type>
      <name>steal_as_bytes</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>a56d9ea009c1e3c0b3ecdfb87233d0c12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; void * &gt;</type>
      <name>property_data</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>ad780907d3e30090c0917a650957945f5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; gulong &gt;</type>
      <name>property_data_size</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>a0db1133c574625a11ed819fba1888045</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; gulong &gt;</type>
      <name>property_size</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>acd37162c359562c87c3ff8e87603f5b3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>a5394efb6174ba62c48fc04efd31f1271</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; MemoryOutputStream &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>a7348c98dc71c1ff04c404df77515011d</anchor>
      <arglist>(void *data, gsize size, GReallocFunc realloc_function, GDestroyNotify destroy_function)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>MemoryOutputStream</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>acdedb0b457edf81294061bef3289b9b4</anchor>
      <arglist>(void *data, gsize size, GReallocFunc realloc_function, GDestroyNotify destroy_function)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::MemoryOutputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>a294410b0d5c9b2d1a08dc9375338f187</anchor>
      <arglist>(GMemoryOutputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Menu</name>
    <filename>classGio_1_1Menu.html</filename>
    <base>Gio::MenuModel</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Menu</name>
      <anchorfile>classGio_1_1Menu.html</anchorfile>
      <anchor>ac60d492ee6dc790d4f33f065a939d422</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GMenu *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Menu.html</anchorfile>
      <anchor>a929f4a1d842ee720a52a3c0389154ccd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GMenu *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Menu.html</anchorfile>
      <anchor>afb37ba4b49b589e519ace5e7b29dd654</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GMenu *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1Menu.html</anchorfile>
      <anchor>a7e42abd72d5abdd822ce6a0256750f92</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>freeze</name>
      <anchorfile>classGio_1_1Menu.html</anchorfile>
      <anchor>a2368b3763316dc6644c6f55386feb7f4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert_item</name>
      <anchorfile>classGio_1_1Menu.html</anchorfile>
      <anchor>a4d7fa8eb14f059503a9ee130a306e555</anchor>
      <arglist>(int position, const Glib::RefPtr&lt; MenuItem &gt; &amp;item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>prepend_item</name>
      <anchorfile>classGio_1_1Menu.html</anchorfile>
      <anchor>a85a974793a615ed9188cefa6bebc1a12</anchor>
      <arglist>(const Glib::RefPtr&lt; MenuItem &gt; &amp;item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append_item</name>
      <anchorfile>classGio_1_1Menu.html</anchorfile>
      <anchor>ae633f3a93f25a8ad687da1b41863fac1</anchor>
      <arglist>(const Glib::RefPtr&lt; MenuItem &gt; &amp;item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classGio_1_1Menu.html</anchorfile>
      <anchor>a83a161993128b47345e86b227da5821e</anchor>
      <arglist>(int position)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_all</name>
      <anchorfile>classGio_1_1Menu.html</anchorfile>
      <anchor>a2b4cdc6c85bec137d17eddf92a09c9f3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classGio_1_1Menu.html</anchorfile>
      <anchor>a850db3f0691c4631c882853a235064ee</anchor>
      <arglist>(int position, const Glib::ustring &amp;label, const Glib::ustring &amp;detailed_action)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classGio_1_1Menu.html</anchorfile>
      <anchor>a47dddd4957d585bdb979d06f01930d33</anchor>
      <arglist>(int position, const Glib::ustring &amp;label)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>prepend</name>
      <anchorfile>classGio_1_1Menu.html</anchorfile>
      <anchor>ade54de0d1615c9a0099bca077c897c9b</anchor>
      <arglist>(const Glib::ustring &amp;label, const Glib::ustring &amp;detailed_action)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>prepend</name>
      <anchorfile>classGio_1_1Menu.html</anchorfile>
      <anchor>a3944b9916e55e508cede3204cc365b70</anchor>
      <arglist>(const Glib::ustring &amp;label)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classGio_1_1Menu.html</anchorfile>
      <anchor>a0cf7e95764bcd539f11aaae1820278be</anchor>
      <arglist>(const Glib::ustring &amp;label, const Glib::ustring &amp;detailed_action)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classGio_1_1Menu.html</anchorfile>
      <anchor>a16475a25c0b6fe6fe83a6beea1ce6f49</anchor>
      <arglist>(const Glib::ustring &amp;label)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert_section</name>
      <anchorfile>classGio_1_1Menu.html</anchorfile>
      <anchor>a2eba90ac2b9b7a0d5c1cf5cf4aea3109</anchor>
      <arglist>(int position, const Glib::ustring &amp;label, const Glib::RefPtr&lt; MenuModel &gt; &amp;section)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert_section</name>
      <anchorfile>classGio_1_1Menu.html</anchorfile>
      <anchor>a421da2fd681d904c52e5aec521577926</anchor>
      <arglist>(int position, const Glib::RefPtr&lt; MenuModel &gt; &amp;section)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>prepend_section</name>
      <anchorfile>classGio_1_1Menu.html</anchorfile>
      <anchor>abf9e550519559f64a8f9b07cdd13a932</anchor>
      <arglist>(const Glib::ustring &amp;label, const Glib::RefPtr&lt; MenuModel &gt; &amp;section)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>prepend_section</name>
      <anchorfile>classGio_1_1Menu.html</anchorfile>
      <anchor>a84e31163b2b09bc07946db08bcfc3043</anchor>
      <arglist>(const Glib::RefPtr&lt; MenuModel &gt; &amp;section)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append_section</name>
      <anchorfile>classGio_1_1Menu.html</anchorfile>
      <anchor>ab3fc029fff37abf97a46462c7c21412c</anchor>
      <arglist>(const Glib::ustring &amp;label, const Glib::RefPtr&lt; MenuModel &gt; &amp;section)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append_section</name>
      <anchorfile>classGio_1_1Menu.html</anchorfile>
      <anchor>a87c353b1713217ea39c1e7bc47ac0886</anchor>
      <arglist>(const Glib::RefPtr&lt; MenuModel &gt; &amp;section)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert_submenu</name>
      <anchorfile>classGio_1_1Menu.html</anchorfile>
      <anchor>a8f3ac0c4bc2c7101dae78a504b9e14ea</anchor>
      <arglist>(int position, const Glib::ustring &amp;label, const Glib::RefPtr&lt; MenuModel &gt; &amp;submenu)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>prepend_submenu</name>
      <anchorfile>classGio_1_1Menu.html</anchorfile>
      <anchor>a671400b0cfc1153966372b101aa543c1</anchor>
      <arglist>(const Glib::ustring &amp;label, const Glib::RefPtr&lt; MenuModel &gt; &amp;submenu)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append_submenu</name>
      <anchorfile>classGio_1_1Menu.html</anchorfile>
      <anchor>a895cbbba112cd0321fd3bac2314f5e19</anchor>
      <arglist>(const Glib::ustring &amp;label, const Glib::RefPtr&lt; MenuModel &gt; &amp;submenu)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~MenuModel</name>
      <anchorfile>classGio_1_1MenuModel.html</anchorfile>
      <anchor>aa50e7a927c5798cfa94d38a50b919c64</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GMenuModel *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MenuModel.html</anchorfile>
      <anchor>aa09ec8d56a76f646e7133b6dd2271ced</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GMenuModel *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MenuModel.html</anchorfile>
      <anchor>a5cdc6c658245ee2a22dcc10e1eb119ab</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GMenuModel *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1MenuModel.html</anchorfile>
      <anchor>ac75e5986055f0ec9cb56077cf533e44c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::VariantBase</type>
      <name>get_item_attribute</name>
      <anchorfile>classGio_1_1MenuModel.html</anchorfile>
      <anchor>a99090d7f9e7406e5bdc950f86b82f019</anchor>
      <arglist>(int item_index, MenuAttribute attribute, const Glib::VariantType &amp;expected_type)</arglist>
    </member>
    <member kind="function">
      <type>const Glib::VariantBase</type>
      <name>get_item_attribute</name>
      <anchorfile>classGio_1_1MenuModel.html</anchorfile>
      <anchor>a9083fb4bc22839eac9d82efd0a465501</anchor>
      <arglist>(int item_index, MenuAttribute attribute, const Glib::VariantType &amp;expected_type) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; MenuModel &gt;</type>
      <name>get_item_link</name>
      <anchorfile>classGio_1_1MenuModel.html</anchorfile>
      <anchor>aca233273e44374beeb579113560621b5</anchor>
      <arglist>(int item_index, MenuLink link)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const MenuModel &gt;</type>
      <name>get_item_link</name>
      <anchorfile>classGio_1_1MenuModel.html</anchorfile>
      <anchor>a559fc7a0480fc4b4df17e91e7a8f3bd5</anchor>
      <arglist>(int item_index, MenuLink link) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_mutable</name>
      <anchorfile>classGio_1_1MenuModel.html</anchorfile>
      <anchor>acbfed3821e834c151001fd0aaeebb398</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_n_items</name>
      <anchorfile>classGio_1_1MenuModel.html</anchorfile>
      <anchor>a2f6a0ebbc8a2c259887dbee8878c428f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; MenuAttributeIter &gt;</type>
      <name>iterate_item_attributes</name>
      <anchorfile>classGio_1_1MenuModel.html</anchorfile>
      <anchor>a074bfb4ed7c3b2a94000b62fdce6dfc0</anchor>
      <arglist>(int item_index)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const MenuAttributeIter &gt;</type>
      <name>iterate_item_attributes</name>
      <anchorfile>classGio_1_1MenuModel.html</anchorfile>
      <anchor>ababd702c0ecfe7f586256c366fb91f04</anchor>
      <arglist>(int item_index) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; MenuLinkIter &gt;</type>
      <name>iterate_item_links</name>
      <anchorfile>classGio_1_1MenuModel.html</anchorfile>
      <anchor>a5abda335e54302c4e8285c41bf201e51</anchor>
      <arglist>(int item_index)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const MenuLinkIter &gt;</type>
      <name>iterate_item_links</name>
      <anchorfile>classGio_1_1MenuModel.html</anchorfile>
      <anchor>a95599efdd50d47162a65a0d905f78fc7</anchor>
      <arglist>(int item_index) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>items_changed</name>
      <anchorfile>classGio_1_1MenuModel.html</anchorfile>
      <anchor>a0b0c42bcd34312965430750a2f56071a</anchor>
      <arglist>(int position, int removed, int added)</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy3&lt; void, int, int, int &gt;</type>
      <name>signal_items_changed</name>
      <anchorfile>classGio_1_1MenuModel.html</anchorfile>
      <anchor>af149b5e5c10b5038d7dd92ece3fa6032</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1Menu.html</anchorfile>
      <anchor>a30a99f90e82c94204304b808e40c3a14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Menu &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1Menu.html</anchorfile>
      <anchor>a5a1507929168dc50efbacae44af3ffb5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1MenuModel.html</anchorfile>
      <anchor>af19553f2244f8ad5a118751952b7a2b5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Menu</name>
      <anchorfile>classGio_1_1Menu.html</anchorfile>
      <anchor>aeb7862542979341cc01191b85726a826</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>MenuModel</name>
      <anchorfile>classGio_1_1MenuModel.html</anchorfile>
      <anchor>a4a58a5d7ed0e2dd3fcab1f110f8cb6a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Menu &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Menu.html</anchorfile>
      <anchor>a3aaa636051265b892b0c392699cb8a7e</anchor>
      <arglist>(GMenu *object, bool take_copy=false)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::MenuModel &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1MenuModel.html</anchorfile>
      <anchor>aeaa4856722c5a84b7f287e8900b43fdd</anchor>
      <arglist>(GMenuModel *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::MenuAttributeIter</name>
    <filename>classGio_1_1MenuAttributeIter.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~MenuAttributeIter</name>
      <anchorfile>classGio_1_1MenuAttributeIter.html</anchorfile>
      <anchor>a29c627c1eeae9f41cbdf185a3ca91616</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GMenuAttributeIter *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MenuAttributeIter.html</anchorfile>
      <anchor>ad26eb0bcf9fa13bdbda556678457cff9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GMenuAttributeIter *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MenuAttributeIter.html</anchorfile>
      <anchor>ac8642701c72e1350f5893a8a437f841b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GMenuAttributeIter *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1MenuAttributeIter.html</anchorfile>
      <anchor>a070bf7635add9b14980dc3f705d1bfd8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_next</name>
      <anchorfile>classGio_1_1MenuAttributeIter.html</anchorfile>
      <anchor>a809969cbb9da566e4d432cabb98e8597</anchor>
      <arglist>(Glib::ustring &amp;out_name, Glib::VariantBase &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_name</name>
      <anchorfile>classGio_1_1MenuAttributeIter.html</anchorfile>
      <anchor>adf71ba894c03e72fe0cd7672610e1986</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::VariantBase</type>
      <name>get_value</name>
      <anchorfile>classGio_1_1MenuAttributeIter.html</anchorfile>
      <anchor>a25cb8fd694f5c65c080bbc3405114d33</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Glib::VariantBase</type>
      <name>get_value</name>
      <anchorfile>classGio_1_1MenuAttributeIter.html</anchorfile>
      <anchor>a0a99cbd4b03378ca92e0c9609cc9cdce</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>next</name>
      <anchorfile>classGio_1_1MenuAttributeIter.html</anchorfile>
      <anchor>a698c1c012ae1c675a41d952469d794dc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1MenuAttributeIter.html</anchorfile>
      <anchor>a1ef59bc349ab7eb026f33885332e2b47</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>MenuAttributeIter</name>
      <anchorfile>classGio_1_1MenuAttributeIter.html</anchorfile>
      <anchor>a857040ab829ed6ab6fdc8869f78afe6c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::MenuAttributeIter &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1MenuAttributeIter.html</anchorfile>
      <anchor>acb20cc0c2e6df6f49884b0e74d8b559b</anchor>
      <arglist>(GMenuAttributeIter *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::MenuItem</name>
    <filename>classGio_1_1MenuItem.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~MenuItem</name>
      <anchorfile>classGio_1_1MenuItem.html</anchorfile>
      <anchor>afc66ae20e28e88d32a80542b88fed042</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GMenuItem *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MenuItem.html</anchorfile>
      <anchor>a12ca5edb28f3bf7516bfb45236db02d1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GMenuItem *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MenuItem.html</anchorfile>
      <anchor>a73d3e65e7ffadf5b7e19edc4b6894f08</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GMenuItem *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1MenuItem.html</anchorfile>
      <anchor>a6b214d265df9ef9a8452327fe79bae43</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_value</name>
      <anchorfile>classGio_1_1MenuItem.html</anchorfile>
      <anchor>aad911d89dbb48ac90f18e14faba2f3be</anchor>
      <arglist>(const Glib::ustring &amp;attribute, const Glib::VariantBase &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute</name>
      <anchorfile>classGio_1_1MenuItem.html</anchorfile>
      <anchor>a5af6c5ee37b8ef1218587434ae3cf1b6</anchor>
      <arglist>(const Glib::ustring &amp;attribute, const Glib::VariantBase &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; MenuModel &gt;</type>
      <name>get_link</name>
      <anchorfile>classGio_1_1MenuItem.html</anchorfile>
      <anchor>a8625449f52402411f9d7391340ae606d</anchor>
      <arglist>(const Glib::ustring &amp;link)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const MenuModel &gt;</type>
      <name>get_link</name>
      <anchorfile>classGio_1_1MenuItem.html</anchorfile>
      <anchor>ac96eb91687ba0d706b145493b942589a</anchor>
      <arglist>(const Glib::ustring &amp;link) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_link</name>
      <anchorfile>classGio_1_1MenuItem.html</anchorfile>
      <anchor>aaac02ded419000a186cfd376d65f9267</anchor>
      <arglist>(const Glib::ustring &amp;link, const Glib::RefPtr&lt; MenuModel &gt; &amp;model)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_label</name>
      <anchorfile>classGio_1_1MenuItem.html</anchorfile>
      <anchor>a92948a899a3ceab9bb8008b37128e63d</anchor>
      <arglist>(const Glib::ustring &amp;label)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_submenu</name>
      <anchorfile>classGio_1_1MenuItem.html</anchorfile>
      <anchor>ac3562d8a32bf6610e462bcbdafed5263</anchor>
      <arglist>(const Glib::RefPtr&lt; MenuModel &gt; &amp;submenu)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_section</name>
      <anchorfile>classGio_1_1MenuItem.html</anchorfile>
      <anchor>a2361bda22895d8028023e51c6ddc9113</anchor>
      <arglist>(const Glib::RefPtr&lt; MenuModel &gt; &amp;section)</arglist>
    </member>
    <member kind="function">
      <type>Glib::VariantBase</type>
      <name>get_attribute</name>
      <anchorfile>classGio_1_1MenuItem.html</anchorfile>
      <anchor>af01863c67e840d6963e07638f4e3866b</anchor>
      <arglist>(const Glib::ustring &amp;attribute, const Glib::VariantType &amp;expected_type) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::VariantBase</type>
      <name>get_attribute</name>
      <anchorfile>classGio_1_1MenuItem.html</anchorfile>
      <anchor>a942abb60268302bceed2e5d6feface73</anchor>
      <arglist>(const Glib::ustring &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::VariantBase</type>
      <name>get_attribute_value</name>
      <anchorfile>classGio_1_1MenuItem.html</anchorfile>
      <anchor>aa9b0fd72c7577f705a5d2fb1dfe5b7f3</anchor>
      <arglist>(const Glib::ustring &amp;attribute, const Glib::VariantType &amp;expected_type) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::VariantBase</type>
      <name>get_attribute_value</name>
      <anchorfile>classGio_1_1MenuItem.html</anchorfile>
      <anchor>aefdb35498934c4a330f8118c6a429257</anchor>
      <arglist>(const Glib::ustring &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_action_and_target</name>
      <anchorfile>classGio_1_1MenuItem.html</anchorfile>
      <anchor>a2aa16d26522f85c676522dd8b3c0c7f7</anchor>
      <arglist>(const Glib::ustring &amp;action)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_action</name>
      <anchorfile>classGio_1_1MenuItem.html</anchorfile>
      <anchor>a53f0a4dead4877377565f4cc7f2d76f9</anchor>
      <arglist>(const Glib::ustring &amp;action)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unset_target</name>
      <anchorfile>classGio_1_1MenuItem.html</anchorfile>
      <anchor>a1094d0c94f886bd37c4ca631c50e2c6c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unset_action_and_target</name>
      <anchorfile>classGio_1_1MenuItem.html</anchorfile>
      <anchor>a46de41b649a31272dc2b13fd69e96e5c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_action_and_target</name>
      <anchorfile>classGio_1_1MenuItem.html</anchorfile>
      <anchor>a2f7175f1e5c5f132516956911f11fc0f</anchor>
      <arglist>(const Glib::ustring &amp;action, const Glib::VariantBase &amp;target_value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_detailed_action</name>
      <anchorfile>classGio_1_1MenuItem.html</anchorfile>
      <anchor>ae799faf2fb9fde82359468c1edef33d3</anchor>
      <arglist>(const Glib::ustring &amp;detailed_action)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_icon</name>
      <anchorfile>classGio_1_1MenuItem.html</anchorfile>
      <anchor>af6f3dd7fa08452e06e53751ad5947537</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unset_icon</name>
      <anchorfile>classGio_1_1MenuItem.html</anchorfile>
      <anchor>ae1228a7693f6cd414b8beab4fe50c62c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1MenuItem.html</anchorfile>
      <anchor>ac1d7557f96575ef4fcdc1ced749ae81e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; MenuItem &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1MenuItem.html</anchorfile>
      <anchor>a98b148e8ff40b4937a0494e671fad42a</anchor>
      <arglist>(const Glib::ustring &amp;label, const Glib::ustring &amp;detailed_action)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; MenuItem &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1MenuItem.html</anchorfile>
      <anchor>a0c47463cc423e29c91f38e4c8d84fa88</anchor>
      <arglist>(const Glib::ustring &amp;label, const Glib::RefPtr&lt; MenuModel &gt; &amp;submenu)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; MenuItem &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1MenuItem.html</anchorfile>
      <anchor>a08361e9a4036be549c802454aa9c656c</anchor>
      <arglist>(const Glib::RefPtr&lt; MenuModel &gt; &amp;submenu)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>MenuItem</name>
      <anchorfile>classGio_1_1MenuItem.html</anchorfile>
      <anchor>a7811f82a7c5b2483c37667ef4517b7de</anchor>
      <arglist>(const Glib::ustring &amp;label=Glib::ustring(), const Glib::ustring &amp;detailed_action=Glib::ustring())</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>MenuItem</name>
      <anchorfile>classGio_1_1MenuItem.html</anchorfile>
      <anchor>a066cca32dbb3b49f985cdba0aba93ca6</anchor>
      <arglist>(const Glib::ustring &amp;label, const Glib::RefPtr&lt; MenuModel &gt; &amp;submenu)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>MenuItem</name>
      <anchorfile>classGio_1_1MenuItem.html</anchorfile>
      <anchor>a10620c7394969858d88bd5611e5cc9a8</anchor>
      <arglist>(const Glib::RefPtr&lt; MenuModel &gt; &amp;submenu)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::MenuItem &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1MenuItem.html</anchorfile>
      <anchor>a923b0dcf6c58eef630f81fd8f6d9046b</anchor>
      <arglist>(GMenuItem *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::MenuLinkIter</name>
    <filename>classGio_1_1MenuLinkIter.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~MenuLinkIter</name>
      <anchorfile>classGio_1_1MenuLinkIter.html</anchorfile>
      <anchor>a369ba32c86ca18e0b9443b65735d8405</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GMenuLinkIter *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MenuLinkIter.html</anchorfile>
      <anchor>a173b3cfa9acd4f726d7e6d263ecd8bad</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GMenuLinkIter *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MenuLinkIter.html</anchorfile>
      <anchor>ab3966ea5109f37c83ae511402e6f1aa3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GMenuLinkIter *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1MenuLinkIter.html</anchorfile>
      <anchor>a020e2bf6116e6b571f32a8ca94457da3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_name</name>
      <anchorfile>classGio_1_1MenuLinkIter.html</anchorfile>
      <anchor>a51b7f9a3b49c69a9845dc61d126df041</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_next</name>
      <anchorfile>classGio_1_1MenuLinkIter.html</anchorfile>
      <anchor>acbcef4f47e5933e561f21f47ce1cb02b</anchor>
      <arglist>(Glib::ustring &amp;out_link, Glib::RefPtr&lt; MenuModel &gt; &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; MenuModel &gt;</type>
      <name>get_value</name>
      <anchorfile>classGio_1_1MenuLinkIter.html</anchorfile>
      <anchor>a3d8cc7062124baa117a4881ec4b5c9a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const MenuModel &gt;</type>
      <name>get_value</name>
      <anchorfile>classGio_1_1MenuLinkIter.html</anchorfile>
      <anchor>a3b356ca32d6ce74ab177ea07cb261608</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>next</name>
      <anchorfile>classGio_1_1MenuLinkIter.html</anchorfile>
      <anchor>ac41524672d20f2b0f725697713ae78da</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1MenuLinkIter.html</anchorfile>
      <anchor>a7adc89d0fead8deb4887962c9ff68896</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>MenuLinkIter</name>
      <anchorfile>classGio_1_1MenuLinkIter.html</anchorfile>
      <anchor>a98783ba6619bdc75a35e22b716844db5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::MenuLinkIter &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1MenuLinkIter.html</anchorfile>
      <anchor>a17688e9319c157ac32bd533aa04227d7</anchor>
      <arglist>(GMenuLinkIter *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::MenuModel</name>
    <filename>classGio_1_1MenuModel.html</filename>
    <base>Glib::Object</base>
  </compound>
  <compound kind="class">
    <name>Gio::Mount</name>
    <filename>classGio_1_1Mount.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Mount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a13e8fa0a412e509ed8a5cc10bf212ee2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GMount *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>afdab4fd2377e912d2baef0cc6a825eca</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GMount *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ae15d61c7a8bb68f66fc46e3eaaaffbe6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>get_root</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>accf83f7b2599411cb82f5f4c0172db81</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const File &gt;</type>
      <name>get_root</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ac2bf8f7a467856c39cfc016d61fe8c5f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_name</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a951d543f8907069e20678dd503928cd0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ae368f1d91fc927b809f27acce5aff58e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a4c26c21db5fb5960b24d780018c6d04f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>get_symbolic_icon</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>adcab6c682190b8d8265af3df3d089c8b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Icon &gt;</type>
      <name>get_symbolic_icon</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a3b8fdf636f0ac89e8045d14c315cda19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_uuid</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a8a58874fb45ac7960dec34f094f0306e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Volume &gt;</type>
      <name>get_volume</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a9497eb3a3a928144f522489b5b432cad</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Volume &gt;</type>
      <name>get_volume</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ac9f2177094e6203eaf6aa186b7ea3ee4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Drive &gt;</type>
      <name>get_drive</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ab9b8889c7b8c8fdb885a46dad7419fed</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Drive &gt;</type>
      <name>get_drive</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a9045c2d50f4433ebfa137c501b00fd96</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_unmount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a52771234b6feb921931f28886bced5f7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_eject</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a279bb465c4781cf4a769db412db947f8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a6eb057d27f3729dc451d32e8c6bc8fa0</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a99bb5452908456ece101cee94d58efe9</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>aedbcd024f16a92c704261c17eb7b1cf6</anchor>
      <arglist>(MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a4673333db9d066f1f0fef5e4b2d5bd2b</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a833c71dbd0d5cfa222cec64cafaaf328</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>af40b60bca3e9bc53496f0ac926a4db04</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>unmount_finish</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a319db22009f052fb5d0c45596f203d4d</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>aae983acbd58daf68125f5129466d4de1</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;operation, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a088ae08b4bc3a8dc44c0e18aa2b438e3</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;operation, const SlotAsyncReady &amp;slot, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a2059d92df5b2cc36268545b3dbd2c171</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;operation, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a4ef4769ca5b2e9a55f8a1981b2cc051e</anchor>
      <arglist>(MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>remount_finish</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a5cb279b126e6086b5f0ae0957794f023</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a6bbacd6b5ab2251d8df9db538d6f0d60</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a3573df8a4d1d10dd321e2f46d9afc337</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a0fe94aae6876d196348f786c5e830b49</anchor>
      <arglist>(MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a8c2898b067f5651cb641c4375833f15b</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a9a27b41f48e3a00783b0d8ac313d0014</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ac7ff80c7b83d251de9a8c47ce79e9e5b</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>eject_finish</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>aee0c22ba1711f4d84d1eb0d2989c2d0d</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>guess_content_type</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a3ab56ac69c41c668990e91d7be2a2b73</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, bool force_rescan=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>guess_content_type</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a498994191262236c4bddf0b95df92642</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, bool force_rescan=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>guess_content_type</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ada39b6385004f938c38ce14b0566756b</anchor>
      <arglist>(bool force_rescan=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>guess_content_type_sync</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a42de2d821060ef0f958ec176749ab595</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, bool force_rescan=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>guess_content_type_sync</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a7e6b4c96208fca788cedb49dbea89258</anchor>
      <arglist>(bool force_rescan=true)</arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>guess_content_type_finish</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a274064a160c15338580685a9e1603497</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_shadowed</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a7788da3491e20c6a5563adb7690001fb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>shadow</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a1988ef61bd5316876ef434593a45f584</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unshadow</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ab25d880d541247871be715e13fa2b39e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>get_default_location</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a8ff89751cfd5b626952525a079829fed</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_sort_key</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a612a645d786012c1866bb153955a87f8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_changed</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ae9331b0fb0c2154885818ed72ddb21a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_unmounted</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>adafc3d61a654cf2236f568e534aa6616</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_pre_unmount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ae0c76ef0e895f2781add651624c590ed</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>aad5f6e7a513330f247f71c9475a3eec8</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a03ec69273177d0e9cd2c6802227deacc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Mount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a43cb15d97a7f03f7a3385bf741708a46</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_changed</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>adf264056921a09b1426625973fb1d182</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_unmounted</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>adc6f47efdfd20501692f82a2c94b7efa</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Mount &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a4723a81c56625aa5920589115060812c</anchor>
      <arglist>(GMount *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::MountOperation</name>
    <filename>classGio_1_1MountOperation.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~MountOperation</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a6899f6121cf5a44a39ae3cc662d92fc6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GMountOperation *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a580640ff16e8cd1cbd9d0ce4659daa7e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GMountOperation *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a100962323f73438a4d35253b5763cc30</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GMountOperation *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a6e6feac74568a2eb7e6ca1a63122c31b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_username</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a13621e9b35aa25b8f62e5a6db14d3967</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_username</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>ae9e313d9dca3421676c590cf50134d62</anchor>
      <arglist>(const Glib::ustring &amp;username)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_password</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>ac874e50f4915199d6013932633841ac0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_password</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a9df86e31c73fea9e438586fde8a92b70</anchor>
      <arglist>(const Glib::ustring &amp;password)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_anonymous</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>aa30b6f82881ae1afea5a21836e5bd036</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_anonymous</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>ad5a97dd24b05012c93211932880edc02</anchor>
      <arglist>(bool anonymous=true)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_domain</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a3f0ed216f46c7a914c73d7d1e4a8c0c7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_domain</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a09fd2984393678b8592b7a3d565c0307</anchor>
      <arglist>(const Glib::ustring &amp;domain)</arglist>
    </member>
    <member kind="function">
      <type>PasswordSave</type>
      <name>get_password_save</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>abc1af61dac7d1427775b7505d27cd319</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_password_save</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>adf1fbd975b639f2b099736f83d3f9bd0</anchor>
      <arglist>(PasswordSave save)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_choice</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>ab7eaa8f1ea17c14c86c5f30cc0c5eda9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_choice</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a6fbd101a1db62e2f34b23b9fa5cca869</anchor>
      <arglist>(int choice)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reply</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a1f444eede759bae682091b8fc5f108d3</anchor>
      <arglist>(MountOperationResult result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy4&lt; void, const Glib::ustring &amp;, const Glib::ustring &amp;, const Glib::ustring &amp;, AskPasswordFlags &gt;</type>
      <name>signal_ask_password</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a10cfcab05979a518d20f0c03cbf1a6cc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy2&lt; void, const Glib::ustring &amp;, const Glib::StringArrayHandle &amp; &gt;</type>
      <name>signal_ask_question</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a38daf1bcead0ae90cc61db691616c342</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, MountOperationResult &gt;</type>
      <name>signal_reply</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a55fa9cab0e2955fa6142f5dcc95198dc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_aborted</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a2aaec5c293ef88d3c331b67ee92f0493</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy3&lt; void, const Glib::ustring &amp;, gint64, gint64 &gt;</type>
      <name>signal_show_unmount_progress</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a7348b259356b0dae5b0e1d56c97f1ee4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Glib::ustring &gt;</type>
      <name>property_username</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a343d4ebfbef38f57a26b25ff86f21a8a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_username</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a344158870c7a4ffd1ba7fe5c42c183e0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Glib::ustring &gt;</type>
      <name>property_password</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a090c6c9ed3ded046b79cacbbda821c9e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_password</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>af2707b368a5a0bae8bb67846f696c58e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_anonymous</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a6da8f2f69cf4ea9fccde46f44addb88a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_anonymous</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>aea841c352e4dd6a4f4b31e461f095b00</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Glib::ustring &gt;</type>
      <name>property_domain</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>ad3206fe2d96665bc187ff8a13e4b22fb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_domain</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a37f8604db759f2b74d3857a11277db55</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; PasswordSave &gt;</type>
      <name>property_password_save</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a04c4d41b4075a04524aa00f3b4fd6fa1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; PasswordSave &gt;</type>
      <name>property_password_save</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>ac32c9c6ec642389e1e53049161922910</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; int &gt;</type>
      <name>property_choice</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>aa54cb65cc8fc27eb4972931668aa151a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_choice</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a73629ee0c8344b8dc9dcc99fae9ddd93</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a06f645537aad67629edd4180e3321bca</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; MountOperation &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a3e59fd19498a9be34bbb7462d87e2ca1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>MountOperation</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a415e62c32b8d497d859e50da0c8431cb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_ask_password</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a2bfee2a7879e75708a22cfb59e99280b</anchor>
      <arglist>(const Glib::ustring &amp;message, const Glib::ustring &amp;default_user, const Glib::ustring &amp;default_domain, AskPasswordFlags flags)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_ask_question</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>af4d007e34e6f023de14a667aabfe3a39</anchor>
      <arglist>(const Glib::ustring &amp;message, const Glib::StringArrayHandle &amp;choices)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_reply</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a9480654f1624640c719ce260883c8f9e</anchor>
      <arglist>(MountOperationResult result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::MountOperation &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a65da8ecee4b6b6cfd9e846ec6bc950fe</anchor>
      <arglist>(GMountOperation *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::NetworkAddress</name>
    <filename>classGio_1_1NetworkAddress.html</filename>
    <base>Glib::Object</base>
    <base>Gio::SocketConnectable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~NetworkAddress</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a6907240bebaea930f6a4ea0cf48e9478</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GNetworkAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>ac3bece6c2edb44d1346abd2a07995df9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GNetworkAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a34f56c110e7a2e843680d8ac8f9b7501</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GNetworkAddress *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>aa38b8f4bb0392393ea1235f3adbe79e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_hostname</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a859e032334faefe8c8c7d68f8ee2cdfe</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint16</type>
      <name>get_port</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a8a8893314bda54fc9b09a52f4bf9c33d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_scheme</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>abb7200ac34651f35c5520f25156664db</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; std::string &gt;</type>
      <name>property_hostname</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>ae30c1790f56d46bb161d8b7e4a8c2b63</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; guint &gt;</type>
      <name>property_port</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a0949682dcefcd8581cec86c06410d675</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; std::string &gt;</type>
      <name>property_scheme</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a1764ce7d454b29866c84eecd823c66c1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>adc8cd99b4c8e352a64eaecfa497bcdc8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; NetworkAddress &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a30cc7b78902bb94a53b7eca98fbee083</anchor>
      <arglist>(const std::string &amp;hostname, guint16 port)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; NetworkAddress &gt;</type>
      <name>parse</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a0090a07db819bd872a1379cb6d6c635a</anchor>
      <arglist>(const std::string &amp;host_and_port, guint16 default_port)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::NetworkAddress &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a8283831783706b23dea2801e56bf1b1d</anchor>
      <arglist>(GNetworkAddress *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::NetworkService</name>
    <filename>classGio_1_1NetworkService.html</filename>
    <base>Glib::Object</base>
    <base>Gio::SocketConnectable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~NetworkService</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a991fb9d21ee21f41b0f6f78c57ba354b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GNetworkService *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a01c7acc26f88ba9b62cebecfadf0eb81</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GNetworkService *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a4163659ccfef2fe1459e54f542a04a83</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GNetworkService *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>ac73f00e197b587678ea62ed430d7592c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_service</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>ab6d8f3c7d9da2a302645eecce0707a7e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_protocol</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a2789410b339d1fd4770ca24243421520</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_domain</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a5ee1798c274fc4868fc108c6e3b0fbef</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_scheme</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a230c5bb95e22702553cfaaeb732ecc9b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_scheme</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a84d94901aa012cd8d1594ccb1ebbed2c</anchor>
      <arglist>(const Glib::ustring &amp;scheme)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_domain</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a014d9c11a66656f47151e747ae148256</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_protocol</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a255ca9d5aea38963484cad402826b3b1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Glib::ustring &gt;</type>
      <name>property_scheme</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>af6dc0c00c17461f1e49b6b3eb6b64680</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_scheme</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a803938e1204d47690385a2953a860992</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_service</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>aee4ae0fcb228072911460899d662473f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a92cefcdf90faf1a83f51bb68fdf8e5c3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; NetworkService &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a1e6e8639ee28297dbce656fa93cafe65</anchor>
      <arglist>(const Glib::ustring &amp;service, const Glib::ustring &amp;protocol, const Glib::ustring &amp;domain)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::NetworkService &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>ac0ea3336b85237336a8c8efeb4f864ec</anchor>
      <arglist>(GNetworkService *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Notification</name>
    <filename>classGio_1_1Notification.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Notification</name>
      <anchorfile>classGio_1_1Notification.html</anchorfile>
      <anchor>ab774677d597a7dc642eab79562ce4252</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GNotification *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Notification.html</anchorfile>
      <anchor>adad17eef207216ffeaf10b1e3406f475</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GNotification *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Notification.html</anchorfile>
      <anchor>a76860196e4e53bfb4f0d6319e4b87a41</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GNotification *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1Notification.html</anchorfile>
      <anchor>a4f988d881d9b3e5dd0b95e3fbd44fcff</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_title</name>
      <anchorfile>classGio_1_1Notification.html</anchorfile>
      <anchor>af12b1eca8a95158c235d12f14d50fb83</anchor>
      <arglist>(const Glib::ustring &amp;title)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_body</name>
      <anchorfile>classGio_1_1Notification.html</anchorfile>
      <anchor>ab67d95006097a4a80e7c2b034f7ecf94</anchor>
      <arglist>(const Glib::ustring &amp;body)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_icon</name>
      <anchorfile>classGio_1_1Notification.html</anchorfile>
      <anchor>a6bb5652cce58e4133c3e95c54b50ef61</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_urgent</name>
      <anchorfile>classGio_1_1Notification.html</anchorfile>
      <anchor>af8f36012b71a0b6b26759954bc208264</anchor>
      <arglist>(bool urgent=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_button</name>
      <anchorfile>classGio_1_1Notification.html</anchorfile>
      <anchor>aabb1338b9fe64c423fcad7358a920441</anchor>
      <arglist>(const Glib::ustring &amp;label, const Glib::ustring &amp;detailed_action)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_button</name>
      <anchorfile>classGio_1_1Notification.html</anchorfile>
      <anchor>aa3a2717c029dcc7f540777c7fb1cec9d</anchor>
      <arglist>(const Glib::ustring &amp;label, const Glib::ustring &amp;action, const T_Value &amp;target)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_button_variant</name>
      <anchorfile>classGio_1_1Notification.html</anchorfile>
      <anchor>a4c11dede544b617946b2560a96e2c57a</anchor>
      <arglist>(const Glib::ustring &amp;label, const Glib::ustring &amp;action, const Glib::VariantBase &amp;target)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_default_action</name>
      <anchorfile>classGio_1_1Notification.html</anchorfile>
      <anchor>a74903aefc8ca1230cfc514fc61ae5be4</anchor>
      <arglist>(const Glib::ustring &amp;detailed_action)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_default_action</name>
      <anchorfile>classGio_1_1Notification.html</anchorfile>
      <anchor>aa539ee6b8f61c9e83e7325da723c1687</anchor>
      <arglist>(const Glib::ustring &amp;action, const T_Value &amp;target)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_default_action_variant</name>
      <anchorfile>classGio_1_1Notification.html</anchorfile>
      <anchor>a4ddbe110e5ac1b30246051e9d5a79e93</anchor>
      <arglist>(const Glib::ustring &amp;action, const Glib::VariantBase &amp;target)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1Notification.html</anchorfile>
      <anchor>ae97c070128a44260a83021495cde9b72</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Notification &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1Notification.html</anchorfile>
      <anchor>a84abf2f3fe1728fcc9dd468f55900360</anchor>
      <arglist>(const Glib::ustring &amp;title)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Notification</name>
      <anchorfile>classGio_1_1Notification.html</anchorfile>
      <anchor>a0e992f6ca8b654ca9f29b411bc007eb8</anchor>
      <arglist>(const Glib::ustring &amp;title)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Notification &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Notification.html</anchorfile>
      <anchor>ace580b39e1f168297a21e4b76e944c0b</anchor>
      <arglist>(GNotification *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::OutputStream</name>
    <filename>classGio_1_1OutputStream.html</filename>
    <base>Glib::Object</base>
  </compound>
  <compound kind="class">
    <name>Gio::Permission</name>
    <filename>classGio_1_1Permission.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Permission</name>
      <anchorfile>classGio_1_1Permission.html</anchorfile>
      <anchor>aed4caa916dd23a64a4518dfd73172c2f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GPermission *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Permission.html</anchorfile>
      <anchor>a72b22a9597f996acae104c45fc960fbe</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GPermission *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Permission.html</anchorfile>
      <anchor>a44d5d50c2eb1ce82004c31da33187759</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GPermission *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1Permission.html</anchorfile>
      <anchor>ad239c70d1607f419e489687459d73ae3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>acquire</name>
      <anchorfile>classGio_1_1Permission.html</anchorfile>
      <anchor>a8e35502ce7f195aeb4b99ef03efc3d65</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>acquire</name>
      <anchorfile>classGio_1_1Permission.html</anchorfile>
      <anchor>a8da11eaad605de8d5fdf270b60d078ca</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>acquire_async</name>
      <anchorfile>classGio_1_1Permission.html</anchorfile>
      <anchor>ae9bc42624e44c068bfba8eea912d1be9</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>acquire_async</name>
      <anchorfile>classGio_1_1Permission.html</anchorfile>
      <anchor>af79bc628f37df342f95402fb2c0e329e</anchor>
      <arglist>(const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>acquire_finish</name>
      <anchorfile>classGio_1_1Permission.html</anchorfile>
      <anchor>a54b25597c86a6547e1d97d2897fd5486</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>release</name>
      <anchorfile>classGio_1_1Permission.html</anchorfile>
      <anchor>a96bed2605f66e5d41c7f431fa29577bc</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>release</name>
      <anchorfile>classGio_1_1Permission.html</anchorfile>
      <anchor>a599d0f206642b07ccf333d5e5bab8341</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>release_async</name>
      <anchorfile>classGio_1_1Permission.html</anchorfile>
      <anchor>ae24e9bdf0c514d677ff72b82ecec3bf6</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>release_async</name>
      <anchorfile>classGio_1_1Permission.html</anchorfile>
      <anchor>a4e674297df5e6a98b870c2775f94194e</anchor>
      <arglist>(const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>release_finish</name>
      <anchorfile>classGio_1_1Permission.html</anchorfile>
      <anchor>a41e1344df32fcd99dd5016a6cffa4d5a</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_allowed</name>
      <anchorfile>classGio_1_1Permission.html</anchorfile>
      <anchor>a3a1efc3f79f6e6a425f7cd63c53e69b4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_can_acquire</name>
      <anchorfile>classGio_1_1Permission.html</anchorfile>
      <anchor>ae4fa3c8eefd372fd7d333dde2669b6ee</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_can_release</name>
      <anchorfile>classGio_1_1Permission.html</anchorfile>
      <anchor>a77f8a1fe9d245e2096b3ccd23ba33dc5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_allowed</name>
      <anchorfile>classGio_1_1Permission.html</anchorfile>
      <anchor>ab5f57e795dab93ef7f2013b28ef72026</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_can_acquire</name>
      <anchorfile>classGio_1_1Permission.html</anchorfile>
      <anchor>a49fcdb8614d748ec795afc6be78e9e94</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_can_release</name>
      <anchorfile>classGio_1_1Permission.html</anchorfile>
      <anchor>ab46d1c1f8ce5a035b219cf5dd8119eb2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1Permission.html</anchorfile>
      <anchor>adaa1953c0d4e3d834298ea3167650af7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Permission</name>
      <anchorfile>classGio_1_1Permission.html</anchorfile>
      <anchor>a126fefae82951abd327a018c1d3d9a3f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>acquire_vfunc</name>
      <anchorfile>classGio_1_1Permission.html</anchorfile>
      <anchor>a8da9eda76aa0f09898da4de266916838</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>acquire_async_vfunc</name>
      <anchorfile>classGio_1_1Permission.html</anchorfile>
      <anchor>aec8dd7c14e5d2325447acfa049103ece</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>acquire_finish_vfunc</name>
      <anchorfile>classGio_1_1Permission.html</anchorfile>
      <anchor>a98e548265374c412ff6d1e444b924bd8</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>release_vfunc</name>
      <anchorfile>classGio_1_1Permission.html</anchorfile>
      <anchor>a7f5007d8988dcae7d76f7ac58d41b123</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>release_async_vfunc</name>
      <anchorfile>classGio_1_1Permission.html</anchorfile>
      <anchor>a1d576f21fd34723fbdf149fd85cff9ac</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>release_finish_vfunc</name>
      <anchorfile>classGio_1_1Permission.html</anchorfile>
      <anchor>a99cfd16c95626967c29db4351cafa73f</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>impl_update</name>
      <anchorfile>classGio_1_1Permission.html</anchorfile>
      <anchor>a4ee6a6cff3d2fcdb548235d0848e2a7e</anchor>
      <arglist>(bool allowed, bool can_acquire, bool can_release)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Permission &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Permission.html</anchorfile>
      <anchor>ac9e29ddf119ded94357bab5be6247ecb</anchor>
      <arglist>(GPermission *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::PollableInputStream</name>
    <filename>classGio_1_1PollableInputStream.html</filename>
    <base>Glib::Interface</base>
  </compound>
  <compound kind="class">
    <name>Gio::PollableOutputStream</name>
    <filename>classGio_1_1PollableOutputStream.html</filename>
    <base>Glib::Interface</base>
  </compound>
  <compound kind="class">
    <name>Gio::Proxy</name>
    <filename>classGio_1_1Proxy.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Proxy</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>a86fd06700799e30e5a433c722951fedd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GProxy *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>a5d635bea4b7b93e6dfe4a9e0d50f569f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GProxy *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>af7968158aaa54282ca7cab466d491ff6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; IOStream &gt;</type>
      <name>connect</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>a6b4fb0207d17c0118720f96ce79b3b05</anchor>
      <arglist>(const Glib::RefPtr&lt; IOStream &gt; &amp;connection, const Glib::RefPtr&lt; const ProxyAddress &gt; &amp;proxy_address, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>connect_async</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>ac95ea8b9613b7f125baa2d96041d8397</anchor>
      <arglist>(const Glib::RefPtr&lt; IOStream &gt; &amp;connection, const Glib::RefPtr&lt; const ProxyAddress &gt; &amp;proxy_address, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>connect_async</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>aa65146dc11e84e4ee09f0f78500d6279</anchor>
      <arglist>(const Glib::RefPtr&lt; IOStream &gt; &amp;connection, const Glib::RefPtr&lt; const ProxyAddress &gt; &amp;proxy_address, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; IOStream &gt;</type>
      <name>connect_finish</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>a14d0ba006367a41d64ae58deb8b2d074</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>supports_hostname</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>a74fc2a43857241702bfa3668c68c14f3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>a1922e1348160624161a7da73a12d401e</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>a09cbe3afb8c91b76923d4903d0abb88c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Proxy &gt;</type>
      <name>get_default_for_protocol</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>a13d55cd6a30e21b62d96fab02138f2f0</anchor>
      <arglist>(const Glib::ustring &amp;protocol)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Proxy</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>aac8ea26a1e716bc0bca4d16dcaa4fe23</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Proxy &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>a2618cd487487871eff6e8ad5d2d3695b</anchor>
      <arglist>(GProxy *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::ProxyAddress</name>
    <filename>classGio_1_1ProxyAddress.html</filename>
    <base>Gio::InetSocketAddress</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~ProxyAddress</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>aeee66714ca21aee0e8fd58df73c6a372</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GProxyAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>aa085bc6a03d6c8861c12bba387d395c2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GProxyAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>a010e1f1f91c72e9be01afce6cb6f55ce</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GProxyAddress *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>ae54b9556db86b4f13b2aef789685fcad</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_protocol</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>abbe07e03c353db1f52de7df7a8d82e0f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_destination_protocol</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>a965aecb110c4a9494fc6e06794332e1d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_destination_hostname</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>a62d7233e953e6b570dd0b3b8502a46c2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint16</type>
      <name>get_destination_port</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>a47d0a94a1bffabce35ce7dcc5674db82</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_username</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>a1a4c55743dd829c42b5abad0fbacad3e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_password</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>a903bdaf26d3905a264c3a9decfa03e47</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_uri</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>aeca1af6dd05cc8c7f9cb90bafd601d3b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_protocol</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>a62d157070df11b4d9de6f3dd5a4aed5e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_destination_protocol</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>a3722e560d24400ac85f1d98abbdd2f7f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_destination_hostname</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>a13d7b8fcd86f5ae204f57207566d84ff</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_destination_port</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>a2986bbfcd288da8de88615fdf6639986</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_username</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>a916cd3370a00ffecf25443ca80ca77a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_password</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>adf6dbab0ba851cd5407f8138ae315fe6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_uri</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>a35a64764fa80ccc36c24b7ddbca098b6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>a816ba2a308f0ab60f694b3fda492075c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; ProxyAddress &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>a31cd08b2cce1b8a1d04af9a6e39db600</anchor>
      <arglist>(const Glib::RefPtr&lt; InetAddress &gt; &amp;address, guint16 port, const Glib::ustring &amp;protocol, const Glib::ustring &amp;destination_hostname, guint16 destination_port, const Glib::ustring &amp;username=Glib::ustring(), const Glib::ustring &amp;password=Glib::ustring())</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>ProxyAddress</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>af36bca5cb7e8bc4a8791600e7267b66b</anchor>
      <arglist>(const Glib::RefPtr&lt; InetAddress &gt; &amp;address, guint16 port, const Glib::ustring &amp;protocol, const Glib::ustring &amp;destination_hostname, guint16 destination_port, const Glib::ustring &amp;username=Glib::ustring(), const Glib::ustring &amp;password=Glib::ustring())</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::ProxyAddress &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>af5ac5530f123a7fc5a0720fb1a806e0b</anchor>
      <arglist>(GProxyAddress *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::ProxyResolver</name>
    <filename>classGio_1_1ProxyResolver.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~ProxyResolver</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>a5c63b3c94c77b16894b0edac5fbef1e5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GProxyResolver *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>a3131a7a3022a4006769e0776c3eafc57</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GProxyResolver *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>ae1cb23c9cd789ef7e4bad90b0829d47e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_supported</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>a2f9af129acc2febba9ba323bf436a243</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Glib::ustring &gt;</type>
      <name>lookup</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>a33219314d36a97ccf30bab58ec279e18</anchor>
      <arglist>(const Glib::ustring &amp;uri, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Glib::ustring &gt;</type>
      <name>lookup</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>abc8a97d206ad3e6562a2327322ba9369</anchor>
      <arglist>(const Glib::ustring &amp;uri)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lookup_async</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>a4fe46f67b2787252395103798a9891d2</anchor>
      <arglist>(const Glib::ustring &amp;uri, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lookup_async</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>ab46bc2b5f3672e11ea26c0289aea572e</anchor>
      <arglist>(const Glib::ustring &amp;uri, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Glib::ustring &gt;</type>
      <name>lookup_finish</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>ab1a31effc0f9384d7c8904c11fbd5668</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>aa5f390c09142e4a6c8fd6bedf310f154</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>a9bf948d2fbf6559b3c28223416b2fb5f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; ProxyResolver &gt;</type>
      <name>get_default</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>ac8cbc11eb57150f28dfc8f6046bb4648</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>ProxyResolver</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>a5884689d8072cb836fd1ddc6c09dc510</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::ProxyResolver &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>a3f4b5af03af6650ce85eb1df6e50add6</anchor>
      <arglist>(GProxyResolver *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::RemoteActionGroup</name>
    <filename>classGio_1_1RemoteActionGroup.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~RemoteActionGroup</name>
      <anchorfile>classGio_1_1RemoteActionGroup.html</anchorfile>
      <anchor>a88f54ea1ece68f212f8cac51b37d616e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GRemoteActionGroup *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1RemoteActionGroup.html</anchorfile>
      <anchor>aa9e53402a7b3aaf8b27bc344cbc7e769</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GRemoteActionGroup *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1RemoteActionGroup.html</anchorfile>
      <anchor>a33c88565858f3ff88680a2168b6fb1d4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>activate_action</name>
      <anchorfile>classGio_1_1RemoteActionGroup.html</anchorfile>
      <anchor>a8e7d6bd31fe683dfd391911c0739f635</anchor>
      <arglist>(const Glib::ustring &amp;action_name, const Glib::VariantBase &amp;parameter, const Glib::VariantBase &amp;platform_data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>change_action_state</name>
      <anchorfile>classGio_1_1RemoteActionGroup.html</anchorfile>
      <anchor>a50b57a393496744613ddb20ad951e510</anchor>
      <arglist>(const Glib::ustring &amp;action_name, const Glib::VariantBase &amp;value, const Glib::VariantBase &amp;platform_data)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>activate_action_vfunc</name>
      <anchorfile>classGio_1_1RemoteActionGroup.html</anchorfile>
      <anchor>a03466a5b72dad8a24ded1b5b8825e5a5</anchor>
      <arglist>(const Glib::ustring &amp;action_name, const Glib::VariantBase &amp;parameter, const Glib::VariantBase &amp;platform_data)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>change_action_state_vfunc</name>
      <anchorfile>classGio_1_1RemoteActionGroup.html</anchorfile>
      <anchor>a54a92949ab973e6589b6552a1c9f6542</anchor>
      <arglist>(const Glib::ustring &amp;action_name, const Glib::VariantBase &amp;value, const Glib::VariantBase &amp;platform_data)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1RemoteActionGroup.html</anchorfile>
      <anchor>ad0514a7d8bbf26ed0221d4a1e5eaf68f</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1RemoteActionGroup.html</anchorfile>
      <anchor>aa12a0373fdd170185d2b238c911672b3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>RemoteActionGroup</name>
      <anchorfile>classGio_1_1RemoteActionGroup.html</anchorfile>
      <anchor>aaf64689f4e9d63c615535191d2f736ad</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::RemoteActionGroup &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1RemoteActionGroup.html</anchorfile>
      <anchor>a236fcb0eaef59a2d9231d05573a8f7bb</anchor>
      <arglist>(GRemoteActionGroup *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Resolver</name>
    <filename>classGio_1_1Resolver.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Resolver</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a91fb01b808b2e2d315d9ffc149f1f71e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GResolver *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a4d323772493d0cf739816c80f08398d2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GResolver *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a77d572cc0c4a48c47ec06e9a5f2d02a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GResolver *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>ae1cf170f1700985b286238d5f1dcbab2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::RefPtr&lt; InetAddress &gt; &gt;</type>
      <name>lookup_by_name</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>aea1576fa2684d9bca58a589098a8371e</anchor>
      <arglist>(const Glib::ustring &amp;hostname, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::RefPtr&lt; InetAddress &gt; &gt;</type>
      <name>lookup_by_name</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a4aaf18d0bcc67d6d139d993b140a8b14</anchor>
      <arglist>(const Glib::ustring &amp;hostname)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lookup_by_name_async</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a0130482bb442e3a006e06d57665c2318</anchor>
      <arglist>(const Glib::ustring &amp;hostname, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lookup_by_name_async</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>ae38a0fc714443839c0bb3a0e40dcd082</anchor>
      <arglist>(const Glib::ustring &amp;hostname, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::RefPtr&lt; InetAddress &gt; &gt;</type>
      <name>lookup_by_name_finish</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>afaf6f9f003fd213ebecb893d60f14380</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>lookup_by_address</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>abb5740225148191d2e93d7a6b12caf23</anchor>
      <arglist>(const Glib::RefPtr&lt; InetAddress &gt; &amp;address, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>lookup_by_address</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a81f793a31c8ddaa2bf26361721c3fd1c</anchor>
      <arglist>(const Glib::RefPtr&lt; InetAddress &gt; &amp;address)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lookup_by_address_async</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a3bfd36d312e60b748df35089d5126b4f</anchor>
      <arglist>(const Glib::RefPtr&lt; InetAddress &gt; &amp;address, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lookup_by_address_async</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a91d05a43f8083af54826fcb3303e0eba</anchor>
      <arglist>(const Glib::RefPtr&lt; InetAddress &gt; &amp;address, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>lookup_by_address_finish</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>ae127e4682bfb20ef0b292e7b98460762</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>ListHandle_SrvTarget</type>
      <name>lookup_service</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>aab5e246c4f14e55e079c8a280dd3de5b</anchor>
      <arglist>(const Glib::ustring &amp;service, const Glib::ustring &amp;protocol, const Glib::ustring &amp;domain, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>ListHandle_SrvTarget</type>
      <name>lookup_service</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a3b131a66a7a7bd3e89713384ff2f6be3</anchor>
      <arglist>(const Glib::ustring &amp;service, const Glib::ustring &amp;protocol, const Glib::ustring &amp;domain)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lookup_service_async</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a49d103c02f6e0e8ad5d4e7abb1967ef0</anchor>
      <arglist>(const Glib::ustring &amp;service, const Glib::ustring &amp;protocol, const Glib::ustring &amp;domain, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lookup_service_async</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a58d46752ddd5305d811df4707c3ce4a7</anchor>
      <arglist>(const Glib::ustring &amp;service, const Glib::ustring &amp;protocol, const Glib::ustring &amp;domain, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>ListHandle_SrvTarget</type>
      <name>lookup_service_finish</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>aae68cb39415c9286474d92c7aeba2e47</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Glib::VariantContainerBase &gt;</type>
      <name>lookup_records</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a0977fbf517bd2b564c32f0aa59180a45</anchor>
      <arglist>(const Glib::ustring &amp;rrname, ResolverRecordType record_type, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Glib::VariantContainerBase &gt;</type>
      <name>lookup_records</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a0ccfae307c3490ca04047539b02adc9c</anchor>
      <arglist>(const Glib::ustring &amp;rrname, ResolverRecordType record_type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lookup_records_async</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a93ae3a79790b7cc59680bc096cd053c0</anchor>
      <arglist>(const Glib::ustring &amp;rrname, ResolverRecordType record_type, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lookup_records_async</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>ac763d0f77c67aeba6bfa52fbdc0eb586</anchor>
      <arglist>(const Glib::ustring &amp;rrname, ResolverRecordType record_type, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Glib::VariantContainerBase &gt;</type>
      <name>lookup_records_finish</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a69b72b15a960fa5ab7ebe4ad25b0589f</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_reload</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a097abf4f88816a46fa2272430a1b5e3d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>aed43435bf27bf2108cb0ec6fb40ff6a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Resolver &gt;</type>
      <name>get_default</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>ac822ffe60ab0ce2acfdc85ccb908f6fc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>set_default</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>afbb1fb4f9edb0e553dbb61ca2437601c</anchor>
      <arglist>(const Glib::RefPtr&lt; Resolver &gt; &amp;resolver)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Resolver &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>aa710fc39dacfe0e34730487741d84fb9</anchor>
      <arglist>(GResolver *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::ResolverError</name>
    <filename>classGio_1_1ResolverError.html</filename>
    <base>Glib::Error</base>
    <member kind="enumeration">
      <type></type>
      <name>Code</name>
      <anchorfile>classGio_1_1ResolverError.html</anchorfile>
      <anchor>a6afd83f5c3f01ba099e5b82b8501b6f2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NOT_FOUND</name>
      <anchorfile>classGio_1_1ResolverError.html</anchorfile>
      <anchor>a6afd83f5c3f01ba099e5b82b8501b6f2a47a46579525249b10ab091f44af1248b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>TEMPORARY_FAILURE</name>
      <anchorfile>classGio_1_1ResolverError.html</anchorfile>
      <anchor>a6afd83f5c3f01ba099e5b82b8501b6f2af94dc802d8d85a9fe0459f99e94b6a6d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>INTERNAL</name>
      <anchorfile>classGio_1_1ResolverError.html</anchorfile>
      <anchor>a6afd83f5c3f01ba099e5b82b8501b6f2a65ff77c88e58b40291356c7410a1c6e5</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ResolverError</name>
      <anchorfile>classGio_1_1ResolverError.html</anchorfile>
      <anchor>a0d015ee9e313bfcd9a86414423f73fbb</anchor>
      <arglist>(Code error_code, const Glib::ustring &amp;error_message)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ResolverError</name>
      <anchorfile>classGio_1_1ResolverError.html</anchorfile>
      <anchor>a70b6b6e5cef46494eca49d696afc2bd8</anchor>
      <arglist>(GError *gobject)</arglist>
    </member>
    <member kind="function">
      <type>Code</type>
      <name>code</name>
      <anchorfile>classGio_1_1ResolverError.html</anchorfile>
      <anchor>a4966b66019b5f44295ab046d34fb2354</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::ResourceError</name>
    <filename>classGio_1_1ResourceError.html</filename>
    <base>Glib::Error</base>
    <member kind="enumeration">
      <type></type>
      <name>Code</name>
      <anchorfile>classGio_1_1ResourceError.html</anchorfile>
      <anchor>ad52695ecc4fc823c588771deeb6f9f20</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NOT_FOUND</name>
      <anchorfile>classGio_1_1ResourceError.html</anchorfile>
      <anchor>ad52695ecc4fc823c588771deeb6f9f20a198347173ad61d62bcd6d17e5bd7147d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>INTERNAL</name>
      <anchorfile>classGio_1_1ResourceError.html</anchorfile>
      <anchor>ad52695ecc4fc823c588771deeb6f9f20a74490a5d85788f2e688862e86eeffa46</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ResourceError</name>
      <anchorfile>classGio_1_1ResourceError.html</anchorfile>
      <anchor>ab2667ba9baeae522292bcc70a81b3e5c</anchor>
      <arglist>(Code error_code, const Glib::ustring &amp;error_message)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ResourceError</name>
      <anchorfile>classGio_1_1ResourceError.html</anchorfile>
      <anchor>a1514e8d78c53b8e71b994ee31ea9f31b</anchor>
      <arglist>(GError *gobject)</arglist>
    </member>
    <member kind="function">
      <type>Code</type>
      <name>code</name>
      <anchorfile>classGio_1_1ResourceError.html</anchorfile>
      <anchor>ac60514766d425fcd5780c3daf18ae591</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Seekable</name>
    <filename>classGio_1_1Seekable.html</filename>
    <base>Glib::Interface</base>
  </compound>
  <compound kind="class">
    <name>Gio::Settings</name>
    <filename>classGio_1_1Settings.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Settings</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a4c89c4537e05922457cf09f279d6fcab</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSettings *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a1350e8f1b8a2f0f02c0e00d0cd7077d0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSettings *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a3c1af502c3c7a372b07987c4d8e320c5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GSettings *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>ade0eeed443f1dfbc4b649bb294e445f6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_value</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a3b98d9d71ac41b70f09caf6cb4341183</anchor>
      <arglist>(const Glib::ustring &amp;key, const Glib::VariantBase &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_value</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>ac36cd4d128d4af6c0aac34572f4d0930</anchor>
      <arglist>(const Glib::ustring &amp;key, Glib::VariantBase &amp;value) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_user_value</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a7e5a08b2d224689d009e17066386e231</anchor>
      <arglist>(const Glib::ustring &amp;key, Glib::VariantBase &amp;value) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_default_value</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>af3c0e321d54534eb9b4d376fd4093fa5</anchor>
      <arglist>(const Glib::ustring &amp;key, Glib::VariantBase &amp;value) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_int</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a1f980e517365e5aa4520e982f5e11b27</anchor>
      <arglist>(const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_int</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a7b252643c8ce35c7892cb0b831d67046</anchor>
      <arglist>(const Glib::ustring &amp;key, int value)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_uint</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>addf324dee920be4f16220795c3ee235f</anchor>
      <arglist>(const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_uiint</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a10284d1e3636cc50aece0268ac18be87</anchor>
      <arglist>(const Glib::ustring &amp;key, guint value)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_boolean</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a0e00e5ad1bf22709184cb576e4b933a7</anchor>
      <arglist>(const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_boolean</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a08d737b902c907b692894ab577c4142e</anchor>
      <arglist>(const Glib::ustring &amp;key, bool value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_string</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a52bda84f1cb85f2efab6b82c72b41b7f</anchor>
      <arglist>(const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_string</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>ad1b4617d76cc9166e68bc849d22c5677</anchor>
      <arglist>(const Glib::ustring &amp;key, const Glib::ustring &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>get_double</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>ac5055dc109007beb12256ca312a0c356</anchor>
      <arglist>(const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_double</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a81b1bebc7cbf6518aa13ab00bf9966d5</anchor>
      <arglist>(const Glib::ustring &amp;key, double value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>get_string_array</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>ae5524c5c368069a6676755c01b968f10</anchor>
      <arglist>(const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_string_array</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a9e6e1bf8334f40cb76999a0678ac1b41</anchor>
      <arglist>(const Glib::ustring &amp;key, const Glib::StringArrayHandle &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_enum</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a4f6a1558661cba8ceea376fc9f81f52f</anchor>
      <arglist>(const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_enum</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a7fe28dd8bb422f55471d636e6bc5b648</anchor>
      <arglist>(const Glib::ustring &amp;key, int value)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_flags</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a679796b7368f679fa28478c6861cdad9</anchor>
      <arglist>(const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_flags</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a049877419a2d25a282ebbfd013bfea79</anchor>
      <arglist>(const Glib::ustring &amp;key, guint value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Settings &gt;</type>
      <name>get_child</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a98cfd433996d89d031108ca92e4d43d8</anchor>
      <arglist>(const Glib::ustring &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Settings &gt;</type>
      <name>get_child</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>ab5afa45ac5edd6ee5c3d55325c9984a9</anchor>
      <arglist>(const Glib::ustring &amp;name) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_writable</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a33a266c5d291000943cae9dda5cf9884</anchor>
      <arglist>(const Glib::ustring &amp;name) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>delay</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a33b026961c111c7cb811dd8886bd10aa</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>apply</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>ae1309ff09c69e278fbb9869219c3ac03</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>revert</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>ac11529acbf1dd553e5f3ebc5c0125ecd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_has_unapplied</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a84b99d6419887e0812f3a58eaece8e88</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a8fe9b5174d02d36b6b8fdacb0b10a049</anchor>
      <arglist>(const Glib::ustring &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Glib::ustring &gt;</type>
      <name>list_children</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a482a46eb92894e73e6678ba48d0e8c15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Glib::ustring &gt;</type>
      <name>list_keys</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a28d9dc219f86a7372e9a2dd7638daa9b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>range_check</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a1b2ab194e7cbf982622eb416a1b68047</anchor>
      <arglist>(const Glib::ustring &amp;key, const Glib::VariantBase &amp;value) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>bind</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a39d962b3e73ec10608a3a744cb4255b4</anchor>
      <arglist>(const Glib::ustring &amp;key, Glib::ObjectBase *object, const Glib::ustring &amp;property, SettingsBindFlags flags=SETTINGS_BIND_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>bind</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a893453b68172f5ecb6c008d2d642da3f</anchor>
      <arglist>(const Glib::ustring &amp;key, const Glib::PropertyProxy_Base &amp;property_proxy, SettingsBindFlags flags=SETTINGS_BIND_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>bind_writable</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a47c913cd1ce8122d742911fa54896fa7</anchor>
      <arglist>(const Glib::ustring &amp;key, Glib::ObjectBase *object, const Glib::ustring &amp;property, bool inverted=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>bind_writable</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>ac0da884631dc04c338287e475a5b93fe</anchor>
      <arglist>(const Glib::ustring &amp;key, const Glib::PropertyProxy_Base &amp;property_proxy, bool inverted=false)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Action &gt;</type>
      <name>create_action</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a03112726403e4b3b8d45f203d7307d6b</anchor>
      <arglist>(const Glib::ustring &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_delay_apply</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>aaa97605482bec03816ec11caa80d54ee</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_has_unapplied</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a98990a4c6063822aa31e5b6798dfcd1b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; std::string &gt;</type>
      <name>property_path</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a2d0ad409118650163e5a921b656cc2ca</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_schema</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a2158459609a1be4022003195534dc6c2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_schema_id</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a8ba6fa118331249e8c56cc2169707b93</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::ustring &amp; &gt;</type>
      <name>signal_changed</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>aedb2d1200cfc06141c56daf8a6c45456</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; bool, guint &gt;</type>
      <name>signal_writable_change_event</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>ae24c1784fc1f2fae4f758ea62bc70c31</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::ustring &amp; &gt;</type>
      <name>signal_writable_changed</name>