// Generated by gmmproc 2.41.2 -- DO NOT MODIFY!


#include <glibmm.h>

#include <giomm/socket.h>
#include <giomm/private/socket_p.h>


// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2007 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gio/gio.h>
#include <glibmm/error.h>
#include <giomm/asyncresult.h>
#include <giomm/socketsource.h>
#include "slot_async.h"

namespace Gio
{

Socket::Socket(SocketFamily family, SocketType type, SocketProtocol protocol,
               const Glib::RefPtr<Cancellable>& cancellable)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(socket_class_.init(), "family",int(family),"type",int(type),"protocol",int(protocol), static_cast<char*>(0)))
{
  init(cancellable);
}

Socket::Socket(int fd, const Glib::RefPtr<Cancellable>& cancellable)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(socket_class_.init(), "fd",fd, static_cast<char*>(0)))
{
  init(cancellable);
}

// static
Glib::RefPtr<Socket> Socket::create(SocketFamily family, SocketType type, SocketProtocol protocol,
                                    const Glib::RefPtr<Cancellable>& cancellable)
{
  return Glib::RefPtr<Socket>(new Socket(family, type, protocol, cancellable));
}

// static
Glib::RefPtr<Socket> Socket::create_from_fd(int fd, const Glib::RefPtr<Cancellable>& cancellable)
{
  return Glib::RefPtr<Socket>(new Socket(fd, cancellable));
}

gssize Socket::receive_from(Glib::RefPtr<SocketAddress>& address, char* buffer, gsize size, const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = 0;
  GSocketAddress* caddr = 0;
  gssize retvalue = g_socket_receive_from(gobj(), &caddr, buffer, size, const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  if (caddr)
      address = Glib::wrap (caddr);

  return retvalue;
}

gssize Socket::receive_from(Glib::RefPtr<SocketAddress>& address, char* buffer, gsize size)
{
  GError* gerror = 0;
  GSocketAddress* caddr = 0;
  gssize retvalue = g_socket_receive_from(gobj(), &caddr, buffer, size, 0, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  if (caddr)
      address = Glib::wrap (caddr);

  return retvalue;
}

gssize Socket::receive_with_blocking(gchar* buffer, gsize size, bool blocking,
  const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = 0;
  gssize const retvalue = g_socket_receive_with_blocking(gobj(), buffer, size,
    blocking, Glib::unwrap(cancellable), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

gssize Socket::send_with_blocking(gchar* buffer, gsize size, bool blocking,
  const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = 0;
  gssize const retvalue = g_socket_send_with_blocking(gobj(), buffer, size,
    blocking, Glib::unwrap(cancellable), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

Glib::RefPtr<SocketSource> Socket::create_source(Glib::IOCondition condition, const Glib::RefPtr<Cancellable>& cancellable)
{
  // The corresponding unreference() takes place in the dtor
  // of the Glib::RefPtr<Socket> object below.
  reference();
  return SocketSource::create(Glib::RefPtr<Socket>(this), condition, cancellable);
}

} // namespace Gio

namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gio::SocketType>::value_type()
{
  return g_socket_type_get_type();
}

// static
GType Glib::Value<Gio::SocketProtocol>::value_type()
{
  return g_socket_protocol_get_type();
}

// static
GType Glib::Value<Gio::SocketMsgFlags>::value_type()
{
  return g_socket_msg_flags_get_type();
}


namespace Glib
{

Glib::RefPtr<Gio::Socket> wrap(GSocket* object, bool take_copy)
{
  return Glib::RefPtr<Gio::Socket>( dynamic_cast<Gio::Socket*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gio
{


/* The *_Class implementation: */

const Glib::Class& Socket_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Socket_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(g_socket_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  Initable::add_interface(get_type());

  }

  return *this;
}


void Socket_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


}


Glib::ObjectBase* Socket_Class::wrap_new(GObject* object)
{
  return new Socket((GSocket*)object);
}


/* The implementation: */

GSocket* Socket::gobj_copy()
{
  reference();
  return gobj();
}

Socket::Socket(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

Socket::Socket(GSocket* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


Socket::~Socket()
{}


Socket::CppClassType Socket::socket_class_; // initialize static member

GType Socket::get_type()
{
  return socket_class_.init().get_type();
}


GType Socket::get_base_type()
{
  return g_socket_get_type();
}


void Socket::bind(const Glib::RefPtr<SocketAddress>& address, bool allow_reuse)
{
  GError* gerror = 0;
  g_socket_bind(gobj(), const_cast<GSocketAddress*>(Glib::unwrap(address)), static_cast<int>(allow_reuse), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

void Socket::listen()
{
  GError* gerror = 0;
  g_socket_listen(gobj(), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

Glib::RefPtr<Socket> Socket::accept(const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = 0;
  Glib::RefPtr<Socket> retvalue = Glib::wrap(g_socket_accept(gobj(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<Socket> Socket::accept()
{
  GError* gerror = 0;
  Glib::RefPtr<Socket> retvalue = Glib::wrap(g_socket_accept(gobj(), 0, &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

void Socket::connect(const Glib::RefPtr<SocketAddress>& address, const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = 0;
  g_socket_connect(gobj(), const_cast<GSocketAddress*>(Glib::unwrap(address)), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

void Socket::connect(const Glib::RefPtr<SocketAddress>& address)
{
  GError* gerror = 0;
  g_socket_connect(gobj(), const_cast<GSocketAddress*>(Glib::unwrap(address)), 0, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

void Socket::check_connect_result()
{
  GError* gerror = 0;
  g_socket_check_connect_result(gobj(), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

gssize Socket::receive(char* buffer, gsize size, const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = 0;
  gssize retvalue = g_socket_receive(gobj(), buffer, size, const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

gssize Socket::receive(char* buffer, gsize size)
{
  GError* gerror = 0;
  gssize retvalue = g_socket_receive(gobj(), buffer, size, 0, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

gssize Socket::send(const gchar* buffer, gsize size, const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = 0;
  gssize retvalue = g_socket_send(gobj(), buffer, size, const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

gssize Socket::send(const gchar* buffer, gsize size)
{
  GError* gerror = 0;
  gssize retvalue = g_socket_send(gobj(), buffer, size, 0, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

gssize Socket::send_to(const Glib::RefPtr<SocketAddress>& address, const char* buffer, gsize size, const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = 0;
  gssize retvalue = g_socket_send_to(gobj(), const_cast<GSocketAddress*>(Glib::unwrap(address)), buffer, size, const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

gssize Socket::send_to(const Glib::RefPtr<SocketAddress>& address, const char* buffer, gsize size)
{
  GError* gerror = 0;
  gssize retvalue = g_socket_send_to(gobj(), const_cast<GSocketAddress*>(Glib::unwrap(address)), buffer, size, 0, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

void Socket::close()
{
  GError* gerror = 0;
  g_socket_close(gobj(), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

bool Socket::is_closed()
{
  return g_socket_is_closed(gobj());
}

void Socket::shutdown(bool shutdown_read, bool shutdown_write)
{
  GError* gerror = 0;
  g_socket_shutdown(gobj(), static_cast<int>(shutdown_read), static_cast<int>(shutdown_write), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

bool Socket::is_connected()
{
  return g_socket_is_connected(gobj());
}

gssize Socket::get_available_bytes() const
{
  return g_socket_get_available_bytes(const_cast<GSocket*>(gobj()));
}

Glib::IOCondition Socket::condition_check(Glib::IOCondition condition)
{
  return ((Glib::IOCondition)(g_socket_condition_check(gobj(), ((GIOCondition)(condition)))));
}

void Socket::condition_wait(Glib::IOCondition condition, const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = 0;
  g_socket_condition_wait(gobj(), ((GIOCondition)(condition)), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

void Socket::condition_wait(Glib::IOCondition condition)
{
  GError* gerror = 0;
  g_socket_condition_wait(gobj(), ((GIOCondition)(condition)), 0, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

void Socket::condition_timed_wait(Glib::IOCondition condition, gint64 timeout, const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = 0;
  g_socket_condition_timed_wait(gobj(), ((GIOCondition)(condition)), timeout, const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

void Socket::condition_timed_wait(Glib::IOCondition condition, gint64 timeout)
{
  GError* gerror = 0;
  g_socket_condition_timed_wait(gobj(), ((GIOCondition)(condition)), timeout, 0, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

void Socket::set_listen_backlog(int backlog)
{
  g_socket_set_listen_backlog(gobj(), backlog);
}

int Socket::get_listen_backlog() const
{
  return g_socket_get_listen_backlog(const_cast<GSocket*>(gobj()));
}

void Socket::set_blocking(bool blocking)
{
  g_socket_set_blocking(gobj(), static_cast<int>(blocking));
}

bool Socket::get_blocking() const
{
  return g_socket_get_blocking(const_cast<GSocket*>(gobj()));
}

void Socket::set_keepalive(bool keepalive)
{
  g_socket_set_keepalive(gobj(), static_cast<int>(keepalive));
}

bool Socket::get_keepalive() const
{
  return g_socket_get_keepalive(const_cast<GSocket*>(gobj()));
}

SocketFamily Socket::get_family() const
{
  return ((SocketFamily)(g_socket_get_family(const_cast<GSocket*>(gobj()))));
}

int Socket::get_fd() const
{
  return g_socket_get_fd(const_cast<GSocket*>(gobj()));
}

Glib::RefPtr<SocketAddress> Socket::get_local_address() const
{
  GError* gerror = 0;
  Glib::RefPtr<SocketAddress> retvalue = Glib::wrap(g_socket_get_local_address(const_cast<GSocket*>(gobj()), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<SocketAddress> Socket::get_remote_address() const
{
  GError* gerror = 0;
  Glib::RefPtr<SocketAddress> retvalue = Glib::wrap(g_socket_get_remote_address(const_cast<GSocket*>(gobj()), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

SocketProtocol Socket::get_protocol() const
{
  return ((SocketProtocol)(g_socket_get_protocol(const_cast<GSocket*>(gobj()))));
}

SocketType Socket::get_socket_type() const
{
  return ((SocketType)(g_socket_get_socket_type(const_cast<GSocket*>(gobj()))));
}

bool Socket::speaks_ipv4() const
{
  return g_socket_speaks_ipv4(const_cast<GSocket*>(gobj()));
}

Glib::RefPtr<Credentials> Socket::get_credentials()
{
  GError* gerror = 0;
  Glib::RefPtr<Credentials> retvalue = Glib::wrap(g_socket_get_credentials(gobj(), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<const Credentials> Socket::get_credentials() const
{
  GError* gerror = 0;
  Glib::RefPtr<const Credentials> retvalue = Glib::wrap(g_socket_get_credentials(const_cast<GSocket*>(gobj()), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

guint Socket::get_timeout() const
{
  return g_socket_get_timeout(const_cast<GSocket*>(gobj()));
}

void Socket::set_timeout(guint timeout)
{
  g_socket_set_timeout(gobj(), timeout);
}

bool Socket::get_option(int level, int optname, int& value) const
{
  GError* gerror = 0;
  bool retvalue = g_socket_get_option(const_cast<GSocket*>(gobj()), level, optname, &(value), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool Socket::set_option(int level, int optname, int value)
{
  GError* gerror = 0;
  bool retvalue = g_socket_set_option(gobj(), level, optname, value, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

guint Socket::get_ttl() const
{
  return g_socket_get_ttl(const_cast<GSocket*>(gobj()));
}

void Socket::set_ttl(guint ttl)
{
  g_socket_set_ttl(gobj(), ttl);
}

bool Socket::get_broadcast() const
{
  return g_socket_get_broadcast(const_cast<GSocket*>(gobj()));
}

void Socket::set_broadcast(bool broadcast)
{
  g_socket_set_broadcast(gobj(), static_cast<int>(broadcast));
}

bool Socket::get_multicast_loopback() const
{
  return g_socket_get_multicast_loopback(const_cast<GSocket*>(gobj()));
}

void Socket::set_multicast_loopback(bool loopback)
{
  g_socket_set_multicast_loopback(gobj(), static_cast<int>(loopback));
}

guint Socket::get_multicast_ttl() const
{
  return g_socket_get_multicast_ttl(const_cast<GSocket*>(gobj()));
}

void Socket::set_multicast_ttl(guint ttl)
{
  g_socket_set_multicast_ttl(gobj(), ttl);
}

bool Socket::join_multicast_group(const Glib::RefPtr<InetAddress>& group, bool source_specific, const std::string& iface)
{
  GError* gerror = 0;
  bool retvalue = g_socket_join_multicast_group(gobj(), const_cast<GInetAddress*>(Glib::unwrap(group)), static_cast<int>(source_specific), iface.empty() ? 0 : iface.c_str(), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool Socket::join_multicast_group(const Glib::RefPtr<InetAddress>& group, bool source_specific)
{
  GError* gerror = 0;
  bool retvalue = g_socket_join_multicast_group(gobj(), const_cast<GInetAddress*>(Glib::unwrap(group)), static_cast<int>(source_specific), 0, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool Socket::leave_multicast_group(const Glib::RefPtr<InetAddress>& group, bool source_specific, const std::string& iface)
{
  GError* gerror = 0;
  bool retvalue = g_socket_leave_multicast_group(gobj(), const_cast<GInetAddress*>(Glib::unwrap(group)), static_cast<int>(source_specific), iface.empty() ? 0 : iface.c_str(), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool Socket::leave_multicast_group(const Glib::RefPtr<InetAddress>& group, bool source_specific)
{
  GError* gerror = 0;
  bool retvalue = g_socket_leave_multicast_group(gobj(), const_cast<GInetAddress*>(Glib::unwrap(group)), static_cast<int>(source_specific), 0, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}


#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< bool > Socket::property_blocking() 
{
  return Glib::PropertyProxy< bool >(this, "blocking");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< bool > Socket::property_blocking() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "blocking");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< SocketFamily > Socket::property_family() const
{
  return Glib::PropertyProxy_ReadOnly< SocketFamily >(this, "family");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< int > Socket::property_fd() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "fd");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< bool > Socket::property_keepalive() 
{
  return Glib::PropertyProxy< bool >(this, "keepalive");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< bool > Socket::property_keepalive() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "keepalive");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< int > Socket::property_listen_backlog() 
{
  return Glib::PropertyProxy< int >(this, "listen-backlog");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< int > Socket::property_listen_backlog() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "listen-backlog");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< Glib::RefPtr<SocketAddress> > Socket::property_local_address() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<SocketAddress> >(this, "local-address");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< Glib::RefPtr<SocketAddress> > Socket::property_remote_address() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<SocketAddress> >(this, "remote-address");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< guint > Socket::property_timeout() 
{
  return Glib::PropertyProxy< guint >(this, "timeout");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< guint > Socket::property_timeout() const
{
  return Glib::PropertyProxy_ReadOnly< guint >(this, "timeout");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< SocketProtocol > Socket::property_protocol() const
{
  return Glib::PropertyProxy_ReadOnly< SocketProtocol >(this, "protocol");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< bool > Socket::property_broadcast() 
{
  return Glib::PropertyProxy< bool >(this, "broadcast");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< bool > Socket::property_broadcast() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "broadcast");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< SocketType > Socket::property_type() const
{
  return Glib::PropertyProxy_ReadOnly< SocketType >(this, "type");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< guint > Socket::property_ttl() 
{
  return Glib::PropertyProxy< guint >(this, "ttl");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< guint > Socket::property_ttl() const
{
  return Glib::PropertyProxy_ReadOnly< guint >(this, "ttl");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< bool > Socket::property_multicast_loopback() 
{
  return Glib::PropertyProxy< bool >(this, "multicast-loopback");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< bool > Socket::property_multicast_loopback() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "multicast-loopback");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< guint > Socket::property_multicast_ttl() 
{
  return Glib::PropertyProxy< guint >(this, "multicast-ttl");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< guint > Socket::property_multicast_ttl() const
{
  return Glib::PropertyProxy_ReadOnly< guint >(this, "multicast-ttl");
}
#endif //GLIBMM_PROPERTIES_ENABLED


} // namespace Gio


