/*  Glimmer - getprefs.c
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "declarations.h"
#include "getprefs.h"
#include "colors.h"
#include "color-settings.h"
#include "main.h"
#include "searches.h"
#include "settings.h"
#include "session.h"
#include "syntax-highlight.h"

void get_prefs(void)
{
   gchar *text;
   build_defaults();
   if(!gnome_config_has_section("/" PACKAGE "/General")) save_defaults();

   text = gnome_config_get_string("/" PACKAGE "/General/default_dir");
   strcpy(general_preferences.default_dir, text);
   g_free(text);

   text = gnome_config_get_string("/" PACKAGE "/General/projects_dir");
   strcpy(general_preferences.projects_dir, text);
   g_free(text);

   general_preferences.save_toolbars = gnome_config_get_int("/" PACKAGE "/General/save_toolbars=1");
   general_preferences.save_session = gnome_config_get_int("/" PACKAGE "/General/save_session=1");
   general_preferences.open_session = gnome_config_get_int("/" PACKAGE "/General/open_session=1");

   text = gnome_config_get_string("/" PACKAGE "/General/session_name");
   if(text && general_preferences.open_session) { g_free(session_file); session_file = text; }
   else g_free(text);

   general_preferences.history = gnome_config_get_int("/" PACKAGE "/General/history_items=15");
   general_preferences.undo_max = gnome_config_get_int("/" PACKAGE "/General/undo_max=20");
   general_preferences.notebook_tab_position = gnome_config_get_int("/" PACKAGE "/General/tab_position=0");

   text = gnome_config_get_string("/" PACKAGE "/Build/terminal");
   if(text && strlen(text) > 0)
   {
      strcpy(general_preferences.terminal, text);
      g_free(text);
   }
   text = gnome_config_get_string("/" PACKAGE "/Build/make");
   if(text && strlen(text) > 0)
   {
      strcpy(general_preferences.make, text);
      g_free(text);
   }

   text = gnome_config_get_string("/" PACKAGE "/User Settings/name");
   if(text && strlen(text) > 0)
   {
      strcpy(general_preferences.name, text);
      g_free(text);
   }
   text = gnome_config_get_string("/" PACKAGE "/User Settings/email");
   if(text && strlen(text) > 0)
   {
      strcpy(general_preferences.email, text);
      g_free(text);
   }

   text = gnome_config_get_string("/" PACKAGE "/Fonts/font_name");
   if(text && strlen(text) > 0)
   {
      strcpy(general_preferences.font_name, text);
      g_free(text);
   }
   text = gnome_config_get_string("/" PACKAGE "/Fonts/italic_name");
   if(text && strlen(text) > 0)
   {
      strcpy(general_preferences.italic_name, text);
      g_free(text);
   }
   text = gnome_config_get_string("/" PACKAGE "/Fonts/bold_name");
   if(text && strlen(text) > 0)
   {
      strcpy(general_preferences.bold_name, text);
      g_free(text);
   }
   text = gnome_config_get_string("/" PACKAGE "/Fonts/boldi_name");
   if(text && strlen(text) > 0)
   {
      strcpy(general_preferences.boldi_name, text);
      g_free(text);
   }
   general_preferences.use_gtk_theme = gnome_config_get_int("/" PACKAGE "/Colors/use_gtk_theme");
   general_preferences.bg.red = gnome_config_get_int("/" PACKAGE "/Colors/bg.red");
   general_preferences.bg.green = gnome_config_get_int("/" PACKAGE "/Colors/bg.green");
   general_preferences.bg.blue = gnome_config_get_int("/" PACKAGE "/Colors/bg.blue");
   general_preferences.fg.red = gnome_config_get_int("/" PACKAGE "/Colors/fg.red");
   general_preferences.fg.green = gnome_config_get_int("/" PACKAGE "/Colors/fg.green");
   general_preferences.fg.blue = gnome_config_get_int("/" PACKAGE "/Colors/fg.blue");
   general_preferences.s_bg.red = gnome_config_get_int("/" PACKAGE "/Colors/s_bg.red");
   general_preferences.s_bg.green = gnome_config_get_int("/" PACKAGE "/Colors/s_bg.green");
   general_preferences.s_bg.blue = gnome_config_get_int("/" PACKAGE "/Colors/s_bg.blue");
   general_preferences.bm_bg.red = gnome_config_get_int("/" PACKAGE "/Colors/bm_bg.red");
   general_preferences.bm_bg.green = gnome_config_get_int("/" PACKAGE "/Colors/bm_bg.green");
   general_preferences.bm_bg.blue = gnome_config_get_int("/" PACKAGE "/Colors/bm_bg.blue");
   general_preferences.gutter_bg.red = gnome_config_get_int("/" PACKAGE "/Colors/gutter_bg.red");
   general_preferences.gutter_bg.green = gnome_config_get_int("/" PACKAGE "/Colors/gutter_bg.green");
   general_preferences.gutter_bg.blue = gnome_config_get_int("/" PACKAGE "/Colors/gutter_bg.blue");

   text = gnome_config_get_string("/" PACKAGE "/Background/background");
   if(text && strlen(text) > 0)
   {
      strcpy(general_preferences.pixmap_name, text);
      g_free(text);
   }

   general_preferences.full_filenames_title = gnome_config_get_int("/" PACKAGE "/File Settings/full_filenames_title=0");
   general_preferences.full_filenames = gnome_config_get_int("/" PACKAGE "/File Settings/full_filenames=0");
   general_preferences.close_all = gnome_config_get_int("/" PACKAGE "/File Settings/close_all=1");
   general_preferences.untitled = gnome_config_get_int("/" PACKAGE "/File Settings/untitled=1");
   general_preferences.draw_numbers = gnome_config_get_int("/" PACKAGE "/File Settings/draw_numbers=0");
   general_preferences.draw_pixmaps = gnome_config_get_int("/" PACKAGE "/File Settings/draw_pixmaps=0");
   general_preferences.cursor_blink = gnome_config_get_int("/" PACKAGE "/File Settings/cursor_blink=1");
   general_preferences.full_selection = gnome_config_get_int("/" PACKAGE "/File Settings/full_selection=1");
   general_preferences.bracketmatch = gnome_config_get_int("/" PACKAGE "/File Settings/bracketmatch=1");
   general_preferences.select_line = gnome_config_get_int("/" PACKAGE "/File Settings/select_line=0");
   general_preferences.syntax = gnome_config_get_int("/" PACKAGE "/File Settings/syntax=1");
   general_preferences.auto_indent = gnome_config_get_int("/" PACKAGE "/File Settings/auto_indent=1");
   general_preferences.tab_stops = gnome_config_get_int("/" PACKAGE "/File Settings/tab_stops=1");
   general_preferences.use_spaces = gnome_config_get_int("/" PACKAGE "/File Settings/use_spaces=0");
   general_preferences.spaces = gnome_config_get_int("/" PACKAGE "/File Settings/spaces=4");

   general_preferences.geometry = gnome_config_get_int("/" PACKAGE "/Geometry/use");
   general_preferences.x = gnome_config_get_int("/" PACKAGE "/Geometry/x");
   general_preferences.y = gnome_config_get_int("/" PACKAGE "/Geometry/y");
   general_preferences.w = gnome_config_get_int("/" PACKAGE "/Geometry/w");
   general_preferences.h = gnome_config_get_int("/" PACKAGE "/Geometry/h");

   text = gnome_config_get_string("/" PACKAGE "/Print Settings/print_font");
   if(text && strlen(text) > 0)
   {
      strcpy(general_preferences.print_font, text);
      g_free(text);
   }

   general_preferences.print_landscape = gnome_config_get_int("/" PACKAGE "/Print Settings/print_landscape=0");
   general_preferences.print_header = gnome_config_get_int("/" PACKAGE "/Print Settings/print_header=1");
   general_preferences.print_with_wrap = gnome_config_get_int("/" PACKAGE "/Print Settings/print_with_wrap=0");
   general_preferences.print_numbers = gnome_config_get_int("/" PACKAGE "/Print Settings/print_numbers=1");
   general_preferences.print_every_n_lines = gnome_config_get_int("/" PACKAGE "/Print Settings/print_every_n_lines=1");

   case_sensitive = gnome_config_get_int("/" PACKAGE "/Find-Replace/case_sensitive=0");
   search_style = gnome_config_get_int("/" PACKAGE "/Find-Replace/search_style=0");
   search_start = gnome_config_get_int("/" PACKAGE "/Find-Replace/search_start=0");
   search_multi = gnome_config_get_int("/" PACKAGE "/Find-Replace/search_multi=0");
   keep_open = gnome_config_get_int("/" PACKAGE "/Find-Replace/keep_open=0");
}

void save_prefs(void)
{
   gchar *text;
   text = general_preferences.default_dir;
   gnome_config_set_string("/" PACKAGE "/General/default_dir", text);
   text = general_preferences.projects_dir;
   gnome_config_set_string("/" PACKAGE "/General/projects_dir", text);
   gnome_config_set_int("/" PACKAGE "/General/save_toolbars", general_preferences.save_toolbars);
   gnome_config_set_int("/" PACKAGE "/General/save_session", general_preferences.save_session);
   gnome_config_set_int("/" PACKAGE "/General/open_session", general_preferences.open_session);
   gnome_config_set_int("/" PACKAGE "/General/history_items", general_preferences.history);
   gnome_config_set_int("/" PACKAGE "/General/undo_max", general_preferences.undo_max);
   gnome_config_set_int("/" PACKAGE "/General/tab_position", general_preferences.notebook_tab_position);

   text = general_preferences.terminal;
   gnome_config_set_string("/" PACKAGE "/Build/terminal", text);
   text = general_preferences.make;
   gnome_config_set_string("/" PACKAGE "/Build/make", text);

   text = general_preferences.name;
   gnome_config_set_string("/" PACKAGE "/User Settings/name", text);
   text = general_preferences.email;
   gnome_config_set_string("/" PACKAGE "/User Settings/email", text);

   text = general_preferences.font_name;
   gnome_config_set_string("/" PACKAGE "/Fonts/font_name", text);
   text = general_preferences.italic_name;
   gnome_config_set_string("/" PACKAGE "/Fonts/italic_name", text);
   text = general_preferences.bold_name;
   gnome_config_set_string("/" PACKAGE "/Fonts/bold_name", text);
   text = general_preferences.boldi_name;
   gnome_config_set_string("/" PACKAGE "/Fonts/boldi_name", text);

   gnome_config_set_int("/" PACKAGE "/Colors/use_gtk_theme", general_preferences.use_gtk_theme);
   gnome_config_set_int("/" PACKAGE "/Colors/bg.red", general_preferences.bg.red);
   gnome_config_set_int("/" PACKAGE "/Colors/bg.green", general_preferences.bg.green);
   gnome_config_set_int("/" PACKAGE "/Colors/bg.blue", general_preferences.bg.blue);
   gnome_config_set_int("/" PACKAGE "/Colors/fg.red", general_preferences.fg.red);
   gnome_config_set_int("/" PACKAGE "/Colors/fg.green", general_preferences.fg.green);
   gnome_config_set_int("/" PACKAGE "/Colors/fg.blue", general_preferences.fg.blue);
   gnome_config_set_int("/" PACKAGE "/Colors/s_bg.red", general_preferences.s_bg.red);
   gnome_config_set_int("/" PACKAGE "/Colors/s_bg.green", general_preferences.s_bg.green);
   gnome_config_set_int("/" PACKAGE "/Colors/s_bg.blue", general_preferences.s_bg.blue);
   gnome_config_set_int("/" PACKAGE "/Colors/bm_bg.red", general_preferences.bm_bg.red);
   gnome_config_set_int("/" PACKAGE "/Colors/bm_bg.green", general_preferences.bm_bg.green);
   gnome_config_set_int("/" PACKAGE "/Colors/bm_bg.blue", general_preferences.bm_bg.blue);
   gnome_config_set_int("/" PACKAGE "/Colors/gutter_bg.red", general_preferences.gutter_bg.red);
   gnome_config_set_int("/" PACKAGE "/Colors/gutter_bg.green", general_preferences.gutter_bg.green);
   gnome_config_set_int("/" PACKAGE "/Colors/gutter_bg.blue", general_preferences.gutter_bg.blue);

   text = general_preferences.pixmap_name;
   gnome_config_set_string("/" PACKAGE "/Background/background", text);

   gnome_config_set_int("/" PACKAGE "/File Settings/full_filenames_title", general_preferences.full_filenames_title);
   gnome_config_set_int("/" PACKAGE "/File Settings/full_filenames", general_preferences.full_filenames);
   gnome_config_set_int("/" PACKAGE "/File Settings/close_all", general_preferences.close_all);
   gnome_config_set_int("/" PACKAGE "/File Settings/untitled", general_preferences.untitled);
   gnome_config_set_int("/" PACKAGE "/File Settings/draw_numbers", general_preferences.draw_numbers);
   gnome_config_set_int("/" PACKAGE "/File Settings/draw_pixmaps", general_preferences.draw_pixmaps);
   gnome_config_set_int("/" PACKAGE "/File Settings/cursor_blink", general_preferences.cursor_blink);
   gnome_config_set_int("/" PACKAGE "/File Settings/full_selection", general_preferences.full_selection);
   gnome_config_set_int("/" PACKAGE "/File Settings/bracketmatch", general_preferences.bracketmatch);
   gnome_config_set_int("/" PACKAGE "/File Settings/select_line", general_preferences.select_line);
   gnome_config_set_int("/" PACKAGE "/File Settings/syntax", general_preferences.syntax);
   gnome_config_set_int("/" PACKAGE "/File Settings/auto_indent", general_preferences.auto_indent);
   gnome_config_set_int("/" PACKAGE "/File Settings/tab_stops", general_preferences.tab_stops);
   gnome_config_set_int("/" PACKAGE "/File Settings/use_spaces", general_preferences.use_spaces);
   gnome_config_set_int("/" PACKAGE "/File Settings/spaces", general_preferences.spaces);

   gnome_config_set_int("/" PACKAGE "/Geometry/use", general_preferences.geometry);
   gnome_config_set_int("/" PACKAGE "/Geometry/x", general_preferences.x);
   gnome_config_set_int("/" PACKAGE "/Geometry/y", general_preferences.y);
   gnome_config_set_int("/" PACKAGE "/Geometry/w", general_preferences.w);
   gnome_config_set_int("/" PACKAGE "/Geometry/h", general_preferences.h);

   text = general_preferences.print_font;
   gnome_config_set_string("/" PACKAGE "/Print Settings/print_font", text);
   gnome_config_set_int("/" PACKAGE "/Print Settings/print_landscape", general_preferences.print_landscape);
   gnome_config_set_int("/" PACKAGE "/Print Settings/print_header", general_preferences.print_header);
   gnome_config_set_int("/" PACKAGE "/Print Settings/print_with_wrap", general_preferences.print_with_wrap);
   gnome_config_set_int("/" PACKAGE "/Print Settings/print_numbers", general_preferences.print_numbers);
   gnome_config_set_int("/" PACKAGE "/Print Settings/print_every_n_lines", general_preferences.print_every_n_lines);
   gnome_config_sync();
}

void save_defaults(void)
{
   gchar *text;
   text = default_preferences.default_dir;
   gnome_config_set_string("/" PACKAGE "/General/default_dir", text);
   text = default_preferences.projects_dir;
   gnome_config_set_string("/" PACKAGE "/General/projects_dir", text);
   gnome_config_set_int("/" PACKAGE "/General/save_toolbars", default_preferences.save_toolbars);
   gnome_config_set_int("/" PACKAGE "/General/save_session", default_preferences.save_session);
   gnome_config_set_int("/" PACKAGE "/General/open_session", default_preferences.open_session);
   gnome_config_set_int("/" PACKAGE "/General/history_items", default_preferences.history);
   gnome_config_set_int("/" PACKAGE "/General/undo_max", default_preferences.undo_max);
   gnome_config_set_int("/" PACKAGE "/General/tab_position", default_preferences.notebook_tab_position);   

   text = default_preferences.terminal;
   gnome_config_set_string("/" PACKAGE "/Build/terminal", text);
   text = default_preferences.make;
   gnome_config_set_string("/" PACKAGE "/Build/make", text);

   text = default_preferences.name;
   gnome_config_set_string("/" PACKAGE "/User Settings/name", text);
   text = default_preferences.email;
   gnome_config_set_string("/" PACKAGE "/User Settings/email", text);

   text = default_preferences.font_name;
   gnome_config_set_string("/" PACKAGE "/Fonts/font_name", text);
   text = default_preferences.italic_name;
   gnome_config_set_string("/" PACKAGE "/Fonts/italic_name", text);
   text = default_preferences.bold_name;
   gnome_config_set_string("/" PACKAGE "/Fonts/bold_name", text);
   text = default_preferences.boldi_name;
   gnome_config_set_string("/" PACKAGE "/Fonts/boldi_name", text);

   gnome_config_set_int("/" PACKAGE "/Colors/use_gtk_theme", default_preferences.use_gtk_theme);
   gnome_config_set_int("/" PACKAGE "/Colors/bg.red", default_preferences.bg.red);
   gnome_config_set_int("/" PACKAGE "/Colors/bg.green", default_preferences.bg.green);
   gnome_config_set_int("/" PACKAGE "/Colors/bg.blue", default_preferences.bg.blue);
   gnome_config_set_int("/" PACKAGE "/Colors/fg.red", default_preferences.fg.red);
   gnome_config_set_int("/" PACKAGE "/Colors/fg.green", default_preferences.fg.green);
   gnome_config_set_int("/" PACKAGE "/Colors/fg.blue", default_preferences.fg.blue);
   gnome_config_set_int("/" PACKAGE "/Colors/s_bg.red", default_preferences.s_bg.red);
   gnome_config_set_int("/" PACKAGE "/Colors/s_bg.green", default_preferences.s_bg.green);
   gnome_config_set_int("/" PACKAGE "/Colors/s_bg.blue", default_preferences.s_bg.blue);
   gnome_config_set_int("/" PACKAGE "/Colors/bm_bg.red", default_preferences.bm_bg.red);
   gnome_config_set_int("/" PACKAGE "/Colors/bm_bg.green", default_preferences.bm_bg.green);
   gnome_config_set_int("/" PACKAGE "/Colors/bm_bg.blue", default_preferences.bm_bg.blue);
   gnome_config_set_int("/" PACKAGE "/Colors/gutter_bg.red", default_preferences.gutter_bg.red);
   gnome_config_set_int("/" PACKAGE "/Colors/gutter_bg.green", default_preferences.gutter_bg.green);
   gnome_config_set_int("/" PACKAGE "/Colors/gutter_bg.blue", default_preferences.gutter_bg.blue);

   text = default_preferences.pixmap_name;
   gnome_config_set_string("/" PACKAGE "/Background/background", text);

   gnome_config_set_int("/" PACKAGE "/File Settings/full_filenames_title", default_preferences.full_filenames_title);
   gnome_config_set_int("/" PACKAGE "/File Settings/full_filenames", default_preferences.full_filenames);
   gnome_config_set_int("/" PACKAGE "/File Settings/close_all", default_preferences.close_all);
   gnome_config_set_int("/" PACKAGE "/File Settings/untitled", default_preferences.untitled);
   gnome_config_set_int("/" PACKAGE "/File Settings/draw_numbers", default_preferences.draw_numbers);
   gnome_config_set_int("/" PACKAGE "/File Settings/draw_pixmaps", default_preferences.draw_pixmaps);
   gnome_config_set_int("/" PACKAGE "/File Settings/cursor_blink", default_preferences.cursor_blink);
   gnome_config_set_int("/" PACKAGE "/File Settings/full_selection", default_preferences.full_selection);
   gnome_config_set_int("/" PACKAGE "/File Settings/bracketmatch", default_preferences.bracketmatch);
   gnome_config_set_int("/" PACKAGE "/File Settings/select_line", default_preferences.select_line);
   gnome_config_set_int("/" PACKAGE "/File Settings/syntax", default_preferences.syntax);
   gnome_config_set_int("/" PACKAGE "/File Settings/auto_indent", default_preferences.auto_indent);
   gnome_config_set_int("/" PACKAGE "/File Settings/tab_stops", default_preferences.tab_stops);
   gnome_config_set_int("/" PACKAGE "/File Settings/use_spaces", default_preferences.use_spaces);
   gnome_config_set_int("/" PACKAGE "/File Settings/spaces", default_preferences.spaces);

   gnome_config_set_int("/" PACKAGE "/Geometry/use", default_preferences.geometry);
   gnome_config_set_int("/" PACKAGE "/Geometry/x", default_preferences.x);
   gnome_config_set_int("/" PACKAGE "/Geometry/y", default_preferences.y);
   gnome_config_set_int("/" PACKAGE "/Geometry/w", default_preferences.w);
   gnome_config_set_int("/" PACKAGE "/Geometry/h", default_preferences.h);

   text = default_preferences.print_font;
   gnome_config_set_string("/" PACKAGE "/Print Settings/print_font", text);
   gnome_config_set_int("/" PACKAGE "/Print Settings/print_landscape", default_preferences.print_landscape);
   gnome_config_set_int("/" PACKAGE "/Print Settings/print_header", default_preferences.print_header);
   gnome_config_set_int("/" PACKAGE "/Print Settings/print_with_wrap", default_preferences.print_with_wrap);
   gnome_config_set_int("/" PACKAGE "/Print Settings/print_numbers", default_preferences.print_numbers);
   gnome_config_set_int("/" PACKAGE "/Print Settings/print_every_n_lines", default_preferences.print_every_n_lines);
   gnome_config_sync();
}

void save_session_pref(void)
{
   gnome_config_set_string("/" PACKAGE "/General/session_name", session_file);
   gnome_config_sync();
}

void build_defaults(void)
{
   GtkWidget *win;
   GtkWidget *text_widget;
   GtkStyle *style;
   gchar *home = NULL;
   gchar *user = NULL;
   gchar *hostname = NULL;
   home = getenv("HOME");
   user = getenv("USER");
   hostname = getenv("HOSTNAME");
   strncpy(default_preferences.default_dir, home, sizeof(default_preferences.default_dir));
   g_snprintf(default_preferences.projects_dir, sizeof(default_preferences.projects_dir), "%s/Projects", home);
   strcpy(default_preferences.terminal, "xterm -e");
   strcpy(general_preferences.terminal, "xterm -e");
   strcpy(default_preferences.make, "make");
   strcpy(general_preferences.make, "make");
   strncpy(default_preferences.name, user ? user : "user", sizeof(default_preferences.name));
   g_snprintf(default_preferences.email, sizeof(default_preferences.email), "%s@%s", user ? user:"user", hostname ? hostname : "localhost");
   default_preferences.save_toolbars = TRUE;
   default_preferences.save_session = TRUE;
   default_preferences.open_session = TRUE;
   default_preferences.history = 15;
   default_preferences.undo_max = 20;
   default_preferences.notebook_tab_position = GTK_POS_TOP;
   default_preferences.use_gtk_theme = FALSE;
   default_preferences.font = general_preferences.font = NULL;
   strcpy(default_preferences.font_name, "-adobe-courier-medium-r-normal-*-17-*-*-*-m-*-iso8859-1");
   strcpy(general_preferences.font_name, default_preferences.font_name);
   default_preferences.italic = general_preferences.italic = NULL;
   strcpy(default_preferences.italic_name, "-adobe-courier-medium-o-normal-*-17-*-*-*-m-*-iso8859-1");
   strcpy(general_preferences.italic_name, default_preferences.italic_name);
   default_preferences.bold = general_preferences.bold = NULL;
   strcpy(default_preferences.bold_name, "-adobe-courier-bold-r-normal-*-17-*-*-*-m-*-iso8859-1");
   strcpy(general_preferences.bold_name, default_preferences.bold_name);
   default_preferences.boldi = general_preferences.boldi = NULL;
   strcpy(default_preferences.boldi_name, "-adobe-courier-bold-o-normal-*-17-*-*-*-m-*-iso8859-1");
   strcpy(general_preferences.boldi_name, default_preferences.boldi_name);
   win = gtk_window_new(GTK_WINDOW_DIALOG);
   text_widget = gtk_text_new(0, 0);
   gtk_container_add(GTK_CONTAINER(win), text_widget);
   gtk_widget_realize(text_widget);
   style = text_widget->style;
   default_preferences.fg = general_preferences.fg = style->text[GTK_STATE_NORMAL];
   default_preferences.bg = general_preferences.bg = style->bg[GTK_STATE_NORMAL];
   default_preferences.s_bg = general_preferences.s_bg = style->bg[GTK_STATE_SELECTED];
   default_preferences.bm_bg = general_preferences.bm_bg = style->bg[GTK_STATE_PRELIGHT];
   default_preferences.gutter_bg = general_preferences.gutter_bg = style->bg[GTK_STATE_INSENSITIVE];
   DefaultCache.colors[DEFAULT] = HighlightCache.colors[DEFAULT] = default_preferences.fg;
   gtk_widget_destroy(win);
   default_preferences.bg_pixmap = general_preferences.bg_pixmap = NULL;
   strcpy(default_preferences.pixmap_name, "");
   strcpy(general_preferences.pixmap_name, default_preferences.pixmap_name);

   default_preferences.full_filenames_title = FALSE;
   default_preferences.full_filenames = FALSE;
   default_preferences.close_all = FALSE;
   default_preferences.untitled = TRUE;
   default_preferences.draw_numbers = FALSE;
   default_preferences.draw_pixmaps = FALSE;
   default_preferences.cursor_blink = TRUE;
   default_preferences.full_selection = FALSE;
   default_preferences.bracketmatch = TRUE;
   default_preferences.select_line = FALSE;
   default_preferences.syntax = TRUE;
   default_preferences.auto_indent = TRUE;
   default_preferences.tab_stops = FALSE;
   default_preferences.use_spaces = FALSE;
   default_preferences.spaces = 4;
   default_preferences.geometry = 0;
   default_preferences.x = 0;
   default_preferences.y = 0;
   default_preferences.w = 750;
   default_preferences.h = 450;
   strcpy(default_preferences.print_font, "Courier 12.000000");
   strcpy(general_preferences.print_font, default_preferences.print_font);
   default_preferences.print_landscape = 0;
   default_preferences.print_header = 1;
   default_preferences.print_with_wrap = 0;
   default_preferences.print_numbers = 1;
   default_preferences.print_every_n_lines = 1;
}

void get_saved_colors(void)
{
   gchar string[256];
   gchar *text;
   HighlightInfo *info = NULL;
   gint i = 0;

   build_default_colors();
   if(!gnome_config_has_section("/" PACKAGE "/Highlighting"))
      save_default_colors();

   for(i = 0; i < MAX_COLORS; i++)
   {
      g_snprintf(string, sizeof(string), "/" PACKAGE "/Highlighting/%s.red", editor_color_names[i]);
      HighlightCache.colors[i].red = gnome_config_get_int(string);
      g_snprintf(string, sizeof(string), "/" PACKAGE "/Highlighting/%s.green", editor_color_names[i]);
      HighlightCache.colors[i].green = gnome_config_get_int(string);
      g_snprintf(string, sizeof(string), "/" PACKAGE "/Highlighting/%s.blue", editor_color_names[i]);
      HighlightCache.colors[i].blue = gnome_config_get_int(string);
      g_snprintf(string, sizeof(string), "/" PACKAGE "/Highlighting/%s.class", editor_color_names[i]);
      text = gnome_config_get_string(string);
      if(text)
      {
         info = get_highlight_info(editor_color_names[i], text);
         HighlightCache.fonts[i] = info->font;
         HighlightCache.types[i] = info->type;
         HighlightCache.flags[i] = info->flags;
         g_free(info);
         g_free(text); /* Memprof claims there is a leak here. This line should fix it. */
      }
   }
}

void save_colors(void)
{
   gchar string[256];
   gchar text[4] = "";
   gint count;
   gint i = 0;

   for(i = 0; i < MAX_COLORS; i++)
   {
      g_snprintf(string, sizeof(string), "/" PACKAGE "/Highlighting/%s.red", editor_color_names[i]);
      gnome_config_set_int(string, HighlightCache.colors[i].red);
      g_snprintf(string, sizeof(string), "/" PACKAGE "/Highlighting/%s.green", editor_color_names[i]);
      gnome_config_set_int(string, HighlightCache.colors[i].green);
      g_snprintf(string, sizeof(string), "/" PACKAGE "/Highlighting/%s.blue", editor_color_names[i]);
      gnome_config_set_int(string, HighlightCache.colors[i].blue);
      count = 0;
      text[count] = '\0';
      if(HighlightCache.types[i] == FONT_ITALIC || HighlightCache.types[i] == FONT_BOLD_ITALIC)
         text[count++] = 'i';
      text[count] = '\0';
      if(HighlightCache.types[i] == FONT_BOLD || HighlightCache.types[i] == FONT_BOLD_ITALIC)
         text[count++] = 'b';
      text[count] = '\0';
      if(HighlightCache.flags[i] & GTK_EXTEXT_STYLE_UNDER)
         text[count++] = 'u';
      text[count] = '\0';
      if(HighlightCache.flags[i] & GTK_EXTEXT_STYLE_STRIKE)
         text[count++] = 's';
      text[count] = '\0';
      g_snprintf(string, sizeof(string), "/" PACKAGE "/Highlighting/%s.class", editor_color_names[i]);
      gnome_config_set_string(string, text);
   }
   gnome_config_sync();
}

void save_default_colors(void)
{
   gchar string[256];
   gchar text[4] = "";
   gint count;
   gint i = 0;

   for(i = 0; i < MAX_COLORS; i++)
   {
      g_snprintf(string, sizeof(string), "/" PACKAGE "/Highlighting/%s.red", editor_color_names[i]);
      gnome_config_set_int(string, DefaultCache.colors[i].red);
      g_snprintf(string, sizeof(string), "/" PACKAGE "/Highlighting/%s.green", editor_color_names[i]);
      gnome_config_set_int(string, DefaultCache.colors[i].green);
      g_snprintf(string, sizeof(string), "/" PACKAGE "/Highlighting/%s.blue", editor_color_names[i]);
      gnome_config_set_int(string, DefaultCache.colors[i].blue);
      count = 0;
      text[count] = '\0';
      if(DefaultCache.types[i] == FONT_ITALIC || DefaultCache.types[i] == FONT_BOLD_ITALIC)
         text[count++] = 'i';
      text[count] = '\0';
      if(DefaultCache.types[i] == FONT_BOLD || DefaultCache.types[i] == FONT_BOLD_ITALIC)
         text[count++] = 'b';
      text[count] = '\0';
      if(DefaultCache.flags[i] & GTK_EXTEXT_STYLE_UNDER)
         text[count++] = 'u';
      text[count] = '\0';
      if(DefaultCache.flags[i] & GTK_EXTEXT_STYLE_STRIKE)
         text[count++] = 's';
      text[count] = '\0';
      g_snprintf(string, sizeof(string), "/" PACKAGE "/Highlighting/%s.class", editor_color_names[i]);
      gnome_config_set_string(string, text);
   }
   gnome_config_sync();
}

void build_default_colors(void)
{
   DefaultCache.colors[WHITE].red = 0xFFFF;
   DefaultCache.colors[WHITE].green = 0xFFFF;
   DefaultCache.colors[WHITE].blue = 0xFFFF;
   DefaultCache.fonts[WHITE] = NULL;
   DefaultCache.types[WHITE] = 0;
   DefaultCache.flags[WHITE] = 0;

   DefaultCache.colors[BLACK].red = 0x0000;
   DefaultCache.colors[BLACK].green = 0x0000;
   DefaultCache.colors[BLACK].blue = 0x0000;
   DefaultCache.fonts[BLACK] = NULL;
   DefaultCache.types[BLACK] = 0;
   DefaultCache.flags[BLACK] = 0;

   DefaultCache.colors[GRAY].red = 0x7FFF;
   DefaultCache.colors[GRAY].green = 0x7FFF;
   DefaultCache.colors[GRAY].blue = 0x7FFF;
   DefaultCache.fonts[GRAY] = NULL;
   DefaultCache.types[GRAY] = 0;
   DefaultCache.flags[GRAY] = 0;

   DefaultCache.colors[BLUE].red = 0x0000;
   DefaultCache.colors[BLUE].green = 0x0000;
   DefaultCache.colors[BLUE].blue = 0xFFFF;
   DefaultCache.fonts[BLUE] = NULL;
   DefaultCache.types[BLUE] = 0;
   DefaultCache.flags[BLUE] = 0;

   DefaultCache.colors[DARK_BLUE].red = 0x0000;
   DefaultCache.colors[DARK_BLUE].green = 0x0000;
   DefaultCache.colors[DARK_BLUE].blue = 0x7FFF;
   DefaultCache.fonts[DARK_BLUE] = NULL;
   DefaultCache.types[DARK_BLUE] = 0;
   DefaultCache.flags[DARK_BLUE] = 0;

   DefaultCache.colors[RED].red = 0xFFFF;
   DefaultCache.colors[RED].green = 0x0000;
   DefaultCache.colors[RED].blue = 0x0000;
   DefaultCache.fonts[RED] = NULL;
   DefaultCache.types[RED] = 0;
   DefaultCache.flags[RED] = 0;

   DefaultCache.colors[DARK_RED].red = 0x7FFF;
   DefaultCache.colors[DARK_RED].green = 0x0000;
   DefaultCache.colors[DARK_RED].blue = 0x0000;
   DefaultCache.fonts[DARK_RED] = NULL;
   DefaultCache.types[DARK_RED] = 0;
   DefaultCache.flags[DARK_RED] = 0;

   DefaultCache.colors[GREEN].red = 0x0000;
   DefaultCache.colors[GREEN].green = 0xFFFF;
   DefaultCache.colors[GREEN].blue = 0x0000;
   DefaultCache.fonts[GREEN] = NULL;
   DefaultCache.types[GREEN] = 0;
   DefaultCache.flags[GREEN] = 0;

   DefaultCache.colors[DARK_GREEN].red = 0x0000;
   DefaultCache.colors[DARK_GREEN].green = 0x7FFF;
   DefaultCache.colors[DARK_GREEN].blue = 0x0000;
   DefaultCache.fonts[DARK_GREEN] = NULL;
   DefaultCache.types[DARK_GREEN] = 0;
   DefaultCache.flags[DARK_GREEN] = 0;

   DefaultCache.colors[CYAN].red = 0x0000;
   DefaultCache.colors[CYAN].green = 0xFFFF;
   DefaultCache.colors[CYAN].blue = 0xFFFF;
   DefaultCache.fonts[CYAN] = NULL;
   DefaultCache.types[CYAN] = 0;
   DefaultCache.flags[CYAN] = 0;

   DefaultCache.colors[MAGENTA].red = 0xFFFF;
   DefaultCache.colors[MAGENTA].green = 0x0000;
   DefaultCache.colors[MAGENTA].blue = 0xFFFF;
   DefaultCache.fonts[MAGENTA] = NULL;
   DefaultCache.types[MAGENTA] = 0;
   DefaultCache.flags[MAGENTA] = 0;

   DefaultCache.colors[YELLOW].red = 0xFFFF;
   DefaultCache.colors[YELLOW].green = 0xFFFF;
   DefaultCache.colors[YELLOW].blue = 0x0000;
   DefaultCache.fonts[YELLOW] = NULL;
   DefaultCache.types[YELLOW] = 0;
   DefaultCache.flags[YELLOW] = 0;

   DefaultCache.colors[ORANGE].red = 0xFFFF;
   DefaultCache.colors[ORANGE].green = 0xAF00;
   DefaultCache.colors[ORANGE].blue = 0x0000;
   DefaultCache.fonts[ORANGE] = NULL;
   DefaultCache.types[ORANGE] = 0;
   DefaultCache.flags[ORANGE] = 0;

   DefaultCache.colors[KEYWORD] = DefaultCache.colors[BLUE];
   DefaultCache.fonts[KEYWORD] = get_font(FONT_BOLD);
   DefaultCache.types[KEYWORD] = FONT_BOLD;
   DefaultCache.flags[KEYWORD] = 0;

   DefaultCache.colors[STRING] = DefaultCache.colors[DARK_GREEN];
   DefaultCache.fonts[STRING] = get_font(FONT_NORMAL);
   DefaultCache.types[STRING] = FONT_NORMAL;
   DefaultCache.flags[STRING] = 0;

   DefaultCache.colors[CHAR_STRING] = DefaultCache.colors[DARK_GREEN];
   DefaultCache.fonts[CHAR_STRING] = get_font(FONT_NORMAL);
   DefaultCache.types[CHAR_STRING] = FONT_NORMAL;
   DefaultCache.flags[CHAR_STRING] = 0;

   DefaultCache.colors[S_CHAR] = DefaultCache.colors[DARK_BLUE];
   DefaultCache.fonts[S_CHAR] = get_font(FONT_NORMAL);
   DefaultCache.types[S_CHAR] = FONT_NORMAL;
   DefaultCache.flags[S_CHAR] = 0;

   DefaultCache.colors[COMMENT] = DefaultCache.colors[DARK_GREEN];
   DefaultCache.fonts[COMMENT] = get_font(FONT_ITALIC);
   DefaultCache.types[COMMENT] = FONT_ITALIC;
   DefaultCache.flags[COMMENT] = 0;

   DefaultCache.colors[PREPROCESSOR] = DefaultCache.colors[DARK_RED];
   DefaultCache.fonts[PREPROCESSOR] = get_font(FONT_NORMAL);
   DefaultCache.types[PREPROCESSOR] = FONT_NORMAL;
   DefaultCache.flags[PREPROCESSOR] = 0;

   DefaultCache.colors[DATA_TYPE] = DefaultCache.colors[BLUE];
   DefaultCache.fonts[DATA_TYPE] = get_font(FONT_NORMAL);
   DefaultCache.types[DATA_TYPE] = FONT_NORMAL;
   DefaultCache.flags[DATA_TYPE] = 0;

   DefaultCache.colors[FUNCTION] = DefaultCache.colors[DARK_BLUE];
   DefaultCache.fonts[FUNCTION] = get_font(FONT_NORMAL);
   DefaultCache.types[FUNCTION] = FONT_NORMAL;
   DefaultCache.flags[FUNCTION] = 0;

   DefaultCache.colors[MACRO] = DefaultCache.colors[RED];
   DefaultCache.fonts[MACRO] = get_font(FONT_NORMAL);
   DefaultCache.types[MACRO] = FONT_NORMAL;
   DefaultCache.flags[MACRO] = 0;

   DefaultCache.colors[VARIABLE] = DefaultCache.colors[RED];
   DefaultCache.fonts[VARIABLE] = get_font(FONT_NORMAL);
   DefaultCache.types[VARIABLE] = FONT_NORMAL;
   DefaultCache.flags[VARIABLE] = 0;

   DefaultCache.colors[SYMBOL] = DefaultCache.colors[ORANGE];
   DefaultCache.fonts[SYMBOL] = get_font(FONT_NORMAL);
   DefaultCache.types[SYMBOL] = FONT_NORMAL;
   DefaultCache.flags[SYMBOL] = 0;

   DefaultCache.colors[OPERATOR] = DefaultCache.colors[GREEN];
   DefaultCache.fonts[OPERATOR] = get_font(FONT_NORMAL);
   DefaultCache.types[OPERATOR] = FONT_NORMAL;
   DefaultCache.flags[OPERATOR] = 0;

   DefaultCache.colors[PUNCTUATION] = DefaultCache.colors[YELLOW];
   DefaultCache.fonts[PUNCTUATION] = get_font(FONT_NORMAL);
   DefaultCache.types[PUNCTUATION] = FONT_NORMAL;
   DefaultCache.flags[PUNCTUATION] = 0;

   DefaultCache.colors[DECIMAL] = DefaultCache.colors[CYAN];
   DefaultCache.fonts[DECIMAL] = get_font(FONT_NORMAL);
   DefaultCache.types[DECIMAL] = FONT_NORMAL;
   DefaultCache.flags[DECIMAL] = 0;

   DefaultCache.colors[HEXIDECIMAL] = DefaultCache.colors[RED];
   DefaultCache.fonts[HEXIDECIMAL] = get_font(FONT_NORMAL);
   DefaultCache.types[HEXIDECIMAL] = FONT_NORMAL;
   DefaultCache.flags[HEXIDECIMAL] = 0;

   DefaultCache.colors[OCTAL] = DefaultCache.colors[MAGENTA];
   DefaultCache.fonts[OCTAL] = get_font(FONT_NORMAL);
   DefaultCache.types[OCTAL] = FONT_NORMAL;
   DefaultCache.flags[OCTAL] = 0;

   HighlightCache = DefaultCache;
}
