/*  Glimmer - toolbar.c
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "declarations.h"
#include "toolbar.h"
#include "build.h"
#include "edit.h"
#include "file-io.h"
#include "main.h"
#include "properties.h"
#include "xpm/debug.xpm"

GtkWidget *filebar;
GtkWidget *editbar;
GtkWidget *buildbar;
GtkWidget *highlightbar;
#ifdef WITH_PYTHON
GtkWidget *customnotebook;
GList *custombars = NULL;
GList *custombaritems = NULL;
GtkWidget *custombar;
#endif
GtkWidget *filebar_new;
GtkWidget *filebar_open;
GtkWidget *filebar_close;
GtkWidget *filebar_save;
GtkWidget *filebar_saveas;
GtkWidget *editbar_undo;
GtkWidget *editbar_redo;
GtkWidget *editbar_cut;
GtkWidget *editbar_copy;
GtkWidget *editbar_paste;
GtkWidget *editbar_properties;
GtkWidget *buildbar_compile;
GtkWidget *buildbar_kill_compile;
GtkWidget *buildbar_debug;
GtkWidget *buildbar_kill_debug;
GtkWidget *buildbar_execute;
GtkWidget *buildbar_kill_exec;
GtkWidget *highlightbar_option;

void make_toolbars(void)
{
#ifdef WITH_PYTHON
   GtkWidget *box;
#endif
   GtkWidget *pixmapwid;
   
   filebar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
   gtk_container_set_border_width(GTK_CONTAINER(filebar), 2);
   gtk_toolbar_set_button_relief(GTK_TOOLBAR(filebar), GTK_RELIEF_NONE);
   gtk_widget_show(filebar);

   pixmapwid = gnome_stock_pixmap_widget_at_size(window, GNOME_STOCK_PIXMAP_NEW, 21, 21);
   filebar_new = gtk_toolbar_append_item(GTK_TOOLBAR(filebar), 0, "New source file", 0, pixmapwid, GTK_SIGNAL_FUNC(new_file_cb), 0); 
   pixmapwid = gnome_stock_pixmap_widget_at_size(window, GNOME_STOCK_PIXMAP_OPEN, 21, 21);
   filebar_open = gtk_toolbar_append_item(GTK_TOOLBAR(filebar), 0, "Open source file", 0, pixmapwid, GTK_SIGNAL_FUNC(open_file_cb), 0); 
   pixmapwid = gnome_stock_pixmap_widget_at_size(window, GNOME_STOCK_PIXMAP_CLOSE, 21, 21);
   filebar_close = gtk_toolbar_append_item(GTK_TOOLBAR(filebar), 0, "Close source file", 0, pixmapwid, GTK_SIGNAL_FUNC(close_file_cb), 0); 
   pixmapwid = gnome_stock_pixmap_widget_at_size(window, GNOME_STOCK_PIXMAP_SAVE, 21, 21);
   filebar_save = gtk_toolbar_append_item(GTK_TOOLBAR(filebar), 0, "Save source file", 0, pixmapwid, GTK_SIGNAL_FUNC(save_file_cb), 0); 
   pixmapwid = gnome_stock_pixmap_widget_at_size(window, GNOME_STOCK_PIXMAP_SAVE_AS, 21, 21);
   filebar_saveas = gtk_toolbar_append_item(GTK_TOOLBAR(filebar), 0, "Save source file with new name", 0, pixmapwid, GTK_SIGNAL_FUNC(save_file_as_cb), 0); 
   gnome_app_add_docked(GNOME_APP(app), filebar, "FileBar", GNOME_DOCK_ITEM_BEH_NORMAL, GNOME_DOCK_TOP, 2, 2, 0);

   editbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
   gtk_container_set_border_width(GTK_CONTAINER(editbar), 2);
   gtk_toolbar_set_button_relief(GTK_TOOLBAR(editbar), GTK_RELIEF_NONE);
   gtk_widget_show(editbar);

   pixmapwid = gnome_stock_pixmap_widget_at_size(window, GNOME_STOCK_PIXMAP_UNDO, 21, 21);
   editbar_undo = gtk_toolbar_append_item(GTK_TOOLBAR(editbar), 0, "Undo last action", 0, pixmapwid, GTK_SIGNAL_FUNC(undo_last_cb), 0); 
   pixmapwid = gnome_stock_pixmap_widget_at_size(window, GNOME_STOCK_PIXMAP_REDO, 21, 21);
   editbar_redo = gtk_toolbar_append_item(GTK_TOOLBAR(editbar), 0, "Redo last action", 0, pixmapwid, GTK_SIGNAL_FUNC(redo_last_cb), 0); 
   pixmapwid = gnome_stock_pixmap_widget_at_size(window, GNOME_STOCK_PIXMAP_CUT, 21, 21);
   editbar_cut = gtk_toolbar_append_item(GTK_TOOLBAR(editbar), 0, "Cut selected text", 0, pixmapwid, GTK_SIGNAL_FUNC(cut_text_cb), 0); 
   pixmapwid = gnome_stock_pixmap_widget_at_size(window, GNOME_STOCK_PIXMAP_COPY, 21, 21);
   editbar_copy = gtk_toolbar_append_item(GTK_TOOLBAR(editbar), 0, "Copy selected text", 0, pixmapwid, GTK_SIGNAL_FUNC(copy_text_cb), 0); 
   pixmapwid = gnome_stock_pixmap_widget_at_size(window, GNOME_STOCK_PIXMAP_PASTE, 21, 21);
   editbar_paste = gtk_toolbar_append_item(GTK_TOOLBAR(editbar), 0, "Paste text from clipboard", 0, pixmapwid, GTK_SIGNAL_FUNC(paste_text_cb), 0); 
   pixmapwid = gnome_stock_pixmap_widget_at_size(window, GNOME_STOCK_PIXMAP_PROPERTIES, 21, 21);
   editbar_properties = gtk_toolbar_append_item(GTK_TOOLBAR(editbar), 0, "Edit the properties of a file", 0, pixmapwid, GTK_SIGNAL_FUNC(edit_properties), 0); 
   gnome_app_add_docked(GNOME_APP(app), editbar, "EditBar", GNOME_DOCK_ITEM_BEH_NORMAL, GNOME_DOCK_TOP, 2, 3, 0);

   buildbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
   gtk_container_set_border_width(GTK_CONTAINER(buildbar), 2);
   gtk_toolbar_set_button_relief(GTK_TOOLBAR(buildbar), GTK_RELIEF_NONE);
   gtk_widget_show(buildbar);

   pixmapwid = gnome_stock_pixmap_widget_at_size(window, GNOME_STOCK_PIXMAP_CONVERT, 21, 21);
   buildbar_compile = gtk_toolbar_append_item(GTK_TOOLBAR(buildbar), 0, "Compile current source", 0, pixmapwid, GTK_SIGNAL_FUNC(compile_file_cb), 0);
   pixmapwid = gnome_stock_pixmap_widget_at_size(window, GNOME_STOCK_PIXMAP_STOP, 21, 21);
   buildbar_kill_compile = gtk_toolbar_append_item(GTK_TOOLBAR(buildbar), 0, "Kill the execute process.", 0, pixmapwid, GTK_SIGNAL_FUNC(kill_compile_cb), 0);
   pixmapwid = gnome_pixmap_new_from_xpm_d(debug_xpm);
   buildbar_debug = gtk_toolbar_append_item(GTK_TOOLBAR(buildbar), 0, "Debug current source", 0, pixmapwid, GTK_SIGNAL_FUNC(debug_file_cb), 0);
   pixmapwid = gnome_stock_pixmap_widget_at_size(window, GNOME_STOCK_PIXMAP_STOP, 21, 21);
   buildbar_kill_debug = gtk_toolbar_append_item(GTK_TOOLBAR(buildbar), 0, "Kill the execute process.", 0, pixmapwid, GTK_SIGNAL_FUNC(kill_debug_cb), 0);
   pixmapwid = gnome_stock_pixmap_widget_at_size(window, GNOME_STOCK_PIXMAP_EXEC, 21, 21);
   buildbar_execute = gtk_toolbar_append_item(GTK_TOOLBAR(buildbar), 0, "Execute current file.", 0, pixmapwid, GTK_SIGNAL_FUNC(execute_file_cb), 0);
   pixmapwid = gnome_stock_pixmap_widget_at_size(window, GNOME_STOCK_PIXMAP_STOP, 21, 21);
   buildbar_kill_exec = gtk_toolbar_append_item(GTK_TOOLBAR(buildbar), 0, "Kill the execute process.", 0, pixmapwid, GTK_SIGNAL_FUNC(kill_execute_cb), 0);
   gnome_app_add_docked(GNOME_APP(app), buildbar, "BuildBar", GNOME_DOCK_ITEM_BEH_NORMAL, GNOME_DOCK_TOP, 2, 4, 0);

#ifdef WITH_PYTHON
   box = gtk_hbox_new(FALSE, 0);
   custombar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
   gtk_toolbar_set_button_relief(GTK_TOOLBAR(custombar), GTK_RELIEF_NONE);
   gtk_container_set_border_width(GTK_CONTAINER(custombar), 2);
   gtk_box_pack_start(GTK_BOX(box), custombar, TRUE, TRUE, 0);
   gtk_widget_show(custombar);

   customnotebook = gtk_notebook_new();
   gtk_notebook_set_tab_pos(GTK_NOTEBOOK(customnotebook), GTK_POS_BOTTOM);
   gtk_box_pack_start(GTK_BOX(box), customnotebook, TRUE, TRUE, 0);
   gtk_widget_show(box);
   gnome_app_add_docked(GNOME_APP(app), box, "CustomBar", GNOME_DOCK_ITEM_BEH_NORMAL, GNOME_DOCK_TOP, 3, 2, 0);
#endif
}
