/* GdsTearAway
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU Library General Public License for more details.
*
*  You should have received a copy of the GNU Library General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <string.h>

#ifndef GDS_TEAR_AWAY_H__
#define GDS_TEAR_AWAY_H__
#ifdef __cplusplus
extern "C" {
#endif

#define GDS_TYPE_TEAR_AWAY (gds_tear_away_get_type())
#define GDS_TEAR_AWAY(obj) (GTK_CHECK_CAST ((obj), GDS_TYPE_TEAR_AWAY, GdsTearAway))
#define GDS_TEAR_AWAY_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass), GDS_TYPE_TEAR_AWAY, GdsTearAwayClass))
#define GDS_IS_TEAR_AWAY(obj) (GTK_CHECK_TYPE((obj), GDS_TYPE_TEAR_AWAY))
#define GDS_IS_TEAR_AWAY_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GDS_TYPE_TEAR_AWAY))

typedef struct _GdsTearAway GdsTearAway;
typedef struct _GdsTearAwayClass GdsTearAwayClass;

typedef enum {
   GTK_TYPE_BOOK,
   GTK_TYPE_CONT
}GdsTearAwayParentType;

struct _GdsTearAway {
   GtkBin bin;
   GtkWidget *new_parent;
   gchar *title;
   gchar *label_string;
   GdsTearAwayParentType parent_type;
   gint parent_position;
   gboolean torn;
   GtkPositionType pos;
};

struct _GdsTearAwayClass {
   GtkBinClass parent_class;
   void (* window_focused) (GtkWidget *widget, gpointer data);
   gint (* child_hide) (GtkWidget *widget, GdkEventButton *event);
   gint (* child_show) (GtkWidget *widget, GdkEventButton *event);
   gint (* detaching) (GtkWidget *widget, GdkEventButton *event);
   gint (* detached) (GtkWidget *widget, GdkEventButton *event);
   gint (* attaching) (GtkWidget *widget, GdkEventButton *event);
   gint (* attached) (GtkWidget *widget, GdkEventButton *event);
};

GtkType gds_tear_away_get_type(void);

GtkWidget *gds_tear_away_new(GtkPositionType pos);
void gds_tear_away_set_child(GdsTearAway *tear_away, GtkWidget *child);
void gds_tear_away_bust_a_switch(GdsTearAway *tear_away);
void gds_tear_away_child_reverse_visible(GdsTearAway *tear_away);
void gds_tear_away_set_title(GdsTearAway *tear_away, const gchar *title);

#ifdef __cplusplus /* cpp compatibility */
}
#endif
#endif
