#include "gnomedirentry.h"
#include "gnomedirlist.h"

/* function declarations */
static void gnome_direntry_class_init(GnomeDirEntryClass *_class);
static void gnome_direntry_init(GnomeDirEntry *dir_entry);
GtkWidget *gnome_direntry_new(void);
static void gnome_direntry_destroy(GtkObject *object);
static void change_dir(GtkWidget *widget, GnomeDirEntry *dir_entry);
static void dir_save_change(GtkWidget *widget, GnomeDirEntry *dir_entry);
/* end function declarations */

static GtkHBoxClass *parent_class = NULL;

GtkType gnome_direntry_get_type(void)
{
   static GtkType direntry_type=0;
   if(!direntry_type)
   {
      static const GtkTypeInfo direntry_info = 
      {	
         "GnomeDirEntry",
	 sizeof(GnomeDirEntry),
	 sizeof(GnomeDirEntryClass),
	 (GtkClassInitFunc) gnome_direntry_class_init,
	 (GtkObjectInitFunc) gnome_direntry_init,
	 NULL,
	 NULL,
	 (GtkClassInitFunc)NULL,
      };
      direntry_type = gtk_type_unique(GTK_TYPE_HBOX, &direntry_info);
   }
   return(direntry_type);
}

static void gnome_direntry_class_init(GnomeDirEntryClass *_class)
{
   GtkObjectClass *object_class;
   object_class = (GtkObjectClass*)_class;
   parent_class = gtk_type_class(GTK_TYPE_HBOX);
   object_class->destroy = gnome_direntry_destroy;
}

static void gnome_direntry_init(GnomeDirEntry *dir_entry)
{
   dir_entry->entry = NULL;
   dir_entry->chdir_button = NULL;
   dir_entry->dir_list = NULL;
}

GtkWidget* gnome_direntry_new(void)
{
   GnomeDirEntry *dir_entry;
   dir_entry = gtk_type_new(GNOME_TYPE_DIRENTRY);

   gtk_container_set_border_width(GTK_CONTAINER(dir_entry), 3);

   dir_entry->entry = gtk_entry_new();
   gtk_box_pack_start(GTK_BOX(dir_entry), dir_entry->entry, TRUE, TRUE, 0);
   gtk_widget_show(dir_entry->entry);
   
   dir_entry->chdir_button = gtk_button_new_with_label("...");
   gtk_box_pack_start(GTK_BOX(dir_entry), dir_entry->chdir_button, FALSE, FALSE, 0);
   gtk_signal_connect(GTK_OBJECT(dir_entry->chdir_button), "clicked", GTK_SIGNAL_FUNC(change_dir), dir_entry);
   gtk_widget_show(dir_entry->chdir_button);
   return GTK_WIDGET(dir_entry);
}

static void gnome_direntry_destroy(GtkObject *object)
{
   GtkWidget *dir_entry;
   g_return_if_fail(object != NULL);
   g_return_if_fail(GNOME_IS_DIRENTRY(object));
   dir_entry = GTK_WIDGET(object);
   gtk_widget_destroy(dir_entry);
}

static void change_dir(GtkWidget *widget, GnomeDirEntry *dir_entry)
{
   g_return_if_fail(dir_entry != NULL);
   g_return_if_fail(GNOME_IS_DIRENTRY(dir_entry));
   if(dir_entry->dir_list != NULL)
   {
      gtk_widget_destroy(dir_entry->dir_list);
      dir_entry->dir_list = NULL;
   }
   dir_entry->dir_list = gnome_dirlist_new();
   gtk_signal_connect(GTK_OBJECT(GNOME_DIRLIST(dir_entry->dir_list)->ok_button), "clicked", GTK_SIGNAL_FUNC(dir_save_change), dir_entry);
   gtk_signal_connect_object(GTK_OBJECT(GNOME_DIRLIST(dir_entry->dir_list)->ok_button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(dir_entry->dir_list));
   gtk_signal_connect_object(GTK_OBJECT(GNOME_DIRLIST(dir_entry->dir_list)->cancel_button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(dir_entry->dir_list));
   gtk_widget_show(dir_entry->dir_list);
}

static void dir_save_change(GtkWidget *widget, GnomeDirEntry *dir_entry)
{
   gtk_entry_set_text(GTK_ENTRY(dir_entry->entry), gnome_dirlist_get_dir(GNOME_DIRLIST(dir_entry->dir_list)));
}

gchar *gnome_direntry_get_dir(GnomeDirEntry *dir_entry)
{
   g_return_val_if_fail(dir_entry != NULL, NULL);
   g_return_val_if_fail(GNOME_IS_DIRENTRY(dir_entry), NULL);
   return(gtk_entry_get_text(GTK_ENTRY(dir_entry->entry)));
}

void gnome_direntry_set_dir(GnomeDirEntry *dir_entry, const gchar *dir)
{
   g_return_if_fail(dir_entry != NULL);
   g_return_if_fail(GNOME_IS_DIRENTRY(dir_entry));
   gtk_entry_set_text(GTK_ENTRY(dir_entry->entry), dir);
}
