/*  Glimmer - gnome-password-dialog.c
 *  This library is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Library General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "gnome-password-dialog.h"

/* function declarations */
static void gnome_password_dialog_class_init(GnomePasswordDialogClass *klass);
static void gnome_password_dialog_init(GnomePasswordDialog *dialog);
static void gnome_password_dialog_destroy(GtkObject *object);
static void check_enable_button(GtkWidget *widget, GnomePasswordDialog *dialog);
static void check_activation(GtkWidget *entry, GnomePasswordDialog *dialog);

/* end function declarations */

static GtkWindowClass *parent_class = NULL;

GtkType gnome_password_dialog_get_type(void)
{
   static GtkType password_dialog_type=0;
   if(!password_dialog_type)
   {
      static const GtkTypeInfo password_dialog_info = 
      {	
         "GnomePasswordDialogDialog",
         sizeof(GnomePasswordDialog),
         sizeof(GnomePasswordDialogClass),
         (GtkClassInitFunc) gnome_password_dialog_class_init,
         (GtkObjectInitFunc) gnome_password_dialog_init,
         NULL,
         NULL,
         (GtkClassInitFunc)NULL,
      };
      password_dialog_type = gtk_type_unique(GTK_TYPE_WINDOW, &password_dialog_info);
   }
   return(password_dialog_type);
}

static void gnome_password_dialog_class_init(GnomePasswordDialogClass *klass)
{
   GtkObjectClass *object_class;
   object_class = (GtkObjectClass*)klass;
   parent_class = gtk_type_class(GTK_TYPE_WINDOW);
   object_class->destroy = gnome_password_dialog_destroy;
}

static void gnome_password_dialog_init(GnomePasswordDialog *dialog)
{

}

GtkWidget* gnome_password_dialog_new(gchar *title)
{
   GnomePasswordDialog *dialog = NULL;
   GtkWidget *main_box = NULL;
   GtkWidget *frame = NULL;
   GtkWidget *util_box = NULL;
   GtkWidget *inside_box = NULL;
   GtkWidget *label = NULL;
   GtkWidget *hsep = NULL;

   dialog = (GnomePasswordDialog *)gtk_type_new(GNOME_TYPE_PASSWORD_DIALOG);
   gtk_container_set_border_width(GTK_CONTAINER(dialog), 5);
   gtk_window_set_title(GTK_WINDOW(dialog), title);
   
   main_box = gtk_vbox_new(FALSE, 0);
   gtk_container_add(GTK_CONTAINER(dialog), main_box);
   gtk_widget_show(main_box);

   frame = gtk_frame_new("Authentication");
   gtk_box_pack_start(GTK_BOX(main_box), frame, TRUE, TRUE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(frame), 5);
   gtk_widget_show(frame);

   util_box = gtk_vbox_new(FALSE, 0);
   gtk_container_add(GTK_CONTAINER(frame), util_box);
   gtk_widget_show(util_box);

   inside_box = gtk_hbox_new(FALSE, 0);
   gtk_box_pack_start(GTK_BOX(util_box), inside_box, TRUE, TRUE, 0);
   gtk_widget_show(inside_box);

   label = gtk_label_new("Username:");
   gtk_box_pack_start(GTK_BOX(inside_box), label, FALSE, FALSE, 5);
   gtk_widget_show(label);

   dialog->username_entry = gtk_entry_new();
   gtk_box_pack_start(GTK_BOX(inside_box), dialog->username_entry, TRUE, TRUE, 5);
   gtk_widget_show(dialog->username_entry);

   label = gtk_label_new("  Password:");
   gtk_box_pack_start(GTK_BOX(inside_box), label, FALSE, FALSE, 5);
   gtk_widget_show(label);

   dialog->password_entry = gtk_entry_new();
   gtk_entry_set_visibility(GTK_ENTRY(dialog->password_entry), FALSE);
   gtk_box_pack_start(GTK_BOX(inside_box), dialog->password_entry, TRUE, TRUE, 5);
   gtk_widget_show(dialog->password_entry);

   inside_box = gtk_hbox_new(FALSE, 0);
   gtk_box_pack_start(GTK_BOX(util_box), inside_box, TRUE, TRUE, 5);
   gtk_widget_show(inside_box);

   dialog->save_pass = gtk_check_button_new_with_label("Save Password?");
   gtk_box_pack_end(GTK_BOX(inside_box), dialog->save_pass, FALSE, FALSE, 5);
   gtk_widget_show(dialog->save_pass);

   hsep = gtk_hseparator_new();
   gtk_box_pack_start(GTK_BOX(main_box), hsep, TRUE, TRUE, 5);
   gtk_widget_show(hsep);

   util_box = gtk_hbutton_box_new();
   gtk_box_pack_start(GTK_BOX(main_box), util_box, TRUE, TRUE, 0);
   gtk_button_box_set_layout(GTK_BUTTON_BOX(util_box), gnome_preferences_get_button_layout());
   gtk_button_box_set_spacing(GTK_BUTTON_BOX(util_box), GNOME_PAD);
   gtk_widget_show(util_box);

   dialog->ok_button = gnome_stock_button(GNOME_STOCK_BUTTON_OK);
   gtk_box_pack_end(GTK_BOX(util_box), dialog->ok_button, FALSE, FALSE, 5);
   gtk_widget_show(dialog->ok_button);
   gtk_widget_set_sensitive(dialog->ok_button, FALSE);
   GTK_WIDGET_SET_FLAGS(dialog->ok_button, GTK_CAN_DEFAULT);
   gtk_window_set_default(GTK_WINDOW(dialog), dialog->ok_button);

   dialog->cancel_button = gnome_stock_button(GNOME_STOCK_BUTTON_CANCEL);
   gtk_box_pack_end(GTK_BOX(util_box), dialog->cancel_button, FALSE, FALSE, 5);
   GTK_WIDGET_SET_FLAGS(dialog->cancel_button, GTK_CAN_DEFAULT);
   gtk_widget_show(dialog->cancel_button);

   gtk_signal_connect(GTK_OBJECT(dialog->username_entry), "changed", GTK_SIGNAL_FUNC(check_enable_button), (gpointer)dialog);
   gtk_signal_connect(GTK_OBJECT(dialog->password_entry), "changed", GTK_SIGNAL_FUNC(check_enable_button), (gpointer)dialog);
   gtk_signal_connect(GTK_OBJECT(dialog->username_entry), "activate", GTK_SIGNAL_FUNC(check_activation), (gpointer)dialog);
   gtk_signal_connect(GTK_OBJECT(dialog->password_entry), "activate", GTK_SIGNAL_FUNC(check_activation), (gpointer)dialog);
   return GTK_WIDGET(dialog);
}

static void gnome_password_dialog_destroy(GtkObject *object)
{
   g_return_if_fail(object != NULL);
   g_return_if_fail(GNOME_IS_PASSWORD_DIALOG(object));
   GTK_OBJECT_CLASS(parent_class)->destroy(object);
}

gchar *gnome_password_dialog_get_username(GnomePasswordDialog *dialog)
{
   gchar *text = NULL;

   g_return_val_if_fail(dialog != NULL, NULL);
   g_return_val_if_fail(GNOME_IS_PASSWORD_DIALOG(dialog), NULL);
   text = gtk_entry_get_text(GTK_ENTRY(dialog->username_entry));
   if(text && strlen(text)) text = g_strdup(text);
   else text = NULL;
   return(text);
}

gchar *gnome_password_dialog_get_password(GnomePasswordDialog *dialog)
{
   gchar *text = NULL;

   g_return_val_if_fail(dialog != NULL, NULL);
   g_return_val_if_fail(GNOME_IS_PASSWORD_DIALOG(dialog), NULL);
   text = gtk_entry_get_text(GTK_ENTRY(dialog->password_entry));
   if(text && strlen(text)) text = g_strdup(text);
   else text = NULL;
   return(text);
}

void gnome_password_dialog_set_username(GnomePasswordDialog *dialog, gchar *username)
{
   g_return_if_fail(dialog != NULL);
   g_return_if_fail(GNOME_IS_PASSWORD_DIALOG(dialog));
   if(username) gtk_entry_set_text(GTK_ENTRY(dialog->username_entry), username);
   else gtk_entry_set_text(GTK_ENTRY(dialog->username_entry),"");
}

void gnome_password_dialog_set_save_pass(GnomePasswordDialog *dialog, gboolean save)
{
   g_return_if_fail(dialog != NULL);
   g_return_if_fail(GNOME_IS_PASSWORD_DIALOG(dialog));
   GTK_TOGGLE_BUTTON(dialog->save_pass)->active = save;
}

gboolean gnome_password_dialog_get_save_pass(GnomePasswordDialog *dialog)
{
   g_return_val_if_fail(dialog != NULL, FALSE);
   g_return_val_if_fail(GNOME_IS_PASSWORD_DIALOG(dialog), FALSE);
   return(GTK_TOGGLE_BUTTON(dialog->save_pass)->active);
}

void gnome_password_dialog_set_password(GnomePasswordDialog *dialog, gchar *password)
{
   g_return_if_fail(dialog != NULL);
   g_return_if_fail(GNOME_IS_PASSWORD_DIALOG(dialog));
   if(password) gtk_entry_set_text(GTK_ENTRY(dialog->password_entry), password);
   else gtk_entry_set_text(GTK_ENTRY(dialog->username_entry),"");
}

static void check_enable_button(GtkWidget *widget, GnomePasswordDialog *dialog)
{
   gchar *user = NULL;
   gchar *pass = NULL;
   gboolean sensitive = FALSE;
   user = gtk_entry_get_text(GTK_ENTRY(dialog->username_entry));
   pass = gtk_entry_get_text(GTK_ENTRY(dialog->password_entry));
   if(user && strlen(user) && pass && strlen(pass)) sensitive = TRUE;
   gtk_widget_set_sensitive(dialog->ok_button, sensitive);
}

static void check_activation(GtkWidget *entry, GnomePasswordDialog *dialog)
{
   gchar *user = NULL;
   gchar *pass = NULL;

   user = gtk_entry_get_text(GTK_ENTRY(dialog->username_entry));
   pass = gtk_entry_get_text(GTK_ENTRY(dialog->password_entry));
   if(entry == dialog->username_entry && user && strlen(user))
   {
      gtk_widget_grab_focus(dialog->password_entry);
   }
   else if(entry == dialog->password_entry && pass && strlen(pass))
   {
      gtk_signal_emit_by_name(GTK_OBJECT(dialog->ok_button), "clicked", NULL);
   }
}
