/* winxp-installer.c generated by valac 0.16.0.2-f2187, the Vala compiler
 * generated from winxp-installer.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/
/* Automated installer media for Windows XP, 2000 and 2003*/

#include <glib.h>
#include <glib-object.h>
#include <osinfo/osinfo.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <libvirt-gconfig/libvirt-gconfig.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define BOXES_TYPE_INSTALLER_MEDIA (boxes_installer_media_get_type ())
#define BOXES_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMedia))
#define BOXES_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))
#define BOXES_IS_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_IS_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_INSTALLER_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))

typedef struct _BoxesInstallerMedia BoxesInstallerMedia;
typedef struct _BoxesInstallerMediaClass BoxesInstallerMediaClass;
typedef struct _BoxesInstallerMediaPrivate BoxesInstallerMediaPrivate;

#define BOXES_TYPE_UNATTENDED_INSTALLER (boxes_unattended_installer_get_type ())
#define BOXES_UNATTENDED_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_UNATTENDED_INSTALLER, BoxesUnattendedInstaller))
#define BOXES_UNATTENDED_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_UNATTENDED_INSTALLER, BoxesUnattendedInstallerClass))
#define BOXES_IS_UNATTENDED_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_UNATTENDED_INSTALLER))
#define BOXES_IS_UNATTENDED_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_UNATTENDED_INSTALLER))
#define BOXES_UNATTENDED_INSTALLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_UNATTENDED_INSTALLER, BoxesUnattendedInstallerClass))

typedef struct _BoxesUnattendedInstaller BoxesUnattendedInstaller;
typedef struct _BoxesUnattendedInstallerClass BoxesUnattendedInstallerClass;
typedef struct _BoxesUnattendedInstallerPrivate BoxesUnattendedInstallerPrivate;

#define BOXES_TYPE_UNATTENDED_FILE (boxes_unattended_file_get_type ())
#define BOXES_UNATTENDED_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_UNATTENDED_FILE, BoxesUnattendedFile))
#define BOXES_IS_UNATTENDED_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_UNATTENDED_FILE))
#define BOXES_UNATTENDED_FILE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BOXES_TYPE_UNATTENDED_FILE, BoxesUnattendedFileIface))

typedef struct _BoxesUnattendedFile BoxesUnattendedFile;
typedef struct _BoxesUnattendedFileIface BoxesUnattendedFileIface;

#define TYPE_AVATAR_FORMAT (avatar_format_get_type ())
#define AVATAR_FORMAT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_FORMAT, AvatarFormat))
#define AVATAR_FORMAT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_FORMAT, AvatarFormatClass))
#define IS_AVATAR_FORMAT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_FORMAT))
#define IS_AVATAR_FORMAT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_FORMAT))
#define AVATAR_FORMAT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_FORMAT, AvatarFormatClass))

typedef struct _AvatarFormat AvatarFormat;
typedef struct _AvatarFormatClass AvatarFormatClass;

#define BOXES_TYPE_WINDOWS_INSTALLER (boxes_windows_installer_get_type ())
#define BOXES_WINDOWS_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_WINDOWS_INSTALLER, BoxesWindowsInstaller))
#define BOXES_WINDOWS_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_WINDOWS_INSTALLER, BoxesWindowsInstallerClass))
#define BOXES_IS_WINDOWS_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_WINDOWS_INSTALLER))
#define BOXES_IS_WINDOWS_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_WINDOWS_INSTALLER))
#define BOXES_WINDOWS_INSTALLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_WINDOWS_INSTALLER, BoxesWindowsInstallerClass))

typedef struct _BoxesWindowsInstaller BoxesWindowsInstaller;
typedef struct _BoxesWindowsInstallerClass BoxesWindowsInstallerClass;
typedef struct _BoxesWindowsInstallerPrivate BoxesWindowsInstallerPrivate;

#define BOXES_TYPE_WIN_XP_INSTALLER (boxes_win_xp_installer_get_type ())
#define BOXES_WIN_XP_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_WIN_XP_INSTALLER, BoxesWinXPInstaller))
#define BOXES_WIN_XP_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_WIN_XP_INSTALLER, BoxesWinXPInstallerClass))
#define BOXES_IS_WIN_XP_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_WIN_XP_INSTALLER))
#define BOXES_IS_WIN_XP_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_WIN_XP_INSTALLER))
#define BOXES_WIN_XP_INSTALLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_WIN_XP_INSTALLER, BoxesWinXPInstallerClass))

typedef struct _BoxesWinXPInstaller BoxesWinXPInstaller;
typedef struct _BoxesWinXPInstallerClass BoxesWinXPInstallerClass;
typedef struct _BoxesWinXPInstallerPrivate BoxesWinXPInstallerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _avatar_format_unref0(var) ((var == NULL) ? NULL : (var = (avatar_format_unref (var), NULL)))
typedef struct _Block34Data Block34Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _BoxesInstallerMedia {
	GObject parent_instance;
	BoxesInstallerMediaPrivate * priv;
	OsinfoOs* os;
	OsinfoResources* resources;
	OsinfoMedia* os_media;
	gchar* label;
	gchar* device_file;
	gchar* mount_point;
	gboolean from_image;
};

struct _BoxesInstallerMediaClass {
	GObjectClass parent_class;
};

typedef enum  {
	UNATTENDED_INSTALLER_ERROR_SETUP_INCOMPLETE
} UnattendedInstallerError;
#define UNATTENDED_INSTALLER_ERROR unattended_installer_error_quark ()
struct _BoxesUnattendedFileIface {
	GTypeInterface parent_iface;
	void (*create) (BoxesUnattendedFile* self, const gchar* hostname, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GFile* (*create_finish) (BoxesUnattendedFile* self, GAsyncResult* _res_, GError** error);
	const gchar* (*get_src_path) (BoxesUnattendedFile* self);
	void (*set_src_path) (BoxesUnattendedFile* self, const gchar* value);
	const gchar* (*get_dest_name) (BoxesUnattendedFile* self);
	void (*set_dest_name) (BoxesUnattendedFile* self, const gchar* value);
	BoxesUnattendedInstaller* (*get_installer) (BoxesUnattendedFile* self);
	void (*set_installer) (BoxesUnattendedFile* self, BoxesUnattendedInstaller* value);
};

struct _BoxesUnattendedInstaller {
	BoxesInstallerMedia parent_instance;
	BoxesUnattendedInstallerPrivate * priv;
	GDataStreamNewlineType newline_type;
	gchar* disk_path;
	GList* unattended_files;
	GtkTable* setup_table;
	GtkLabel* setup_label;
	GtkHBox* setup_hbox;
	GtkSwitch* express_toggle;
	GtkEntry* username_entry;
	GtkEntry* password_entry;
	gchar* timezone;
	gchar* lang;
	AvatarFormat* avatar_format;
};

struct _BoxesUnattendedInstallerClass {
	BoxesInstallerMediaClass parent_class;
	void (*populate_setup_vbox) (BoxesUnattendedInstaller* self, GtkVBox* setup_vbox);
	void (*set_direct_boot_params) (BoxesUnattendedInstaller* self, GVirConfigDomainOs* os);
	GVirConfigDomainDisk* (*get_unattended_disk_config) (BoxesUnattendedInstaller* self);
	void (*check_needed_info) (BoxesUnattendedInstaller* self, GError** error);
	gchar* (*fill_unattended_data) (BoxesUnattendedInstaller* self, const gchar* data, const gchar* hostname, GError** error);
	void (*setup_ui) (BoxesUnattendedInstaller* self);
	void (*clean_up) (BoxesUnattendedInstaller* self, GError** error);
	void (*prepare_direct_boot) (BoxesUnattendedInstaller* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*prepare_direct_boot_finish) (BoxesUnattendedInstaller* self, GAsyncResult* _res_, GError** error);
};

struct _BoxesWindowsInstaller {
	BoxesUnattendedInstaller parent_instance;
	BoxesWindowsInstallerPrivate * priv;
};

struct _BoxesWindowsInstallerClass {
	BoxesUnattendedInstallerClass parent_class;
};

struct _BoxesWinXPInstaller {
	BoxesWindowsInstaller parent_instance;
	BoxesWinXPInstallerPrivate * priv;
};

struct _BoxesWinXPInstallerClass {
	BoxesWindowsInstallerClass parent_class;
};

struct _BoxesWinXPInstallerPrivate {
	GtkEntry* key_entry;
	gulong key_inserted_id;
};

struct _Block34Data {
	int _ref_count_;
	BoxesWinXPInstaller * self;
	GtkNotebook* notebook;
};


static gpointer boxes_win_xp_installer_parent_class = NULL;
static GRegex* boxes_win_xp_installer_key_regex;
static GRegex* boxes_win_xp_installer_key_regex = NULL;
static GRegex* boxes_win_xp_installer_admin_pass_regex;
static GRegex* boxes_win_xp_installer_admin_pass_regex = NULL;

GType boxes_installer_media_get_type (void) G_GNUC_CONST;
GType boxes_unattended_installer_get_type (void) G_GNUC_CONST;
GQuark unattended_installer_error_quark (void);
GType boxes_unattended_file_get_type (void) G_GNUC_CONST;
gpointer avatar_format_ref (gpointer instance);
void avatar_format_unref (gpointer instance);
GParamSpec* param_spec_avatar_format (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_avatar_format (GValue* value, gpointer v_object);
void value_take_avatar_format (GValue* value, gpointer v_object);
gpointer value_get_avatar_format (const GValue* value);
GType avatar_format_get_type (void) G_GNUC_CONST;
GType boxes_windows_installer_get_type (void) G_GNUC_CONST;
GType boxes_win_xp_installer_get_type (void) G_GNUC_CONST;
#define BOXES_WIN_XP_INSTALLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BOXES_TYPE_WIN_XP_INSTALLER, BoxesWinXPInstallerPrivate))
enum  {
	BOXES_WIN_XP_INSTALLER_DUMMY_PROPERTY
};
BoxesWinXPInstaller* boxes_win_xp_installer_new_copy (BoxesInstallerMedia* media, GError** error);
BoxesWinXPInstaller* boxes_win_xp_installer_construct_copy (GType object_type, BoxesInstallerMedia* media, GError** error);
gchar* boxes_get_unattended (const gchar* file_name);
AvatarFormat* avatar_format_new (const gchar* type, const gchar* extension, gboolean alpha, gint width, gint height);
AvatarFormat* avatar_format_construct (GType object_type, const gchar* type, const gchar* extension, gboolean alpha, gint width, gint height);
BoxesUnattendedInstaller* boxes_unattended_installer_construct_copy (GType object_type, BoxesInstallerMedia* media, const gchar* unattended_src_path, const gchar* unattended_dest_name, AvatarFormat* avatar_format, GError** error);
void boxes_unattended_installer_add_unattended_text_file (BoxesUnattendedInstaller* self, const gchar* unattended_src_path, const gchar* unattended_dest_name);
static void boxes_win_xp_installer_real_setup_ui (BoxesUnattendedInstaller* base);
static Block34Data* block34_data_ref (Block34Data* _data34_);
static void block34_data_unref (void * _userdata_);
void boxes_unattended_installer_setup_ui (BoxesUnattendedInstaller* self);
static void __lambda46_ (Block34Data* _data34_);
static void ___lambda46__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void boxes_win_xp_installer_on_key_text_inserted (BoxesWinXPInstaller* self, const gchar* text, gint text_length, gint* position);
static void _boxes_win_xp_installer_on_key_text_inserted_gtk_editable_insert_text (GtkEditable* _sender, const gchar* new_text, gint new_text_length, gint* position, gpointer self);
static gchar* boxes_win_xp_installer_real_fill_unattended_data (BoxesUnattendedInstaller* base, const gchar* data, const gchar* hostname, GError** error);
gchar* boxes_unattended_installer_fill_unattended_data (BoxesUnattendedInstaller* self, const gchar* data, const gchar* hostname, GError** error);
gchar* boxes_unattended_installer_get_password (BoxesUnattendedInstaller* self);
static gboolean _vala_uint_array_contains (guint* stack, int stack_length, guint needle);
BoxesWinXPInstaller* boxes_win_xp_installer_new (void);
BoxesWinXPInstaller* boxes_win_xp_installer_construct (GType object_type);
BoxesWindowsInstaller* boxes_windows_installer_construct (GType object_type);
static void boxes_win_xp_installer_finalize (GObject* obj);

static const guint BOXES_WIN_XP_INSTALLER_allowed_dash_positions[4] = {(guint) 5, (guint) 11, (guint) 17, (guint) 23};

BoxesWinXPInstaller* boxes_win_xp_installer_construct_copy (GType object_type, BoxesInstallerMedia* media, GError** error) {
	BoxesWinXPInstaller * self = NULL;
	BoxesInstallerMedia* _tmp0_;
	OsinfoOs* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* unattended_source;
	AvatarFormat* _tmp8_;
	AvatarFormat* avatar_format;
	BoxesInstallerMedia* _tmp9_;
	const gchar* _tmp10_;
	BoxesInstallerMedia* _tmp11_;
	OsinfoOs* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* name;
	const gchar* _tmp16_;
	gchar* _tmp17_ = NULL;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	BoxesInstallerMedia* _tmp20_;
	OsinfoOs* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_ = NULL;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (media != NULL, NULL);
	_tmp0_ = media;
	_tmp1_ = _tmp0_->os;
	_tmp2_ = osinfo_product_get_short_id ((OsinfoProduct*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, ".sif", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = boxes_get_unattended (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	unattended_source = _tmp7_;
	_tmp8_ = avatar_format_new ("bmp", ".bmp", FALSE, 48, 48);
	avatar_format = _tmp8_;
	_tmp9_ = media;
	_tmp10_ = unattended_source;
	self = (BoxesWinXPInstaller*) boxes_unattended_installer_construct_copy (object_type, _tmp9_, _tmp10_, "Winnt.sif", avatar_format, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_avatar_format_unref0 (avatar_format);
		_g_free0 (unattended_source);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp11_ = media;
	_tmp12_ = _tmp11_->os;
	_tmp13_ = osinfo_product_get_short_id ((OsinfoProduct*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strconcat (_tmp14_, ".cmd", NULL);
	name = _tmp15_;
	_tmp16_ = name;
	_tmp17_ = boxes_get_unattended (_tmp16_);
	_g_free0 (unattended_source);
	unattended_source = _tmp17_;
	_tmp18_ = unattended_source;
	_tmp19_ = name;
	boxes_unattended_installer_add_unattended_text_file ((BoxesUnattendedInstaller*) self, _tmp18_, _tmp19_);
	_tmp20_ = media;
	_tmp21_ = _tmp20_->os;
	_tmp22_ = osinfo_product_get_short_id ((OsinfoProduct*) _tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strconcat (_tmp23_, ".reg", NULL);
	_g_free0 (name);
	name = _tmp24_;
	_tmp25_ = name;
	_tmp26_ = boxes_get_unattended (_tmp25_);
	_g_free0 (unattended_source);
	unattended_source = _tmp26_;
	_tmp27_ = unattended_source;
	_tmp28_ = name;
	boxes_unattended_installer_add_unattended_text_file ((BoxesUnattendedInstaller*) self, _tmp27_, _tmp28_);
	((BoxesUnattendedInstaller*) self)->newline_type = G_DATA_STREAM_NEWLINE_TYPE_CR_LF;
	_g_free0 (name);
	_avatar_format_unref0 (avatar_format);
	_g_free0 (unattended_source);
	return self;
}


BoxesWinXPInstaller* boxes_win_xp_installer_new_copy (BoxesInstallerMedia* media, GError** error) {
	return boxes_win_xp_installer_construct_copy (BOXES_TYPE_WIN_XP_INSTALLER, media, error);
}


static Block34Data* block34_data_ref (Block34Data* _data34_) {
	g_atomic_int_inc (&_data34_->_ref_count_);
	return _data34_;
}


static void block34_data_unref (void * _userdata_) {
	Block34Data* _data34_;
	_data34_ = (Block34Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data34_->_ref_count_)) {
		BoxesWinXPInstaller * self;
		self = _data34_->self;
		_g_object_unref0 (_data34_->notebook);
		_g_object_unref0 (self);
		g_slice_free (Block34Data, _data34_);
	}
}


static void __lambda46_ (Block34Data* _data34_) {
	BoxesWinXPInstaller * self;
	GtkEntry* _tmp0_;
	self = _data34_->self;
	gtk_notebook_next_page (_data34_->notebook);
	_tmp0_ = self->priv->key_entry;
	g_object_set ((GtkWidget*) _tmp0_, "is-focus", TRUE, NULL);
}


static void ___lambda46__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda46_ (self);
}


static void _boxes_win_xp_installer_on_key_text_inserted_gtk_editable_insert_text (GtkEditable* _sender, const gchar* new_text, gint new_text_length, gint* position, gpointer self) {
	boxes_win_xp_installer_on_key_text_inserted (self, new_text, new_text_length, position);
}


static void boxes_win_xp_installer_real_setup_ui (BoxesUnattendedInstaller* base) {
	BoxesWinXPInstaller * self;
	Block34Data* _data34_;
	GtkTable* _tmp0_;
	GtkTable* _tmp1_;
	guint _tmp2_ = 0U;
	guint _tmp3_;
	GtkTable* _tmp4_;
	guint _tmp5_ = 0U;
	guint _tmp6_;
	GtkHBox* _tmp7_;
	GtkHBox* _tmp8_;
	GtkHBox* hbox;
	const gchar* _tmp9_ = NULL;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* label;
	GtkNotebook* _tmp12_;
	GtkNotebook* _tmp13_;
	const gchar* _tmp14_ = NULL;
	GtkButton* _tmp15_;
	GtkButton* _tmp16_;
	GtkButton* button;
	GtkEntry* _tmp17_;
	GtkEntry* _tmp18_;
	GtkEntry* _tmp19_;
	GtkEntry* _tmp20_;
	GtkEntry* _tmp21_;
	GtkStyleContext* _tmp22_ = NULL;
	GtkEntry* _tmp23_;
	GtkTable* _tmp24_;
	GtkTable* _tmp25_;
	guint _tmp26_ = 0U;
	guint _tmp27_;
	GtkTable* _tmp28_;
	guint _tmp29_ = 0U;
	guint _tmp30_;
	GtkTable* _tmp31_;
	guint _tmp32_ = 0U;
	guint _tmp33_;
	GtkSwitch* _tmp34_;
	GtkEntry* _tmp35_;
	gulong _tmp36_ = 0UL;
	self = (BoxesWinXPInstaller*) base;
	_data34_ = g_slice_new0 (Block34Data);
	_data34_->_ref_count_ = 1;
	_data34_->self = g_object_ref (self);
	BOXES_UNATTENDED_INSTALLER_CLASS (boxes_win_xp_installer_parent_class)->setup_ui ((BoxesUnattendedInstaller*) BOXES_WINDOWS_INSTALLER (self));
	_tmp0_ = ((BoxesUnattendedInstaller*) self)->setup_table;
	_tmp1_ = ((BoxesUnattendedInstaller*) self)->setup_table;
	g_object_get (_tmp1_, "n-rows", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = ((BoxesUnattendedInstaller*) self)->setup_table;
	g_object_get (_tmp4_, "n-columns", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	gtk_table_resize (_tmp0_, _tmp3_ + 1, _tmp6_);
	_tmp7_ = (GtkHBox*) gtk_hbox_new (FALSE, 10);
	_tmp8_ = g_object_ref_sink (_tmp7_);
	hbox = _tmp8_;
	gtk_widget_set_margin_top ((GtkWidget*) hbox, 12);
	_tmp9_ = _ ("Product Key");
	_tmp10_ = (GtkLabel*) gtk_label_new (_tmp9_);
	_tmp11_ = g_object_ref_sink (_tmp10_);
	label = _tmp11_;
	gtk_widget_set_halign ((GtkWidget*) label, GTK_ALIGN_START);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
	_tmp12_ = (GtkNotebook*) gtk_notebook_new ();
	_tmp13_ = g_object_ref_sink (_tmp12_);
	_data34_->notebook = _tmp13_;
	gtk_notebook_set_show_tabs (_data34_->notebook, FALSE);
	gtk_notebook_set_show_border (_data34_->notebook, FALSE);
	_tmp14_ = _ ("_Add Product Key");
	_tmp15_ = (GtkButton*) gtk_button_new_with_mnemonic (_tmp14_);
	_tmp16_ = g_object_ref_sink (_tmp15_);
	button = _tmp16_;
	gtk_notebook_append_page (_data34_->notebook, (GtkWidget*) button, NULL);
	_tmp17_ = (GtkEntry*) gtk_entry_new ();
	_tmp18_ = g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->key_entry);
	self->priv->key_entry = _tmp18_;
	_tmp19_ = self->priv->key_entry;
	gtk_entry_set_width_chars (_tmp19_, 29);
	_tmp20_ = self->priv->key_entry;
	gtk_entry_set_max_length (_tmp20_, 29);
	_tmp21_ = self->priv->key_entry;
	_tmp22_ = gtk_widget_get_style_context ((GtkWidget*) _tmp21_);
	gtk_style_context_add_class (_tmp22_, "boxes-product-key-entry");
	_tmp23_ = self->priv->key_entry;
	gtk_notebook_append_page (_data34_->notebook, (GtkWidget*) _tmp23_, NULL);
	g_signal_connect_data (button, "clicked", (GCallback) ___lambda46__gtk_button_clicked, block34_data_ref (_data34_), (GClosureNotify) block34_data_unref, 0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) _data34_->notebook, TRUE, TRUE, (guint) 0);
	_tmp24_ = ((BoxesUnattendedInstaller*) self)->setup_table;
	_tmp25_ = ((BoxesUnattendedInstaller*) self)->setup_table;
	g_object_get (_tmp25_, "n-columns", &_tmp26_, NULL);
	_tmp27_ = _tmp26_;
	_tmp28_ = ((BoxesUnattendedInstaller*) self)->setup_table;
	g_object_get (_tmp28_, "n-rows", &_tmp29_, NULL);
	_tmp30_ = _tmp29_;
	_tmp31_ = ((BoxesUnattendedInstaller*) self)->setup_table;
	g_object_get (_tmp31_, "n-rows", &_tmp32_, NULL);
	_tmp33_ = _tmp32_;
	gtk_table_attach_defaults (_tmp24_, (GtkWidget*) hbox, (guint) 0, _tmp27_, _tmp30_ - 1, _tmp33_);
	_tmp34_ = ((BoxesUnattendedInstaller*) self)->express_toggle;
	g_object_bind_property_with_closures ((GObject*) _tmp34_, "active", (GObject*) hbox, "sensitive", 0, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp35_ = self->priv->key_entry;
	_tmp36_ = g_signal_connect_object ((GtkEditable*) _tmp35_, "insert-text", (GCallback) _boxes_win_xp_installer_on_key_text_inserted_gtk_editable_insert_text, self, 0);
	self->priv->key_inserted_id = _tmp36_;
	_g_object_unref0 (button);
	_g_object_unref0 (label);
	_g_object_unref0 (hbox);
	block34_data_unref (_data34_);
	_data34_ = NULL;
}


static gchar* boxes_win_xp_installer_real_fill_unattended_data (BoxesUnattendedInstaller* base, const gchar* data, const gchar* hostname, GError** error) {
	BoxesWinXPInstaller * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* str;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* admin_pass;
	GRegex* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	GRegex* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	GtkEntry* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_;
	GError * _inner_error_ = NULL;
	self = (BoxesWinXPInstaller*) base;
	g_return_val_if_fail (data != NULL, NULL);
	g_return_val_if_fail (hostname != NULL, NULL);
	_tmp0_ = data;
	_tmp1_ = hostname;
	_tmp2_ = BOXES_UNATTENDED_INSTALLER_CLASS (boxes_win_xp_installer_parent_class)->fill_unattended_data ((BoxesUnattendedInstaller*) BOXES_WINDOWS_INSTALLER (self), _tmp0_, _tmp1_, &_inner_error_);
	str = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp4_ = boxes_unattended_installer_get_password ((BoxesUnattendedInstaller*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strcmp0 (_tmp6_, "") != 0;
	_g_free0 (_tmp6_);
	if (_tmp7_) {
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = boxes_unattended_installer_get_password ((BoxesUnattendedInstaller*) self);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp3_);
		_tmp3_ = _tmp9_;
	} else {
		gchar* _tmp10_;
		_tmp10_ = g_strdup ("*");
		_g_free0 (_tmp3_);
		_tmp3_ = _tmp10_;
	}
	_tmp11_ = _tmp3_;
	_tmp12_ = g_strdup (_tmp11_);
	admin_pass = _tmp12_;
	_tmp13_ = boxes_win_xp_installer_admin_pass_regex;
	_tmp14_ = str;
	_tmp15_ = str;
	_tmp16_ = strlen (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = admin_pass;
	_tmp19_ = g_regex_replace (_tmp13_, _tmp14_, (gssize) _tmp17_, 0, _tmp18_, 0, &_inner_error_);
	_tmp20_ = _tmp19_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (admin_pass);
			_g_free0 (_tmp3_);
			_g_free0 (str);
			return NULL;
		} else {
			_g_free0 (admin_pass);
			_g_free0 (_tmp3_);
			_g_free0 (str);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_g_free0 (str);
	str = _tmp20_;
	_tmp21_ = boxes_win_xp_installer_key_regex;
	_tmp22_ = str;
	_tmp23_ = str;
	_tmp24_ = strlen (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = self->priv->key_entry;
	_tmp27_ = gtk_entry_get_text (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_regex_replace (_tmp21_, _tmp22_, (gssize) _tmp25_, 0, _tmp28_, 0, &_inner_error_);
	_tmp30_ = _tmp29_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (admin_pass);
			_g_free0 (_tmp3_);
			_g_free0 (str);
			return NULL;
		} else {
			_g_free0 (admin_pass);
			_g_free0 (_tmp3_);
			_g_free0 (str);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp30_;
	_g_free0 (admin_pass);
	_g_free0 (_tmp3_);
	_g_free0 (str);
	return result;
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static gboolean _vala_uint_array_contains (guint* stack, int stack_length, guint needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}


static void boxes_win_xp_installer_on_key_text_inserted (BoxesWinXPInstaller* self, const gchar* text, gint text_length, gint* position) {
	gchar* _tmp0_;
	gchar* _result_;
	guint i;
	const gchar* _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8* _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp20_;
	GtkEntry* _tmp32_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = g_strdup ("");
	_result_ = _tmp0_;
	i = (guint) 0;
	_tmp1_ = text;
	_tmp2_ = string_get_data (_tmp1_, &_tmp2__length1);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	{
		gchar* character_collection = NULL;
		gint character_collection_length1 = 0;
		gint _character_collection_size_ = 0;
		gint character_it = 0;
		character_collection = (gchar*) _tmp3_;
		character_collection_length1 = _tmp3__length1;
		for (character_it = 0; character_it < _tmp3__length1; character_it = character_it + 1) {
			gchar character = '\0';
			character = character_collection[character_it];
			{
				guint _tmp4_;
				gint _tmp5_;
				guint char_position;
				gchar _tmp6_;
				const gchar* _tmp14_;
				gchar _tmp15_;
				gchar* _tmp16_ = NULL;
				gchar* _tmp17_;
				gchar* _tmp18_;
				guint _tmp19_;
				_tmp4_ = i;
				_tmp5_ = *position;
				char_position = _tmp4_ + _tmp5_;
				_tmp6_ = character;
				if (_tmp6_ != '-') {
					gchar _tmp7_;
					gboolean _tmp8_ = FALSE;
					guint _tmp9_;
					_tmp7_ = character;
					_tmp8_ = g_ascii_isalnum (_tmp7_);
					if (!_tmp8_) {
						continue;
					}
					_tmp9_ = char_position;
					if (_vala_uint_array_contains (BOXES_WIN_XP_INSTALLER_allowed_dash_positions, G_N_ELEMENTS (BOXES_WIN_XP_INSTALLER_allowed_dash_positions), _tmp9_)) {
						const gchar* _tmp10_;
						gchar* _tmp11_;
						guint _tmp12_;
						_tmp10_ = _result_;
						_tmp11_ = g_strconcat (_tmp10_, "-", NULL);
						_g_free0 (_result_);
						_result_ = _tmp11_;
						_tmp12_ = i;
						i = _tmp12_ + 1;
					}
				} else {
					guint _tmp13_;
					_tmp13_ = char_position;
					if (!_vala_uint_array_contains (BOXES_WIN_XP_INSTALLER_allowed_dash_positions, G_N_ELEMENTS (BOXES_WIN_XP_INSTALLER_allowed_dash_positions), _tmp13_)) {
						continue;
					}
				}
				_tmp14_ = _result_;
				_tmp15_ = character;
				_tmp16_ = g_strdup_printf ("%c", _tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_strconcat (_tmp14_, _tmp17_, NULL);
				_g_free0 (_result_);
				_result_ = _tmp18_;
				_g_free0 (_tmp17_);
				_tmp19_ = i;
				i = _tmp19_ + 1;
			}
		}
	}
	_tmp20_ = _result_;
	if (g_strcmp0 (_tmp20_, "") != 0) {
		GtkEntry* _tmp21_;
		gulong _tmp22_;
		GtkEntry* _tmp23_;
		const gchar* _tmp24_;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_;
		const gchar* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		GtkEntry* _tmp30_;
		gulong _tmp31_;
		_tmp21_ = self->priv->key_entry;
		_tmp22_ = self->priv->key_inserted_id;
		g_signal_handler_block (_tmp21_, _tmp22_);
		_tmp23_ = self->priv->key_entry;
		_tmp24_ = _result_;
		_tmp25_ = g_utf8_strup (_tmp24_, (gssize) (-1));
		_tmp26_ = _tmp25_;
		_tmp27_ = _result_;
		_tmp28_ = strlen (_tmp27_);
		_tmp29_ = _tmp28_;
		gtk_editable_insert_text ((GtkEditable*) _tmp23_, _tmp26_, _tmp29_, position);
		_g_free0 (_tmp26_);
		_tmp30_ = self->priv->key_entry;
		_tmp31_ = self->priv->key_inserted_id;
		g_signal_handler_unblock (_tmp30_, _tmp31_);
	}
	_tmp32_ = self->priv->key_entry;
	g_signal_stop_emission_by_name (_tmp32_, "insert-text");
	_g_free0 (_result_);
}


BoxesWinXPInstaller* boxes_win_xp_installer_construct (GType object_type) {
	BoxesWinXPInstaller * self = NULL;
	self = (BoxesWinXPInstaller*) boxes_windows_installer_construct (object_type);
	return self;
}


BoxesWinXPInstaller* boxes_win_xp_installer_new (void) {
	return boxes_win_xp_installer_construct (BOXES_TYPE_WIN_XP_INSTALLER);
}


static void boxes_win_xp_installer_class_init (BoxesWinXPInstallerClass * klass) {
	GError * _inner_error_ = NULL;
	boxes_win_xp_installer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BoxesWinXPInstallerPrivate));
	BOXES_UNATTENDED_INSTALLER_CLASS (klass)->setup_ui = boxes_win_xp_installer_real_setup_ui;
	BOXES_UNATTENDED_INSTALLER_CLASS (klass)->fill_unattended_data = boxes_win_xp_installer_real_fill_unattended_data;
	G_OBJECT_CLASS (klass)->finalize = boxes_win_xp_installer_finalize;
	{
		GRegex* _tmp0_;
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		GRegex* _tmp3_;
		_tmp0_ = g_regex_new ("BOXES_PRODUCT_KEY", 0, 0, &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch70_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_g_regex_unref0 (boxes_win_xp_installer_key_regex);
		boxes_win_xp_installer_key_regex = _tmp1_;
		_tmp2_ = g_regex_new ("BOXES_XP_ADMIN_PASSWORD", 0, 0, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch70_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_g_regex_unref0 (boxes_win_xp_installer_admin_pass_regex);
		boxes_win_xp_installer_admin_pass_regex = _tmp3_;
	}
	goto __finally70;
	__catch70_g_regex_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally70:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
}


static void boxes_win_xp_installer_instance_init (BoxesWinXPInstaller * self) {
	self->priv = BOXES_WIN_XP_INSTALLER_GET_PRIVATE (self);
}


static void boxes_win_xp_installer_finalize (GObject* obj) {
	BoxesWinXPInstaller * self;
	self = BOXES_WIN_XP_INSTALLER (obj);
	_g_object_unref0 (self->priv->key_entry);
	G_OBJECT_CLASS (boxes_win_xp_installer_parent_class)->finalize (obj);
}


GType boxes_win_xp_installer_get_type (void) {
	static volatile gsize boxes_win_xp_installer_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_win_xp_installer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BoxesWinXPInstallerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_win_xp_installer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesWinXPInstaller), 0, (GInstanceInitFunc) boxes_win_xp_installer_instance_init, NULL };
		GType boxes_win_xp_installer_type_id;
		boxes_win_xp_installer_type_id = g_type_register_static (BOXES_TYPE_WINDOWS_INSTALLER, "BoxesWinXPInstaller", &g_define_type_info, 0);
		g_once_init_leave (&boxes_win_xp_installer_type_id__volatile, boxes_win_xp_installer_type_id);
	}
	return boxes_win_xp_installer_type_id__volatile;
}



