/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* gbf_project-tree.c
 *
 * Copyright (C) 2000-2001  JP Rosevear
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: JP Rosevear
 */

#include "menus.h"

static GHashTable *controls = NULL;	

static void
object_destroyed_cb (GtkObject *obj, GHashTable *controls) 
{
	g_hash_table_remove (controls, obj);
}

void 
menus_add (BonoboControl *control, GtkObject *obj, 
	   const char *name, BonoboUIVerb verbs[])
{	
	Bonobo_UIContainer remote_uic;
	BonoboUIComponent *uic;

	if (!controls) 
		controls = g_hash_table_new (g_direct_hash, g_direct_equal);

	uic = bonobo_control_get_ui_component (control);

	remote_uic = bonobo_control_get_remote_ui_container (control);
	if (remote_uic == CORBA_OBJECT_NIL) {
		g_warning ("Remote UI container not found");
		return;
	}

	bonobo_ui_component_set_container (uic, remote_uic);
	bonobo_object_release_unref (remote_uic, NULL);
	
	bonobo_ui_component_add_verb_list_with_data (uic, verbs, obj);
	bonobo_ui_util_set_ui (uic, GNOME_DATADIR, "gbf-tree.xml", name);

	gtk_signal_connect (obj, "destroy", object_destroyed_cb, controls);
	g_hash_table_insert (controls, obj, control);
}

void 
menus_sensitize (GtkObject *obj)
{
	BonoboControl *control = NULL;
	BonoboUIComponent *uic;
	GbfProjectClient *prj;
    
	if (controls)
		control = g_hash_table_lookup (controls, obj);
	
	if (!control)
		return;

	uic = bonobo_control_get_ui_component (control);
	gtk_object_get (obj, "project", &prj, NULL);
	
	bonobo_ui_component_set_prop (uic, "/commands/BuildAll", "sensitive",
				      prj ? "1" : "0", NULL);    
	bonobo_ui_component_set_prop (uic, "/commands/BuildInstall", "sensitive",
				      prj ? "1" : "0", NULL);
	bonobo_ui_component_set_prop (uic, "/commands/BuildRun", "sensitive", 
				      prj ? "1" : "0", NULL);
	bonobo_ui_component_set_prop (uic, "/commands/BuildParameters", "sensitive", 
				      prj ? "1" : "0", NULL);
	bonobo_ui_component_set_prop (uic, "/commands/AddTarget", "sensitive", 
				      prj ? "1" : "0", NULL);
}

