/* test-number.c generated by valac 0.24.0, the Vala compiler
 * generated from test-number.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <float.h>
#include <math.h>
#include <locale.h>


#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _number_unref0(var) ((var == NULL) ? NULL : (var = (number_unref (var), NULL)))

#define TYPE_ANGLE_UNIT (angle_unit_get_type ())
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define __g_list_free__number_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__number_unref0_ (var), NULL)))

typedef enum  {
	ANGLE_UNIT_RADIANS,
	ANGLE_UNIT_DEGREES,
	ANGLE_UNIT_GRADIANS
} AngleUnit;


extern gint fail_count;
gint fail_count = 0;
extern gint pass_count;
gint pass_count = 0;

void pass (const gchar* text);
void fail (const gchar* text);
void test_integer (void);
gpointer number_ref (gpointer instance);
void number_unref (gpointer instance);
GParamSpec* param_spec_number (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_number (GValue* value, gpointer v_object);
void value_take_number (GValue* value, gpointer v_object);
gpointer value_get_number (const GValue* value);
GType number_get_type (void) G_GNUC_CONST;
Number* number_new_integer (gint64 value);
Number* number_construct_integer (GType object_type, gint64 value);
gint64 number_to_integer (Number* self);
void test_unsigned_integer (void);
Number* number_new_unsigned_integer (guint64 x);
Number* number_construct_unsigned_integer (GType object_type, guint64 x);
guint64 number_to_unsigned_integer (Number* self);
void test_fraction (void);
Number* number_new_fraction (gint64 numerator, gint64 denominator);
Number* number_construct_fraction (GType object_type, gint64 numerator, gint64 denominator);
gboolean double_matches (Number* a, gdouble b);
gdouble number_to_double (Number* self);
void test_float (void);
Number* number_new_float (gfloat value);
Number* number_construct_float (GType object_type, gfloat value);
gfloat number_to_float (Number* self);
void test_double (void);
Number* number_new_double (gdouble value);
Number* number_construct_double (GType object_type, gdouble value);
void test_complex (void);
Number* number_new_complex (Number* x, Number* y);
Number* number_construct_complex (GType object_type, Number* x, Number* y);
Number* number_real_component (Number* self);
Number* number_imaginary_component (Number* self);
void test_polar (void);
GType angle_unit_get_type (void) G_GNUC_CONST;
Number* number_new_polar (Number* r, Number* theta, AngleUnit unit);
Number* number_construct_polar (GType object_type, Number* r, Number* theta, AngleUnit unit);
void test_i (void);
Number* number_new_i (void);
Number* number_construct_i (GType object_type);
void test_pi (void);
Number* number_new_pi (void);
Number* number_construct_pi (GType object_type);
void test_eulers (void);
Number* number_new_eulers (void);
Number* number_construct_eulers (GType object_type);
void test_string (void);
Number* mp_set_from_string (const gchar* str, gint default_base);
void test_sgn (void);
Number* number_sgn (Number* self);
void test_invert_sign (void);
Number* number_invert_sign (Number* self);
void test_abs (void);
Number* number_abs (Number* self);
void test_arg (void);
Number* number_arg (Number* self, AngleUnit unit);
gboolean number_is_zero (Number* self);
void test_conjugate (void);
Number* number_conjugate (Number* self);
void test_real_component (void);
void test_imaginary_component (void);
gchar* double_string (gdouble x);
void test_integer_component (void);
Number* number_integer_component (Number* self);
void test_fractional_component (void);
Number* number_fractional_component (Number* self);
void test_fractional_part (void);
Number* number_fractional_part (Number* self);
void test_floor (void);
Number* number_floor (Number* self);
void test_ceiling (void);
Number* number_ceiling (Number* self);
void test_round (void);
Number* number_round (Number* self);
void test_reciprocal (void);
Number* number_reciprocal (Number* self);
void test_epowy (void);
Number* number_epowy (Number* self);
void test_xpowy (void);
Number* number_xpowy (Number* self, Number* y);
void test_xpowy_integer (void);
Number* number_xpowy_integer (Number* self, gint64 n);
void test_root3 (void);
Number* number_root (Number* self, gint64 n);
void test_sqrt (void);
Number* number_sqrt (Number* self);
void test_ln (void);
Number* number_ln (Number* self);
void test_logarithm2 (void);
Number* number_logarithm (Number* self, gint64 n);
void test_logarithm10 (void);
void test_is_zero (void);
void test_is_negative (void);
gboolean number_is_negative (Number* self);
void test_is_integer (void);
gboolean number_is_integer (Number* self);
void test_is_positive_integer (void);
gboolean number_is_positive_integer (Number* self);
void test_is_natural (void);
gboolean number_is_natural (Number* self);
void test_is_complex (void);
gboolean number_is_complex (Number* self);
void test_factorial (void);
Number* number_factorial (Number* self);
void test_add (void);
Number* number_add (Number* self, Number* y);
void test_subtract (void);
Number* number_subtract (Number* self, Number* y);
void test_multiply (void);
Number* number_multiply (Number* self, Number* y);
void test_multiply_integer (void);
Number* number_multiply_integer (Number* self, gint64 y);
void test_divide (void);
Number* number_divide (Number* self, Number* y);
void test_divide_integer (void);
Number* number_divide_integer (Number* self, gint64 y);
void test_modulus_divide (void);
Number* number_modulus_divide (Number* self, Number* y);
void test_sin (void);
Number* number_sin (Number* self, AngleUnit unit);
void test_cos (void);
Number* number_cos (Number* self, AngleUnit unit);
void test_and (void);
Number* number_and (Number* self, Number* y);
void test_or (void);
Number* number_or (Number* self, Number* y);
void test_xor (void);
Number* number_xor (Number* self, Number* y);
void test_not (void);
Number* number_not (Number* self, gint wordlen);
void test_shift (void);
Number* number_shift (Number* self, gint count);
void test_factorize (void);
GList* number_factorize (Number* self);
GList* factorize (gint number);
static void _number_unref0_ (gpointer var);
static void _g_list_free__number_unref0_ (GList* self);
gint _vala_main (gchar** args, int args_length1);


void pass (const gchar* text) {
	gint _tmp0_ = 0;
	_tmp0_ = pass_count;
	pass_count = _tmp0_ + 1;
}


void fail (const gchar* text) {
	FILE* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	g_return_if_fail (text != NULL);
	_tmp0_ = stdout;
	_tmp1_ = text;
	fprintf (_tmp0_, "*FAIL: %s\n", _tmp1_);
	_tmp2_ = fail_count;
	fail_count = _tmp2_ + 1;
}


void test_integer (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				Number* z = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				Number* _tmp5_ = NULL;
				gint64 _tmp6_ = 0LL;
				gint _tmp7_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_integer ((gint64) _tmp3_);
				z = _tmp4_;
				_tmp5_ = z;
				_tmp6_ = number_to_integer (_tmp5_);
				_tmp7_ = a;
				if (_tmp6_ != ((gint64) _tmp7_)) {
					gint _tmp8_ = 0;
					Number* _tmp9_ = NULL;
					gint64 _tmp10_ = 0LL;
					gint _tmp11_ = 0;
					gchar* _tmp12_ = NULL;
					gchar* _tmp13_ = NULL;
					_tmp8_ = a;
					_tmp9_ = z;
					_tmp10_ = number_to_integer (_tmp9_);
					_tmp11_ = a;
					_tmp12_ = g_strdup_printf ("Number.integer (%d).to_integer () -> %lli, expected %i", _tmp8_, _tmp10_, _tmp11_);
					_tmp13_ = _tmp12_;
					fail (_tmp13_);
					_g_free0 (_tmp13_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_unsigned_integer (void) {
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				Number* z = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				Number* _tmp5_ = NULL;
				guint64 _tmp6_ = 0ULL;
				gint _tmp7_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_unsigned_integer ((guint64) _tmp3_);
				z = _tmp4_;
				_tmp5_ = z;
				_tmp6_ = number_to_unsigned_integer (_tmp5_);
				_tmp7_ = a;
				if (_tmp6_ != ((guint64) _tmp7_)) {
					gint _tmp8_ = 0;
					Number* _tmp9_ = NULL;
					guint64 _tmp10_ = 0ULL;
					gint _tmp11_ = 0;
					gchar* _tmp12_ = NULL;
					gchar* _tmp13_ = NULL;
					_tmp8_ = a;
					_tmp9_ = z;
					_tmp10_ = number_to_unsigned_integer (_tmp9_);
					_tmp11_ = a;
					_tmp12_ = g_strdup_printf ("Number.unsigned_integer (%d).to_unsigned_integer () -> %i, expected %i", _tmp8_, (gint) _tmp10_, _tmp11_);
					_tmp13_ = _tmp12_;
					fail (_tmp13_);
					_g_free0 (_tmp13_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_fraction (void) {
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = 1;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							gint _tmp7_ = 0;
							Number* _tmp8_ = NULL;
							gdouble expected = 0.0;
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							Number* _tmp11_ = NULL;
							gdouble _tmp12_ = 0.0;
							gboolean _tmp13_ = FALSE;
							if (!_tmp3_) {
								gint _tmp4_ = 0;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ <= 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = b;
							_tmp8_ = number_new_fraction ((gint64) _tmp6_, (gint64) _tmp7_);
							z = _tmp8_;
							_tmp9_ = a;
							_tmp10_ = b;
							expected = ((gdouble) _tmp9_) / _tmp10_;
							_tmp11_ = z;
							_tmp12_ = expected;
							_tmp13_ = double_matches (_tmp11_, _tmp12_);
							if (!_tmp13_) {
								gint _tmp14_ = 0;
								gint _tmp15_ = 0;
								Number* _tmp16_ = NULL;
								gdouble _tmp17_ = 0.0;
								gdouble _tmp18_ = 0.0;
								gchar* _tmp19_ = NULL;
								gchar* _tmp20_ = NULL;
								_tmp14_ = a;
								_tmp15_ = b;
								_tmp16_ = z;
								_tmp17_ = number_to_double (_tmp16_);
								_tmp18_ = expected;
								_tmp19_ = g_strdup_printf ("Number.fraction (%d, %d) -> %f, expected %f", _tmp14_, _tmp15_, _tmp17_, _tmp18_);
								_tmp20_ = _tmp19_;
								fail (_tmp20_);
								_g_free0 (_tmp20_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void test_float (void) {
	{
		gfloat a = 0.0F;
		a = -10.0f;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gfloat _tmp2_ = 0.0F;
				Number* z = NULL;
				gfloat _tmp3_ = 0.0F;
				Number* _tmp4_ = NULL;
				Number* _tmp5_ = NULL;
				gfloat _tmp6_ = 0.0F;
				gfloat _tmp7_ = 0.0F;
				if (!_tmp0_) {
					gfloat _tmp1_ = 0.0F;
					_tmp1_ = a;
					a = _tmp1_ + 0.5f;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10.0f)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_float (_tmp3_);
				z = _tmp4_;
				_tmp5_ = z;
				_tmp6_ = number_to_float (_tmp5_);
				_tmp7_ = a;
				if (_tmp6_ != _tmp7_) {
					gfloat _tmp8_ = 0.0F;
					Number* _tmp9_ = NULL;
					gfloat _tmp10_ = 0.0F;
					gfloat _tmp11_ = 0.0F;
					gchar* _tmp12_ = NULL;
					gchar* _tmp13_ = NULL;
					_tmp8_ = a;
					_tmp9_ = z;
					_tmp10_ = number_to_float (_tmp9_);
					_tmp11_ = a;
					_tmp12_ = g_strdup_printf ("Number.float (%f).to_float () -> %f, expected %f", (gdouble) _tmp8_, (gdouble) _tmp10_, (gdouble) _tmp11_);
					_tmp13_ = _tmp12_;
					fail (_tmp13_);
					_g_free0 (_tmp13_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_double (void) {
	{
		gdouble a = 0.0;
		a = -10.0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gdouble _tmp2_ = 0.0;
				Number* z = NULL;
				gdouble _tmp3_ = 0.0;
				Number* _tmp4_ = NULL;
				Number* _tmp5_ = NULL;
				gdouble _tmp6_ = 0.0;
				gdouble _tmp7_ = 0.0;
				if (!_tmp0_) {
					gdouble _tmp1_ = 0.0;
					_tmp1_ = a;
					a = _tmp1_ + 0.5;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10.0)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_double (_tmp3_);
				z = _tmp4_;
				_tmp5_ = z;
				_tmp6_ = number_to_double (_tmp5_);
				_tmp7_ = a;
				if (_tmp6_ != _tmp7_) {
					gdouble _tmp8_ = 0.0;
					Number* _tmp9_ = NULL;
					gdouble _tmp10_ = 0.0;
					gdouble _tmp11_ = 0.0;
					gchar* _tmp12_ = NULL;
					gchar* _tmp13_ = NULL;
					_tmp8_ = a;
					_tmp9_ = z;
					_tmp10_ = number_to_double (_tmp9_);
					_tmp11_ = a;
					_tmp12_ = g_strdup_printf ("Number.double (%f).to_double () -> %f, expected %f", _tmp8_, _tmp10_, _tmp11_);
					_tmp13_ = _tmp12_;
					fail (_tmp13_);
					_g_free0 (_tmp13_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_complex (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							Number* _tmp7_ = NULL;
							Number* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							Number* _tmp11_ = NULL;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							gint re_expected = 0;
							gint _tmp14_ = 0;
							gint im_expected = 0;
							gint _tmp15_ = 0;
							gboolean _tmp16_ = FALSE;
							Number* _tmp17_ = NULL;
							Number* _tmp18_ = NULL;
							Number* _tmp19_ = NULL;
							gint64 _tmp20_ = 0LL;
							gint _tmp21_ = 0;
							gboolean _tmp22_ = FALSE;
							if (!_tmp3_) {
								gint _tmp4_ = 0;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ <= 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = number_new_integer ((gint64) _tmp6_);
							_tmp8_ = _tmp7_;
							_tmp9_ = b;
							_tmp10_ = number_new_integer ((gint64) _tmp9_);
							_tmp11_ = _tmp10_;
							_tmp12_ = number_new_complex (_tmp8_, _tmp11_);
							_tmp13_ = _tmp12_;
							_number_unref0 (_tmp11_);
							_number_unref0 (_tmp8_);
							z = _tmp13_;
							_tmp14_ = a;
							re_expected = _tmp14_;
							_tmp15_ = b;
							im_expected = _tmp15_;
							_tmp17_ = z;
							_tmp18_ = number_real_component (_tmp17_);
							_tmp19_ = _tmp18_;
							_tmp20_ = number_to_integer (_tmp19_);
							_tmp21_ = re_expected;
							_tmp22_ = _tmp20_ != ((gint64) _tmp21_);
							_number_unref0 (_tmp19_);
							if (_tmp22_) {
								_tmp16_ = TRUE;
							} else {
								Number* _tmp23_ = NULL;
								Number* _tmp24_ = NULL;
								Number* _tmp25_ = NULL;
								gint64 _tmp26_ = 0LL;
								gint _tmp27_ = 0;
								_tmp23_ = z;
								_tmp24_ = number_imaginary_component (_tmp23_);
								_tmp25_ = _tmp24_;
								_tmp26_ = number_to_integer (_tmp25_);
								_tmp27_ = im_expected;
								_tmp16_ = _tmp26_ != ((gint64) _tmp27_);
								_number_unref0 (_tmp25_);
							}
							if (_tmp16_) {
								gint _tmp28_ = 0;
								gint _tmp29_ = 0;
								Number* _tmp30_ = NULL;
								Number* _tmp31_ = NULL;
								Number* _tmp32_ = NULL;
								gint64 _tmp33_ = 0LL;
								Number* _tmp34_ = NULL;
								Number* _tmp35_ = NULL;
								Number* _tmp36_ = NULL;
								gint64 _tmp37_ = 0LL;
								gint _tmp38_ = 0;
								gint _tmp39_ = 0;
								gchar* _tmp40_ = NULL;
								gchar* _tmp41_ = NULL;
								_tmp28_ = a;
								_tmp29_ = b;
								_tmp30_ = z;
								_tmp31_ = number_real_component (_tmp30_);
								_tmp32_ = _tmp31_;
								_tmp33_ = number_to_integer (_tmp32_);
								_tmp34_ = z;
								_tmp35_ = number_imaginary_component (_tmp34_);
								_tmp36_ = _tmp35_;
								_tmp37_ = number_to_integer (_tmp36_);
								_tmp38_ = re_expected;
								_tmp39_ = im_expected;
								_tmp40_ = g_strdup_printf ("Number.complex (%d%+di) -> %d%+di, expected %d%+di", _tmp28_, _tmp29_, (gint) _tmp33_, (gint) _tmp37_, _tmp38_, _tmp39_);
								_tmp41_ = _tmp40_;
								fail (_tmp41_);
								_g_free0 (_tmp41_);
								_number_unref0 (_tmp36_);
								_number_unref0 (_tmp32_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
}


void test_polar (void) {
	{
		gint ri = 0;
		ri = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = ri;
					ri = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = ri;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				{
					gint theta_i = 0;
					theta_i = -10;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_ = 0;
							gdouble r = 0.0;
							gint _tmp6_ = 0;
							gdouble theta = 0.0;
							gint _tmp7_ = 0;
							Number* z = NULL;
							gdouble _tmp8_ = 0.0;
							Number* _tmp9_ = NULL;
							Number* _tmp10_ = NULL;
							gdouble _tmp11_ = 0.0;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							Number* _tmp14_ = NULL;
							Number* _tmp15_ = NULL;
							gdouble re_expected = 0.0;
							gdouble _tmp16_ = 0.0;
							gdouble _tmp17_ = 0.0;
							gdouble _tmp18_ = 0.0;
							gdouble im_expected = 0.0;
							gdouble _tmp19_ = 0.0;
							gdouble _tmp20_ = 0.0;
							gdouble _tmp21_ = 0.0;
							gboolean _tmp22_ = FALSE;
							Number* _tmp23_ = NULL;
							Number* _tmp24_ = NULL;
							Number* _tmp25_ = NULL;
							gdouble _tmp26_ = 0.0;
							gboolean _tmp27_ = FALSE;
							gboolean _tmp28_ = FALSE;
							if (!_tmp3_) {
								gint _tmp4_ = 0;
								_tmp4_ = theta_i;
								theta_i = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = theta_i;
							if (!(_tmp5_ <= 10)) {
								break;
							}
							_tmp6_ = ri;
							r = (gdouble) _tmp6_;
							_tmp7_ = theta_i;
							theta = ((2 * G_PI) * _tmp7_) / 10.0;
							_tmp8_ = r;
							_tmp9_ = number_new_double (_tmp8_);
							_tmp10_ = _tmp9_;
							_tmp11_ = theta;
							_tmp12_ = number_new_double (_tmp11_);
							_tmp13_ = _tmp12_;
							_tmp14_ = number_new_polar (_tmp10_, _tmp13_, ANGLE_UNIT_RADIANS);
							_tmp15_ = _tmp14_;
							_number_unref0 (_tmp13_);
							_number_unref0 (_tmp10_);
							z = _tmp15_;
							_tmp16_ = r;
							_tmp17_ = theta;
							_tmp18_ = cos (_tmp17_);
							re_expected = _tmp16_ * _tmp18_;
							_tmp19_ = r;
							_tmp20_ = theta;
							_tmp21_ = sin (_tmp20_);
							im_expected = _tmp19_ * _tmp21_;
							_tmp23_ = z;
							_tmp24_ = number_real_component (_tmp23_);
							_tmp25_ = _tmp24_;
							_tmp26_ = re_expected;
							_tmp27_ = double_matches (_tmp25_, _tmp26_);
							_tmp28_ = !_tmp27_;
							_number_unref0 (_tmp25_);
							if (_tmp28_) {
								_tmp22_ = TRUE;
							} else {
								Number* _tmp29_ = NULL;
								Number* _tmp30_ = NULL;
								Number* _tmp31_ = NULL;
								gdouble _tmp32_ = 0.0;
								gboolean _tmp33_ = FALSE;
								_tmp29_ = z;
								_tmp30_ = number_imaginary_component (_tmp29_);
								_tmp31_ = _tmp30_;
								_tmp32_ = im_expected;
								_tmp33_ = double_matches (_tmp31_, _tmp32_);
								_tmp22_ = !_tmp33_;
								_number_unref0 (_tmp31_);
							}
							if (_tmp22_) {
								gdouble _tmp34_ = 0.0;
								gdouble _tmp35_ = 0.0;
								Number* _tmp36_ = NULL;
								Number* _tmp37_ = NULL;
								Number* _tmp38_ = NULL;
								gdouble _tmp39_ = 0.0;
								Number* _tmp40_ = NULL;
								Number* _tmp41_ = NULL;
								Number* _tmp42_ = NULL;
								gdouble _tmp43_ = 0.0;
								gdouble _tmp44_ = 0.0;
								gdouble _tmp45_ = 0.0;
								gchar* _tmp46_ = NULL;
								gchar* _tmp47_ = NULL;
								_tmp34_ = r;
								_tmp35_ = theta;
								_tmp36_ = z;
								_tmp37_ = number_real_component (_tmp36_);
								_tmp38_ = _tmp37_;
								_tmp39_ = number_to_double (_tmp38_);
								_tmp40_ = z;
								_tmp41_ = number_imaginary_component (_tmp40_);
								_tmp42_ = _tmp41_;
								_tmp43_ = number_to_double (_tmp42_);
								_tmp44_ = re_expected;
								_tmp45_ = im_expected;
								_tmp46_ = g_strdup_printf ("Number.polar (%f, %f) -> %f%+fi, expected %f%+fi", _tmp34_, _tmp35_, _tmp39_, _tmp43_, _tmp44_, _tmp45_);
								_tmp47_ = _tmp46_;
								fail (_tmp47_);
								_g_free0 (_tmp47_);
								_number_unref0 (_tmp42_);
								_number_unref0 (_tmp38_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
}


void test_i (void) {
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	gint64 _tmp5_ = 0LL;
	gboolean _tmp6_ = FALSE;
	_tmp0_ = number_new_i ();
	z = _tmp0_;
	_tmp2_ = z;
	_tmp3_ = number_real_component (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = number_to_integer (_tmp4_);
	_tmp6_ = _tmp5_ != ((gint64) 0);
	_number_unref0 (_tmp4_);
	if (_tmp6_) {
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		gint64 _tmp10_ = 0LL;
		_tmp7_ = z;
		_tmp8_ = number_imaginary_component (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = number_to_integer (_tmp9_);
		_tmp1_ = _tmp10_ != ((gint64) 1);
		_number_unref0 (_tmp9_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		gint64 _tmp14_ = 0LL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		gint64 _tmp18_ = 0LL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		_tmp11_ = z;
		_tmp12_ = number_real_component (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = number_to_integer (_tmp13_);
		_tmp15_ = z;
		_tmp16_ = number_imaginary_component (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = number_to_integer (_tmp17_);
		_tmp19_ = g_strdup_printf ("Number.i () -> %d%+di, expected i", (gint) _tmp14_, (gint) _tmp18_);
		_tmp20_ = _tmp19_;
		fail (_tmp20_);
		_g_free0 (_tmp20_);
		_number_unref0 (_tmp17_);
		_number_unref0 (_tmp13_);
		_number_unref0 (z);
		return;
	}
	pass (NULL);
	_number_unref0 (z);
}


void test_pi (void) {
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	gdouble expected = 0.0;
	Number* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gboolean _tmp3_ = FALSE;
	_tmp0_ = number_new_pi ();
	z = _tmp0_;
	expected = G_PI;
	_tmp1_ = z;
	_tmp2_ = expected;
	_tmp3_ = double_matches (_tmp1_, _tmp2_);
	if (!_tmp3_) {
		Number* _tmp4_ = NULL;
		gdouble _tmp5_ = 0.0;
		gdouble _tmp6_ = 0.0;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp4_ = z;
		_tmp5_ = number_to_double (_tmp4_);
		_tmp6_ = expected;
		_tmp7_ = g_strdup_printf ("Number.pi () -> %f, expected %f", _tmp5_, _tmp6_);
		_tmp8_ = _tmp7_;
		fail (_tmp8_);
		_g_free0 (_tmp8_);
		_number_unref0 (z);
		return;
	}
	pass (NULL);
	_number_unref0 (z);
}


void test_eulers (void) {
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	gdouble expected = 0.0;
	Number* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gboolean _tmp3_ = FALSE;
	_tmp0_ = number_new_eulers ();
	z = _tmp0_;
	expected = G_E;
	_tmp1_ = z;
	_tmp2_ = expected;
	_tmp3_ = double_matches (_tmp1_, _tmp2_);
	if (!_tmp3_) {
		Number* _tmp4_ = NULL;
		gdouble _tmp5_ = 0.0;
		gdouble _tmp6_ = 0.0;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp4_ = z;
		_tmp5_ = number_to_double (_tmp4_);
		_tmp6_ = expected;
		_tmp7_ = g_strdup_printf ("Number.eulers () -> %f, expected %f", _tmp5_, _tmp6_);
		_tmp8_ = _tmp7_;
		fail (_tmp8_);
		_g_free0 (_tmp8_);
		_number_unref0 (z);
		return;
	}
	pass (NULL);
	_number_unref0 (z);
}


void test_string (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gchar* s = NULL;
				gint _tmp3_ = 0;
				gchar* _tmp4_ = NULL;
				Number* z = NULL;
				const gchar* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp11_ = NULL;
				gint64 _tmp12_ = 0LL;
				gint _tmp13_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = g_strdup_printf ("%d", _tmp3_);
				s = _tmp4_;
				_tmp5_ = s;
				_tmp6_ = mp_set_from_string (_tmp5_, 10);
				z = _tmp6_;
				_tmp7_ = z;
				if (_tmp7_ == NULL) {
					const gchar* _tmp8_ = NULL;
					gchar* _tmp9_ = NULL;
					gchar* _tmp10_ = NULL;
					_tmp8_ = s;
					_tmp9_ = g_strdup_printf ("mp_set_from_string (\"%s\") -> null", _tmp8_);
					_tmp10_ = _tmp9_;
					fail (_tmp10_);
					_g_free0 (_tmp10_);
					_number_unref0 (z);
					_g_free0 (s);
					return;
				}
				_tmp11_ = z;
				_tmp12_ = number_to_integer (_tmp11_);
				_tmp13_ = a;
				if (_tmp12_ != ((gint64) _tmp13_)) {
					const gchar* _tmp14_ = NULL;
					Number* _tmp15_ = NULL;
					gint64 _tmp16_ = 0LL;
					gint _tmp17_ = 0;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					_tmp14_ = s;
					_tmp15_ = z;
					_tmp16_ = number_to_integer (_tmp15_);
					_tmp17_ = a;
					_tmp18_ = g_strdup_printf ("mp_set_from_string (\"%s\").to_integer () -> %d, expected %d", _tmp14_, (gint) _tmp16_, _tmp17_);
					_tmp19_ = _tmp18_;
					fail (_tmp19_);
					_g_free0 (_tmp19_);
					_number_unref0 (z);
					_g_free0 (s);
					return;
				}
				_number_unref0 (z);
				_g_free0 (s);
			}
		}
	}
	pass (NULL);
}


void test_sgn (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				Number* z = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				gint expected = 0;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				Number* _tmp9_ = NULL;
				gint64 _tmp10_ = 0LL;
				gint _tmp11_ = 0;
				gboolean _tmp12_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_integer ((gint64) _tmp3_);
				z = _tmp4_;
				expected = 0;
				_tmp5_ = a;
				if (_tmp5_ < 0) {
					expected = -1;
				}
				_tmp6_ = a;
				if (_tmp6_ > 0) {
					expected = 1;
				}
				_tmp7_ = z;
				_tmp8_ = number_sgn (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = number_to_integer (_tmp9_);
				_tmp11_ = expected;
				_tmp12_ = _tmp10_ != ((gint64) _tmp11_);
				_number_unref0 (_tmp9_);
				if (_tmp12_) {
					gint _tmp13_ = 0;
					Number* _tmp14_ = NULL;
					Number* _tmp15_ = NULL;
					Number* _tmp16_ = NULL;
					gint64 _tmp17_ = 0LL;
					gint _tmp18_ = 0;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_ = NULL;
					_tmp13_ = a;
					_tmp14_ = z;
					_tmp15_ = number_sgn (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = number_to_integer (_tmp16_);
					_tmp18_ = expected;
					_tmp19_ = g_strdup_printf ("(%d).sgn () -> %d, expected %d", _tmp13_, (gint) _tmp17_, _tmp18_);
					_tmp20_ = _tmp19_;
					fail (_tmp20_);
					_g_free0 (_tmp20_);
					_number_unref0 (_tmp16_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_invert_sign (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				Number* z = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				gint expected = 0;
				gint _tmp5_ = 0;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				gint64 _tmp9_ = 0LL;
				gint _tmp10_ = 0;
				gboolean _tmp11_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_integer ((gint64) _tmp3_);
				z = _tmp4_;
				_tmp5_ = a;
				expected = -_tmp5_;
				_tmp6_ = z;
				_tmp7_ = number_invert_sign (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = number_to_integer (_tmp8_);
				_tmp10_ = expected;
				_tmp11_ = _tmp9_ != ((gint64) _tmp10_);
				_number_unref0 (_tmp8_);
				if (_tmp11_) {
					gint _tmp12_ = 0;
					Number* _tmp13_ = NULL;
					Number* _tmp14_ = NULL;
					Number* _tmp15_ = NULL;
					gint64 _tmp16_ = 0LL;
					gint _tmp17_ = 0;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					_tmp12_ = a;
					_tmp13_ = z;
					_tmp14_ = number_invert_sign (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = number_to_integer (_tmp15_);
					_tmp17_ = expected;
					_tmp18_ = g_strdup_printf ("(%d).invert_sign () -> %d, expected %d", _tmp12_, (gint) _tmp16_, _tmp17_);
					_tmp19_ = _tmp18_;
					fail (_tmp19_);
					_g_free0 (_tmp19_);
					_number_unref0 (_tmp15_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_abs (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				Number* z = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				gint expected = 0;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				Number* _tmp9_ = NULL;
				gint64 _tmp10_ = 0LL;
				gint _tmp11_ = 0;
				gboolean _tmp12_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_integer ((gint64) _tmp3_);
				z = _tmp4_;
				_tmp5_ = a;
				_tmp6_ = abs (_tmp5_);
				expected = _tmp6_;
				_tmp7_ = z;
				_tmp8_ = number_abs (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = number_to_integer (_tmp9_);
				_tmp11_ = expected;
				_tmp12_ = _tmp10_ != ((gint64) _tmp11_);
				_number_unref0 (_tmp9_);
				if (_tmp12_) {
					gint _tmp13_ = 0;
					Number* _tmp14_ = NULL;
					Number* _tmp15_ = NULL;
					Number* _tmp16_ = NULL;
					gint64 _tmp17_ = 0LL;
					gint _tmp18_ = 0;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_ = NULL;
					_tmp13_ = a;
					_tmp14_ = z;
					_tmp15_ = number_abs (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = number_to_integer (_tmp16_);
					_tmp18_ = expected;
					_tmp19_ = g_strdup_printf ("(%d).abs () -> %d, expected %d", _tmp13_, (gint) _tmp17_, _tmp18_);
					_tmp20_ = _tmp19_;
					fail (_tmp20_);
					_g_free0 (_tmp20_);
					_number_unref0 (_tmp16_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_arg (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							Number* _tmp7_ = NULL;
							Number* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							Number* _tmp11_ = NULL;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							Number* _tmp14_ = NULL;
							Number* _tmp15_ = NULL;
							gdouble expected = 0.0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							gdouble _tmp18_ = 0.0;
							gboolean _tmp19_ = FALSE;
							Number* _tmp20_ = NULL;
							Number* _tmp21_ = NULL;
							Number* _tmp22_ = NULL;
							gdouble _tmp23_ = 0.0;
							gboolean _tmp24_ = FALSE;
							gboolean _tmp25_ = FALSE;
							if (!_tmp3_) {
								gint _tmp4_ = 0;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ <= 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = number_new_integer ((gint64) _tmp6_);
							_tmp8_ = _tmp7_;
							_tmp9_ = b;
							_tmp10_ = number_new_integer ((gint64) _tmp9_);
							_tmp11_ = _tmp10_;
							_tmp12_ = number_new_complex (_tmp8_, _tmp11_);
							_tmp13_ = _tmp12_;
							_number_unref0 (_tmp11_);
							_number_unref0 (_tmp8_);
							z = _tmp13_;
							_tmp14_ = z;
							_tmp15_ = number_arg (_tmp14_, ANGLE_UNIT_RADIANS);
							_number_unref0 (z);
							z = _tmp15_;
							_tmp16_ = b;
							_tmp17_ = a;
							_tmp18_ = atan2 ((gdouble) _tmp16_, (gdouble) _tmp17_);
							expected = _tmp18_;
							_tmp20_ = z;
							_tmp21_ = number_real_component (_tmp20_);
							_tmp22_ = _tmp21_;
							_tmp23_ = expected;
							_tmp24_ = double_matches (_tmp22_, _tmp23_);
							_tmp25_ = !_tmp24_;
							_number_unref0 (_tmp22_);
							if (_tmp25_) {
								_tmp19_ = TRUE;
							} else {
								Number* _tmp26_ = NULL;
								Number* _tmp27_ = NULL;
								Number* _tmp28_ = NULL;
								gboolean _tmp29_ = FALSE;
								_tmp26_ = z;
								_tmp27_ = number_imaginary_component (_tmp26_);
								_tmp28_ = _tmp27_;
								_tmp29_ = number_is_zero (_tmp28_);
								_tmp19_ = !_tmp29_;
								_number_unref0 (_tmp28_);
							}
							if (_tmp19_) {
								gint _tmp30_ = 0;
								gint _tmp31_ = 0;
								Number* _tmp32_ = NULL;
								Number* _tmp33_ = NULL;
								Number* _tmp34_ = NULL;
								gdouble _tmp35_ = 0.0;
								Number* _tmp36_ = NULL;
								Number* _tmp37_ = NULL;
								Number* _tmp38_ = NULL;
								gdouble _tmp39_ = 0.0;
								gdouble _tmp40_ = 0.0;
								gchar* _tmp41_ = NULL;
								gchar* _tmp42_ = NULL;
								_tmp30_ = a;
								_tmp31_ = b;
								_tmp32_ = z;
								_tmp33_ = number_real_component (_tmp32_);
								_tmp34_ = _tmp33_;
								_tmp35_ = number_to_double (_tmp34_);
								_tmp36_ = z;
								_tmp37_ = number_imaginary_component (_tmp36_);
								_tmp38_ = _tmp37_;
								_tmp39_ = number_to_double (_tmp38_);
								_tmp40_ = expected;
								_tmp41_ = g_strdup_printf ("(%d%+di).arg () -> %f%+fi, expected %f", _tmp30_, _tmp31_, _tmp35_, _tmp39_, _tmp40_);
								_tmp42_ = _tmp41_;
								fail (_tmp42_);
								_g_free0 (_tmp42_);
								_number_unref0 (_tmp38_);
								_number_unref0 (_tmp34_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
}


void test_conjugate (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							Number* _tmp7_ = NULL;
							Number* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							Number* _tmp11_ = NULL;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							Number* _tmp14_ = NULL;
							Number* _tmp15_ = NULL;
							gint re_expected = 0;
							gint _tmp16_ = 0;
							gint im_expected = 0;
							gint _tmp17_ = 0;
							gboolean _tmp18_ = FALSE;
							Number* _tmp19_ = NULL;
							Number* _tmp20_ = NULL;
							Number* _tmp21_ = NULL;
							gint64 _tmp22_ = 0LL;
							gint _tmp23_ = 0;
							gboolean _tmp24_ = FALSE;
							if (!_tmp3_) {
								gint _tmp4_ = 0;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ <= 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = number_new_integer ((gint64) _tmp6_);
							_tmp8_ = _tmp7_;
							_tmp9_ = b;
							_tmp10_ = number_new_integer ((gint64) _tmp9_);
							_tmp11_ = _tmp10_;
							_tmp12_ = number_new_complex (_tmp8_, _tmp11_);
							_tmp13_ = _tmp12_;
							_number_unref0 (_tmp11_);
							_number_unref0 (_tmp8_);
							z = _tmp13_;
							_tmp14_ = z;
							_tmp15_ = number_conjugate (_tmp14_);
							_number_unref0 (z);
							z = _tmp15_;
							_tmp16_ = a;
							re_expected = _tmp16_;
							_tmp17_ = b;
							im_expected = -_tmp17_;
							_tmp19_ = z;
							_tmp20_ = number_real_component (_tmp19_);
							_tmp21_ = _tmp20_;
							_tmp22_ = number_to_integer (_tmp21_);
							_tmp23_ = re_expected;
							_tmp24_ = _tmp22_ != ((gint64) _tmp23_);
							_number_unref0 (_tmp21_);
							if (_tmp24_) {
								_tmp18_ = TRUE;
							} else {
								Number* _tmp25_ = NULL;
								Number* _tmp26_ = NULL;
								Number* _tmp27_ = NULL;
								gint64 _tmp28_ = 0LL;
								gint _tmp29_ = 0;
								_tmp25_ = z;
								_tmp26_ = number_imaginary_component (_tmp25_);
								_tmp27_ = _tmp26_;
								_tmp28_ = number_to_integer (_tmp27_);
								_tmp29_ = im_expected;
								_tmp18_ = _tmp28_ != ((gint64) _tmp29_);
								_number_unref0 (_tmp27_);
							}
							if (_tmp18_) {
								gint _tmp30_ = 0;
								gint _tmp31_ = 0;
								Number* _tmp32_ = NULL;
								Number* _tmp33_ = NULL;
								Number* _tmp34_ = NULL;
								gint64 _tmp35_ = 0LL;
								Number* _tmp36_ = NULL;
								Number* _tmp37_ = NULL;
								Number* _tmp38_ = NULL;
								gint64 _tmp39_ = 0LL;
								gint _tmp40_ = 0;
								gint _tmp41_ = 0;
								gchar* _tmp42_ = NULL;
								gchar* _tmp43_ = NULL;
								_tmp30_ = a;
								_tmp31_ = b;
								_tmp32_ = z;
								_tmp33_ = number_real_component (_tmp32_);
								_tmp34_ = _tmp33_;
								_tmp35_ = number_to_integer (_tmp34_);
								_tmp36_ = z;
								_tmp37_ = number_imaginary_component (_tmp36_);
								_tmp38_ = _tmp37_;
								_tmp39_ = number_to_integer (_tmp38_);
								_tmp40_ = re_expected;
								_tmp41_ = im_expected;
								_tmp42_ = g_strdup_printf ("(%d%+di).real_component () -> %d%+di, expected %d%+di", _tmp30_, _tmp31_, (gint) _tmp35_, (gint) _tmp39_, _tmp40_, _tmp41_);
								_tmp43_ = _tmp42_;
								fail (_tmp43_);
								_g_free0 (_tmp43_);
								_number_unref0 (_tmp38_);
								_number_unref0 (_tmp34_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
}


void test_real_component (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							Number* _tmp7_ = NULL;
							Number* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							Number* _tmp11_ = NULL;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							gint expected = 0;
							gint _tmp14_ = 0;
							Number* _tmp15_ = NULL;
							Number* _tmp16_ = NULL;
							Number* _tmp17_ = NULL;
							gint64 _tmp18_ = 0LL;
							gint _tmp19_ = 0;
							gboolean _tmp20_ = FALSE;
							if (!_tmp3_) {
								gint _tmp4_ = 0;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ <= 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = number_new_integer ((gint64) _tmp6_);
							_tmp8_ = _tmp7_;
							_tmp9_ = b;
							_tmp10_ = number_new_integer ((gint64) _tmp9_);
							_tmp11_ = _tmp10_;
							_tmp12_ = number_new_complex (_tmp8_, _tmp11_);
							_tmp13_ = _tmp12_;
							_number_unref0 (_tmp11_);
							_number_unref0 (_tmp8_);
							z = _tmp13_;
							_tmp14_ = a;
							expected = _tmp14_;
							_tmp15_ = z;
							_tmp16_ = number_real_component (_tmp15_);
							_tmp17_ = _tmp16_;
							_tmp18_ = number_to_integer (_tmp17_);
							_tmp19_ = expected;
							_tmp20_ = _tmp18_ != ((gint64) _tmp19_);
							_number_unref0 (_tmp17_);
							if (_tmp20_) {
								gint _tmp21_ = 0;
								gint _tmp22_ = 0;
								Number* _tmp23_ = NULL;
								Number* _tmp24_ = NULL;
								Number* _tmp25_ = NULL;
								gint64 _tmp26_ = 0LL;
								gint _tmp27_ = 0;
								gchar* _tmp28_ = NULL;
								gchar* _tmp29_ = NULL;
								_tmp21_ = a;
								_tmp22_ = b;
								_tmp23_ = z;
								_tmp24_ = number_real_component (_tmp23_);
								_tmp25_ = _tmp24_;
								_tmp26_ = number_to_integer (_tmp25_);
								_tmp27_ = expected;
								_tmp28_ = g_strdup_printf ("(%d+%di).real_component () -> %d, expected %d", _tmp21_, _tmp22_, (gint) _tmp26_, _tmp27_);
								_tmp29_ = _tmp28_;
								fail (_tmp29_);
								_g_free0 (_tmp29_);
								_number_unref0 (_tmp25_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void test_imaginary_component (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							Number* _tmp7_ = NULL;
							Number* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							Number* _tmp11_ = NULL;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							gint expected = 0;
							gint _tmp14_ = 0;
							Number* _tmp15_ = NULL;
							Number* _tmp16_ = NULL;
							Number* _tmp17_ = NULL;
							gint64 _tmp18_ = 0LL;
							gint _tmp19_ = 0;
							gboolean _tmp20_ = FALSE;
							if (!_tmp3_) {
								gint _tmp4_ = 0;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ <= 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = number_new_integer ((gint64) _tmp6_);
							_tmp8_ = _tmp7_;
							_tmp9_ = b;
							_tmp10_ = number_new_integer ((gint64) _tmp9_);
							_tmp11_ = _tmp10_;
							_tmp12_ = number_new_complex (_tmp8_, _tmp11_);
							_tmp13_ = _tmp12_;
							_number_unref0 (_tmp11_);
							_number_unref0 (_tmp8_);
							z = _tmp13_;
							_tmp14_ = b;
							expected = _tmp14_;
							_tmp15_ = z;
							_tmp16_ = number_imaginary_component (_tmp15_);
							_tmp17_ = _tmp16_;
							_tmp18_ = number_to_integer (_tmp17_);
							_tmp19_ = expected;
							_tmp20_ = _tmp18_ != ((gint64) _tmp19_);
							_number_unref0 (_tmp17_);
							if (_tmp20_) {
								gint _tmp21_ = 0;
								gint _tmp22_ = 0;
								Number* _tmp23_ = NULL;
								Number* _tmp24_ = NULL;
								Number* _tmp25_ = NULL;
								gint64 _tmp26_ = 0LL;
								gint _tmp27_ = 0;
								gchar* _tmp28_ = NULL;
								gchar* _tmp29_ = NULL;
								_tmp21_ = a;
								_tmp22_ = b;
								_tmp23_ = z;
								_tmp24_ = number_imaginary_component (_tmp23_);
								_tmp25_ = _tmp24_;
								_tmp26_ = number_to_integer (_tmp25_);
								_tmp27_ = expected;
								_tmp28_ = g_strdup_printf ("(%d+%di).imaginary_component () -> %d, expected %d", _tmp21_, _tmp22_, (gint) _tmp26_, _tmp27_);
								_tmp29_ = _tmp28_;
								fail (_tmp29_);
								_g_free0 (_tmp29_);
								_number_unref0 (_tmp25_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


gboolean double_matches (Number* a, gdouble b) {
	gboolean result = FALSE;
	Number* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gdouble _tmp4_ = 0.0;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	g_return_val_if_fail (a != NULL, FALSE);
	_tmp0_ = a;
	_tmp1_ = number_to_double (_tmp0_);
	_tmp2_ = double_string (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = b;
	_tmp5_ = double_string (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strcmp0 (_tmp3_, _tmp6_) == 0;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	result = _tmp7_;
	return result;
}


gchar* double_string (gdouble x) {
	gchar* result = NULL;
	gchar* value = NULL;
	gdouble _tmp0_ = 0.0;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	_tmp0_ = x;
	_tmp1_ = g_strdup_printf ("%.6f", _tmp0_);
	value = _tmp1_;
	_tmp2_ = value;
	if (g_strcmp0 (_tmp2_, "-0.000000") == 0) {
		gchar* _tmp3_ = NULL;
		_tmp3_ = g_strdup ("0.000000");
		result = _tmp3_;
		_g_free0 (value);
		return result;
	} else {
		result = value;
		return result;
	}
	_g_free0 (value);
}


void test_integer_component (void) {
	{
		gint ai = 0;
		ai = -100;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gdouble a = 0.0;
				gint _tmp3_ = 0;
				Number* z = NULL;
				gdouble _tmp4_ = 0.0;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				gdouble expected = 0.0;
				gdouble _tmp9_ = 0.0;
				gdouble _tmp10_ = 0.0;
				Number* _tmp11_ = NULL;
				gdouble _tmp12_ = 0.0;
				gboolean _tmp13_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = ai;
					ai = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = ai;
				if (!(_tmp2_ <= 100)) {
					break;
				}
				_tmp3_ = ai;
				a = _tmp3_ / 10.0;
				_tmp4_ = a;
				_tmp5_ = number_new_double (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = number_integer_component (_tmp6_);
				_tmp8_ = _tmp7_;
				_number_unref0 (_tmp6_);
				z = _tmp8_;
				_tmp9_ = a;
				_tmp10_ = trunc (_tmp9_);
				expected = _tmp10_;
				_tmp11_ = z;
				_tmp12_ = expected;
				_tmp13_ = double_matches (_tmp11_, _tmp12_);
				if (!_tmp13_) {
					gdouble _tmp14_ = 0.0;
					Number* _tmp15_ = NULL;
					gdouble _tmp16_ = 0.0;
					gdouble _tmp17_ = 0.0;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					_tmp14_ = a;
					_tmp15_ = z;
					_tmp16_ = number_to_double (_tmp15_);
					_tmp17_ = expected;
					_tmp18_ = g_strdup_printf ("(%f).integer_component () -> %f, expected %f", _tmp14_, _tmp16_, _tmp17_);
					_tmp19_ = _tmp18_;
					fail (_tmp19_);
					_g_free0 (_tmp19_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_fractional_component (void) {
	{
		gint ai = 0;
		ai = -100;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gdouble a = 0.0;
				gint _tmp3_ = 0;
				Number* z = NULL;
				gdouble _tmp4_ = 0.0;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				gdouble expected = 0.0;
				gdouble _tmp9_ = 0.0;
				gdouble _tmp10_ = 0.0;
				gdouble _tmp11_ = 0.0;
				Number* _tmp12_ = NULL;
				gdouble _tmp13_ = 0.0;
				gboolean _tmp14_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = ai;
					ai = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = ai;
				if (!(_tmp2_ <= 100)) {
					break;
				}
				_tmp3_ = ai;
				a = _tmp3_ / 10.0;
				_tmp4_ = a;
				_tmp5_ = number_new_double (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = number_fractional_component (_tmp6_);
				_tmp8_ = _tmp7_;
				_number_unref0 (_tmp6_);
				z = _tmp8_;
				_tmp9_ = a;
				_tmp10_ = a;
				_tmp11_ = trunc (_tmp10_);
				expected = _tmp9_ - _tmp11_;
				_tmp12_ = z;
				_tmp13_ = expected;
				_tmp14_ = double_matches (_tmp12_, _tmp13_);
				if (!_tmp14_) {
					gdouble _tmp15_ = 0.0;
					Number* _tmp16_ = NULL;
					gdouble _tmp17_ = 0.0;
					gdouble _tmp18_ = 0.0;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_ = NULL;
					_tmp15_ = a;
					_tmp16_ = z;
					_tmp17_ = number_to_double (_tmp16_);
					_tmp18_ = expected;
					_tmp19_ = g_strdup_printf ("(%f).fractional_component () -> %f, expected %f", _tmp15_, _tmp17_, _tmp18_);
					_tmp20_ = _tmp19_;
					fail (_tmp20_);
					_g_free0 (_tmp20_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_fractional_part (void) {
	{
		gint ai = 0;
		ai = -100;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gdouble a = 0.0;
				gint _tmp3_ = 0;
				Number* z = NULL;
				gdouble _tmp4_ = 0.0;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				gdouble expected = 0.0;
				gdouble _tmp9_ = 0.0;
				gdouble _tmp10_ = 0.0;
				gdouble _tmp11_ = 0.0;
				Number* _tmp12_ = NULL;
				gdouble _tmp13_ = 0.0;
				gboolean _tmp14_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = ai;
					ai = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = ai;
				if (!(_tmp2_ <= 100)) {
					break;
				}
				_tmp3_ = ai;
				a = _tmp3_ / 10.0;
				_tmp4_ = a;
				_tmp5_ = number_new_double (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = number_fractional_part (_tmp6_);
				_tmp8_ = _tmp7_;
				_number_unref0 (_tmp6_);
				z = _tmp8_;
				_tmp9_ = a;
				_tmp10_ = a;
				_tmp11_ = floor (_tmp10_);
				expected = _tmp9_ - _tmp11_;
				_tmp12_ = z;
				_tmp13_ = expected;
				_tmp14_ = double_matches (_tmp12_, _tmp13_);
				if (!_tmp14_) {
					gdouble _tmp15_ = 0.0;
					Number* _tmp16_ = NULL;
					gdouble _tmp17_ = 0.0;
					gdouble _tmp18_ = 0.0;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_ = NULL;
					_tmp15_ = a;
					_tmp16_ = z;
					_tmp17_ = number_to_double (_tmp16_);
					_tmp18_ = expected;
					_tmp19_ = g_strdup_printf ("(%f).fractional_part () -> %f, expected %f", _tmp15_, _tmp17_, _tmp18_);
					_tmp20_ = _tmp19_;
					fail (_tmp20_);
					_g_free0 (_tmp20_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_floor (void) {
	{
		gint ai = 0;
		ai = -100;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gdouble a = 0.0;
				gint _tmp3_ = 0;
				Number* z = NULL;
				gdouble _tmp4_ = 0.0;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				gdouble expected = 0.0;
				gdouble _tmp9_ = 0.0;
				gdouble _tmp10_ = 0.0;
				Number* _tmp11_ = NULL;
				gdouble _tmp12_ = 0.0;
				gboolean _tmp13_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = ai;
					ai = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = ai;
				if (!(_tmp2_ <= 100)) {
					break;
				}
				_tmp3_ = ai;
				a = _tmp3_ / 10.0;
				_tmp4_ = a;
				_tmp5_ = number_new_double (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = number_floor (_tmp6_);
				_tmp8_ = _tmp7_;
				_number_unref0 (_tmp6_);
				z = _tmp8_;
				_tmp9_ = a;
				_tmp10_ = floor (_tmp9_);
				expected = _tmp10_;
				_tmp11_ = z;
				_tmp12_ = expected;
				_tmp13_ = double_matches (_tmp11_, _tmp12_);
				if (!_tmp13_) {
					gdouble _tmp14_ = 0.0;
					Number* _tmp15_ = NULL;
					gdouble _tmp16_ = 0.0;
					gdouble _tmp17_ = 0.0;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					_tmp14_ = a;
					_tmp15_ = z;
					_tmp16_ = number_to_double (_tmp15_);
					_tmp17_ = expected;
					_tmp18_ = g_strdup_printf ("(%f).floor () -> %f, expected %f", _tmp14_, _tmp16_, _tmp17_);
					_tmp19_ = _tmp18_;
					fail (_tmp19_);
					_g_free0 (_tmp19_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_ceiling (void) {
	{
		gint ai = 0;
		ai = -100;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gdouble a = 0.0;
				gint _tmp3_ = 0;
				Number* z = NULL;
				gdouble _tmp4_ = 0.0;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				gdouble expected = 0.0;
				gdouble _tmp9_ = 0.0;
				gdouble _tmp10_ = 0.0;
				Number* _tmp11_ = NULL;
				gdouble _tmp12_ = 0.0;
				gboolean _tmp13_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = ai;
					ai = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = ai;
				if (!(_tmp2_ <= 100)) {
					break;
				}
				_tmp3_ = ai;
				a = _tmp3_ / 10.0;
				_tmp4_ = a;
				_tmp5_ = number_new_double (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = number_ceiling (_tmp6_);
				_tmp8_ = _tmp7_;
				_number_unref0 (_tmp6_);
				z = _tmp8_;
				_tmp9_ = a;
				_tmp10_ = ceil (_tmp9_);
				expected = _tmp10_;
				_tmp11_ = z;
				_tmp12_ = expected;
				_tmp13_ = double_matches (_tmp11_, _tmp12_);
				if (!_tmp13_) {
					gdouble _tmp14_ = 0.0;
					Number* _tmp15_ = NULL;
					gdouble _tmp16_ = 0.0;
					gdouble _tmp17_ = 0.0;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					_tmp14_ = a;
					_tmp15_ = z;
					_tmp16_ = number_to_double (_tmp15_);
					_tmp17_ = expected;
					_tmp18_ = g_strdup_printf ("(%f).ceiling () -> %f, expected %f", _tmp14_, _tmp16_, _tmp17_);
					_tmp19_ = _tmp18_;
					fail (_tmp19_);
					_g_free0 (_tmp19_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_round (void) {
	{
		gint ai = 0;
		ai = -100;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gdouble a = 0.0;
				gint _tmp3_ = 0;
				Number* z = NULL;
				gdouble _tmp4_ = 0.0;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				gdouble expected = 0.0;
				gdouble _tmp9_ = 0.0;
				gdouble _tmp10_ = 0.0;
				Number* _tmp11_ = NULL;
				gdouble _tmp12_ = 0.0;
				gboolean _tmp13_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = ai;
					ai = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = ai;
				if (!(_tmp2_ <= 100)) {
					break;
				}
				_tmp3_ = ai;
				a = _tmp3_ / 10.0;
				_tmp4_ = a;
				_tmp5_ = number_new_double (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = number_round (_tmp6_);
				_tmp8_ = _tmp7_;
				_number_unref0 (_tmp6_);
				z = _tmp8_;
				_tmp9_ = a;
				_tmp10_ = round (_tmp9_);
				expected = _tmp10_;
				_tmp11_ = z;
				_tmp12_ = expected;
				_tmp13_ = double_matches (_tmp11_, _tmp12_);
				if (!_tmp13_) {
					gdouble _tmp14_ = 0.0;
					Number* _tmp15_ = NULL;
					gdouble _tmp16_ = 0.0;
					gdouble _tmp17_ = 0.0;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					_tmp14_ = a;
					_tmp15_ = z;
					_tmp16_ = number_to_double (_tmp15_);
					_tmp17_ = expected;
					_tmp18_ = g_strdup_printf ("(%f).round () -> %f, expected %f", _tmp14_, _tmp16_, _tmp17_);
					_tmp19_ = _tmp18_;
					fail (_tmp19_);
					_g_free0 (_tmp19_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_reciprocal (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
				Number* z = NULL;
				gint _tmp4_ = 0;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				gdouble expected = 0.0;
				gint _tmp9_ = 0;
				Number* _tmp10_ = NULL;
				gdouble _tmp11_ = 0.0;
				gboolean _tmp12_ = FALSE;
				gdouble _tmp19_ = 0.0;
				Number* _tmp20_ = NULL;
				Number* _tmp21_ = NULL;
				Number* _tmp22_ = NULL;
				Number* _tmp23_ = NULL;
				gint _tmp24_ = 0;
				gboolean _tmp25_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				if (_tmp3_ == 0) {
					continue;
				}
				_tmp4_ = a;
				_tmp5_ = number_new_double ((gdouble) _tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = number_reciprocal (_tmp6_);
				_tmp8_ = _tmp7_;
				_number_unref0 (_tmp6_);
				z = _tmp8_;
				_tmp9_ = a;
				expected = 1.0 / _tmp9_;
				_tmp10_ = z;
				_tmp11_ = expected;
				_tmp12_ = double_matches (_tmp10_, _tmp11_);
				if (!_tmp12_) {
					gint _tmp13_ = 0;
					Number* _tmp14_ = NULL;
					gdouble _tmp15_ = 0.0;
					gdouble _tmp16_ = 0.0;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					_tmp13_ = a;
					_tmp14_ = z;
					_tmp15_ = number_to_double (_tmp14_);
					_tmp16_ = expected;
					_tmp17_ = g_strdup_printf ("(%f).reciprocal () -> %f, expected %f", (gdouble) _tmp13_, _tmp15_, _tmp16_);
					_tmp18_ = _tmp17_;
					fail (_tmp18_);
					_g_free0 (_tmp18_);
					_number_unref0 (z);
					return;
				}
				_tmp19_ = expected;
				_tmp20_ = number_new_double (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = number_reciprocal (_tmp21_);
				_number_unref0 (z);
				z = _tmp22_;
				_number_unref0 (_tmp21_);
				_tmp23_ = z;
				_tmp24_ = a;
				_tmp25_ = double_matches (_tmp23_, (gdouble) _tmp24_);
				if (!_tmp25_) {
					gdouble _tmp26_ = 0.0;
					Number* _tmp27_ = NULL;
					gdouble _tmp28_ = 0.0;
					gint _tmp29_ = 0;
					gchar* _tmp30_ = NULL;
					gchar* _tmp31_ = NULL;
					_tmp26_ = expected;
					_tmp27_ = z;
					_tmp28_ = number_to_double (_tmp27_);
					_tmp29_ = a;
					_tmp30_ = g_strdup_printf ("(%f).reciprocal () -> %f, expected %f", _tmp26_, _tmp28_, (gdouble) _tmp29_);
					_tmp31_ = _tmp30_;
					fail (_tmp31_);
					_g_free0 (_tmp31_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_epowy (void) {
	{
		gint ai = 0;
		ai = -100;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gdouble a = 0.0;
				gint _tmp3_ = 0;
				Number* z = NULL;
				gdouble _tmp4_ = 0.0;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				gdouble expected = 0.0;
				gdouble _tmp9_ = 0.0;
				gdouble _tmp10_ = 0.0;
				Number* _tmp11_ = NULL;
				gdouble _tmp12_ = 0.0;
				gboolean _tmp13_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = ai;
					ai = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = ai;
				if (!(_tmp2_ <= 100)) {
					break;
				}
				_tmp3_ = ai;
				a = _tmp3_ / 10.0;
				_tmp4_ = a;
				_tmp5_ = number_new_double (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = number_epowy (_tmp6_);
				_tmp8_ = _tmp7_;
				_number_unref0 (_tmp6_);
				z = _tmp8_;
				_tmp9_ = a;
				_tmp10_ = exp (_tmp9_);
				expected = _tmp10_;
				_tmp11_ = z;
				_tmp12_ = expected;
				_tmp13_ = double_matches (_tmp11_, _tmp12_);
				if (!_tmp13_) {
					gdouble _tmp14_ = 0.0;
					Number* _tmp15_ = NULL;
					gdouble _tmp16_ = 0.0;
					gdouble _tmp17_ = 0.0;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					_tmp14_ = a;
					_tmp15_ = z;
					_tmp16_ = number_to_double (_tmp15_);
					_tmp17_ = expected;
					_tmp18_ = g_strdup_printf ("(%f).epowy () -> %f, expected %f", _tmp14_, _tmp16_, _tmp17_);
					_tmp19_ = _tmp18_;
					fail (_tmp19_);
					_g_free0 (_tmp19_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_xpowy (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							Number* _tmp7_ = NULL;
							Number* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							Number* _tmp11_ = NULL;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							gdouble expected = 0.0;
							gint _tmp14_ = 0;
							Number* _tmp29_ = NULL;
							gdouble _tmp30_ = 0.0;
							gboolean _tmp31_ = FALSE;
							if (!_tmp3_) {
								gint _tmp4_ = 0;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ <= 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = number_new_integer ((gint64) _tmp6_);
							_tmp8_ = _tmp7_;
							_tmp9_ = b;
							_tmp10_ = number_new_integer ((gint64) _tmp9_);
							_tmp11_ = _tmp10_;
							_tmp12_ = number_xpowy (_tmp8_, _tmp11_);
							_tmp13_ = _tmp12_;
							_number_unref0 (_tmp11_);
							_number_unref0 (_tmp8_);
							z = _tmp13_;
							expected = 1.0;
							_tmp14_ = a;
							if (_tmp14_ == 0) {
								expected = 0.0;
							} else {
								gint _tmp15_ = 0;
								_tmp15_ = b;
								if (_tmp15_ < 0) {
									{
										gint i = 0;
										i = 0;
										{
											gboolean _tmp16_ = FALSE;
											_tmp16_ = TRUE;
											while (TRUE) {
												gint _tmp18_ = 0;
												gint _tmp19_ = 0;
												gdouble _tmp20_ = 0.0;
												gint _tmp21_ = 0;
												if (!_tmp16_) {
													gint _tmp17_ = 0;
													_tmp17_ = i;
													i = _tmp17_ - 1;
												}
												_tmp16_ = FALSE;
												_tmp18_ = i;
												_tmp19_ = b;
												if (!(_tmp18_ > _tmp19_)) {
													break;
												}
												_tmp20_ = expected;
												_tmp21_ = a;
												expected = _tmp20_ / _tmp21_;
											}
										}
									}
								} else {
									gint _tmp22_ = 0;
									_tmp22_ = b;
									if (_tmp22_ > 0) {
										{
											gint i = 0;
											i = 0;
											{
												gboolean _tmp23_ = FALSE;
												_tmp23_ = TRUE;
												while (TRUE) {
													gint _tmp25_ = 0;
													gint _tmp26_ = 0;
													gdouble _tmp27_ = 0.0;
													gint _tmp28_ = 0;
													if (!_tmp23_) {
														gint _tmp24_ = 0;
														_tmp24_ = i;
														i = _tmp24_ + 1;
													}
													_tmp23_ = FALSE;
													_tmp25_ = i;
													_tmp26_ = b;
													if (!(_tmp25_ < _tmp26_)) {
														break;
													}
													_tmp27_ = expected;
													_tmp28_ = a;
													expected = _tmp27_ * _tmp28_;
												}
											}
										}
									}
								}
							}
							_tmp29_ = z;
							_tmp30_ = expected;
							_tmp31_ = double_matches (_tmp29_, _tmp30_);
							if (!_tmp31_) {
								gint _tmp32_ = 0;
								gint _tmp33_ = 0;
								Number* _tmp34_ = NULL;
								gdouble _tmp35_ = 0.0;
								gdouble _tmp36_ = 0.0;
								gchar* _tmp37_ = NULL;
								gchar* _tmp38_ = NULL;
								_tmp32_ = a;
								_tmp33_ = b;
								_tmp34_ = z;
								_tmp35_ = number_to_double (_tmp34_);
								_tmp36_ = expected;
								_tmp37_ = g_strdup_printf ("(%d).xpowy (%d) -> %f, expected %f", _tmp32_, _tmp33_, _tmp35_, _tmp36_);
								_tmp38_ = _tmp37_;
								fail (_tmp38_);
								_g_free0 (_tmp38_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void test_xpowy_integer (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							Number* _tmp7_ = NULL;
							Number* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							Number* _tmp11_ = NULL;
							gdouble expected = 0.0;
							gint _tmp12_ = 0;
							Number* _tmp27_ = NULL;
							gdouble _tmp28_ = 0.0;
							gboolean _tmp29_ = FALSE;
							if (!_tmp3_) {
								gint _tmp4_ = 0;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ <= 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = number_new_integer ((gint64) _tmp6_);
							_tmp8_ = _tmp7_;
							_tmp9_ = b;
							_tmp10_ = number_xpowy_integer (_tmp8_, (gint64) _tmp9_);
							_tmp11_ = _tmp10_;
							_number_unref0 (_tmp8_);
							z = _tmp11_;
							expected = 1.0;
							_tmp12_ = a;
							if (_tmp12_ == 0) {
								expected = 0.0;
							} else {
								gint _tmp13_ = 0;
								_tmp13_ = b;
								if (_tmp13_ < 0) {
									{
										gint i = 0;
										i = 0;
										{
											gboolean _tmp14_ = FALSE;
											_tmp14_ = TRUE;
											while (TRUE) {
												gint _tmp16_ = 0;
												gint _tmp17_ = 0;
												gdouble _tmp18_ = 0.0;
												gint _tmp19_ = 0;
												if (!_tmp14_) {
													gint _tmp15_ = 0;
													_tmp15_ = i;
													i = _tmp15_ - 1;
												}
												_tmp14_ = FALSE;
												_tmp16_ = i;
												_tmp17_ = b;
												if (!(_tmp16_ > _tmp17_)) {
													break;
												}
												_tmp18_ = expected;
												_tmp19_ = a;
												expected = _tmp18_ / _tmp19_;
											}
										}
									}
								} else {
									gint _tmp20_ = 0;
									_tmp20_ = b;
									if (_tmp20_ > 0) {
										{
											gint i = 0;
											i = 0;
											{
												gboolean _tmp21_ = FALSE;
												_tmp21_ = TRUE;
												while (TRUE) {
													gint _tmp23_ = 0;
													gint _tmp24_ = 0;
													gdouble _tmp25_ = 0.0;
													gint _tmp26_ = 0;
													if (!_tmp21_) {
														gint _tmp22_ = 0;
														_tmp22_ = i;
														i = _tmp22_ + 1;
													}
													_tmp21_ = FALSE;
													_tmp23_ = i;
													_tmp24_ = b;
													if (!(_tmp23_ < _tmp24_)) {
														break;
													}
													_tmp25_ = expected;
													_tmp26_ = a;
													expected = _tmp25_ * _tmp26_;
												}
											}
										}
									}
								}
							}
							_tmp27_ = z;
							_tmp28_ = expected;
							_tmp29_ = double_matches (_tmp27_, _tmp28_);
							if (!_tmp29_) {
								gint _tmp30_ = 0;
								gint _tmp31_ = 0;
								Number* _tmp32_ = NULL;
								gdouble _tmp33_ = 0.0;
								gdouble _tmp34_ = 0.0;
								gchar* _tmp35_ = NULL;
								gchar* _tmp36_ = NULL;
								_tmp30_ = a;
								_tmp31_ = b;
								_tmp32_ = z;
								_tmp33_ = number_to_double (_tmp32_);
								_tmp34_ = expected;
								_tmp35_ = g_strdup_printf ("(%d).xpowy_integer (%d) -> %f, expected %f", _tmp30_, _tmp31_, _tmp33_, _tmp34_);
								_tmp36_ = _tmp35_;
								fail (_tmp36_);
								_g_free0 (_tmp36_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void test_root3 (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				Number* z = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				gdouble expected = 0.0;
				gint _tmp8_ = 0;
				gdouble _tmp9_ = 0.0;
				Number* _tmp10_ = NULL;
				gdouble _tmp11_ = 0.0;
				gboolean _tmp12_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_double ((gdouble) _tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = number_root (_tmp5_, (gint64) 3);
				_tmp7_ = _tmp6_;
				_number_unref0 (_tmp5_);
				z = _tmp7_;
				_tmp8_ = a;
				_tmp9_ = cbrt ((gdouble) _tmp8_);
				expected = _tmp9_;
				_tmp10_ = z;
				_tmp11_ = expected;
				_tmp12_ = double_matches (_tmp10_, _tmp11_);
				if (!_tmp12_) {
					gint _tmp13_ = 0;
					Number* _tmp14_ = NULL;
					gdouble _tmp15_ = 0.0;
					gdouble _tmp16_ = 0.0;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					_tmp13_ = a;
					_tmp14_ = z;
					_tmp15_ = number_to_double (_tmp14_);
					_tmp16_ = expected;
					_tmp17_ = g_strdup_printf ("(%f).root (3) -> %f, expected %f", (gdouble) _tmp13_, _tmp15_, _tmp16_);
					_tmp18_ = _tmp17_;
					fail (_tmp18_);
					_g_free0 (_tmp18_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_sqrt (void) {
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				Number* z = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				gdouble expected = 0.0;
				gint _tmp8_ = 0;
				gdouble _tmp9_ = 0.0;
				Number* _tmp10_ = NULL;
				gdouble _tmp11_ = 0.0;
				gboolean _tmp12_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_double ((gdouble) _tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = number_sqrt (_tmp5_);
				_tmp7_ = _tmp6_;
				_number_unref0 (_tmp5_);
				z = _tmp7_;
				_tmp8_ = a;
				_tmp9_ = sqrt ((gdouble) _tmp8_);
				expected = _tmp9_;
				_tmp10_ = z;
				_tmp11_ = expected;
				_tmp12_ = double_matches (_tmp10_, _tmp11_);
				if (!_tmp12_) {
					gint _tmp13_ = 0;
					Number* _tmp14_ = NULL;
					gdouble _tmp15_ = 0.0;
					gdouble _tmp16_ = 0.0;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					_tmp13_ = a;
					_tmp14_ = z;
					_tmp15_ = number_to_double (_tmp14_);
					_tmp16_ = expected;
					_tmp17_ = g_strdup_printf ("(%f).sqrt () -> %f, expected %f", (gdouble) _tmp13_, _tmp15_, _tmp16_);
					_tmp18_ = _tmp17_;
					fail (_tmp18_);
					_g_free0 (_tmp18_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_ln (void) {
	{
		gint a = 0;
		a = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				Number* z = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				gdouble expected = 0.0;
				gint _tmp8_ = 0;
				gdouble _tmp9_ = 0.0;
				Number* _tmp10_ = NULL;
				gdouble _tmp11_ = 0.0;
				gboolean _tmp12_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_double ((gdouble) _tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = number_ln (_tmp5_);
				_tmp7_ = _tmp6_;
				_number_unref0 (_tmp5_);
				z = _tmp7_;
				_tmp8_ = a;
				_tmp9_ = log ((gdouble) _tmp8_);
				expected = _tmp9_;
				_tmp10_ = z;
				_tmp11_ = expected;
				_tmp12_ = double_matches (_tmp10_, _tmp11_);
				if (!_tmp12_) {
					gint _tmp13_ = 0;
					Number* _tmp14_ = NULL;
					gdouble _tmp15_ = 0.0;
					gdouble _tmp16_ = 0.0;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					_tmp13_ = a;
					_tmp14_ = z;
					_tmp15_ = number_to_double (_tmp14_);
					_tmp16_ = expected;
					_tmp17_ = g_strdup_printf ("(%f).ln () -> %f, expected %f", (gdouble) _tmp13_, _tmp15_, _tmp16_);
					_tmp18_ = _tmp17_;
					fail (_tmp18_);
					_g_free0 (_tmp18_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_logarithm2 (void) {
	{
		gint a = 0;
		a = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				Number* z = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				gdouble expected = 0.0;
				gint _tmp8_ = 0;
				gdouble _tmp9_ = 0.0;
				Number* _tmp10_ = NULL;
				gdouble _tmp11_ = 0.0;
				gboolean _tmp12_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_double ((gdouble) _tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = number_logarithm (_tmp5_, (gint64) 2);
				_tmp7_ = _tmp6_;
				_number_unref0 (_tmp5_);
				z = _tmp7_;
				_tmp8_ = a;
				_tmp9_ = log2 ((gdouble) _tmp8_);
				expected = _tmp9_;
				_tmp10_ = z;
				_tmp11_ = expected;
				_tmp12_ = double_matches (_tmp10_, _tmp11_);
				if (!_tmp12_) {
					gint _tmp13_ = 0;
					Number* _tmp14_ = NULL;
					gdouble _tmp15_ = 0.0;
					gdouble _tmp16_ = 0.0;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					_tmp13_ = a;
					_tmp14_ = z;
					_tmp15_ = number_to_double (_tmp14_);
					_tmp16_ = expected;
					_tmp17_ = g_strdup_printf ("(%f).logarithm (2) -> %f, expected %f", (gdouble) _tmp13_, _tmp15_, _tmp16_);
					_tmp18_ = _tmp17_;
					fail (_tmp18_);
					_g_free0 (_tmp18_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_logarithm10 (void) {
	{
		gint a = 0;
		a = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				Number* z = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				gdouble expected = 0.0;
				gint _tmp8_ = 0;
				gdouble _tmp9_ = 0.0;
				Number* _tmp10_ = NULL;
				gdouble _tmp11_ = 0.0;
				gboolean _tmp12_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_double ((gdouble) _tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = number_logarithm (_tmp5_, (gint64) 10);
				_tmp7_ = _tmp6_;
				_number_unref0 (_tmp5_);
				z = _tmp7_;
				_tmp8_ = a;
				_tmp9_ = log10 ((gdouble) _tmp8_);
				expected = _tmp9_;
				_tmp10_ = z;
				_tmp11_ = expected;
				_tmp12_ = double_matches (_tmp10_, _tmp11_);
				if (!_tmp12_) {
					gint _tmp13_ = 0;
					Number* _tmp14_ = NULL;
					gdouble _tmp15_ = 0.0;
					gdouble _tmp16_ = 0.0;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					_tmp13_ = a;
					_tmp14_ = z;
					_tmp15_ = number_to_double (_tmp14_);
					_tmp16_ = expected;
					_tmp17_ = g_strdup_printf ("(%f).logarithm (10) -> %f, expected %f", (gdouble) _tmp13_, _tmp15_, _tmp16_);
					_tmp18_ = _tmp17_;
					fail (_tmp18_);
					_g_free0 (_tmp18_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_is_zero (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				Number* z = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				gboolean expected = FALSE;
				gint _tmp5_ = 0;
				Number* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_integer ((gint64) _tmp3_);
				z = _tmp4_;
				_tmp5_ = a;
				expected = _tmp5_ == 0;
				_tmp6_ = z;
				_tmp7_ = number_is_zero (_tmp6_);
				_tmp8_ = expected;
				if (_tmp7_ != _tmp8_) {
					const gchar* _tmp9_ = NULL;
					Number* _tmp10_ = NULL;
					gboolean _tmp11_ = FALSE;
					const gchar* _tmp12_ = NULL;
					gboolean _tmp13_ = FALSE;
					gint _tmp14_ = 0;
					gchar* _tmp15_ = NULL;
					gchar* _tmp16_ = NULL;
					_tmp10_ = z;
					_tmp11_ = number_is_zero (_tmp10_);
					if (_tmp11_) {
						_tmp9_ = "true";
					} else {
						_tmp9_ = "false";
					}
					_tmp13_ = expected;
					if (_tmp13_) {
						_tmp12_ = "true";
					} else {
						_tmp12_ = "false";
					}
					_tmp14_ = a;
					_tmp15_ = g_strdup_printf ("(%d).is_zero () -> %s, expected %s", _tmp14_, _tmp9_, _tmp12_);
					_tmp16_ = _tmp15_;
					fail (_tmp16_);
					_g_free0 (_tmp16_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_is_negative (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				Number* z = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				gboolean expected = FALSE;
				gint _tmp5_ = 0;
				Number* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_integer ((gint64) _tmp3_);
				z = _tmp4_;
				_tmp5_ = a;
				expected = _tmp5_ < 0;
				_tmp6_ = z;
				_tmp7_ = number_is_negative (_tmp6_);
				_tmp8_ = expected;
				if (_tmp7_ != _tmp8_) {
					const gchar* _tmp9_ = NULL;
					Number* _tmp10_ = NULL;
					gboolean _tmp11_ = FALSE;
					const gchar* _tmp12_ = NULL;
					gboolean _tmp13_ = FALSE;
					gint _tmp14_ = 0;
					gchar* _tmp15_ = NULL;
					gchar* _tmp16_ = NULL;
					_tmp10_ = z;
					_tmp11_ = number_is_negative (_tmp10_);
					if (_tmp11_) {
						_tmp9_ = "true";
					} else {
						_tmp9_ = "false";
					}
					_tmp13_ = expected;
					if (_tmp13_) {
						_tmp12_ = "true";
					} else {
						_tmp12_ = "false";
					}
					_tmp14_ = a;
					_tmp15_ = g_strdup_printf ("(%d).is_negative () -> %s, expected %s", _tmp14_, _tmp9_, _tmp12_);
					_tmp16_ = _tmp15_;
					fail (_tmp16_);
					_g_free0 (_tmp16_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_is_integer (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				Number* z = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				gboolean expected = FALSE;
				Number* _tmp5_ = NULL;
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_integer ((gint64) _tmp3_);
				z = _tmp4_;
				expected = TRUE;
				_tmp5_ = z;
				_tmp6_ = number_is_integer (_tmp5_);
				_tmp7_ = expected;
				if (_tmp6_ != _tmp7_) {
					const gchar* _tmp8_ = NULL;
					Number* _tmp9_ = NULL;
					gboolean _tmp10_ = FALSE;
					const gchar* _tmp11_ = NULL;
					gboolean _tmp12_ = FALSE;
					gint _tmp13_ = 0;
					gchar* _tmp14_ = NULL;
					gchar* _tmp15_ = NULL;
					_tmp9_ = z;
					_tmp10_ = number_is_integer (_tmp9_);
					if (_tmp10_) {
						_tmp8_ = "true";
					} else {
						_tmp8_ = "false";
					}
					_tmp12_ = expected;
					if (_tmp12_) {
						_tmp11_ = "true";
					} else {
						_tmp11_ = "false";
					}
					_tmp13_ = a;
					_tmp14_ = g_strdup_printf ("(%d).is_integer () -> %s, expected %s", _tmp13_, _tmp8_, _tmp11_);
					_tmp15_ = _tmp14_;
					fail (_tmp15_);
					_g_free0 (_tmp15_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_is_positive_integer (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				Number* z = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				gboolean expected = FALSE;
				gint _tmp5_ = 0;
				Number* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_integer ((gint64) _tmp3_);
				z = _tmp4_;
				_tmp5_ = a;
				expected = _tmp5_ >= 0;
				_tmp6_ = z;
				_tmp7_ = number_is_positive_integer (_tmp6_);
				_tmp8_ = expected;
				if (_tmp7_ != _tmp8_) {
					const gchar* _tmp9_ = NULL;
					Number* _tmp10_ = NULL;
					gboolean _tmp11_ = FALSE;
					const gchar* _tmp12_ = NULL;
					gboolean _tmp13_ = FALSE;
					gint _tmp14_ = 0;
					gchar* _tmp15_ = NULL;
					gchar* _tmp16_ = NULL;
					_tmp10_ = z;
					_tmp11_ = number_is_positive_integer (_tmp10_);
					if (_tmp11_) {
						_tmp9_ = "true";
					} else {
						_tmp9_ = "false";
					}
					_tmp13_ = expected;
					if (_tmp13_) {
						_tmp12_ = "true";
					} else {
						_tmp12_ = "false";
					}
					_tmp14_ = a;
					_tmp15_ = g_strdup_printf ("(%d).is_positive_integer () -> %s, expected %s", _tmp14_, _tmp9_, _tmp12_);
					_tmp16_ = _tmp15_;
					fail (_tmp16_);
					_g_free0 (_tmp16_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_is_natural (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				Number* z = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				gboolean expected = FALSE;
				gint _tmp5_ = 0;
				Number* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_integer ((gint64) _tmp3_);
				z = _tmp4_;
				_tmp5_ = a;
				expected = _tmp5_ > 0;
				_tmp6_ = z;
				_tmp7_ = number_is_natural (_tmp6_);
				_tmp8_ = expected;
				if (_tmp7_ != _tmp8_) {
					const gchar* _tmp9_ = NULL;
					Number* _tmp10_ = NULL;
					gboolean _tmp11_ = FALSE;
					const gchar* _tmp12_ = NULL;
					gboolean _tmp13_ = FALSE;
					gint _tmp14_ = 0;
					gchar* _tmp15_ = NULL;
					gchar* _tmp16_ = NULL;
					_tmp10_ = z;
					_tmp11_ = number_is_natural (_tmp10_);
					if (_tmp11_) {
						_tmp9_ = "true";
					} else {
						_tmp9_ = "false";
					}
					_tmp13_ = expected;
					if (_tmp13_) {
						_tmp12_ = "true";
					} else {
						_tmp12_ = "false";
					}
					_tmp14_ = a;
					_tmp15_ = g_strdup_printf ("(%d).is_natural () -> %s, expected %s", _tmp14_, _tmp9_, _tmp12_);
					_tmp16_ = _tmp15_;
					fail (_tmp16_);
					_g_free0 (_tmp16_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_is_complex (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							Number* _tmp7_ = NULL;
							Number* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							Number* _tmp11_ = NULL;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							gboolean expected = FALSE;
							gint _tmp14_ = 0;
							Number* _tmp15_ = NULL;
							gboolean _tmp16_ = FALSE;
							gboolean _tmp17_ = FALSE;
							if (!_tmp3_) {
								gint _tmp4_ = 0;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ <= 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = number_new_integer ((gint64) _tmp6_);
							_tmp8_ = _tmp7_;
							_tmp9_ = b;
							_tmp10_ = number_new_integer ((gint64) _tmp9_);
							_tmp11_ = _tmp10_;
							_tmp12_ = number_new_complex (_tmp8_, _tmp11_);
							_tmp13_ = _tmp12_;
							_number_unref0 (_tmp11_);
							_number_unref0 (_tmp8_);
							z = _tmp13_;
							_tmp14_ = b;
							expected = _tmp14_ != 0;
							_tmp15_ = z;
							_tmp16_ = number_is_complex (_tmp15_);
							_tmp17_ = expected;
							if (_tmp16_ != _tmp17_) {
								const gchar* _tmp18_ = NULL;
								Number* _tmp19_ = NULL;
								gboolean _tmp20_ = FALSE;
								const gchar* _tmp21_ = NULL;
								gboolean _tmp22_ = FALSE;
								gint _tmp23_ = 0;
								gint _tmp24_ = 0;
								gchar* _tmp25_ = NULL;
								gchar* _tmp26_ = NULL;
								_tmp19_ = z;
								_tmp20_ = number_is_complex (_tmp19_);
								if (_tmp20_) {
									_tmp18_ = "true";
								} else {
									_tmp18_ = "false";
								}
								_tmp22_ = expected;
								if (_tmp22_) {
									_tmp21_ = "true";
								} else {
									_tmp21_ = "false";
								}
								_tmp23_ = a;
								_tmp24_ = b;
								_tmp25_ = g_strdup_printf ("(%d+%di).is_complex () -> %s, expected %s", _tmp23_, _tmp24_, _tmp18_, _tmp21_);
								_tmp26_ = _tmp25_;
								fail (_tmp26_);
								_g_free0 (_tmp26_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void test_factorial (void) {
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				Number* z = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				gint expected = 0;
				Number* _tmp11_ = NULL;
				Number* _tmp12_ = NULL;
				Number* _tmp13_ = NULL;
				gint64 _tmp14_ = 0LL;
				gint _tmp15_ = 0;
				gboolean _tmp16_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_integer ((gint64) _tmp3_);
				z = _tmp4_;
				expected = 1;
				{
					gint i = 0;
					i = 2;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							gint _tmp7_ = 0;
							gint _tmp8_ = 0;
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = i;
								i = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = i;
							_tmp8_ = a;
							if (!(_tmp7_ <= _tmp8_)) {
								break;
							}
							_tmp9_ = expected;
							_tmp10_ = i;
							expected = _tmp9_ * _tmp10_;
						}
					}
				}
				_tmp11_ = z;
				_tmp12_ = number_factorial (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = number_to_integer (_tmp13_);
				_tmp15_ = expected;
				_tmp16_ = _tmp14_ != ((gint64) _tmp15_);
				_number_unref0 (_tmp13_);
				if (_tmp16_) {
					gint _tmp17_ = 0;
					Number* _tmp18_ = NULL;
					Number* _tmp19_ = NULL;
					Number* _tmp20_ = NULL;
					gint64 _tmp21_ = 0LL;
					gint _tmp22_ = 0;
					gchar* _tmp23_ = NULL;
					gchar* _tmp24_ = NULL;
					_tmp17_ = a;
					_tmp18_ = z;
					_tmp19_ = number_factorial (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp21_ = number_to_integer (_tmp20_);
					_tmp22_ = expected;
					_tmp23_ = g_strdup_printf ("(%d).factorial () -> %lli, expected %lli", _tmp17_, _tmp21_, _tmp22_);
					_tmp24_ = _tmp23_;
					fail (_tmp24_);
					_g_free0 (_tmp24_);
					_number_unref0 (_tmp20_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_add (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							Number* _tmp7_ = NULL;
							Number* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							Number* _tmp11_ = NULL;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							gint expected = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							Number* _tmp16_ = NULL;
							gint64 _tmp17_ = 0LL;
							gint _tmp18_ = 0;
							if (!_tmp3_) {
								gint _tmp4_ = 0;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ <= 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = number_new_integer ((gint64) _tmp6_);
							_tmp8_ = _tmp7_;
							_tmp9_ = b;
							_tmp10_ = number_new_integer ((gint64) _tmp9_);
							_tmp11_ = _tmp10_;
							_tmp12_ = number_add (_tmp8_, _tmp11_);
							_tmp13_ = _tmp12_;
							_number_unref0 (_tmp11_);
							_number_unref0 (_tmp8_);
							z = _tmp13_;
							_tmp14_ = a;
							_tmp15_ = b;
							expected = _tmp14_ + _tmp15_;
							_tmp16_ = z;
							_tmp17_ = number_to_integer (_tmp16_);
							_tmp18_ = expected;
							if (_tmp17_ != ((gint64) _tmp18_)) {
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								Number* _tmp21_ = NULL;
								gint64 _tmp22_ = 0LL;
								gint _tmp23_ = 0;
								gchar* _tmp24_ = NULL;
								gchar* _tmp25_ = NULL;
								_tmp19_ = a;
								_tmp20_ = b;
								_tmp21_ = z;
								_tmp22_ = number_to_integer (_tmp21_);
								_tmp23_ = expected;
								_tmp24_ = g_strdup_printf ("(%d).add (%d) -> %lli, expected %d", _tmp19_, _tmp20_, _tmp22_, _tmp23_);
								_tmp25_ = _tmp24_;
								fail (_tmp25_);
								_g_free0 (_tmp25_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void test_subtract (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							Number* _tmp7_ = NULL;
							Number* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							Number* _tmp11_ = NULL;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							gint expected = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							Number* _tmp16_ = NULL;
							gint64 _tmp17_ = 0LL;
							gint _tmp18_ = 0;
							if (!_tmp3_) {
								gint _tmp4_ = 0;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ <= 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = number_new_integer ((gint64) _tmp6_);
							_tmp8_ = _tmp7_;
							_tmp9_ = b;
							_tmp10_ = number_new_integer ((gint64) _tmp9_);
							_tmp11_ = _tmp10_;
							_tmp12_ = number_subtract (_tmp8_, _tmp11_);
							_tmp13_ = _tmp12_;
							_number_unref0 (_tmp11_);
							_number_unref0 (_tmp8_);
							z = _tmp13_;
							_tmp14_ = a;
							_tmp15_ = b;
							expected = _tmp14_ - _tmp15_;
							_tmp16_ = z;
							_tmp17_ = number_to_integer (_tmp16_);
							_tmp18_ = expected;
							if (_tmp17_ != ((gint64) _tmp18_)) {
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								Number* _tmp21_ = NULL;
								gint64 _tmp22_ = 0LL;
								gint _tmp23_ = 0;
								gchar* _tmp24_ = NULL;
								gchar* _tmp25_ = NULL;
								_tmp19_ = a;
								_tmp20_ = b;
								_tmp21_ = z;
								_tmp22_ = number_to_integer (_tmp21_);
								_tmp23_ = expected;
								_tmp24_ = g_strdup_printf ("(%d).subtract (%d) -> %lli, expected %d", _tmp19_, _tmp20_, _tmp22_, _tmp23_);
								_tmp25_ = _tmp24_;
								fail (_tmp25_);
								_g_free0 (_tmp25_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void test_multiply (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							Number* _tmp7_ = NULL;
							Number* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							Number* _tmp11_ = NULL;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							gint expected = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							Number* _tmp16_ = NULL;
							gint64 _tmp17_ = 0LL;
							gint _tmp18_ = 0;
							if (!_tmp3_) {
								gint _tmp4_ = 0;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ <= 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = number_new_integer ((gint64) _tmp6_);
							_tmp8_ = _tmp7_;
							_tmp9_ = b;
							_tmp10_ = number_new_integer ((gint64) _tmp9_);
							_tmp11_ = _tmp10_;
							_tmp12_ = number_multiply (_tmp8_, _tmp11_);
							_tmp13_ = _tmp12_;
							_number_unref0 (_tmp11_);
							_number_unref0 (_tmp8_);
							z = _tmp13_;
							_tmp14_ = a;
							_tmp15_ = b;
							expected = _tmp14_ * _tmp15_;
							_tmp16_ = z;
							_tmp17_ = number_to_integer (_tmp16_);
							_tmp18_ = expected;
							if (_tmp17_ != ((gint64) _tmp18_)) {
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								Number* _tmp21_ = NULL;
								gint64 _tmp22_ = 0LL;
								gint _tmp23_ = 0;
								gchar* _tmp24_ = NULL;
								gchar* _tmp25_ = NULL;
								_tmp19_ = a;
								_tmp20_ = b;
								_tmp21_ = z;
								_tmp22_ = number_to_integer (_tmp21_);
								_tmp23_ = expected;
								_tmp24_ = g_strdup_printf ("(%d).multiply (%d) -> %lli, expected %d", _tmp19_, _tmp20_, _tmp22_, _tmp23_);
								_tmp25_ = _tmp24_;
								fail (_tmp25_);
								_g_free0 (_tmp25_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void test_multiply_integer (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							Number* _tmp7_ = NULL;
							Number* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							Number* _tmp11_ = NULL;
							gint expected = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							Number* _tmp14_ = NULL;
							gint64 _tmp15_ = 0LL;
							gint _tmp16_ = 0;
							if (!_tmp3_) {
								gint _tmp4_ = 0;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ <= 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = number_new_integer ((gint64) _tmp6_);
							_tmp8_ = _tmp7_;
							_tmp9_ = b;
							_tmp10_ = number_multiply_integer (_tmp8_, (gint64) _tmp9_);
							_tmp11_ = _tmp10_;
							_number_unref0 (_tmp8_);
							z = _tmp11_;
							_tmp12_ = a;
							_tmp13_ = b;
							expected = _tmp12_ * _tmp13_;
							_tmp14_ = z;
							_tmp15_ = number_to_integer (_tmp14_);
							_tmp16_ = expected;
							if (_tmp15_ != ((gint64) _tmp16_)) {
								gint _tmp17_ = 0;
								gint _tmp18_ = 0;
								Number* _tmp19_ = NULL;
								gint64 _tmp20_ = 0LL;
								gint _tmp21_ = 0;
								gchar* _tmp22_ = NULL;
								gchar* _tmp23_ = NULL;
								_tmp17_ = a;
								_tmp18_ = b;
								_tmp19_ = z;
								_tmp20_ = number_to_integer (_tmp19_);
								_tmp21_ = expected;
								_tmp22_ = g_strdup_printf ("(%d).multiply_integer (%d) -> %lli, expected %d", _tmp17_, _tmp18_, _tmp20_, _tmp21_);
								_tmp23_ = _tmp22_;
								fail (_tmp23_);
								_g_free0 (_tmp23_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void test_divide (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_ = 0;
							gint _tmp6_ = 0;
							Number* z = NULL;
							gint _tmp7_ = 0;
							gint _tmp8_ = 0;
							Number* _tmp9_ = NULL;
							Number* _tmp10_ = NULL;
							gint _tmp11_ = 0;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							Number* _tmp14_ = NULL;
							Number* _tmp15_ = NULL;
							gint expected = 0;
							gint _tmp16_ = 0;
							Number* _tmp17_ = NULL;
							gint64 _tmp18_ = 0LL;
							gint _tmp19_ = 0;
							if (!_tmp3_) {
								gint _tmp4_ = 0;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ <= 10)) {
								break;
							}
							_tmp6_ = b;
							if (_tmp6_ == 0) {
								continue;
							}
							_tmp7_ = a;
							_tmp8_ = b;
							_tmp9_ = number_new_integer ((gint64) (_tmp7_ * _tmp8_));
							_tmp10_ = _tmp9_;
							_tmp11_ = b;
							_tmp12_ = number_new_integer ((gint64) _tmp11_);
							_tmp13_ = _tmp12_;
							_tmp14_ = number_divide (_tmp10_, _tmp13_);
							_tmp15_ = _tmp14_;
							_number_unref0 (_tmp13_);
							_number_unref0 (_tmp10_);
							z = _tmp15_;
							_tmp16_ = a;
							expected = _tmp16_;
							_tmp17_ = z;
							_tmp18_ = number_to_integer (_tmp17_);
							_tmp19_ = expected;
							if (_tmp18_ != ((gint64) _tmp19_)) {
								gint _tmp20_ = 0;
								gint _tmp21_ = 0;
								gint _tmp22_ = 0;
								Number* _tmp23_ = NULL;
								gint64 _tmp24_ = 0LL;
								gint _tmp25_ = 0;
								gchar* _tmp26_ = NULL;
								gchar* _tmp27_ = NULL;
								_tmp20_ = a;
								_tmp21_ = b;
								_tmp22_ = b;
								_tmp23_ = z;
								_tmp24_ = number_to_integer (_tmp23_);
								_tmp25_ = expected;
								_tmp26_ = g_strdup_printf ("(%d).divide (%d) -> %lli, expected %d", _tmp20_ * _tmp21_, _tmp22_, _tmp24_, _tmp25_);
								_tmp27_ = _tmp26_;
								fail (_tmp27_);
								_g_free0 (_tmp27_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void test_divide_integer (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_ = 0;
							gint _tmp6_ = 0;
							Number* z = NULL;
							gint _tmp7_ = 0;
							gint _tmp8_ = 0;
							Number* _tmp9_ = NULL;
							Number* _tmp10_ = NULL;
							gint _tmp11_ = 0;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							gint expected = 0;
							gint _tmp14_ = 0;
							Number* _tmp15_ = NULL;
							gint64 _tmp16_ = 0LL;
							gint _tmp17_ = 0;
							if (!_tmp3_) {
								gint _tmp4_ = 0;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ <= 10)) {
								break;
							}
							_tmp6_ = b;
							if (_tmp6_ == 0) {
								continue;
							}
							_tmp7_ = a;
							_tmp8_ = b;
							_tmp9_ = number_new_integer ((gint64) (_tmp7_ * _tmp8_));
							_tmp10_ = _tmp9_;
							_tmp11_ = b;
							_tmp12_ = number_divide_integer (_tmp10_, (gint64) _tmp11_);
							_tmp13_ = _tmp12_;
							_number_unref0 (_tmp10_);
							z = _tmp13_;
							_tmp14_ = a;
							expected = _tmp14_;
							_tmp15_ = z;
							_tmp16_ = number_to_integer (_tmp15_);
							_tmp17_ = expected;
							if (_tmp16_ != ((gint64) _tmp17_)) {
								gint _tmp18_ = 0;
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								Number* _tmp21_ = NULL;
								gint64 _tmp22_ = 0LL;
								gint _tmp23_ = 0;
								gchar* _tmp24_ = NULL;
								gchar* _tmp25_ = NULL;
								_tmp18_ = a;
								_tmp19_ = b;
								_tmp20_ = b;
								_tmp21_ = z;
								_tmp22_ = number_to_integer (_tmp21_);
								_tmp23_ = expected;
								_tmp24_ = g_strdup_printf ("(%d).divide_integer (%d) -> %lli, expected %d", _tmp18_ * _tmp19_, _tmp20_, _tmp22_, _tmp23_);
								_tmp25_ = _tmp24_;
								fail (_tmp25_);
								_g_free0 (_tmp25_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void test_modulus_divide (void) {
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = 1;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							Number* _tmp7_ = NULL;
							Number* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							Number* _tmp11_ = NULL;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							gint expected = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							Number* _tmp16_ = NULL;
							gint64 _tmp17_ = 0LL;
							gint _tmp18_ = 0;
							if (!_tmp3_) {
								gint _tmp4_ = 0;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ <= 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = number_new_integer ((gint64) _tmp6_);
							_tmp8_ = _tmp7_;
							_tmp9_ = b;
							_tmp10_ = number_new_integer ((gint64) _tmp9_);
							_tmp11_ = _tmp10_;
							_tmp12_ = number_modulus_divide (_tmp8_, _tmp11_);
							_tmp13_ = _tmp12_;
							_number_unref0 (_tmp11_);
							_number_unref0 (_tmp8_);
							z = _tmp13_;
							_tmp14_ = a;
							_tmp15_ = b;
							expected = _tmp14_ % _tmp15_;
							_tmp16_ = z;
							_tmp17_ = number_to_integer (_tmp16_);
							_tmp18_ = expected;
							if (_tmp17_ != ((gint64) _tmp18_)) {
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								Number* _tmp21_ = NULL;
								gint64 _tmp22_ = 0LL;
								gint _tmp23_ = 0;
								gchar* _tmp24_ = NULL;
								gchar* _tmp25_ = NULL;
								_tmp19_ = a;
								_tmp20_ = b;
								_tmp21_ = z;
								_tmp22_ = number_to_integer (_tmp21_);
								_tmp23_ = expected;
								_tmp24_ = g_strdup_printf ("(%d).modulus_divide (%d) -> %lli, expected %d", _tmp19_, _tmp20_, _tmp22_, _tmp23_);
								_tmp25_ = _tmp24_;
								fail (_tmp25_);
								_g_free0 (_tmp25_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void test_sin (void) {
	{
		gdouble a = 0.0;
		a = -G_PI;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gdouble _tmp2_ = 0.0;
				Number* z = NULL;
				gdouble _tmp3_ = 0.0;
				Number* _tmp4_ = NULL;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				gdouble expected = 0.0;
				gdouble _tmp8_ = 0.0;
				gdouble _tmp9_ = 0.0;
				Number* _tmp10_ = NULL;
				gdouble _tmp11_ = 0.0;
				gboolean _tmp12_ = FALSE;
				if (!_tmp0_) {
					gdouble _tmp1_ = 0.0;
					_tmp1_ = a;
					a = _tmp1_ + (G_PI / 16);
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= G_PI)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_double (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = number_sin (_tmp5_, ANGLE_UNIT_RADIANS);
				_tmp7_ = _tmp6_;
				_number_unref0 (_tmp5_);
				z = _tmp7_;
				_tmp8_ = a;
				_tmp9_ = sin (_tmp8_);
				expected = _tmp9_;
				_tmp10_ = z;
				_tmp11_ = expected;
				_tmp12_ = double_matches (_tmp10_, _tmp11_);
				if (!_tmp12_) {
					gdouble _tmp13_ = 0.0;
					Number* _tmp14_ = NULL;
					gdouble _tmp15_ = 0.0;
					gdouble _tmp16_ = 0.0;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					_tmp13_ = a;
					_tmp14_ = z;
					_tmp15_ = number_to_double (_tmp14_);
					_tmp16_ = expected;
					_tmp17_ = g_strdup_printf ("(%f).sin () -> %f, expected %f", _tmp13_, _tmp15_, _tmp16_);
					_tmp18_ = _tmp17_;
					fail (_tmp18_);
					_g_free0 (_tmp18_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_cos (void) {
	{
		gdouble a = 0.0;
		a = -G_PI;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gdouble _tmp2_ = 0.0;
				Number* z = NULL;
				gdouble _tmp3_ = 0.0;
				Number* _tmp4_ = NULL;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				gdouble expected = 0.0;
				gdouble _tmp8_ = 0.0;
				gdouble _tmp9_ = 0.0;
				Number* _tmp10_ = NULL;
				gdouble _tmp11_ = 0.0;
				gboolean _tmp12_ = FALSE;
				if (!_tmp0_) {
					gdouble _tmp1_ = 0.0;
					_tmp1_ = a;
					a = _tmp1_ + (G_PI / 16);
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= G_PI)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_double (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = number_cos (_tmp5_, ANGLE_UNIT_RADIANS);
				_tmp7_ = _tmp6_;
				_number_unref0 (_tmp5_);
				z = _tmp7_;
				_tmp8_ = a;
				_tmp9_ = cos (_tmp8_);
				expected = _tmp9_;
				_tmp10_ = z;
				_tmp11_ = expected;
				_tmp12_ = double_matches (_tmp10_, _tmp11_);
				if (!_tmp12_) {
					gdouble _tmp13_ = 0.0;
					Number* _tmp14_ = NULL;
					gdouble _tmp15_ = 0.0;
					gdouble _tmp16_ = 0.0;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					_tmp13_ = a;
					_tmp14_ = z;
					_tmp15_ = number_to_double (_tmp14_);
					_tmp16_ = expected;
					_tmp17_ = g_strdup_printf ("(%f).cos () -> %f, expected %f", _tmp13_, _tmp15_, _tmp16_);
					_tmp18_ = _tmp17_;
					fail (_tmp18_);
					_g_free0 (_tmp18_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_and (void) {
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ < 10)) {
					break;
				}
				{
					gint b = 0;
					b = 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							Number* _tmp7_ = NULL;
							Number* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							Number* _tmp11_ = NULL;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							gint expected = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							Number* _tmp16_ = NULL;
							gint64 _tmp17_ = 0LL;
							gint _tmp18_ = 0;
							if (!_tmp3_) {
								gint _tmp4_ = 0;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ < 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = number_new_integer ((gint64) _tmp6_);
							_tmp8_ = _tmp7_;
							_tmp9_ = b;
							_tmp10_ = number_new_integer ((gint64) _tmp9_);
							_tmp11_ = _tmp10_;
							_tmp12_ = number_and (_tmp8_, _tmp11_);
							_tmp13_ = _tmp12_;
							_number_unref0 (_tmp11_);
							_number_unref0 (_tmp8_);
							z = _tmp13_;
							_tmp14_ = a;
							_tmp15_ = b;
							expected = _tmp14_ & _tmp15_;
							_tmp16_ = z;
							_tmp17_ = number_to_integer (_tmp16_);
							_tmp18_ = expected;
							if (_tmp17_ != ((gint64) _tmp18_)) {
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								Number* _tmp21_ = NULL;
								gint64 _tmp22_ = 0LL;
								gint _tmp23_ = 0;
								gchar* _tmp24_ = NULL;
								gchar* _tmp25_ = NULL;
								_tmp19_ = a;
								_tmp20_ = b;
								_tmp21_ = z;
								_tmp22_ = number_to_integer (_tmp21_);
								_tmp23_ = expected;
								_tmp24_ = g_strdup_printf ("(%d).and (%d) -> %lli, expected %d", _tmp19_, _tmp20_, _tmp22_, _tmp23_);
								_tmp25_ = _tmp24_;
								fail (_tmp25_);
								_g_free0 (_tmp25_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void test_or (void) {
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ < 10)) {
					break;
				}
				{
					gint b = 0;
					b = 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							Number* _tmp7_ = NULL;
							Number* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							Number* _tmp11_ = NULL;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							gint expected = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							Number* _tmp16_ = NULL;
							gint64 _tmp17_ = 0LL;
							gint _tmp18_ = 0;
							if (!_tmp3_) {
								gint _tmp4_ = 0;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ < 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = number_new_integer ((gint64) _tmp6_);
							_tmp8_ = _tmp7_;
							_tmp9_ = b;
							_tmp10_ = number_new_integer ((gint64) _tmp9_);
							_tmp11_ = _tmp10_;
							_tmp12_ = number_or (_tmp8_, _tmp11_);
							_tmp13_ = _tmp12_;
							_number_unref0 (_tmp11_);
							_number_unref0 (_tmp8_);
							z = _tmp13_;
							_tmp14_ = a;
							_tmp15_ = b;
							expected = _tmp14_ | _tmp15_;
							_tmp16_ = z;
							_tmp17_ = number_to_integer (_tmp16_);
							_tmp18_ = expected;
							if (_tmp17_ != ((gint64) _tmp18_)) {
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								Number* _tmp21_ = NULL;
								gint64 _tmp22_ = 0LL;
								gint _tmp23_ = 0;
								gchar* _tmp24_ = NULL;
								gchar* _tmp25_ = NULL;
								_tmp19_ = a;
								_tmp20_ = b;
								_tmp21_ = z;
								_tmp22_ = number_to_integer (_tmp21_);
								_tmp23_ = expected;
								_tmp24_ = g_strdup_printf ("(%d).or (%d) -> %lli, expected %d", _tmp19_, _tmp20_, _tmp22_, _tmp23_);
								_tmp25_ = _tmp24_;
								fail (_tmp25_);
								_g_free0 (_tmp25_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void test_xor (void) {
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ < 10)) {
					break;
				}
				{
					gint b = 0;
					b = 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							Number* _tmp7_ = NULL;
							Number* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							Number* _tmp11_ = NULL;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							gint expected = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							Number* _tmp16_ = NULL;
							gint64 _tmp17_ = 0LL;
							gint _tmp18_ = 0;
							if (!_tmp3_) {
								gint _tmp4_ = 0;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ < 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = number_new_integer ((gint64) _tmp6_);
							_tmp8_ = _tmp7_;
							_tmp9_ = b;
							_tmp10_ = number_new_integer ((gint64) _tmp9_);
							_tmp11_ = _tmp10_;
							_tmp12_ = number_xor (_tmp8_, _tmp11_);
							_tmp13_ = _tmp12_;
							_number_unref0 (_tmp11_);
							_number_unref0 (_tmp8_);
							z = _tmp13_;
							_tmp14_ = a;
							_tmp15_ = b;
							expected = _tmp14_ ^ _tmp15_;
							_tmp16_ = z;
							_tmp17_ = number_to_integer (_tmp16_);
							_tmp18_ = expected;
							if (_tmp17_ != ((gint64) _tmp18_)) {
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								Number* _tmp21_ = NULL;
								gint64 _tmp22_ = 0LL;
								gint _tmp23_ = 0;
								gchar* _tmp24_ = NULL;
								gchar* _tmp25_ = NULL;
								_tmp19_ = a;
								_tmp20_ = b;
								_tmp21_ = z;
								_tmp22_ = number_to_integer (_tmp21_);
								_tmp23_ = expected;
								_tmp24_ = g_strdup_printf ("(%d).xor (%d) -> %lli, expected %d", _tmp19_, _tmp20_, _tmp22_, _tmp23_);
								_tmp25_ = _tmp24_;
								fail (_tmp25_);
								_g_free0 (_tmp25_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void test_not (void) {
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				Number* z = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				gint expected = 0;
				gint _tmp8_ = 0;
				Number* _tmp9_ = NULL;
				gint64 _tmp10_ = 0LL;
				gint _tmp11_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ < 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_integer ((gint64) _tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = number_not (_tmp5_, 8);
				_tmp7_ = _tmp6_;
				_number_unref0 (_tmp5_);
				z = _tmp7_;
				_tmp8_ = a;
				expected = (~_tmp8_) & 0xFF;
				_tmp9_ = z;
				_tmp10_ = number_to_integer (_tmp9_);
				_tmp11_ = expected;
				if (_tmp10_ != ((gint64) _tmp11_)) {
					gint _tmp12_ = 0;
					Number* _tmp13_ = NULL;
					gint64 _tmp14_ = 0LL;
					gint _tmp15_ = 0;
					gchar* _tmp16_ = NULL;
					gchar* _tmp17_ = NULL;
					_tmp12_ = a;
					_tmp13_ = z;
					_tmp14_ = number_to_integer (_tmp13_);
					_tmp15_ = expected;
					_tmp16_ = g_strdup_printf ("(%d).not () -> %lli, expected %d", _tmp12_, _tmp14_, _tmp15_);
					_tmp17_ = _tmp16_;
					fail (_tmp17_);
					_g_free0 (_tmp17_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_shift (void) {
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ < 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_ = 0;
							Number* z = NULL;
							gint _tmp6_ = 0;
							Number* _tmp7_ = NULL;
							Number* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							Number* _tmp11_ = NULL;
							gint expected = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							Number* _tmp17_ = NULL;
							gint64 _tmp18_ = 0LL;
							gint _tmp19_ = 0;
							if (!_tmp3_) {
								gint _tmp4_ = 0;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ < 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = number_new_integer ((gint64) _tmp6_);
							_tmp8_ = _tmp7_;
							_tmp9_ = b;
							_tmp10_ = number_shift (_tmp8_, _tmp9_);
							_tmp11_ = _tmp10_;
							_number_unref0 (_tmp8_);
							z = _tmp11_;
							_tmp12_ = a;
							_tmp13_ = b;
							expected = _tmp12_ << _tmp13_;
							_tmp14_ = b;
							if (_tmp14_ < 0) {
								gint _tmp15_ = 0;
								gint _tmp16_ = 0;
								_tmp15_ = a;
								_tmp16_ = b;
								expected = _tmp15_ >> (-_tmp16_);
							}
							_tmp17_ = z;
							_tmp18_ = number_to_integer (_tmp17_);
							_tmp19_ = expected;
							if (_tmp18_ != ((gint64) _tmp19_)) {
								gint _tmp20_ = 0;
								gint _tmp21_ = 0;
								Number* _tmp22_ = NULL;
								gint64 _tmp23_ = 0LL;
								gint _tmp24_ = 0;
								gchar* _tmp25_ = NULL;
								gchar* _tmp26_ = NULL;
								_tmp20_ = a;
								_tmp21_ = b;
								_tmp22_ = z;
								_tmp23_ = number_to_integer (_tmp22_);
								_tmp24_ = expected;
								_tmp25_ = g_strdup_printf ("(%d).shift (%d) -> %lli, expected %d", _tmp20_, _tmp21_, _tmp23_, _tmp24_);
								_tmp26_ = _tmp25_;
								fail (_tmp26_);
								_g_free0 (_tmp26_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


static gpointer _number_ref0 (gpointer self) {
	return self ? number_ref (self) : NULL;
}


static void _number_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (number_unref (var), NULL));
}


static void _g_list_free__number_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _number_unref0_, NULL);
	g_list_free (self);
}


void test_factorize (void) {
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				GList* factors = NULL;
				gint _tmp3_ = 0;
				Number* _tmp4_ = NULL;
				Number* _tmp5_ = NULL;
				GList* _tmp6_ = NULL;
				GList* _tmp7_ = NULL;
				GList* expected = NULL;
				gint _tmp8_ = 0;
				GList* _tmp9_ = NULL;
				gboolean matches = FALSE;
				GList* _tmp10_ = NULL;
				guint _tmp11_ = 0U;
				GList* _tmp12_ = NULL;
				guint _tmp13_ = 0U;
				gboolean _tmp26_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ < 100)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_integer ((gint64) _tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = number_factorize (_tmp5_);
				_tmp7_ = _tmp6_;
				_number_unref0 (_tmp5_);
				factors = _tmp7_;
				_tmp8_ = a;
				_tmp9_ = factorize (_tmp8_);
				expected = _tmp9_;
				matches = FALSE;
				_tmp10_ = factors;
				_tmp11_ = g_list_length (_tmp10_);
				_tmp12_ = expected;
				_tmp13_ = g_list_length (_tmp12_);
				if (_tmp11_ == _tmp13_) {
					matches = TRUE;
					{
						gint i = 0;
						i = 0;
						{
							gboolean _tmp14_ = FALSE;
							_tmp14_ = TRUE;
							while (TRUE) {
								gint _tmp16_ = 0;
								GList* _tmp17_ = NULL;
								guint _tmp18_ = 0U;
								GList* _tmp19_ = NULL;
								gint _tmp20_ = 0;
								gconstpointer _tmp21_ = NULL;
								gint64 _tmp22_ = 0LL;
								GList* _tmp23_ = NULL;
								gint _tmp24_ = 0;
								gconstpointer _tmp25_ = NULL;
								if (!_tmp14_) {
									gint _tmp15_ = 0;
									_tmp15_ = i;
									i = _tmp15_ + 1;
								}
								_tmp14_ = FALSE;
								_tmp16_ = i;
								_tmp17_ = factors;
								_tmp18_ = g_list_length (_tmp17_);
								if (!(((guint) _tmp16_) < _tmp18_)) {
									break;
								}
								_tmp19_ = factors;
								_tmp20_ = i;
								_tmp21_ = g_list_nth_data (_tmp19_, (guint) _tmp20_);
								_tmp22_ = number_to_integer ((Number*) _tmp21_);
								_tmp23_ = expected;
								_tmp24_ = i;
								_tmp25_ = g_list_nth_data (_tmp23_, (guint) _tmp24_);
								if (_tmp22_ != ((gint64) ((gint) ((gintptr) _tmp25_)))) {
									matches = FALSE;
								}
							}
						}
					}
				}
				_tmp26_ = matches;
				if (!_tmp26_) {
					gchar* factors_string = NULL;
					gchar* _tmp27_ = NULL;
					GList* _tmp28_ = NULL;
					gchar* expected_string = NULL;
					gchar* _tmp39_ = NULL;
					GList* _tmp40_ = NULL;
					gint _tmp49_ = 0;
					const gchar* _tmp50_ = NULL;
					const gchar* _tmp51_ = NULL;
					gchar* _tmp52_ = NULL;
					gchar* _tmp53_ = NULL;
					_tmp27_ = g_strdup ("");
					factors_string = _tmp27_;
					_tmp28_ = factors;
					{
						GList* f_collection = NULL;
						GList* f_it = NULL;
						f_collection = _tmp28_;
						for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
							Number* _tmp29_ = NULL;
							Number* f = NULL;
							_tmp29_ = _number_ref0 ((Number*) f_it->data);
							f = _tmp29_;
							{
								const gchar* _tmp30_ = NULL;
								const gchar* _tmp33_ = NULL;
								Number* _tmp34_ = NULL;
								gint64 _tmp35_ = 0LL;
								gchar* _tmp36_ = NULL;
								gchar* _tmp37_ = NULL;
								gchar* _tmp38_ = NULL;
								_tmp30_ = factors_string;
								if (g_strcmp0 (_tmp30_, "") != 0) {
									const gchar* _tmp31_ = NULL;
									gchar* _tmp32_ = NULL;
									_tmp31_ = factors_string;
									_tmp32_ = g_strconcat (_tmp31_, ", ", NULL);
									_g_free0 (factors_string);
									factors_string = _tmp32_;
								}
								_tmp33_ = factors_string;
								_tmp34_ = f;
								_tmp35_ = number_to_integer (_tmp34_);
								_tmp36_ = g_strdup_printf ("%d", (gint) _tmp35_);
								_tmp37_ = _tmp36_;
								_tmp38_ = g_strconcat (_tmp33_, _tmp37_, NULL);
								_g_free0 (factors_string);
								factors_string = _tmp38_;
								_g_free0 (_tmp37_);
								_number_unref0 (f);
							}
						}
					}
					_tmp39_ = g_strdup ("");
					expected_string = _tmp39_;
					_tmp40_ = expected;
					{
						GList* f_collection = NULL;
						GList* f_it = NULL;
						f_collection = _tmp40_;
						for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
							gint f = 0;
							f = (gint) ((gintptr) f_it->data);
							{
								const gchar* _tmp41_ = NULL;
								const gchar* _tmp44_ = NULL;
								gint _tmp45_ = 0;
								gchar* _tmp46_ = NULL;
								gchar* _tmp47_ = NULL;
								gchar* _tmp48_ = NULL;
								_tmp41_ = expected_string;
								if (g_strcmp0 (_tmp41_, "") != 0) {
									const gchar* _tmp42_ = NULL;
									gchar* _tmp43_ = NULL;
									_tmp42_ = expected_string;
									_tmp43_ = g_strconcat (_tmp42_, ", ", NULL);
									_g_free0 (expected_string);
									expected_string = _tmp43_;
								}
								_tmp44_ = expected_string;
								_tmp45_ = f;
								_tmp46_ = g_strdup_printf ("%d", _tmp45_);
								_tmp47_ = _tmp46_;
								_tmp48_ = g_strconcat (_tmp44_, _tmp47_, NULL);
								_g_free0 (expected_string);
								expected_string = _tmp48_;
								_g_free0 (_tmp47_);
							}
						}
					}
					_tmp49_ = a;
					_tmp50_ = factors_string;
					_tmp51_ = expected_string;
					_tmp52_ = g_strdup_printf ("(%d).factorize () -> (%s), expected (%s)", _tmp49_, _tmp50_, _tmp51_);
					_tmp53_ = _tmp52_;
					fail (_tmp53_);
					_g_free0 (_tmp53_);
					_g_free0 (expected_string);
					_g_free0 (factors_string);
					_g_list_free0 (expected);
					__g_list_free__number_unref0_0 (factors);
					return;
				}
				_g_list_free0 (expected);
				__g_list_free__number_unref0_0 (factors);
			}
		}
	}
	pass (NULL);
}


GList* factorize (gint number) {
	GList* result = NULL;
	GList* factors = NULL;
	gint _tmp0_ = 0;
	gint n = 0;
	gint _tmp2_ = 0;
	factors = NULL;
	_tmp0_ = number;
	if (_tmp0_ < 2) {
		gint _tmp1_ = 0;
		_tmp1_ = number;
		factors = g_list_append (factors, (gpointer) ((gintptr) _tmp1_));
		result = factors;
		return result;
	}
	_tmp2_ = number;
	n = _tmp2_;
	while (TRUE) {
		{
			gint factor = 0;
			factor = 2;
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = TRUE;
				while (TRUE) {
					gint _tmp5_ = 0;
					gint _tmp6_ = 0;
					gint _tmp7_ = 0;
					gint _tmp8_ = 0;
					if (!_tmp3_) {
						gint _tmp4_ = 0;
						_tmp4_ = factor;
						factor = _tmp4_ + 1;
					}
					_tmp3_ = FALSE;
					_tmp5_ = factor;
					_tmp6_ = n;
					if (!(_tmp5_ <= _tmp6_)) {
						break;
					}
					_tmp7_ = n;
					_tmp8_ = factor;
					if ((_tmp7_ % _tmp8_) == 0) {
						gint _tmp9_ = 0;
						gint _tmp10_ = 0;
						gint _tmp11_ = 0;
						gint _tmp12_ = 0;
						_tmp9_ = factor;
						factors = g_list_append (factors, (gpointer) ((gintptr) _tmp9_));
						_tmp10_ = n;
						_tmp11_ = factor;
						n = _tmp10_ / _tmp11_;
						_tmp12_ = n;
						if (_tmp12_ == 1) {
							result = factors;
							return result;
						}
						break;
					}
				}
			}
		}
	}
	_g_list_free0 (factors);
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp7_ = 0;
	setlocale (LC_ALL, "C");
	test_integer ();
	test_unsigned_integer ();
	test_fraction ();
	test_float ();
	test_double ();
	test_complex ();
	test_polar ();
	test_string ();
	test_eulers ();
	test_i ();
	test_pi ();
	test_is_zero ();
	test_is_negative ();
	test_is_integer ();
	test_is_positive_integer ();
	test_is_natural ();
	test_is_complex ();
	test_sgn ();
	test_invert_sign ();
	test_abs ();
	test_arg ();
	test_conjugate ();
	test_real_component ();
	test_imaginary_component ();
	test_integer_component ();
	test_fractional_component ();
	test_fractional_part ();
	test_floor ();
	test_ceiling ();
	test_round ();
	test_reciprocal ();
	test_epowy ();
	test_xpowy ();
	test_xpowy_integer ();
	test_root3 ();
	test_sqrt ();
	test_ln ();
	test_logarithm2 ();
	test_logarithm10 ();
	test_factorial ();
	test_add ();
	test_subtract ();
	test_multiply ();
	test_multiply_integer ();
	test_divide ();
	test_divide_integer ();
	test_modulus_divide ();
	test_sin ();
	test_cos ();
	test_and ();
	test_or ();
	test_xor ();
	test_not ();
	test_shift ();
	test_factorize ();
	_tmp0_ = fail_count;
	if (_tmp0_ == 0) {
		FILE* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		_tmp1_ = stdout;
		_tmp2_ = pass_count;
		fprintf (_tmp1_, "Passed all %i tests\n", _tmp2_);
	} else {
		FILE* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		_tmp3_ = stdout;
		_tmp4_ = fail_count;
		_tmp5_ = pass_count;
		_tmp6_ = fail_count;
		fprintf (_tmp3_, "Failed %i/%d tests\n", _tmp4_, _tmp5_ + _tmp6_);
	}
	_tmp7_ = fail_count;
	result = _tmp7_;
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return _vala_main (argv, argc);
}



