/* gnome-calculator.c generated by valac 0.32.1, the Vala compiler
 * generated from gnome-calculator.vala, do not modify */

/*
 * Copyright (C) 1987-2008 Sun Microsystems, Inc. All Rights Reserved.
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "libcalculator.h"
#include <stdio.h>
#include <langinfo.h>
#include <glib/gi18n-lib.h>
#include <locale.h>


#define TYPE_CALCULATOR (calculator_get_type ())
#define CALCULATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CALCULATOR, Calculator))
#define CALCULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CALCULATOR, CalculatorClass))
#define IS_CALCULATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CALCULATOR))
#define IS_CALCULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CALCULATOR))
#define CALCULATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CALCULATOR, CalculatorClass))

typedef struct _Calculator Calculator;
typedef struct _CalculatorClass CalculatorClass;
typedef struct _CalculatorPrivate CalculatorPrivate;

#define TYPE_MATH_WINDOW (math_window_get_type ())
#define MATH_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_WINDOW, MathWindow))
#define MATH_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_WINDOW, MathWindowClass))
#define IS_MATH_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_WINDOW))
#define IS_MATH_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_WINDOW))
#define MATH_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_WINDOW, MathWindowClass))

typedef struct _MathWindow MathWindow;
typedef struct _MathWindowClass MathWindowClass;

#define TYPE_MATH_PREFERENCES_DIALOG (math_preferences_dialog_get_type ())
#define MATH_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialog))
#define MATH_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialogClass))
#define IS_MATH_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_PREFERENCES_DIALOG))
#define IS_MATH_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_PREFERENCES_DIALOG))
#define MATH_PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialogClass))

typedef struct _MathPreferencesDialog MathPreferencesDialog;
typedef struct _MathPreferencesDialogClass MathPreferencesDialogClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_BUTTON_MODE (button_mode_get_type ())

#define TYPE_MATH_BUTTONS (math_buttons_get_type ())
#define MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_BUTTONS, MathButtons))
#define MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_BUTTONS, MathButtonsClass))
#define IS_MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_BUTTONS))
#define IS_MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_BUTTONS))
#define MATH_BUTTONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_BUTTONS, MathButtonsClass))

typedef struct _MathButtons MathButtons;
typedef struct _MathButtonsClass MathButtonsClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define TYPE_SOLVE_EQUATION (solve_equation_get_type ())
#define SOLVE_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOLVE_EQUATION, SolveEquation))
#define SOLVE_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOLVE_EQUATION, SolveEquationClass))
#define IS_SOLVE_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOLVE_EQUATION))
#define IS_SOLVE_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOLVE_EQUATION))
#define SOLVE_EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOLVE_EQUATION, SolveEquationClass))

typedef struct _SolveEquation SolveEquation;
typedef struct _SolveEquationClass SolveEquationClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _SolveEquationPrivate SolveEquationPrivate;

struct _Calculator {
	GtkApplication parent_instance;
	CalculatorPrivate * priv;
};

struct _CalculatorClass {
	GtkApplicationClass parent_class;
};

struct _CalculatorPrivate {
	GSettings* settings;
	MathWindow* window;
	MathPreferencesDialog* preferences_dialog;
};

typedef enum  {
	BUTTON_MODE_BASIC,
	BUTTON_MODE_ADVANCED,
	BUTTON_MODE_FINANCIAL,
	BUTTON_MODE_PROGRAMMING,
	BUTTON_MODE_KEYBOARD
} ButtonMode;

struct _SolveEquation {
	Equation parent_instance;
	SolveEquationPrivate * priv;
};

struct _SolveEquationClass {
	EquationClass parent_class;
};


static gpointer calculator_parent_class = NULL;
static gchar* calculator_program_name;
static gchar* calculator_program_name = NULL;
static gchar* calculator_equation_string;
static gchar* calculator_equation_string = NULL;
static gpointer solve_equation_parent_class = NULL;

GType calculator_get_type (void) G_GNUC_CONST;
GType math_window_get_type (void) G_GNUC_CONST;
GType math_preferences_dialog_get_type (void) G_GNUC_CONST;
#define CALCULATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CALCULATOR, CalculatorPrivate))
enum  {
	CALCULATOR_DUMMY_PROPERTY
};
static void calculator_show_preferences_cb (Calculator* self);
static void _calculator_show_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void calculator_help_cb (Calculator* self);
static void _calculator_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void calculator_about_cb (Calculator* self);
static void _calculator_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void calculator_quit_cb (Calculator* self);
static void _calculator_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Calculator* calculator_new (void);
Calculator* calculator_construct (GType object_type);
static void calculator_real_startup (GApplication* base);
GType button_mode_get_type (void) G_GNUC_CONST;
MathWindow* math_window_new (GtkApplication* app, MathEquation* equation);
MathWindow* math_window_construct (GType object_type, GtkApplication* app, MathEquation* equation);
GType math_buttons_get_type (void) G_GNUC_CONST;
MathButtons* math_window_get_buttons (MathWindow* self);
void math_buttons_set_programming_base (MathButtons* self, gint value);
void math_buttons_set_mode (MathButtons* self, ButtonMode value);
static void calculator_real_activate (GApplication* base);
MathEquation* math_window_get_equation (MathWindow* self);
static void calculator_real_shutdown (GApplication* base);
ButtonMode math_buttons_get_mode (MathButtons* self);
gint math_buttons_get_programming_base (MathButtons* self);
static gint calculator_real_handle_local_options (GApplication* base, GVariantDict* options);
static gchar* _variant_get1 (GVariant* value);
GType solve_equation_get_type (void) G_GNUC_CONST;
SolveEquation* solve_equation_new (const gchar* text);
SolveEquation* solve_equation_construct (GType object_type, const gchar* text);
MathPreferencesDialog* math_preferences_dialog_new (MathEquation* eq);
MathPreferencesDialog* math_preferences_dialog_construct (GType object_type, MathEquation* eq);
gint calculator_main (gchar** args, int args_length1);
static void calculator_finalize (GObject* obj);
enum  {
	SOLVE_EQUATION_DUMMY_PROPERTY
};
static Number* solve_equation_real_convert (Equation* base, Number* x, const gchar* x_units, const gchar* z_units);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry CALCULATOR_option_entries[4] = {{"solve", 's', 0, G_OPTION_ARG_STRING, NULL, "Solve given equation", "equation"}, {"equation", 'e', 0, G_OPTION_ARG_STRING, &calculator_equation_string, "Start with given equation", "equation"}, {"version", 'v', 0, G_OPTION_ARG_NONE, NULL, "Show release version", NULL}, {NULL}};
static const GActionEntry CALCULATOR_app_entries[4] = {{"preferences", _calculator_show_preferences_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"help", _calculator_help_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"about", _calculator_about_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"quit", _calculator_quit_cb_gsimple_action_activate_callback, NULL, NULL, NULL}};

static void _calculator_show_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	calculator_show_preferences_cb ((Calculator*) self);
}


static void _calculator_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	calculator_help_cb ((Calculator*) self);
}


static void _calculator_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	calculator_about_cb ((Calculator*) self);
}


static void _calculator_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	calculator_quit_cb ((Calculator*) self);
}


Calculator* calculator_construct (GType object_type) {
	Calculator * self = NULL;
	self = (Calculator*) g_object_new (object_type, "flags", G_APPLICATION_NON_UNIQUE, NULL);
	g_application_add_main_option_entries ((GApplication*) self, CALCULATOR_option_entries);
	return self;
}


Calculator* calculator_new (void) {
	return calculator_construct (TYPE_CALCULATOR);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void calculator_real_startup (GApplication* base) {
	Calculator * self;
	GSettings* _tmp0_ = NULL;
	gint accuracy = 0;
	GSettings* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint word_size = 0;
	GSettings* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint number_base = 0;
	GSettings* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gboolean show_tsep = FALSE;
	GSettings* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean show_zeroes = FALSE;
	GSettings* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	DisplayFormat number_format = 0;
	GSettings* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	AngleUnit angle_units = 0;
	GSettings* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	ButtonMode button_mode = 0;
	GSettings* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gchar* source_currency = NULL;
	GSettings* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* target_currency = NULL;
	GSettings* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* source_units = NULL;
	GSettings* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* target_units = NULL;
	GSettings* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gint precision = 0;
	GSettings* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	MathEquation* equation = NULL;
	MathEquation* _tmp27_ = NULL;
	gulong _tmp28_ = 0UL;
	gulong _tmp29_ = 0UL;
	MathWindow* _tmp30_ = NULL;
	MathButtons* buttons = NULL;
	MathWindow* _tmp31_ = NULL;
	MathButtons* _tmp32_ = NULL;
	MathButtons* _tmp33_ = NULL;
	MathButtons* _tmp34_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp35_ = NULL;
	GMenuModel* menu = NULL;
	GObject* _tmp37_ = NULL;
	GMenuModel* _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
	gchar** _tmp40_ = NULL;
	gchar** _tmp41_ = NULL;
	gint _tmp41__length1 = 0;
	gchar* _tmp42_ = NULL;
	gchar** _tmp43_ = NULL;
	gchar** _tmp44_ = NULL;
	gint _tmp44__length1 = 0;
	gchar* _tmp45_ = NULL;
	gchar** _tmp46_ = NULL;
	gchar** _tmp47_ = NULL;
	gint _tmp47__length1 = 0;
	gchar* _tmp48_ = NULL;
	gchar** _tmp49_ = NULL;
	gchar** _tmp50_ = NULL;
	gint _tmp50__length1 = 0;
	GError * _inner_error_ = NULL;
	self = (Calculator*) base;
	G_APPLICATION_CLASS (calculator_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = g_settings_new ("org.gnome.calculator");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_get_int (_tmp1_, "accuracy");
	accuracy = _tmp2_;
	_tmp3_ = self->priv->settings;
	_tmp4_ = g_settings_get_int (_tmp3_, "word-size");
	word_size = _tmp4_;
	_tmp5_ = self->priv->settings;
	_tmp6_ = g_settings_get_int (_tmp5_, "base");
	number_base = _tmp6_;
	_tmp7_ = self->priv->settings;
	_tmp8_ = g_settings_get_boolean (_tmp7_, "show-thousands");
	show_tsep = _tmp8_;
	_tmp9_ = self->priv->settings;
	_tmp10_ = g_settings_get_boolean (_tmp9_, "show-zeroes");
	show_zeroes = _tmp10_;
	_tmp11_ = self->priv->settings;
	_tmp12_ = g_settings_get_enum (_tmp11_, "number-format");
	number_format = (DisplayFormat) _tmp12_;
	_tmp13_ = self->priv->settings;
	_tmp14_ = g_settings_get_enum (_tmp13_, "angle-units");
	angle_units = (AngleUnit) _tmp14_;
	_tmp15_ = self->priv->settings;
	_tmp16_ = g_settings_get_enum (_tmp15_, "button-mode");
	button_mode = (ButtonMode) _tmp16_;
	_tmp17_ = self->priv->settings;
	_tmp18_ = g_settings_get_string (_tmp17_, "source-currency");
	source_currency = _tmp18_;
	_tmp19_ = self->priv->settings;
	_tmp20_ = g_settings_get_string (_tmp19_, "target-currency");
	target_currency = _tmp20_;
	_tmp21_ = self->priv->settings;
	_tmp22_ = g_settings_get_string (_tmp21_, "source-units");
	source_units = _tmp22_;
	_tmp23_ = self->priv->settings;
	_tmp24_ = g_settings_get_string (_tmp23_, "target-units");
	target_units = _tmp24_;
	_tmp25_ = self->priv->settings;
	_tmp26_ = g_settings_get_int (_tmp25_, "precision");
	precision = _tmp26_;
	_tmp27_ = math_equation_new ();
	equation = _tmp27_;
	math_equation_set_accuracy (equation, accuracy);
	math_equation_set_word_size (equation, word_size);
	math_equation_set_show_thousands_separators (equation, show_tsep);
	math_equation_set_show_trailing_zeroes (equation, show_zeroes);
	math_equation_set_number_format (equation, number_format);
	math_equation_set_angle_units (equation, angle_units);
	math_equation_set_source_currency (equation, source_currency);
	math_equation_set_target_currency (equation, target_currency);
	math_equation_set_source_units (equation, source_units);
	math_equation_set_target_units (equation, target_units);
	_tmp28_ = number_get_precision ();
	_tmp29_ = _tmp28_;
	number_set_precision ((gulong) precision);
	g_action_map_add_action_entries ((GActionMap*) self, CALCULATOR_app_entries, G_N_ELEMENTS (CALCULATOR_app_entries), self);
	_tmp30_ = math_window_new ((GtkApplication*) self, equation);
	g_object_ref_sink (_tmp30_);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp30_;
	_tmp31_ = self->priv->window;
	_tmp32_ = math_window_get_buttons (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = _g_object_ref0 (_tmp33_);
	buttons = _tmp34_;
	math_buttons_set_programming_base (buttons, number_base);
	math_buttons_set_mode (buttons, button_mode);
	_tmp35_ = gtk_builder_new ();
	builder = _tmp35_;
	{
		gtk_builder_add_from_resource (builder, "/org/gnome/calculator/menu.ui", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp36_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp36_ = e->message;
		g_error ("gnome-calculator.vala:88: Error loading menu UI: %s", _tmp36_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (builder);
		_g_object_unref0 (buttons);
		_g_object_unref0 (equation);
		_g_free0 (target_units);
		_g_free0 (source_units);
		_g_free0 (target_currency);
		_g_free0 (source_currency);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp37_ = gtk_builder_get_object (builder, "appmenu");
	_tmp38_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp37_, g_menu_model_get_type ()) ? ((GMenuModel*) _tmp37_) : NULL);
	menu = _tmp38_;
	gtk_application_set_app_menu ((GtkApplication*) self, menu);
	_tmp39_ = g_strdup ("<control>C");
	_tmp40_ = g_new0 (gchar*, 1 + 1);
	_tmp40_[0] = _tmp39_;
	_tmp41_ = _tmp40_;
	_tmp41__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.copy", _tmp41_);
	_tmp41_ = (_vala_array_free (_tmp41_, _tmp41__length1, (GDestroyNotify) g_free), NULL);
	_tmp42_ = g_strdup ("<control>V");
	_tmp43_ = g_new0 (gchar*, 1 + 1);
	_tmp43_[0] = _tmp42_;
	_tmp44_ = _tmp43_;
	_tmp44__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.paste", _tmp44_);
	_tmp44_ = (_vala_array_free (_tmp44_, _tmp44__length1, (GDestroyNotify) g_free), NULL);
	_tmp45_ = g_strdup ("<control>Z");
	_tmp46_ = g_new0 (gchar*, 1 + 1);
	_tmp46_[0] = _tmp45_;
	_tmp47_ = _tmp46_;
	_tmp47__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.undo", _tmp47_);
	_tmp47_ = (_vala_array_free (_tmp47_, _tmp47__length1, (GDestroyNotify) g_free), NULL);
	_tmp48_ = g_strdup ("<control><shift>Z");
	_tmp49_ = g_new0 (gchar*, 1 + 1);
	_tmp49_[0] = _tmp48_;
	_tmp50_ = _tmp49_;
	_tmp50__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.redo", _tmp50_);
	_tmp50_ = (_vala_array_free (_tmp50_, _tmp50__length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (menu);
	_g_object_unref0 (builder);
	_g_object_unref0 (buttons);
	_g_object_unref0 (equation);
	_g_free0 (target_units);
	_g_free0 (source_units);
	_g_free0 (target_currency);
	_g_free0 (source_currency);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void calculator_real_activate (GApplication* base) {
	Calculator * self;
	MathWindow* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	self = (Calculator*) base;
	G_APPLICATION_CLASS (calculator_parent_class)->activate ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = self->priv->window;
	gtk_window_present ((GtkWindow*) _tmp0_);
	_tmp2_ = calculator_equation_string;
	if (g_strcmp0 (_tmp2_, "") != 0) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = calculator_equation_string;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar** equations = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar** _tmp7_ = NULL;
		gchar** _tmp8_ = NULL;
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		gint equations_length1 = 0;
		gint _equations_size_ = 0;
		_tmp4_ = calculator_equation_string;
		_tmp5_ = g_strcompress (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "\n", 0);
		_tmp9_ = _tmp8_;
		_tmp9__length1 = _vala_array_length (_tmp7_);
		_g_free0 (_tmp6_);
		equations = _tmp9_;
		equations_length1 = _tmp9__length1;
		_equations_size_ = equations_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp10_ = FALSE;
				_tmp10_ = TRUE;
				while (TRUE) {
					gint _tmp12_ = 0;
					gchar** _tmp13_ = NULL;
					gint _tmp13__length1 = 0;
					gchar** _tmp14_ = NULL;
					gint _tmp14__length1 = 0;
					gint _tmp15_ = 0;
					const gchar* _tmp16_ = NULL;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					gint _tmp19_ = 0;
					gint _tmp20_ = 0;
					gboolean _tmp21_ = FALSE;
					if (!_tmp10_) {
						gint _tmp11_ = 0;
						_tmp11_ = i;
						i = _tmp11_ + 1;
					}
					_tmp10_ = FALSE;
					_tmp12_ = i;
					_tmp13_ = equations;
					_tmp13__length1 = equations_length1;
					if (!(_tmp12_ < _tmp13__length1)) {
						break;
					}
					_tmp14_ = equations;
					_tmp14__length1 = equations_length1;
					_tmp15_ = i;
					_tmp16_ = _tmp14_[_tmp15_];
					_tmp17_ = string_strip (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = strlen (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp21_ = _tmp20_ > 0;
					_g_free0 (_tmp18_);
					if (_tmp21_) {
						MathWindow* _tmp22_ = NULL;
						MathEquation* _tmp23_ = NULL;
						MathEquation* _tmp24_ = NULL;
						gchar** _tmp25_ = NULL;
						gint _tmp25__length1 = 0;
						gint _tmp26_ = 0;
						const gchar* _tmp27_ = NULL;
						_tmp22_ = self->priv->window;
						_tmp23_ = math_window_get_equation (_tmp22_);
						_tmp24_ = _tmp23_;
						_tmp25_ = equations;
						_tmp25__length1 = equations_length1;
						_tmp26_ = i;
						_tmp27_ = _tmp25_[_tmp26_];
						math_equation_set (_tmp24_, _tmp27_);
					} else {
						MathWindow* _tmp28_ = NULL;
						MathEquation* _tmp29_ = NULL;
						MathEquation* _tmp30_ = NULL;
						_tmp28_ = self->priv->window;
						_tmp29_ = math_window_get_equation (_tmp28_);
						_tmp30_ = _tmp29_;
						math_equation_solve (_tmp30_);
					}
				}
			}
		}
		equations = (_vala_array_free (equations, equations_length1, (GDestroyNotify) g_free), NULL);
	}
}


static void calculator_real_shutdown (GApplication* base) {
	Calculator * self;
	MathEquation* equation = NULL;
	MathWindow* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	MathEquation* _tmp2_ = NULL;
	MathEquation* _tmp3_ = NULL;
	MathButtons* buttons = NULL;
	MathWindow* _tmp4_ = NULL;
	MathButtons* _tmp5_ = NULL;
	MathButtons* _tmp6_ = NULL;
	MathButtons* _tmp7_ = NULL;
	GSettings* _tmp8_ = NULL;
	ButtonMode _tmp9_ = 0;
	ButtonMode _tmp10_ = 0;
	GSettings* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	GSettings* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	GSettings* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	GSettings* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	GSettings* _tmp23_ = NULL;
	DisplayFormat _tmp24_ = 0;
	DisplayFormat _tmp25_ = 0;
	GSettings* _tmp26_ = NULL;
	AngleUnit _tmp27_ = 0;
	AngleUnit _tmp28_ = 0;
	GSettings* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	GSettings* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	GSettings* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	GSettings* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	GSettings* _tmp45_ = NULL;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
	self = (Calculator*) base;
	G_APPLICATION_CLASS (calculator_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = self->priv->window;
	_tmp1_ = math_window_get_equation (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	equation = _tmp3_;
	_tmp4_ = self->priv->window;
	_tmp5_ = math_window_get_buttons (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	buttons = _tmp7_;
	_tmp8_ = self->priv->settings;
	_tmp9_ = math_buttons_get_mode (buttons);
	_tmp10_ = _tmp9_;
	g_settings_set_enum (_tmp8_, "button-mode", (gint) _tmp10_);
	_tmp11_ = self->priv->settings;
	_tmp12_ = math_equation_get_accuracy (equation);
	_tmp13_ = _tmp12_;
	g_settings_set_int (_tmp11_, "accuracy", _tmp13_);
	_tmp14_ = self->priv->settings;
	_tmp15_ = math_equation_get_word_size (equation);
	_tmp16_ = _tmp15_;
	g_settings_set_int (_tmp14_, "word-size", _tmp16_);
	_tmp17_ = self->priv->settings;
	_tmp18_ = math_equation_get_show_thousands_separators (equation);
	_tmp19_ = _tmp18_;
	g_settings_set_boolean (_tmp17_, "show-thousands", _tmp19_);
	_tmp20_ = self->priv->settings;
	_tmp21_ = math_equation_get_show_trailing_zeroes (equation);
	_tmp22_ = _tmp21_;
	g_settings_set_boolean (_tmp20_, "show-zeroes", _tmp22_);
	_tmp23_ = self->priv->settings;
	_tmp24_ = math_equation_get_number_format (equation);
	_tmp25_ = _tmp24_;
	g_settings_set_enum (_tmp23_, "number-format", (gint) _tmp25_);
	_tmp26_ = self->priv->settings;
	_tmp27_ = math_equation_get_angle_units (equation);
	_tmp28_ = _tmp27_;
	g_settings_set_enum (_tmp26_, "angle-units", (gint) _tmp28_);
	_tmp29_ = self->priv->settings;
	_tmp30_ = math_equation_get_source_currency (equation);
	_tmp31_ = _tmp30_;
	_tmp32_ = _tmp31_;
	g_settings_set_string (_tmp29_, "source-currency", _tmp32_);
	_g_free0 (_tmp32_);
	_tmp33_ = self->priv->settings;
	_tmp34_ = math_equation_get_target_currency (equation);
	_tmp35_ = _tmp34_;
	_tmp36_ = _tmp35_;
	g_settings_set_string (_tmp33_, "target-currency", _tmp36_);
	_g_free0 (_tmp36_);
	_tmp37_ = self->priv->settings;
	_tmp38_ = math_equation_get_source_units (equation);
	_tmp39_ = _tmp38_;
	_tmp40_ = _tmp39_;
	g_settings_set_string (_tmp37_, "source-units", _tmp40_);
	_g_free0 (_tmp40_);
	_tmp41_ = self->priv->settings;
	_tmp42_ = math_equation_get_target_units (equation);
	_tmp43_ = _tmp42_;
	_tmp44_ = _tmp43_;
	g_settings_set_string (_tmp41_, "target-units", _tmp44_);
	_g_free0 (_tmp44_);
	_tmp45_ = self->priv->settings;
	_tmp46_ = math_buttons_get_programming_base (buttons);
	_tmp47_ = _tmp46_;
	g_settings_set_int (_tmp45_, "base", _tmp47_);
	_g_object_unref0 (buttons);
	_g_object_unref0 (equation);
}


static gchar* _variant_get1 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gint calculator_real_handle_local_options (GApplication* base, GVariantDict* options) {
	Calculator * self;
	gint result = 0;
	GVariantDict* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GVariantDict* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	self = (Calculator*) base;
	g_return_val_if_fail (options != NULL, 0);
	_tmp0_ = options;
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
	if (_tmp1_) {
		FILE* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		_tmp2_ = stderr;
		_tmp3_ = calculator_program_name;
		fprintf (_tmp2_, "%1$s %2$s\n", _tmp3_, VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	_tmp4_ = options;
	_tmp5_ = g_variant_dict_contains (_tmp4_, "solve");
	if (_tmp5_) {
		gchar* solve_equation = NULL;
		GVariantDict* _tmp6_ = NULL;
		const GVariantType* _tmp7_ = NULL;
		GVariant* _tmp8_ = NULL;
		GVariant* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* tsep_string = NULL;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		const gchar* _tmp15_ = NULL;
		gchar* decimal = NULL;
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		SolveEquation* e = NULL;
		const gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		SolveEquation* _tmp29_ = NULL;
		SolveEquation* _tmp30_ = NULL;
		SolveEquation* _tmp31_ = NULL;
		SolveEquation* _tmp32_ = NULL;
		SolveEquation* _tmp33_ = NULL;
		ErrorCode _error_ = 0;
		guint representation_base = 0U;
		Number* _result_ = NULL;
		SolveEquation* _tmp34_ = NULL;
		guint _tmp35_ = 0U;
		ErrorCode _tmp36_ = 0;
		Number* _tmp37_ = NULL;
		Number* _tmp38_ = NULL;
		_tmp6_ = options;
		_tmp7_ = G_VARIANT_TYPE_STRING;
		_tmp8_ = g_variant_dict_lookup_value (_tmp6_, "solve", _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _variant_get1 (_tmp9_);
		_tmp11_ = _tmp10_;
		_g_variant_unref0 (_tmp9_);
		solve_equation = _tmp11_;
		_tmp12_ = nl_langinfo (THOUSEP);
		_tmp13_ = g_strdup (_tmp12_);
		tsep_string = _tmp13_;
		_tmp15_ = tsep_string;
		if (_tmp15_ == NULL) {
			_tmp14_ = TRUE;
		} else {
			const gchar* _tmp16_ = NULL;
			_tmp16_ = tsep_string;
			_tmp14_ = g_strcmp0 (_tmp16_, "") == 0;
		}
		if (_tmp14_) {
			gchar* _tmp17_ = NULL;
			_tmp17_ = g_strdup (" ");
			_g_free0 (tsep_string);
			tsep_string = _tmp17_;
		}
		_tmp18_ = nl_langinfo (RADIXCHAR);
		_tmp19_ = g_strdup (_tmp18_);
		decimal = _tmp19_;
		_tmp20_ = decimal;
		if (_tmp20_ == NULL) {
			gchar* _tmp21_ = NULL;
			_tmp21_ = g_strdup ("");
			_g_free0 (decimal);
			decimal = _tmp21_;
		}
		_tmp22_ = solve_equation;
		_tmp23_ = tsep_string;
		_tmp24_ = string_replace (_tmp22_, _tmp23_, "");
		_tmp25_ = _tmp24_;
		_tmp26_ = decimal;
		_tmp27_ = string_replace (_tmp25_, _tmp26_, ".");
		_tmp28_ = _tmp27_;
		_tmp29_ = solve_equation_new (_tmp28_);
		_tmp30_ = _tmp29_;
		_g_free0 (_tmp28_);
		_g_free0 (_tmp25_);
		e = _tmp30_;
		_tmp31_ = e;
		((Equation*) _tmp31_)->base = 10;
		_tmp32_ = e;
		((Equation*) _tmp32_)->wordlen = 32;
		_tmp33_ = e;
		((Equation*) _tmp33_)->angle_units = ANGLE_UNIT_DEGREES;
		_tmp34_ = e;
		_tmp37_ = equation_parse ((Equation*) _tmp34_, &_tmp35_, &_tmp36_, NULL, NULL, NULL);
		representation_base = _tmp35_;
		_error_ = _tmp36_;
		_result_ = _tmp37_;
		_tmp38_ = _result_;
		if (_tmp38_ != NULL) {
			Serializer* serializer = NULL;
			Serializer* _tmp39_ = NULL;
			Serializer* _tmp40_ = NULL;
			guint _tmp41_ = 0U;
			FILE* _tmp42_ = NULL;
			Serializer* _tmp43_ = NULL;
			Number* _tmp44_ = NULL;
			gchar* _tmp45_ = NULL;
			gchar* _tmp46_ = NULL;
			_tmp39_ = serializer_new (DISPLAY_FORMAT_AUTOMATIC, 10, 9);
			serializer = _tmp39_;
			_tmp40_ = serializer;
			_tmp41_ = representation_base;
			serializer_set_representation_base (_tmp40_, _tmp41_);
			_tmp42_ = stdout;
			_tmp43_ = serializer;
			_tmp44_ = _result_;
			_tmp45_ = serializer_to_string (_tmp43_, _tmp44_);
			_tmp46_ = _tmp45_;
			fprintf (_tmp42_, "%s\n", _tmp46_);
			_g_free0 (_tmp46_);
			result = EXIT_SUCCESS;
			_g_object_unref0 (serializer);
			_g_object_unref0 (_result_);
			_g_object_unref0 (e);
			_g_free0 (decimal);
			_g_free0 (tsep_string);
			_g_free0 (solve_equation);
			return result;
		} else {
			ErrorCode _tmp47_ = 0;
			_tmp47_ = _error_;
			if (_tmp47_ == ERROR_CODE_MP) {
				FILE* _tmp48_ = NULL;
				const gchar* _tmp49_ = NULL;
				const gchar* _tmp50_ = NULL;
				_tmp48_ = stderr;
				_tmp49_ = number_get_error ();
				_tmp50_ = _tmp49_;
				fprintf (_tmp48_, "Error: %s\n", _tmp50_);
				result = EXIT_FAILURE;
				_g_object_unref0 (_result_);
				_g_object_unref0 (e);
				_g_free0 (decimal);
				_g_free0 (tsep_string);
				_g_free0 (solve_equation);
				return result;
			} else {
				FILE* _tmp51_ = NULL;
				ErrorCode _tmp52_ = 0;
				gchar* _tmp53_ = NULL;
				gchar* _tmp54_ = NULL;
				_tmp51_ = stderr;
				_tmp52_ = _error_;
				_tmp53_ = mp_error_code_to_string (_tmp52_);
				_tmp54_ = _tmp53_;
				fprintf (_tmp51_, "Error: %s\n", _tmp54_);
				_g_free0 (_tmp54_);
				result = EXIT_FAILURE;
				_g_object_unref0 (_result_);
				_g_object_unref0 (e);
				_g_free0 (decimal);
				_g_free0 (tsep_string);
				_g_free0 (solve_equation);
				return result;
			}
		}
		_g_object_unref0 (_result_);
		_g_object_unref0 (e);
		_g_free0 (decimal);
		_g_free0 (tsep_string);
		_g_free0 (solve_equation);
	}
	result = -1;
	return result;
}


static void calculator_show_preferences_cb (Calculator* self) {
	MathPreferencesDialog* _tmp0_ = NULL;
	MathPreferencesDialog* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	if (_tmp0_ == NULL) {
		MathWindow* _tmp1_ = NULL;
		MathEquation* _tmp2_ = NULL;
		MathEquation* _tmp3_ = NULL;
		MathPreferencesDialog* _tmp4_ = NULL;
		MathPreferencesDialog* _tmp5_ = NULL;
		MathWindow* _tmp6_ = NULL;
		_tmp1_ = self->priv->window;
		_tmp2_ = math_window_get_equation (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = math_preferences_dialog_new (_tmp3_);
		g_object_ref_sink (_tmp4_);
		_g_object_unref0 (self->priv->preferences_dialog);
		self->priv->preferences_dialog = _tmp4_;
		_tmp5_ = self->priv->preferences_dialog;
		_tmp6_ = self->priv->window;
		gtk_window_set_transient_for ((GtkWindow*) _tmp5_, (GtkWindow*) _tmp6_);
	}
	_tmp7_ = self->priv->preferences_dialog;
	gtk_window_present ((GtkWindow*) _tmp7_);
}


static void calculator_help_cb (Calculator* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		MathWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
		_tmp0_ = self->priv->window;
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp1_, "help:gnome-calculator", _tmp2_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		gchar* message = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		GtkMessageDialog* d = NULL;
		MathWindow* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		GtkMessageDialog* _tmp7_ = NULL;
		GtkMessageDialog* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		GtkMessageDialog* _tmp11_ = NULL;
		GtkMessageDialog* _tmp12_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = _ ("Unable to open help file");
		_tmp4_ = g_strdup (_tmp3_);
		message = _tmp4_;
		_tmp5_ = self->priv->window;
		_tmp6_ = message;
		_tmp7_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp5_, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", _tmp6_);
		g_object_ref_sink (_tmp7_);
		d = _tmp7_;
		_tmp8_ = d;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		gtk_message_dialog_format_secondary_text (_tmp8_, "%s", _tmp10_);
		_tmp11_ = d;
		gtk_dialog_run ((GtkDialog*) _tmp11_);
		_tmp12_ = d;
		gtk_widget_destroy ((GtkWidget*) _tmp12_);
		_g_object_unref0 (d);
		_g_free0 (message);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void calculator_about_cb (Calculator* self) {
	gchar** authors = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar** documenters = NULL;
	gchar* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gint documenters_length1 = 0;
	gint _documenters_size_ = 0;
	gchar* translator_credits = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	MathWindow* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Rich Burridge <rich.burridge@gmail.com>");
	_tmp1_ = g_strdup ("Robert Ancell <robert.ancell@gmail.com>");
	_tmp2_ = g_strdup ("Klaus Niederkrüger <kniederk@umpa.ens-lyon.fr>");
	_tmp3_ = g_strdup ("Robin Sonefors <ozamosi@flukkost.nu>");
	_tmp4_ = g_new0 (gchar*, 5 + 1);
	_tmp4_[0] = _tmp0_;
	_tmp4_[1] = _tmp1_;
	_tmp4_[2] = _tmp2_;
	_tmp4_[3] = _tmp3_;
	_tmp4_[4] = NULL;
	authors = _tmp4_;
	authors_length1 = 5;
	_authors_size_ = authors_length1;
	_tmp5_ = g_strdup ("Sun Microsystems");
	_tmp6_ = g_new0 (gchar*, 2 + 1);
	_tmp6_[0] = _tmp5_;
	_tmp6_[1] = NULL;
	documenters = _tmp6_;
	documenters_length1 = 2;
	_documenters_size_ = documenters_length1;
	_tmp7_ = _ ("translator-credits");
	_tmp8_ = g_strdup (_tmp7_);
	translator_credits = _tmp8_;
	_tmp9_ = self->priv->window;
	_tmp10_ = _ ("Calculator");
	_tmp11_ = _ ("About Calculator");
	_tmp12_ = _ ("Calculator with financial and scientific modes.");
	gtk_show_about_dialog ((GtkWindow*) _tmp9_, "program-name", _tmp10_, "title", _tmp11_, "version", VERSION, "copyright", "\xc2\xa9 1986–2014 The Calculator authors", "license-type", GTK_LICENSE_GPL_3_0, "comments", _tmp12_, "authors", authors, "documenters", documenters, "translator_credits", translator_credits, "logo-icon-name", "accessories-calculator", NULL);
	_g_free0 (translator_credits);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}


static void calculator_quit_cb (Calculator* self) {
	MathWindow* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


gint calculator_main (gchar** args, int args_length1) {
	gint result = 0;
	GDateTime* now = NULL;
	GDateTime* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	Calculator* app = NULL;
	Calculator* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gint _tmp7_ = 0;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = g_date_time_new_now_utc ();
	now = _tmp0_;
	_tmp1_ = g_date_time_get_microsecond (now);
	g_random_set_seed ((guint32) _tmp1_);
	_tmp2_ = args;
	_tmp2__length1 = args_length1;
	_tmp3_ = _tmp2_[0];
	_tmp4_ = g_path_get_basename (_tmp3_);
	_g_free0 (calculator_program_name);
	calculator_program_name = _tmp4_;
	gtk_window_set_default_icon_name ("accessories-calculator");
	_tmp5_ = calculator_new ();
	app = _tmp5_;
	_tmp6_ = args;
	_tmp6__length1 = args_length1;
	_tmp7_ = g_application_run ((GApplication*) app, _tmp6__length1, _tmp6_);
	result = _tmp7_;
	_g_object_unref0 (app);
	_g_date_time_unref0 (now);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return calculator_main (argv, argc);
}


static void calculator_class_init (CalculatorClass * klass) {
	calculator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CalculatorPrivate));
	((GApplicationClass *) klass)->startup = calculator_real_startup;
	((GApplicationClass *) klass)->activate = calculator_real_activate;
	((GApplicationClass *) klass)->shutdown = calculator_real_shutdown;
	((GApplicationClass *) klass)->handle_local_options = calculator_real_handle_local_options;
	G_OBJECT_CLASS (klass)->finalize = calculator_finalize;
}


static void calculator_instance_init (Calculator * self) {
	self->priv = CALCULATOR_GET_PRIVATE (self);
}


static void calculator_finalize (GObject* obj) {
	Calculator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CALCULATOR, Calculator);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->preferences_dialog);
	G_OBJECT_CLASS (calculator_parent_class)->finalize (obj);
}


GType calculator_get_type (void) {
	static volatile gsize calculator_type_id__volatile = 0;
	if (g_once_init_enter (&calculator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CalculatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) calculator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Calculator), 0, (GInstanceInitFunc) calculator_instance_init, NULL };
		GType calculator_type_id;
		calculator_type_id = g_type_register_static (gtk_application_get_type (), "Calculator", &g_define_type_info, 0);
		g_once_init_leave (&calculator_type_id__volatile, calculator_type_id);
	}
	return calculator_type_id__volatile;
}


SolveEquation* solve_equation_construct (GType object_type, const gchar* text) {
	SolveEquation * self = NULL;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = text;
	self = (SolveEquation*) equation_construct (object_type, _tmp0_);
	return self;
}


SolveEquation* solve_equation_new (const gchar* text) {
	return solve_equation_construct (TYPE_SOLVE_EQUATION, text);
}


static Number* solve_equation_real_convert (Equation* base, Number* x, const gchar* x_units, const gchar* z_units) {
	SolveEquation * self;
	Number* result = NULL;
	UnitManager* _tmp0_ = NULL;
	UnitManager* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	self = (SolveEquation*) base;
	g_return_val_if_fail (x != NULL, NULL);
	g_return_val_if_fail (x_units != NULL, NULL);
	g_return_val_if_fail (z_units != NULL, NULL);
	_tmp0_ = unit_manager_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = x;
	_tmp3_ = x_units;
	_tmp4_ = z_units;
	_tmp5_ = unit_manager_convert_by_symbol (_tmp1_, _tmp2_, _tmp3_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp1_);
	result = _tmp6_;
	return result;
}


static void solve_equation_class_init (SolveEquationClass * klass) {
	solve_equation_parent_class = g_type_class_peek_parent (klass);
	((EquationClass *) klass)->convert = solve_equation_real_convert;
}


static void solve_equation_instance_init (SolveEquation * self) {
}


GType solve_equation_get_type (void) {
	static volatile gsize solve_equation_type_id__volatile = 0;
	if (g_once_init_enter (&solve_equation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SolveEquationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) solve_equation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SolveEquation), 0, (GInstanceInitFunc) solve_equation_instance_init, NULL };
		GType solve_equation_type_id;
		solve_equation_type_id = g_type_register_static (TYPE_EQUATION, "SolveEquation", &g_define_type_info, 0);
		g_once_init_leave (&solve_equation_type_id__volatile, solve_equation_type_id);
	}
	return solve_equation_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



