/* 
 * Copyright (C) 1999 JP Rosevear
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "gnome_chess.h"
#include <gdk/gdkkeysyms.h> 
#include "disk.h"

extern GtkWidget *app;

static GnomeUIInfo *menus[MENU_SIZE];

static GnomeUIInfo file_menu[] = {

  {GNOME_APP_UI_ITEM,N_("_New Game..."),NULL,menu_new_cb,NULL,
  NULL, GNOME_APP_PIXMAP_STOCK,GNOME_STOCK_MENU_NEW,GDK_n,GDK_CONTROL_MASK,NULL},

  GNOMEUIINFO_SEPARATOR,

  {GNOME_APP_UI_ITEM,N_("_Load Game..."),NULL,menu_load_cb,NULL,
  NULL, GNOME_APP_PIXMAP_STOCK,GNOME_STOCK_MENU_OPEN,0,0,NULL},

  {GNOME_APP_UI_ITEM,N_("_Save Game..."),NULL,menu_save_cb,NULL,
  NULL, GNOME_APP_PIXMAP_STOCK,GNOME_STOCK_MENU_SAVE,0,0,NULL},

  GNOMEUIINFO_SEPARATOR,

  {GNOME_APP_UI_ITEM,N_("S_ervers..."),NULL,server_cb,NULL,
  NULL, GNOME_APP_PIXMAP_STOCK,GNOME_STOCK_MENU_BOOK_OPEN,0,0,NULL},

  GNOMEUIINFO_SEPARATOR,

  {GNOME_APP_UI_ITEM,N_("_Quit"),NULL,menu_quit_cb,NULL,
  NULL, GNOME_APP_PIXMAP_STOCK,GNOME_STOCK_MENU_QUIT,GDK_q,GDK_CONTROL_MASK,NULL},

  GNOMEUIINFO_END  
};

static GnomeUIInfo action_menu[] = 
{

  {GNOME_APP_UI_ITEM,N_("_Flag"),NULL,menu_flag_cb,NULL,
  NULL, GNOME_APP_PIXMAP_NONE,NULL,GDK_f,GDK_CONTROL_MASK,NULL},

  {GNOME_APP_UI_ITEM,N_("_Draw"),NULL,menu_draw_cb,NULL,
  NULL, GNOME_APP_PIXMAP_NONE,NULL,GDK_d,GDK_CONTROL_MASK,NULL},

  {GNOME_APP_UI_ITEM,N_("_Resign"),NULL,menu_resign_cb,NULL,
  NULL, GNOME_APP_PIXMAP_NONE,NULL,0,0,NULL},

  GNOMEUIINFO_END  
};

static GnomeUIInfo move_menu[] = 
{
  {GNOME_APP_UI_ITEM,N_("_Start"),NULL,menu_start_cb,NULL,
  NULL, GNOME_APP_PIXMAP_STOCK,GNOME_STOCK_MENU_FIRST,GDK_s, GDK_MOD1_MASK,NULL},

  {GNOME_APP_UI_ITEM,N_("_Previous"),NULL,menu_previous_cb,NULL,
  NULL, GNOME_APP_PIXMAP_STOCK,GNOME_STOCK_MENU_BACK,GDK_p, GDK_MOD1_MASK,NULL},

  {GNOME_APP_UI_ITEM,N_("_Next"),NULL,menu_next_cb,NULL,
  NULL, GNOME_APP_PIXMAP_STOCK,GNOME_STOCK_MENU_FORWARD,GDK_n,GDK_MOD1_MASK,NULL},

  {GNOME_APP_UI_ITEM,N_("_End"),NULL,menu_end_cb,NULL,
  NULL, GNOME_APP_PIXMAP_STOCK,GNOME_STOCK_MENU_LAST,GDK_e, GDK_MOD1_MASK,NULL},

  GNOMEUIINFO_SEPARATOR,

  {GNOME_APP_UI_ITEM,N_("_Take Back"),NULL,menu_takeback_cb,NULL,
  NULL, GNOME_APP_PIXMAP_STOCK,GNOME_STOCK_MENU_UNDO,GDK_t,GDK_CONTROL_MASK,NULL},

  GNOMEUIINFO_SEPARATOR,

  {GNOME_APP_UI_ITEM,N_("Move _Now"),NULL,menu_now_cb,NULL,
  NULL, GNOME_APP_PIXMAP_NONE,NULL,0,0,NULL},

  {GNOME_APP_UI_ITEM,N_("_Go"),NULL,menu_go_cb,NULL,
  NULL, GNOME_APP_PIXMAP_NONE,NULL,0,0,NULL},

  GNOMEUIINFO_END  
};

static GnomeUIInfo options_mode_items[] =
{
  {GNOME_APP_UI_ITEM,N_("Computer _White"),NULL,menu_computer_white_cb,NULL,
  NULL, GNOME_APP_PIXMAP_NONE,NULL,0,0,NULL},

  {GNOME_APP_UI_ITEM,N_("Computer _Black"),NULL,menu_computer_black_cb,NULL,
  NULL, GNOME_APP_PIXMAP_NONE,NULL,0,0,NULL},

  {GNOME_APP_UI_ITEM,N_("Two _Players"),NULL,menu_two_players_cb,NULL,
  NULL, GNOME_APP_PIXMAP_NONE,NULL,0,0,NULL},

  {GNOME_APP_UI_ITEM,N_("Two _Computers"),NULL,menu_two_machines_cb,NULL,
  NULL, GNOME_APP_PIXMAP_NONE,NULL,0,0,NULL},

  {GNOME_APP_UI_ITEM,N_("_Analyse Mode"),NULL,menu_analyse_mode_cb,NULL,
  NULL, GNOME_APP_PIXMAP_NONE,NULL,0,0,NULL},

  GNOMEUIINFO_END  
};

static GnomeUIInfo options_mode_list [] =
{

	GNOMEUIINFO_RADIOLIST((gpointer)options_mode_items),

	GNOMEUIINFO_END  
};

static GnomeUIInfo options_menu[] = 
{

  {GNOME_APP_UI_SUBTREE, N_("Mode"), N_("Mode options"), &options_mode_list},

  GNOMEUIINFO_SEPARATOR,

  {GNOME_APP_UI_ITEM,N_("_Level"),NULL,level_cb,NULL,
  NULL, GNOME_APP_PIXMAP_NONE,NULL,0,0,NULL},

  GNOMEUIINFO_SEPARATOR,

  {GNOME_APP_UI_ITEM,N_("_Preferences..."),NULL,menu_prefs_cb,NULL,
  NULL, GNOME_APP_PIXMAP_STOCK,GNOME_STOCK_MENU_PREF,0,0,NULL},

  GNOMEUIINFO_END  
};

static GnomeUIInfo help_menu[] = 
{
  GNOMEUIINFO_MENU_ABOUT_ITEM(menu_about_cb, NULL),

  GNOMEUIINFO_END  
};

static GnomeUIInfo mainmenu[] = {

	{GNOME_APP_UI_SUBTREE, N_("_File"), NULL, file_menu, NULL, NULL,
	GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},

	{GNOME_APP_UI_SUBTREE, N_("_Action"), NULL, action_menu, NULL, NULL,
	GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},

	{GNOME_APP_UI_SUBTREE, N_("_Move"), NULL, move_menu, NULL, NULL,
	GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},

	{GNOME_APP_UI_SUBTREE, N_("_Settings"), NULL, options_menu, NULL, NULL,
	GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},

	/*	GNOMEUIINFO_JUSTIFY_RIGHT , */

	{GNOME_APP_UI_SUBTREE, N_("_Help"), NULL, help_menu, NULL, NULL,
	GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},

	GNOMEUIINFO_END  
};

static GnomeUIInfo toolbar [] = {
	GNOMEUIINFO_ITEM_STOCK (N_("New"),
				N_("Start a new game"),
				menu_new_cb, GNOME_STOCK_PIXMAP_NEW),
	GNOMEUIINFO_ITEM_STOCK (N_("Open"),
				N_("Opens a game"),
				menu_load_cb, GNOME_STOCK_PIXMAP_OPEN),
	GNOMEUIINFO_ITEM_STOCK (N_("Save"),
				N_("Saves a game"),
				menu_save_cb, GNOME_STOCK_PIXMAP_SAVE),
	GNOMEUIINFO_ITEM_STOCK (N_("First"),
				N_("Go to beginning of game"),
				menu_start_cb, GNOME_STOCK_PIXMAP_FIRST),
	GNOMEUIINFO_ITEM_STOCK (N_("Previous"),
				N_("Take one move back"),
				menu_previous_cb, GNOME_STOCK_PIXMAP_BACK),
	GNOMEUIINFO_ITEM_STOCK (N_("Forward"),
				N_("Move one move forward"),
				menu_next_cb, GNOME_STOCK_PIXMAP_FORWARD),
	GNOMEUIINFO_ITEM_STOCK (N_("Last"),
				N_("Go to the end of game"),
				menu_end_cb, GNOME_STOCK_PIXMAP_LAST),

	GNOMEUIINFO_END
};

void create_menus()
{
  GtkWidget *tb;
  GnomeDockItem *item;    
                                                 
  gnome_app_create_menus (GNOME_APP(app),mainmenu);
  gnome_app_create_toolbar (GNOME_APP (app),toolbar);
 
  item = gnome_app_get_dock_item_by_name(GNOME_APP(app), GNOME_APP_TOOLBAR_NAME);             
  tb = gnome_dock_item_get_child (item);    
  gtk_toolbar_set_style (GTK_TOOLBAR (tb), GTK_TOOLBAR_ICONS);    

  menus[MENU_NEW] = &file_menu[0];
  menus[MENU_LOAD] = &file_menu[2];
  menus[MENU_SAVE] = &file_menu[3];
  menus[MENU_SERVERS] = &file_menu[5];
  menus[MENU_FLAG] = &action_menu[0];
  menus[MENU_DRAW] = &action_menu[1];
  menus[MENU_RESIGN] = &action_menu[2];
  menus[MENU_START] = &move_menu[0];
  menus[MENU_NEXT] = &move_menu[1];
  menus[MENU_PREVIOUS] = &move_menu[2];
  menus[MENU_END] = &move_menu[3];
  menus[MENU_TAKEBACK] = &move_menu[5];
  menus[MENU_NOW] = &move_menu[7];
  menus[MENU_GO] = &move_menu[8];
  menus[MENU_CWHITE] = &options_mode_items[0];
  menus[MENU_CBLACK] = &options_mode_items[1];
  menus[MENU_TWOP] = &options_mode_items[2];
  menus[MENU_TWOC] = &options_mode_items[3];
  menus[MENU_ANALYZE] = &options_mode_items[4];
  menus[MENU_LEVEL] = &options_menu[2];

}

void check_menu(gint item) {
  GTK_CHECK_MENU_ITEM(menus[item]->widget)->active = TRUE;
}

void uncheck_menu(gint item) {
  GTK_CHECK_MENU_ITEM(menus[item]->widget)->active = FALSE;
}

void uncheck_all_menus() {
	int i;

	for (i=14;i<19;i++)
		uncheck_menu(i);
}

void enable_menu(gint item) {
  GnomeUIInfo *menu;

  menu = menus[item];
  gtk_widget_set_sensitive(menu->widget, TRUE);
}

void enable_all_menus() {
	int i;

	for (i=0;i<MENU_SIZE;i++)
		enable_menu(i);
}

void disable_menu(gint item) {
  GnomeUIInfo *menu;

  menu = menus[item];
  gtk_widget_set_sensitive(menu->widget, FALSE);
}

void menu_load_cb (GtkWidget *widget, void *data) {
  load_game();
  update_board();
  return;
}

void menu_save_cb (GtkWidget *widget, void *data) {
  save_game();
  return;
}

void menu_quit_cb (GtkWidget *widget, void *data) {
  engine_destroy_all();
  gtk_main_quit ();
  return;
}

void menu_new_cb (GtkWidget *widget, void *data) {
  (first_chess_programm->menudata->menu_new_cb)(widget, data);
}

void menu_flag_cb (GtkWidget *widget, void *data) {
  (first_chess_programm->menudata->menu_flag_cb)(widget, data);
}

void menu_draw_cb (GtkWidget *widget, void *data) {
  (first_chess_programm->menudata->menu_draw_cb)(widget, data);
}

void menu_resign_cb (GtkWidget *widget, void *data) {
  (first_chess_programm->menudata->menu_resign_cb)(widget, data);
}

void menu_start_cb (GtkWidget *widget, void *data) {
  (first_chess_programm->menudata->menu_start_cb)(widget, data);
}

void menu_previous_cb (GtkWidget *widget, void *data) {
  (first_chess_programm->menudata->menu_previous_cb)(widget, data);
}

void menu_next_cb (GtkWidget *widget, void *data) {
  (first_chess_programm->menudata->menu_next_cb)(widget, data);
}

void menu_end_cb (GtkWidget *widget, void *data) {
  (first_chess_programm->menudata->menu_end_cb)(widget, data);
}

void menu_takeback_cb (GtkWidget *widget, void *data) {
  (first_chess_programm->menudata->menu_takeback_cb)(widget, data);
}

void menu_now_cb (GtkWidget *widget, void *data) {
  (first_chess_programm->menudata->menu_now_cb)(widget, data);
}

void menu_go_cb (GtkWidget *widget, void *data) {
  (first_chess_programm->menudata->menu_go_cb)(widget, data);
}

void menu_computer_white_cb (GtkWidget *widget, void *data) {
  (first_chess_programm->menudata->menu_cwhite_cb)(widget, data);
  board.mode = COMPUTER_WHITE;
}

void menu_computer_black_cb (GtkWidget *widget, void *data) {
  (first_chess_programm->menudata->menu_cblack_cb)(widget, data);
  board.mode = COMPUTER_BLACK;
}

void menu_two_players_cb (GtkWidget *widget, void *data) {
  board.mode = HUMANS;
}

void menu_two_machines_cb (GtkWidget *widget, void *data) {
  board.mode = AUTOPLAY;
}

void menu_analyse_mode_cb (GtkWidget *widget, void *data) {
  board.mode = ANALYSE;
  engine_write(first_chess_programm,"analyze\n");
}

void menu_prefs_cb (GtkWidget *widget, void *data) {
	gnomechess_prefs_dialog();
}

void menu_about_cb (GtkWidget *widget, void *data) {
  GtkWidget *about;
  const  gchar *authors[] = {
	  N_("Robert Wilhelm <robert@physiol.med.tu-muenchen.de>"),
	  N_("JP Rosevear <jpr@arcavia.com>"),
          NULL
          };

  about = gnome_about_new ( _("The Gnome Chess Program"), VERSION,
			    _("Copyright (C) 1998-1999"),
			    authors,
  		_("This  program  is  part of  the  GNOME  project. " 
	" Gnome-Chess comes with ABSOLUTELY NO WARRANTY. This is free " 
	"software, and you are welcome to redistribute it under the conditions "
	"of the GNU General Public Licence."),
			    NULL);
  gtk_widget_show (about);
  return;
}

void command_cb (GtkWidget *widget, void *data) {
	gchar *command;

	command = gtk_entry_get_text(GTK_ENTRY(board.command));
	engine_write(first_chess_programm, "%s\n", command);
    gtk_entry_set_text(GTK_ENTRY(board.command), "");
}
